<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_authz_host - Serveur Apache HTTP Version 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_authz_host</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_authz_host.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_authz_host.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Autorisations de groupe bases sur l'hte (nom ou adresse
IP)</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>authz_host_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_authz_host.c</td></tr>
<tr><th><a href="module-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis les versions 2.3 et suprieures
d'Apache</td></tr></table>
<h3>Sommaire</h3>

    <p>Les fournisseurs d'autorisation implments par le module
    <code class="module"><a href="../mod/mod_authz_host.html">mod_authz_host</a></code> sont enregistrs  l'aide de
    la directive <code class="directive"><a href="../mod/mod_authz_core.html#require">Require</a></code>. On peut
    utiliser cette directive  l'intrieur de sections <code class="directive"><a href="../mod/core.html#directory">&lt;Directory&gt;</a></code>, <code class="directive"><a href="../mod/core.html#files">&lt;Files&gt;</a></code>, ou <code class="directive"><a href="../mod/core.html#location">&lt;Location&gt;</a></code> ou de fichiers
    <code><a href="core.html#accessfilename">.htaccess</a> </code> pour
    contrler l'accs  certaines zones du serveur. Le contrle d'accs
    peut tre effectu en fonction du nom d'hte ou de l'adresse IP.</p>

    <p>En gnral, les directives de restriction d'accs s'appliquent 
    toutes les mthodes d'accs (<code>GET</code>, <code>PUT</code>,
    <code>POST</code>, etc...). C'est d'ailleurs ce que l'on souhaite
    dans la plupart des cas. Il est cependant possible de ne restreindre
    l'accs que pour certaines mthodes, tout en laissant les autres
    mthodes sans protection, en plaant les directives dans une section
    <code class="directive"><a href="../mod/core.html#limit">&lt;Limit&gt;</a></code>.</p>
</div>
<div id="quickview"><h3 class="directives">Directives</h3>
<p>Ce module ne fournit aucune directive.</p>
<h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#requiredirectives">Les directives Require</a></li>
</ul><h3>Voir aussi</h3>
<ul class="seealso">
<li><a href="../howto/auth.html">Authentification, autorisation et
contrle d'accs</a></li>
<li><code class="directive"><a href="../mod/mod_authz_core.html#require">Require</a></code></li>
</ul><ul class="seealso"><li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="requiredirectives" id="requiredirectives">Les directives Require</a></h2>

    <p>La directive Apache <code class="directive"><a href="../mod/mod_authz_core.html#require">Require</a></code> est utilise au cours de
    la phase d'autorisation pour vrifier si un utilisateur se voit
    accorder ou refuser l'accs  une ressource. mod_authz_host fournit
    les types d'autorisation <code>ip</code>, <code>host</code> et <code>local</code>. D'autres
    types d'autorisation
    sont aussi disponibles, mais ncessitent le chargement des modules
    d'autorisation appropris.</p>

    <p>Ces fournisseurs d'autorisation permettent de dterminer quels
    htes peuvent accder  une zone du serveur. On peut contrler
    l'accs en fonction du nom d'hte, de l'adresse IP, ou d'un intervalle
    d'adresses IP.</p>

    <p>A partir de la version 2.4.8, les directives require host
    supportent les <a href="../expr.html">expressions</a>.</p>

<h3><a name="reqip" id="reqip">Require ip</a></h3>

    <p>Le fournisseur <code>ip</code> permet de contrler l'accs au
    serveur en fonction de l'adresse IP du client distant. Lorsque
    <code>Require ip <var>adresse-ip</var></code> est spcifi, la
    requte est autorise si l'adresse IP du client distant correspond
    </p>

    <p>Une adresse IP complte :</p>

    <pre class="prettyprint lang-config">Require ip 10.1.2.3
Require ip 192.168.1.104 192.168.1.205</pre>


    <p>L'adresse IP d'un hte pour qui l'accs est accord</p>

    <p>Une adresse IP partielle :</p>

    <pre class="prettyprint lang-config">Require ip 10.1
Require ip 10 172.20 192.168.2</pre>

    <p>Les 1  3 premiers octets d'une adresse IP, pour une restriction
     un sous-rseau.</p>

    <p>Une paire rseau/masque de sous-rseau :</p>

    <pre class="prettyprint lang-config">Require ip 10.1.0.0/255.255.0.0</pre>

    <p>Un rseau a.b.c.d, et un masque de sous-rseau w.x.y.z. pour une
    restriction de sous-rseau plus fine.</p>

    <p>Une spcification CIDR rseau/nnn :</p>

    <pre class="prettyprint lang-config">Require ip 10.1.0.0/16</pre>

    <p>Identique au cas prcdent, except que le masque de sous-rseau
    reprsente les nnn premiers bits de poids fort.</p>

    <p>Notez que les trois derniers exemples correspondent exectement au
    mme ensemble d'htes.</p>

    <p>On peut spcifier des adresses et des sous-rseaux IPv6 comme
    suit :</p>

    <pre class="prettyprint lang-config">Require ip 2001:db8::a00:20ff:fea7:ccea
Require ip 2001:db8::a00:20ff:fea7:ccea/10</pre>


    <p>Note: comme les adresses IP sont lues au dmarrage, les
    expressions ne sont pas values au moment de la requte.</p>



<h3><a name="reqhost" id="reqhost">Require host</a></h3>

    <p>Le fournisseur <code>host</code> permet de contrler l'accs au
    serveur en fonction du nom d'hte du client distant. Lorsque
    <code>Require host <var>nom-hte</var></code> est spcifi, la
    requte est autorise si le nom d'hte correspond </p>

    <p>Un nom de domaine (ventuellement partiel)</p>

    <pre class="prettyprint lang-config">Require host example.org
Require host .net example.edu</pre>


    <p>Les htes dont les noms correspondent ou se terminent par la
    chane spcifie se voient accorder l'accs. Seuls les lment de
    nom de domaine complets sont mis en correspondance ; ainsi,
    l'exemple ci-dessus correspondra  <code>foo.example.org</code>, mais
    ne correspondra pas  <code>fooexample.org</code>. Avec cette
    configuration, Apache va effectuer une double recherche DNS sur
    l'adresse IP du client, sans tenir compte de la dfinition de la
    directive  <code class="directive"><a href="../mod/core.html#hostnamelookups">HostnameLookups</a></code>. Il
    va effectuer une recherche DNS inverse sur l'adresse IP pour trouver
    le nom d'hte associ, puis une recherche DNS directe sur le nom
    d'hte pour vrifier qu'il correspond bien  l'adresse IP originale.
    L'accs ne sera accord que si le nom d'hte correspond et si les
    recherches DNS inverse et directe sont cohrentes.</p>



<h3><a name="reqlocal" id="reqlocal">Require local</a></h3>

    <p>Le fournisseur <code>local</code> autorise l'accs au serveur si
    l'une au moins de ces conditions est satisfaite :</p>

    <ul>
        <li>l'adresse IP du client correspond  127.0.0.0/8</li>
        <li>l'adresse IP du client est ::1</li>
        <li>les adresses IP du client et du serveur sont identiques</li>
    </ul>

    <p>L'exemple suivant montre une mthode simple pour slectionner les
    connexions en provenance de l'hte local :</p>

    <pre class="prettyprint lang-config">Require local</pre>




<h3><a name="proxy" id="proxy">Note concernant la scurit</a></h3>

    <p>Si le contenu de votre serveur est mandat, vous devez garder 
    l'esprit que l'adresse client correspondra  l'adresse de votre
    serveur mandataire et non  l'adresse du client, et l'utilisation de
    la directive <code>Require</code> dans ce contexte ne provoquera pas
    forcment l'effet dsir. Voir <code class="module"><a href="../mod/mod_remoteip.html">mod_remoteip</a></code> pour
    une solution possible  ce problme.</p>
    


</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_authz_host.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_authz_host.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/mod_authz_host.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2014 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>