/***************************************************************************
                          groupbox.h - Groupbox widget 
                             -------------------
    copyright            : (C) 2002 by Marc Britton
    email                : consume@optusnet.com.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef _HAVE_GROUPBOX_H_
#define _HAVE_GROUPBOX_H_

/* KDE INCLUDES */

/* QT INCLUDES */
#include <tqgroupbox.h>
#include <tqobject.h>
#include <tqstringlist.h>
#include <tqstring.h>
#include <tqobjectlist.h>

/* OTHER INCLUDES */
#include <kommanderwidget.h>
#include <kommander_export.h>
class TQWidget;

class TQShowEvent;
class KOMMANDER_EXPORT GroupBox : public TQGroupBox, public KommanderWidget
{
  TQ_OBJECT
  

  TQ_PROPERTY(TQString populationText READ populationText WRITE setPopulationText DESIGNABLE false)
  TQ_PROPERTY(TQStringList associations READ associatedText WRITE setAssociatedText DESIGNABLE false)
  TQ_PROPERTY(bool KommanderWidget READ isKommanderWidget)
public:
  GroupBox(TQWidget *a_parent, const char *a_name);
  ~GroupBox();

  virtual bool isKommanderWidget() const;
  virtual void setAssociatedText(const TQStringList&);
  virtual TQStringList associatedText() const;
  virtual TQString currentState() const;
  virtual TQString populationText() const;
  virtual void setPopulationText(const TQString&);

  virtual void insertChild(TQObject*);
  virtual void removeChild(TQObject*);
  
  virtual TQString handleDCOP(int function, const TQStringList& args);
  virtual bool isFunctionSupported(int function);
public slots:
  virtual void populate();
signals:
  void widgetOpened();
  void widgetTextChanged(const TQString &);
  void contextMenuRequested(int xpos, int ypos);
protected:
  TQObjectList m_childList;
  void showEvent(TQShowEvent *e);
  void contextMenuEvent( TQContextMenuEvent * e );
private:
};

#endif
