/***************************************************************************
                          buttongroup.cpp - Button group widget 
                             -------------------
    copyright            : (C) 2002-2004 by Marc Britton
    email                : consume@optusnet.com.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/* KDE INCLUDES */
#include <tdelocale.h>

/* QT INCLUDES */
#include <tqobject.h>
#include <tqstring.h>
#include <tqwidget.h>
#include <tqstringlist.h>
#include <tqbuttongroup.h>
#include <tqevent.h>

/* OTHER INCLUDES */
#include <kommanderwidget.h>
#include "kommanderplugin.h"
#include <specials.h>
#include "buttongroup.h"

#include "radiobutton.h" // include a button header for the compiler with dynamic cast below

enum Functions {
  FirstFunction = 720,
  BG_selectedId,
  LastFunction
};

ButtonGroup::ButtonGroup(TQWidget *a_parent, const char *a_name)
	: TQButtonGroup(a_parent, a_name), KommanderWidget(this)
{
  TQStringList states;
  states << "checked";
  states << "unchecked";
  setStates(states);
  setDisplayStates(states);
  
  KommanderPlugin::setDefaultGroup(Group::DCOP);
  KommanderPlugin::registerFunction(BG_selectedId, "selectedId(TQString widget)", i18n("Returns the ID of the selected button."), 1);

}

ButtonGroup::~ButtonGroup()
{
}

TQString ButtonGroup::currentState() const
{
  if (!isCheckable() || isChecked())
    return "checked";
  else
    return "unchecked";
}

bool ButtonGroup::isKommanderWidget() const
{
  return true;
}

TQStringList ButtonGroup::associatedText() const
{
  return KommanderWidget::associatedText();
}

void ButtonGroup::setAssociatedText(const TQStringList& a_at)
{
  KommanderWidget::setAssociatedText(a_at);
}

void ButtonGroup::setPopulationText(const TQString& a_text)
{
  KommanderWidget::setPopulationText( a_text );
}

TQString ButtonGroup::populationText() const
{
  return KommanderWidget::populationText();
}

void ButtonGroup::populate()
{
//FIXME: implement
}

void ButtonGroup::showEvent(TQShowEvent* e)
{
  TQButtonGroup::showEvent(e);
  emit widgetOpened();
}

void ButtonGroup::contextMenuEvent( TQContextMenuEvent * e )
{
  e->accept();  
  TQPoint p = e->globalPos();
  emit contextMenuRequested(p.x(), p.y());
}

bool ButtonGroup::isFunctionSupported(int f)
{
  return f == DCOP::text || f == DCOP::checked || f == DCOP::setChecked || f == DCOP::geometry || f == DCOP::getBackgroundColor || f == DCOP::setBackgroundColor || (f >= FirstFunction && f <= LastFunction);
}
    

TQString ButtonGroup::handleDCOP(int function, const TQStringList& args) 
{
  switch (function) {
    case DCOP::text:
    {
      TQString text;
      for (int i = 0; i < count(); i++)
        if (dynamic_cast<KommanderWidget*>(find(i)))
          text += (dynamic_cast<KommanderWidget*>(find(i)))->evalAssociatedText();
      return text;
    }
    case DCOP::checked:
      return TQString::number(isChecked());
    case DCOP::setChecked:
      setCheckable(true);
      setChecked(args[0] != "false");
      break;
    case BG_selectedId:
      return TQString::number(this->selectedId() );
      break;
    case DCOP::geometry:
    {
      TQString geo = TQString::number(this->x())+" "+TQString::number(this->y())+" "+TQString::number(this->width())+" "+TQString::number(this->height());
      return geo;
      break;
    }
    case DCOP::getBackgroundColor:
      return this->paletteBackgroundColor().name();
      break;
    case DCOP::setBackgroundColor:
    {
      TQColor color;
      color.setNamedColor(args[0]);
      this->setPaletteBackgroundColor(color);
      break;
    }
    default:
      return KommanderWidget::handleDCOP(function, args);
  }
  return TQString();
}


#include "buttongroup.moc"
