%{CPP_TEMPLATE}

#include <tqdragobject.h>
#include <tqpainter.h>
#include <tqpaintdevicemetrics.h>
#include <tqdragobject.h>
#include <statusbar.h>
#include <tqtoolbutton.h>

#include <kdebug.h>
#include <tdeglobal.h>
#include <ktip.h>
#include <tdeparts/part.h>
#include <tdeparts/partmanager.h>

#include <tdeio/netaccess.h>
#include <kurl.h>
#include <kurldrag.h>
#include <kurlrequesterdlg.h>
#include <tdeconfig.h>
#include <tdeconfigdialog.h>
#include <klibloader.h>
#include <tdeaboutdata.h>
#include <tdefiledialog.h>
#include <tdeactionclasses.h>
#include <tdeglobal.h>
#include <tdelocale.h>
#include <kiconloader.h>
#include <tdeversion.h>
#include <tdemenubar.h>
#include <kstatusbar.h>
#include <kkeydialog.h>
#include <tdemessagebox.h>
#include <ktabwidget.h>
#include <kedittoolbar.h>
#include <tdeversion.h>
#include <tdestdaccel.h>
#include <tdeaction.h>
#include <kstdaction.h>

#include "settings.h"
#include "prefs.h"
#include "%{APPNAMELC}tdemdiView.h"
#include "tdemdikonsole.h"
#include "%{APPNAMELC}tdemdi.h"

%{APPNAMELC}tdemdi::%{APPNAMELC}tdemdi(KMdi::MdiMode mode)
	: KMdiMainFrm( 0, "%{APPNAMELC}", mode )
{
	resize( 800, 600 ); // start at 800x600 the first time

	setManagedDockPositionModeEnabled(true);
	setStandardMDIMenuEnabled(false);

	m_manager = new KParts::PartManager(this);
	connect(m_manager, TQ_SIGNAL(activePartChanged(KParts::Part*)),
			this, TQ_SLOT(createGUI(KParts::Part*)) );

#if KDE_IS_VERSION(3, 3, 0)
	setToolviewStyle( KMdi::TextAndIcon );
	tabWidget()->setHoverCloseButton( false );
#endif

	setMenuForSDIModeSysButtons( menuBar() );
	setManagedDockPositionModeEnabled(true); 

	m_console = NULL;

	// accept dnd
	setAcceptDrops(true);

	// then, setup our actions
	setupActions();

	//createShellGUI( true );

	// and a status bar
	statusBar()->show();

	connect( this, TQ_SIGNAL( viewActivated( KMdiChildView * ) ), this, TQ_SLOT( currentChanged( KMdiChildView * ) ) );

	m_console = new tdemdikonsole(this, "konsole");
	m_console->setIcon( SmallIcon("konsole") );
	m_console->setCaption( i18n("Terminal") );
	addToolWindow( m_console, KDockWidget::DockBottom, getMainDockWidget(), 20 );


#if KDE_IS_VERSION(3, 3, 0)
	if (Settings::showCloseTabsButton())
	{
		TQToolButton *but = new TQToolButton(tabWidget());
		but->setIconSet(SmallIcon("tab_remove"));
		but->adjustSize();
		but->hide();
		connect(but, TQ_SIGNAL(clicked()), actionCollection()->action( "file_close" ), TQ_SIGNAL(activated()));
		tabWidget()->setCornerWidget(but, TopRight);
	}
#endif

	// apply the saved mainwindow settings, if any, and ask the mainwindow
	// to automatically save settings if changed: window size, toolbar
	// position, icon size, etc.
	setAutoSaveSettings();

	// Read the dock config only if the app was started at least only once - tdemdi is tricky
        TDEConfig *cfg = new TDEConfig("%{APPNAMELC}_dockposrc");
        if (cfg->readNumEntry("%{APPNAMELC}_main_dock_settings", 0) == 1) manager()->readConfig(cfg);
        cfg->writeEntry("%{APPNAMELC}_main_dock_settings", 1);
        delete cfg;

	showTipOnStart();
}

%{APPNAMELC}tdemdi::~%{APPNAMELC}tdemdi()
{
	// Write the dock config on exit
        TDEConfig *cfg = new TDEConfig("%{APPNAMELC}_dockposrc");
        manager()->writeConfig(cfg);
        delete cfg;
	delete m_console;
}

void %{APPNAMELC}tdemdi::setupActions()
{
	setXMLFile("%{APPNAMELC}_shell.rc");

	KStdAction::openNew(this, TQ_SLOT(slotFileNew()), actionCollection());

	KStdAction::tipOfDay( this, TQ_SLOT( showTip() ), actionCollection() 
			)->setWhatsThis(i18n("This shows useful tips on the use of this application."));

	KStdAction::close(this, TQ_SLOT(slotFileClose()), actionCollection());
	KStdAction::quit(this, TQ_SLOT(slotFileQuit()), actionCollection());

	m_toolbarAction = KStdAction::showToolbar(this, TQ_SLOT(optionsShowToolbar()), actionCollection());
	m_statusbarAction = KStdAction::showStatusbar(this, TQ_SLOT(optionsShowStatusbar()), actionCollection());

	KStdAction::keyBindings(this, TQ_SLOT(optionsConfigureKeys()), actionCollection());
	KStdAction::preferences(this, TQ_SLOT(optionsPreferences()), actionCollection());

	TDEAction* action = KStdAction::configureToolbars(this, 
	         TQ_SLOT(optionsConfigureToolbars()), actionCollection());

	createGUI( NULL );
}

void %{APPNAMELC}tdemdi::showTip() 
{
	KTipDialog::showTip(this,TQString(),true);
}

void %{APPNAMELC}tdemdi::showTipOnStart()
{
	KTipDialog::showTip(this);
}

void %{APPNAMELC}tdemdi::slotFileNew()
{
	%{APPNAMELC}tdemdiView *view = new %{APPNAMELC}tdemdiView(this);
	m_manager->addPart( view->part() );

	addWindow( view );

	// add the tree view to the widget stack
	m_views += view;

	currentChanged( view );
}

void %{APPNAMELC}tdemdi::openURL(const KURL & url)
{
	// check if the url is not already opened first
	TQValueList<%{APPNAMELC}tdemdiView*>::iterator it  = m_views.begin();
	TQValueList<%{APPNAMELC}tdemdiView*>::iterator end = m_views.end();
	for (; it != end; ++it)
	{
		%{APPNAMELC}tdemdiView *view = *it;
		if (view->part()->url() == url)
		{
			activateView(view);
			return;
		}
	}

	%{APPNAMELC}tdemdiView *view = new %{APPNAMELC}tdemdiView(this);
	m_manager->addPart( view->part() );

	addWindow( view );

	m_views += view;

	view->part()->openURL(url);
	currentChanged( view );
}

void %{APPNAMELC}tdemdi::currentChanged( KMdiChildView *current )
{
	//kdWarning()<<"current view changed"<<endl;
	if (!current)
	{
		m_manager->setActivePart(NULL);
		//setCaption("()");
		return;
	}

	// switch to the corresponding document
	if ( m_views.contains( (%{APPNAMELC}tdemdiView*) current ) )
	{
		%{APPNAMELC}tdemdiView *view = (%{APPNAMELC}tdemdiView*) current;
		//view->updateCaption();
		m_manager->setActivePart( view->part() );
	}
}

void %{APPNAMELC}tdemdi::slotFileClose()
{
	requestClose( activeWindow() );
}

bool %{APPNAMELC}tdemdi::requestClose(KMdiChildView* v)
{
	//    kdWarning()<<"closing view"<<v<<endl;
	//    if (view == NULL)
	//	return;

	if (v == NULL)
	{
		if ( m_views.count() == 1)
		{
			%{APPNAMELC}tdemdiView *view = m_views[0];
			if (view->part()->queryClose())
			{
				m_manager->removePart( view->part() );

				closeWindow( view );
				m_views.clear();
				setCaption("kdissert");
				return true;
			}
			return false;
		}
		return true;
	}

	%{APPNAMELC}tdemdiView *view = (%{APPNAMELC}tdemdiView*) v;
	if ( m_views.contains( view ) )
	{
		m_views.remove( view );
		if ( view->part()->queryClose() )
		{
			m_manager->removePart( view->part() );

			closeWindow( view );
			return true;
		}
		return false;
	}
	return true;
}

void %{APPNAMELC}tdemdi::slotFileQuit()
{
	close();
}

void %{APPNAMELC}tdemdi::optionsShowToolbar()
{
	if (m_toolbarAction->isChecked())
		toolBar()->show();
	else
		toolBar()->hide();
}

void %{APPNAMELC}tdemdi::optionsShowStatusbar()
{
	if (m_statusbarAction->isChecked())
		statusBar()->show();
	else
		statusBar()->hide();
}

void %{APPNAMELC}tdemdi::optionsConfigureKeys()
{
	//KKeyDialog::configure(actionCollection());
	KKeyDialog dlg( false, this );
	TQPtrList<KXMLGUIClient> clients = guiFactory()->clients();

	for( TQPtrListIterator<KXMLGUIClient> it( clients ); it.current(); ++it )
		dlg.insert ( (*it)->actionCollection(), (*it)->instance()->aboutData()->programName() );

	dlg.configure();

	for (int i=0; i<m_views.count(); i++)
	{
		m_views[i]->part()->reloadXML();
	}
}

void %{APPNAMELC}tdemdi::optionsConfigureToolbars()
{
	//saveMainWindowSettings(TDEGlobal::config(), autoSaveGroup());
}

void %{APPNAMELC}tdemdi::newToolbarConfig()
{
	// This slot is called when user clicks "Ok" or "Apply" in the toolbar editor.
	// recreate our GUI, and re-apply the settings (e.g. "text under icons", etc.)
	//createGUI();
	//applyMainWindowSettings(TDEGlobal::config(), autoSaveGroup());
}

void %{APPNAMELC}tdemdi::optionsPreferences()
{
	// The preference dialog is derived from prefs-base.ui which is subclassed into Prefs
	//
	// compare the names of the widgets in the .ui file 
	// to the names of the variables in the .kcfg file
	if (TDEConfigDialog::showDialog("settings"))
		return;	

	TDEConfigDialog *dialog = new TDEConfigDialog(this, "settings", Settings::self(), KDialogBase::Swallow);
	dialog->addPage(new prefs(), i18n("General"), "package_settings");
	connect(dialog, TQ_SIGNAL(settingsChanged()), this, TQ_SLOT(settingsChanged()));
	dialog->show();
}

void %{APPNAMELC}tdemdi::settingsChanged()
{
	// propagate the changes to our views
	/*TQValueList<%{APPNAMELC}tdemdiView*>::iterator it  = m_views.begin();
	  TQValueList<%{APPNAMELC}tdemdiView*>::iterator end = m_views.end();
	  for (; it != end; ++it)
	  {
	  %{APPNAMELC}tdemdiView *view = *it;
	  view->settingsChanged();
	  }*/
}

void %{APPNAMELC}tdemdi::changeStatusbar(const TQString& text)
{
	// display the text on the statusbar
	statusBar()->message(text, 2000);
}

void %{APPNAMELC}tdemdi::dragEnterEvent(TQDragEnterEvent *event)
{
	// accept uri drops only
	event->accept(KURLDrag::canDecode(event));
}

void %{APPNAMELC}tdemdi::dropEvent(TQDropEvent *event)
{
	KURL::List urls;

	// see if we can decode a URI.. if not, just ignore it
	if (KURLDrag::decode(event, urls) && !urls.isEmpty())
	{
		// okay, we have a URI.. process it
		const KURL &url = urls.first();

		// load in the file
		openURL(url);
	}
}

bool %{APPNAMELC}tdemdi::queryClose()
{
	TQValueList<%{APPNAMELC}tdemdiView*>::iterator it;

	// check if we can close all documents
	for (it = m_views.begin(); it != m_views.end(); ++it)
	{
		// kdWarning()<<"searching for the part"<<endl;
		%{APPNAMELC}tdemdiView *view = *it;
		if (!view->part()->queryClose())
		{
			return false;
		}
	}

	// and now close the documents
	for (it = m_views.begin(); it != m_views.end(); ++it)
	{
		// now close all views
		%{APPNAMELC}tdemdiView *view = *it;

		m_manager->removePart( view->part() );
		closeWindow( view );
	}

	return true;
}

#include "%{APPNAMELC}tdemdi.moc"
