/*
	mtip.cpp - A tip widget
	Copyright (C) 2003  Konrad Twardowski <kdtonline@poczta.onet.pl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "miscutils.h"
#include "mtip.h"

#include <tqtooltip.h>

#include <kiconloader.h>

// public

MTip::MTip(const TipType tipType, TQWidget *parent)
	: KActiveLabel(parent, "MTip")
{
	setFrameStyle(StyledPanel | Sunken);
	setTipType(tipType);
	setTipText("");
}

MTip::~MTip()
{
}

void MTip::setTipText(const TQString &value)
{
	// valign and "center" ?
	TQString leftCell;
	if (_iconPath.isEmpty()) {
		leftCell = "";
	}
	else {
		leftCell = "<td align=\"center\" valign=\"center\">";
		leftCell += "<img src=\"" + _iconPath + "\">";
		leftCell += "</td>";
	}
	setText(MiscUtils::HTML(
		"<table border=\"0\" cellpadding=\"0\" cellspacing=\"2\">" \
			"<tr>" + leftCell + "<td>" + value + "</td></tr>" \
		"</table>"
	));
}

void MTip::setTipType(const TipType value)
{
	_type = value;
	switch (_type)
	{
		case Info:
			_iconPath = getIconPath("messagebox_info");
			setPaletteBackgroundColor(white);
			setPaletteForegroundColor(blue);
			break;
		case Normal:
			_iconPath = getIconPath("messagebox_info");
			setPaletteBackgroundColor(TQToolTip::palette().active().background());
			setPaletteForegroundColor(black);
			break;
		case Warning:
			_iconPath = getIconPath("messagebox_warning");
			setPaletteBackgroundColor(yellow);
			setPaletteForegroundColor(black);
			break;
		default:
			_iconPath = "";
	}
}

// private

TQString MTip::getIconPath(const TQString &name) const
{
	return TDEGlobal::iconLoader()->iconPath(name, TDEIcon::NoGroup, TDEIcon::SizeLarge);
}
