// SPDX-FileCopyrightText: 2025 mio <stigma@disroot.org>
//
// SPDX-License-Identifier: GPL-2.0-or-later.

#include "audioView.h"

#include <tqlayout.h>

#include <tdepopupmenu.h>
#include <tdelocale.h>

#include "analyzer.h"
#include "codeineConfig.h"

namespace Codeine
{

AudioView::AudioView(TQWidget *parent, const char *name)
    : TQFrame(parent, name)
{
    auto *layout = new TQHBoxLayout(this);
    m_analyzer = new Analyzer::Block(this);

    // We subtract one from the below to remove excess padding.
    // 36 blocks for the max/min height is arbitrary, but looks okay.
    m_analyzer->setMaximumSize((Analyzer::Block::MAX_COLUMNS / 2) * (Analyzer::Block::WIDTH + 1) - 1,
        36 * (Analyzer::Block::HEIGHT + 1) - 1);

    m_analyzer->setMinimumSize(Analyzer::Block::WIDTH * Analyzer::Block::MIN_COLUMNS,
        36 * (Analyzer::Block::HEIGHT + 1) - 1);

    layout->addWidget(m_analyzer);

    m_analyzer->setShown(config("AudioView")->readBoolEntry("showAudioAnalyzer", true));
}

AudioView::~AudioView()
{
    config("AudioView")->writeEntry("showAudioAnalyzer", m_analyzer->isVisible());
    config("AudioView")->sync();
}

void AudioView::contextMenuEvent(TQContextMenuEvent *e)
{
    TDEPopupMenu popup;

    popup.setCheckable(true);
    int id = popup.insertItem(i18n("Show Analyzer"), this, TQ_SLOT(slotToggleVisibility()));
    popup.setItemChecked(id, m_analyzer->isVisible());

    popup.exec(e->globalPos());
}

void AudioView::slotToggleVisibility()
{
    m_analyzer->setShown(!m_analyzer->isVisible());
}

}

#include "audioView.moc"
