// File autogenerated

// declaration include
#include "device1Proxy.h"

// TQt includes
#include <tqmap.h>
#include <tqstring.h>
#include <tqstringlist.h>

// TQt D-Bus includes
#include <tqdbusconnection.h>
#include <tqdbusdata.h>
#include <tqdbusdatalist.h>
#include <tqdbusdatamap.h>
#include <tqdbuserror.h>
#include <tqdbusmessage.h>
#include <tqdbusobjectpath.h>
#include <tqdbusproxy.h>
#include <tqdbusvariant.h>


namespace org
{
namespace bluez
{

Device1Proxy::Device1Proxy(const TQString& service, const TQString& path, TQObject* parent, const char* name)
    : TQObject(parent, name),
      m_baseProxy(new TQT_DBusProxy())
{
    m_baseProxy->setInterface("org.bluez.Device1");
    m_baseProxy->setPath(path);
    m_baseProxy->setService(service);

    TQObject::connect(m_baseProxy, TQ_SIGNAL(asyncReply(int, const TQT_DBusMessage&)),
                     this,        TQ_SLOT(slotHandleAsyncReply(int, const TQT_DBusMessage&)));
}

Device1Proxy::~Device1Proxy()
{
    delete m_baseProxy;
}

void Device1Proxy::setConnection(const TQT_DBusConnection& connection)
{
    m_baseProxy->setConnection(connection);
}

bool Device1Proxy::DisconnectAsync(int& asyncCallId, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;


    asyncCallId = m_baseProxy->sendWithAsyncReply("Disconnect", parameters);

    if (asyncCallId != 0) m_asyncCalls[asyncCallId] = "Disconnect";

    error = TQT_DBusError();
    return (asyncCallId != 0);
}

bool Device1Proxy::ConnectAsync(int& asyncCallId, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;


    asyncCallId = m_baseProxy->sendWithAsyncReply("Connect", parameters);

    if (asyncCallId != 0) m_asyncCalls[asyncCallId] = "Connect";

    error = TQT_DBusError();
    return (asyncCallId != 0);
}

bool Device1Proxy::ConnectProfileAsync(int& asyncCallId, const TQString& UUID, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;

    parameters << TQT_DBusData::fromString(UUID);

    asyncCallId = m_baseProxy->sendWithAsyncReply("ConnectProfile", parameters);

    if (asyncCallId != 0) m_asyncCalls[asyncCallId] = "ConnectProfile";

    error = TQT_DBusError();
    return (asyncCallId != 0);
}

bool Device1Proxy::DisconnectProfileAsync(int& asyncCallId, const TQString& UUID, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;

    parameters << TQT_DBusData::fromString(UUID);

    asyncCallId = m_baseProxy->sendWithAsyncReply("DisconnectProfile", parameters);

    if (asyncCallId != 0) m_asyncCalls[asyncCallId] = "DisconnectProfile";

    error = TQT_DBusError();
    return (asyncCallId != 0);
}

bool Device1Proxy::PairAsync(int& asyncCallId, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;


    asyncCallId = m_baseProxy->sendWithAsyncReply("Pair", parameters);

    if (asyncCallId != 0) m_asyncCalls[asyncCallId] = "Pair";

    error = TQT_DBusError();
    return (asyncCallId != 0);
}

bool Device1Proxy::CancelPairingAsync(int& asyncCallId, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;


    asyncCallId = m_baseProxy->sendWithAsyncReply("CancelPairing", parameters);

    if (asyncCallId != 0) m_asyncCalls[asyncCallId] = "CancelPairing";

    error = TQT_DBusError();
    return (asyncCallId != 0);
}

void Device1Proxy::setDBusProperty(const TQString& name, const TQT_DBusVariant& value, TQT_DBusError& error)
{
    TQT_DBusConnection connection = m_baseProxy->connection();

    TQT_DBusMessage message = TQT_DBusMessage::methodCall(m_baseProxy->service(), m_baseProxy->path(), "org.freedesktop.DBus.Properties", "Set");

    message << TQT_DBusData::fromString(m_baseProxy->interface());
    message << TQT_DBusData::fromString(name);
    message << TQT_DBusData::fromVariant(value);

    connection.sendWithReply(message, &error);
}

TQT_DBusVariant Device1Proxy::getDBusProperty(const TQString& name, TQT_DBusError& error) const
{
    TQT_DBusConnection connection = m_baseProxy->connection();

    TQT_DBusMessage message = TQT_DBusMessage::methodCall(m_baseProxy->service(), m_baseProxy->path(), "org.freedesktop.DBus.Properties", "Get");

    message << TQT_DBusData::fromString(m_baseProxy->interface());
    message << TQT_DBusData::fromString(name);

    TQT_DBusMessage reply = connection.sendWithReply(message, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return TQT_DBusVariant();
    if (reply.count() != 1) return TQT_DBusVariant();

    bool ok = false;
    TQT_DBusVariant value = reply.front().toVariant(&ok);
    if (!ok) return TQT_DBusVariant();

    return value;
}

TQString Device1Proxy::getAddress(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Address", error);

    if (error.isValid()) return TQString();

    bool ok = false;

    TQString result =  variant.value.toString(&ok);
    if (!ok) {}

    return result;
}

TQString Device1Proxy::getName(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Name", error);

    if (error.isValid()) return TQString();

    bool ok = false;

    TQString result =  variant.value.toString(&ok);
    if (!ok) {}

    return result;
}

void Device1Proxy::setAlias(const TQString& value, TQT_DBusError& error)
{
    TQT_DBusVariant variant;
    variant.value = TQT_DBusData::fromString(value);
    variant.signature = "s";

    setDBusProperty("Alias", variant, error);
}

TQString Device1Proxy::getAlias(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Alias", error);

    if (error.isValid()) return TQString();

    bool ok = false;

    TQString result =  variant.value.toString(&ok);
    if (!ok) {}

    return result;
}

TQ_UINT32 Device1Proxy::getClass(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Class", error);

    if (error.isValid()) return TQ_UINT32();

    bool ok = false;

    TQ_UINT32 result =  variant.value.toUInt32(&ok);
    if (!ok) {}

    return result;
}

TQ_UINT16 Device1Proxy::getAppearance(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Appearance", error);

    if (error.isValid()) return TQ_UINT16();

    bool ok = false;

    TQ_UINT16 result =  variant.value.toUInt16(&ok);
    if (!ok) {}

    return result;
}

TQString Device1Proxy::getIcon(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Icon", error);

    if (error.isValid()) return TQString();

    bool ok = false;

    TQString result =  variant.value.toString(&ok);
    if (!ok) {}

    return result;
}

bool Device1Proxy::getPaired(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Paired", error);

    if (error.isValid()) return bool();

    bool ok = false;

    bool result =  variant.value.toBool(&ok);
    if (!ok) {}

    return result;
}

void Device1Proxy::setTrusted(bool value, TQT_DBusError& error)
{
    TQT_DBusVariant variant;
    variant.value = TQT_DBusData::fromBool(value);
    variant.signature = "b";

    setDBusProperty("Trusted", variant, error);
}

bool Device1Proxy::getTrusted(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Trusted", error);

    if (error.isValid()) return bool();

    bool ok = false;

    bool result =  variant.value.toBool(&ok);
    if (!ok) {}

    return result;
}

void Device1Proxy::setBlocked(bool value, TQT_DBusError& error)
{
    TQT_DBusVariant variant;
    variant.value = TQT_DBusData::fromBool(value);
    variant.signature = "b";

    setDBusProperty("Blocked", variant, error);
}

bool Device1Proxy::getBlocked(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Blocked", error);

    if (error.isValid()) return bool();

    bool ok = false;

    bool result =  variant.value.toBool(&ok);
    if (!ok) {}

    return result;
}

bool Device1Proxy::getLegacyPairing(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("LegacyPairing", error);

    if (error.isValid()) return bool();

    bool ok = false;

    bool result =  variant.value.toBool(&ok);
    if (!ok) {}

    return result;
}

TQ_INT16 Device1Proxy::getRSSI(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("RSSI", error);

    if (error.isValid()) return TQ_INT16();

    bool ok = false;

    TQ_INT16 result =  variant.value.toInt16(&ok);
    if (!ok) {}

    return result;
}

bool Device1Proxy::getConnected(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Connected", error);

    if (error.isValid()) return bool();

    bool ok = false;

    bool result =  variant.value.toBool(&ok);
    if (!ok) {}

    return result;
}

TQStringList Device1Proxy::getUUIDs(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("UUIDs", error);

    if (error.isValid()) return TQStringList();

    bool ok = false;

    bool subOK = false;

    TQStringList result =  variant.value.toList(&ok).toTQStringList(&subOK);
    if (!subOK) {}
    if (!ok) {}

    return result;
}

TQString Device1Proxy::getModalias(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Modalias", error);

    if (error.isValid()) return TQString();

    bool ok = false;

    TQString result =  variant.value.toString(&ok);
    if (!ok) {}

    return result;
}

TQT_DBusObjectPath Device1Proxy::getAdapter(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Adapter", error);

    if (error.isValid()) return TQT_DBusObjectPath();

    bool ok = false;

    TQT_DBusObjectPath result =  variant.value.toObjectPath(&ok);
    if (!ok) {}

    return result;
}

TQMap< TQ_UINT16, TQT_DBusVariant > Device1Proxy::getManufacturerData(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("ManufacturerData", error);

    if (error.isValid()) return TQMap< TQ_UINT16, TQT_DBusVariant >();

    bool ok = false;

    bool subOK = false;

    TQMap< TQ_UINT16, TQT_DBusVariant > result =  variant.value.toUInt16KeyMap(&ok).toVariantMap(&subOK);
    if (!subOK) {}
    if (!ok) {}

    return result;
}

TQMap< TQString, TQT_DBusVariant > Device1Proxy::getServiceData(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("ServiceData", error);

    if (error.isValid()) return TQMap< TQString, TQT_DBusVariant >();

    bool ok = false;

    bool subOK = false;

    TQMap< TQString, TQT_DBusVariant > result =  variant.value.toStringKeyMap(&ok).toVariantMap(&subOK);
    if (!subOK) {}
    if (!ok) {}

    return result;
}

TQ_INT16 Device1Proxy::getTxPower(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("TxPower", error);

    if (error.isValid()) return TQ_INT16();

    bool ok = false;

    TQ_INT16 result =  variant.value.toInt16(&ok);
    if (!ok) {}

    return result;
}

bool Device1Proxy::getServicesResolved(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("ServicesResolved", error);

    if (error.isValid()) return bool();

    bool ok = false;

    bool result =  variant.value.toBool(&ok);
    if (!ok) {}

    return result;
}

void Device1Proxy::slotHandleAsyncReply(int asyncCallId, const TQT_DBusMessage& message)
{
    TQMap<int, TQString>::iterator findIt = m_asyncCalls.find(asyncCallId);
    if (findIt == m_asyncCalls.end()) return;

    const TQString signalName = findIt.data();
    m_asyncCalls.erase(findIt);

    if (signalName == "Disconnect")
    {
        int _asyncCallId = asyncCallId;

        if (message.type() == TQT_DBusMessage::ErrorMessage) {
            emit AsyncErrorResponseDetected(_asyncCallId, message.error());
        }


        emit DisconnectAsyncReply(_asyncCallId);
    }
    else if (signalName == "Connect")
    {
        int _asyncCallId = asyncCallId;

        if (message.type() == TQT_DBusMessage::ErrorMessage) {
            emit AsyncErrorResponseDetected(_asyncCallId, message.error());
        }


        emit ConnectAsyncReply(_asyncCallId);
    }
    else if (signalName == "ConnectProfile")
    {
        int _asyncCallId = asyncCallId;

        if (message.type() == TQT_DBusMessage::ErrorMessage) {
            emit AsyncErrorResponseDetected(_asyncCallId, message.error());
        }


        emit ConnectProfileAsyncReply(_asyncCallId);
    }
    else if (signalName == "DisconnectProfile")
    {
        int _asyncCallId = asyncCallId;

        if (message.type() == TQT_DBusMessage::ErrorMessage) {
            emit AsyncErrorResponseDetected(_asyncCallId, message.error());
        }


        emit DisconnectProfileAsyncReply(_asyncCallId);
    }
    else if (signalName == "Pair")
    {
        int _asyncCallId = asyncCallId;

        if (message.type() == TQT_DBusMessage::ErrorMessage) {
            emit AsyncErrorResponseDetected(_asyncCallId, message.error());
        }


        emit PairAsyncReply(_asyncCallId);
    }
    else if (signalName == "CancelPairing")
    {
        int _asyncCallId = asyncCallId;

        if (message.type() == TQT_DBusMessage::ErrorMessage) {
            emit AsyncErrorResponseDetected(_asyncCallId, message.error());
        }


        emit CancelPairingAsyncReply(_asyncCallId);
    }
}

}; // namespace bluez

}; // namespace org

#include "device1Proxy.moc"

// End of File

