env_with_default("QDS_AUTO_INSTALL_QUICK_DESIGNER_COMPONENTS" ENV_QDS_AUTO_INSTALL_QUICK_DESIGNER_COMPONENTS ${BUILD_DESIGNSTUDIO})
option(QDS_AUTO_INSTALL_QUICK_DESIGNER_COMPONENTS "Auto-install qtquickdesigner-components into the active Qt" ${ENV_QDS_AUTO_INSTALL_QUICK_DESIGNER_COMPONENTS})

# to avoid long file path which are problematic under windows
# it picks a short build dir under current drive temp
function(determine_dependency_build_directory out_var)
  set(dep_build_dir "${PROJECT_BINARY_DIR}/build_quickdesigner_components")
  if(WIN32)
    set(_cfg "${CMAKE_BUILD_TYPE}")
    if(NOT _cfg)
      if(CMAKE_CONFIGURATION_TYPES)
        set(_cfg "Release")
      else()
        set(_cfg "Release")
      endif()
    endif()
    # the path have to be on the same device like the Qt
    string(REGEX REPLACE "^([A-Za-z]):/.*" "\\1:" drive "${Qt6_DIR}")
    if(drive MATCHES "^[A-Za-z]:$")
      set(candidate "${drive}/_buildquickdesignercomps${_cfg}")
      if(EXISTS "${candidate}")
        file(REMOVE_RECURSE "${candidate}")
      endif()
      file(MAKE_DIRECTORY "${candidate}")
      file(
        WRITE
        "${candidate}/Readme.txt"
        "This build dir was generated by AutoInstallDesignerComponents.cmake to avoid too long build path for qtquickdesigner-components."
      )
      if(IS_DIRECTORY "${candidate}")
        file(TO_CMAKE_PATH "${candidate}" dep_build_dir)
      endif()
    endif()
  endif()
  set(${out_var} "${dep_build_dir}" PARENT_SCOPE)
endfunction()

function(auto_install_quick_designer_components)
  get_filename_component(_qtCMakeDir "${Qt6_DIR}" ABSOLUTE)
  get_filename_component(_qtLibDir   "${_qtCMakeDir}/../.." ABSOLUTE)
  get_filename_component(qtInstallPrefix "${_qtLibDir}/.." ABSOLUTE)

  set(_qqdc_cfg "${CMAKE_BUILD_TYPE}")
  if(NOT _qqdc_cfg)
    set(_qqdc_cfg "Release")
  endif()
  string(TOLOWER "${_qqdc_cfg}" _qqdc_build_type)
  set(_qqdc_sha_file "${qtInstallPrefix}/.qtquickdesigner-components.${_qqdc_build_type}.sha")
  if (EXISTS "${_qqdc_sha_file}")
    file(READ "${_qqdc_sha_file}" _qqdc_installed_sha)
    string(STRIP "${_qqdc_installed_sha}" _qqdc_installed_sha)
    message(STATUS "auto_install_qtquickdesigner_components: found existing install (SHA=${_qqdc_installed_sha}) → skip")
    if (NOT TARGET a_i_q_c)
      # Dummy-Target
      add_custom_target(a_i_q_c)
    endif()
    return()
  endif()

  include(ExternalProject)
  determine_dependency_build_directory(SHORT_BUILD_DIRECTORY)
  message(STATUS "auto_install_qtquickdesigner_components: using build dir=${SHORT_BUILD_DIRECTORY}")
  if (NOT TARGET a_i_q_c)
    set(_extra_macos_argument "")
    if(APPLE AND CMAKE_OSX_ARCHITECTURES)
      set(_extra_macos_argument "-DCMAKE_OSX_ARCHITECTURES:STRING=${CMAKE_OSX_ARCHITECTURES}")
    endif()
    ExternalProject_Add(a_i_q_c
      GIT_REPOSITORY https://codereview.qt-project.org/qt-labs/qtquickdesigner-components
      GIT_TAG        HEAD
      GIT_SHALLOW    TRUE
      SOURCE_DIR     "${SHORT_BUILD_DIRECTORY}/src"
      BINARY_DIR     "${SHORT_BUILD_DIRECTORY}"
      CMAKE_ARGS
        -DCMAKE_PREFIX_PATH=${qtInstallPrefix}
        -DCMAKE_INSTALL_PREFIX=${qtInstallPrefix}
        -DCMAKE_BUILD_TYPE=${CMAKE_BUILD_TYPE}
        ${_extra_macos_argument}
      USES_TERMINAL_DOWNLOAD TRUE
      USES_TERMINAL_CONFIGURE TRUE
      USES_TERMINAL_BUILD TRUE
      USES_TERMINAL_INSTALL TRUE
      UPDATE_DISCONNECTED TRUE
    )

    set(qdsWriteShaScript "${CMAKE_CURRENT_BINARY_DIR}/qds_write_sha.cmake")
    file(WRITE "${qdsWriteShaScript}" [=[
cmake_minimum_required(VERSION 3.16)
if(NOT DEFINED source_dir OR NOT DEFINED output_file)
  message(FATAL_ERROR "qds_write_sha.cmake: missing variables")
endif()
find_program(GIT_EXECUTABLE git)
if(NOT GIT_EXECUTABLE)
  set(sha "unknown")
else()
  execute_process(COMMAND "${GIT_EXECUTABLE}" -C "${source_dir}" rev-parse HEAD
                  OUTPUT_VARIABLE sha OUTPUT_STRIP_TRAILING_WHITESPACE ERROR_QUIET)
  if(NOT sha)
    set(sha "unknown")
  endif()
endif()
file(WRITE "${output_file}" "${sha}")
message(STATUS "qtquickdesigner-components: wrote SHA '${sha}' to '${output_file}'")
]=])

    ExternalProject_Add_Step(a_i_q_c write_sha
      DEPENDEES install
      COMMAND ${CMAKE_COMMAND}
              -Dsource_dir=<SOURCE_DIR>
              -Doutput_file=${_qqdc_sha_file}
              -P ${qdsWriteShaScript}
      USES_TERMINAL TRUE
    )
  endif() #if (NOT TARGET a_i_q_c)
endfunction()

if (QDS_AUTO_INSTALL_QUICK_DESIGNER_COMPONENTS)
  message(STATUS "auto_install_qtquickdesigner_components: enabled")

  auto_install_quick_designer_components()
else()
    message(STATUS "auto_install_qtquickdesigner_components: disabled")
endif()
