// Copyright (C) 2022 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0+ OR GPL-3.0 WITH Qt-GPL-exception-1.0

#pragma once

#include "terminalwidget.h"

#include <coreplugin/ioutputpane.h>

#include <utils/terminalhooks.h>

#include <QAction>
#include <QMenu>
#include <QTabBar>
#include <QTabWidget>
#include <QToolButton>

class QComboBox;

namespace Terminal {

class TerminalWidget;

class TabBar : public QTabBar
{
public:
    using QTabBar::QTabBar;

protected:
    void mouseReleaseEvent(QMouseEvent *event) override;
};

class TabWidget : public QTabWidget
{
public:
    TabWidget();
};

class TerminalPane : public Core::IOutputPane
{
    Q_OBJECT
public:
    TerminalPane(QObject *parent = nullptr);
    ~TerminalPane() override;

    QWidget *outputWidget(QWidget *parent) override;
    QList<QWidget *> toolBarWidgets() const override;
    void clearContents() override;
    void visibilityChanged(bool visible) override;
    void setFocus() override;
    bool hasFocus() const override;
    bool canFocus() const override;
    bool canNavigate() const override;
    bool canNext() const override;
    bool canPrevious() const override;
    void goToNext() override;
    void goToPrev() override;

    void openTerminal(const Utils::Terminal::OpenTerminalParameters &parameters);
    void addTerminal(TerminalWidget *terminal, const QString &title);

    TerminalWidget *stoppedTerminalWithId(Utils::Id identifier) const;

    void ensureVisible(TerminalWidget *terminal);

private:
    TerminalWidget *currentTerminal() const;

    void removeTab(int index);
    void setupTerminalWidget(TerminalWidget *terminal);
    void initActions();
    void createShellMenu();
    void contextMenuRequested(const QPoint &pos);

private:
    TabWidget m_tabWidget;

    QToolButton *m_newTerminalButton{nullptr};
    QToolButton *m_closeTerminalButton{nullptr};
    QToolButton *m_openSettingsButton{nullptr};
    QToolButton *m_escSettingButton{nullptr};
    QToolButton *m_lockKeyboardButton{nullptr};
    QComboBox *m_variablesComboBox{nullptr};

    QAction *m_newTerminalAction{nullptr};
    QAction *m_closeTerminalAction{nullptr};
    QAction *m_toggleKeyboardLockAction{nullptr};
    QAction *m_closeCurrentTabAction{nullptr};
    QAction *m_closeAllTabsAction{nullptr};
    QAction *m_closeOtherTabsAction{nullptr};

    QMenu m_shellMenu;

    Core::Context m_selfContext;

    bool m_widgetInitialized{false};
    bool m_isVisible{false};
};

} // namespace Terminal
