import highendivisystem 1.0
import QtQuick.Studio.Components 1.0
import QtQuick.Controls 2.15
import QtQuick.Layouts 1.11
import QtGraphicalEffects 1.0
import QtQuick3D.Effects 1.15
import QtQuick.Studio.Effects 1.0
import QtQuick.Timeline 1.0
import FlowView 1.0
import QtMultimedia 5.15
import QtQuick3D 1.15
import QtQuick 2.15
import QtQuick.VirtualKeyboard 2.1
import QtLocation 5.6
import QtPositioning 5.6

Node {
    id: snowgroup

    Snow {
        id: snow1
        opacity: 0
        scale.z: 1
        scale.y: 2.52993
        scale.x: 4.11806
        eulerRotation.z: 6.17568
        eulerRotation.y: 9.43307
        eulerRotation.x: -5.31784
    }

    Snow {
        id: snow2
        x: 12.658
        y: 16.517
        opacity: 0
        z: 223.32808
        scale.z: 1
        eulerRotation.z: 6.17568
        eulerRotation.y: 9.43307
        eulerRotation.x: -5.31784
        scale.y: 2.52993
        scale.x: 4.11806
    }

    Timeline {
        id: timeline
        animations: [
            TimelineAnimation {
                id: timelineAnimation
                running: true
                duration: 1000
                loops: 1
                to: 1000
                from: 0
            }
        ]
        endFrame: 1000
        enabled: true
        startFrame: 0
        currentFrame: rainctrl.value * 1000

        KeyframeGroup {
            target: snow1
            property: "opacity"
            Keyframe {
                frame: 1000
                value: 1
            }

            Keyframe {
                frame: 9
                value: 1
            }

            Keyframe {
                frame: 0
                value: 0
            }
        }

        KeyframeGroup {
            target: snow2
            property: "opacity"
            Keyframe {
                frame: 1000
                value: 1
            }

            Keyframe {
                frame: 462
                value: 1
            }

            Keyframe {
                frame: 74
                value: 0
            }

            Keyframe {
                frame: 0
                value: 0
            }
        }

        KeyframeGroup {
            target: snow3
            property: "opacity"
            Keyframe {
                frame: 641
                value: 1
            }

            Keyframe {
                frame: 1000
                value: 1
            }

            Keyframe {
                frame: 508
                value: 0
            }

            Keyframe {
                frame: 0
                value: 0
            }
        }

        KeyframeGroup {
            target: snow4
            property: "opacity"
            Keyframe {
                frame: 1000
                value: 1
            }

            Keyframe {
                frame: 774
                value: 1
            }

            Keyframe {
                frame: 627
                value: 0
            }

            Keyframe {
                frame: 0
                value: 0
            }
        }

        KeyframeGroup {
            target: snow5
            property: "opacity"
            Keyframe {
                frame: 1000
                value: 1
            }

            Keyframe {
                frame: 905
                value: 1
            }

            Keyframe {
                frame: 857
                value: 0
            }
        }

        KeyframeGroup {
            target: snow6
            property: "opacity"
            Keyframe {
                frame: 1000
                value: 1
            }

            Keyframe {
                frame: 950
                value: 1
            }

            Keyframe {
                frame: 878
                value: 0
            }
        }
    }

    Snow {
        id: snow3
        x: 2.783
        y: 24.741
        opacity: 0
        eulerRotation.x: -5.31784
        scale.x: 4.11806
        eulerRotation.y: 9.43307
        z: 209.987
        eulerRotation.z: 1.29252
        scale.y: 2.52993
        scale.z: 1
    }

    Snow {
        id: snow4
        x: -11.094
        y: 16.859
        opacity: 0
        scale.x: 4.11806
        eulerRotation.x: -5.31784
        eulerRotation.y: 9.43307
        z: 126.45801
        eulerRotation.z: 3.13289
        scale.y: 2.52993
        scale.z: 1
    }

    Snow {
        id: snow5
        x: -14.203
        y: 15.093
        opacity: 0
        eulerRotation.x: -5.31784
        scale.x: 4.67808
        eulerRotation.y: 9.43307
        z: 107.74252
        eulerRotation.z: -8.32325
        scale.y: 2.7625
        scale.z: 1
    }

    Snow {
        id: snow6
        x: -17.26
        y: 14.717
        opacity: 0
        scale.x: 4.70015
        eulerRotation.x: -5.31784
        eulerRotation.y: 9.43307
        z: 112.85574
        eulerRotation.z: 14.1135
        scale.y: 2.79266
        scale.z: 1
    }
}

/*##^##
Designer {
    D{i:0}D{i:1}D{i:2}D{i:6;property:"opacity";target:"snow1"}D{i:12;property:"opacity";target:"snow2"}
D{i:15;property:"opacity";target:"snow3"}D{i:17;property:"opacity";target:"snow3"}
D{i:20;property:"opacity";target:"snow4"}D{i:22;property:"opacity";target:"snow4"}
D{i:25;property:"opacity";target:"snow5"}D{i:29;property:"opacity";target:"snow6"}
D{i:3}D{i:32}D{i:33}D{i:34}D{i:35}
}
##^##*/

