import highendivisystem 1.0
import QtQuick.Studio.Components 1.0
import QtQuick.Controls 2.15
import QtQuick.Layouts 1.11
import QtGraphicalEffects 1.0
import QtQuick3D.Effects 1.15
import QtQuick.Studio.Effects 1.0
import QtQuick.Timeline 1.0
import FlowView 1.0
import QtMultimedia 5.15
import QtQuick3D 1.15
import QtQuick 2.15
import QtQuick.VirtualKeyboard 2.1
import QtLocation 5.6
import QtPositioning 5.6

Node {
    id: raingroup

    Rain {
        id: rain1
        x: 7.911
        y: 34.157
        opacity: 0
        z: -20.94177
    }

    Rain {
        id: rain2
        x: 6.503
        y: 73.684
        opacity: 0
        z: 72.72953
    }

    Timeline {
        id: timeline
        animations: [
            TimelineAnimation {
                id: timelineAnimation
                running: true
                duration: 1000
                loops: 1
                to: 1000
                from: 0
            }
        ]
        endFrame: 1000
        enabled: true
        startFrame: 0
        currentFrame: rainctrl.value * 1000

        KeyframeGroup {
            target: rain1
            property: "opacity"
            Keyframe {
                frame: 1000
                value: 1
            }

            Keyframe {
                frame: 9
                value: 1
            }

            Keyframe {
                frame: 0
                value: 0
            }
        }

        KeyframeGroup {
            target: rain2
            property: "opacity"
            Keyframe {
                frame: 1000
                value: 1
            }

            Keyframe {
                frame: 116
                value: 0
            }

            Keyframe {
                frame: 248
                value: 1
            }

            Keyframe {
                frame: 0
                value: 0
            }
        }

        KeyframeGroup {
            target: rain3
            property: "opacity"
            Keyframe {
                frame: 548
                value: 1
            }

            Keyframe {
                frame: 1000
                value: 1
            }

            Keyframe {
                frame: 328
                value: 0
            }

            Keyframe {
                frame: 0
                value: 0
            }
        }
    }

    Rain {
        id: rain3
        x: 12
        y: 51.957
        opacity: 0
        z: -8.18115
    }
}

/*##^##
Designer {
    D{i:0}D{i:15;property:"opacity";target:"rain3"}D{i:3}
}
##^##*/

