import highendivisystem 1.0
import QtQuick.Studio.Components 1.0
import QtQuick.Controls 2.15
import QtQuick.Layouts 1.11
import QtGraphicalEffects 1.0
import QtQuick3D.Effects 1.15
import QtQuick.Studio.Effects 1.0
import QtQuick.Timeline 1.0
import FlowView 1.0
import QtMultimedia 5.15
import QtQuick3D 1.15
import QtQuick 2.15
import QtQuick.VirtualKeyboard 2.1
import QtLocation 5.6
import QtPositioning 5.6


Model {
    id: doorbackright
    source: "asset_imports/Quick3DAssets/BakedCar2/meshes/door_rear_right.mesh"
    property bool isOpen: false
    eulerRotation.x: -90
    DefaultMaterial {
        id: defaultMaterial4
        opacity: 0
        diffuseColor: "#040404"
    }
    
    DefaultMaterial {
        id: cubeMaterial4

        Texture {
            id: element7
            source: "doorRR.png"
        }
        diffuseMap: element7
        emissiveFactor: 0
        emissiveColor: "#ffffff"
        specularTint: "#000000"
        specularAmount: 0.4
        diffuseColor: "#7b8f91"
    }

    Model {
        id: cube
        source: "asset_imports/Quick3DAssets/CarWindows/meshes/door_rear_right_window.mesh"
        materials: cubeMaterial
        DefaultMaterial {
            id: cubeMaterial
            specularAmount: 0
            diffuseMap: texture1
            diffuseColor: "#ffffff"

            Texture {
                id: texture1
                source: "img/rrwindow.png"
                positionV: rrwindowslider.value
            }
        }
    }
    states: [
        State {
            name: "closed"
            when: !doorbackright.isOpen
        },
        State {
            name: "open"
            when: doorbackright.isOpen

            PropertyChanges {
                target: doorbackright
                eulerRotation.y: 35
            }
        }
    ]
    transitions: Transition {
        NumberAnimation
        {
            properties: "eulerRotation.y"
            easing.type: Easing.InOutQuad
            duration: 500
        }

    }
    z: 920.00452
    materials: [cubeMaterial4, defaultMaterial4]
}



/*##^##
Designer {
    D{i:0}D{i:1;invisible:true}
}
##^##*/
