import highendivisystem 1.0
import QtQuick.Studio.Components 1.0
import QtQuick.Controls 2.15
import QtQuick.Layouts 1.11
import QtGraphicalEffects 1.0
import QtQuick3D.Effects 1.15
import QtQuick.Studio.Effects 1.0
import QtQuick.Timeline 1.0
import FlowView 1.0
import QtMultimedia 5.15
import QtQuick3D 1.15
import QtQuick 2.15
import QtQuick.VirtualKeyboard 2.1
import QtLocation 5.6
import QtPositioning 5.6


Rectangle {
    id: ac
    width: 1080
    height: 480
    color: "#1c2630"
    opacity: 1
    visible: true
    

    Image {
        id: gradientCol
        x: 0
        y: 0
        width: 1080
        rotation: 180
        height: 270
        opacity: 0.203
        anchors.bottom: parent.bottom
        source: "img/whitegradient.png"
        fillMode: Image.Stretch
        anchors.bottomMargin: 210
    }
    
    Rectangle {
        id: rectangle
        x: 0
        y: 0
        width: 1080
        height: 480
        opacity: 0.182
        color: glow.color
    }
    
    Image {
        id: gradientDark
        x: 0
        y: 224
        width: 1080
        height: 256
        anchors.bottom: parent.bottom
        anchors.bottomMargin: 0
        fillMode: Image.Stretch
        source: "img/darkgradient.png"
    }
    
    Image {
        id: gradientwhite
        x: 0
        y: 0
        width: 1080
        height: 164
        opacity: 0.182
        anchors.bottom: parent.bottom
        source: "img/whitegradient.png"
        fillMode: Image.Stretch
        rotation: 180
        anchors.bottomMargin: 316
    }
    
    Image {
        id: glowcolor
        x: 200
        y: -14
        source: "img/glow.png"
        fillMode: Image.PreserveAspectFit
    }
    
    Image {
        id: image1
        x: 0
        y: 0
        width: 1080
        height: 480
        opacity: 0.391
        source: "img/smoke-2.png"
        rotation: 180
        fillMode: Image.Stretch
    }

    Rectangle1 {
        id: rectangle1
        x: 0
        y: 0
    }

    GlowItem {
        id: glow
        x: 412
        y: 68
        color: "#f20e60"
        HeatControl {
            id: heatctrl
        }
        
        radius: 72.5
        spread: 0.24
        
        Image {
            id: image
            x: 0
            y: 0
            fillMode: Image.PreserveAspectFit
            source: "roundmask.png"
        }
    }
    
    OpacityMaskItem {
        id: opacityMask
        x: 412
        y: 68
        width: 256
        height: 256
        layer.enabled: true
        invert: false
        enabled: true
        focus: false
        visible: true
        
        //layer.effect: opacityMask
        Rectangle {
            id: heatcontrol
            x: 0
            y: 0
            width: 256
            height: 256
            color: "transparent"
            enabled: true
            visible: false
            
            ListView {
                id: listView
                x: 91
                y: 0
                anchors.rightMargin: 91
                anchors.leftMargin: 91
                snapMode: ListView.SnapToItem
                enabled: true
                anchors.fill: parent
                flickableDirection: Flickable.VerticalFlick
                boundsBehavior: Flickable.StopAtBounds
                model: Heatmodel {}
                clip: false
                delegate: Text {
                    id: heattext
                    font.pointSize: 50
                    color: "white"
                    text: name
                }
                
                Layout.fillWidth: true
                Layout.fillHeight: true
                
                ScrollBar.vertical: ScrollBar {
                    position: realscroll.position
                    width: 0
                    snapMode: ScrollBar.SnapOnRelease
                }
                onContentYChanged: {
                    listView.currentIndex = Math.round(contentY / 81) + 1
                    var currItem = listView.currentItem
                    var prevItem = listView.itemAt(currentItem.x,
                                                   currentItem.y - 81)
                    var nextItem = listView.itemAt(currentItem.x,
                                                   currentItem.y + 81)
                    
                    var perc = (40 - Math.abs(
                                    contentY + 81 - listView.currentIndex * 81)) / 40
                    currItem.scale = 1 + perc * .5
                    
                    if (prevItem)
                        prevItem.scale = 1 - perc * .25
                    
                    if (nextItem)
                        nextItem.scale = 1 - perc * .25
                }
            }
        }
        
        Image {
            id: image4
            x: 0
            y: 0
            width: 256
            height: 256
            fillMode: Image.PreserveAspectFit
            source: "img/roundmask.png"
        }
    }
    
    Rectangle {
        id: heatcontrol1
        x: 410
        y: 62
        width: 256
        height: 256
        color: "#00000000"
        opacity: 0
        visible: true
        enabled: true
        ListView {
            id: listView2
            snapMode: ListView.SnapToItem
            model: Heatmodel {}
            anchors.fill: parent
            clip: false
            Layout.fillWidth: true
            flickableDirection: Flickable.VerticalFlick
            enabled: true
            boundsBehavior: Flickable.StopAtBounds
            Layout.fillHeight: true
            delegate: Text {
                id: delitem
                color: "#ffffff"
                text: name
                font.pointSize: 50
            }
            ScrollBar.vertical: ScrollBar {
                id: realscroll
                width: 0
                snapMode: ScrollBar.SnapOnRelease
            }
            //onMovementEnded: testelement.text = 32 - (realscroll.position * 20).toFixed()
            //onMovingVerticallyChanged: print(listView2.contentY)
        }
    }
    
    Text {
        id: testelement
        x: 218
        y: 155
        width: 146
        height: 92
        color: "#ffffff"
        text: ""
        font.pixelSize: 50
    }
    function decreaseTemp(){
        if(realscroll.position < 0.81){
            realscroll.position += 0.05
        }
    }
    PushButton {
        id: minusButton
        x: 368
        y: 170
        graphicpressedSource: "img/minusP.png"
        graphicSource: "img/minus.png"
        onPressed: decreaseTemp()
    }
    function increaseTemp(){
        if(realscroll.position >= 0.05){
            realscroll.position -= 0.05
        }
    }
    PushButton {
        id: plusButton
        x: 628
        y: 170
        graphicpressedSource: "img/plusH.png"
        graphicSource: "img/plus.png"
        onPressed: increaseTemp()
    }
    
    ToggleSwitch {
        id: toggleSwitch6
        x: 283
        y: 170
        graphicpressedSource: "img/snowP.png"
        graphicSource: "img/snow.png"
    }
    
    Rectangle {
        id: leftSeatWarmer
        x: 26
        y: 104
        width: 168
        height: 200
        color: "#00ffffff"
        
        ToggleSwitch {
            id: toggleSwitch
            x: 0
            y: 0
            graphicSource: "img/seattop.png"
            graphicpressedSource: "img/seattopH.png"
        }
        
        ToggleSwitch {
            id: toggleSwitch1
            x: 0
            y: 105
            graphicpressedSource: "img/seatbottomH.png"
            graphicSource: "img/seatbottom.png"
        }
        
        ToggleSwitch {
            id: toggleSwitch5
            x: 87
            y: 60
            graphicpressedSource: "img/snowP.png"
            graphicSource: "img/snow.png"
        }
    }
    
    Rectangle {
        id: rightSeatWarmer
        x: 886
        y: 104
        width: 168
        height: 200
        opacity: 1
        color: "#00ffffff"
        
        ToggleSwitch {
            id: toggleSwitch2
            x: 74
            y: 0
            graphicpressedMirror: true
            graphicMirror: true
            graphicSource: "img/seattop.png"
            graphicpressedSource: "img/seattopH.png"
        }
        
        ToggleSwitch {
            id: toggleSwitch3
            x: 74
            y: 105
            graphicpressedSource: "img/seatbottomH.png"
            graphicMirror: true
            graphicSource: "img/seatbottom.png"
            graphicpressedMirror: true
        }
        
        ToggleSwitch {
            id: toggleSwitch4
            x: 0
            y: 60
            graphicpressedSource: "img/snowP.png"
            graphicMirror: false
            graphicSource: "img/snow.png"
            graphicpressedMirror: false
        }
    }
    

    ToggleSwitch {
        id: toggleSwitch7
        x: 715
        y: 170
        graphicpressedSource: "img/windshieldmaxH.png"
        graphicSource: "img/windshieldmax.png"
    }
    
    ToggleSwitch {
        id: toggleSwitch8
        x: 493
        y: 351
        graphicpressedSource: "img/actoggleP.png"
        graphicSource: "img/actoggle.png"
    }
    
    Blower {
        id: blower
        x: 352
        y: 330
    }

    ToggleSwitch {
        id: toggleSwitch9
        x: 614
        y: 330
        graphicpressedSource: "img/inflowP.png"
        graphicSource: "img/inflow.png"
    }

    Timeline {
        id: timeline
        animations: [
            TimelineAnimation {
                id: timelineAnimation
                duration: 10000
                loops: 1
                running: true
                to: 10000
                from: 0
            }
        ]
        enabled: true
        startFrame: 0
        endFrame: 10000
        currentFrame: 10000 * realscroll.position

        KeyframeGroup {
            target: glow
            property: "color"
            Keyframe {
                value: "#0e66f2"
                frame: 10002
            }

            Keyframe {
                value: "#f20e60"
                frame: 0
            }
        }
    }



}

/*##^##
Designer {
    D{i:0;height:480;width:1080}D{i:39}
}
##^##*/
