import QtQuick
import QtQuick3D
import Generated.QtQuick3D.Cables 1.0
import Generated.QtQuick3D.Batterylines 1.0
Node {
    id: rootNode
    property real charge: 0
    Model {
        id: chargerLine
        x: -140.003
        y: 52.8871
        z: -138.411
        scale.x: 2.81262
        scale.y: 2.81262
        scale.z: 2.81262
        source: "meshes/chargerLine.mesh"

        DefaultMaterial {
            id: aluminium_material
            diffuseColor: "#312d37"
        }
        materials: [
            aluminium_material
        ]
    }
    Model {
        id: chargerBody
        x: -167.261
        y: -24.0961
        z: -138.256
        rotation: Qt.quaternion(0.707107, -0.707107, 0, 0)
        scale.x: 0.0259211
        scale.y: 0.0259211
        scale.z: 0.0259211
        source: "meshes/chargerBody.mesh"

        DefaultMaterial {
            id: black_paint_material
            specularAmount: 1
            diffuseColor: "#2a2a2a"
        }
        materials: [
            black_paint_material,
            aluminium_material
        ]
    }
    Model {
        id: charger
        x: -118.402
        y: 78.5045
        z: -208.34
        rotation: Qt.quaternion(-0.358569, 0.513947, 0.454116, 0.633297)
        scale.x: 0.0331995
        scale.y: 0.0331995
        scale.z: 0.0331995
        source: "meshes/charger.mesh"

        DefaultMaterial {
            id: white_plastick_material
            diffuseColor: "#ffc0c0c0"
        }
        materials: [
            white_plastick_material,
            aluminium_material
        ]
    }
    Model {
        id: chargerPole
        x: -185.464
        y: -44.2512
        z: -138.428
        rotation: Qt.quaternion(0.5, -0.5, 0.5, 0.5)
        scale.x: 2.81262
        scale.y: 2.81262
        scale.z: 2.81262
        source: "meshes/chargerPole.mesh"

        DefaultMaterial {
            id: bodypaint_material
            diffuseColor: "#3e3c43"
        }
        materials: [
            bodypaint_material
        ]
    }
    Batterylines {
        id: batterylines
        x: 3.525
        y: -3.083
        visible: true
        chargeVal: rootNode.charge
        z: 0.46289
    }

    Model {
        id: battery
        scale.x: 100
        scale.y: 100
        scale.z: 100
        source: "meshes/battery.mesh"
        eulerRotation.z: 179.99995
        eulerRotation.y: -179.99995
        eulerRotation.x: -90
        materials: customMaterial

        CustomMaterial {
            id: customMaterial
            property real chargeValue: rootNode.charge
            property color base: "#a0609d"
            property color charge: "#25192c"
            cullMode: Material.NoCulling
            shadingMode: CustomMaterial.Shaded
            depthDrawMode: Material.OpaqueOnlyDepthDraw
            alwaysDirty: true
            destinationBlend: CustomMaterial.NoBlend
            vertexShader: "../../../Outrun_ClusterContent/charger.vert"
            fragmentShader: "../../../Outrun_ClusterContent/charger.frag"
        }
    }
    Model {
        id: engineElectronics_Front
        rotation: Qt.quaternion(0.707107, -0.707107, 0, 0)
        scale.x: 100
        scale.y: 100
        scale.z: 100
        source: "meshes/engineElectronics_Front.mesh"
        materials: [
            black_paint_material,
            aluminium_material
        ]
    }
    Cables {
        id: cables
        x: -0
        y: -2.522
        z: 0
    }
    Model {
        id: engineElectronics_back
        rotation: Qt.quaternion(0.707107, -0.707107, 0, 0)
        scale.x: 100
        scale.y: 100
        scale.z: 100
        source: "meshes/engineElectronics_back.mesh"
        materials: [blue,black_paint_material]

        DefaultMaterial {
            id: blue
            specularAmount: 1
            diffuseColor: "#62487e"
        }

        DefaultMaterial {
            id: defaultMaterial1
            diffuseColor: "#4aee45"
        }
    }
    Model {
        id: engineElectronicsFront2
        rotation: Qt.quaternion(0.707107, -0.707107, 0, 0)
        scale.x: 100
        scale.y: 100
        scale.z: 100
        source: "meshes/engineElectronicsFront2.mesh"
        materials: [
            aluminium_material
        ]
    }
    Model {
        id: engineAxle_Front
        rotation: Qt.quaternion(0.707107, -0.707107, 0, 0)
        scale.x: 100
        scale.y: 100
        scale.z: 100
        source: "meshes/engineAxle_Front.mesh"

        DefaultMaterial {
            id: brake_discs_material
            diffuseColor: "#ff847659"
        }
        materials: [
            brake_discs_material,
            black_paint_material,
            aluminium_material
        ]
    }
    Model {
        id: engineAxle_back
        rotation: Qt.quaternion(0.707107, -0.707107, 0, 0)
        scale.x: 100
        scale.y: 100
        scale.z: 100
        source: "meshes/engineAxle_back.mesh"
        materials: [
            brake_discs_material,
            black_paint_material,
            aluminium_material
        ]
    }


}
