untrusted comment: verify with openbsd-77-base.pub
RWSbCCUoGpcxVUooOgxxdZSBq6xH1+OSj+qGvJrL2Ogu3a5a+s62rxZmul+Gxejyien4fP1Du4Mwv7Yppe4v78T/CWM6X17WxAQ=

OpenBSD 7.7 errata 006, June 17, 2025:

Multiple X11 server issues.  
CVE-2025-49175 CVE-2025-49176 CVE-2025-49177 CVE-2025-49178
CVE-2025-49179 CVE-2025-49180

Apply by doing:
    signify -Vep /etc/signify/openbsd-77-base.pub -x 006_xserver.patch.sig \
        -m - | (cd /usr/xenocara && patch -p0)

And then rebuild and install the X server:
    cd /usr/xenocara/xserver
    make -f Makefile.bsd-wrapper obj
    make -f Makefile.bsd-wrapper build

Index: xserver/dix/dispatch.c
===================================================================
RCS file: /cvs/xenocara/xserver/dix/dispatch.c,v
diff -u -p -r1.24 dispatch.c
--- xserver/dix/dispatch.c	25 Feb 2025 15:52:12 -0000	1.24
+++ xserver/dix/dispatch.c	3 Jun 2025 13:18:01 -0000
@@ -518,9 +518,10 @@ Dispatch(void)
 
                 /* now, finally, deal with client requests */
                 result = ReadRequestFromClient(client);
-                if (result <= 0) {
-                    if (result < 0)
-                        CloseDownClient(client);
+                if (result == 0)
+                    break;
+                else if (result == -1) {
+                    CloseDownClient(client);
                     break;
                 }
 
@@ -541,7 +542,7 @@ Dispatch(void)
                                           client->index,
                                           client->requestBuffer);
 #endif
-                if (result > (maxBigRequestSize << 2))
+                if (result < 0 || result > (maxBigRequestSize << 2))
                     result = BadLength;
                 else {
                     result = XaceHookDispatch(client, client->majorOp);
Index: xserver/hw/xfree86/modes/xf86RandR12.c
===================================================================
RCS file: /cvs/xenocara/xserver/hw/xfree86/modes/xf86RandR12.c,v
diff -u -p -r1.22 xf86RandR12.c
--- xserver/hw/xfree86/modes/xf86RandR12.c	11 Nov 2021 09:03:08 -0000	1.22
+++ xserver/hw/xfree86/modes/xf86RandR12.c	3 Jun 2025 13:18:02 -0000
@@ -2149,7 +2149,8 @@ xf86RandR14ProviderSetProperty(ScreenPtr
     /* If we don't have any property handler, then we don't care what the
      * user is setting properties to.
      */
-    if (config->provider_funcs->set_property == NULL)
+    if (config->provider_funcs == NULL ||
+        config->provider_funcs->set_property == NULL)
         return TRUE;
 
     /*
@@ -2167,7 +2168,8 @@ xf86RandR14ProviderGetProperty(ScreenPtr
     ScrnInfoPtr pScrn = xf86ScreenToScrn(pScreen);
     xf86CrtcConfigPtr config = XF86_CRTC_CONFIG_PTR(pScrn);
 
-    if (config->provider_funcs->get_property == NULL)
+    if (config->provider_funcs == NULL ||
+        config->provider_funcs->get_property == NULL)
         return TRUE;
 
     /* Should be safe even w/o vtSema */
Index: xserver/os/io.c
===================================================================
RCS file: /cvs/xenocara/xserver/os/io.c,v
diff -u -p -r1.19 io.c
--- xserver/os/io.c	11 Nov 2021 09:03:14 -0000	1.19
+++ xserver/os/io.c	3 Jun 2025 13:18:03 -0000
@@ -296,6 +296,10 @@ ReadRequestFromClient(ClientPtr client)
                 needed = get_big_req_len(request, client);
         }
         client->req_len = needed;
+        if (needed > MAXINT >> 2) {
+            /* Check for potential integer overflow */
+            return -(BadLength);
+        }
         needed <<= 2;           /* needed is in bytes now */
     }
     if (gotnow < needed) {
@@ -438,7 +442,7 @@ ReadRequestFromClient(ClientPtr client)
      */
 
     gotnow -= needed;
-    if (!gotnow)
+    if (!gotnow && !oci->ignoreBytes)
         AvailableInput = oc;
     if (move_header) {
         if (client->req_len < bytes_to_int32(sizeof(xBigReq) - sizeof(xReq))) {
Index: xserver/randr/rrproviderproperty.c
===================================================================
RCS file: /cvs/xenocara/xserver/randr/rrproviderproperty.c,v
diff -u -p -r1.4 rrproviderproperty.c
--- xserver/randr/rrproviderproperty.c	13 Dec 2023 06:21:57 -0000	1.4
+++ xserver/randr/rrproviderproperty.c	3 Jun 2025 13:18:03 -0000
@@ -179,7 +179,8 @@ RRChangeProviderProperty(RRProviderPtr p
 
     if (mode == PropModeReplace || len > 0) {
         void *new_data = NULL, *old_data = NULL;
-
+        if (total_len > MAXINT / size_in_bytes)
+            return BadValue;
         total_size = total_len * size_in_bytes;
         new_value.data = (void *) malloc(total_size);
         if (!new_value.data && total_size) {
Index: xserver/record/record.c
===================================================================
RCS file: /cvs/xenocara/xserver/record/record.c,v
diff -u -p -r1.23 record.c
--- xserver/record/record.c	14 Dec 2021 13:41:00 -0000	1.23
+++ xserver/record/record.c	3 Jun 2025 13:18:03 -0000
@@ -45,6 +45,7 @@ and Jim Haggerty of Metheus.
 #include "inputstr.h"
 #include "eventconvert.h"
 #include "scrnintstr.h"
+#include "opaque.h"
 
 #include <stdio.h>
 #include <assert.h>
@@ -1297,6 +1298,13 @@ RecordSanityCheckRegisterClients(RecordC
     xRecordRange *pRange;
     int i;
     XID recordingClient;
+
+    /* LimitClients is 2048 at max, way less that MAXINT */
+    if (stuff->nClients > LimitClients)
+        return BadValue;
+
+    if (stuff->nRanges > (MAXINT - 4 * stuff->nClients) / SIZEOF(xRecordRange))
+        return BadValue;
 
     if (((client->req_len << 2) - SIZEOF(xRecordRegisterClientsReq)) !=
         4 * stuff->nClients + SIZEOF(xRecordRange) * stuff->nRanges)
Index: xserver/render/animcur.c
===================================================================
RCS file: /cvs/xenocara/xserver/render/animcur.c,v
diff -u -p -r1.16 animcur.c
--- xserver/render/animcur.c	27 Jul 2019 07:57:25 -0000	1.16
+++ xserver/render/animcur.c	3 Jun 2025 13:18:03 -0000
@@ -304,6 +304,9 @@ AnimCursorCreate(CursorPtr *cursors, CAR
     int rc = BadAlloc, i;
     AnimCurPtr ac;
 
+    if (ncursor <= 0)
+        return BadValue;
+
     for (i = 0; i < screenInfo.numScreens; i++)
         if (!GetAnimCurScreen(screenInfo.screens[i]))
             return BadImplementation;
Index: xserver/render/render.c
===================================================================
RCS file: /cvs/xenocara/xserver/render/render.c,v
diff -u -p -r1.27 render.c
--- xserver/render/render.c	3 Apr 2024 16:27:34 -0000	1.27
+++ xserver/render/render.c	3 Jun 2025 13:18:03 -0000
@@ -1795,6 +1795,8 @@ ProcRenderCreateAnimCursor(ClientPtr cli
     ncursor =
         (client->req_len -
          (bytes_to_int32(sizeof(xRenderCreateAnimCursorReq)))) >> 1;
+    if (ncursor <= 0)
+        return BadValue;
     cursors = xallocarray(ncursor, sizeof(CursorPtr) + sizeof(CARD32));
     if (!cursors)
         return BadAlloc;
Index: xserver/xfixes/disconnect.c
===================================================================
RCS file: /cvs/xenocara/xserver/xfixes/disconnect.c,v
diff -u -p -r1.1 disconnect.c
--- xserver/xfixes/disconnect.c	11 Nov 2021 09:03:15 -0000	1.1
+++ xserver/xfixes/disconnect.c	3 Jun 2025 13:18:03 -0000
@@ -67,6 +67,7 @@ ProcXFixesSetClientDisconnectMode(Client
     ClientDisconnectPtr pDisconnect = GetClientDisconnect(client);
 
     REQUEST(xXFixesSetClientDisconnectModeReq);
+    REQUEST_SIZE_MATCH(xXFixesSetClientDisconnectModeReq);
 
     pDisconnect->disconnect_mode = stuff->disconnect_mode;
 
@@ -80,7 +81,7 @@ SProcXFixesSetClientDisconnectMode(Clien
 
     swaps(&stuff->length);
 
-    REQUEST_AT_LEAST_SIZE(xXFixesSetClientDisconnectModeReq);
+    REQUEST_SIZE_MATCH(xXFixesSetClientDisconnectModeReq);
 
     swapl(&stuff->disconnect_mode);
 
