; -*- coding: iso-2022-7bit  -*-
;;; u-cns-3.el --- tables between UCS and CNS 11643:1992 plane 3

;; Copyright (c) 1991-1994 Unicode, Inc.
;; Copyright (C) 1998 Koichi Yasuoka.
;; Copyright (C) 1998 MORIOKA Tomohiko.

;; Author: MORIOKA Tomohiko <morioka@jaist.ac.jp>

;; Keywords: CCL, mule, multilingual, character set, coding-system,
;;                ISO/IEC 10646, Unicode 2.0, CNS 11643:1992

;; This file is part of Mule-UCS.

;;; Commentary:

;; This program was originally based on "Uni2CNS.Z" by Koichi Yasuoka
;; <yasuoka@kudpc.kyoto-u.ac.jp>, and checked and translated to Emacs
;; Lisp by MORIOKA Tomohiko.

;; "Uni2CNS.Z" was originally based on "CJKXRef.text" by John
;; H. Jenkins <John_Jenkins@taligent.com>.  Here the author expresses
;; his appreciation to Ken Lunde <lunde@mv.us.adobe.com>, Christian
;; Wittern <cwittern@conline.central.de>, and Jack Halpern
;; <jhalpern@super.win.or.jp>.

;;; Code:

(put 'chinese-cns11643-3 'unicode-assoc
     'cns11643-3-vs-unicode-assoc)

(defvar cns11643-3-vs-unicode-assoc
  `(assoc
    (char-1 . ucs-generic)
    ,(transformate-list-structure
      (identity . c-notated-string-to-number)
      ((?$(I!!(B . "0x4E28") ; <CJK>
       (?$(I!"(B . "0x4E36") ; <CJK>
       (?$(I!#(B . "0x4E3F") ; <CJK>
       (?$(I!$(B . "0x4E85") ; <CJK>
       (?$(I!%(B . "0x4E05") ; <CJK>
       (?$(I!&(B . "0x4E04") ; <CJK>
       (?$(I!'(B . "0x5182") ; <CJK>
       (?$(I!((B . "0x5196") ; <CJK>
       (?$(I!)(B . "0x5338") ; <CJK>
       (?$(I!*(B . "0x5369") ; <CJK>
       (?$(I!+(B . "0x53B6") ; <CJK>
       (?$(I!,(B . "0x4E2A") ; <CJK>
       (?$(I!-(B . "0x4E87") ; <CJK>
       (?$(I!.(B . "0x4E49") ; <CJK>
       (?$(I!/(B . "0x51E2") ; <CJK>
       (?$(I!0(B . "0x4E46") ; <CJK>
       (?$(I!1(B . "0x4E8F") ; <CJK>
       (?$(I!2(B . "0x4EBC") ; <CJK>
       (?$(I!3(B . "0x4EBE") ; <CJK>
       (?$(I!4(B . "0x5166") ; <CJK>
       (?$(I!5(B . "0x51E3") ; <CJK>
       (?$(I!6(B . "0x5204") ; <CJK>
       (?$(I!7(B . "0x529C") ; <CJK>
       (?$(I!8(B . "0x5344") ; <CJK>
       (?$(I!9(B . "0x5902") ; <CJK>
       (?$(I!:(B . "0x590A") ; <CJK>
       (?$(I!;(B . "0x5B80") ; <CJK>
       (?$(I!<(B . "0x5DDB") ; <CJK>
       (?$(I!=(B . "0x5E7A") ; <CJK>
       (?$(I!>(B . "0x5E7F") ; <CJK>
       (?$(I!?(B . "0x5EF4") ; <CJK>
       (?$(I!@(B . "0x5F50") ; <CJK>
       (?$(I!A(B . "0x5F51") ; <CJK>
       (?$(I!B(B . "0x5F61") ; <CJK>
       (?$(I!C(B . "0x961D") ; <CJK>
       (?$(I!D(B . "0x2000B") ; <CJK>
       (?$(I!E(B . "0x4E63") ; <CJK>
       (?$(I!F(B . "0x4E62") ; <CJK>
       (?$(I!G(B . "0x4EA3") ; <CJK>
       (?$(I!H(B . "0x5185") ; <CJK>
       (?$(I!I(B . "0x4EC5") ; <CJK>
       (?$(I!J(B . "0x4ECF") ; <CJK>
       (?$(I!K(B . "0x4ECE") ; <CJK>
       (?$(I!L(B . "0x4ECC") ; <CJK>
       (?$(I!M(B . "0x5184") ; <CJK>
       (?$(I!N(B . "0x5186") ; <CJK>
       (?$(I!O(B . "0x2F817") ; <CJK>
       (?$(I!P(B . "0x34C5") ; <CJK>
       (?$(I!Q(B . "0x51E4") ; <CJK>
       (?$(I!R(B . "0x5205") ; <CJK>
       (?$(I!S(B . "0x529E") ; <CJK>
       (?$(I!T(B . "0x529D") ; <CJK>
       (?$(I!U(B . "0x52FD") ; <CJK>
       (?$(I!V(B . "0x5300") ; <CJK>
       (?$(I!W(B . "0x533A") ; <CJK>
       (?$(I!X(B . "0x3539") ; <CJK>
       (?$(I!Y(B . "0x5346") ; <CJK>
       (?$(I!Z(B . "0x535D") ; <CJK>
       (?$(I![(B . "0x5386") ; <CJK>
       (?$(I!\(B . "0x53B7") ; <CJK>
       (?$(I!](B . "0x3555") ; <CJK>
       (?$(I!^(B . "0x53CC") ; <CJK>
       (?$(I!_(B . "0x355B") ; <CJK>
       (?$(I!`(B . "0x53CE") ; <CJK>
       (?$(I!a(B . "0x5721") ; <CJK>
       (?$(I!b(B . "0x37A2") ; <CJK>
       (?$(I!c(B . "0x5E00") ; <CJK>
       (?$(I!d(B . "0x5F0C") ; <CJK>
       (?$(I!e(B . "0x6237") ; <CJK>
       (?$(I!f(B . "0x6238") ; <CJK>
       (?$(I!g(B . "0x6534") ; <CJK>
       (?$(I!h(B . "0x6535") ; <CJK>
       (?$(I!i(B . "0x65E0") ; <CJK>
       (?$(I!j(B . "0x3E26") ; <CJK>
       (?$(I!k(B . "0x738D") ; <CJK>
       (?$(I!l(B . "0x4E97") ; <CJK>
       (?$(I!m(B . "0x4EE0") ; <CJK>
       (?$(I!n(B . "0x3432") ; <CJK>
       (?$(I!o(B . "0x201A9") ; <CJK>
       (?$(I!p(B . "0x4EE7") ; <CJK>
       (?$(I!q(B . "0x3433") ; <CJK>
       (?$(I!r(B . "0x4EE6") ; <CJK>
       (?$(I!s(B . "0x3434") ; <CJK>
       (?$(I!t(B . "0x36A2") ; <CJK>
       (?$(I!u(B . "0x3431") ; <CJK>
       (?$(I!v(B . "0x34B0") ; <CJK>
       (?$(I!w(B . "0x56D8") ; <CJK>
       (?$(I!x(B . "0x518B") ; <CJK>
       (?$(I!y(B . "0x518C") ; <CJK>
       (?$(I!z(B . "0x5199") ; <CJK>
       (?$(I!{(B . "0x51E5") ; <CJK>
       (?$(I!|(B . "0x2F850") ; <CJK>
       (?$(I!}(B . "0x520B") ; <CJK>
       (?$(I!~(B . "0x34DC") ; <CJK>
       (?$(I"!(B . "0x361E") ; <CJK>
       (?$(I""(B . "0x5304") ; <CJK>
       (?$(I"#(B . "0x5303") ; <CJK>
       (?$(I"$(B . "0x5307") ; <CJK>
       (?$(I"%(B . "0x2F82A") ; <CJK>
       (?$(I"&(B . "0x531E") ; <CJK>
       (?$(I"'(B . "0x535F") ; <CJK>
       (?$(I"((B . "0x536D") ; <CJK>
       (?$(I")(B . "0x5389") ; <CJK>
       (?$(I"*(B . "0x53BA") ; <CJK>
       (?$(I"+(B . "0x53D0") ; <CJK>
       (?$(I",(B . "0x3565") ; <CJK>
       (?$(I"-(B . "0x53F6") ; <CJK>
       (?$(I".(B . "0x53F7") ; <CJK>
       (?$(I"/(B . "0x53F9") ; <CJK>
       (?$(I"0(B . "0x3564") ; <CJK>
       (?$(I"1(B . "0x53F4") ; <CJK>
       (?$(I"2(B . "0x361D") ; <CJK>
       (?$(I"3(B . "0x3626") ; <CJK>
       (?$(I"4(B . "0x5724") ; <CJK>
       (?$(I"5(B . "0x5904") ; <CJK>
       (?$(I"6(B . "0x5918") ; <CJK>
       (?$(I"7(B . "0x5932") ; <CJK>
       (?$(I"8(B . "0x5930") ; <CJK>
       (?$(I"9(B . "0x5934") ; <CJK>
       (?$(I":(B . "0x368E") ; <CJK>
       (?$(I";(B . "0x5975") ; <CJK>
       (?$(I"<(B . "0x374A") ; <CJK>
       (?$(I"=(B . "0x5B82") ; <CJK>
       (?$(I">(B . "0x5BF9") ; <CJK>
       (?$(I"?(B . "0x5C14") ; <CJK>
       (?$(I"@(B . "0x378B") ; <CJK>
       (?$(I"A(B . "0x37A6") ; <CJK>
       (?$(I"B(B . "0x37A4") ; <CJK>
       (?$(I"C(B . "0x37A5") ; <CJK>
       (?$(I"D(B . "0x37A7") ; <CJK>
       (?$(I"E(B . "0x382F") ; <CJK>
       (?$(I"F(B . "0x3832") ; <CJK>
       (?$(I"G(B . "0x5E81") ; <CJK>
       (?$(I"H(B . "0x5E83") ; <CJK>
       (?$(I"I(B . "0x5F0D") ; <CJK>
       (?$(I"J(B . "0x5F52") ; <CJK>
       (?$(I"K(B . "0x38D4") ; <CJK>
       (?$(I"L(B . "0x5FCA") ; <CJK>
       (?$(I"M(B . "0x5FC7") ; <CJK>
       (?$(I"N(B . "0x6239") ; <CJK>
       (?$(I"O(B . "0x39C5") ; <CJK>
       (?$(I"P(B . "0x624F") ; <CJK>
       (?$(I"Q(B . "0x65E7") ; <CJK>
       (?$(I"R(B . "0x672F") ; <CJK>
       (?$(I"S(B . "0x6B7A") ; <CJK>
       (?$(I"T(B . "0x6C39") ; <CJK>
       (?$(I"U(B . "0x3CBA") ; <CJK>
       (?$(I"V(B . "0x3CB9") ; <CJK>
       (?$(I"W(B . "0x6C37") ; <CJK>
       (?$(I"X(B . "0x6C44") ; <CJK>
       (?$(I"Y(B . "0x6C45") ; <CJK>
       (?$(I"Z(B . "0x738C") ; <CJK>
       (?$(I"[(B . "0x7592") ; <CJK>
       (?$(I"\(B . "0x7676") ; <CJK>
       (?$(I"](B . "0x9093") ; <CJK>
       (?$(I"^(B . "0x9092") ; <CJK>
       (?$(I"_(B . "0x48B3") ; <CJK>
       (?$(I"`(B . "0x49BA") ; <CJK>
       (?$(I"a(B . "0x4E21") ; <CJK>
       (?$(I"b(B . "0x4E20") ; <CJK>
       (?$(I"c(B . "0x4E22") ; <CJK>
       (?$(I"d(B . "0x4E68") ; <CJK>
       (?$(I"e(B . "0x4E89") ; <CJK>
       (?$(I"f(B . "0x4E98") ; <CJK>
       (?$(I"g(B . "0x4EF9") ; <CJK>
       (?$(I"h(B . "0x4EEF") ; <CJK>
       (?$(I"i(B . "0x343B") ; <CJK>
       (?$(I"j(B . "0x343C") ; <CJK>
       (?$(I"k(B . "0x4EF8") ; <CJK>
       (?$(I"l(B . "0x4F06") ; <CJK>
       (?$(I"m(B . "0x4F03") ; <CJK>
       (?$(I"n(B . "0x4EFC") ; <CJK>
       (?$(I"o(B . "0x4EEE") ; <CJK>
       (?$(I"p(B . "0x4F16") ; <CJK>
       (?$(I"q(B . "0x3439") ; <CJK>
       (?$(I"r(B . "0x4F28") ; <CJK>
       (?$(I"s(B . "0x4F1C") ; <CJK>
       (?$(I"t(B . "0x4F07") ; <CJK>
       (?$(I"u(B . "0x4F1A") ; <CJK>
       (?$(I"v(B . "0x4EFA") ; <CJK>
       (?$(I"w(B . "0x4F17") ; <CJK>
       (?$(I"x(B . "0x514A") ; <CJK>
       (?$(I"y(B . "0x34B2") ; <CJK>
       (?$(I"z(B . "0x5172") ; <CJK>
       (?$(I"{(B . "0x2F815") ; <CJK>
       (?$(I"|(B . "0x51B4") ; <CJK>
       (?$(I"}(B . "0x51B3") ; <CJK>
       (?$(I"~(B . "0x51B2") ; <CJK>
       (?$(I#!(B . "0x34C7") ; <CJK>
       (?$(I#"(B . "0x51E8") ; <CJK>
       (?$(I##(B . "0x342B") ; <CJK>
       (?$(I#$(B . "0x5214") ; <CJK>
       (?$(I#%(B . "0x520F") ; <CJK>
       (?$(I#&(B . "0x5215") ; <CJK>
       (?$(I#'(B . "0x5218") ; <CJK>
       (?$(I#((B . "0x52A8") ; <CJK>
       (?$(I#)(B . "0x2F82C") ; <CJK>
       (?$(I#*(B . "0x534B") ; <CJK>
       (?$(I#+(B . "0x534F") ; <CJK>
       (?$(I#,(B . "0x353B") ; <CJK>
       (?$(I#-(B . "0x5350") ; <CJK>
       (?$(I#.(B . "0x3544") ; <CJK>
       (?$(I#/(B . "0x538B") ; <CJK>
       (?$(I#0(B . "0x3542") ; <CJK>
       (?$(I#1(B . "0x53BE") ; <CJK>
       (?$(I#2(B . "0x355C") ; <CJK>
       (?$(I#3(B . "0x53D2") ; <CJK>
       (?$(I#4(B . "0x5416") ; <CJK>
       (?$(I#5(B . "0x53FF") ; <CJK>
       (?$(I#6(B . "0x3567") ; <CJK>
       (?$(I#7(B . "0x5400") ; <CJK>
       (?$(I#8(B . "0x3566") ; <CJK>
       (?$(I#9(B . "0x5405") ; <CJK>
       (?$(I#:(B . "0x5413") ; <CJK>
       (?$(I#;(B . "0x5415") ; <CJK>
       (?$(I#<(B . "0x2F83B") ; <CJK>
       (?$(I#=(B . "0x361F") ; <CJK>
       (?$(I#>(B . "0x56E3") ; <CJK>
       (?$(I#?(B . "0x5735") ; <CJK>
       (?$(I#@(B . "0x5736") ; <CJK>
       (?$(I#A(B . "0x5731") ; <CJK>
       (?$(I#B(B . "0x5732") ; <CJK>
       (?$(I#C(B . "0x58EE") ; <CJK>
       (?$(I#D(B . "0x5905") ; <CJK>
       (?$(I#E(B . "0x4E54") ; <CJK>
       (?$(I#F(B . "0x368F") ; <CJK>
       (?$(I#G(B . "0x5936") ; <CJK>
       (?$(I#H(B . "0x3690") ; <CJK>
       (?$(I#I(B . "0x36A8") ; <CJK>
       (?$(I#J(B . "0x36A4") ; <CJK>
       (?$(I#K(B . "0x597A") ; <CJK>
       (?$(I#L(B . "0x36A3") ; <CJK>
       (?$(I#M(B . "0x5986") ; <CJK>
       (?$(I#N(B . "0x373D") ; <CJK>
       (?$(I#O(B . "0x374C") ; <CJK>
       (?$(I#P(B . "0x5B86") ; <CJK>
       (?$(I#Q(B . "0x5F53") ; <CJK>
       (?$(I#R(B . "0x5C18") ; <CJK>
       (?$(I#S(B . "0x378C") ; <CJK>
       (?$(I#T(B . "0x5C3D") ; <CJK>
       (?$(I#U(B . "0x5C78") ; <CJK>
       (?$(I#V(B . "0x37A8") ; <CJK>
       (?$(I#W(B . "0x37AD") ; <CJK>
       (?$(I#X(B . "0x37AF") ; <CJK>
       (?$(I#Y(B . "0x21D46") ; <CJK>
       (?$(I#Z(B . "0x5C80") ; <CJK>
       (?$(I#[(B . "0x3829") ; <CJK>
       (?$(I#\(B . "0x5E08") ; <CJK>
       (?$(I#](B . "0x3836") ; <CJK>
       (?$(I#^(B . "0x3871") ; <CJK>
       (?$(I#_(B . "0x3870") ; <CJK>
       (?$(I#`(B . "0x386F") ; <CJK>
       (?$(I#a(B . "0x5EF5") ; <CJK>
       (?$(I#b(B . "0x5F0E") ; <CJK>
       (?$(I#c(B . "0x38A9") ; <CJK>
       (?$(I#d(B . "0x38AA") ; <CJK>
       (?$(I#e(B . "0x38FB") ; <CJK>
       (?$(I#f(B . "0x5FD3") ; <CJK>
       (?$(I#g(B . "0x5FDA") ; <CJK>
       (?$(I#h(B . "0x38FC") ; <CJK>
       (?$(I#i(B . "0x5FDB") ; <CJK>
       (?$(I#j(B . "0x39AE") ; <CJK>
       (?$(I#k(B . "0x620F") ; <CJK>
       (?$(I#l(B . "0x625D") ; <CJK>
       (?$(I#m(B . "0x625F") ; <CJK>
       (?$(I#n(B . "0x6267") ; <CJK>
       (?$(I#o(B . "0x6257") ; <CJK>
       (?$(I#p(B . "0x9F50") ; <CJK>
       (?$(I#q(B . "0x3AC3") ; <CJK>
       (?$(I#r(B . "0x65EB") ; <CJK>
       (?$(I#s(B . "0x65EA") ; <CJK>
       (?$(I#t(B . "0x3B30") ; <CJK>
       (?$(I#u(B . "0x6737") ; <CJK>
       (?$(I#v(B . "0x3B41") ; <CJK>
       (?$(I#w(B . "0x6732") ; <CJK>
       (?$(I#x(B . "0x6736") ; <CJK>
       (?$(I#y(B . "0x6B22") ; <CJK>
       (?$(I#z(B . "0x6BCE") ; <CJK>
       (?$(I#{(B . "0x3C8C") ; <CJK>
       (?$(I#|(B . "0x6C58") ; <CJK>
       (?$(I#}(B . "0x6C51") ; <CJK>
       (?$(I#~(B . "0x6C77") ; <CJK>
       (?$(I$!(B . "0x6C3C") ; <CJK>
       (?$(I$"(B . "0x3CBB") ; <CJK>
       (?$(I$#(B . "0x6C5A") ; <CJK>
       (?$(I$$(B . "0x23C86") ; <CJK>
       (?$(I$%(B . "0x6C53") ; <CJK>
       (?$(I$&(B . "0x706F") ; <CJK>
       (?$(I$'(B . "0x7072") ; <CJK>
       (?$(I$((B . "0x706E") ; <CJK>
       (?$(I$)(B . "0x2F835") ; <CJK>
       (?$(I$*(B . "0x3DA1") ; <CJK>
       (?$(I$+(B . "0x7073") ; <CJK>
       (?$(I$,(B . "0x72B1") ; <CJK>
       (?$(I$-(B . "0x72B2") ; <CJK>
       (?$(I$.(B . "0x3EA8") ; <CJK>
       (?$(I$/(B . "0x738F") ; <CJK>
       (?$(I$0(B . "0x3EAA") ; <CJK>
       (?$(I$1(B . "0x3EAB") ; <CJK>
       (?$(I$2(B . "0x4096") ; <CJK>
       (?$(I$3(B . "0x793C") ; <CJK>
       (?$(I$4(B . "0x41C2") ; <CJK>
       (?$(I$5(B . "0x808D") ; <CJK>
       (?$(I$6(B . "0x808E") ; <CJK>
       (?$(I$7(B . "0x4493") ; <CJK>
       (?$(I$8(B . "0x827B") ; <CJK>
       (?$(I$9(B . "0x4494") ; <CJK>
       (?$(I$:(B . "0x8D71") ; <CJK>
       (?$(I$;(B . "0x8FB9") ; <CJK>
       (?$(I$<(B . "0x9096") ; <CJK>
       (?$(I$=(B . "0x909A") ; <CJK>
       (?$(I$>(B . "0x49BB") ; <CJK>
       (?$(I$?(B . "0x4E24") ; <CJK>
       (?$(I$@(B . "0x4E71") ; <CJK>
       (?$(I$A(B . "0x2F81B") ; <CJK>
       (?$(I$B(B . "0x4E9C") ; <CJK>
       (?$(I$C(B . "0x4F45") ; <CJK>
       (?$(I$D(B . "0x4F4A") ; <CJK>
       (?$(I$E(B . "0x4F39") ; <CJK>
       (?$(I$F(B . "0x4F37") ; <CJK>
       (?$(I$G(B . "0x3443") ; <CJK>
       (?$(I$H(B . "0x4F32") ; <CJK>
       (?$(I$I(B . "0x4F42") ; <CJK>
       (?$(I$J(B . "0x3442") ; <CJK>
       (?$(I$K(B . "0x4F44") ; <CJK>
       (?$(I$L(B . "0x4F4B") ; <CJK>
       (?$(I$M(B . "0x3444") ; <CJK>
       (?$(I$N(B . "0x4F40") ; <CJK>
       (?$(I$O(B . "0x4F35") ; <CJK>
       (?$(I$P(B . "0x4F31") ; <CJK>
       (?$(I$Q(B . "0x5151") ; <CJK>
       (?$(I$R(B . "0x2F80E") ; <CJK>
       (?$(I$S(B . "0x5150") ; <CJK>
       (?$(I$T(B . "0x514E") ; <CJK>
       (?$(I$U(B . "0x34B3") ; <CJK>
       (?$(I$V(B . "0x34B7") ; <CJK>
       (?$(I$W(B . "0x519D") ; <CJK>
       (?$(I$X(B . "0x34C8") ; <CJK>
       (?$(I$Y(B . "0x51B5") ; <CJK>
       (?$(I$Z(B . "0x51B8") ; <CJK>
       (?$(I$[(B . "0x51EC") ; <CJK>
       (?$(I$\(B . "0x5223") ; <CJK>
       (?$(I$](B . "0x5227") ; <CJK>
       (?$(I$^(B . "0x5226") ; <CJK>
       (?$(I$_(B . "0x521F") ; <CJK>
       (?$(I$`(B . "0x522B") ; <CJK>
       (?$(I$a(B . "0x5220") ; <CJK>
       (?$(I$b(B . "0x52B4") ; <CJK>
       (?$(I$c(B . "0x52B3") ; <CJK>
       (?$(I$d(B . "0x3518") ; <CJK>
       (?$(I$e(B . "0x5325") ; <CJK>
       (?$(I$f(B . "0x533B") ; <CJK>
       (?$(I$g(B . "0x5374") ; <CJK>
       (?$(I$h(B . "0x3547") ; <CJK>
       (?$(I$i(B . "0x3546") ; <CJK>
       (?$(I$j(B . "0x3545") ; <CJK>
       (?$(I$k(B . "0x356B") ; <CJK>
       (?$(I$l(B . "0x3569") ; <CJK>
       (?$(I$m(B . "0x544D") ; <CJK>
       (?$(I$n(B . "0x3572") ; <CJK>
       (?$(I$o(B . "0x3571") ; <CJK>
       (?$(I$p(B . "0x543A") ; <CJK>
       (?$(I$q(B . "0x356C") ; <CJK>
       (?$(I$r(B . "0x356F") ; <CJK>
       (?$(I$s(B . "0x5444") ; <CJK>
       (?$(I$t(B . "0x544C") ; <CJK>
       (?$(I$u(B . "0x5423") ; <CJK>
       (?$(I$v(B . "0x541A") ; <CJK>
       (?$(I$w(B . "0x5432") ; <CJK>
       (?$(I$x(B . "0x544B") ; <CJK>
       (?$(I$y(B . "0x5421") ; <CJK>
       (?$(I$z(B . "0x3573") ; <CJK>
       (?$(I${(B . "0x5434") ; <CJK>
       (?$(I$|(B . "0x5449") ; <CJK>
       (?$(I$}(B . "0x5450") ; <CJK>
       (?$(I$~(B . "0x5422") ; <CJK>
       (?$(I%!(B . "0x543F") ; <CJK>
       (?$(I%"(B . "0x5451") ; <CJK>
       (?$(I%#(B . "0x545A") ; <CJK>
       (?$(I%$(B . "0x542F") ; <CJK>
       (?$(I%%(B . "0x3576") ; <CJK>
       (?$(I%&(B . "0x56E9") ; <CJK>
       (?$(I%'(B . "0x56F2") ; <CJK>
       (?$(I%((B . "0x56F3") ; <CJK>
       (?$(I%)(B . "0x56EF") ; <CJK>
       (?$(I%*(B . "0x56ED") ; <CJK>
       (?$(I%+(B . "0x56EC") ; <CJK>
       (?$(I%,(B . "0x56E6") ; <CJK>
       (?$(I%-(B . "0x5748") ; <CJK>
       (?$(I%.(B . "0x3627") ; <CJK>
       (?$(I%/(B . "0x5744") ; <CJK>
       (?$(I%0(B . "0x573F") ; <CJK>
       (?$(I%1(B . "0x573C") ; <CJK>
       (?$(I%2(B . "0x5753") ; <CJK>
       (?$(I%3(B . "0x5756") ; <CJK>
       (?$(I%4(B . "0x3630") ; <CJK>
       (?$(I%5(B . "0x575F") ; <CJK>
       (?$(I%6(B . "0x5743") ; <CJK>
       (?$(I%7(B . "0x5758") ; <CJK>
       (?$(I%8(B . "0x5757") ; <CJK>
       (?$(I%9(B . "0x3629") ; <CJK>
       (?$(I%:(B . "0x362A") ; <CJK>
       (?$(I%;(B . "0x362F") ; <CJK>
       (?$(I%<(B . "0x5746") ; <CJK>
       (?$(I%=(B . "0x362C") ; <CJK>
       (?$(I%>(B . "0x573D") ; <CJK>
       (?$(I%?(B . "0x362D") ; <CJK>
       (?$(I%@(B . "0x5742") ; <CJK>
       (?$(I%A(B . "0x5754") ; <CJK>
       (?$(I%B(B . "0x5755") ; <CJK>
       (?$(I%C(B . "0x58F1") ; <CJK>
       (?$(I%D(B . "0x58F2") ; <CJK>
       (?$(I%E(B . "0x58F0") ; <CJK>
       (?$(I%F(B . "0x590B") ; <CJK>
       (?$(I%G(B . "0x9EA6") ; <CJK>
       (?$(I%H(B . "0x56F1") ; <CJK>
       (?$(I%I(B . "0x593D") ; <CJK>
       (?$(I%J(B . "0x3693") ; <CJK>
       (?$(I%K(B . "0x5994") ; <CJK>
       (?$(I%L(B . "0x598C") ; <CJK>
       (?$(I%M(B . "0x36AD") ; <CJK>
       (?$(I%N(B . "0x599C") ; <CJK>
       (?$(I%O(B . "0x36AC") ; <CJK>
       (?$(I%P(B . "0x36AB") ; <CJK>
       (?$(I%Q(B . "0x599F") ; <CJK>
       (?$(I%R(B . "0x36A9") ; <CJK>
       (?$(I%S(B . "0x599B") ; <CJK>
       (?$(I%T(B . "0x36AE") ; <CJK>
       (?$(I%U(B . "0x5989") ; <CJK>
       (?$(I%V(B . "0x599A") ; <CJK>
       (?$(I%W(B . "0x36AA") ; <CJK>
       (?$(I%X(B . "0x6588") ; <CJK>
       (?$(I%Y(B . "0x374E") ; <CJK>
       (?$(I%Z(B . "0x5B8D") ; <CJK>
       (?$(I%[(B . "0x3750") ; <CJK>
       (?$(I%\(B . "0x5BFE") ; <CJK>
       (?$(I%](B . "0x5BFF") ; <CJK>
       (?$(I%^(B . "0x5BFD") ; <CJK>
       (?$(I%_(B . "0x5C2B") ; <CJK>
       (?$(I%`(B . "0x37B2") ; <CJK>
       (?$(I%a(B . "0x5C84") ; <CJK>
       (?$(I%b(B . "0x5C8E") ; <CJK>
       (?$(I%c(B . "0x5C9C") ; <CJK>
       (?$(I%d(B . "0x37B5") ; <CJK>
       (?$(I%e(B . "0x37B6") ; <CJK>
       (?$(I%f(B . "0x5C85") ; <CJK>
       (?$(I%g(B . "0x5DF5") ; <CJK>
       (?$(I%h(B . "0x5E09") ; <CJK>
       (?$(I%i(B . "0x3839") ; <CJK>
       (?$(I%j(B . "0x383B") ; <CJK>
       (?$(I%k(B . "0x5E0B") ; <CJK>
       (?$(I%l(B . "0x3872") ; <CJK>
       (?$(I%m(B . "0x5E92") ; <CJK>
       (?$(I%n(B . "0x5E90") ; <CJK>
       (?$(I%o(B . "0x5F03") ; <CJK>
       (?$(I%p(B . "0x38AC") ; <CJK>
       (?$(I%q(B . "0x5F1E") ; <CJK>
       (?$(I%r(B . "0x5F63") ; <CJK>
       (?$(I%s(B . "0x3908") ; <CJK>
       (?$(I%t(B . "0x5FE7") ; <CJK>
       (?$(I%u(B . "0x5FFE") ; <CJK>
       (?$(I%v(B . "0x5FE6") ; <CJK>
       (?$(I%w(B . "0x5FDC") ; <CJK>
       (?$(I%x(B . "0x5FCE") ; <CJK>
       (?$(I%y(B . "0x3903") ; <CJK>
       (?$(I%z(B . "0x5FFC") ; <CJK>
       (?$(I%{(B . "0x5FDF") ; <CJK>
       (?$(I%|(B . "0x5FEC") ; <CJK>
       (?$(I%}(B . "0x5FF6") ; <CJK>
       (?$(I%~(B . "0x225D7") ; <CJK>
       (?$(I&!(B . "0x5FF2") ; <CJK>
       (?$(I&"(B . "0x5FF0") ; <CJK>
       (?$(I&#(B . "0x5FF9") ; <CJK>
       (?$(I&$(B . "0x390B") ; <CJK>
       (?$(I&%(B . "0x6213") ; <CJK>
       (?$(I&&(B . "0x39AF") ; <CJK>
       (?$(I&'(B . "0x2F8B2") ; <CJK>
       (?$(I&((B . "0x623B") ; <CJK>
       (?$(I&)(B . "0x623C") ; <CJK>
       (?$(I&*(B . "0x6282") ; <CJK>
       (?$(I&+(B . "0x39CE") ; <CJK>
       (?$(I&,(B . "0x39CB") ; <CJK>
       (?$(I&-(B . "0x39CC") ; <CJK>
       (?$(I&.(B . "0x6278") ; <CJK>
       (?$(I&/(B . "0x628B") ; <CJK>
       (?$(I&0(B . "0x39CD") ; <CJK>
       (?$(I&1(B . "0x629E") ; <CJK>
       (?$(I&2(B . "0x62A5") ; <CJK>
       (?$(I&3(B . "0x629B") ; <CJK>
       (?$(I&4(B . "0x629C") ; <CJK>
       (?$(I&5(B . "0x6299") ; <CJK>
       (?$(I&6(B . "0x628D") ; <CJK>
       (?$(I&7(B . "0x6285") ; <CJK>
       (?$(I&8(B . "0x629D") ; <CJK>
       (?$(I&9(B . "0x6275") ; <CJK>
       (?$(I&:(B . "0x3A80") ; <CJK>
       (?$(I&;(B . "0x3AAF") ; <CJK>
       (?$(I&<(B . "0x3AD3") ; <CJK>
       (?$(I&=(B . "0x65F6") ; <CJK>
       (?$(I&>(B . "0x3AD5") ; <CJK>
       (?$(I&?(B . "0x3AD4") ; <CJK>
       (?$(I&@(B . "0x3AD7") ; <CJK>
       (?$(I&A(B . "0x66F5") ; <CJK>
       (?$(I&B(B . "0x675B") ; <CJK>
       (?$(I&C(B . "0x3B42") ; <CJK>
       (?$(I&D(B . "0x6754") ; <CJK>
       (?$(I&E(B . "0x6752") ; <CJK>
       (?$(I&F(B . "0x3B44") ; <CJK>
       (?$(I&G(B . "0x6758") ; <CJK>
       (?$(I&H(B . "0x6744") ; <CJK>
       (?$(I&I(B . "0x674A") ; <CJK>
       (?$(I&J(B . "0x6761") ; <CJK>
       (?$(I&K(B . "0x3CC6") ; <CJK>
       (?$(I&L(B . "0x6C7F") ; <CJK>
       (?$(I&M(B . "0x6C91") ; <CJK>
       (?$(I&N(B . "0x6C9E") ; <CJK>
       (?$(I&O(B . "0x3CC0") ; <CJK>
       (?$(I&P(B . "0x6C6E") ; <CJK>
       (?$(I&Q(B . "0x6C7C") ; <CJK>
       (?$(I&R(B . "0x6C9F") ; <CJK>
       (?$(I&S(B . "0x6C75") ; <CJK>
       (?$(I&T(B . "0x3CBE") ; <CJK>
       (?$(I&U(B . "0x6C56") ; <CJK>
       (?$(I&V(B . "0x6CA2") ; <CJK>
       (?$(I&W(B . "0x6C79") ; <CJK>
       (?$(I&X(B . "0x3CCA") ; <CJK>
       (?$(I&Y(B . "0x6CA1") ; <CJK>
       (?$(I&Z(B . "0x3CC4") ; <CJK>
       (?$(I&[(B . "0x6CAA") ; <CJK>
       (?$(I&\(B . "0x6CA0") ; <CJK>
       (?$(I&](B . "0x3CC2") ; <CJK>
       (?$(I&^(B . "0x7079") ; <CJK>
       (?$(I&_(B . "0x7077") ; <CJK>
       (?$(I&`(B . "0x707E") ; <CJK>
       (?$(I&a(B . "0x3DA4") ; <CJK>
       (?$(I&b(B . "0x7075") ; <CJK>
       (?$(I&c(B . "0x707B") ; <CJK>
       (?$(I&d(B . "0x7264") ; <CJK>
       (?$(I&e(B . "0x3E29") ; <CJK>
       (?$(I&f(B . "0x72BB") ; <CJK>
       (?$(I&g(B . "0x72BC") ; <CJK>
       (?$(I&h(B . "0x72C7") ; <CJK>
       (?$(I&i(B . "0x72B9") ; <CJK>
       (?$(I&j(B . "0x72BE") ; <CJK>
       (?$(I&k(B . "0x72B6") ; <CJK>
       (?$(I&l(B . "0x3E60") ; <CJK>
       (?$(I&m(B . "0x3E5E") ; <CJK>
       (?$(I&n(B . "0x7398") ; <CJK>
       (?$(I&o(B . "0x3EAD") ; <CJK>
       (?$(I&p(B . "0x3EAE") ; <CJK>
       (?$(I&q(B . "0x3EAC") ; <CJK>
       (?$(I&r(B . "0x3F57") ; <CJK>
       (?$(I&s(B . "0x7593") ; <CJK>
       (?$(I&t(B . "0x7680") ; <CJK>
       (?$(I&u(B . "0x3FDD") ; <CJK>
       (?$(I&v(B . "0x7683") ; <CJK>
       (?$(I&w(B . "0x76C0") ; <CJK>
       (?$(I&x(B . "0x76C1") ; <CJK>
       (?$(I&y(B . "0x400E") ; <CJK>
       (?$(I&z(B . "0x4097") ; <CJK>
       (?$(I&{(B . "0x77F4") ; <CJK>
       (?$(I&|(B . "0x77F5") ; <CJK>
       (?$(I&}(B . "0x4127") ; <CJK>
       (?$(I&~(B . "0x7ACC") ; <CJK>
       (?$(I'!(B . "0x7ACD") ; <CJK>
       (?$(I'"(B . "0x7CFA") ; <CJK>
       (?$(I'#(B . "0x809F") ; <CJK>
       (?$(I'$(B . "0x8091") ; <CJK>
       (?$(I'%(B . "0x8097") ; <CJK>
       (?$(I'&(B . "0x8094") ; <CJK>
       (?$(I''(B . "0x4495") ; <CJK>
       (?$(I'((B . "0x8286") ; <CJK>
       (?$(I')(B . "0x828C") ; <CJK>
       (?$(I'*(B . "0x2F98F") ; <CJK>
       (?$(I'+(B . "0x8295") ; <CJK>
       (?$(I',(B . "0x4498") ; <CJK>
       (?$(I'-(B . "0x866C") ; <CJK>
       (?$(I'.(B . "0x459D") ; <CJK>
       (?$(I'/(B . "0x8FB5") ; <CJK>
       (?$(I'0(B . "0x8FBE") ; <CJK>
       (?$(I'1(B . "0x8FC7") ; <CJK>
       (?$(I'2(B . "0x488A") ; <CJK>
       (?$(I'3(B . "0x8FC1") ; <CJK>
       (?$(I'4(B . "0x90A9") ; <CJK>
       (?$(I'5(B . "0x90A4") ; <CJK>
       (?$(I'6(B . "0x48B5") ; <CJK>
       (?$(I'7(B . "0x48B6") ; <CJK>
       (?$(I'8(B . "0x48B7") ; <CJK>
       (?$(I'9(B . "0x90A8") ; <CJK>
       (?$(I':(B . "0x9627") ; <CJK>
       (?$(I';(B . "0x9626") ; <CJK>
       (?$(I'<(B . "0x962B") ; <CJK>
       (?$(I'=(B . "0x9633") ; <CJK>
       (?$(I'>(B . "0x9634") ; <CJK>
       (?$(I'?(B . "0x9629") ; <CJK>
       (?$(I'@(B . "0x4E3D") ; <CJK>
       (?$(I'A(B . "0x3428") ; <CJK>
       (?$(I'B(B . "0x4E9D") ; <CJK>
       (?$(I'C(B . "0x4F93") ; <CJK>
       (?$(I'D(B . "0x4F8A") ; <CJK>
       (?$(I'E(B . "0x344D") ; <CJK>
       (?$(I'F(B . "0x3449") ; <CJK>
       (?$(I'G(B . "0x4F6D") ; <CJK>
       (?$(I'H(B . "0x4F8E") ; <CJK>
       (?$(I'I(B . "0x4FA0") ; <CJK>
       (?$(I'J(B . "0x4FA2") ; <CJK>
       (?$(I'K(B . "0x4FA1") ; <CJK>
       (?$(I'L(B . "0x4F9F") ; <CJK>
       (?$(I'M(B . "0x4FA3") ; <CJK>
       (?$(I'N(B . "0x20209") ; <CJK>
       (?$(I'O(B . "0x4F72") ; <CJK>
       (?$(I'P(B . "0x3451") ; <CJK>
       (?$(I'Q(B . "0x4F8C") ; <CJK>
       (?$(I'R(B . "0x5156") ; <CJK>
       (?$(I'S(B . "0x2F80F") ; <CJK>
       (?$(I'T(B . "0x2F811") ; <CJK>
       (?$(I'U(B . "0x5190") ; <CJK>
       (?$(I'V(B . "0x34CB") ; <CJK>
       (?$(I'W(B . "0x34CA") ; <CJK>
       (?$(I'X(B . "0x34CC") ; <CJK>
       (?$(I'Y(B . "0x51ED") ; <CJK>
       (?$(I'Z(B . "0x51FE") ; <CJK>
       (?$(I'[(B . "0x522F") ; <CJK>
       (?$(I'\(B . "0x206EC") ; <CJK>
       (?$(I'](B . "0x523C") ; <CJK>
       (?$(I'^(B . "0x5234") ; <CJK>
       (?$(I'_(B . "0x5239") ; <CJK>
       (?$(I'`(B . "0x52B9") ; <CJK>
       (?$(I'a(B . "0x52B5") ; <CJK>
       (?$(I'b(B . "0x52BF") ; <CJK>
       (?$(I'c(B . "0x5355") ; <CJK>
       (?$(I'd(B . "0x353D") ; <CJK>
       (?$(I'e(B . "0x5376") ; <CJK>
       (?$(I'f(B . "0x537A") ; <CJK>
       (?$(I'g(B . "0x5393") ; <CJK>
       (?$(I'h(B . "0x3548") ; <CJK>
       (?$(I'i(B . "0x53C1") ; <CJK>
       (?$(I'j(B . "0x53C2") ; <CJK>
       (?$(I'k(B . "0x53D5") ; <CJK>
       (?$(I'l(B . "0x5485") ; <CJK>
       (?$(I'm(B . "0x3578") ; <CJK>
       (?$(I'n(B . "0x545F") ; <CJK>
       (?$(I'o(B . "0x5493") ; <CJK>
       (?$(I'p(B . "0x5489") ; <CJK>
       (?$(I'q(B . "0x5479") ; <CJK>
       (?$(I'r(B . "0x9EFE") ; <CJK>
       (?$(I's(B . "0x548F") ; <CJK>
       (?$(I't(B . "0x5469") ; <CJK>
       (?$(I'u(B . "0x546D") ; <CJK>
       (?$(I'v(B . "0x357A") ; <CJK>
       (?$(I'w(B . "0x5494") ; <CJK>
       (?$(I'x(B . "0x546A") ; <CJK>
       (?$(I'y(B . "0x548A") ; <CJK>
       (?$(I'z(B . "0x3577") ; <CJK>
       (?$(I'{(B . "0x56FD") ; <CJK>
       (?$(I'|(B . "0x56FB") ; <CJK>
       (?$(I'}(B . "0x56F8") ; <CJK>
       (?$(I'~(B . "0x3621") ; <CJK>
       (?$(I(!(B . "0x56FC") ; <CJK>
       (?$(I("(B . "0x56F6") ; <CJK>
       (?$(I(#(B . "0x5765") ; <CJK>
       (?$(I($(B . "0x5781") ; <CJK>
       (?$(I(%(B . "0x5763") ; <CJK>
       (?$(I(&(B . "0x5767") ; <CJK>
       (?$(I('(B . "0x3631") ; <CJK>
       (?$(I(((B . "0x576E") ; <CJK>
       (?$(I()(B . "0x5778") ; <CJK>
       (?$(I(*(B . "0x577F") ; <CJK>
       (?$(I(+(B . "0x3633") ; <CJK>
       (?$(I(,(B . "0x3634") ; <CJK>
       (?$(I(-(B . "0x58F3") ; <CJK>
       (?$(I(.(B . "0x594B") ; <CJK>
       (?$(I(/(B . "0x594C") ; <CJK>
       (?$(I(0(B . "0x36C1") ; <CJK>
       (?$(I(1(B . "0x36B0") ; <CJK>
       (?$(I(2(B . "0x36B4") ; <CJK>
       (?$(I(3(B . "0x59AD") ; <CJK>
       (?$(I(4(B . "0x36B8") ; <CJK>
       (?$(I(5(B . "0x59C4") ; <CJK>
       (?$(I(6(B . "0x36BC") ; <CJK>
       (?$(I(7(B . "0x59C2") ; <CJK>
       (?$(I(8(B . "0x59B0") ; <CJK>
       (?$(I(9(B . "0x36BF") ; <CJK>
       (?$(I(:(B . "0x36B5") ; <CJK>
       (?$(I(;(B . "0x36B1") ; <CJK>
       (?$(I(<(B . "0x36BD") ; <CJK>
       (?$(I(=(B . "0x59BF") ; <CJK>
       (?$(I(>(B . "0x36BB") ; <CJK>
       (?$(I(?(B . "0x59C9") ; <CJK>
       (?$(I(@(B . "0x59B8") ; <CJK>
       (?$(I(A(B . "0x59AC") ; <CJK>
       (?$(I(B(B . "0x36B3") ; <CJK>
       (?$(I(C(B . "0x36B6") ; <CJK>
       (?$(I(D(B . "0x36BA") ; <CJK>
       (?$(I(E(B . "0x59B7") ; <CJK>
       (?$(I(F(B . "0x59D7") ; <CJK>
       (?$(I(G(B . "0x36B7") ; <CJK>
       (?$(I(H(B . "0x5B60") ; <CJK>
       (?$(I(I(B . "0x3740") ; <CJK>
       (?$(I(J(B . "0x5B96") ; <CJK>
       (?$(I(K(B . "0x5B9E") ; <CJK>
       (?$(I(L(B . "0x5B94") ; <CJK>
       (?$(I(M(B . "0x5B9F") ; <CJK>
       (?$(I(N(B . "0x5B9D") ; <CJK>
       (?$(I(O(B . "0x3752") ; <CJK>
       (?$(I(P(B . "0x5C00") ; <CJK>
       (?$(I(Q(B . "0x5C19") ; <CJK>
       (?$(I(R(B . "0x3790") ; <CJK>
       (?$(I(S(B . "0x3791") ; <CJK>
       (?$(I(T(B . "0x5C49") ; <CJK>
       (?$(I(U(B . "0x5C4A") ; <CJK>
       (?$(I(V(B . "0x37BE") ; <CJK>
       (?$(I(W(B . "0x5CBB") ; <CJK>
       (?$(I(X(B . "0x5CC1") ; <CJK>
       (?$(I(Y(B . "0x37C0") ; <CJK>
       (?$(I(Z(B . "0x37C1") ; <CJK>
       (?$(I([(B . "0x37B9") ; <CJK>
       (?$(I(\(B . "0x5CB9") ; <CJK>
       (?$(I(](B . "0x5C9E") ; <CJK>
       (?$(I(^(B . "0x5CB4") ; <CJK>
       (?$(I(_(B . "0x5CBA") ; <CJK>
       (?$(I(`(B . "0x5DF6") ; <CJK>
       (?$(I(a(B . "0x5E13") ; <CJK>
       (?$(I(b(B . "0x5E12") ; <CJK>
       (?$(I(c(B . "0x5E77") ; <CJK>
       (?$(I(d(B . "0x3879") ; <CJK>
       (?$(I(e(B . "0x5E98") ; <CJK>
       (?$(I(f(B . "0x387B") ; <CJK>
       (?$(I(g(B . "0x5E99") ; <CJK>
       (?$(I(h(B . "0x5E9D") ; <CJK>
       (?$(I(i(B . "0x5EF8") ; <CJK>
       (?$(I(j(B . "0x38A0") ; <CJK>
       (?$(I(k(B . "0x5EF9") ; <CJK>
       (?$(I(l(B . "0x3429") ; <CJK>
       (?$(I(m(B . "0x5F06") ; <CJK>
       (?$(I(n(B . "0x5F21") ; <CJK>
       (?$(I(o(B . "0x38AE") ; <CJK>
       (?$(I(p(B . "0x5F25") ; <CJK>
       (?$(I(q(B . "0x5F55") ; <CJK>
       (?$(I(r(B . "0x38CD") ; <CJK>
       (?$(I(s(B . "0x38CB") ; <CJK>
       (?$(I(t(B . "0x38D9") ; <CJK>
       (?$(I(u(B . "0x5F84") ; <CJK>
       (?$(I(v(B . "0x5F83") ; <CJK>
       (?$(I(w(B . "0x6030") ; <CJK>
       (?$(I(x(B . "0x6007") ; <CJK>
       (?$(I(y(B . "0x390C") ; <CJK>
       (?$(I(z(B . "0x6036") ; <CJK>
       (?$(I({(B . "0x3901") ; <CJK>
       (?$(I(|(B . "0x3905") ; <CJK>
       (?$(I(}(B . "0x3902") ; <CJK>
       (?$(I(~(B . "0x5FE9") ; <CJK>
       (?$(I)!(B . "0x603D") ; <CJK>
       (?$(I)"(B . "0x6008") ; <CJK>
       (?$(I)#(B . "0x3913") ; <CJK>
       (?$(I)$(B . "0x3911") ; <CJK>
       (?$(I)%(B . "0x62BA") ; <CJK>
       (?$(I)&(B . "0x62B2") ; <CJK>
       (?$(I)'(B . "0x39E4") ; <CJK>
       (?$(I)((B . "0x62B7") ; <CJK>
       (?$(I))(B . "0x62E4") ; <CJK>
       (?$(I)*(B . "0x62A7") ; <CJK>
       (?$(I)+(B . "0x39DA") ; <CJK>
       (?$(I),(B . "0x39D5") ; <CJK>
       (?$(I)-(B . "0x39D3") ; <CJK>
       (?$(I).(B . "0x62D5") ; <CJK>
       (?$(I)/(B . "0x62E1") ; <CJK>
       (?$(I)0(B . "0x62DD") ; <CJK>
       (?$(I)1(B . "0x62A6") ; <CJK>
       (?$(I)2(B . "0x62C1") ; <CJK>
       (?$(I)3(B . "0x62C5") ; <CJK>
       (?$(I)4(B . "0x62C0") ; <CJK>
       (?$(I)5(B . "0x62DF") ; <CJK>
       (?$(I)6(B . "0x62E0") ; <CJK>
       (?$(I)7(B . "0x62DE") ; <CJK>
       (?$(I)8(B . "0x39D6") ; <CJK>
       (?$(I)9(B . "0x6589") ; <CJK>
       (?$(I):(B . "0x3AB4") ; <CJK>
       (?$(I);(B . "0x65A6") ; <CJK>
       (?$(I)<(B . "0x65BA") ; <CJK>
       (?$(I)=(B . "0x3AD9") ; <CJK>
       (?$(I)>(B . "0x65FF") ; <CJK>
       (?$(I)?(B . "0x3AD8") ; <CJK>
       (?$(I)@(B . "0x6617") ; <CJK>
       (?$(I)A(B . "0x6618") ; <CJK>
       (?$(I)B(B . "0x6601") ; <CJK>
       (?$(I)C(B . "0x65FE") ; <CJK>
       (?$(I)D(B . "0x3B33") ; <CJK>
       (?$(I)E(B . "0x670C") ; <CJK>
       (?$(I)F(B . "0x3B48") ; <CJK>
       (?$(I)G(B . "0x676B") ; <CJK>
       (?$(I)H(B . "0x6796") ; <CJK>
       (?$(I)I(B . "0x6782") ; <CJK>
       (?$(I)J(B . "0x678A") ; <CJK>
       (?$(I)K(B . "0x3B47") ; <CJK>
       (?$(I)L(B . "0x67A3") ; <CJK>
       (?$(I)M(B . "0x3B4B") ; <CJK>
       (?$(I)N(B . "0x67A2") ; <CJK>
       (?$(I)O(B . "0x678F") ; <CJK>
       (?$(I)P(B . "0x3B4A") ; <CJK>
       (?$(I)Q(B . "0x67F9") ; <CJK>
       (?$(I)R(B . "0x6780") ; <CJK>
       (?$(I)S(B . "0x6B26") ; <CJK>
       (?$(I)T(B . "0x6B27") ; <CJK>
       (?$(I)U(B . "0x6B68") ; <CJK>
       (?$(I)V(B . "0x6B69") ; <CJK>
       (?$(I)W(B . "0x3C5A") ; <CJK>
       (?$(I)X(B . "0x6B81") ; <CJK>
       (?$(I)Y(B . "0x6BB4") ; <CJK>
       (?$(I)Z(B . "0x6BD1") ; <CJK>
       (?$(I)[(B . "0x3C8E") ; <CJK>
       (?$(I)\(B . "0x3CB4") ; <CJK>
       (?$(I)](B . "0x6C1C") ; <CJK>
       (?$(I)^(B . "0x3CCD") ; <CJK>
       (?$(I)_(B . "0x3CCC") ; <CJK>
       (?$(I)`(B . "0x3CCF") ; <CJK>
       (?$(I)a(B . "0x3CCB") ; <CJK>
       (?$(I)b(B . "0x3CCE") ; <CJK>
       (?$(I)c(B . "0x6C97") ; <CJK>
       (?$(I)d(B . "0x6C6C") ; <CJK>
       (?$(I)e(B . "0x6CDF") ; <CJK>
       (?$(I)f(B . "0x3CD2") ; <CJK>
       (?$(I)g(B . "0x6CEA") ; <CJK>
       (?$(I)h(B . "0x3CD1") ; <CJK>
       (?$(I)i(B . "0x6CE4") ; <CJK>
       (?$(I)j(B . "0x6CD8") ; <CJK>
       (?$(I)k(B . "0x6CB2") ; <CJK>
       (?$(I)l(B . "0x6CCE") ; <CJK>
       (?$(I)m(B . "0x6CC8") ; <CJK>
       (?$(I)n(B . "0x3DA6") ; <CJK>
       (?$(I)o(B . "0x708B") ; <CJK>
       (?$(I)p(B . "0x7088") ; <CJK>
       (?$(I)q(B . "0x7090") ; <CJK>
       (?$(I)r(B . "0x708F") ; <CJK>
       (?$(I)s(B . "0x3DAA") ; <CJK>
       (?$(I)t(B . "0x7087") ; <CJK>
       (?$(I)u(B . "0x7089") ; <CJK>
       (?$(I)v(B . "0x708D") ; <CJK>
       (?$(I)w(B . "0x7081") ; <CJK>
       (?$(I)x(B . "0x3DA8") ; <CJK>
       (?$(I)y(B . "0x708C") ; <CJK>
       (?$(I)z(B . "0x3E13") ; <CJK>
       (?$(I){(B . "0x3E1A") ; <CJK>
       (?$(I)|(B . "0x7240") ; <CJK>
       (?$(I)}(B . "0x3E1D") ; <CJK>
       (?$(I)~(B . "0x3E1E") ; <CJK>
       (?$(I*!(B . "0x7265") ; <CJK>
       (?$(I*"(B . "0x7266") ; <CJK>
       (?$(I*#(B . "0x7268") ; <CJK>
       (?$(I*$(B . "0x3E65") ; <CJK>
       (?$(I*%(B . "0x3E66") ; <CJK>
       (?$(I*&(B . "0x72CD") ; <CJK>
       (?$(I*'(B . "0x72D3") ; <CJK>
       (?$(I*((B . "0x72DB") ; <CJK>
       (?$(I*)(B . "0x3E64") ; <CJK>
       (?$(I**(B . "0x72CF") ; <CJK>
       (?$(I*+(B . "0x73A7") ; <CJK>
       (?$(I*,(B . "0x73A3") ; <CJK>
       (?$(I*-(B . "0x739E") ; <CJK>
       (?$(I*.(B . "0x3EB0") ; <CJK>
       (?$(I*/(B . "0x73AF") ; <CJK>
       (?$(I*0(B . "0x3EB3") ; <CJK>
       (?$(I*1(B . "0x3EB5") ; <CJK>
       (?$(I*2(B . "0x73AA") ; <CJK>
       (?$(I*3(B . "0x739C") ; <CJK>
       (?$(I*4(B . "0x3F19") ; <CJK>
       (?$(I*5(B . "0x7542") ; <CJK>
       (?$(I*6(B . "0x7544") ; <CJK>
       (?$(I*7(B . "0x753B") ; <CJK>
       (?$(I*8(B . "0x7541") ; <CJK>
       (?$(I*9(B . "0x2233F") ; <CJK>
       (?$(I*:(B . "0x759B") ; <CJK>
       (?$(I*;(B . "0x759E") ; <CJK>
       (?$(I*<(B . "0x3F75") ; <CJK>
       (?$(I*=(B . "0x79C4") ; <CJK>
       (?$(I*>(B . "0x79C3") ; <CJK>
       (?$(I*?(B . "0x79C6") ; <CJK>
       (?$(I*@(B . "0x412B") ; <CJK>
       (?$(I*A(B . "0x412C") ; <CJK>
       (?$(I*B(B . "0x79C7") ; <CJK>
       (?$(I*C(B . "0x412D") ; <CJK>
       (?$(I*D(B . "0x79CA") ; <CJK>
       (?$(I*E(B . "0x2592E") ; <CJK>
       (?$(I*F(B . "0x41C3") ; <CJK>
       (?$(I*G(B . "0x7ACF") ; <CJK>
       (?$(I*H(B . "0x7C76") ; <CJK>
       (?$(I*I(B . "0x7C74") ; <CJK>
       (?$(I*J(B . "0x7CFF") ; <CJK>
       (?$(I*K(B . "0x7CFC") ; <CJK>
       (?$(I*L(B . "0x34BA") ; <CJK>
       (?$(I*M(B . "0x4350") ; <CJK>
       (?$(I*N(B . "0x7F59") ; <CJK>
       (?$(I*O(B . "0x80A8") ; <CJK>
       (?$(I*P(B . "0x43D3") ; <CJK>
       (?$(I*Q(B . "0x43D0") ; <CJK>
       (?$(I*R(B . "0x80B0") ; <CJK>
       (?$(I*S(B . "0x43DC") ; <CJK>
       (?$(I*T(B . "0x80B3") ; <CJK>
       (?$(I*U(B . "0x43D2") ; <CJK>
       (?$(I*V(B . "0x80A4") ; <CJK>
       (?$(I*W(B . "0x80B6") ; <CJK>
       (?$(I*X(B . "0x80A7") ; <CJK>
       (?$(I*Y(B . "0x80AC") ; <CJK>
       (?$(I*Z(B . "0x43DB") ; <CJK>
       (?$(I*[(B . "0x80A6") ; <CJK>
       (?$(I*\(B . "0x5367") ; <CJK>
       (?$(I*](B . "0x820E") ; <CJK>
       (?$(I*^(B . "0x82C4") ; <CJK>
       (?$(I*_(B . "0x833E") ; <CJK>
       (?$(I*`(B . "0x829C") ; <CJK>
       (?$(I*a(B . "0x44A5") ; <CJK>
       (?$(I*b(B . "0x449F") ; <CJK>
       (?$(I*c(B . "0x449A") ; <CJK>
       (?$(I*d(B . "0x449C") ; <CJK>
       (?$(I*e(B . "0x44A2") ; <CJK>
       (?$(I*f(B . "0x82AA") ; <CJK>
       (?$(I*g(B . "0x449B") ; <CJK>
       (?$(I*h(B . "0x82C9") ; <CJK>
       (?$(I*i(B . "0x44A3") ; <CJK>
       (?$(I*j(B . "0x449D") ; <CJK>
       (?$(I*k(B . "0x82A6") ; <CJK>
       (?$(I*l(B . "0x82B2") ; <CJK>
       (?$(I*m(B . "0x4588") ; <CJK>
       (?$(I*n(B . "0x461A") ; <CJK>
       (?$(I*o(B . "0x488D") ; <CJK>
       (?$(I*p(B . "0x8FCC") ; <CJK>
       (?$(I*q(B . "0x8FD9") ; <CJK>
       (?$(I*r(B . "0x8FCA") ; <CJK>
       (?$(I*s(B . "0x8FD8") ; <CJK>
       (?$(I*t(B . "0x8FCF") ; <CJK>
       (?$(I*u(B . "0x90B7") ; <CJK>
       (?$(I*v(B . "0x48B8") ; <CJK>
       (?$(I*w(B . "0x90AD") ; <CJK>
       (?$(I*x(B . "0x90B9") ; <CJK>
       (?$(I*y(B . "0x9637") ; <CJK>
       (?$(I*z(B . "0x49C3") ; <CJK>
       (?$(I*{(B . "0x9641") ; <CJK>
       (?$(I*|(B . "0x963E") ; <CJK>
       (?$(I*}(B . "0x96B6") ; <CJK>
       (?$(I*~(B . "0x9751") ; <CJK>
       (?$(I+!(B . "0x9763") ; <CJK>
       (?$(I+"(B . "0x4E57") ; <CJK>
       (?$(I+#(B . "0x4E79") ; <CJK>
       (?$(I+$(B . "0x4EB2") ; <CJK>
       (?$(I+%(B . "0x4EB0") ; <CJK>
       (?$(I+&(B . "0x4EAF") ; <CJK>
       (?$(I+'(B . "0x4EB1") ; <CJK>
       (?$(I+((B . "0x4FD2") ; <CJK>
       (?$(I+)(B . "0x4FD5") ; <CJK>
       (?$(I+*(B . "0x345D") ; <CJK>
       (?$(I++(B . "0x4FBE") ; <CJK>
       (?$(I+,(B . "0x4FB8") ; <CJK>
       (?$(I+-(B . "0x4FB0") ; <CJK>
       (?$(I+.(B . "0x4FB1") ; <CJK>
       (?$(I+/(B . "0x4FC8") ; <CJK>
       (?$(I+0(B . "0x345A") ; <CJK>
       (?$(I+1(B . "0x3457") ; <CJK>
       (?$(I+2(B . "0x4FC6") ; <CJK>
       (?$(I+3(B . "0x4FCC") ; <CJK>
       (?$(I+4(B . "0x4FE5") ; <CJK>
       (?$(I+5(B . "0x4FE3") ; <CJK>
       (?$(I+6(B . "0x4FB4") ; <CJK>
       (?$(I+7(B . "0x516A") ; <CJK>
       (?$(I+8(B . "0x34B8") ; <CJK>
       (?$(I+9(B . "0x519F") ; <CJK>
       (?$(I+:(B . "0x34C2") ; <CJK>
       (?$(I+;(B . "0x51C1") ; <CJK>
       (?$(I+<(B . "0x34CF") ; <CJK>
       (?$(I+=(B . "0x51C2") ; <CJK>
       (?$(I+>(B . "0x51C3") ; <CJK>
       (?$(I+?(B . "0x5245") ; <CJK>
       (?$(I+@(B . "0x5248") ; <CJK>
       (?$(I+A(B . "0x34E7") ; <CJK>
       (?$(I+B(B . "0x34E9") ; <CJK>
       (?$(I+C(B . "0x524F") ; <CJK>
       (?$(I+D(B . "0x4452") ; <CJK>
       (?$(I+E(B . "0x34E8") ; <CJK>
       (?$(I+F(B . "0x52C5") ; <CJK>
       (?$(I+G(B . "0x52CA") ; <CJK>
       (?$(I+H(B . "0x52C4") ; <CJK>
       (?$(I+I(B . "0x5327") ; <CJK>
       (?$(I+J(B . "0x5358") ; <CJK>
       (?$(I+K(B . "0x537D") ; <CJK>
       (?$(I+L(B . "0x354A") ; <CJK>
       (?$(I+M(B . "0x53DD") ; <CJK>
       (?$(I+N(B . "0x53DC") ; <CJK>
       (?$(I+O(B . "0x53DA") ; <CJK>
       (?$(I+P(B . "0x53D9") ; <CJK>
       (?$(I+Q(B . "0x54B9") ; <CJK>
       (?$(I+R(B . "0x3580") ; <CJK>
       (?$(I+S(B . "0x54D0") ; <CJK>
       (?$(I+T(B . "0x54B4") ; <CJK>
       (?$(I+U(B . "0x54CA") ; <CJK>
       (?$(I+V(B . "0x3587") ; <CJK>
       (?$(I+W(B . "0x54A3") ; <CJK>
       (?$(I+X(B . "0x54DA") ; <CJK>
       (?$(I+Y(B . "0x54A4") ; <CJK>
       (?$(I+Z(B . "0x3584") ; <CJK>
       (?$(I+[(B . "0x54B2") ; <CJK>
       (?$(I+\(B . "0x549E") ; <CJK>
       (?$(I+](B . "0x549F") ; <CJK>
       (?$(I+^(B . "0x54B5") ; <CJK>
       (?$(I+_(B . "0x3582") ; <CJK>
       (?$(I+`(B . "0x3581") ; <CJK>
       (?$(I+a(B . "0x54CD") ; <CJK>
       (?$(I+b(B . "0x3583") ; <CJK>
       (?$(I+c(B . "0x54CC") ; <CJK>
       (?$(I+d(B . "0x3622") ; <CJK>
       (?$(I+e(B . "0x5700") ; <CJK>
       (?$(I+f(B . "0x57AC") ; <CJK>
       (?$(I+g(B . "0x5791") ; <CJK>
       (?$(I+h(B . "0x578E") ; <CJK>
       (?$(I+i(B . "0x578D") ; <CJK>
       (?$(I+j(B . "0x5792") ; <CJK>
       (?$(I+k(B . "0x57A1") ; <CJK>
       (?$(I+l(B . "0x5790") ; <CJK>
       (?$(I+m(B . "0x57A6") ; <CJK>
       (?$(I+n(B . "0x57A8") ; <CJK>
       (?$(I+o(B . "0x363B") ; <CJK>
       (?$(I+p(B . "0x579C") ; <CJK>
       (?$(I+q(B . "0x5796") ; <CJK>
       (?$(I+r(B . "0x57A7") ; <CJK>
       (?$(I+s(B . "0x363A") ; <CJK>
       (?$(I+t(B . "0x3638") ; <CJK>
       (?$(I+u(B . "0x3639") ; <CJK>
       (?$(I+v(B . "0x3636") ; <CJK>
       (?$(I+w(B . "0x58F5") ; <CJK>
       (?$(I+x(B . "0x3685") ; <CJK>
       (?$(I+y(B . "0x5909") ; <CJK>
       (?$(I+z(B . "0x5908") ; <CJK>
       (?$(I+{(B . "0x3C54") ; <CJK>
       (?$(I+|(B . "0x5952") ; <CJK>
       (?$(I+}(B . "0x369A") ; <CJK>
       (?$(I+~(B . "0x36C4") ; <CJK>
       (?$(I,!(B . "0x59DF") ; <CJK>
       (?$(I,"(B . "0x36C5") ; <CJK>
       (?$(I,#(B . "0x59EB") ; <CJK>
       (?$(I,$(B . "0x59EF") ; <CJK>
       (?$(I,%(B . "0x59F0") ; <CJK>
       (?$(I,&(B . "0x59D5") ; <CJK>
       (?$(I,'(B . "0x5A0D") ; <CJK>
       (?$(I,((B . "0x5A04") ; <CJK>
       (?$(I,)(B . "0x59F9") ; <CJK>
       (?$(I,*(B . "0x5A02") ; <CJK>
       (?$(I,+(B . "0x59F8") ; <CJK>
       (?$(I,,(B . "0x59E2") ; <CJK>
       (?$(I,-(B . "0x59D9") ; <CJK>
       (?$(I,.(B . "0x59E7") ; <CJK>
       (?$(I,/(B . "0x5B6A") ; <CJK>
       (?$(I,0(B . "0x3754") ; <CJK>
       (?$(I,1(B . "0x3755") ; <CJK>
       (?$(I,2(B . "0x5BAB") ; <CJK>
       (?$(I,3(B . "0x3756") ; <CJK>
       (?$(I,4(B . "0x5C1B") ; <CJK>
       (?$(I,5(B . "0x5C2F") ; <CJK>
       (?$(I,6(B . "0x3796") ; <CJK>
       (?$(I,7(B . "0x663C") ; <CJK>
       (?$(I,8(B . "0x3795") ; <CJK>
       (?$(I,9(B . "0x3794") ; <CJK>
       (?$(I,:(B . "0x37C4") ; <CJK>
       (?$(I,;(B . "0x5CD1") ; <CJK>
       (?$(I,<(B . "0x5CDC") ; <CJK>
       (?$(I,=(B . "0x5CE6") ; <CJK>
       (?$(I,>(B . "0x5CE1") ; <CJK>
       (?$(I,?(B . "0x5CCD") ; <CJK>
       (?$(I,@(B . "0x2F87A") ; <CJK>
       (?$(I,A(B . "0x5CE2") ; <CJK>
       (?$(I,B(B . "0x5CDD") ; <CJK>
       (?$(I,C(B . "0x5CE5") ; <CJK>
       (?$(I,D(B . "0x5DFB") ; <CJK>
       (?$(I,E(B . "0x5DFA") ; <CJK>
       (?$(I,F(B . "0x5E1E") ; <CJK>
       (?$(I,G(B . "0x3844") ; <CJK>
       (?$(I,H(B . "0x5EA1") ; <CJK>
       (?$(I,I(B . "0x387D") ; <CJK>
       (?$(I,J(B . "0x387E") ; <CJK>
       (?$(I,K(B . "0x5EFC") ; <CJK>
       (?$(I,L(B . "0x5EFB") ; <CJK>
       (?$(I,M(B . "0x5F2F") ; <CJK>
       (?$(I,N(B . "0x38B2") ; <CJK>
       (?$(I,O(B . "0x38B6") ; <CJK>
       (?$(I,P(B . "0x5F66") ; <CJK>
       (?$(I,Q(B . "0x2F899") ; <CJK>
       (?$(I,R(B . "0x38DC") ; <CJK>
       (?$(I,S(B . "0x38DF") ; <CJK>
       (?$(I,T(B . "0x605C") ; <CJK>
       (?$(I,U(B . "0x3928") ; <CJK>
       (?$(I,V(B . "0x604E") ; <CJK>
       (?$(I,W(B . "0x6051") ; <CJK>
       (?$(I,X(B . "0x3919") ; <CJK>
       (?$(I,Y(B . "0x3910") ; <CJK>
       (?$(I,Z(B . "0x6023") ; <CJK>
       (?$(I,[(B . "0x6031") ; <CJK>
       (?$(I,\(B . "0x607C") ; <CJK>
       (?$(I,](B . "0x6052") ; <CJK>
       (?$(I,^(B . "0x392C") ; <CJK>
       (?$(I,_(B . "0x6060") ; <CJK>
       (?$(I,`(B . "0x604A") ; <CJK>
       (?$(I,a(B . "0x6061") ; <CJK>
       (?$(I,b(B . "0x391B") ; <CJK>
       (?$(I,c(B . "0x6218") ; <CJK>
       (?$(I,d(B . "0x39C2") ; <CJK>
       (?$(I,e(B . "0x39EF") ; <CJK>
       (?$(I,f(B . "0x39E3") ; <CJK>
       (?$(I,g(B . "0x39E5") ; <CJK>
       (?$(I,h(B . "0x39EA") ; <CJK>
       (?$(I,i(B . "0x39E6") ; <CJK>
       (?$(I,j(B . "0x39EE") ; <CJK>
       (?$(I,k(B . "0x631F") ; <CJK>
       (?$(I,l(B . "0x6317") ; <CJK>
       (?$(I,m(B . "0x62EA") ; <CJK>
       (?$(I,n(B . "0x6321") ; <CJK>
       (?$(I,o(B . "0x6304") ; <CJK>
       (?$(I,p(B . "0x6305") ; <CJK>
       (?$(I,q(B . "0x39E8") ; <CJK>
       (?$(I,r(B . "0x6531") ; <CJK>
       (?$(I,s(B . "0x6544") ; <CJK>
       (?$(I,t(B . "0x6540") ; <CJK>
       (?$(I,u(B . "0x3A85") ; <CJK>
       (?$(I,v(B . "0x6542") ; <CJK>
       (?$(I,w(B . "0x65BE") ; <CJK>
       (?$(I,x(B . "0x3AE0") ; <CJK>
       (?$(I,y(B . "0x6629") ; <CJK>
       (?$(I,z(B . "0x661B") ; <CJK>
       (?$(I,{(B . "0x3ADD") ; <CJK>
       (?$(I,|(B . "0x6623") ; <CJK>
       (?$(I,}(B . "0x662C") ; <CJK>
       (?$(I,~(B . "0x661A") ; <CJK>
       (?$(I-!(B . "0x6630") ; <CJK>
       (?$(I-"(B . "0x663B") ; <CJK>
       (?$(I-#(B . "0x661E") ; <CJK>
       (?$(I-$(B . "0x6637") ; <CJK>
       (?$(I-%(B . "0x6638") ; <CJK>
       (?$(I-&(B . "0x3AE1") ; <CJK>
       (?$(I-'(B . "0x670E") ; <CJK>
       (?$(I-((B . "0x3B51") ; <CJK>
       (?$(I-)(B . "0x3B55") ; <CJK>
       (?$(I-*(B . "0x67E8") ; <CJK>
       (?$(I-+(B . "0x67D6") ; <CJK>
       (?$(I-,(B . "0x3B52") ; <CJK>
       (?$(I--(B . "0x67C7") ; <CJK>
       (?$(I-.(B . "0x67BC") ; <CJK>
       (?$(I-/(B . "0x6852") ; <CJK>
       (?$(I-0(B . "0x67BF") ; <CJK>
       (?$(I-1(B . "0x67D5") ; <CJK>
       (?$(I-2(B . "0x67FE") ; <CJK>
       (?$(I-3(B . "0x8363") ; <CJK>
       (?$(I-4(B . "0x67FB") ; <CJK>
       (?$(I-5(B . "0x2F8DF") ; <CJK>
       (?$(I-6(B . "0x67B1") ; <CJK>
       (?$(I-7(B . "0x6801") ; <CJK>
       (?$(I-8(B . "0x6805") ; <CJK>
       (?$(I-9(B . "0x6800") ; <CJK>
       (?$(I-:(B . "0x67D7") ; <CJK>
       (?$(I-;(B . "0x409E") ; <CJK>
       (?$(I-<(B . "0x6B2A") ; <CJK>
       (?$(I-=(B . "0x6B6B") ; <CJK>
       (?$(I->(B . "0x3C52") ; <CJK>
       (?$(I-?(B . "0x3C5E") ; <CJK>
       (?$(I-@(B . "0x3C60") ; <CJK>
       (?$(I-A(B . "0x3C5F") ; <CJK>
       (?$(I-B(B . "0x6BE1") ; <CJK>
       (?$(I-C(B . "0x3C92") ; <CJK>
       (?$(I-D(B . "0x3CD6") ; <CJK>
       (?$(I-E(B . "0x6D23") ; <CJK>
       (?$(I-F(B . "0x6CFF") ; <CJK>
       (?$(I-G(B . "0x6D14") ; <CJK>
       (?$(I-H(B . "0x6D05") ; <CJK>
       (?$(I-I(B . "0x6D13") ; <CJK>
       (?$(I-J(B . "0x6D06") ; <CJK>
       (?$(I-K(B . "0x6D21") ; <CJK>
       (?$(I-L(B . "0x3CDE") ; <CJK>
       (?$(I-M(B . "0x6D15") ; <CJK>
       (?$(I-N(B . "0x6CAF") ; <CJK>
       (?$(I-O(B . "0x6CF4") ; <CJK>
       (?$(I-P(B . "0x6D02") ; <CJK>
       (?$(I-Q(B . "0x6D45") ; <CJK>
       (?$(I-R(B . "0x2F8FE") ; <CJK>
       (?$(I-S(B . "0x6D26") ; <CJK>
       (?$(I-T(B . "0x3CD9") ; <CJK>
       (?$(I-U(B . "0x6D44") ; <CJK>
       (?$(I-V(B . "0x3CDD") ; <CJK>
       (?$(I-W(B . "0x6D24") ; <CJK>
       (?$(I-X(B . "0x70A5") ; <CJK>
       (?$(I-Y(B . "0x3DAC") ; <CJK>
       (?$(I-Z(B . "0x70A3") ; <CJK>
       (?$(I-[(B . "0x3DB0") ; <CJK>
       (?$(I-\(B . "0x70A2") ; <CJK>
       (?$(I-](B . "0x70BB") ; <CJK>
       (?$(I-^(B . "0x70A0") ; <CJK>
       (?$(I-_(B . "0x70AA") ; <CJK>
       (?$(I-`(B . "0x3DAF") ; <CJK>
       (?$(I-a(B . "0x3DAE") ; <CJK>
       (?$(I-b(B . "0x70A8") ; <CJK>
       (?$(I-c(B . "0x70B6") ; <CJK>
       (?$(I-d(B . "0x70B2") ; <CJK>
       (?$(I-e(B . "0x70A7") ; <CJK>
       (?$(I-f(B . "0x3DAD") ; <CJK>
       (?$(I-g(B . "0x3DAB") ; <CJK>
       (?$(I-h(B . "0x70B9") ; <CJK>
       (?$(I-i(B . "0x722E") ; <CJK>
       (?$(I-j(B . "0x3E16") ; <CJK>
       (?$(I-k(B . "0x723C") ; <CJK>
       (?$(I-l(B . "0x3E30") ; <CJK>
       (?$(I-m(B . "0x726D") ; <CJK>
       (?$(I-n(B . "0x3E33") ; <CJK>
       (?$(I-o(B . "0x3E31") ; <CJK>
       (?$(I-p(B . "0x72E7") ; <CJK>
       (?$(I-q(B . "0x72ED") ; <CJK>
       (?$(I-r(B . "0x3E6E") ; <CJK>
       (?$(I-s(B . "0x72EC") ; <CJK>
       (?$(I-t(B . "0x72E5") ; <CJK>
       (?$(I-u(B . "0x72E2") ; <CJK>
       (?$(I-v(B . "0x3EB1") ; <CJK>
       (?$(I-w(B . "0x73C4") ; <CJK>
       (?$(I-x(B . "0x73BD") ; <CJK>
       (?$(I-y(B . "0x73CF") ; <CJK>
       (?$(I-z(B . "0x73C9") ; <CJK>
       (?$(I-{(B . "0x73C1") ; <CJK>
       (?$(I-|(B . "0x73D0") ; <CJK>
       (?$(I-}(B . "0x3EB7") ; <CJK>
       (?$(I-~(B . "0x73CE") ; <CJK>
       (?$(I.!(B . "0x74ED") ; <CJK>
       (?$(I."(B . "0x74EB") ; <CJK>
       (?$(I.#(B . "0x3F1A") ; <CJK>
       (?$(I.$(B . "0x74EF") ; <CJK>
       (?$(I.%(B . "0x7549") ; <CJK>
       (?$(I.&(B . "0x7550") ; <CJK>
       (?$(I.'(B . "0x7546") ; <CJK>
       (?$(I.((B . "0x754A") ; <CJK>
       (?$(I.)(B . "0x3F59") ; <CJK>
       (?$(I.*(B . "0x754D") ; <CJK>
       (?$(I.+(B . "0x75A6") ; <CJK>
       (?$(I.,(B . "0x3F7A") ; <CJK>
       (?$(I.-(B . "0x3F78") ; <CJK>
       (?$(I..(B . "0x3F7B") ; <CJK>
       (?$(I./(B . "0x75A8") ; <CJK>
       (?$(I.0(B . "0x3FDE") ; <CJK>
       (?$(I.1(B . "0x3FEC") ; <CJK>
       (?$(I.2(B . "0x76C7") ; <CJK>
       (?$(I.3(B . "0x76FF") ; <CJK>
       (?$(I.4(B . "0x401E") ; <CJK>
       (?$(I.5(B . "0x76FD") ; <CJK>
       (?$(I.6(B . "0x77E6") ; <CJK>
       (?$(I.7(B . "0x780A") ; <CJK>
       (?$(I.8(B . "0x409B") ; <CJK>
       (?$(I.9(B . "0x7804") ; <CJK>
       (?$(I.:(B . "0x780B") ; <CJK>
       (?$(I.;(B . "0x7807") ; <CJK>
       (?$(I.<(B . "0x409D") ; <CJK>
       (?$(I.=(B . "0x7815") ; <CJK>
       (?$(I.>(B . "0x7808") ; <CJK>
       (?$(I.?(B . "0x40FD") ; <CJK>
       (?$(I.@(B . "0x79D3") ; <CJK>
       (?$(I.A(B . "0x79D4") ; <CJK>
       (?$(I.B(B . "0x79D0") ; <CJK>
       (?$(I.C(B . "0x79D7") ; <CJK>
       (?$(I.D(B . "0x7A7C") ; <CJK>
       (?$(I.E(B . "0x4194") ; <CJK>
       (?$(I.F(B . "0x4193") ; <CJK>
       (?$(I.G(B . "0x7A7D") ; <CJK>
       (?$(I.H(B . "0x7A83") ; <CJK>
       (?$(I.I(B . "0x7A82") ; <CJK>
       (?$(I.J(B . "0x41C6") ; <CJK>
       (?$(I.K(B . "0x7AD4") ; <CJK>
       (?$(I.L(B . "0x7AD5") ; <CJK>
       (?$(I.M(B . "0x7AD3") ; <CJK>
       (?$(I.N(B . "0x7AD0") ; <CJK>
       (?$(I.O(B . "0x7AD2") ; <CJK>
       (?$(I.P(B . "0x7AFE") ; <CJK>
       (?$(I.Q(B . "0x7AFC") ; <CJK>
       (?$(I.R(B . "0x7C77") ; <CJK>
       (?$(I.S(B . "0x7C7C") ; <CJK>
       (?$(I.T(B . "0x7C7B") ; <CJK>
       (?$(I.U(B . "0x42B8") ; <CJK>
       (?$(I.V(B . "0x2F96A") ; <CJK>
       (?$(I.W(B . "0x42B7") ; <CJK>
       (?$(I.X(B . "0x42B9") ; <CJK>
       (?$(I.Y(B . "0x4353") ; <CJK>
       (?$(I.Z(B . "0x25133") ; <CJK>
       (?$(I.[(B . "0x4352") ; <CJK>
       (?$(I.\(B . "0x4351") ; <CJK>
       (?$(I.](B . "0x7F8F") ; <CJK>
       (?$(I.^(B . "0x80D3") ; <CJK>
       (?$(I._(B . "0x43E3") ; <CJK>
       (?$(I.`(B . "0x80CB") ; <CJK>
       (?$(I.a(B . "0x80D2") ; <CJK>
       (?$(I.b(B . "0x43E2") ; <CJK>
       (?$(I.c(B . "0x8109") ; <CJK>
       (?$(I.d(B . "0x80E2") ; <CJK>
       (?$(I.e(B . "0x80DF") ; <CJK>
       (?$(I.f(B . "0x80C6") ; <CJK>
       (?$(I.g(B . "0x4463") ; <CJK>
       (?$(I.h(B . "0x8224") ; <CJK>
       (?$(I.i(B . "0x82F7") ; <CJK>
       (?$(I.j(B . "0x82D8") ; <CJK>
       (?$(I.k(B . "0x82DD") ; <CJK>
       (?$(I.l(B . "0x44AA") ; <CJK>
       (?$(I.m(B . "0x44A6") ; <CJK>
       (?$(I.n(B . "0x82F8") ; <CJK>
       (?$(I.o(B . "0x82FC") ; <CJK>
       (?$(I.p(B . "0x44A8") ; <CJK>
       (?$(I.q(B . "0x44A9") ; <CJK>
       (?$(I.r(B . "0x82E9") ; <CJK>
       (?$(I.s(B . "0x44AB") ; <CJK>
       (?$(I.t(B . "0x82EE") ; <CJK>
       (?$(I.u(B . "0x44AC") ; <CJK>
       (?$(I.v(B . "0x82D0") ; <CJK>
       (?$(I.w(B . "0x830E") ; <CJK>
       (?$(I.x(B . "0x82E2") ; <CJK>
       (?$(I.y(B . "0x830B") ; <CJK>
       (?$(I.z(B . "0x82FD") ; <CJK>
       (?$(I.{(B . "0x5179") ; <CJK>
       (?$(I.|(B . "0x8676") ; <CJK>
       (?$(I.}(B . "0x459E") ; <CJK>
       (?$(I.~(B . "0x8678") ; <CJK>
       (?$(I/!(B . "0x459F") ; <CJK>
       (?$(I/"(B . "0x45A0") ; <CJK>
       (?$(I/#(B . "0x8675") ; <CJK>
       (?$(I/$(B . "0x867D") ; <CJK>
       (?$(I/%(B . "0x460F") ; <CJK>
       (?$(I/&(B . "0x8842") ; <CJK>
       (?$(I/'(B . "0x8866") ; <CJK>
       (?$(I/((B . "0x461C") ; <CJK>
       (?$(I/)(B . "0x898C") ; <CJK>
       (?$(I/*(B . "0x8A05") ; <CJK>
       (?$(I/+(B . "0x46AE") ; <CJK>
       (?$(I/,(B . "0x8A06") ; <CJK>
       (?$(I/-(B . "0x46B0") ; <CJK>
       (?$(I/.(B . "0x8C9F") ; <CJK>
       (?$(I//(B . "0x47D4") ; <CJK>
       (?$(I/0(B . "0x8FF1") ; <CJK>
       (?$(I/1(B . "0x8FE7") ; <CJK>
       (?$(I/2(B . "0x8FE9") ; <CJK>
       (?$(I/3(B . "0x8FEF") ; <CJK>
       (?$(I/4(B . "0x90C2") ; <CJK>
       (?$(I/5(B . "0x90BC") ; <CJK>
       (?$(I/6(B . "0x48BB") ; <CJK>
       (?$(I/7(B . "0x90C6") ; <CJK>
       (?$(I/8(B . "0x90C0") ; <CJK>
       (?$(I/9(B . "0x48C1") ; <CJK>
       (?$(I/:(B . "0x48C2") ; <CJK>
       (?$(I/;(B . "0x90CD") ; <CJK>
       (?$(I/<(B . "0x90C9") ; <CJK>
       (?$(I/=(B . "0x48BE") ; <CJK>
       (?$(I/>(B . "0x90C4") ; <CJK>
       (?$(I/?(B . "0x48E5") ; <CJK>
       (?$(I/@(B . "0x9581") ; <CJK>
       (?$(I/A(B . "0x49C6") ; <CJK>
       (?$(I/B(B . "0x9CEC") ; <CJK>
       (?$(I/C(B . "0x5032") ; <CJK>
       (?$(I/D(B . "0x4FF9") ; <CJK>
       (?$(I/E(B . "0x501D") ; <CJK>
       (?$(I/F(B . "0x4FFF") ; <CJK>
       (?$(I/G(B . "0x5004") ; <CJK>
       (?$(I/H(B . "0x4FF0") ; <CJK>
       (?$(I/I(B . "0x5003") ; <CJK>
       (?$(I/J(B . "0x462E") ; <CJK>
       (?$(I/K(B . "0x5002") ; <CJK>
       (?$(I/L(B . "0x4FFC") ; <CJK>
       (?$(I/M(B . "0x4FF2") ; <CJK>
       (?$(I/N(B . "0x5024") ; <CJK>
       (?$(I/O(B . "0x5008") ; <CJK>
       (?$(I/P(B . "0x5036") ; <CJK>
       (?$(I/Q(B . "0x502E") ; <CJK>
       (?$(I/R(B . "0x3465") ; <CJK>
       (?$(I/S(B . "0x5010") ; <CJK>
       (?$(I/T(B . "0x5038") ; <CJK>
       (?$(I/U(B . "0x5039") ; <CJK>
       (?$(I/V(B . "0x4FFD") ; <CJK>
       (?$(I/W(B . "0x5056") ; <CJK>
       (?$(I/X(B . "0x4FFB") ; <CJK>
       (?$(I/Y(B . "0x51A3") ; <CJK>
       (?$(I/Z(B . "0x51A6") ; <CJK>
       (?$(I/[(B . "0x51A1") ; <CJK>
       (?$(I/\(B . "0x34D1") ; <CJK>
       (?$(I/](B . "0x34D0") ; <CJK>
       (?$(I/^(B . "0x51C7") ; <CJK>
       (?$(I/_(B . "0x51C9") ; <CJK>
       (?$(I/`(B . "0x5260") ; <CJK>
       (?$(I/a(B . "0x5264") ; <CJK>
       (?$(I/b(B . "0x5259") ; <CJK>
       (?$(I/c(B . "0x5265") ; <CJK>
       (?$(I/d(B . "0x5267") ; <CJK>
       (?$(I/e(B . "0x5257") ; <CJK>
       (?$(I/f(B . "0x5263") ; <CJK>
       (?$(I/g(B . "0x34EE") ; <CJK>
       (?$(I/h(B . "0x5253") ; <CJK>
       (?$(I/i(B . "0x34EF") ; <CJK>
       (?$(I/j(B . "0x52CF") ; <CJK>
       (?$(I/k(B . "0x351E") ; <CJK>
       (?$(I/l(B . "0x52CE") ; <CJK>
       (?$(I/m(B . "0x52D0") ; <CJK>
       (?$(I/n(B . "0x52D1") ; <CJK>
       (?$(I/o(B . "0x52CC") ; <CJK>
       (?$(I/p(B . "0x354B") ; <CJK>
       (?$(I/q(B . "0x354D") ; <CJK>
       (?$(I/r(B . "0x3556") ; <CJK>
       (?$(I/s(B . "0x550D") ; <CJK>
       (?$(I/t(B . "0x54F4") ; <CJK>
       (?$(I/u(B . "0x3592") ; <CJK>
       (?$(I/v(B . "0x5513") ; <CJK>
       (?$(I/w(B . "0x54EF") ; <CJK>
       (?$(I/x(B . "0x54F5") ; <CJK>
       (?$(I/y(B . "0x54F9") ; <CJK>
       (?$(I/z(B . "0x5502") ; <CJK>
       (?$(I/{(B . "0x5500") ; <CJK>
       (?$(I/|(B . "0x3593") ; <CJK>
       (?$(I/}(B . "0x3590") ; <CJK>
       (?$(I/~(B . "0x5518") ; <CJK>
       (?$(I0!(B . "0x54F0") ; <CJK>
       (?$(I0"(B . "0x54F6") ; <CJK>
       (?$(I0#(B . "0x2F841") ; <CJK>
       (?$(I0$(B . "0x3597") ; <CJK>
       (?$(I0%(B . "0x5519") ; <CJK>
       (?$(I0&(B . "0x3623") ; <CJK>
       (?$(I0'(B . "0x5705") ; <CJK>
       (?$(I0((B . "0x57C9") ; <CJK>
       (?$(I0)(B . "0x363F") ; <CJK>
       (?$(I0*(B . "0x57B7") ; <CJK>
       (?$(I0+(B . "0x57CD") ; <CJK>
       (?$(I0,(B . "0x3643") ; <CJK>
       (?$(I0-(B . "0x3642") ; <CJK>
       (?$(I0.(B . "0x3644") ; <CJK>
       (?$(I0/(B . "0x57BE") ; <CJK>
       (?$(I00(B . "0x57BB") ; <CJK>
       (?$(I01(B . "0x3645") ; <CJK>
       (?$(I02(B . "0x57DB") ; <CJK>
       (?$(I03(B . "0x57C8") ; <CJK>
       (?$(I04(B . "0x57C4") ; <CJK>
       (?$(I05(B . "0x57C5") ; <CJK>
       (?$(I06(B . "0x57D1") ; <CJK>
       (?$(I07(B . "0x57CA") ; <CJK>
       (?$(I08(B . "0x57C0") ; <CJK>
       (?$(I09(B . "0x36D9") ; <CJK>
       (?$(I0:(B . "0x36DE") ; <CJK>
       (?$(I0;(B . "0x5A21") ; <CJK>
       (?$(I0<(B . "0x5A2A") ; <CJK>
       (?$(I0=(B . "0x36CF") ; <CJK>
       (?$(I0>(B . "0x5A1D") ; <CJK>
       (?$(I0?(B . "0x36CD") ; <CJK>
       (?$(I0@(B . "0x5A0B") ; <CJK>
       (?$(I0A(B . "0x36DD") ; <CJK>
       (?$(I0B(B . "0x36CE") ; <CJK>
       (?$(I0C(B . "0x36D3") ; <CJK>
       (?$(I0D(B . "0x36D6") ; <CJK>
       (?$(I0E(B . "0x5A22") ; <CJK>
       (?$(I0F(B . "0x36DC") ; <CJK>
       (?$(I0G(B . "0x36D1") ; <CJK>
       (?$(I0H(B . "0x5A24") ; <CJK>
       (?$(I0I(B . "0x36D0") ; <CJK>
       (?$(I0J(B . "0x5A14") ; <CJK>
       (?$(I0K(B . "0x5A31") ; <CJK>
       (?$(I0L(B . "0x36D5") ; <CJK>
       (?$(I0M(B . "0x5A2F") ; <CJK>
       (?$(I0N(B . "0x5A1A") ; <CJK>
       (?$(I0O(B . "0x5A12") ; <CJK>
       (?$(I0P(B . "0x36D4") ; <CJK>
       (?$(I0Q(B . "0x36DB") ; <CJK>
       (?$(I0R(B . "0x5A26") ; <CJK>
       (?$(I0S(B . "0x2172E") ; <CJK>
       (?$(I0T(B . "0x3743") ; <CJK>
       (?$(I0U(B . "0x5BBC") ; <CJK>
       (?$(I0V(B . "0x5BBB") ; <CJK>
       (?$(I0W(B . "0x5BB7") ; <CJK>
       (?$(I0X(B . "0x5C05") ; <CJK>
       (?$(I0Y(B . "0x5C06") ; <CJK>
       (?$(I0Z(B . "0x5C52") ; <CJK>
       (?$(I0[(B . "0x5C53") ; <CJK>
       (?$(I0\(B . "0x37CD") ; <CJK>
       (?$(I0](B . "0x37D1") ; <CJK>
       (?$(I0^(B . "0x5CFA") ; <CJK>
       (?$(I0_(B . "0x5CEB") ; <CJK>
       (?$(I0`(B . "0x37CA") ; <CJK>
       (?$(I0a(B . "0x5CF3") ; <CJK>
       (?$(I0b(B . "0x5CF5") ; <CJK>
       (?$(I0c(B . "0x5CE9") ; <CJK>
       (?$(I0d(B . "0x5CEF") ; <CJK>
       (?$(I0e(B . "0x37D4") ; <CJK>
       (?$(I0f(B . "0x5E2A") ; <CJK>
       (?$(I0g(B . "0x5E30") ; <CJK>
       (?$(I0h(B . "0x5E2E") ; <CJK>
       (?$(I0i(B . "0x5E2C") ; <CJK>
       (?$(I0j(B . "0x5E2F") ; <CJK>
       (?$(I0k(B . "0x5EAF") ; <CJK>
       (?$(I0l(B . "0x5EA9") ; <CJK>
       (?$(I0m(B . "0x3886") ; <CJK>
       (?$(I0n(B . "0x5EFD") ; <CJK>
       (?$(I0o(B . "0x5F32") ; <CJK>
       (?$(I0p(B . "0x5F8E") ; <CJK>
       (?$(I0q(B . "0x5F93") ; <CJK>
       (?$(I0r(B . "0x5F8F") ; <CJK>
       (?$(I0s(B . "0x604F") ; <CJK>
       (?$(I0t(B . "0x6099") ; <CJK>
       (?$(I0u(B . "0x3933") ; <CJK>
       (?$(I0v(B . "0x607E") ; <CJK>
       (?$(I0w(B . "0x3937") ; <CJK>
       (?$(I0x(B . "0x6074") ; <CJK>
       (?$(I0y(B . "0x604B") ; <CJK>
       (?$(I0z(B . "0x6073") ; <CJK>
       (?$(I0{(B . "0x6075") ; <CJK>
       (?$(I0|(B . "0x392A") ; <CJK>
       (?$(I0}(B . "0x391F") ; <CJK>
       (?$(I0~(B . "0x6056") ; <CJK>
       (?$(I1!(B . "0x60A9") ; <CJK>
       (?$(I1"(B . "0x608B") ; <CJK>
       (?$(I1#(B . "0x60A6") ; <CJK>
       (?$(I1$(B . "0x3939") ; <CJK>
       (?$(I1%(B . "0x6093") ; <CJK>
       (?$(I1&(B . "0x60AE") ; <CJK>
       (?$(I1'(B . "0x609E") ; <CJK>
       (?$(I1((B . "0x60A7") ; <CJK>
       (?$(I1)(B . "0x6245") ; <CJK>
       (?$(I1*(B . "0x39F2") ; <CJK>
       (?$(I1+(B . "0x39F8") ; <CJK>
       (?$(I1,(B . "0x632E") ; <CJK>
       (?$(I1-(B . "0x39F7") ; <CJK>
       (?$(I1.(B . "0x6352") ; <CJK>
       (?$(I1/(B . "0x6330") ; <CJK>
       (?$(I10(B . "0x635B") ; <CJK>
       (?$(I11(B . "0x39F4") ; <CJK>
       (?$(I12(B . "0x6319") ; <CJK>
       (?$(I13(B . "0x631B") ; <CJK>
       (?$(I14(B . "0x39F1") ; <CJK>
       (?$(I15(B . "0x6331") ; <CJK>
       (?$(I16(B . "0x635D") ; <CJK>
       (?$(I17(B . "0x6337") ; <CJK>
       (?$(I18(B . "0x6335") ; <CJK>
       (?$(I19(B . "0x6353") ; <CJK>
       (?$(I1:(B . "0x39F5") ; <CJK>
       (?$(I1;(B . "0x635C") ; <CJK>
       (?$(I1<(B . "0x633F") ; <CJK>
       (?$(I1=(B . "0x654B") ; <CJK>
       (?$(I1>(B . "0x3A87") ; <CJK>
       (?$(I1?(B . "0x4369") ; <CJK>
       (?$(I1@(B . "0x658B") ; <CJK>
       (?$(I1A(B . "0x3AB6") ; <CJK>
       (?$(I1B(B . "0x659A") ; <CJK>
       (?$(I1C(B . "0x6650") ; <CJK>
       (?$(I1D(B . "0x6646") ; <CJK>
       (?$(I1E(B . "0x664E") ; <CJK>
       (?$(I1F(B . "0x6640") ; <CJK>
       (?$(I1G(B . "0x3AE9") ; <CJK>
       (?$(I1H(B . "0x664B") ; <CJK>
       (?$(I1I(B . "0x6648") ; <CJK>
       (?$(I1J(B . "0x3AEB") ; <CJK>
       (?$(I1K(B . "0x6660") ; <CJK>
       (?$(I1L(B . "0x6644") ; <CJK>
       (?$(I1M(B . "0x664D") ; <CJK>
       (?$(I1N(B . "0x3B34") ; <CJK>
       (?$(I1O(B . "0x6837") ; <CJK>
       (?$(I1P(B . "0x6824") ; <CJK>
       (?$(I1Q(B . "0x3B62") ; <CJK>
       (?$(I1R(B . "0x3B5C") ; <CJK>
       (?$(I1S(B . "0x681B") ; <CJK>
       (?$(I1T(B . "0x6836") ; <CJK>
       (?$(I1U(B . "0x3B60") ; <CJK>
       (?$(I1V(B . "0x682C") ; <CJK>
       (?$(I1W(B . "0x6819") ; <CJK>
       (?$(I1X(B . "0x6856") ; <CJK>
       (?$(I1Y(B . "0x6847") ; <CJK>
       (?$(I1Z(B . "0x683E") ; <CJK>
       (?$(I1[(B . "0x681E") ; <CJK>
       (?$(I1\(B . "0x2F8E1") ; <CJK>
       (?$(I1](B . "0x6815") ; <CJK>
       (?$(I1^(B . "0x6822") ; <CJK>
       (?$(I1_(B . "0x6827") ; <CJK>
       (?$(I1`(B . "0x6859") ; <CJK>
       (?$(I1a(B . "0x6858") ; <CJK>
       (?$(I1b(B . "0x6855") ; <CJK>
       (?$(I1c(B . "0x6830") ; <CJK>
       (?$(I1d(B . "0x6823") ; <CJK>
       (?$(I1e(B . "0x6B2E") ; <CJK>
       (?$(I1f(B . "0x6B2B") ; <CJK>
       (?$(I1g(B . "0x6B30") ; <CJK>
       (?$(I1h(B . "0x6B6C") ; <CJK>
       (?$(I1i(B . "0x3C61") ; <CJK>
       (?$(I1j(B . "0x6B8B") ; <CJK>
       (?$(I1k(B . "0x3C7F") ; <CJK>
       (?$(I1l(B . "0x6BE9") ; <CJK>
       (?$(I1m(B . "0x6BEA") ; <CJK>
       (?$(I1n(B . "0x6BE5") ; <CJK>
       (?$(I1o(B . "0x6D6B") ; <CJK>
       (?$(I1p(B . "0x3CE5") ; <CJK>
       (?$(I1q(B . "0x3CE6") ; <CJK>
       (?$(I1r(B . "0x6D73") ; <CJK>
       (?$(I1s(B . "0x6D57") ; <CJK>
       (?$(I1t(B . "0x3CE9") ; <CJK>
       (?$(I1u(B . "0x3CF3") ; <CJK>
       (?$(I1v(B . "0x6D5D") ; <CJK>
       (?$(I1w(B . "0x6D56") ; <CJK>
       (?$(I1x(B . "0x6D8F") ; <CJK>
       (?$(I1y(B . "0x6D5B") ; <CJK>
       (?$(I1z(B . "0x6D1C") ; <CJK>
       (?$(I1{(B . "0x6D9A") ; <CJK>
       (?$(I1|(B . "0x6D9B") ; <CJK>
       (?$(I1}(B . "0x6D99") ; <CJK>
       (?$(I1~(B . "0x3CEE") ; <CJK>
       (?$(I2!(B . "0x6D81") ; <CJK>
       (?$(I2"(B . "0x6D71") ; <CJK>
       (?$(I2#(B . "0x3CED") ; <CJK>
       (?$(I2$(B . "0x3CEC") ; <CJK>
       (?$(I2%(B . "0x6D72") ; <CJK>
       (?$(I2&(B . "0x6D5C") ; <CJK>
       (?$(I2'(B . "0x6D96") ; <CJK>
       (?$(I2((B . "0x70C4") ; <CJK>
       (?$(I2)(B . "0x70DB") ; <CJK>
       (?$(I2*(B . "0x70CC") ; <CJK>
       (?$(I2+(B . "0x70D0") ; <CJK>
       (?$(I2,(B . "0x70E3") ; <CJK>
       (?$(I2-(B . "0x70DF") ; <CJK>
       (?$(I2.(B . "0x3DB3") ; <CJK>
       (?$(I2/(B . "0x70D6") ; <CJK>
       (?$(I20(B . "0x70EE") ; <CJK>
       (?$(I21(B . "0x70D5") ; <CJK>
       (?$(I22(B . "0x3DB5") ; <CJK>
       (?$(I23(B . "0x3E27") ; <CJK>
       (?$(I24(B . "0x3E35") ; <CJK>
       (?$(I25(B . "0x3E36") ; <CJK>
       (?$(I26(B . "0x727A") ; <CJK>
       (?$(I27(B . "0x3E71") ; <CJK>
       (?$(I28(B . "0x72F5") ; <CJK>
       (?$(I29(B . "0x7302") ; <CJK>
       (?$(I2:(B . "0x3EB8") ; <CJK>
       (?$(I2;(B . "0x3EC2") ; <CJK>
       (?$(I2<(B . "0x73E2") ; <CJK>
       (?$(I2=(B . "0x73EC") ; <CJK>
       (?$(I2>(B . "0x73D5") ; <CJK>
       (?$(I2?(B . "0x73F9") ; <CJK>
       (?$(I2@(B . "0x73DF") ; <CJK>
       (?$(I2A(B . "0x73E6") ; <CJK>
       (?$(I2B(B . "0x3EC8") ; <CJK>
       (?$(I2C(B . "0x3EC0") ; <CJK>
       (?$(I2D(B . "0x3EC1") ; <CJK>
       (?$(I2E(B . "0x3EC4") ; <CJK>
       (?$(I2F(B . "0x73E4") ; <CJK>
       (?$(I2G(B . "0x73E1") ; <CJK>
       (?$(I2H(B . "0x74F3") ; <CJK>
       (?$(I2I(B . "0x3F1F") ; <CJK>
       (?$(I2J(B . "0x3F1C") ; <CJK>
       (?$(I2K(B . "0x3F1D") ; <CJK>
       (?$(I2L(B . "0x3F4D") ; <CJK>
       (?$(I2M(B . "0x7556") ; <CJK>
       (?$(I2N(B . "0x7555") ; <CJK>
       (?$(I2O(B . "0x7558") ; <CJK>
       (?$(I2P(B . "0x7557") ; <CJK>
       (?$(I2Q(B . "0x755E") ; <CJK>
       (?$(I2R(B . "0x75C3") ; <CJK>
       (?$(I2S(B . "0x3F87") ; <CJK>
       (?$(I2T(B . "0x3F82") ; <CJK>
       (?$(I2U(B . "0x75B4") ; <CJK>
       (?$(I2V(B . "0x3F7D") ; <CJK>
       (?$(I2W(B . "0x75B1") ; <CJK>
       (?$(I2X(B . "0x3FDF") ; <CJK>
       (?$(I2Y(B . "0x4000") ; <CJK>
       (?$(I2Z(B . "0x76CB") ; <CJK>
       (?$(I2[(B . "0x76CC") ; <CJK>
       (?$(I2\(B . "0x772A") ; <CJK>
       (?$(I2](B . "0x4020") ; <CJK>
       (?$(I2^(B . "0x7716") ; <CJK>
       (?$(I2_(B . "0x770F") ; <CJK>
       (?$(I2`(B . "0x4022") ; <CJK>
       (?$(I2a(B . "0x4024") ; <CJK>
       (?$(I2b(B . "0x773F") ; <CJK>
       (?$(I2c(B . "0x772B") ; <CJK>
       (?$(I2d(B . "0x770E") ; <CJK>
       (?$(I2e(B . "0x7724") ; <CJK>
       (?$(I2f(B . "0x4021") ; <CJK>
       (?$(I2g(B . "0x7721") ; <CJK>
       (?$(I2h(B . "0x7718") ; <CJK>
       (?$(I2i(B . "0x77DD") ; <CJK>
       (?$(I2j(B . "0x40A4") ; <CJK>
       (?$(I2k(B . "0x40A5") ; <CJK>
       (?$(I2l(B . "0x7824") ; <CJK>
       (?$(I2m(B . "0x7836") ; <CJK>
       (?$(I2n(B . "0x4101") ; <CJK>
       (?$(I2o(B . "0x7958") ; <CJK>
       (?$(I2p(B . "0x7959") ; <CJK>
       (?$(I2q(B . "0x4103") ; <CJK>
       (?$(I2r(B . "0x7962") ; <CJK>
       (?$(I2s(B . "0x79DA") ; <CJK>
       (?$(I2t(B . "0x79D9") ; <CJK>
       (?$(I2u(B . "0x4137") ; <CJK>
       (?$(I2v(B . "0x79E1") ; <CJK>
       (?$(I2w(B . "0x79E5") ; <CJK>
       (?$(I2x(B . "0x79E8") ; <CJK>
       (?$(I2y(B . "0x79DB") ; <CJK>
       (?$(I2z(B . "0x4138") ; <CJK>
       (?$(I2{(B . "0x79E2") ; <CJK>
       (?$(I2|(B . "0x79F0") ; <CJK>
       (?$(I2}(B . "0x4199") ; <CJK>
       (?$(I2~(B . "0x4198") ; <CJK>
       (?$(I3!(B . "0x4197") ; <CJK>
       (?$(I3"(B . "0x41C9") ; <CJK>
       (?$(I3#(B . "0x7ADA") ; <CJK>
       (?$(I3$(B . "0x7ADD") ; <CJK>
       (?$(I3%(B . "0x41C7") ; <CJK>
       (?$(I3&(B . "0x7ADB") ; <CJK>
       (?$(I3'(B . "0x7ADC") ; <CJK>
       (?$(I3((B . "0x41D9") ; <CJK>
       (?$(I3)(B . "0x41DB") ; <CJK>
       (?$(I3*(B . "0x7B0D") ; <CJK>
       (?$(I3+(B . "0x7B0B") ; <CJK>
       (?$(I3,(B . "0x7B14") ; <CJK>
       (?$(I3-(B . "0x7C8E") ; <CJK>
       (?$(I3.(B . "0x7C86") ; <CJK>
       (?$(I3/(B . "0x427B") ; <CJK>
       (?$(I30(B . "0x7C87") ; <CJK>
       (?$(I31(B . "0x7C83") ; <CJK>
       (?$(I32(B . "0x7C8B") ; <CJK>
       (?$(I33(B . "0x427C") ; <CJK>
       (?$(I34(B . "0x42BD") ; <CJK>
       (?$(I35(B . "0x42BC") ; <CJK>
       (?$(I36(B . "0x42C3") ; <CJK>
       (?$(I37(B . "0x7D24") ; <CJK>
       (?$(I38(B . "0x42C1") ; <CJK>
       (?$(I39(B . "0x42BF") ; <CJK>
       (?$(I3:(B . "0x42C4") ; <CJK>
       (?$(I3;(B . "0x7D25") ; <CJK>
       (?$(I3<(B . "0x7F62") ; <CJK>
       (?$(I3=(B . "0x7F93") ; <CJK>
       (?$(I3>(B . "0x7F99") ; <CJK>
       (?$(I3?(B . "0x7F97") ; <CJK>
       (?$(I3@(B . "0x437E") ; <CJK>
       (?$(I3A(B . "0x437F") ; <CJK>
       (?$(I3B(B . "0x7FC4") ; <CJK>
       (?$(I3C(B . "0x7FC6") ; <CJK>
       (?$(I3D(B . "0x800A") ; <CJK>
       (?$(I3E(B . "0x43B4") ; <CJK>
       (?$(I3F(B . "0x43B3") ; <CJK>
       (?$(I3G(B . "0x8040") ; <CJK>
       (?$(I3H(B . "0x803C") ; <CJK>
       (?$(I3I(B . "0x803B") ; <CJK>
       (?$(I3J(B . "0x80F6") ; <CJK>
       (?$(I3K(B . "0x80FF") ; <CJK>
       (?$(I3L(B . "0x80EE") ; <CJK>
       (?$(I3M(B . "0x8104") ; <CJK>
       (?$(I3N(B . "0x8103") ; <CJK>
       (?$(I3O(B . "0x8107") ; <CJK>
       (?$(I3P(B . "0x2F983") ; <CJK>
       (?$(I3Q(B . "0x43E6") ; <CJK>
       (?$(I3R(B . "0x80F7") ; <CJK>
       (?$(I3S(B . "0x4459") ; <CJK>
       (?$(I3T(B . "0x445A") ; <CJK>
       (?$(I3U(B . "0x822D") ; <CJK>
       (?$(I3V(B . "0x4464") ; <CJK>
       (?$(I3W(B . "0x8227") ; <CJK>
       (?$(I3X(B . "0x8229") ; <CJK>
       (?$(I3Y(B . "0x831F") ; <CJK>
       (?$(I3Z(B . "0x8357") ; <CJK>
       (?$(I3[(B . "0x44B4") ; <CJK>
       (?$(I3\(B . "0x44B9") ; <CJK>
       (?$(I3](B . "0x44B7") ; <CJK>
       (?$(I3^(B . "0x44B5") ; <CJK>
       (?$(I3_(B . "0x8321") ; <CJK>
       (?$(I3`(B . "0x44C1") ; <CJK>
       (?$(I3a(B . "0x44B1") ; <CJK>
       (?$(I3b(B . "0x8318") ; <CJK>
       (?$(I3c(B . "0x8358") ; <CJK>
       (?$(I3d(B . "0x44B3") ; <CJK>
       (?$(I3e(B . "0x44BA") ; <CJK>
       (?$(I3f(B . "0x458C") ; <CJK>
       (?$(I3g(B . "0x458B") ; <CJK>
       (?$(I3h(B . "0x458D") ; <CJK>
       (?$(I3i(B . "0x8684") ; <CJK>
       (?$(I3j(B . "0x869F") ; <CJK>
       (?$(I3k(B . "0x869B") ; <CJK>
       (?$(I3l(B . "0x8689") ; <CJK>
       (?$(I3m(B . "0x86A6") ; <CJK>
       (?$(I3n(B . "0x8692") ; <CJK>
       (?$(I3o(B . "0x868F") ; <CJK>
       (?$(I3p(B . "0x86A0") ; <CJK>
       (?$(I3q(B . "0x884F") ; <CJK>
       (?$(I3r(B . "0x8878") ; <CJK>
       (?$(I3s(B . "0x887A") ; <CJK>
       (?$(I3t(B . "0x886E") ; <CJK>
       (?$(I3u(B . "0x887B") ; <CJK>
       (?$(I3v(B . "0x8884") ; <CJK>
       (?$(I3w(B . "0x8873") ; <CJK>
       (?$(I3x(B . "0x4678") ; <CJK>
       (?$(I3y(B . "0x4677") ; <CJK>
       (?$(I3z(B . "0x8A0D") ; <CJK>
       (?$(I3{(B . "0x8A0B") ; <CJK>
       (?$(I3|(B . "0x8A19") ; <CJK>
       (?$(I3}(B . "0x46B2") ; <CJK>
       (?$(I3~(B . "0x47D6") ; <CJK>
       (?$(I4!(B . "0x8ED0") ; <CJK>
       (?$(I4"(B . "0x4845") ; <CJK>
       (?$(I4#(B . "0x4892") ; <CJK>
       (?$(I4$(B . "0x4895") ; <CJK>
       (?$(I4%(B . "0x8FF9") ; <CJK>
       (?$(I4&(B . "0x9009") ; <CJK>
       (?$(I4'(B . "0x9008") ; <CJK>
       (?$(I4((B . "0x48C6") ; <CJK>
       (?$(I4)(B . "0x90DE") ; <CJK>
       (?$(I4*(B . "0x9151") ; <CJK>
       (?$(I4+(B . "0x48E7") ; <CJK>
       (?$(I4,(B . "0x48E8") ; <CJK>
       (?$(I4-(B . "0x91DB") ; <CJK>
       (?$(I4.(B . "0x91DF") ; <CJK>
       (?$(I4/(B . "0x91DE") ; <CJK>
       (?$(I40(B . "0x91D6") ; <CJK>
       (?$(I41(B . "0x91E0") ; <CJK>
       (?$(I42(B . "0x9585") ; <CJK>
       (?$(I43(B . "0x9660") ; <CJK>
       (?$(I44(B . "0x9659") ; <CJK>
       (?$(I45(B . "0x49CB") ; <CJK>
       (?$(I46(B . "0x9656") ; <CJK>
       (?$(I47(B . "0x49CD") ; <CJK>
       (?$(I48(B . "0x49F1") ; <CJK>
       (?$(I49(B . "0x96BD") ; <CJK>
       (?$(I4:(B . "0x4B22") ; <CJK>
       (?$(I4;(B . "0x3421") ; <CJK>
       (?$(I4<(B . "0x5042") ; <CJK>
       (?$(I4=(B . "0x5059") ; <CJK>
       (?$(I4>(B . "0x346F") ; <CJK>
       (?$(I4?(B . "0x5044") ; <CJK>
       (?$(I4@(B . "0x5066") ; <CJK>
       (?$(I4A(B . "0x5052") ; <CJK>
       (?$(I4B(B . "0x5054") ; <CJK>
       (?$(I4C(B . "0x5071") ; <CJK>
       (?$(I4D(B . "0x5050") ; <CJK>
       (?$(I4E(B . "0x507B") ; <CJK>
       (?$(I4F(B . "0x507C") ; <CJK>
       (?$(I4G(B . "0x5058") ; <CJK>
       (?$(I4H(B . "0x3470") ; <CJK>
       (?$(I4I(B . "0x3464") ; <CJK>
       (?$(I4J(B . "0x5079") ; <CJK>
       (?$(I4K(B . "0x506C") ; <CJK>
       (?$(I4L(B . "0x5078") ; <CJK>
       (?$(I4M(B . "0x51A8") ; <CJK>
       (?$(I4N(B . "0x51D1") ; <CJK>
       (?$(I4O(B . "0x51CF") ; <CJK>
       (?$(I4P(B . "0x5268") ; <CJK>
       (?$(I4Q(B . "0x5276") ; <CJK>
       (?$(I4R(B . "0x52D4") ; <CJK>
       (?$(I4S(B . "0x352D") ; <CJK>
       (?$(I4T(B . "0x53A0") ; <CJK>
       (?$(I4U(B . "0x53C4") ; <CJK>
       (?$(I4V(B . "0x3558") ; <CJK>
       (?$(I4W(B . "0x5558") ; <CJK>
       (?$(I4X(B . "0x554C") ; <CJK>
       (?$(I4Y(B . "0x5568") ; <CJK>
       (?$(I4Z(B . "0x35A6") ; <CJK>
       (?$(I4[(B . "0x5549") ; <CJK>
       (?$(I4\(B . "0x35A4") ; <CJK>
       (?$(I4](B . "0x359F") ; <CJK>
       (?$(I4^(B . "0x555D") ; <CJK>
       (?$(I4_(B . "0x5529") ; <CJK>
       (?$(I4`(B . "0x20DAE") ; <CJK>
       (?$(I4a(B . "0x5554") ; <CJK>
       (?$(I4b(B . "0x5553") ; <CJK>
       (?$(I4c(B . "0x35A3") ; <CJK>
       (?$(I4d(B . "0x555A") ; <CJK>
       (?$(I4e(B . "0x35A0") ; <CJK>
       (?$(I4f(B . "0x553A") ; <CJK>
       (?$(I4g(B . "0x553F") ; <CJK>
       (?$(I4h(B . "0x552B") ; <CJK>
       (?$(I4i(B . "0x57EA") ; <CJK>
       (?$(I4j(B . "0x364A") ; <CJK>
       (?$(I4k(B . "0x57EF") ; <CJK>
       (?$(I4l(B . "0x3647") ; <CJK>
       (?$(I4m(B . "0x3648") ; <CJK>
       (?$(I4n(B . "0x57DD") ; <CJK>
       (?$(I4o(B . "0x57FE") ; <CJK>
       (?$(I4p(B . "0x2F855") ; <CJK>
       (?$(I4q(B . "0x57DE") ; <CJK>
       (?$(I4r(B . "0x57E6") ; <CJK>
       (?$(I4s(B . "0x3649") ; <CJK>
       (?$(I4t(B . "0x57E8") ; <CJK>
       (?$(I4u(B . "0x57FF") ; <CJK>
       (?$(I4v(B . "0x5803") ; <CJK>
       (?$(I4w(B . "0x58F7") ; <CJK>
       (?$(I4x(B . "0x68A6") ; <CJK>
       (?$(I4y(B . "0x591F") ; <CJK>
       (?$(I4z(B . "0x369E") ; <CJK>
       (?$(I4{(B . "0x595B") ; <CJK>
       (?$(I4|(B . "0x595D") ; <CJK>
       (?$(I4}(B . "0x595E") ; <CJK>
       (?$(I4~(B . "0x21637") ; <CJK>
       (?$(I5!(B . "0x36E8") ; <CJK>
       (?$(I5"(B . "0x5A2B") ; <CJK>
       (?$(I5#(B . "0x36EC") ; <CJK>
       (?$(I5$(B . "0x5A3B") ; <CJK>
       (?$(I5%(B . "0x36ED") ; <CJK>
       (?$(I5&(B . "0x36E6") ; <CJK>
       (?$(I5'(B . "0x5A61") ; <CJK>
       (?$(I5((B . "0x5A3A") ; <CJK>
       (?$(I5)(B . "0x5A6E") ; <CJK>
       (?$(I5*(B . "0x5A4B") ; <CJK>
       (?$(I5+(B . "0x5A6B") ; <CJK>
       (?$(I5,(B . "0x36EB") ; <CJK>
       (?$(I5-(B . "0x36E7") ; <CJK>
       (?$(I5.(B . "0x5A45") ; <CJK>
       (?$(I5/(B . "0x5A4E") ; <CJK>
       (?$(I50(B . "0x5A68") ; <CJK>
       (?$(I51(B . "0x5A3D") ; <CJK>
       (?$(I52(B . "0x5A71") ; <CJK>
       (?$(I53(B . "0x5A3F") ; <CJK>
       (?$(I54(B . "0x5A6F") ; <CJK>
       (?$(I55(B . "0x5A75") ; <CJK>
       (?$(I56(B . "0x36E9") ; <CJK>
       (?$(I57(B . "0x5A73") ; <CJK>
       (?$(I58(B . "0x5A2C") ; <CJK>
       (?$(I59(B . "0x5A59") ; <CJK>
       (?$(I5:(B . "0x5A54") ; <CJK>
       (?$(I5;(B . "0x5A4F") ; <CJK>
       (?$(I5<(B . "0x5A63") ; <CJK>
       (?$(I5=(B . "0x375C") ; <CJK>
       (?$(I5>(B . "0x375D") ; <CJK>
       (?$(I5?(B . "0x5BC8") ; <CJK>
       (?$(I5@(B . "0x3760") ; <CJK>
       (?$(I5A(B . "0x5BC3") ; <CJK>
       (?$(I5B(B . "0x375B") ; <CJK>
       (?$(I5C(B . "0x5C5B") ; <CJK>
       (?$(I5D(B . "0x5C61") ; <CJK>
       (?$(I5E(B . "0x3799") ; <CJK>
       (?$(I5F(B . "0x5D21") ; <CJK>
       (?$(I5G(B . "0x5D0A") ; <CJK>
       (?$(I5H(B . "0x5D09") ; <CJK>
       (?$(I5I(B . "0x37D8") ; <CJK>
       (?$(I5J(B . "0x5D2C") ; <CJK>
       (?$(I5K(B . "0x5D08") ; <CJK>
       (?$(I5L(B . "0x37DA") ; <CJK>
       (?$(I5M(B . "0x37DD") ; <CJK>
       (?$(I5N(B . "0x5D2A") ; <CJK>
       (?$(I5O(B . "0x5D15") ; <CJK>
       (?$(I5P(B . "0x37E0") ; <CJK>
       (?$(I5Q(B . "0x5D10") ; <CJK>
       (?$(I5R(B . "0x5D13") ; <CJK>
       (?$(I5S(B . "0x37E5") ; <CJK>
       (?$(I5T(B . "0x5D2F") ; <CJK>
       (?$(I5U(B . "0x5D18") ; <CJK>
       (?$(I5V(B . "0x37D7") ; <CJK>
       (?$(I5W(B . "0x5DE3") ; <CJK>
       (?$(I5X(B . "0x5E39") ; <CJK>
       (?$(I5Y(B . "0x5E35") ; <CJK>
       (?$(I5Z(B . "0x5E3A") ; <CJK>
       (?$(I5[(B . "0x5E32") ; <CJK>
       (?$(I5\(B . "0x384E") ; <CJK>
       (?$(I5](B . "0x388C") ; <CJK>
       (?$(I5^(B . "0x3888") ; <CJK>
       (?$(I5_(B . "0x2F88D") ; <CJK>
       (?$(I5`(B . "0x5EBB") ; <CJK>
       (?$(I5a(B . "0x5EBA") ; <CJK>
       (?$(I5b(B . "0x5F34") ; <CJK>
       (?$(I5c(B . "0x5F39") ; <CJK>
       (?$(I5d(B . "0x38CE") ; <CJK>
       (?$(I5e(B . "0x2F89C") ; <CJK>
       (?$(I5f(B . "0x38E5") ; <CJK>
       (?$(I5g(B . "0x38E6") ; <CJK>
       (?$(I5h(B . "0x6098") ; <CJK>
       (?$(I5i(B . "0x3932") ; <CJK>
       (?$(I5j(B . "0x60D0") ; <CJK>
       (?$(I5k(B . "0x3940") ; <CJK>
       (?$(I5l(B . "0x3947") ; <CJK>
       (?$(I5m(B . "0x394C") ; <CJK>
       (?$(I5n(B . "0x60D7") ; <CJK>
       (?$(I5o(B . "0x60AA") ; <CJK>
       (?$(I5p(B . "0x3935") ; <CJK>
       (?$(I5q(B . "0x60A1") ; <CJK>
       (?$(I5r(B . "0x60A4") ; <CJK>
       (?$(I5s(B . "0x3930") ; <CJK>
       (?$(I5t(B . "0x60EE") ; <CJK>
       (?$(I5u(B . "0x3943") ; <CJK>
       (?$(I5v(B . "0x60E7") ; <CJK>
       (?$(I5w(B . "0x394D") ; <CJK>
       (?$(I5x(B . "0x60E8") ; <CJK>
       (?$(I5y(B . "0x60DE") ; <CJK>
       (?$(I5z(B . "0x39B7") ; <CJK>
       (?$(I5{(B . "0x39F3") ; <CJK>
       (?$(I5|(B . "0x637E") ; <CJK>
       (?$(I5}(B . "0x638B") ; <CJK>
       (?$(I5~(B . "0x3A02") ; <CJK>
       (?$(I6!(B . "0x3A0B") ; <CJK>
       (?$(I6"(B . "0x6379") ; <CJK>
       (?$(I6#(B . "0x6386") ; <CJK>
       (?$(I6$(B . "0x6393") ; <CJK>
       (?$(I6%(B . "0x3A04") ; <CJK>
       (?$(I6&(B . "0x6373") ; <CJK>
       (?$(I6'(B . "0x636A") ; <CJK>
       (?$(I6((B . "0x2F8BA") ; <CJK>
       (?$(I6)(B . "0x636C") ; <CJK>
       (?$(I6*(B . "0x3A08") ; <CJK>
       (?$(I6+(B . "0x637F") ; <CJK>
       (?$(I6,(B . "0x39FC") ; <CJK>
       (?$(I6-(B . "0x63B2") ; <CJK>
       (?$(I6.(B . "0x63BA") ; <CJK>
       (?$(I6/(B . "0x39FF") ; <CJK>
       (?$(I60(B . "0x3A00") ; <CJK>
       (?$(I61(B . "0x6366") ; <CJK>
       (?$(I62(B . "0x6374") ; <CJK>
       (?$(I63(B . "0x3A8B") ; <CJK>
       (?$(I64(B . "0x655A") ; <CJK>
       (?$(I65(B . "0x3A8D") ; <CJK>
       (?$(I66(B . "0x654E") ; <CJK>
       (?$(I67(B . "0x654D") ; <CJK>
       (?$(I68(B . "0x658D") ; <CJK>
       (?$(I69(B . "0x658E") ; <CJK>
       (?$(I6:(B . "0x65AD") ; <CJK>
       (?$(I6;(B . "0x3ACA") ; <CJK>
       (?$(I6<(B . "0x65C7") ; <CJK>
       (?$(I6=(B . "0x65CA") ; <CJK>
       (?$(I6>(B . "0x3ACB") ; <CJK>
       (?$(I6?(B . "0x65C9") ; <CJK>
       (?$(I6@(B . "0x2F8CB") ; <CJK>
       (?$(I6A(B . "0x65E3") ; <CJK>
       (?$(I6B(B . "0x6657") ; <CJK>
       (?$(I6C(B . "0x3AF3") ; <CJK>
       (?$(I6D(B . "0x6663") ; <CJK>
       (?$(I6E(B . "0x6667") ; <CJK>
       (?$(I6F(B . "0x671A") ; <CJK>
       (?$(I6G(B . "0x6719") ; <CJK>
       (?$(I6H(B . "0x6716") ; <CJK>
       (?$(I6I(B . "0x3B36") ; <CJK>
       (?$(I6J(B . "0x3B6A") ; <CJK>
       (?$(I6K(B . "0x689E") ; <CJK>
       (?$(I6L(B . "0x68B6") ; <CJK>
       (?$(I6M(B . "0x6898") ; <CJK>
       (?$(I6N(B . "0x6873") ; <CJK>
       (?$(I6O(B . "0x3B6B") ; <CJK>
       (?$(I6P(B . "0x689A") ; <CJK>
       (?$(I6Q(B . "0x688E") ; <CJK>
       (?$(I6R(B . "0x68B7") ; <CJK>
       (?$(I6S(B . "0x68DB") ; <CJK>
       (?$(I6T(B . "0x68A5") ; <CJK>
       (?$(I6U(B . "0x686C") ; <CJK>
       (?$(I6V(B . "0x68C1") ; <CJK>
       (?$(I6W(B . "0x6884") ; <CJK>
       (?$(I6X(B . "0x3B71") ; <CJK>
       (?$(I6Y(B . "0x3B68") ; <CJK>
       (?$(I6Z(B . "0x6895") ; <CJK>
       (?$(I6[(B . "0x687A") ; <CJK>
       (?$(I6\(B . "0x6899") ; <CJK>
       (?$(I6](B . "0x3B72") ; <CJK>
       (?$(I6^(B . "0x68B8") ; <CJK>
       (?$(I6_(B . "0x68B9") ; <CJK>
       (?$(I6`(B . "0x6870") ; <CJK>
       (?$(I6a(B . "0x3C2E") ; <CJK>
       (?$(I6b(B . "0x6B35") ; <CJK>
       (?$(I6c(B . "0x3C62") ; <CJK>
       (?$(I6d(B . "0x6B90") ; <CJK>
       (?$(I6e(B . "0x6BBB") ; <CJK>
       (?$(I6f(B . "0x6BED") ; <CJK>
       (?$(I6g(B . "0x3C98") ; <CJK>
       (?$(I6h(B . "0x3CB5") ; <CJK>
       (?$(I6i(B . "0x3CEB") ; <CJK>
       (?$(I6j(B . "0x6DC1") ; <CJK>
       (?$(I6k(B . "0x6DC3") ; <CJK>
       (?$(I6l(B . "0x6DCE") ; <CJK>
       (?$(I6m(B . "0x3CFB") ; <CJK>
       (?$(I6n(B . "0x3CF8") ; <CJK>
       (?$(I6o(B . "0x6DAD") ; <CJK>
       (?$(I6p(B . "0x6E04") ; <CJK>
       (?$(I6q(B . "0x3CF5") ; <CJK>
       (?$(I6r(B . "0x6DB9") ; <CJK>
       (?$(I6s(B . "0x3D08") ; <CJK>
       (?$(I6t(B . "0x6DE7") ; <CJK>
       (?$(I6u(B . "0x2F907") ; <CJK>
       (?$(I6v(B . "0x6E08") ; <CJK>
       (?$(I6w(B . "0x6E06") ; <CJK>
       (?$(I6x(B . "0x3D0A") ; <CJK>
       (?$(I6y(B . "0x6E0A") ; <CJK>
       (?$(I6z(B . "0x6DB0") ; <CJK>
       (?$(I6{(B . "0x3D06") ; <CJK>
       (?$(I6|(B . "0x6DF8") ; <CJK>
       (?$(I6}(B . "0x6E0C") ; <CJK>
       (?$(I6~(B . "0x3CFD") ; <CJK>
       (?$(I7!(B . "0x6DB1") ; <CJK>
       (?$(I7"(B . "0x3CFA") ; <CJK>
       (?$(I7#(B . "0x6E02") ; <CJK>
       (?$(I7$(B . "0x6E07") ; <CJK>
       (?$(I7%(B . "0x6E09") ; <CJK>
       (?$(I7&(B . "0x6E01") ; <CJK>
       (?$(I7'(B . "0x6E17") ; <CJK>
       (?$(I7((B . "0x6DFF") ; <CJK>
       (?$(I7)(B . "0x6E12") ; <CJK>
       (?$(I7*(B . "0x3DBA") ; <CJK>
       (?$(I7+(B . "0x3DB9") ; <CJK>
       (?$(I7,(B . "0x7103") ; <CJK>
       (?$(I7-(B . "0x7107") ; <CJK>
       (?$(I7.(B . "0x7101") ; <CJK>
       (?$(I7/(B . "0x70F5") ; <CJK>
       (?$(I70(B . "0x70F1") ; <CJK>
       (?$(I71(B . "0x7108") ; <CJK>
       (?$(I72(B . "0x70F2") ; <CJK>
       (?$(I73(B . "0x710F") ; <CJK>
       (?$(I74(B . "0x3DBB") ; <CJK>
       (?$(I75(B . "0x70FE") ; <CJK>
       (?$(I76(B . "0x3E18") ; <CJK>
       (?$(I77(B . "0x3E40") ; <CJK>
       (?$(I78(B . "0x3E3D") ; <CJK>
       (?$(I79(B . "0x731A") ; <CJK>
       (?$(I7:(B . "0x7310") ; <CJK>
       (?$(I7;(B . "0x730E") ; <CJK>
       (?$(I7<(B . "0x7402") ; <CJK>
       (?$(I7=(B . "0x73F3") ; <CJK>
       (?$(I7>(B . "0x3ECD") ; <CJK>
       (?$(I7?(B . "0x3EC9") ; <CJK>
       (?$(I7@(B . "0x73FB") ; <CJK>
       (?$(I7A(B . "0x3ECB") ; <CJK>
       (?$(I7B(B . "0x3ECA") ; <CJK>
       (?$(I7C(B . "0x3ECE") ; <CJK>
       (?$(I7D(B . "0x751B") ; <CJK>
       (?$(I7E(B . "0x7523") ; <CJK>
       (?$(I7F(B . "0x7561") ; <CJK>
       (?$(I7G(B . "0x7568") ; <CJK>
       (?$(I7H(B . "0x3F5E") ; <CJK>
       (?$(I7I(B . "0x7567") ; <CJK>
       (?$(I7J(B . "0x75D3") ; <CJK>
       (?$(I7K(B . "0x3F91") ; <CJK>
       (?$(I7L(B . "0x3F8C") ; <CJK>
       (?$(I7M(B . "0x7690") ; <CJK>
       (?$(I7N(B . "0x3FE1") ; <CJK>
       (?$(I7O(B . "0x4002") ; <CJK>
       (?$(I7P(B . "0x76D5") ; <CJK>
       (?$(I7Q(B . "0x76D7") ; <CJK>
       (?$(I7R(B . "0x76D6") ; <CJK>
       (?$(I7S(B . "0x7730") ; <CJK>
       (?$(I7T(B . "0x402B") ; <CJK>
       (?$(I7U(B . "0x7726") ; <CJK>
       (?$(I7V(B . "0x402A") ; <CJK>
       (?$(I7W(B . "0x7740") ; <CJK>
       (?$(I7X(B . "0x3E14") ; <CJK>
       (?$(I7Y(B . "0x771E") ; <CJK>
       (?$(I7Z(B . "0x40AD") ; <CJK>
       (?$(I7[(B . "0x40A3") ; <CJK>
       (?$(I7\(B . "0x40AB") ; <CJK>
       (?$(I7](B . "0x7847") ; <CJK>
       (?$(I7^(B . "0x40AF") ; <CJK>
       (?$(I7_(B . "0x784B") ; <CJK>
       (?$(I7`(B . "0x7851") ; <CJK>
       (?$(I7a(B . "0x784F") ; <CJK>
       (?$(I7b(B . "0x7842") ; <CJK>
       (?$(I7c(B . "0x7846") ; <CJK>
       (?$(I7d(B . "0x4104") ; <CJK>
       (?$(I7e(B . "0x796E") ; <CJK>
       (?$(I7f(B . "0x796C") ; <CJK>
       (?$(I7g(B . "0x79F2") ; <CJK>
       (?$(I7h(B . "0x4144") ; <CJK>
       (?$(I7i(B . "0x79F1") ; <CJK>
       (?$(I7j(B . "0x79F5") ; <CJK>
       (?$(I7k(B . "0x79F3") ; <CJK>
       (?$(I7l(B . "0x79F9") ; <CJK>
       (?$(I7m(B . "0x413D") ; <CJK>
       (?$(I7n(B . "0x4147") ; <CJK>
       (?$(I7o(B . "0x419C") ; <CJK>
       (?$(I7p(B . "0x7A9A") ; <CJK>
       (?$(I7q(B . "0x7A93") ; <CJK>
       (?$(I7r(B . "0x7A91") ; <CJK>
       (?$(I7s(B . "0x7AE1") ; <CJK>
       (?$(I7t(B . "0x41E0") ; <CJK>
       (?$(I7u(B . "0x41E4") ; <CJK>
       (?$(I7v(B . "0x7B21") ; <CJK>
       (?$(I7w(B . "0x7B1C") ; <CJK>
       (?$(I7x(B . "0x7B16") ; <CJK>
       (?$(I7y(B . "0x7B17") ; <CJK>
       (?$(I7z(B . "0x7B36") ; <CJK>
       (?$(I7{(B . "0x7B1F") ; <CJK>
       (?$(I7|(B . "0x4280") ; <CJK>
       (?$(I7}(B . "0x7C93") ; <CJK>
       (?$(I7~(B . "0x7C99") ; <CJK>
       (?$(I8!(B . "0x7C9A") ; <CJK>
       (?$(I8"(B . "0x7C9C") ; <CJK>
       (?$(I8#(B . "0x42CA") ; <CJK>
       (?$(I8$(B . "0x7D49") ; <CJK>
       (?$(I8%(B . "0x42D4") ; <CJK>
       (?$(I8&(B . "0x7D34") ; <CJK>
       (?$(I8'(B . "0x7D37") ; <CJK>
       (?$(I8((B . "0x42D2") ; <CJK>
       (?$(I8)(B . "0x7D2D") ; <CJK>
       (?$(I8*(B . "0x42CB") ; <CJK>
       (?$(I8+(B . "0x7D4C") ; <CJK>
       (?$(I8,(B . "0x42CE") ; <CJK>
       (?$(I8-(B . "0x42D3") ; <CJK>
       (?$(I8.(B . "0x7D48") ; <CJK>
       (?$(I8/(B . "0x4344") ; <CJK>
       (?$(I80(B . "0x4348") ; <CJK>
       (?$(I81(B . "0x7F3B") ; <CJK>
       (?$(I82(B . "0x4345") ; <CJK>
       (?$(I83(B . "0x4381") ; <CJK>
       (?$(I84(B . "0x4386") ; <CJK>
       (?$(I85(B . "0x4385") ; <CJK>
       (?$(I86(B . "0x8008") ; <CJK>
       (?$(I87(B . "0x801A") ; <CJK>
       (?$(I88(B . "0x43A3") ; <CJK>
       (?$(I89(B . "0x801D") ; <CJK>
       (?$(I8:(B . "0x43B5") ; <CJK>
       (?$(I8;(B . "0x8049") ; <CJK>
       (?$(I8<(B . "0x8045") ; <CJK>
       (?$(I8=(B . "0x8044") ; <CJK>
       (?$(I8>(B . "0x7C9B") ; <CJK>
       (?$(I8?(B . "0x43FA") ; <CJK>
       (?$(I8@(B . "0x43F9") ; <CJK>
       (?$(I8A(B . "0x812A") ; <CJK>
       (?$(I8B(B . "0x812E") ; <CJK>
       (?$(I8C(B . "0x43FB") ; <CJK>
       (?$(I8D(B . "0x43F2") ; <CJK>
       (?$(I8E(B . "0x8131") ; <CJK>
       (?$(I8F(B . "0x43EF") ; <CJK>
       (?$(I8G(B . "0x811A") ; <CJK>
       (?$(I8H(B . "0x8134") ; <CJK>
       (?$(I8I(B . "0x8117") ; <CJK>
       (?$(I8J(B . "0x445B") ; <CJK>
       (?$(I8K(B . "0x4466") ; <CJK>
       (?$(I8L(B . "0x44CE") ; <CJK>
       (?$(I8M(B . "0x831D") ; <CJK>
       (?$(I8N(B . "0x8371") ; <CJK>
       (?$(I8O(B . "0x8384") ; <CJK>
       (?$(I8P(B . "0x8380") ; <CJK>
       (?$(I8Q(B . "0x8372") ; <CJK>
       (?$(I8R(B . "0x83A1") ; <CJK>
       (?$(I8S(B . "0x35B4") ; <CJK>
       (?$(I8T(B . "0x8379") ; <CJK>
       (?$(I8U(B . "0x8391") ; <CJK>
       (?$(I8V(B . "0x44C8") ; <CJK>
       (?$(I8W(B . "0x839F") ; <CJK>
       (?$(I8X(B . "0x83AD") ; <CJK>
       (?$(I8Y(B . "0x44D1") ; <CJK>
       (?$(I8Z(B . "0x44C5") ; <CJK>
       (?$(I8[(B . "0x8323") ; <CJK>
       (?$(I8\(B . "0x44D2") ; <CJK>
       (?$(I8](B . "0x8385") ; <CJK>
       (?$(I8^(B . "0x839C") ; <CJK>
       (?$(I8_(B . "0x83B7") ; <CJK>
       (?$(I8`(B . "0x8658") ; <CJK>
       (?$(I8a(B . "0x865A") ; <CJK>
       (?$(I8b(B . "0x458F") ; <CJK>
       (?$(I8c(B . "0x8657") ; <CJK>
       (?$(I8d(B . "0x86B2") ; <CJK>
       (?$(I8e(B . "0x45A7") ; <CJK>
       (?$(I8f(B . "0x86AE") ; <CJK>
       (?$(I8g(B . "0x45A5") ; <CJK>
       (?$(I8h(B . "0x45A4") ; <CJK>
       (?$(I8i(B . "0x4611") ; <CJK>
       (?$(I8j(B . "0x8845") ; <CJK>
       (?$(I8k(B . "0x889C") ; <CJK>
       (?$(I8l(B . "0x8894") ; <CJK>
       (?$(I8m(B . "0x88A3") ; <CJK>
       (?$(I8n(B . "0x888F") ; <CJK>
       (?$(I8o(B . "0x88A5") ; <CJK>
       (?$(I8p(B . "0x88A9") ; <CJK>
       (?$(I8q(B . "0x88A6") ; <CJK>
       (?$(I8r(B . "0x888A") ; <CJK>
       (?$(I8s(B . "0x88A0") ; <CJK>
       (?$(I8t(B . "0x8890") ; <CJK>
       (?$(I8u(B . "0x8992") ; <CJK>
       (?$(I8v(B . "0x8991") ; <CJK>
       (?$(I8w(B . "0x8994") ; <CJK>
       (?$(I8x(B . "0x46B5") ; <CJK>
       (?$(I8y(B . "0x8A26") ; <CJK>
       (?$(I8z(B . "0x8A32") ; <CJK>
       (?$(I8{(B . "0x8A28") ; <CJK>
       (?$(I8|(B . "0x46B4") ; <CJK>
       (?$(I8}(B . "0x46BD") ; <CJK>
       (?$(I8~(B . "0x8A1C") ; <CJK>
       (?$(I9!(B . "0x46BB") ; <CJK>
       (?$(I9"(B . "0x8A2B") ; <CJK>
       (?$(I9#(B . "0x8A20") ; <CJK>
       (?$(I9$(B . "0x46B9") ; <CJK>
       (?$(I9%(B . "0x8A29") ; <CJK>
       (?$(I9&(B . "0x46C2") ; <CJK>
       (?$(I9'(B . "0x46BE") ; <CJK>
       (?$(I9((B . "0x46BA") ; <CJK>
       (?$(I9)(B . "0x8A21") ; <CJK>
       (?$(I9*(B . "0x8C3A") ; <CJK>
       (?$(I9+(B . "0x3AB7") ; <CJK>
       (?$(I9,(B . "0x8C5B") ; <CJK>
       (?$(I9-(B . "0x8C58") ; <CJK>
       (?$(I9.(B . "0x8C7C") ; <CJK>
       (?$(I9/(B . "0x4758") ; <CJK>
       (?$(I90(B . "0x8CA6") ; <CJK>
       (?$(I91(B . "0x8CAE") ; <CJK>
       (?$(I92(B . "0x8CAD") ; <CJK>
       (?$(I93(B . "0x8D65") ; <CJK>
       (?$(I94(B . "0x479B") ; <CJK>
       (?$(I95(B . "0x8D7E") ; <CJK>
       (?$(I96(B . "0x479C") ; <CJK>
       (?$(I97(B . "0x8D7C") ; <CJK>
       (?$(I98(B . "0x8D7F") ; <CJK>
       (?$(I99(B . "0x8D7A") ; <CJK>
       (?$(I9:(B . "0x8DBD") ; <CJK>
       (?$(I9;(B . "0x47DA") ; <CJK>
       (?$(I9<(B . "0x47DE") ; <CJK>
       (?$(I9=(B . "0x8DC0") ; <CJK>
       (?$(I9>(B . "0x8DBB") ; <CJK>
       (?$(I9?(B . "0x8EAD") ; <CJK>
       (?$(I9@(B . "0x8EAF") ; <CJK>
       (?$(I9A(B . "0x8ED6") ; <CJK>
       (?$(I9B(B . "0x484D") ; <CJK>
       (?$(I9C(B . "0x4846") ; <CJK>
       (?$(I9D(B . "0x4847") ; <CJK>
       (?$(I9E(B . "0x484B") ; <CJK>
       (?$(I9F(B . "0x484C") ; <CJK>
       (?$(I9G(B . "0x8ED9") ; <CJK>
       (?$(I9H(B . "0x4848") ; <CJK>
       (?$(I9I(B . "0x4899") ; <CJK>
       (?$(I9J(B . "0x9012") ; <CJK>
       (?$(I9K(B . "0x900E") ; <CJK>
       (?$(I9L(B . "0x9025") ; <CJK>
       (?$(I9M(B . "0x489B") ; <CJK>
       (?$(I9N(B . "0x9013") ; <CJK>
       (?$(I9O(B . "0x90EE") ; <CJK>
       (?$(I9P(B . "0x48CE") ; <CJK>
       (?$(I9Q(B . "0x90AB") ; <CJK>
       (?$(I9R(B . "0x90F7") ; <CJK>
       (?$(I9S(B . "0x48EB") ; <CJK>
       (?$(I9T(B . "0x9159") ; <CJK>
       (?$(I9U(B . "0x9154") ; <CJK>
       (?$(I9V(B . "0x91F2") ; <CJK>
       (?$(I9W(B . "0x91F0") ; <CJK>
       (?$(I9X(B . "0x91E5") ; <CJK>
       (?$(I9Y(B . "0x91F6") ; <CJK>
       (?$(I9Z(B . "0x491C") ; <CJK>
       (?$(I9[(B . "0x498C") ; <CJK>
       (?$(I9\(B . "0x9587") ; <CJK>
       (?$(I9](B . "0x49D1") ; <CJK>
       (?$(I9^(B . "0x965A") ; <CJK>
       (?$(I9_(B . "0x49D6") ; <CJK>
       (?$(I9`(B . "0x49D3") ; <CJK>
       (?$(I9a(B . "0x966E") ; <CJK>
       (?$(I9b(B . "0x49D4") ; <CJK>
       (?$(I9c(B . "0x49D0") ; <CJK>
       (?$(I9d(B . "0x49D5") ; <CJK>
       (?$(I9e(B . "0x9679") ; <CJK>
       (?$(I9f(B . "0x4A0B") ; <CJK>
       (?$(I9g(B . "0x98E1") ; <CJK>
       (?$(I9h(B . "0x98E6") ; <CJK>
       (?$(I9i(B . "0x4BC6") ; <CJK>
       (?$(I9j(B . "0x9EC4") ; <CJK>
       (?$(I9k(B . "0x9ED2") ; <CJK>
       (?$(I9l(B . "0x4E80") ; <CJK>
       (?$(I9m(B . "0x3424") ; <CJK>
       (?$(I9n(B . "0x4E81") ; <CJK>
       (?$(I9o(B . "0x508F") ; <CJK>
       (?$(I9p(B . "0x5097") ; <CJK>
       (?$(I9q(B . "0x5088") ; <CJK>
       (?$(I9r(B . "0x5089") ; <CJK>
       (?$(I9s(B . "0x3474") ; <CJK>
       (?$(I9t(B . "0x347A") ; <CJK>
       (?$(I9u(B . "0x5081") ; <CJK>
       (?$(I9v(B . "0x5160") ; <CJK>
       (?$(I9w(B . "0x20564") ; <CJK>
       (?$(I9x(B . "0x34C3") ; <CJK>
       (?$(I9y(B . "0x5E42") ; <CJK>
       (?$(I9z(B . "0x51D3") ; <CJK>
       (?$(I9{(B . "0x34D4") ; <CJK>
       (?$(I9|(B . "0x34D5") ; <CJK>
       (?$(I9}(B . "0x51D2") ; <CJK>
       (?$(I9~(B . "0x51D6") ; <CJK>
       (?$(I:!(B . "0x5273") ; <CJK>
       (?$(I:"(B . "0x34FB") ; <CJK>
       (?$(I:#(B . "0x5270") ; <CJK>
       (?$(I:$(B . "0x34F7") ; <CJK>
       (?$(I:%(B . "0x3532") ; <CJK>
       (?$(I:&(B . "0x2F833") ; <CJK>
       (?$(I:'(B . "0x53A8") ; <CJK>
       (?$(I:((B . "0x53A6") ; <CJK>
       (?$(I:)(B . "0x53C5") ; <CJK>
       (?$(I:*(B . "0x5597") ; <CJK>
       (?$(I:+(B . "0x55DE") ; <CJK>
       (?$(I:,(B . "0x35BA") ; <CJK>
       (?$(I:-(B . "0x35BF") ; <CJK>
       (?$(I:.(B . "0x5596") ; <CJK>
       (?$(I:/(B . "0x55B4") ; <CJK>
       (?$(I:0(B . "0x35C7") ; <CJK>
       (?$(I:1(B . "0x5585") ; <CJK>
       (?$(I:2(B . "0x35B7") ; <CJK>
       (?$(I:3(B . "0x559B") ; <CJK>
       (?$(I:4(B . "0x55A0") ; <CJK>
       (?$(I:5(B . "0x35B9") ; <CJK>
       (?$(I:6(B . "0x5559") ; <CJK>
       (?$(I:7(B . "0x35C3") ; <CJK>
       (?$(I:8(B . "0x5586") ; <CJK>
       (?$(I:9(B . "0x35BD") ; <CJK>
       (?$(I::(B . "0x35D0") ; <CJK>
       (?$(I:;(B . "0x55AF") ; <CJK>
       (?$(I:<(B . "0x557A") ; <CJK>
       (?$(I:=(B . "0x35C1") ; <CJK>
       (?$(I:>(B . "0x35BE") ; <CJK>
       (?$(I:?(B . "0x35CD") ; <CJK>
       (?$(I:@(B . "0x559E") ; <CJK>
       (?$(I:A(B . "0x35CB") ; <CJK>
       (?$(I:B(B . "0x55A9") ; <CJK>
       (?$(I:C(B . "0x570F") ; <CJK>
       (?$(I:D(B . "0x570E") ; <CJK>
       (?$(I:E(B . "0x581A") ; <CJK>
       (?$(I:F(B . "0x364F") ; <CJK>
       (?$(I:G(B . "0x581F") ; <CJK>
       (?$(I:H(B . "0x3653") ; <CJK>
       (?$(I:I(B . "0x583C") ; <CJK>
       (?$(I:J(B . "0x5818") ; <CJK>
       (?$(I:K(B . "0x583E") ; <CJK>
       (?$(I:L(B . "0x5826") ; <CJK>
       (?$(I:M(B . "0x3655") ; <CJK>
       (?$(I:N(B . "0x583A") ; <CJK>
       (?$(I:O(B . "0x21364") ; <CJK>
       (?$(I:P(B . "0x5822") ; <CJK>
       (?$(I:Q(B . "0x3651") ; <CJK>
       (?$(I:R(B . "0x58FB") ; <CJK>
       (?$(I:S(B . "0x5963") ; <CJK>
       (?$(I:T(B . "0x5964") ; <CJK>
       (?$(I:U(B . "0x369F") ; <CJK>
       (?$(I:V(B . "0x5AA8") ; <CJK>
       (?$(I:W(B . "0x5AA3") ; <CJK>
       (?$(I:X(B . "0x5A82") ; <CJK>
       (?$(I:Y(B . "0x5A88") ; <CJK>
       (?$(I:Z(B . "0x5AA1") ; <CJK>
       (?$(I:[(B . "0x5A85") ; <CJK>
       (?$(I:\(B . "0x5A98") ; <CJK>
       (?$(I:](B . "0x36FE") ; <CJK>
       (?$(I:^(B . "0x5A99") ; <CJK>
       (?$(I:_(B . "0x36FB") ; <CJK>
       (?$(I:`(B . "0x5A89") ; <CJK>
       (?$(I:a(B . "0x5A81") ; <CJK>
       (?$(I:b(B . "0x5A96") ; <CJK>
       (?$(I:c(B . "0x5A80") ; <CJK>
       (?$(I:d(B . "0x36F1") ; <CJK>
       (?$(I:e(B . "0x36F5") ; <CJK>
       (?$(I:f(B . "0x5A91") ; <CJK>
       (?$(I:g(B . "0x36EF") ; <CJK>
       (?$(I:h(B . "0x3704") ; <CJK>
       (?$(I:i(B . "0x3703") ; <CJK>
       (?$(I:j(B . "0x36F4") ; <CJK>
       (?$(I:k(B . "0x5ACF") ; <CJK>
       (?$(I:l(B . "0x36F3") ; <CJK>
       (?$(I:m(B . "0x3702") ; <CJK>
       (?$(I:n(B . "0x36F7") ; <CJK>
       (?$(I:o(B . "0x36FA") ; <CJK>
       (?$(I:p(B . "0x36FD") ; <CJK>
       (?$(I:q(B . "0x36EE") ; <CJK>
       (?$(I:r(B . "0x5A87") ; <CJK>
       (?$(I:s(B . "0x5AA0") ; <CJK>
       (?$(I:t(B . "0x36F0") ; <CJK>
       (?$(I:u(B . "0x5A79") ; <CJK>
       (?$(I:v(B . "0x36F2") ; <CJK>
       (?$(I:w(B . "0x5A86") ; <CJK>
       (?$(I:x(B . "0x5AAB") ; <CJK>
       (?$(I:y(B . "0x5AAA") ; <CJK>
       (?$(I:z(B . "0x5AA4") ; <CJK>
       (?$(I:{(B . "0x5A8D") ; <CJK>
       (?$(I:|(B . "0x5A7E") ; <CJK>
       (?$(I:}(B . "0x3744") ; <CJK>
       (?$(I:~(B . "0x5BD5") ; <CJK>
       (?$(I;!(B . "0x3762") ; <CJK>
       (?$(I;"(B . "0x3777") ; <CJK>
       (?$(I;#(B . "0x3DC9") ; <CJK>
       (?$(I;$(B . "0x5C1E") ; <CJK>
       (?$(I;%(B . "0x5C5F") ; <CJK>
       (?$(I;&(B . "0x5C5E") ; <CJK>
       (?$(I;'(B . "0x5D44") ; <CJK>
       (?$(I;((B . "0x5D3E") ; <CJK>
       (?$(I;)(B . "0x37E8") ; <CJK>
       (?$(I;*(B . "0x5D48") ; <CJK>
       (?$(I;+(B . "0x5D1C") ; <CJK>
       (?$(I;,(B . "0x37EF") ; <CJK>
       (?$(I;-(B . "0x5D5B") ; <CJK>
       (?$(I;.(B . "0x5D4D") ; <CJK>
       (?$(I;/(B . "0x37E6") ; <CJK>
       (?$(I;0(B . "0x37ED") ; <CJK>
       (?$(I;1(B . "0x5D57") ; <CJK>
       (?$(I;2(B . "0x37E7") ; <CJK>
       (?$(I;3(B . "0x5D53") ; <CJK>
       (?$(I;4(B . "0x5D4F") ; <CJK>
       (?$(I;5(B . "0x37EB") ; <CJK>
       (?$(I;6(B . "0x5D3B") ; <CJK>
       (?$(I;7(B . "0x5D46") ; <CJK>
       (?$(I;8(B . "0x382D") ; <CJK>
       (?$(I;9(B . "0x3855") ; <CJK>
       (?$(I;:(B . "0x5E46") ; <CJK>
       (?$(I;;(B . "0x5E47") ; <CJK>
       (?$(I;<(B . "0x3853") ; <CJK>
       (?$(I;=(B . "0x5E48") ; <CJK>
       (?$(I;>(B . "0x5EC0") ; <CJK>
       (?$(I;?(B . "0x5EBD") ; <CJK>
       (?$(I;@(B . "0x5EBF") ; <CJK>
       (?$(I;A(B . "0x3890") ; <CJK>
       (?$(I;B(B . "0x5F11") ; <CJK>
       (?$(I;C(B . "0x38BE") ; <CJK>
       (?$(I;D(B . "0x5F3E") ; <CJK>
       (?$(I;E(B . "0x5F3B") ; <CJK>
       (?$(I;F(B . "0x38BD") ; <CJK>
       (?$(I;G(B . "0x5F3A") ; <CJK>
       (?$(I;H(B . "0x38CF") ; <CJK>
       (?$(I;I(B . "0x38D0") ; <CJK>
       (?$(I;J(B . "0x38EC") ; <CJK>
       (?$(I;K(B . "0x5FA7") ; <CJK>
       (?$(I;L(B . "0x394B") ; <CJK>
       (?$(I;M(B . "0x60EA") ; <CJK>
       (?$(I;N(B . "0x3948") ; <CJK>
       (?$(I;O(B . "0x6107") ; <CJK>
       (?$(I;P(B . "0x6122") ; <CJK>
       (?$(I;Q(B . "0x610C") ; <CJK>
       (?$(I;R(B . "0x3955") ; <CJK>
       (?$(I;S(B . "0x3951") ; <CJK>
       (?$(I;T(B . "0x60B3") ; <CJK>
       (?$(I;U(B . "0x60D6") ; <CJK>
       (?$(I;V(B . "0x60D2") ; <CJK>
       (?$(I;W(B . "0x394E") ; <CJK>
       (?$(I;X(B . "0x60E3") ; <CJK>
       (?$(I;Y(B . "0x60E5") ; <CJK>
       (?$(I;Z(B . "0x60E9") ; <CJK>
       (?$(I;[(B . "0x396B") ; <CJK>
       (?$(I;\(B . "0x395E") ; <CJK>
       (?$(I;](B . "0x6111") ; <CJK>
       (?$(I;^(B . "0x60FD") ; <CJK>
       (?$(I;_(B . "0x3960") ; <CJK>
       (?$(I;`(B . "0x3967") ; <CJK>
       (?$(I;a(B . "0x611E") ; <CJK>
       (?$(I;b(B . "0x6120") ; <CJK>
       (?$(I;c(B . "0x6121") ; <CJK>
       (?$(I;d(B . "0x621E") ; <CJK>
       (?$(I;e(B . "0x39B8") ; <CJK>
       (?$(I;f(B . "0x63E2") ; <CJK>
       (?$(I;g(B . "0x63DE") ; <CJK>
       (?$(I;h(B . "0x63E6") ; <CJK>
       (?$(I;i(B . "0x3A14") ; <CJK>
       (?$(I;j(B . "0x3A0F") ; <CJK>
       (?$(I;k(B . "0x3A07") ; <CJK>
       (?$(I;l(B . "0x3A13") ; <CJK>
       (?$(I;m(B . "0x63F8") ; <CJK>
       (?$(I;n(B . "0x3A17") ; <CJK>
       (?$(I;o(B . "0x63FE") ; <CJK>
       (?$(I;p(B . "0x63C1") ; <CJK>
       (?$(I;q(B . "0x63BF") ; <CJK>
       (?$(I;r(B . "0x63F7") ; <CJK>
       (?$(I;s(B . "0x63D1") ; <CJK>
       (?$(I;t(B . "0x655F") ; <CJK>
       (?$(I;u(B . "0x6560") ; <CJK>
       (?$(I;v(B . "0x6561") ; <CJK>
       (?$(I;w(B . "0x3A9A") ; <CJK>
       (?$(I;x(B . "0x3AB8") ; <CJK>
       (?$(I;y(B . "0x65D1") ; <CJK>
       (?$(I;z(B . "0x3AF7") ; <CJK>
       (?$(I;{(B . "0x3AF8") ; <CJK>
       (?$(I;|(B . "0x667D") ; <CJK>
       (?$(I;}(B . "0x666B") ; <CJK>
       (?$(I;~(B . "0x667F") ; <CJK>
       (?$(I<!(B . "0x3AFD") ; <CJK>
       (?$(I<"(B . "0x3AF5") ; <CJK>
       (?$(I<#(B . "0x6673") ; <CJK>
       (?$(I<$(B . "0x6681") ; <CJK>
       (?$(I<%(B . "0x666D") ; <CJK>
       (?$(I<&(B . "0x6669") ; <CJK>
       (?$(I<'(B . "0x3AFA") ; <CJK>
       (?$(I<((B . "0x3B38") ; <CJK>
       (?$(I<)(B . "0x671E") ; <CJK>
       (?$(I<*(B . "0x68ED") ; <CJK>
       (?$(I<+(B . "0x3B87") ; <CJK>
       (?$(I<,(B . "0x3B80") ; <CJK>
       (?$(I<-(B . "0x3B88") ; <CJK>
       (?$(I<.(B . "0x3B79") ; <CJK>
       (?$(I</(B . "0x6903") ; <CJK>
       (?$(I<0(B . "0x3B7C") ; <CJK>
       (?$(I<1(B . "0x68FE") ; <CJK>
       (?$(I<2(B . "0x68E5") ; <CJK>
       (?$(I<3(B . "0x691E") ; <CJK>
       (?$(I<4(B . "0x6902") ; <CJK>
       (?$(I<5(B . "0x3B83") ; <CJK>
       (?$(I<6(B . "0x3B85") ; <CJK>
       (?$(I<7(B . "0x6909") ; <CJK>
       (?$(I<8(B . "0x68CA") ; <CJK>
       (?$(I<9(B . "0x6900") ; <CJK>
       (?$(I<:(B . "0x2F8E5") ; <CJK>
       (?$(I<;(B . "0x6901") ; <CJK>
       (?$(I<<(B . "0x6918") ; <CJK>
       (?$(I<=(B . "0x68E2") ; <CJK>
       (?$(I<>(B . "0x68CF") ; <CJK>
       (?$(I<?(B . "0x3B7B") ; <CJK>
       (?$(I<@(B . "0x692E") ; <CJK>
       (?$(I<A(B . "0x68C5") ; <CJK>
       (?$(I<B(B . "0x68FF") ; <CJK>
       (?$(I<C(B . "0x3B86") ; <CJK>
       (?$(I<D(B . "0x691C") ; <CJK>
       (?$(I<E(B . "0x68C3") ; <CJK>
       (?$(I<F(B . "0x3C34") ; <CJK>
       (?$(I<G(B . "0x6B6F") ; <CJK>
       (?$(I<H(B . "0x3C55") ; <CJK>
       (?$(I<I(B . "0x6B6E") ; <CJK>
       (?$(I<J(B . "0x3C68") ; <CJK>
       (?$(I<K(B . "0x6BBE") ; <CJK>
       (?$(I<L(B . "0x3C9C") ; <CJK>
       (?$(I<M(B . "0x6BF4") ; <CJK>
       (?$(I<N(B . "0x6C2D") ; <CJK>
       (?$(I<O(B . "0x3CFC") ; <CJK>
       (?$(I<P(B . "0x6DB6") ; <CJK>
       (?$(I<Q(B . "0x6E75") ; <CJK>
       (?$(I<R(B . "0x6E1E") ; <CJK>
       (?$(I<S(B . "0x3D1A") ; <CJK>
       (?$(I<T(B . "0x6E18") ; <CJK>
       (?$(I<U(B . "0x3D17") ; <CJK>
       (?$(I<V(B . "0x6E48") ; <CJK>
       (?$(I<W(B . "0x3D1B") ; <CJK>
       (?$(I<X(B . "0x6E4F") ; <CJK>
       (?$(I<Y(B . "0x3D13") ; <CJK>
       (?$(I<Z(B . "0x6E42") ; <CJK>
       (?$(I<[(B . "0x6E6A") ; <CJK>
       (?$(I<\(B . "0x6E70") ; <CJK>
       (?$(I<](B . "0x6DFE") ; <CJK>
       (?$(I<^(B . "0x3D05") ; <CJK>
       (?$(I<_(B . "0x3D07") ; <CJK>
       (?$(I<`(B . "0x6E6D") ; <CJK>
       (?$(I<a(B . "0x3D1C") ; <CJK>
       (?$(I<b(B . "0x6E7B") ; <CJK>
       (?$(I<c(B . "0x6E7E") ; <CJK>
       (?$(I<d(B . "0x6E59") ; <CJK>
       (?$(I<e(B . "0x3D11") ; <CJK>
       (?$(I<f(B . "0x6E57") ; <CJK>
       (?$(I<g(B . "0x3D16") ; <CJK>
       (?$(I<h(B . "0x6E80") ; <CJK>
       (?$(I<i(B . "0x6E50") ; <CJK>
       (?$(I<j(B . "0x3D15") ; <CJK>
       (?$(I<k(B . "0x6E29") ; <CJK>
       (?$(I<l(B . "0x6E76") ; <CJK>
       (?$(I<m(B . "0x6E2A") ; <CJK>
       (?$(I<n(B . "0x6E4C") ; <CJK>
       (?$(I<o(B . "0x712A") ; <CJK>
       (?$(I<p(B . "0x3DCB") ; <CJK>
       (?$(I<q(B . "0x7135") ; <CJK>
       (?$(I<r(B . "0x712C") ; <CJK>
       (?$(I<s(B . "0x7137") ; <CJK>
       (?$(I<t(B . "0x711D") ; <CJK>
       (?$(I<u(B . "0x3DC5") ; <CJK>
       (?$(I<v(B . "0x3DC2") ; <CJK>
       (?$(I<w(B . "0x7138") ; <CJK>
       (?$(I<x(B . "0x3DCD") ; <CJK>
       (?$(I<y(B . "0x7134") ; <CJK>
       (?$(I<z(B . "0x712B") ; <CJK>
       (?$(I<{(B . "0x7133") ; <CJK>
       (?$(I<|(B . "0x7127") ; <CJK>
       (?$(I<}(B . "0x7124") ; <CJK>
       (?$(I<~(B . "0x3DCA") ; <CJK>
       (?$(I=!(B . "0x712D") ; <CJK>
       (?$(I="(B . "0x7232") ; <CJK>
       (?$(I=#(B . "0x7283") ; <CJK>
       (?$(I=$(B . "0x7282") ; <CJK>
       (?$(I=%(B . "0x7287") ; <CJK>
       (?$(I=&(B . "0x7306") ; <CJK>
       (?$(I='(B . "0x7324") ; <CJK>
       (?$(I=((B . "0x7338") ; <CJK>
       (?$(I=)(B . "0x732A") ; <CJK>
       (?$(I=*(B . "0x732C") ; <CJK>
       (?$(I=+(B . "0x732B") ; <CJK>
       (?$(I=,(B . "0x3E83") ; <CJK>
       (?$(I=-(B . "0x732F") ; <CJK>
       (?$(I=.(B . "0x7328") ; <CJK>
       (?$(I=/(B . "0x7417") ; <CJK>
       (?$(I=0(B . "0x3ED6") ; <CJK>
       (?$(I=1(B . "0x3ED5") ; <CJK>
       (?$(I=2(B . "0x7419") ; <CJK>
       (?$(I=3(B . "0x7438") ; <CJK>
       (?$(I=4(B . "0x3ED1") ; <CJK>
       (?$(I=5(B . "0x741F") ; <CJK>
       (?$(I=6(B . "0x7414") ; <CJK>
       (?$(I=7(B . "0x743C") ; <CJK>
       (?$(I=8(B . "0x73F7") ; <CJK>
       (?$(I=9(B . "0x741C") ; <CJK>
       (?$(I=:(B . "0x7415") ; <CJK>
       (?$(I=;(B . "0x7418") ; <CJK>
       (?$(I=<(B . "0x7439") ; <CJK>
       (?$(I==(B . "0x74F9") ; <CJK>
       (?$(I=>(B . "0x7524") ; <CJK>
       (?$(I=?(B . "0x2F934") ; <CJK>
       (?$(I=@(B . "0x3F52") ; <CJK>
       (?$(I=A(B . "0x3F5F") ; <CJK>
       (?$(I=B(B . "0x756E") ; <CJK>
       (?$(I=C(B . "0x756D") ; <CJK>
       (?$(I=D(B . "0x7571") ; <CJK>
       (?$(I=E(B . "0x758E") ; <CJK>
       (?$(I=F(B . "0x3F95") ; <CJK>
       (?$(I=G(B . "0x75E5") ; <CJK>
       (?$(I=H(B . "0x3F9D") ; <CJK>
       (?$(I=I(B . "0x3F98") ; <CJK>
       (?$(I=J(B . "0x3F9E") ; <CJK>
       (?$(I=K(B . "0x3F96") ; <CJK>
       (?$(I=L(B . "0x7694") ; <CJK>
       (?$(I=M(B . "0x76B3") ; <CJK>
       (?$(I=N(B . "0x4003") ; <CJK>
       (?$(I=O(B . "0x76D9") ; <CJK>
       (?$(I=P(B . "0x402F") ; <CJK>
       (?$(I=Q(B . "0x7748") ; <CJK>
       (?$(I=R(B . "0x7749") ; <CJK>
       (?$(I=S(B . "0x7743") ; <CJK>
       (?$(I=T(B . "0x4031") ; <CJK>
       (?$(I=U(B . "0x4033") ; <CJK>
       (?$(I=V(B . "0x7742") ; <CJK>
       (?$(I=W(B . "0x77DF") ; <CJK>
       (?$(I=X(B . "0x40B4") ; <CJK>
       (?$(I=Y(B . "0x7863") ; <CJK>
       (?$(I=Z(B . "0x7876") ; <CJK>
       (?$(I=[(B . "0x40B0") ; <CJK>
       (?$(I=\(B . "0x785F") ; <CJK>
       (?$(I=](B . "0x7866") ; <CJK>
       (?$(I=^(B . "0x7966") ; <CJK>
       (?$(I=_(B . "0x7971") ; <CJK>
       (?$(I=`(B . "0x4108") ; <CJK>
       (?$(I=a(B . "0x4107") ; <CJK>
       (?$(I=b(B . "0x7976") ; <CJK>
       (?$(I=c(B . "0x7984") ; <CJK>
       (?$(I=d(B . "0x7975") ; <CJK>
       (?$(I=e(B . "0x79FF") ; <CJK>
       (?$(I=f(B . "0x7A07") ; <CJK>
       (?$(I=g(B . "0x414E") ; <CJK>
       (?$(I=h(B . "0x7A0E") ; <CJK>
       (?$(I=i(B . "0x7A09") ; <CJK>
       (?$(I=j(B . "0x4150") ; <CJK>
       (?$(I=k(B . "0x4152") ; <CJK>
       (?$(I=l(B . "0x41A1") ; <CJK>
       (?$(I=m(B . "0x41A3") ; <CJK>
       (?$(I=n(B . "0x41A5") ; <CJK>
       (?$(I=o(B . "0x41CC") ; <CJK>
       (?$(I=p(B . "0x7AE7") ; <CJK>
       (?$(I=q(B . "0x7AE2") ; <CJK>
       (?$(I=r(B . "0x7B55") ; <CJK>
       (?$(I=s(B . "0x41EF") ; <CJK>
       (?$(I=t(B . "0x41EA") ; <CJK>
       (?$(I=u(B . "0x7B43") ; <CJK>
       (?$(I=v(B . "0x7B57") ; <CJK>
       (?$(I=w(B . "0x7B6C") ; <CJK>
       (?$(I=x(B . "0x7B42") ; <CJK>
       (?$(I=y(B . "0x7B53") ; <CJK>
       (?$(I=z(B . "0x41ED") ; <CJK>
       (?$(I={(B . "0x7B41") ; <CJK>
       (?$(I=|(B . "0x4285") ; <CJK>
       (?$(I=}(B . "0x4284") ; <CJK>
       (?$(I=~(B . "0x7CA7") ; <CJK>
       (?$(I>!(B . "0x7CA0") ; <CJK>
       (?$(I>"(B . "0x7CA6") ; <CJK>
       (?$(I>#(B . "0x7CA4") ; <CJK>
       (?$(I>$(B . "0x7D74") ; <CJK>
       (?$(I>%(B . "0x42DB") ; <CJK>
       (?$(I>&(B . "0x7D59") ; <CJK>
       (?$(I>'(B . "0x42D9") ; <CJK>
       (?$(I>((B . "0x7D60") ; <CJK>
       (?$(I>)(B . "0x7D57") ; <CJK>
       (?$(I>*(B . "0x7D6C") ; <CJK>
       (?$(I>+(B . "0x7D7E") ; <CJK>
       (?$(I>,(B . "0x7D64") ; <CJK>
       (?$(I>-(B . "0x42D7") ; <CJK>
       (?$(I>.(B . "0x7D5A") ; <CJK>
       (?$(I>/(B . "0x7D5D") ; <CJK>
       (?$(I>0(B . "0x42DA") ; <CJK>
       (?$(I>1(B . "0x42DE") ; <CJK>
       (?$(I>2(B . "0x42D8") ; <CJK>
       (?$(I>3(B . "0x7D76") ; <CJK>
       (?$(I>4(B . "0x7D4D") ; <CJK>
       (?$(I>5(B . "0x7D75") ; <CJK>
       (?$(I>6(B . "0x42D5") ; <CJK>
       (?$(I>7(B . "0x7FD3") ; <CJK>
       (?$(I>8(B . "0x7FD6") ; <CJK>
       (?$(I>9(B . "0x439C") ; <CJK>
       (?$(I>:(B . "0x439D") ; <CJK>
       (?$(I>;(B . "0x8060") ; <CJK>
       (?$(I><(B . "0x804E") ; <CJK>
       (?$(I>=(B . "0x8145") ; <CJK>
       (?$(I>>(B . "0x813B") ; <CJK>
       (?$(I>?(B . "0x43FE") ; <CJK>
       (?$(I>@(B . "0x8148") ; <CJK>
       (?$(I>A(B . "0x8142") ; <CJK>
       (?$(I>B(B . "0x8149") ; <CJK>
       (?$(I>C(B . "0x8140") ; <CJK>
       (?$(I>D(B . "0x8114") ; <CJK>
       (?$(I>E(B . "0x8141") ; <CJK>
       (?$(I>F(B . "0x4407") ; <CJK>
       (?$(I>G(B . "0x81EF") ; <CJK>
       (?$(I>H(B . "0x81F6") ; <CJK>
       (?$(I>I(B . "0x8203") ; <CJK>
       (?$(I>J(B . "0x446A") ; <CJK>
       (?$(I>K(B . "0x83ED") ; <CJK>
       (?$(I>L(B . "0x44E7") ; <CJK>
       (?$(I>M(B . "0x83DA") ; <CJK>
       (?$(I>N(B . "0x8418") ; <CJK>
       (?$(I>O(B . "0x83D2") ; <CJK>
       (?$(I>P(B . "0x8408") ; <CJK>
       (?$(I>Q(B . "0x44E2") ; <CJK>
       (?$(I>R(B . "0x8400") ; <CJK>
       (?$(I>S(B . "0x44DF") ; <CJK>
       (?$(I>T(B . "0x44E1") ; <CJK>
       (?$(I>U(B . "0x44E5") ; <CJK>
       (?$(I>V(B . "0x8417") ; <CJK>
       (?$(I>W(B . "0x8346") ; <CJK>
       (?$(I>X(B . "0x8414") ; <CJK>
       (?$(I>Y(B . "0x83D3") ; <CJK>
       (?$(I>Z(B . "0x8405") ; <CJK>
       (?$(I>[(B . "0x841F") ; <CJK>
       (?$(I>\(B . "0x8402") ; <CJK>
       (?$(I>](B . "0x8416") ; <CJK>
       (?$(I>^(B . "0x83CD") ; <CJK>
       (?$(I>_(B . "0x83E6") ; <CJK>
       (?$(I>`(B . "0x4591") ; <CJK>
       (?$(I>a(B . "0x865D") ; <CJK>
       (?$(I>b(B . "0x86D5") ; <CJK>
       (?$(I>c(B . "0x86E1") ; <CJK>
       (?$(I>d(B . "0x45B4") ; <CJK>
       (?$(I>e(B . "0x45B0") ; <CJK>
       (?$(I>f(B . "0x45B5") ; <CJK>
       (?$(I>g(B . "0x45AE") ; <CJK>
       (?$(I>h(B . "0x86EE") ; <CJK>
       (?$(I>i(B . "0x8847") ; <CJK>
       (?$(I>j(B . "0x8846") ; <CJK>
       (?$(I>k(B . "0x462D") ; <CJK>
       (?$(I>l(B . "0x462C") ; <CJK>
       (?$(I>m(B . "0x88BB") ; <CJK>
       (?$(I>n(B . "0x462B") ; <CJK>
       (?$(I>o(B . "0x88BF") ; <CJK>
       (?$(I>p(B . "0x88B4") ; <CJK>
       (?$(I>q(B . "0x4629") ; <CJK>
       (?$(I>r(B . "0x88B5") ; <CJK>
       (?$(I>s(B . "0x467F") ; <CJK>
       (?$(I>t(B . "0x899A") ; <CJK>
       (?$(I>u(B . "0x8A43") ; <CJK>
       (?$(I>v(B . "0x46C9") ; <CJK>
       (?$(I>w(B . "0x46CB") ; <CJK>
       (?$(I>x(B . "0x8A5A") ; <CJK>
       (?$(I>y(B . "0x46C5") ; <CJK>
       (?$(I>z(B . "0x46C6") ; <CJK>
       (?$(I>{(B . "0x46CA") ; <CJK>
       (?$(I>|(B . "0x8A35") ; <CJK>
       (?$(I>}(B . "0x8A38") ; <CJK>
       (?$(I>~(B . "0x8A42") ; <CJK>
       (?$(I?!(B . "0x8A49") ; <CJK>
       (?$(I?"(B . "0x8A5D") ; <CJK>
       (?$(I?#(B . "0x8A4B") ; <CJK>
       (?$(I?$(B . "0x8A3D") ; <CJK>
       (?$(I?%(B . "0x46D2") ; <CJK>
       (?$(I?&(B . "0x46D0") ; <CJK>
       (?$(I?'(B . "0x472D") ; <CJK>
       (?$(I?((B . "0x4735") ; <CJK>
       (?$(I?)(B . "0x8C60") ; <CJK>
       (?$(I?*(B . "0x8C5E") ; <CJK>
       (?$(I?+(B . "0x8C7F") ; <CJK>
       (?$(I?,(B . "0x8C7E") ; <CJK>
       (?$(I?-(B . "0x8C83") ; <CJK>
       (?$(I?.(B . "0x476C") ; <CJK>
       (?$(I?/(B . "0x8CB1") ; <CJK>
       (?$(I?0(B . "0x8D87") ; <CJK>
       (?$(I?1(B . "0x479D") ; <CJK>
       (?$(I?2(B . "0x47A0") ; <CJK>
       (?$(I?3(B . "0x8D88") ; <CJK>
       (?$(I?4(B . "0x8D83") ; <CJK>
       (?$(I?5(B . "0x47A2") ; <CJK>
       (?$(I?6(B . "0x479F") ; <CJK>
       (?$(I?7(B . "0x8D86") ; <CJK>
       (?$(I?8(B . "0x8D8B") ; <CJK>
       (?$(I?9(B . "0x8D82") ; <CJK>
       (?$(I?:(B . "0x8DCA") ; <CJK>
       (?$(I?;(B . "0x8DD2") ; <CJK>
       (?$(I?<(B . "0x47EB") ; <CJK>
       (?$(I?=(B . "0x47E2") ; <CJK>
       (?$(I?>(B . "0x8DD4") ; <CJK>
       (?$(I??(B . "0x8DC9") ; <CJK>
       (?$(I?@(B . "0x8EB0") ; <CJK>
       (?$(I?A(B . "0x4836") ; <CJK>
       (?$(I?B(B . "0x4832") ; <CJK>
       (?$(I?C(B . "0x4850") ; <CJK>
       (?$(I?D(B . "0x8EF2") ; <CJK>
       (?$(I?E(B . "0x8EE4") ; <CJK>
       (?$(I?F(B . "0x8EF3") ; <CJK>
       (?$(I?G(B . "0x8EEA") ; <CJK>
       (?$(I?H(B . "0x484F") ; <CJK>
       (?$(I?I(B . "0x8EFD") ; <CJK>
       (?$(I?J(B . "0x4852") ; <CJK>
       (?$(I?K(B . "0x8F9D") ; <CJK>
       (?$(I?L(B . "0x902B") ; <CJK>
       (?$(I?M(B . "0x902A") ; <CJK>
       (?$(I?N(B . "0x489E") ; <CJK>
       (?$(I?O(B . "0x9028") ; <CJK>
       (?$(I?P(B . "0x9029") ; <CJK>
       (?$(I?Q(B . "0x902C") ; <CJK>
       (?$(I?R(B . "0x48A0") ; <CJK>
       (?$(I?S(B . "0x489C") ; <CJK>
       (?$(I?T(B . "0x903A") ; <CJK>
       (?$(I?U(B . "0x9030") ; <CJK>
       (?$(I?V(B . "0x9037") ; <CJK>
       (?$(I?W(B . "0x903B") ; <CJK>
       (?$(I?X(B . "0x48D1") ; <CJK>
       (?$(I?Y(B . "0x910A") ; <CJK>
       (?$(I?Z(B . "0x48EF") ; <CJK>
       (?$(I?[(B . "0x48F0") ; <CJK>
       (?$(I?\(B . "0x48F1") ; <CJK>
       (?$(I?](B . "0x91FE") ; <CJK>
       (?$(I?^(B . "0x9220") ; <CJK>
       (?$(I?_(B . "0x491D") ; <CJK>
       (?$(I?`(B . "0x920B") ; <CJK>
       (?$(I?a(B . "0x491F") ; <CJK>
       (?$(I?b(B . "0x9218") ; <CJK>
       (?$(I?c(B . "0x9222") ; <CJK>
       (?$(I?d(B . "0x491E") ; <CJK>
       (?$(I?e(B . "0x921B") ; <CJK>
       (?$(I?f(B . "0x9208") ; <CJK>
       (?$(I?g(B . "0x4920") ; <CJK>
       (?$(I?h(B . "0x920E") ; <CJK>
       (?$(I?i(B . "0x9213") ; <CJK>
       (?$(I?j(B . "0x498E") ; <CJK>
       (?$(I?k(B . "0x4991") ; <CJK>
       (?$(I?l(B . "0x9595") ; <CJK>
       (?$(I?m(B . "0x28CDD") ; <CJK>
       (?$(I?n(B . "0x4990") ; <CJK>
       (?$(I?o(B . "0x49D7") ; <CJK>
       (?$(I?p(B . "0x968C") ; <CJK>
       (?$(I?q(B . "0x967B") ; <CJK>
       (?$(I?r(B . "0x967F") ; <CJK>
       (?$(I?s(B . "0x9681") ; <CJK>
       (?$(I?t(B . "0x49D9") ; <CJK>
       (?$(I?u(B . "0x9682") ; <CJK>
       (?$(I?v(B . "0x49F4") ; <CJK>
       (?$(I?w(B . "0x49F6") ; <CJK>
       (?$(I?x(B . "0x3560") ; <CJK>
       (?$(I?y(B . "0x49F5") ; <CJK>
       (?$(I?z(B . "0x49F3") ; <CJK>
       (?$(I?{(B . "0x96EE") ; <CJK>
       (?$(I?|(B . "0x96ED") ; <CJK>
       (?$(I?}(B . "0x4A0C") ; <CJK>
       (?$(I?~(B . "0x96EC") ; <CJK>
       (?$(I@!(B . "0x975F") ; <CJK>
       (?$(I@"(B . "0x976F") ; <CJK>
       (?$(I@#(B . "0x4A51") ; <CJK>
       (?$(I@$(B . "0x976D") ; <CJK>
       (?$(I@%(B . "0x4AA6") ; <CJK>
       (?$(I@&(B . "0x4AA7") ; <CJK>
       (?$(I@'(B . "0x4AA8") ; <CJK>
       (?$(I@((B . "0x4B27") ; <CJK>
       (?$(I@)(B . "0x4B24") ; <CJK>
       (?$(I@*(B . "0x4B25") ; <CJK>
       (?$(I@+(B . "0x98F0") ; <CJK>
       (?$(I@,(B . "0x4B2A") ; <CJK>
       (?$(I@-(B . "0x4B74") ; <CJK>
       (?$(I@.(B . "0x4BC7") ; <CJK>
       (?$(I@/(B . "0x9AA9") ; <CJK>
       (?$(I@0(B . "0x4BE7") ; <CJK>
       (?$(I@1(B . "0x4BED") ; <CJK>
       (?$(I@2(B . "0x9AE0") ; <CJK>
       (?$(I@3(B . "0x4EB7") ; <CJK>
       (?$(I@4(B . "0x342E") ; <CJK>
       (?$(I@5(B . "0x347B") ; <CJK>
       (?$(I@6(B . "0x50CC") ; <CJK>
       (?$(I@7(B . "0x50BC") ; <CJK>
       (?$(I@8(B . "0x347C") ; <CJK>
       (?$(I@9(B . "0x50AA") ; <CJK>
       (?$(I@:(B . "0x50B9") ; <CJK>
       (?$(I@;(B . "0x347D") ; <CJK>
       (?$(I@<(B . "0x50AB") ; <CJK>
       (?$(I@=(B . "0x50C3") ; <CJK>
       (?$(I@>(B . "0x50CD") ; <CJK>
       (?$(I@?(B . "0x517E") ; <CJK>
       (?$(I@@(B . "0x527E") ; <CJK>
       (?$(I@A(B . "0x5279") ; <CJK>
       (?$(I@B(B . "0x34FD") ; <CJK>
       (?$(I@C(B . "0x2F823") ; <CJK>
       (?$(I@D(B . "0x52E1") ; <CJK>
       (?$(I@E(B . "0x52E0") ; <CJK>
       (?$(I@F(B . "0x52E7") ; <CJK>
       (?$(I@G(B . "0x5380") ; <CJK>
       (?$(I@H(B . "0x53AB") ; <CJK>
       (?$(I@I(B . "0x53AA") ; <CJK>
       (?$(I@J(B . "0x53A9") ; <CJK>
       (?$(I@K(B . "0x53E0") ; <CJK>
       (?$(I@L(B . "0x55EA") ; <CJK>
       (?$(I@M(B . "0x35DA") ; <CJK>
       (?$(I@N(B . "0x55D7") ; <CJK>
       (?$(I@O(B . "0x35D6") ; <CJK>
       (?$(I@P(B . "0x35DB") ; <CJK>
       (?$(I@Q(B . "0x55C1") ; <CJK>
       (?$(I@R(B . "0x5715") ; <CJK>
       (?$(I@S(B . "0x365B") ; <CJK>
       (?$(I@T(B . "0x586C") ; <CJK>
       (?$(I@U(B . "0x365C") ; <CJK>
       (?$(I@V(B . "0x585C") ; <CJK>
       (?$(I@W(B . "0x5850") ; <CJK>
       (?$(I@X(B . "0x5861") ; <CJK>
       (?$(I@Y(B . "0x586A") ; <CJK>
       (?$(I@Z(B . "0x5869") ; <CJK>
       (?$(I@[(B . "0x5856") ; <CJK>
       (?$(I@\(B . "0x5860") ; <CJK>
       (?$(I@](B . "0x5866") ; <CJK>
       (?$(I@^(B . "0x585F") ; <CJK>
       (?$(I@_(B . "0x5923") ; <CJK>
       (?$(I@`(B . "0x5966") ; <CJK>
       (?$(I@a(B . "0x5968") ; <CJK>
       (?$(I@b(B . "0x3706") ; <CJK>
       (?$(I@c(B . "0x370B") ; <CJK>
       (?$(I@d(B . "0x5ACE") ; <CJK>
       (?$(I@e(B . "0x370D") ; <CJK>
       (?$(I@f(B . "0x5AC5") ; <CJK>
       (?$(I@g(B . "0x5AC3") ; <CJK>
       (?$(I@h(B . "0x370A") ; <CJK>
       (?$(I@i(B . "0x3713") ; <CJK>
       (?$(I@j(B . "0x5AD0") ; <CJK>
       (?$(I@k(B . "0x3710") ; <CJK>
       (?$(I@l(B . "0x3712") ; <CJK>
       (?$(I@m(B . "0x3709") ; <CJK>
       (?$(I@n(B . "0x3708") ; <CJK>
       (?$(I@o(B . "0x3711") ; <CJK>
       (?$(I@p(B . "0x370F") ; <CJK>
       (?$(I@q(B . "0x5B74") ; <CJK>
       (?$(I@r(B . "0x5B76") ; <CJK>
       (?$(I@s(B . "0x5BDC") ; <CJK>
       (?$(I@t(B . "0x5BD7") ; <CJK>
       (?$(I@u(B . "0x5BDA") ; <CJK>
       (?$(I@v(B . "0x5BDB") ; <CJK>
       (?$(I@w(B . "0x3767") ; <CJK>
       (?$(I@x(B . "0x5C20") ; <CJK>
       (?$(I@y(B . "0x5D6D") ; <CJK>
       (?$(I@z(B . "0x5D66") ; <CJK>
       (?$(I@{(B . "0x37F6") ; <CJK>
       (?$(I@|(B . "0x5D64") ; <CJK>
       (?$(I@}(B . "0x5D6E") ; <CJK>
       (?$(I@~(B . "0x2F87E") ; <CJK>
       (?$(IA!(B . "0x5D60") ; <CJK>
       (?$(IA"(B . "0x5F42") ; <CJK>
       (?$(IA#(B . "0x5F5A") ; <CJK>
       (?$(IA$(B . "0x5F6E") ; <CJK>
       (?$(IA%(B . "0x3964") ; <CJK>
       (?$(IA&(B . "0x396C") ; <CJK>
       (?$(IA'(B . "0x6130") ; <CJK>
       (?$(IA((B . "0x613A") ; <CJK>
       (?$(IA)(B . "0x612A") ; <CJK>
       (?$(IA*(B . "0x6143") ; <CJK>
       (?$(IA+(B . "0x6119") ; <CJK>
       (?$(IA,(B . "0x6131") ; <CJK>
       (?$(IA-(B . "0x396D") ; <CJK>
       (?$(IA.(B . "0x613D") ; <CJK>
       (?$(IA/(B . "0x397A") ; <CJK>
       (?$(IA0(B . "0x3975") ; <CJK>
       (?$(IA1(B . "0x3A0D") ; <CJK>
       (?$(IA2(B . "0x6408") ; <CJK>
       (?$(IA3(B . "0x6432") ; <CJK>
       (?$(IA4(B . "0x6438") ; <CJK>
       (?$(IA5(B . "0x3A1E") ; <CJK>
       (?$(IA6(B . "0x6431") ; <CJK>
       (?$(IA7(B . "0x3A1B") ; <CJK>
       (?$(IA8(B . "0x6419") ; <CJK>
       (?$(IA9(B . "0x3A2A") ; <CJK>
       (?$(IA:(B . "0x6411") ; <CJK>
       (?$(IA;(B . "0x3A1F") ; <CJK>
       (?$(IA<(B . "0x3A22") ; <CJK>
       (?$(IA=(B . "0x6429") ; <CJK>
       (?$(IA>(B . "0x641D") ; <CJK>
       (?$(IA?(B . "0x3A25") ; <CJK>
       (?$(IA@(B . "0x3A27") ; <CJK>
       (?$(IAA(B . "0x3A29") ; <CJK>
       (?$(IAB(B . "0x643C") ; <CJK>
       (?$(IAC(B . "0x3A24") ; <CJK>
       (?$(IAD(B . "0x6446") ; <CJK>
       (?$(IAE(B . "0x6447") ; <CJK>
       (?$(IAF(B . "0x3A28") ; <CJK>
       (?$(IAG(B . "0x3A26") ; <CJK>
       (?$(IAH(B . "0x643A") ; <CJK>
       (?$(IAI(B . "0x6407") ; <CJK>
       (?$(IAJ(B . "0x3A23") ; <CJK>
       (?$(IAK(B . "0x656B") ; <CJK>
       (?$(IAL(B . "0x3A9F") ; <CJK>
       (?$(IAM(B . "0x6570") ; <CJK>
       (?$(IAN(B . "0x656D") ; <CJK>
       (?$(IAO(B . "0x3AB1") ; <CJK>
       (?$(IAP(B . "0x65E4") ; <CJK>
       (?$(IAQ(B . "0x6693") ; <CJK>
       (?$(IAR(B . "0x3B03") ; <CJK>
       (?$(IAS(B . "0x3B07") ; <CJK>
       (?$(IAT(B . "0x3B0C") ; <CJK>
       (?$(IAU(B . "0x3B06") ; <CJK>
       (?$(IAV(B . "0x668F") ; <CJK>
       (?$(IAW(B . "0x3B04") ; <CJK>
       (?$(IAX(B . "0x3B09") ; <CJK>
       (?$(IAY(B . "0x6692") ; <CJK>
       (?$(IAZ(B . "0x3B05") ; <CJK>
       (?$(IA[(B . "0x668E") ; <CJK>
       (?$(IA\(B . "0x3B08") ; <CJK>
       (?$(IA](B . "0x6946") ; <CJK>
       (?$(IA^(B . "0x3B96") ; <CJK>
       (?$(IA_(B . "0x3B9C") ; <CJK>
       (?$(IA`(B . "0x3B9F") ; <CJK>
       (?$(IAa(B . "0x3B9B") ; <CJK>
       (?$(IAb(B . "0x3B98") ; <CJK>
       (?$(IAc(B . "0x3B99") ; <CJK>
       (?$(IAd(B . "0x3B94") ; <CJK>
       (?$(IAe(B . "0x6931") ; <CJK>
       (?$(IAf(B . "0x3B8D") ; <CJK>
       (?$(IAg(B . "0x3BA3") ; <CJK>
       (?$(IAh(B . "0x693E") ; <CJK>
       (?$(IAi(B . "0x3B93") ; <CJK>
       (?$(IAj(B . "0x697C") ; <CJK>
       (?$(IAk(B . "0x6943") ; <CJK>
       (?$(IAl(B . "0x3B92") ; <CJK>
       (?$(IAm(B . "0x6973") ; <CJK>
       (?$(IAn(B . "0x2F8E8") ; <CJK>
       (?$(IAo(B . "0x6955") ; <CJK>
       (?$(IAp(B . "0x3B8E") ; <CJK>
       (?$(IAq(B . "0x3B8C") ; <CJK>
       (?$(IAr(B . "0x6985") ; <CJK>
       (?$(IAs(B . "0x694D") ; <CJK>
       (?$(IAt(B . "0x6950") ; <CJK>
       (?$(IAu(B . "0x6947") ; <CJK>
       (?$(IAv(B . "0x6967") ; <CJK>
       (?$(IAw(B . "0x6936") ; <CJK>
       (?$(IAx(B . "0x6964") ; <CJK>
       (?$(IAy(B . "0x6961") ; <CJK>
       (?$(IAz(B . "0x3B9A") ; <CJK>
       (?$(IA{(B . "0x697D") ; <CJK>
       (?$(IA|(B . "0x6B44") ; <CJK>
       (?$(IA}(B . "0x6B40") ; <CJK>
       (?$(IA~(B . "0x6B71") ; <CJK>
       (?$(IB!(B . "0x6B73") ; <CJK>
       (?$(IB"(B . "0x6B9C") ; <CJK>
       (?$(IB#(B . "0x3C6A") ; <CJK>
       (?$(IB$(B . "0x3C6D") ; <CJK>
       (?$(IB%(B . "0x3C84") ; <CJK>
       (?$(IB&(B . "0x6BC1") ; <CJK>
       (?$(IB'(B . "0x3CA0") ; <CJK>
       (?$(IB((B . "0x6BFA") ; <CJK>
       (?$(IB)(B . "0x6C31") ; <CJK>
       (?$(IB*(B . "0x6C32") ; <CJK>
       (?$(IB+(B . "0x3D1D") ; <CJK>
       (?$(IB,(B . "0x3D26") ; <CJK>
       (?$(IB-(B . "0x6EB8") ; <CJK>
       (?$(IB.(B . "0x6EA8") ; <CJK>
       (?$(IB/(B . "0x3D33") ; <CJK>
       (?$(IB0(B . "0x6E91") ; <CJK>
       (?$(IB1(B . "0x6EBB") ; <CJK>
       (?$(IB2(B . "0x3D38") ; <CJK>
       (?$(IB3(B . "0x6E9A") ; <CJK>
       (?$(IB4(B . "0x3D30") ; <CJK>
       (?$(IB5(B . "0x3D28") ; <CJK>
       (?$(IB6(B . "0x6EA9") ; <CJK>
       (?$(IB7(B . "0x3D27") ; <CJK>
       (?$(IB8(B . "0x3D2A") ; <CJK>
       (?$(IB9(B . "0x6EB5") ; <CJK>
       (?$(IB:(B . "0x6E6C") ; <CJK>
       (?$(IB;(B . "0x6EE8") ; <CJK>
       (?$(IB<(B . "0x3D31") ; <CJK>
       (?$(IB=(B . "0x6EDD") ; <CJK>
       (?$(IB>(B . "0x6EDA") ; <CJK>
       (?$(IB?(B . "0x6EE6") ; <CJK>
       (?$(IB@(B . "0x6EAC") ; <CJK>
       (?$(IBA(B . "0x3D34") ; <CJK>
       (?$(IBB(B . "0x3D2E") ; <CJK>
       (?$(IBC(B . "0x3D3B") ; <CJK>
       (?$(IBD(B . "0x6ED9") ; <CJK>
       (?$(IBE(B . "0x6EE3") ; <CJK>
       (?$(IBF(B . "0x6EE9") ; <CJK>
       (?$(IBG(B . "0x6EDB") ; <CJK>
       (?$(IBH(B . "0x3D29") ; <CJK>
       (?$(IBI(B . "0x716F") ; <CJK>
       (?$(IBJ(B . "0x3DD2") ; <CJK>
       (?$(IBK(B . "0x3DD8") ; <CJK>
       (?$(IBL(B . "0x7148") ; <CJK>
       (?$(IBM(B . "0x3DCF") ; <CJK>
       (?$(IBN(B . "0x714A") ; <CJK>
       (?$(IBO(B . "0x716B") ; <CJK>
       (?$(IBP(B . "0x3DD9") ; <CJK>
       (?$(IBQ(B . "0x714F") ; <CJK>
       (?$(IBR(B . "0x7157") ; <CJK>
       (?$(IBS(B . "0x7174") ; <CJK>
       (?$(IBT(B . "0x3DCE") ; <CJK>
       (?$(IBU(B . "0x3DD3") ; <CJK>
       (?$(IBV(B . "0x3DD0") ; <CJK>
       (?$(IBW(B . "0x7145") ; <CJK>
       (?$(IBX(B . "0x7151") ; <CJK>
       (?$(IBY(B . "0x716D") ; <CJK>
       (?$(IBZ(B . "0x3BA1") ; <CJK>
       (?$(IB[(B . "0x7251") ; <CJK>
       (?$(IB\(B . "0x7250") ; <CJK>
       (?$(IB](B . "0x724E") ; <CJK>
       (?$(IB^(B . "0x3E47") ; <CJK>
       (?$(IB_(B . "0x7341") ; <CJK>
       (?$(IB`(B . "0x3E8B") ; <CJK>
       (?$(IBa(B . "0x732E") ; <CJK>
       (?$(IBb(B . "0x7346") ; <CJK>
       (?$(IBc(B . "0x3ED4") ; <CJK>
       (?$(IBd(B . "0x7427") ; <CJK>
       (?$(IBe(B . "0x3EDE") ; <CJK>
       (?$(IBf(B . "0x7448") ; <CJK>
       (?$(IBg(B . "0x7453") ; <CJK>
       (?$(IBh(B . "0x743D") ; <CJK>
       (?$(IBi(B . "0x3EDF") ; <CJK>
       (?$(IBj(B . "0x745D") ; <CJK>
       (?$(IBk(B . "0x7456") ; <CJK>
       (?$(IBl(B . "0x3ED7") ; <CJK>
       (?$(IBm(B . "0x741E") ; <CJK>
       (?$(IBn(B . "0x7447") ; <CJK>
       (?$(IBo(B . "0x7443") ; <CJK>
       (?$(IBp(B . "0x7458") ; <CJK>
       (?$(IBq(B . "0x7449") ; <CJK>
       (?$(IBr(B . "0x3EE1") ; <CJK>
       (?$(IBs(B . "0x744C") ; <CJK>
       (?$(IBt(B . "0x7445") ; <CJK>
       (?$(IBu(B . "0x743E") ; <CJK>
       (?$(IBv(B . "0x3F2F") ; <CJK>
       (?$(IBw(B . "0x7501") ; <CJK>
       (?$(IBx(B . "0x751E") ; <CJK>
       (?$(IBy(B . "0x3F62") ; <CJK>
       (?$(IBz(B . "0x3F63") ; <CJK>
       (?$(IB{(B . "0x757A") ; <CJK>
       (?$(IB|(B . "0x75EE") ; <CJK>
       (?$(IB}(B . "0x7602") ; <CJK>
       (?$(IB~(B . "0x7697") ; <CJK>
       (?$(IC!(B . "0x7698") ; <CJK>
       (?$(IC"(B . "0x3FE2") ; <CJK>
       (?$(IC#(B . "0x4004") ; <CJK>
       (?$(IC$(B . "0x4043") ; <CJK>
       (?$(IC%(B . "0x775D") ; <CJK>
       (?$(IC&(B . "0x7764") ; <CJK>
       (?$(IC'(B . "0x7753") ; <CJK>
       (?$(IC((B . "0x7758") ; <CJK>
       (?$(IC)(B . "0x7882") ; <CJK>
       (?$(IC*(B . "0x7890") ; <CJK>
       (?$(IC+(B . "0x788A") ; <CJK>
       (?$(IC,(B . "0x40BE") ; <CJK>
       (?$(IC-(B . "0x787A") ; <CJK>
       (?$(IC.(B . "0x787D") ; <CJK>
       (?$(IC/(B . "0x40BA") ; <CJK>
       (?$(IC0(B . "0x788B") ; <CJK>
       (?$(IC1(B . "0x7878") ; <CJK>
       (?$(IC2(B . "0x40BC") ; <CJK>
       (?$(IC3(B . "0x2F94E") ; <CJK>
       (?$(IC4(B . "0x788D") ; <CJK>
       (?$(IC5(B . "0x7888") ; <CJK>
       (?$(IC6(B . "0x7892") ; <CJK>
       (?$(IC7(B . "0x7881") ; <CJK>
       (?$(IC8(B . "0x797E") ; <CJK>
       (?$(IC9(B . "0x7983") ; <CJK>
       (?$(IC:(B . "0x410D") ; <CJK>
       (?$(IC;(B . "0x410E") ; <CJK>
       (?$(IC<(B . "0x4111") ; <CJK>
       (?$(IC=(B . "0x7980") ; <CJK>
       (?$(IC>(B . "0x410F") ; <CJK>
       (?$(IC?(B . "0x4112") ; <CJK>
       (?$(IC@(B . "0x4155") ; <CJK>
       (?$(ICA(B . "0x7A0F") ; <CJK>
       (?$(ICB(B . "0x4159") ; <CJK>
       (?$(ICC(B . "0x415B") ; <CJK>
       (?$(ICD(B . "0x7A1D") ; <CJK>
       (?$(ICE(B . "0x4157") ; <CJK>
       (?$(ICF(B . "0x7AA1") ; <CJK>
       (?$(ICG(B . "0x7AA4") ; <CJK>
       (?$(ICH(B . "0x41CE") ; <CJK>
       (?$(ICI(B . "0x7AE9") ; <CJK>
       (?$(ICJ(B . "0x7AEA") ; <CJK>
       (?$(ICK(B . "0x41FE") ; <CJK>
       (?$(ICL(B . "0x7B62") ; <CJK>
       (?$(ICM(B . "0x7B6B") ; <CJK>
       (?$(ICN(B . "0x41FC") ; <CJK>
       (?$(ICO(B . "0x7B5E") ; <CJK>
       (?$(ICP(B . "0x41F5") ; <CJK>
       (?$(ICQ(B . "0x7B79") ; <CJK>
       (?$(ICR(B . "0x41F9") ; <CJK>
       (?$(ICS(B . "0x41FA") ; <CJK>
       (?$(ICT(B . "0x7B6F") ; <CJK>
       (?$(ICU(B . "0x7B68") ; <CJK>
       (?$(ICV(B . "0x4288") ; <CJK>
       (?$(ICW(B . "0x4289") ; <CJK>
       (?$(ICX(B . "0x7CAE") ; <CJK>
       (?$(ICY(B . "0x428A") ; <CJK>
       (?$(ICZ(B . "0x4287") ; <CJK>
       (?$(IC[(B . "0x428B") ; <CJK>
       (?$(IC\(B . "0x7CB0") ; <CJK>
       (?$(IC](B . "0x42E6") ; <CJK>
       (?$(IC^(B . "0x7D90") ; <CJK>
       (?$(IC_(B . "0x42ED") ; <CJK>
       (?$(IC`(B . "0x7D8A") ; <CJK>
       (?$(ICa(B . "0x42E5") ; <CJK>
       (?$(ICb(B . "0x7D8B") ; <CJK>
       (?$(ICc(B . "0x7D99") ; <CJK>
       (?$(ICd(B . "0x7D95") ; <CJK>
       (?$(ICe(B . "0x42E0") ; <CJK>
       (?$(ICf(B . "0x7D87") ; <CJK>
       (?$(ICg(B . "0x7D78") ; <CJK>
       (?$(ICh(B . "0x7D97") ; <CJK>
       (?$(ICi(B . "0x7D89") ; <CJK>
       (?$(ICj(B . "0x7D98") ; <CJK>
       (?$(ICk(B . "0x42E1") ; <CJK>
       (?$(ICl(B . "0x435B") ; <CJK>
       (?$(ICm(B . "0x435C") ; <CJK>
       (?$(ICn(B . "0x7FA3") ; <CJK>
       (?$(ICo(B . "0x438F") ; <CJK>
       (?$(ICp(B . "0x438B") ; <CJK>
       (?$(ICq(B . "0x438D") ; <CJK>
       (?$(ICr(B . "0x7FDD") ; <CJK>
       (?$(ICs(B . "0x8057") ; <CJK>
       (?$(ICt(B . "0x43B9") ; <CJK>
       (?$(ICu(B . "0x8163") ; <CJK>
       (?$(ICv(B . "0x816A") ; <CJK>
       (?$(ICw(B . "0x816C") ; <CJK>
       (?$(ICx(B . "0x440F") ; <CJK>
       (?$(ICy(B . "0x4419") ; <CJK>
       (?$(ICz(B . "0x4413") ; <CJK>
       (?$(IC{(B . "0x815D") ; <CJK>
       (?$(IC|(B . "0x8175") ; <CJK>
       (?$(IC}(B . "0x4418") ; <CJK>
       (?$(IC~(B . "0x815F") ; <CJK>
       (?$(ID!(B . "0x4416") ; <CJK>
       (?$(ID"(B . "0x817D") ; <CJK>
       (?$(ID#(B . "0x816D") ; <CJK>
       (?$(ID$(B . "0x4453") ; <CJK>
       (?$(ID%(B . "0x2F98D") ; <CJK>
       (?$(ID&(B . "0x8241") ; <CJK>
       (?$(ID'(B . "0x844F") ; <CJK>
       (?$(ID((B . "0x8484") ; <CJK>
       (?$(ID)(B . "0x44F6") ; <CJK>
       (?$(ID*(B . "0x847F") ; <CJK>
       (?$(ID+(B . "0x44F5") ; <CJK>
       (?$(ID,(B . "0x8448") ; <CJK>
       (?$(ID-(B . "0x842A") ; <CJK>
       (?$(ID.(B . "0x847B") ; <CJK>
       (?$(ID/(B . "0x8472") ; <CJK>
       (?$(ID0(B . "0x8464") ; <CJK>
       (?$(ID1(B . "0x842E") ; <CJK>
       (?$(ID2(B . "0x845C") ; <CJK>
       (?$(ID3(B . "0x8453") ; <CJK>
       (?$(ID4(B . "0x44F7") ; <CJK>
       (?$(ID5(B . "0x8441") ; <CJK>
       (?$(ID6(B . "0x84C8") ; <CJK>
       (?$(ID7(B . "0x44F0") ; <CJK>
       (?$(ID8(B . "0x8462") ; <CJK>
       (?$(ID9(B . "0x8480") ; <CJK>
       (?$(ID:(B . "0x843E") ; <CJK>
       (?$(ID;(B . "0x8483") ; <CJK>
       (?$(ID<(B . "0x8471") ; <CJK>
       (?$(ID=(B . "0x44F9") ; <CJK>
       (?$(ID>(B . "0x844A") ; <CJK>
       (?$(ID?(B . "0x8455") ; <CJK>
       (?$(ID@(B . "0x8458") ; <CJK>
       (?$(IDA(B . "0x4592") ; <CJK>
       (?$(IDB(B . "0x4595") ; <CJK>
       (?$(IDC(B . "0x4596") ; <CJK>
       (?$(IDD(B . "0x86FC") ; <CJK>
       (?$(IDE(B . "0x86FD") ; <CJK>
       (?$(IDF(B . "0x8715") ; <CJK>
       (?$(IDG(B . "0x45B9") ; <CJK>
       (?$(IDH(B . "0x8716") ; <CJK>
       (?$(IDI(B . "0x86FF") ; <CJK>
       (?$(IDJ(B . "0x45BD") ; <CJK>
       (?$(IDK(B . "0x45B8") ; <CJK>
       (?$(IDL(B . "0x4612") ; <CJK>
       (?$(IDM(B . "0x8858") ; <CJK>
       (?$(IDN(B . "0x88CF") ; <CJK>
       (?$(IDO(B . "0x88E0") ; <CJK>
       (?$(IDP(B . "0x4680") ; <CJK>
       (?$(IDQ(B . "0x4681") ; <CJK>
       (?$(IDR(B . "0x469A") ; <CJK>
       (?$(IDS(B . "0x4698") ; <CJK>
       (?$(IDT(B . "0x89E7") ; <CJK>
       (?$(IDU(B . "0x8A6A") ; <CJK>
       (?$(IDV(B . "0x8A80") ; <CJK>
       (?$(IDW(B . "0x46D4") ; <CJK>
       (?$(IDX(B . "0x8A6F") ; <CJK>
       (?$(IDY(B . "0x8A65") ; <CJK>
       (?$(IDZ(B . "0x46DA") ; <CJK>
       (?$(ID[(B . "0x8A78") ; <CJK>
       (?$(ID\(B . "0x8A7D") ; <CJK>
       (?$(ID](B . "0x8A88") ; <CJK>
       (?$(ID^(B . "0x46D6") ; <CJK>
       (?$(ID_(B . "0x46DB") ; <CJK>
       (?$(ID`(B . "0x8A64") ; <CJK>
       (?$(IDa(B . "0x8A7E") ; <CJK>
       (?$(IDb(B . "0x46DC") ; <CJK>
       (?$(IDc(B . "0x8A67") ; <CJK>
       (?$(IDd(B . "0x8C63") ; <CJK>
       (?$(IDe(B . "0x8C88") ; <CJK>
       (?$(IDf(B . "0x4771") ; <CJK>
       (?$(IDg(B . "0x8CCD") ; <CJK>
       (?$(IDh(B . "0x4772") ; <CJK>
       (?$(IDi(B . "0x8CC9") ; <CJK>
       (?$(IDj(B . "0x47A8") ; <CJK>
       (?$(IDk(B . "0x8DED") ; <CJK>
       (?$(IDl(B . "0x47F0") ; <CJK>
       (?$(IDm(B . "0x2F9DB") ; <CJK>
       (?$(IDn(B . "0x47F1") ; <CJK>
       (?$(IDo(B . "0x47FD") ; <CJK>
       (?$(IDp(B . "0x4838") ; <CJK>
       (?$(IDq(B . "0x4837") ; <CJK>
       (?$(IDr(B . "0x4839") ; <CJK>
       (?$(IDs(B . "0x8EB1") ; <CJK>
       (?$(IDt(B . "0x4855") ; <CJK>
       (?$(IDu(B . "0x4853") ; <CJK>
       (?$(IDv(B . "0x8F04") ; <CJK>
       (?$(IDw(B . "0x8F9E") ; <CJK>
       (?$(IDx(B . "0x8FA0") ; <CJK>
       (?$(IDy(B . "0x9043") ; <CJK>
       (?$(IDz(B . "0x9046") ; <CJK>
       (?$(ID{(B . "0x9048") ; <CJK>
       (?$(ID|(B . "0x9045") ; <CJK>
       (?$(ID}(B . "0x9040") ; <CJK>
       (?$(ID~(B . "0x904C") ; <CJK>
       (?$(IE!(B . "0x48D5") ; <CJK>
       (?$(IE"(B . "0x48BD") ; <CJK>
       (?$(IE#(B . "0x910C") ; <CJK>
       (?$(IE$(B . "0x9113") ; <CJK>
       (?$(IE%(B . "0x9115") ; <CJK>
       (?$(IE&(B . "0x48F5") ; <CJK>
       (?$(IE'(B . "0x916B") ; <CJK>
       (?$(IE((B . "0x9167") ; <CJK>
       (?$(IE)(B . "0x925D") ; <CJK>
       (?$(IE*(B . "0x9255") ; <CJK>
       (?$(IE+(B . "0x9235") ; <CJK>
       (?$(IE,(B . "0x4921") ; <CJK>
       (?$(IE-(B . "0x9259") ; <CJK>
       (?$(IE.(B . "0x922F") ; <CJK>
       (?$(IE/(B . "0x923C") ; <CJK>
       (?$(IE0(B . "0x928F") ; <CJK>
       (?$(IE1(B . "0x925C") ; <CJK>
       (?$(IE2(B . "0x926A") ; <CJK>
       (?$(IE3(B . "0x9262") ; <CJK>
       (?$(IE4(B . "0x925F") ; <CJK>
       (?$(IE5(B . "0x926B") ; <CJK>
       (?$(IE6(B . "0x926E") ; <CJK>
       (?$(IE7(B . "0x923B") ; <CJK>
       (?$(IE8(B . "0x9244") ; <CJK>
       (?$(IE9(B . "0x9241") ; <CJK>
       (?$(IE:(B . "0x959A") ; <CJK>
       (?$(IE;(B . "0x4992") ; <CJK>
       (?$(IE<(B . "0x9599") ; <CJK>
       (?$(IE=(B . "0x49DE") ; <CJK>
       (?$(IE>(B . "0x49DB") ; <CJK>
       (?$(IE?(B . "0x49DA") ; <CJK>
       (?$(IE@(B . "0x968F") ; <CJK>
       (?$(IEA(B . "0x49DF") ; <CJK>
       (?$(IEB(B . "0x9696") ; <CJK>
       (?$(IEC(B . "0x49F9") ; <CJK>
       (?$(IED(B . "0x49F8") ; <CJK>
       (?$(IEE(B . "0x49FA") ; <CJK>
       (?$(IEF(B . "0x96F4") ; <CJK>
       (?$(IEG(B . "0x96FC") ; <CJK>
       (?$(IEH(B . "0x4A0E") ; <CJK>
       (?$(IEI(B . "0x9755") ; <CJK>
       (?$(IEJ(B . "0x4A43") ; <CJK>
       (?$(IEK(B . "0x9779") ; <CJK>
       (?$(IEL(B . "0x4A56") ; <CJK>
       (?$(IEM(B . "0x4A53") ; <CJK>
       (?$(IEN(B . "0x4A9E") ; <CJK>
       (?$(IEO(B . "0x97EE") ; <CJK>
       (?$(IEP(B . "0x97F5") ; <CJK>
       (?$(IEQ(B . "0x4AA9") ; <CJK>
       (?$(IER(B . "0x980B") ; <CJK>
       (?$(IES(B . "0x4AFA") ; <CJK>
       (?$(IET(B . "0x98F3") ; <CJK>
       (?$(IEU(B . "0x4B31") ; <CJK>
       (?$(IEV(B . "0x4B30") ; <CJK>
       (?$(IEW(B . "0x98F7") ; <CJK>
       (?$(IEX(B . "0x98FF") ; <CJK>
       (?$(IEY(B . "0x98F5") ; <CJK>
       (?$(IEZ(B . "0x4B32") ; <CJK>
       (?$(IE[(B . "0x98EC") ; <CJK>
       (?$(IE\(B . "0x98F1") ; <CJK>
       (?$(IE](B . "0x4B29") ; <CJK>
       (?$(IE^(B . "0x4B2E") ; <CJK>
       (?$(IE_(B . "0x999A") ; <CJK>
       (?$(IE`(B . "0x4B76") ; <CJK>
       (?$(IEa(B . "0x9AE2") ; <CJK>
       (?$(IEb(B . "0x9B3D") ; <CJK>
       (?$(IEc(B . "0x9B5D") ; <CJK>
       (?$(IEd(B . "0x9CE8") ; <CJK>
       (?$(IEe(B . "0x4CA5") ; <CJK>
       (?$(IEf(B . "0x9CEB") ; <CJK>
       (?$(IEg(B . "0x9CEF") ; <CJK>
       (?$(IEh(B . "0x9CEE") ; <CJK>
       (?$(IEi(B . "0x9E81") ; <CJK>
       (?$(IEj(B . "0x9F14") ; <CJK>
       (?$(IEk(B . "0x50D0") ; <CJK>
       (?$(IEl(B . "0x50D9") ; <CJK>
       (?$(IEm(B . "0x50DC") ; <CJK>
       (?$(IEn(B . "0x50D8") ; <CJK>
       (?$(IEo(B . "0x348C") ; <CJK>
       (?$(IEp(B . "0x50E1") ; <CJK>
       (?$(IEq(B . "0x50EB") ; <CJK>
       (?$(IEr(B . "0x348B") ; <CJK>
       (?$(IEs(B . "0x3489") ; <CJK>
       (?$(IEt(B . "0x50F4") ; <CJK>
       (?$(IEu(B . "0x50E2") ; <CJK>
       (?$(IEv(B . "0x50DE") ; <CJK>
       (?$(IEw(B . "0x348D") ; <CJK>
       (?$(IEx(B . "0x3486") ; <CJK>
       (?$(IEy(B . "0x34D7") ; <CJK>
       (?$(IEz(B . "0x51F4") ; <CJK>
       (?$(IE{(B . "0x3504") ; <CJK>
       (?$(IE|(B . "0x3507") ; <CJK>
       (?$(IE}(B . "0x3503") ; <CJK>
       (?$(IE~(B . "0x52ED") ; <CJK>
       (?$(IF!(B . "0x52EA") ; <CJK>
       (?$(IF"(B . "0x3522") ; <CJK>
       (?$(IF#(B . "0x5332") ; <CJK>
       (?$(IF$(B . "0x3551") ; <CJK>
       (?$(IF%(B . "0x53AE") ; <CJK>
       (?$(IF&(B . "0x53B0") ; <CJK>
       (?$(IF'(B . "0x3561") ; <CJK>
       (?$(IF((B . "0x55FB") ; <CJK>
       (?$(IF)(B . "0x5603") ; <CJK>
       (?$(IF*(B . "0x560B") ; <CJK>
       (?$(IF+(B . "0x35E9") ; <CJK>
       (?$(IF,(B . "0x5607") ; <CJK>
       (?$(IF-(B . "0x35E5") ; <CJK>
       (?$(IF.(B . "0x55F8") ; <CJK>
       (?$(IF/(B . "0x35E4") ; <CJK>
       (?$(IF0(B . "0x5628") ; <CJK>
       (?$(IF1(B . "0x561E") ; <CJK>
       (?$(IF2(B . "0x35E3") ; <CJK>
       (?$(IF3(B . "0x5618") ; <CJK>
       (?$(IF4(B . "0x5611") ; <CJK>
       (?$(IF5(B . "0x5651") ; <CJK>
       (?$(IF6(B . "0x5605") ; <CJK>
       (?$(IF7(B . "0x5717") ; <CJK>
       (?$(IF8(B . "0x5892") ; <CJK>
       (?$(IF9(B . "0x3665") ; <CJK>
       (?$(IF:(B . "0x588C") ; <CJK>
       (?$(IF;(B . "0x3663") ; <CJK>
       (?$(IF<(B . "0x5878") ; <CJK>
       (?$(IF=(B . "0x5884") ; <CJK>
       (?$(IF>(B . "0x5873") ; <CJK>
       (?$(IF?(B . "0x58AD") ; <CJK>
       (?$(IF@(B . "0x5897") ; <CJK>
       (?$(IFA(B . "0x5895") ; <CJK>
       (?$(IFB(B . "0x5877") ; <CJK>
       (?$(IFC(B . "0x5872") ; <CJK>
       (?$(IFD(B . "0x5896") ; <CJK>
       (?$(IFE(B . "0x588D") ; <CJK>
       (?$(IFF(B . "0x5910") ; <CJK>
       (?$(IFG(B . "0x368C") ; <CJK>
       (?$(IFH(B . "0x596C") ; <CJK>
       (?$(IFI(B . "0x371A") ; <CJK>
       (?$(IFJ(B . "0x5AE7") ; <CJK>
       (?$(IFK(B . "0x3715") ; <CJK>
       (?$(IFL(B . "0x5AE4") ; <CJK>
       (?$(IFM(B . "0x3720") ; <CJK>
       (?$(IFN(B . "0x3721") ; <CJK>
       (?$(IFO(B . "0x5AEF") ; <CJK>
       (?$(IFP(B . "0x5626") ; <CJK>
       (?$(IFQ(B . "0x371C") ; <CJK>
       (?$(IFR(B . "0x371B") ; <CJK>
       (?$(IFS(B . "0x5AF0") ; <CJK>
       (?$(IFT(B . "0x5D7B") ; <CJK>
       (?$(IFU(B . "0x37FE") ; <CJK>
       (?$(IFV(B . "0x5D83") ; <CJK>
       (?$(IFW(B . "0x3804") ; <CJK>
       (?$(IFX(B . "0x3801") ; <CJK>
       (?$(IFY(B . "0x5D8B") ; <CJK>
       (?$(IFZ(B . "0x5D8C") ; <CJK>
       (?$(IF[(B . "0x3800") ; <CJK>
       (?$(IF\(B . "0x5D78") ; <CJK>
       (?$(IF](B . "0x5E52") ; <CJK>
       (?$(IF^(B . "0x386D") ; <CJK>
       (?$(IF_(B . "0x3893") ; <CJK>
       (?$(IF`(B . "0x5ED0") ; <CJK>
       (?$(IFa(B . "0x5ECF") ; <CJK>
       (?$(IFb(B . "0x38A1") ; <CJK>
       (?$(IFc(B . "0x5FB3") ; <CJK>
       (?$(IFd(B . "0x5FB4") ; <CJK>
       (?$(IFe(B . "0x3976") ; <CJK>
       (?$(IFf(B . "0x3979") ; <CJK>
       (?$(IFg(B . "0x3972") ; <CJK>
       (?$(IFh(B . "0x617B") ; <CJK>
       (?$(IFi(B . "0x3983") ; <CJK>
       (?$(IFj(B . "0x616F") ; <CJK>
       (?$(IFk(B . "0x6181") ; <CJK>
       (?$(IFl(B . "0x613C") ; <CJK>
       (?$(IFm(B . "0x6142") ; <CJK>
       (?$(IFn(B . "0x6138") ; <CJK>
       (?$(IFo(B . "0x6133") ; <CJK>
       (?$(IFp(B . "0x2F8A6") ; <CJK>
       (?$(IFq(B . "0x6160") ; <CJK>
       (?$(IFr(B . "0x6169") ; <CJK>
       (?$(IFs(B . "0x617D") ; <CJK>
       (?$(IFt(B . "0x6186") ; <CJK>
       (?$(IFu(B . "0x622C") ; <CJK>
       (?$(IFv(B . "0x6228") ; <CJK>
       (?$(IFw(B . "0x3A38") ; <CJK>
       (?$(IFx(B . "0x644C") ; <CJK>
       (?$(IFy(B . "0x3A30") ; <CJK>
       (?$(IFz(B . "0x6457") ; <CJK>
       (?$(IF{(B . "0x647C") ; <CJK>
       (?$(IF|(B . "0x3A34") ; <CJK>
       (?$(IF}(B . "0x3A3A") ; <CJK>
       (?$(IF~(B . "0x6455") ; <CJK>
       (?$(IG!(B . "0x6462") ; <CJK>
       (?$(IG"(B . "0x6471") ; <CJK>
       (?$(IG#(B . "0x646A") ; <CJK>
       (?$(IG$(B . "0x6456") ; <CJK>
       (?$(IG%(B . "0x643B") ; <CJK>
       (?$(IG&(B . "0x6481") ; <CJK>
       (?$(IG'(B . "0x3A35") ; <CJK>
       (?$(IG((B . "0x644F") ; <CJK>
       (?$(IG)(B . "0x647E") ; <CJK>
       (?$(IG*(B . "0x6464") ; <CJK>
       (?$(IG+(B . "0x3A3F") ; <CJK>
       (?$(IG,(B . "0x3A40") ; <CJK>
       (?$(IG-(B . "0x3A32") ; <CJK>
       (?$(IG.(B . "0x3A31") ; <CJK>
       (?$(IG/(B . "0x3A36") ; <CJK>
       (?$(IG0(B . "0x6571") ; <CJK>
       (?$(IG1(B . "0x230BA") ; <CJK>
       (?$(IG2(B . "0x3B0F") ; <CJK>
       (?$(IG3(B . "0x66A5") ; <CJK>
       (?$(IG4(B . "0x669A") ; <CJK>
       (?$(IG5(B . "0x669C") ; <CJK>
       (?$(IG6(B . "0x3B10") ; <CJK>
       (?$(IG7(B . "0x66A6") ; <CJK>
       (?$(IG8(B . "0x3B0D") ; <CJK>
       (?$(IG9(B . "0x66A4") ; <CJK>
       (?$(IG:(B . "0x698F") ; <CJK>
       (?$(IG;(B . "0x69C5") ; <CJK>
       (?$(IG<(B . "0x69C8") ; <CJK>
       (?$(IG=(B . "0x6992") ; <CJK>
       (?$(IG>(B . "0x69B2") ; <CJK>
       (?$(IG?(B . "0x3BA9") ; <CJK>
       (?$(IG@(B . "0x3BB4") ; <CJK>
       (?$(IGA(B . "0x3BAC") ; <CJK>
       (?$(IGB(B . "0x69E3") ; <CJK>
       (?$(IGC(B . "0x69C0") ; <CJK>
       (?$(IGD(B . "0x69D6") ; <CJK>
       (?$(IGE(B . "0x69D1") ; <CJK>
       (?$(IGF(B . "0x699F") ; <CJK>
       (?$(IGG(B . "0x69A2") ; <CJK>
       (?$(IGH(B . "0x69D2") ; <CJK>
       (?$(IGI(B . "0x3BB8") ; <CJK>
       (?$(IGJ(B . "0x3BAE") ; <CJK>
       (?$(IGK(B . "0x235F3") ; <CJK>
       (?$(IGL(B . "0x69E1") ; <CJK>
       (?$(IGM(B . "0x69D5") ; <CJK>
       (?$(IGN(B . "0x699D") ; <CJK>
       (?$(IGO(B . "0x3BB3") ; <CJK>
       (?$(IGP(B . "0x3BBA") ; <CJK>
       (?$(IGQ(B . "0x6998") ; <CJK>
       (?$(IGR(B . "0x3C3F") ; <CJK>
       (?$(IGS(B . "0x6B74") ; <CJK>
       (?$(IGT(B . "0x6BA1") ; <CJK>
       (?$(IGU(B . "0x3D3C") ; <CJK>
       (?$(IGV(B . "0x6EF0") ; <CJK>
       (?$(IGW(B . "0x6EF3") ; <CJK>
       (?$(IGX(B . "0x3D42") ; <CJK>
       (?$(IGY(B . "0x3D40") ; <CJK>
       (?$(IGZ(B . "0x6F1B") ; <CJK>
       (?$(IG[(B . "0x6F0C") ; <CJK>
       (?$(IG\(B . "0x6F1D") ; <CJK>
       (?$(IG](B . "0x6F34") ; <CJK>
       (?$(IG^(B . "0x6F28") ; <CJK>
       (?$(IG_(B . "0x6F17") ; <CJK>
       (?$(IG`(B . "0x3D3E") ; <CJK>
       (?$(IGa(B . "0x6F44") ; <CJK>
       (?$(IGb(B . "0x6F42") ; <CJK>
       (?$(IGc(B . "0x6F04") ; <CJK>
       (?$(IGd(B . "0x6F11") ; <CJK>
       (?$(IGe(B . "0x6EFA") ; <CJK>
       (?$(IGf(B . "0x6F4A") ; <CJK>
       (?$(IGg(B . "0x7191") ; <CJK>
       (?$(IGh(B . "0x718E") ; <CJK>
       (?$(IGi(B . "0x3DE1") ; <CJK>
       (?$(IGj(B . "0x718B") ; <CJK>
       (?$(IGk(B . "0x718D") ; <CJK>
       (?$(IGl(B . "0x717F") ; <CJK>
       (?$(IGm(B . "0x718C") ; <CJK>
       (?$(IGn(B . "0x717E") ; <CJK>
       (?$(IGo(B . "0x717C") ; <CJK>
       (?$(IGp(B . "0x7183") ; <CJK>
       (?$(IGq(B . "0x3DE6") ; <CJK>
       (?$(IGr(B . "0x7188") ; <CJK>
       (?$(IGs(B . "0x3DE0") ; <CJK>
       (?$(IGt(B . "0x3E15") ; <CJK>
       (?$(IGu(B . "0x7294") ; <CJK>
       (?$(IGv(B . "0x3E93") ; <CJK>
       (?$(IGw(B . "0x7355") ; <CJK>
       (?$(IGx(B . "0x7353") ; <CJK>
       (?$(IGy(B . "0x734F") ; <CJK>
       (?$(IGz(B . "0x7354") ; <CJK>
       (?$(IG{(B . "0x746C") ; <CJK>
       (?$(IG|(B . "0x7465") ; <CJK>
       (?$(IG}(B . "0x7466") ; <CJK>
       (?$(IG~(B . "0x7461") ; <CJK>
       (?$(IH!(B . "0x746B") ; <CJK>
       (?$(IH"(B . "0x7468") ; <CJK>
       (?$(IH#(B . "0x7476") ; <CJK>
       (?$(IH$(B . "0x3EE7") ; <CJK>
       (?$(IH%(B . "0x7460") ; <CJK>
       (?$(IH&(B . "0x24A0F") ; <CJK>
       (?$(IH'(B . "0x7474") ; <CJK>
       (?$(IH((B . "0x7506") ; <CJK>
       (?$(IH)(B . "0x760E") ; <CJK>
       (?$(IH*(B . "0x3FAD") ; <CJK>
       (?$(IH+(B . "0x7607") ; <CJK>
       (?$(IH,(B . "0x3FAE") ; <CJK>
       (?$(IH-(B . "0x3FE3") ; <CJK>
       (?$(IH.(B . "0x76B9") ; <CJK>
       (?$(IH/(B . "0x3FF5") ; <CJK>
       (?$(IH0(B . "0x76B7") ; <CJK>
       (?$(IH1(B . "0x76E2") ; <CJK>
       (?$(IH2(B . "0x4006") ; <CJK>
       (?$(IH3(B . "0x7774") ; <CJK>
       (?$(IH4(B . "0x7777") ; <CJK>
       (?$(IH5(B . "0x7776") ; <CJK>
       (?$(IH6(B . "0x7775") ; <CJK>
       (?$(IH7(B . "0x404F") ; <CJK>
       (?$(IH8(B . "0x7778") ; <CJK>
       (?$(IH9(B . "0x7771") ; <CJK>
       (?$(IH:(B . "0x4054") ; <CJK>
       (?$(IH;(B . "0x777A") ; <CJK>
       (?$(IH<(B . "0x715B") ; <CJK>
       (?$(IH=(B . "0x777B") ; <CJK>
       (?$(IH>(B . "0x78A6") ; <CJK>
       (?$(IH?(B . "0x78AE") ; <CJK>
       (?$(IH@(B . "0x78B8") ; <CJK>
       (?$(IHA(B . "0x40CB") ; <CJK>
       (?$(IHB(B . "0x40E3") ; <CJK>
       (?$(IHC(B . "0x40C9") ; <CJK>
       (?$(IHD(B . "0x78B1") ; <CJK>
       (?$(IHE(B . "0x78AF") ; <CJK>
       (?$(IHF(B . "0x4113") ; <CJK>
       (?$(IHG(B . "0x7989") ; <CJK>
       (?$(IHH(B . "0x7987") ; <CJK>
       (?$(IHI(B . "0x4115") ; <CJK>
       (?$(IHJ(B . "0x4161") ; <CJK>
       (?$(IHK(B . "0x7A29") ; <CJK>
       (?$(IHL(B . "0x4166") ; <CJK>
       (?$(IHM(B . "0x7A2A") ; <CJK>
       (?$(IHN(B . "0x4164") ; <CJK>
       (?$(IHO(B . "0x7A2D") ; <CJK>
       (?$(IHP(B . "0x7A2C") ; <CJK>
       (?$(IHQ(B . "0x4160") ; <CJK>
       (?$(IHR(B . "0x7A32") ; <CJK>
       (?$(IHS(B . "0x4163") ; <CJK>
       (?$(IHT(B . "0x7AEC") ; <CJK>
       (?$(IHU(B . "0x7AF0") ; <CJK>
       (?$(IHV(B . "0x7B81") ; <CJK>
       (?$(IHW(B . "0x7B9E") ; <CJK>
       (?$(IHX(B . "0x7B83") ; <CJK>
       (?$(IHY(B . "0x420A") ; <CJK>
       (?$(IHZ(B . "0x7B92") ; <CJK>
       (?$(IH[(B . "0x4204") ; <CJK>
       (?$(IH\(B . "0x7BA3") ; <CJK>
       (?$(IH](B . "0x7B9F") ; <CJK>
       (?$(IH^(B . "0x7B93") ; <CJK>
       (?$(IH_(B . "0x4207") ; <CJK>
       (?$(IH`(B . "0x7B86") ; <CJK>
       (?$(IHa(B . "0x7CB8") ; <CJK>
       (?$(IHb(B . "0x7CB7") ; <CJK>
       (?$(IHc(B . "0x428D") ; <CJK>
       (?$(IHd(B . "0x428F") ; <CJK>
       (?$(IHe(B . "0x4290") ; <CJK>
       (?$(IHf(B . "0x4292") ; <CJK>
       (?$(IHg(B . "0x42EC") ; <CJK>
       (?$(IHh(B . "0x7DC8") ; <CJK>
       (?$(IHi(B . "0x7DB6") ; <CJK>
       (?$(IHj(B . "0x2F96C") ; <CJK>
       (?$(IHk(B . "0x7DD1") ; <CJK>
       (?$(IHl(B . "0x42E7") ; <CJK>
       (?$(IHm(B . "0x7DA8") ; <CJK>
       (?$(IHn(B . "0x7DAB") ; <CJK>
       (?$(IHo(B . "0x42F2") ; <CJK>
       (?$(IHp(B . "0x7DB3") ; <CJK>
       (?$(IHq(B . "0x7DCD") ; <CJK>
       (?$(IHr(B . "0x42EE") ; <CJK>
       (?$(IHs(B . "0x7DCF") ; <CJK>
       (?$(IHt(B . "0x7DA4") ; <CJK>
       (?$(IHu(B . "0x42EF") ; <CJK>
       (?$(IHv(B . "0x434C") ; <CJK>
       (?$(IHw(B . "0x7F41") ; <CJK>
       (?$(IHx(B . "0x7F6F") ; <CJK>
       (?$(IHy(B . "0x7F71") ; <CJK>
       (?$(IHz(B . "0x435E") ; <CJK>
       (?$(IH{(B . "0x435F") ; <CJK>
       (?$(IH|(B . "0x4376") ; <CJK>
       (?$(IH}(B . "0x4374") ; <CJK>
       (?$(IH~(B . "0x4372") ; <CJK>
       (?$(II!(B . "0x4390") ; <CJK>
       (?$(II"(B . "0x8023") ; <CJK>
       (?$(II#(B . "0x805B") ; <CJK>
       (?$(II$(B . "0x43BE") ; <CJK>
       (?$(II%(B . "0x8061") ; <CJK>
       (?$(II&(B . "0x805F") ; <CJK>
       (?$(II'(B . "0x8181") ; <CJK>
       (?$(II((B . "0x4426") ; <CJK>
       (?$(II)(B . "0x4425") ; <CJK>
       (?$(II*(B . "0x8184") ; <CJK>
       (?$(II+(B . "0x8213") ; <CJK>
       (?$(II,(B . "0x4474") ; <CJK>
       (?$(II-(B . "0x824A") ; <CJK>
       (?$(II.(B . "0x824C") ; <CJK>
       (?$(II/(B . "0x44FD") ; <CJK>
       (?$(II0(B . "0x4505") ; <CJK>
       (?$(II1(B . "0x4501") ; <CJK>
       (?$(II2(B . "0x84BD") ; <CJK>
       (?$(II3(B . "0x8495") ; <CJK>
       (?$(II4(B . "0x4509") ; <CJK>
       (?$(II5(B . "0x8492") ; <CJK>
       (?$(II6(B . "0x84C3") ; <CJK>
       (?$(II7(B . "0x450C") ; <CJK>
       (?$(II8(B . "0x8496") ; <CJK>
       (?$(II9(B . "0x84A5") ; <CJK>
       (?$(II:(B . "0x84B5") ; <CJK>
       (?$(II;(B . "0x84B3") ; <CJK>
       (?$(II<(B . "0x84A3") ; <CJK>
       (?$(II=(B . "0x84E4") ; <CJK>
       (?$(II>(B . "0x84D8") ; <CJK>
       (?$(II?(B . "0x84D5") ; <CJK>
       (?$(II@(B . "0x450D") ; <CJK>
       (?$(IIA(B . "0x84B7") ; <CJK>
       (?$(IIB(B . "0x84AD") ; <CJK>
       (?$(IIC(B . "0x84DA") ; <CJK>
       (?$(IID(B . "0x8493") ; <CJK>
       (?$(IIE(B . "0x8736") ; <CJK>
       (?$(IIF(B . "0x45C0") ; <CJK>
       (?$(IIG(B . "0x45C5") ; <CJK>
       (?$(IIH(B . "0x45C9") ; <CJK>
       (?$(III(B . "0x873D") ; <CJK>
       (?$(IIJ(B . "0x872B") ; <CJK>
       (?$(IIK(B . "0x8747") ; <CJK>
       (?$(IIL(B . "0x8739") ; <CJK>
       (?$(IIM(B . "0x45D5") ; <CJK>
       (?$(IIN(B . "0x8745") ; <CJK>
       (?$(IIO(B . "0x871D") ; <CJK>
       (?$(IIP(B . "0x4641") ; <CJK>
       (?$(IIQ(B . "0x88FF") ; <CJK>
       (?$(IIR(B . "0x88EA") ; <CJK>
       (?$(IIS(B . "0x4633") ; <CJK>
       (?$(IIT(B . "0x88F5") ; <CJK>
       (?$(IIU(B . "0x463A") ; <CJK>
       (?$(IIV(B . "0x8900") ; <CJK>
       (?$(IIW(B . "0x88ED") ; <CJK>
       (?$(IIX(B . "0x8903") ; <CJK>
       (?$(IIY(B . "0x88E9") ; <CJK>
       (?$(IIZ(B . "0x4640") ; <CJK>
       (?$(II[(B . "0x4642") ; <CJK>
       (?$(II\(B . "0x89EA") ; <CJK>
       (?$(II](B . "0x46E8") ; <CJK>
       (?$(II^(B . "0x8A9B") ; <CJK>
       (?$(II_(B . "0x8A8E") ; <CJK>
       (?$(II`(B . "0x8AA2") ; <CJK>
       (?$(IIa(B . "0x46E4") ; <CJK>
       (?$(IIb(B . "0x8A9C") ; <CJK>
       (?$(IIc(B . "0x8A94") ; <CJK>
       (?$(IId(B . "0x8A90") ; <CJK>
       (?$(IIe(B . "0x8AA9") ; <CJK>
       (?$(IIf(B . "0x8AAC") ; <CJK>
       (?$(IIg(B . "0x46E7") ; <CJK>
       (?$(IIh(B . "0x8A9F") ; <CJK>
       (?$(IIi(B . "0x46E6") ; <CJK>
       (?$(IIj(B . "0x46E1") ; <CJK>
       (?$(IIk(B . "0x8A9D") ; <CJK>
       (?$(IIl(B . "0x4739") ; <CJK>
       (?$(IIm(B . "0x8C67") ; <CJK>
       (?$(IIn(B . "0x475C") ; <CJK>
       (?$(IIo(B . "0x4775") ; <CJK>
       (?$(IIp(B . "0x8CD0") ; <CJK>
       (?$(IIq(B . "0x8CD6") ; <CJK>
       (?$(IIr(B . "0x8CD4") ; <CJK>
       (?$(IIs(B . "0x8D98") ; <CJK>
       (?$(IIt(B . "0x8D9A") ; <CJK>
       (?$(IIu(B . "0x8D97") ; <CJK>
       (?$(IIv(B . "0x47AE") ; <CJK>
       (?$(IIw(B . "0x47B0") ; <CJK>
       (?$(IIx(B . "0x47FA") ; <CJK>
       (?$(IIy(B . "0x8E0B") ; <CJK>
       (?$(IIz(B . "0x8E08") ; <CJK>
       (?$(II{(B . "0x8E01") ; <CJK>
       (?$(II|(B . "0x8EB4") ; <CJK>
       (?$(II}(B . "0x8EB3") ; <CJK>
       (?$(II~(B . "0x485B") ; <CJK>
       (?$(IJ!(B . "0x8FA1") ; <CJK>
       (?$(IJ"(B . "0x8FA2") ; <CJK>
       (?$(IJ#(B . "0x48A5") ; <CJK>
       (?$(IJ$(B . "0x905A") ; <CJK>
       (?$(IJ%(B . "0x48A2") ; <CJK>
       (?$(IJ&(B . "0x9061") ; <CJK>
       (?$(IJ'(B . "0x905F") ; <CJK>
       (?$(IJ((B . "0x48DB") ; <CJK>
       (?$(IJ)(B . "0x48DA") ; <CJK>
       (?$(IJ*(B . "0x9125") ; <CJK>
       (?$(IJ+(B . "0x917B") ; <CJK>
       (?$(IJ,(B . "0x9176") ; <CJK>
       (?$(IJ-(B . "0x917C") ; <CJK>
       (?$(IJ.(B . "0x4924") ; <CJK>
       (?$(IJ/(B . "0x9289") ; <CJK>
       (?$(IJ0(B . "0x92F6") ; <CJK>
       (?$(IJ1(B . "0x92B1") ; <CJK>
       (?$(IJ2(B . "0x92AD") ; <CJK>
       (?$(IJ3(B . "0x9292") ; <CJK>
       (?$(IJ4(B . "0x9281") ; <CJK>
       (?$(IJ5(B . "0x9284") ; <CJK>
       (?$(IJ6(B . "0x4926") ; <CJK>
       (?$(IJ7(B . "0x92AE") ; <CJK>
       (?$(IJ8(B . "0x9290") ; <CJK>
       (?$(IJ9(B . "0x929E") ; <CJK>
       (?$(IJ:(B . "0x4998") ; <CJK>
       (?$(IJ;(B . "0x4996") ; <CJK>
       (?$(IJ<(B . "0x499A") ; <CJK>
       (?$(IJ=(B . "0x95A2") ; <CJK>
       (?$(IJ>(B . "0x95A7") ; <CJK>
       (?$(IJ?(B . "0x4997") ; <CJK>
       (?$(IJ@(B . "0x49E1") ; <CJK>
       (?$(IJA(B . "0x49E0") ; <CJK>
       (?$(IJB(B . "0x49E3") ; <CJK>
       (?$(IJC(B . "0x49E2") ; <CJK>
       (?$(IJD(B . "0x96A0") ; <CJK>
       (?$(IJE(B . "0x969D") ; <CJK>
       (?$(IJF(B . "0x969F") ; <CJK>
       (?$(IJG(B . "0x96D0") ; <CJK>
       (?$(IJH(B . "0x49FB") ; <CJK>
       (?$(IJI(B . "0x96D1") ; <CJK>
       (?$(IJJ(B . "0x4A12") ; <CJK>
       (?$(IJK(B . "0x4A14") ; <CJK>
       (?$(IJL(B . "0x9759") ; <CJK>
       (?$(IJM(B . "0x4A45") ; <CJK>
       (?$(IJN(B . "0x9764") ; <CJK>
       (?$(IJO(B . "0x4A5C") ; <CJK>
       (?$(IJP(B . "0x4A5D") ; <CJK>
       (?$(IJQ(B . "0x4AB8") ; <CJK>
       (?$(IJR(B . "0x9819") ; <CJK>
       (?$(IJS(B . "0x4ABA") ; <CJK>
       (?$(IJT(B . "0x9814") ; <CJK>
       (?$(IJU(B . "0x9815") ; <CJK>
       (?$(IJV(B . "0x981A") ; <CJK>
       (?$(IJW(B . "0x4B03") ; <CJK>
       (?$(IJX(B . "0x4B35") ; <CJK>
       (?$(IJY(B . "0x4B36") ; <CJK>
       (?$(IJZ(B . "0x4B39") ; <CJK>
       (?$(IJ[(B . "0x9906") ; <CJK>
       (?$(IJ\(B . "0x4B2D") ; <CJK>
       (?$(IJ](B . "0x98F8") ; <CJK>
       (?$(IJ^(B . "0x9901") ; <CJK>
       (?$(IJ_(B . "0x4B7A") ; <CJK>
       (?$(IJ`(B . "0x99BE") ; <CJK>
       (?$(IJa(B . "0x99BC") ; <CJK>
       (?$(IJb(B . "0x99B7") ; <CJK>
       (?$(IJc(B . "0x99B6") ; <CJK>
       (?$(IJd(B . "0x99C0") ; <CJK>
       (?$(IJe(B . "0x4B78") ; <CJK>
       (?$(IJf(B . "0x99B8") ; <CJK>
       (?$(IJg(B . "0x4B7B") ; <CJK>
       (?$(IJh(B . "0x4B7C") ; <CJK>
       (?$(IJi(B . "0x4B7E") ; <CJK>
       (?$(IJj(B . "0x99C4") ; <CJK>
       (?$(IJk(B . "0x4B7D") ; <CJK>
       (?$(IJl(B . "0x99BF") ; <CJK>
       (?$(IJm(B . "0x4BC9") ; <CJK>
       (?$(IJn(B . "0x9ADA") ; <CJK>
       (?$(IJo(B . "0x9AE4") ; <CJK>
       (?$(IJp(B . "0x9AE9") ; <CJK>
       (?$(IJq(B . "0x9AE8") ; <CJK>
       (?$(IJr(B . "0x9AEA") ; <CJK>
       (?$(IJs(B . "0x9AE5") ; <CJK>
       (?$(IJt(B . "0x4BF3") ; <CJK>
       (?$(IJu(B . "0x9B26") ; <CJK>
       (?$(IJv(B . "0x4C1A") ; <CJK>
       (?$(IJw(B . "0x4C19") ; <CJK>
       (?$(IJx(B . "0x9B40") ; <CJK>
       (?$(IJy(B . "0x4C1F") ; <CJK>
       (?$(IJz(B . "0x4CA6") ; <CJK>
       (?$(IJ{(B . "0x4CA7") ; <CJK>
       (?$(IJ|(B . "0x4CA8") ; <CJK>
       (?$(IJ}(B . "0x4CAB") ; <CJK>
       (?$(IJ~(B . "0x4CA9") ; <CJK>
       (?$(IK!(B . "0x4D2E") ; <CJK>
       (?$(IK"(B . "0x9EBD") ; <CJK>
       (?$(IK#(B . "0x4D5E") ; <CJK>
       (?$(IK$(B . "0x3495") ; <CJK>
       (?$(IK%(B . "0x3493") ; <CJK>
       (?$(IK&(B . "0x3492") ; <CJK>
       (?$(IK'(B . "0x510E") ; <CJK>
       (?$(IK((B . "0x3496") ; <CJK>
       (?$(IK)(B . "0x50F7") ; <CJK>
       (?$(IK*(B . "0x3497") ; <CJK>
       (?$(IK+(B . "0x50FC") ; <CJK>
       (?$(IK,(B . "0x510D") ; <CJK>
       (?$(IK-(B . "0x5101") ; <CJK>
       (?$(IK.(B . "0x51DA") ; <CJK>
       (?$(IK/(B . "0x51D9") ; <CJK>
       (?$(IK0(B . "0x51DB") ; <CJK>
       (?$(IK1(B . "0x5286") ; <CJK>
       (?$(IK2(B . "0x528E") ; <CJK>
       (?$(IK3(B . "0x52EE") ; <CJK>
       (?$(IK4(B . "0x5333") ; <CJK>
       (?$(IK5(B . "0x53B1") ; <CJK>
       (?$(IK6(B . "0x35F5") ; <CJK>
       (?$(IK7(B . "0x5647") ; <CJK>
       (?$(IK8(B . "0x562D") ; <CJK>
       (?$(IK9(B . "0x5654") ; <CJK>
       (?$(IK:(B . "0x35EA") ; <CJK>
       (?$(IK;(B . "0x564B") ; <CJK>
       (?$(IK<(B . "0x5652") ; <CJK>
       (?$(IK=(B . "0x5631") ; <CJK>
       (?$(IK>(B . "0x5644") ; <CJK>
       (?$(IK?(B . "0x5656") ; <CJK>
       (?$(IK@(B . "0x5650") ; <CJK>
       (?$(IKA(B . "0x562B") ; <CJK>
       (?$(IKB(B . "0x35F3") ; <CJK>
       (?$(IKC(B . "0x564D") ; <CJK>
       (?$(IKD(B . "0x5637") ; <CJK>
       (?$(IKE(B . "0x564F") ; <CJK>
       (?$(IKF(B . "0x58A2") ; <CJK>
       (?$(IKG(B . "0x58B7") ; <CJK>
       (?$(IKH(B . "0x3669") ; <CJK>
       (?$(IKI(B . "0x58B2") ; <CJK>
       (?$(IKJ(B . "0x366B") ; <CJK>
       (?$(IKK(B . "0x58AA") ; <CJK>
       (?$(IKL(B . "0x58B5") ; <CJK>
       (?$(IKM(B . "0x58B0") ; <CJK>
       (?$(IKN(B . "0x366C") ; <CJK>
       (?$(IKO(B . "0x58B4") ; <CJK>
       (?$(IKP(B . "0x58A4") ; <CJK>
       (?$(IKQ(B . "0x58A7") ; <CJK>
       (?$(IKR(B . "0x3668") ; <CJK>
       (?$(IKS(B . "0x5926") ; <CJK>
       (?$(IKT(B . "0x5AFE") ; <CJK>
       (?$(IKU(B . "0x3728") ; <CJK>
       (?$(IKV(B . "0x5B04") ; <CJK>
       (?$(IKW(B . "0x3726") ; <CJK>
       (?$(IKX(B . "0x5AFC") ; <CJK>
       (?$(IKY(B . "0x3725") ; <CJK>
       (?$(IKZ(B . "0x5B06") ; <CJK>
       (?$(IK[(B . "0x5B0A") ; <CJK>
       (?$(IK\(B . "0x5AFA") ; <CJK>
       (?$(IK](B . "0x5B0D") ; <CJK>
       (?$(IK^(B . "0x5B00") ; <CJK>
       (?$(IK_(B . "0x5B0E") ; <CJK>
       (?$(IK`(B . "0x376B") ; <CJK>
       (?$(IKa(B . "0x380F") ; <CJK>
       (?$(IKb(B . "0x3808") ; <CJK>
       (?$(IKc(B . "0x5D91") ; <CJK>
       (?$(IKd(B . "0x380C") ; <CJK>
       (?$(IKe(B . "0x5D8F") ; <CJK>
       (?$(IKf(B . "0x5D90") ; <CJK>
       (?$(IKg(B . "0x5D98") ; <CJK>
       (?$(IKh(B . "0x5DA4") ; <CJK>
       (?$(IKi(B . "0x5D9B") ; <CJK>
       (?$(IKj(B . "0x5DA3") ; <CJK>
       (?$(IKk(B . "0x5D96") ; <CJK>
       (?$(IKl(B . "0x5DE4") ; <CJK>
       (?$(IKm(B . "0x5E5A") ; <CJK>
       (?$(IKn(B . "0x3860") ; <CJK>
       (?$(IKo(B . "0x3862") ; <CJK>
       (?$(IKp(B . "0x5E5E") ; <CJK>
       (?$(IKq(B . "0x3898") ; <CJK>
       (?$(IKr(B . "0x5FB8") ; <CJK>
       (?$(IKs(B . "0x6157") ; <CJK>
       (?$(IKt(B . "0x615C") ; <CJK>
       (?$(IKu(B . "0x61A6") ; <CJK>
       (?$(IKv(B . "0x6195") ; <CJK>
       (?$(IKw(B . "0x6188") ; <CJK>
       (?$(IKx(B . "0x398A") ; <CJK>
       (?$(IKy(B . "0x61A3") ; <CJK>
       (?$(IKz(B . "0x618F") ; <CJK>
       (?$(IK{(B . "0x3984") ; <CJK>
       (?$(IK|(B . "0x6164") ; <CJK>
       (?$(IK}(B . "0x397F") ; <CJK>
       (?$(IK~(B . "0x6159") ; <CJK>
       (?$(IL!(B . "0x6178") ; <CJK>
       (?$(IL"(B . "0x3982") ; <CJK>
       (?$(IL#(B . "0x6185") ; <CJK>
       (?$(IL$(B . "0x6187") ; <CJK>
       (?$(IL%(B . "0x619E") ; <CJK>
       (?$(IL&(B . "0x3996") ; <CJK>
       (?$(IL'(B . "0x3989") ; <CJK>
       (?$(IL((B . "0x6198") ; <CJK>
       (?$(IL)(B . "0x619C") ; <CJK>
       (?$(IL*(B . "0x398D") ; <CJK>
       (?$(IL+(B . "0x39BC") ; <CJK>
       (?$(IL,(B . "0x622F") ; <CJK>
       (?$(IL-(B . "0x6480") ; <CJK>
       (?$(IL.(B . "0x649B") ; <CJK>
       (?$(IL/(B . "0x648E") ; <CJK>
       (?$(IL0(B . "0x648D") ; <CJK>
       (?$(IL1(B . "0x6494") ; <CJK>
       (?$(IL2(B . "0x64C6") ; <CJK>
       (?$(IL3(B . "0x3A44") ; <CJK>
       (?$(IL4(B . "0x64A8") ; <CJK>
       (?$(IL5(B . "0x6483") ; <CJK>
       (?$(IL6(B . "0x3A3C") ; <CJK>
       (?$(IL7(B . "0x64B9") ; <CJK>
       (?$(IL8(B . "0x6486") ; <CJK>
       (?$(IL9(B . "0x64B4") ; <CJK>
       (?$(IL:(B . "0x64AF") ; <CJK>
       (?$(IL;(B . "0x6491") ; <CJK>
       (?$(IL<(B . "0x3A4E") ; <CJK>
       (?$(IL=(B . "0x64AA") ; <CJK>
       (?$(IL>(B . "0x64A1") ; <CJK>
       (?$(IL?(B . "0x64A7") ; <CJK>
       (?$(IL@(B . "0x66B6") ; <CJK>
       (?$(ILA(B . "0x66B3") ; <CJK>
       (?$(ILB(B . "0x3B14") ; <CJK>
       (?$(ILC(B . "0x66BC") ; <CJK>
       (?$(ILD(B . "0x66AC") ; <CJK>
       (?$(ILE(B . "0x3B15") ; <CJK>
       (?$(ILF(B . "0x66AD") ; <CJK>
       (?$(ILG(B . "0x6A0E") ; <CJK>
       (?$(ILH(B . "0x3BCE") ; <CJK>
       (?$(ILI(B . "0x6A1C") ; <CJK>
       (?$(ILJ(B . "0x6A1A") ; <CJK>
       (?$(ILK(B . "0x3BE0") ; <CJK>
       (?$(ILL(B . "0x3BC2") ; <CJK>
       (?$(ILM(B . "0x6A0B") ; <CJK>
       (?$(ILN(B . "0x3BBF") ; <CJK>
       (?$(ILO(B . "0x69EF") ; <CJK>
       (?$(ILP(B . "0x6A0C") ; <CJK>
       (?$(ILQ(B . "0x69F0") ; <CJK>
       (?$(ILR(B . "0x6A22") ; <CJK>
       (?$(ILS(B . "0x3BC4") ; <CJK>
       (?$(ILT(B . "0x69D8") ; <CJK>
       (?$(ILU(B . "0x3BCF") ; <CJK>
       (?$(ILV(B . "0x6A12") ; <CJK>
       (?$(ILW(B . "0x69FA") ; <CJK>
       (?$(ILX(B . "0x3BC8") ; <CJK>
       (?$(ILY(B . "0x6A2A") ; <CJK>
       (?$(ILZ(B . "0x3BCC") ; <CJK>
       (?$(IL[(B . "0x6A10") ; <CJK>
       (?$(IL\(B . "0x3BCD") ; <CJK>
       (?$(IL](B . "0x3BC7") ; <CJK>
       (?$(IL^(B . "0x6A29") ; <CJK>
       (?$(IL_(B . "0x69F9") ; <CJK>
       (?$(IL`(B . "0x69EA") ; <CJK>
       (?$(ILa(B . "0x6A2C") ; <CJK>
       (?$(ILb(B . "0x6A24") ; <CJK>
       (?$(ILc(B . "0x4CB7") ; <CJK>
       (?$(ILd(B . "0x69E9") ; <CJK>
       (?$(ILe(B . "0x6B52") ; <CJK>
       (?$(ILf(B . "0x6B4F") ; <CJK>
       (?$(ILg(B . "0x6B53") ; <CJK>
       (?$(ILh(B . "0x3C43") ; <CJK>
       (?$(ILi(B . "0x3CB6") ; <CJK>
       (?$(ILj(B . "0x6F10") ; <CJK>
       (?$(ILk(B . "0x6F65") ; <CJK>
       (?$(ILl(B . "0x6F75") ; <CJK>
       (?$(ILm(B . "0x3D51") ; <CJK>
       (?$(ILn(B . "0x3D4A") ; <CJK>
       (?$(ILo(B . "0x3D4D") ; <CJK>
       (?$(ILp(B . "0x3D56") ; <CJK>
       (?$(ILq(B . "0x6FD0") ; <CJK>
       (?$(ILr(B . "0x3D53") ; <CJK>
       (?$(ILs(B . "0x6F5C") ; <CJK>
       (?$(ILt(B . "0x6F3D") ; <CJK>
       (?$(ILu(B . "0x6F71") ; <CJK>
       (?$(ILv(B . "0x3D59") ; <CJK>
       (?$(ILw(B . "0x6F91") ; <CJK>
       (?$(ILx(B . "0x6F0B") ; <CJK>
       (?$(ILy(B . "0x6F79") ; <CJK>
       (?$(ILz(B . "0x6F81") ; <CJK>
       (?$(IL{(B . "0x6F8F") ; <CJK>
       (?$(IL|(B . "0x3D4E") ; <CJK>
       (?$(IL}(B . "0x6F59") ; <CJK>
       (?$(IL~(B . "0x6F74") ; <CJK>
       (?$(IM!(B . "0x3DEE") ; <CJK>
       (?$(IM"(B . "0x71AE") ; <CJK>
       (?$(IM#(B . "0x3DEC") ; <CJK>
       (?$(IM$(B . "0x71A3") ; <CJK>
       (?$(IM%(B . "0x71AD") ; <CJK>
       (?$(IM&(B . "0x3DEB") ; <CJK>
       (?$(IM'(B . "0x3DEF") ; <CJK>
       (?$(IM((B . "0x71AB") ; <CJK>
       (?$(IM)(B . "0x71A6") ; <CJK>
       (?$(IM*(B . "0x71A2") ; <CJK>
       (?$(IM+(B . "0x3DED") ; <CJK>
       (?$(IM,(B . "0x52F2") ; <CJK>
       (?$(IM-(B . "0x7257") ; <CJK>
       (?$(IM.(B . "0x7255") ; <CJK>
       (?$(IM/(B . "0x7299") ; <CJK>
       (?$(IM0(B . "0x734B") ; <CJK>
       (?$(IM1(B . "0x747A") ; <CJK>
       (?$(IM2(B . "0x3EF2") ; <CJK>
       (?$(IM3(B . "0x3EEF") ; <CJK>
       (?$(IM4(B . "0x3EF1") ; <CJK>
       (?$(IM5(B . "0x748C") ; <CJK>
       (?$(IM6(B . "0x7484") ; <CJK>
       (?$(IM7(B . "0x3EED") ; <CJK>
       (?$(IM8(B . "0x3EF0") ; <CJK>
       (?$(IM9(B . "0x7482") ; <CJK>
       (?$(IM:(B . "0x7493") ; <CJK>
       (?$(IM;(B . "0x747B") ; <CJK>
       (?$(IM<(B . "0x3EEE") ; <CJK>
       (?$(IM=(B . "0x7509") ; <CJK>
       (?$(IM>(B . "0x4C1B") ; <CJK>
       (?$(IM?(B . "0x3F50") ; <CJK>
       (?$(IM@(B . "0x3F66") ; <CJK>
       (?$(IMA(B . "0x3684") ; <CJK>
       (?$(IMB(B . "0x3FB8") ; <CJK>
       (?$(IMC(B . "0x3FF6") ; <CJK>
       (?$(IMD(B . "0x778A") ; <CJK>
       (?$(IME(B . "0x4057") ; <CJK>
       (?$(IMF(B . "0x7790") ; <CJK>
       (?$(IMG(B . "0x405E") ; <CJK>
       (?$(IMH(B . "0x78C6") ; <CJK>
       (?$(IMI(B . "0x78D3") ; <CJK>
       (?$(IMJ(B . "0x78C0") ; <CJK>
       (?$(IMK(B . "0x78D2") ; <CJK>
       (?$(IML(B . "0x78C7") ; <CJK>
       (?$(IMM(B . "0x78C2") ; <CJK>
       (?$(IMN(B . "0x4119") ; <CJK>
       (?$(IMO(B . "0x799F") ; <CJK>
       (?$(IMP(B . "0x799D") ; <CJK>
       (?$(IMQ(B . "0x799E") ; <CJK>
       (?$(IMR(B . "0x4170") ; <CJK>
       (?$(IMS(B . "0x7A41") ; <CJK>
       (?$(IMT(B . "0x416E") ; <CJK>
       (?$(IMU(B . "0x7A38") ; <CJK>
       (?$(IMV(B . "0x7A3A") ; <CJK>
       (?$(IMW(B . "0x7A42") ; <CJK>
       (?$(IMX(B . "0x4172") ; <CJK>
       (?$(IMY(B . "0x4176") ; <CJK>
       (?$(IMZ(B . "0x7A3E") ; <CJK>
       (?$(IM[(B . "0x7AB0") ; <CJK>
       (?$(IM\(B . "0x7BAE") ; <CJK>
       (?$(IM](B . "0x7BB3") ; <CJK>
       (?$(IM^(B . "0x4212") ; <CJK>
       (?$(IM_(B . "0x421F") ; <CJK>
       (?$(IM`(B . "0x7BBF") ; <CJK>
       (?$(IMa(B . "0x4211") ; <CJK>
       (?$(IMb(B . "0x4216") ; <CJK>
       (?$(IMc(B . "0x7BCD") ; <CJK>
       (?$(IMd(B . "0x4219") ; <CJK>
       (?$(IMe(B . "0x7BB2") ; <CJK>
       (?$(IMf(B . "0x4224") ; <CJK>
       (?$(IMg(B . "0x4214") ; <CJK>
       (?$(IMh(B . "0x4225") ; <CJK>
       (?$(IMi(B . "0x4295") ; <CJK>
       (?$(IMj(B . "0x4296") ; <CJK>
       (?$(IMk(B . "0x4293") ; <CJK>
       (?$(IMl(B . "0x4294") ; <CJK>
       (?$(IMm(B . "0x7CC4") ; <CJK>
       (?$(IMn(B . "0x7CCD") ; <CJK>
       (?$(IMo(B . "0x7CC2") ; <CJK>
       (?$(IMp(B . "0x7CC6") ; <CJK>
       (?$(IMq(B . "0x7CC3") ; <CJK>
       (?$(IMr(B . "0x7CC9") ; <CJK>
       (?$(IMs(B . "0x7CC7") ; <CJK>
       (?$(IMt(B . "0x42A0") ; <CJK>
       (?$(IMu(B . "0x7DF8") ; <CJK>
       (?$(IMv(B . "0x42FB") ; <CJK>
       (?$(IMw(B . "0x7DED") ; <CJK>
       (?$(IMx(B . "0x7DE2") ; <CJK>
       (?$(IMy(B . "0x42FC") ; <CJK>
       (?$(IMz(B . "0x4300") ; <CJK>
       (?$(IM{(B . "0x42F8") ; <CJK>
       (?$(IM|(B . "0x7DDC") ; <CJK>
       (?$(IM}(B . "0x7E02") ; <CJK>
       (?$(IM~(B . "0x7E01") ; <CJK>
       (?$(IN!(B . "0x42F9") ; <CJK>
       (?$(IN"(B . "0x7DD6") ; <CJK>
       (?$(IN#(B . "0x4304") ; <CJK>
       (?$(IN$(B . "0x7DE4") ; <CJK>
       (?$(IN%(B . "0x7DFE") ; <CJK>
       (?$(IN&(B . "0x4303") ; <CJK>
       (?$(IN'(B . "0x7E00") ; <CJK>
       (?$(IN((B . "0x7DFC") ; <CJK>
       (?$(IN)(B . "0x7DFD") ; <CJK>
       (?$(IN*(B . "0x42F3") ; <CJK>
       (?$(IN+(B . "0x7DF5") ; <CJK>
       (?$(IN,(B . "0x7DFF") ; <CJK>
       (?$(IN-(B . "0x42FA") ; <CJK>
       (?$(IN.(B . "0x7DEB") ; <CJK>
       (?$(IN/(B . "0x7DE5") ; <CJK>
       (?$(IN0(B . "0x7F78") ; <CJK>
       (?$(IN1(B . "0x7FAE") ; <CJK>
       (?$(IN2(B . "0x7FE7") ; <CJK>
       (?$(IN3(B . "0x43BF") ; <CJK>
       (?$(IN4(B . "0x8065") ; <CJK>
       (?$(IN5(B . "0x806A") ; <CJK>
       (?$(IN6(B . "0x8066") ; <CJK>
       (?$(IN7(B . "0x8068") ; <CJK>
       (?$(IN8(B . "0x806B") ; <CJK>
       (?$(IN9(B . "0x8194") ; <CJK>
       (?$(IN:(B . "0x81A1") ; <CJK>
       (?$(IN;(B . "0x8192") ; <CJK>
       (?$(IN<(B . "0x8196") ; <CJK>
       (?$(IN=(B . "0x8193") ; <CJK>
       (?$(IN>(B . "0x4479") ; <CJK>
       (?$(IN?(B . "0x4510") ; <CJK>
       (?$(IN@(B . "0x8501") ; <CJK>
       (?$(INA(B . "0x4514") ; <CJK>
       (?$(INB(B . "0x84F8") ; <CJK>
       (?$(INC(B . "0x450E") ; <CJK>
       (?$(IND(B . "0x84F5") ; <CJK>
       (?$(INE(B . "0x451A") ; <CJK>
       (?$(INF(B . "0x8504") ; <CJK>
       (?$(ING(B . "0x4519") ; <CJK>
       (?$(INH(B . "0x4521") ; <CJK>
       (?$(INI(B . "0x4523") ; <CJK>
       (?$(INJ(B . "0x451F") ; <CJK>
       (?$(INK(B . "0x851B") ; <CJK>
       (?$(INL(B . "0x8503") ; <CJK>
       (?$(INM(B . "0x8533") ; <CJK>
       (?$(INN(B . "0x8534") ; <CJK>
       (?$(INO(B . "0x84ED") ; <CJK>
       (?$(INP(B . "0x4525") ; <CJK>
       (?$(INQ(B . "0x452B") ; <CJK>
       (?$(INR(B . "0x8535") ; <CJK>
       (?$(INS(B . "0x4516") ; <CJK>
       (?$(INT(B . "0x8505") ; <CJK>
       (?$(INU(B . "0x4522") ; <CJK>
       (?$(INV(B . "0x451B") ; <CJK>
       (?$(INW(B . "0x45CE") ; <CJK>
       (?$(INX(B . "0x45CF") ; <CJK>
       (?$(INY(B . "0x877D") ; <CJK>
       (?$(INZ(B . "0x45CB") ; <CJK>
       (?$(IN[(B . "0x45D1") ; <CJK>
       (?$(IN\(B . "0x45CC") ; <CJK>
       (?$(IN](B . "0x8771") ; <CJK>
       (?$(IN^(B . "0x4617") ; <CJK>
       (?$(IN_(B . "0x885C") ; <CJK>
       (?$(IN`(B . "0x88E6") ; <CJK>
       (?$(INa(B . "0x890F") ; <CJK>
       (?$(INb(B . "0x891B") ; <CJK>
       (?$(INc(B . "0x4651") ; <CJK>
       (?$(INd(B . "0x89A9") ; <CJK>
       (?$(INe(B . "0x89A5") ; <CJK>
       (?$(INf(B . "0x89EE") ; <CJK>
       (?$(INg(B . "0x8AB1") ; <CJK>
       (?$(INh(B . "0x46ED") ; <CJK>
       (?$(INi(B . "0x8ACC") ; <CJK>
       (?$(INj(B . "0x8ACE") ; <CJK>
       (?$(INk(B . "0x46F4") ; <CJK>
       (?$(INl(B . "0x8AB7") ; <CJK>
       (?$(INm(B . "0x46F1") ; <CJK>
       (?$(INn(B . "0x8AB5") ; <CJK>
       (?$(INo(B . "0x8AE9") ; <CJK>
       (?$(INp(B . "0x8AB4") ; <CJK>
       (?$(INq(B . "0x46F8") ; <CJK>
       (?$(INr(B . "0x8AB3") ; <CJK>
       (?$(INs(B . "0x8AC1") ; <CJK>
       (?$(INt(B . "0x8AAF") ; <CJK>
       (?$(INu(B . "0x8ACA") ; <CJK>
       (?$(INv(B . "0x8AD0") ; <CJK>
       (?$(INw(B . "0x472F") ; <CJK>
       (?$(INx(B . "0x475E") ; <CJK>
       (?$(INy(B . "0x475D") ; <CJK>
       (?$(INz(B . "0x8C8E") ; <CJK>
       (?$(IN{(B . "0x4776") ; <CJK>
       (?$(IN|(B . "0x4777") ; <CJK>
       (?$(IN}(B . "0x8CE9") ; <CJK>
       (?$(IN~(B . "0x8CDB") ; <CJK>
       (?$(IO!(B . "0x477E") ; <CJK>
       (?$(IO"(B . "0x8CEB") ; <CJK>
       (?$(IO#(B . "0x8DA4") ; <CJK>
       (?$(IO$(B . "0x47B6") ; <CJK>
       (?$(IO%(B . "0x8DA2") ; <CJK>
       (?$(IO&(B . "0x8D9D") ; <CJK>
       (?$(IO'(B . "0x47B3") ; <CJK>
       (?$(IO((B . "0x47FC") ; <CJK>
       (?$(IO)(B . "0x4803") ; <CJK>
       (?$(IO*(B . "0x4800") ; <CJK>
       (?$(IO+(B . "0x8E2A") ; <CJK>
       (?$(IO,(B . "0x8E28") ; <CJK>
       (?$(IO-(B . "0x480A") ; <CJK>
       (?$(IO.(B . "0x4802") ; <CJK>
       (?$(IO/(B . "0x8EB8") ; <CJK>
       (?$(IO0(B . "0x8EB6") ; <CJK>
       (?$(IO1(B . "0x8EB9") ; <CJK>
       (?$(IO2(B . "0x8EB7") ; <CJK>
       (?$(IO3(B . "0x8F22") ; <CJK>
       (?$(IO4(B . "0x8F2B") ; <CJK>
       (?$(IO5(B . "0x8F27") ; <CJK>
       (?$(IO6(B . "0x8F19") ; <CJK>
       (?$(IO7(B . "0x8FA4") ; <CJK>
       (?$(IO8(B . "0x4887") ; <CJK>
       (?$(IO9(B . "0x8FB3") ; <CJK>
       (?$(IO:(B . "0x48A6") ; <CJK>
       (?$(IO;(B . "0x9071") ; <CJK>
       (?$(IO<(B . "0x906A") ; <CJK>
       (?$(IO=(B . "0x48A9") ; <CJK>
       (?$(IO>(B . "0x48DE") ; <CJK>
       (?$(IO?(B . "0x9188") ; <CJK>
       (?$(IO@(B . "0x918C") ; <CJK>
       (?$(IOA(B . "0x92BF") ; <CJK>
       (?$(IOB(B . "0x92B8") ; <CJK>
       (?$(IOC(B . "0x92BE") ; <CJK>
       (?$(IOD(B . "0x92DC") ; <CJK>
       (?$(IOE(B . "0x92E5") ; <CJK>
       (?$(IOF(B . "0x492E") ; <CJK>
       (?$(IOG(B . "0x492D") ; <CJK>
       (?$(IOH(B . "0x92D4") ; <CJK>
       (?$(IOI(B . "0x92D6") ; <CJK>
       (?$(IOJ(B . "0x4930") ; <CJK>
       (?$(IOK(B . "0x92DA") ; <CJK>
       (?$(IOL(B . "0x92ED") ; <CJK>
       (?$(IOM(B . "0x92F3") ; <CJK>
       (?$(ION(B . "0x92DB") ; <CJK>
       (?$(IOO(B . "0x492B") ; <CJK>
       (?$(IOP(B . "0x92B9") ; <CJK>
       (?$(IOQ(B . "0x92E2") ; <CJK>
       (?$(IOR(B . "0x92EB") ; <CJK>
       (?$(IOS(B . "0x95AF") ; <CJK>
       (?$(IOT(B . "0x499E") ; <CJK>
       (?$(IOU(B . "0x95B2") ; <CJK>
       (?$(IOV(B . "0x95B3") ; <CJK>
       (?$(IOW(B . "0x499F") ; <CJK>
       (?$(IOX(B . "0x49E5") ; <CJK>
       (?$(IOY(B . "0x49E4") ; <CJK>
       (?$(IOZ(B . "0x96A3") ; <CJK>
       (?$(IO[(B . "0x96A5") ; <CJK>
       (?$(IO\(B . "0x49FD") ; <CJK>
       (?$(IO](B . "0x49FC") ; <CJK>
       (?$(IO^(B . "0x4A17") ; <CJK>
       (?$(IO_(B . "0x4A19") ; <CJK>
       (?$(IO`(B . "0x970A") ; <CJK>
       (?$(IOa(B . "0x4A18") ; <CJK>
       (?$(IOb(B . "0x9787") ; <CJK>
       (?$(IOc(B . "0x9789") ; <CJK>
       (?$(IOd(B . "0x978C") ; <CJK>
       (?$(IOe(B . "0x97EF") ; <CJK>
       (?$(IOf(B . "0x982A") ; <CJK>
       (?$(IOg(B . "0x9822") ; <CJK>
       (?$(IOh(B . "0x4ABF") ; <CJK>
       (?$(IOi(B . "0x981F") ; <CJK>
       (?$(IOj(B . "0x4B3C") ; <CJK>
       (?$(IOk(B . "0x9919") ; <CJK>
       (?$(IOl(B . "0x4B6B") ; <CJK>
       (?$(IOm(B . "0x99CA") ; <CJK>
       (?$(IOn(B . "0x99DA") ; <CJK>
       (?$(IOo(B . "0x4B83") ; <CJK>
       (?$(IOp(B . "0x4B81") ; <CJK>
       (?$(IOq(B . "0x4B80") ; <CJK>
       (?$(IOr(B . "0x99DE") ; <CJK>
       (?$(IOs(B . "0x99C8") ; <CJK>
       (?$(IOt(B . "0x99E0") ; <CJK>
       (?$(IOu(B . "0x4BCA") ; <CJK>
       (?$(IOv(B . "0x9AB6") ; <CJK>
       (?$(IOw(B . "0x9AB5") ; <CJK>
       (?$(IOx(B . "0x4BCE") ; <CJK>
       (?$(IOy(B . "0x9AF4") ; <CJK>
       (?$(IOz(B . "0x4BF6") ; <CJK>
       (?$(IO{(B . "0x9B6B") ; <CJK>
       (?$(IO|(B . "0x9B69") ; <CJK>
       (?$(IO}(B . "0x9B72") ; <CJK>
       (?$(IO~(B . "0x9B63") ; <CJK>
       (?$(IP!(B . "0x4C39") ; <CJK>
       (?$(IP"(B . "0x9D0D") ; <CJK>
       (?$(IP#(B . "0x4CAE") ; <CJK>
       (?$(IP$(B . "0x9D01") ; <CJK>
       (?$(IP%(B . "0x9D0C") ; <CJK>
       (?$(IP&(B . "0x4CB5") ; <CJK>
       (?$(IP'(B . "0x9CF8") ; <CJK>
       (?$(IP((B . "0x4CB3") ; <CJK>
       (?$(IP)(B . "0x4CB4") ; <CJK>
       (?$(IP*(B . "0x9CFE") ; <CJK>
       (?$(IP+(B . "0x9D02") ; <CJK>
       (?$(IP,(B . "0x9E84") ; <CJK>
       (?$(IP-(B . "0x4D22") ; <CJK>
       (?$(IP.(B . "0x9EAB") ; <CJK>
       (?$(IP/(B . "0x9EAA") ; <CJK>
       (?$(IP0(B . "0x511D") ; <CJK>
       (?$(IP1(B . "0x5116") ; <CJK>
       (?$(IP2(B . "0x3499") ; <CJK>
       (?$(IP3(B . "0x512B") ; <CJK>
       (?$(IP4(B . "0x511E") ; <CJK>
       (?$(IP5(B . "0x511B") ; <CJK>
       (?$(IP6(B . "0x5290") ; <CJK>
       (?$(IP7(B . "0x5294") ; <CJK>
       (?$(IP8(B . "0x5314") ; <CJK>
       (?$(IP9(B . "0x20B89") ; <CJK>
       (?$(IP:(B . "0x3602") ; <CJK>
       (?$(IP;(B . "0x5667") ; <CJK>
       (?$(IP<(B . "0x3601") ; <CJK>
       (?$(IP=(B . "0x567B") ; <CJK>
       (?$(IP>(B . "0x36A1") ; <CJK>
       (?$(IP?(B . "0x565F") ; <CJK>
       (?$(IP@(B . "0x5661") ; <CJK>
       (?$(IPA(B . "0x35FD") ; <CJK>
       (?$(IPB(B . "0x3673") ; <CJK>
       (?$(IPC(B . "0x3674") ; <CJK>
       (?$(IPD(B . "0x3670") ; <CJK>
       (?$(IPE(B . "0x3676") ; <CJK>
       (?$(IPF(B . "0x3675") ; <CJK>
       (?$(IPG(B . "0x3672") ; <CJK>
       (?$(IPH(B . "0x58C3") ; <CJK>
       (?$(IPI(B . "0x58CA") ; <CJK>
       (?$(IPJ(B . "0x58BB") ; <CJK>
       (?$(IPK(B . "0x58C0") ; <CJK>
       (?$(IPL(B . "0x58C4") ; <CJK>
       (?$(IPM(B . "0x5901") ; <CJK>
       (?$(IPN(B . "0x5B1F") ; <CJK>
       (?$(IPO(B . "0x5B18") ; <CJK>
       (?$(IPP(B . "0x5B11") ; <CJK>
       (?$(IPQ(B . "0x5B15") ; <CJK>
       (?$(IPR(B . "0x3729") ; <CJK>
       (?$(IPS(B . "0x5B12") ; <CJK>
       (?$(IPT(B . "0x5B1C") ; <CJK>
       (?$(IPU(B . "0x372A") ; <CJK>
       (?$(IPV(B . "0x5B22") ; <CJK>
       (?$(IPW(B . "0x5B79") ; <CJK>
       (?$(IPX(B . "0x5DA6") ; <CJK>
       (?$(IPY(B . "0x3816") ; <CJK>
       (?$(IPZ(B . "0x5DB3") ; <CJK>
       (?$(IP[(B . "0x5DAB") ; <CJK>
       (?$(IP\(B . "0x5EEA") ; <CJK>
       (?$(IP](B . "0x3899") ; <CJK>
       (?$(IP^(B . "0x5F5B") ; <CJK>
       (?$(IP_(B . "0x38D3") ; <CJK>
       (?$(IP`(B . "0x38F5") ; <CJK>
       (?$(IPa(B . "0x61B7") ; <CJK>
       (?$(IPb(B . "0x61CE") ; <CJK>
       (?$(IPc(B . "0x61B9") ; <CJK>
       (?$(IPd(B . "0x61BD") ; <CJK>
       (?$(IPe(B . "0x61CF") ; <CJK>
       (?$(IPf(B . "0x61C0") ; <CJK>
       (?$(IPg(B . "0x6199") ; <CJK>
       (?$(IPh(B . "0x6197") ; <CJK>
       (?$(IPi(B . "0x3994") ; <CJK>
       (?$(IPj(B . "0x61BB") ; <CJK>
       (?$(IPk(B . "0x61D0") ; <CJK>
       (?$(IPl(B . "0x61C4") ; <CJK>
       (?$(IPm(B . "0x6231") ; <CJK>
       (?$(IPn(B . "0x3A56") ; <CJK>
       (?$(IPo(B . "0x64D3") ; <CJK>
       (?$(IPp(B . "0x64C0") ; <CJK>
       (?$(IPq(B . "0x3A59") ; <CJK>
       (?$(IPr(B . "0x3A58") ; <CJK>
       (?$(IPs(B . "0x3A55") ; <CJK>
       (?$(IPt(B . "0x3A52") ; <CJK>
       (?$(IPu(B . "0x64DC") ; <CJK>
       (?$(IPv(B . "0x64D1") ; <CJK>
       (?$(IPw(B . "0x64C8") ; <CJK>
       (?$(IPx(B . "0x3A57") ; <CJK>
       (?$(IPy(B . "0x64D5") ; <CJK>
       (?$(IPz(B . "0x66C3") ; <CJK>
       (?$(IP{(B . "0x3B1B") ; <CJK>
       (?$(IP|(B . "0x3B1C") ; <CJK>
       (?$(IP}(B . "0x66BF") ; <CJK>
       (?$(IP~(B . "0x66C5") ; <CJK>
       (?$(IQ!(B . "0x3B19") ; <CJK>
       (?$(IQ"(B . "0x66CD") ; <CJK>
       (?$(IQ#(B . "0x66C1") ; <CJK>
       (?$(IQ$(B . "0x6706") ; <CJK>
       (?$(IQ%(B . "0x3B3F") ; <CJK>
       (?$(IQ&(B . "0x6724") ; <CJK>
       (?$(IQ'(B . "0x6A63") ; <CJK>
       (?$(IQ((B . "0x6A42") ; <CJK>
       (?$(IQ)(B . "0x6A52") ; <CJK>
       (?$(IQ*(B . "0x3BDB") ; <CJK>
       (?$(IQ+(B . "0x6A43") ; <CJK>
       (?$(IQ,(B . "0x6A33") ; <CJK>
       (?$(IQ-(B . "0x3BE2") ; <CJK>
       (?$(IQ.(B . "0x6A6C") ; <CJK>
       (?$(IQ/(B . "0x6A57") ; <CJK>
       (?$(IQ0(B . "0x3BD7") ; <CJK>
       (?$(IQ1(B . "0x6A4C") ; <CJK>
       (?$(IQ2(B . "0x6A6E") ; <CJK>
       (?$(IQ3(B . "0x3BDE") ; <CJK>
       (?$(IQ4(B . "0x3BE5") ; <CJK>
       (?$(IQ5(B . "0x3BE4") ; <CJK>
       (?$(IQ6(B . "0x3BE6") ; <CJK>
       (?$(IQ7(B . "0x3BD6") ; <CJK>
       (?$(IQ8(B . "0x6A37") ; <CJK>
       (?$(IQ9(B . "0x3BDF") ; <CJK>
       (?$(IQ:(B . "0x6A71") ; <CJK>
       (?$(IQ;(B . "0x6A4A") ; <CJK>
       (?$(IQ<(B . "0x6A36") ; <CJK>
       (?$(IQ=(B . "0x3BDC") ; <CJK>
       (?$(IQ>(B . "0x6A53") ; <CJK>
       (?$(IQ?(B . "0x3BDA") ; <CJK>
       (?$(IQ@(B . "0x6A45") ; <CJK>
       (?$(IQA(B . "0x6A70") ; <CJK>
       (?$(IQB(B . "0x3BD3") ; <CJK>
       (?$(IQC(B . "0x3BD0") ; <CJK>
       (?$(IQD(B . "0x6A5C") ; <CJK>
       (?$(IQE(B . "0x6B58") ; <CJK>
       (?$(IQF(B . "0x6B57") ; <CJK>
       (?$(IQG(B . "0x3C86") ; <CJK>
       (?$(IQH(B . "0x3C87") ; <CJK>
       (?$(IQI(B . "0x3CAD") ; <CJK>
       (?$(IQJ(B . "0x3CB7") ; <CJK>
       (?$(IQK(B . "0x3D58") ; <CJK>
       (?$(IQL(B . "0x3D6A") ; <CJK>
       (?$(IQM(B . "0x6FBB") ; <CJK>
       (?$(IQN(B . "0x3D62") ; <CJK>
       (?$(IQO(B . "0x3D61") ; <CJK>
       (?$(IQP(B . "0x6FBE") ; <CJK>
       (?$(IQQ(B . "0x3D69") ; <CJK>
       (?$(IQR(B . "0x3D6C") ; <CJK>
       (?$(IQS(B . "0x3D65") ; <CJK>
       (?$(IQT(B . "0x6FB5") ; <CJK>
       (?$(IQU(B . "0x6FD3") ; <CJK>
       (?$(IQV(B . "0x6F9F") ; <CJK>
       (?$(IQW(B . "0x3D66") ; <CJK>
       (?$(IQX(B . "0x6FB7") ; <CJK>
       (?$(IQY(B . "0x6FF5") ; <CJK>
       (?$(IQZ(B . "0x71B7") ; <CJK>
       (?$(IQ[(B . "0x3DF5") ; <CJK>
       (?$(IQ\(B . "0x71BB") ; <CJK>
       (?$(IQ](B . "0x3DF4") ; <CJK>
       (?$(IQ^(B . "0x71D1") ; <CJK>
       (?$(IQ_(B . "0x3DF7") ; <CJK>
       (?$(IQ`(B . "0x71BA") ; <CJK>
       (?$(IQa(B . "0x3DF8") ; <CJK>
       (?$(IQb(B . "0x71B6") ; <CJK>
       (?$(IQc(B . "0x71CC") ; <CJK>
       (?$(IQd(B . "0x3DFB") ; <CJK>
       (?$(IQe(B . "0x3DFC") ; <CJK>
       (?$(IQf(B . "0x71D3") ; <CJK>
       (?$(IQg(B . "0x749B") ; <CJK>
       (?$(IQh(B . "0x3EF5") ; <CJK>
       (?$(IQi(B . "0x3EF8") ; <CJK>
       (?$(IQj(B . "0x7496") ; <CJK>
       (?$(IQk(B . "0x74A2") ; <CJK>
       (?$(IQl(B . "0x749D") ; <CJK>
       (?$(IQm(B . "0x750A") ; <CJK>
       (?$(IQn(B . "0x750E") ; <CJK>
       (?$(IQo(B . "0x3F3C") ; <CJK>
       (?$(IQp(B . "0x7581") ; <CJK>
       (?$(IQq(B . "0x762C") ; <CJK>
       (?$(IQr(B . "0x7637") ; <CJK>
       (?$(IQs(B . "0x7636") ; <CJK>
       (?$(IQt(B . "0x763B") ; <CJK>
       (?$(IQu(B . "0x3FC5") ; <CJK>
       (?$(IQv(B . "0x76A1") ; <CJK>
       (?$(IQw(B . "0x4062") ; <CJK>
       (?$(IQx(B . "0x4063") ; <CJK>
       (?$(IQy(B . "0x7798") ; <CJK>
       (?$(IQz(B . "0x4067") ; <CJK>
       (?$(IQ{(B . "0x7796") ; <CJK>
       (?$(IQ|(B . "0x4066") ; <CJK>
       (?$(IQ}(B . "0x40D9") ; <CJK>
       (?$(IQ~(B . "0x40DB") ; <CJK>
       (?$(IR!(B . "0x78D6") ; <CJK>
       (?$(IR"(B . "0x78EB") ; <CJK>
       (?$(IR#(B . "0x40D8") ; <CJK>
       (?$(IR$(B . "0x78DC") ; <CJK>
       (?$(IR%(B . "0x411B") ; <CJK>
       (?$(IR&(B . "0x79A5") ; <CJK>
       (?$(IR'(B . "0x79A9") ; <CJK>
       (?$(IR((B . "0x9834") ; <CJK>
       (?$(IR)(B . "0x7A53") ; <CJK>
       (?$(IR*(B . "0x7A45") ; <CJK>
       (?$(IR+(B . "0x4179") ; <CJK>
       (?$(IR,(B . "0x7A4F") ; <CJK>
       (?$(IR-(B . "0x417D") ; <CJK>
       (?$(IR.(B . "0x7ABD") ; <CJK>
       (?$(IR/(B . "0x7ABB") ; <CJK>
       (?$(IR0(B . "0x7AF1") ; <CJK>
       (?$(IR1(B . "0x422C") ; <CJK>
       (?$(IR2(B . "0x4237") ; <CJK>
       (?$(IR3(B . "0x7BEC") ; <CJK>
       (?$(IR4(B . "0x7BED") ; <CJK>
       (?$(IR5(B . "0x4230") ; <CJK>
       (?$(IR6(B . "0x429A") ; <CJK>
       (?$(IR7(B . "0x7CD3") ; <CJK>
       (?$(IR8(B . "0x4A00") ; <CJK>
       (?$(IR9(B . "0x7CE1") ; <CJK>
       (?$(IR:(B . "0x4305") ; <CJK>
       (?$(IR;(B . "0x7E19") ; <CJK>
       (?$(IR<(B . "0x4307") ; <CJK>
       (?$(IR=(B . "0x4309") ; <CJK>
       (?$(IR>(B . "0x430A") ; <CJK>
       (?$(IR?(B . "0x7E27") ; <CJK>
       (?$(IR@(B . "0x7E26") ; <CJK>
       (?$(IRA(B . "0x4379") ; <CJK>
       (?$(IRB(B . "0x43C2") ; <CJK>
       (?$(IRC(B . "0x806E") ; <CJK>
       (?$(IRD(B . "0x81AF") ; <CJK>
       (?$(IRE(B . "0x4438") ; <CJK>
       (?$(IRF(B . "0x4437") ; <CJK>
       (?$(IRG(B . "0x81AD") ; <CJK>
       (?$(IRH(B . "0x4421") ; <CJK>
       (?$(IRI(B . "0x81AA") ; <CJK>
       (?$(IRJ(B . "0x8218") ; <CJK>
       (?$(IRK(B . "0x445E") ; <CJK>
       (?$(IRL(B . "0x453D") ; <CJK>
       (?$(IRM(B . "0x4537") ; <CJK>
       (?$(IRN(B . "0x4540") ; <CJK>
       (?$(IRO(B . "0x856F") ; <CJK>
       (?$(IRP(B . "0x854C") ; <CJK>
       (?$(IRQ(B . "0x451D") ; <CJK>
       (?$(IRR(B . "0x8542") ; <CJK>
       (?$(IRS(B . "0x4533") ; <CJK>
       (?$(IRT(B . "0x855C") ; <CJK>
       (?$(IRU(B . "0x8570") ; <CJK>
       (?$(IRV(B . "0x855F") ; <CJK>
       (?$(IRW(B . "0x4535") ; <CJK>
       (?$(IRX(B . "0x855A") ; <CJK>
       (?$(IRY(B . "0x854B") ; <CJK>
       (?$(IRZ(B . "0x853F") ; <CJK>
       (?$(IR[(B . "0x878A") ; <CJK>
       (?$(IR\(B . "0x45D8") ; <CJK>
       (?$(IR](B . "0x878B") ; <CJK>
       (?$(IR^(B . "0x87A1") ; <CJK>
       (?$(IR_(B . "0x878E") ; <CJK>
       (?$(IR`(B . "0x45DC") ; <CJK>
       (?$(IRa(B . "0x45DE") ; <CJK>
       (?$(IRb(B . "0x8799") ; <CJK>
       (?$(IRc(B . "0x885E") ; <CJK>
       (?$(IRd(B . "0x885F") ; <CJK>
       (?$(IRe(B . "0x8924") ; <CJK>
       (?$(IRf(B . "0x89A7") ; <CJK>
       (?$(IRg(B . "0x8AEA") ; <CJK>
       (?$(IRh(B . "0x8AFD") ; <CJK>
       (?$(IRi(B . "0x8AF9") ; <CJK>
       (?$(IRj(B . "0x8AE3") ; <CJK>
       (?$(IRk(B . "0x8AE5") ; <CJK>
       (?$(IRl(B . "0x46FA") ; <CJK>
       (?$(IRm(B . "0x46FB") ; <CJK>
       (?$(IRn(B . "0x8AEC") ; <CJK>
       (?$(IRo(B . "0x473D") ; <CJK>
       (?$(IRp(B . "0x473B") ; <CJK>
       (?$(IRq(B . "0x473F") ; <CJK>
       (?$(IRr(B . "0x475F") ; <CJK>
       (?$(IRs(B . "0x8CF2") ; <CJK>
       (?$(IRt(B . "0x477F") ; <CJK>
       (?$(IRu(B . "0x8CEF") ; <CJK>
       (?$(IRv(B . "0x4784") ; <CJK>
       (?$(IRw(B . "0x8DA6") ; <CJK>
       (?$(IRx(B . "0x47BC") ; <CJK>
       (?$(IRy(B . "0x4814") ; <CJK>
       (?$(IRz(B . "0x480F") ; <CJK>
       (?$(IR{(B . "0x8E3B") ; <CJK>
       (?$(IR|(B . "0x8E43") ; <CJK>
       (?$(IR}(B . "0x480E") ; <CJK>
       (?$(IR~(B . "0x8E32") ; <CJK>
       (?$(IS!(B . "0x8F31") ; <CJK>
       (?$(IS"(B . "0x8F30") ; <CJK>
       (?$(IS#(B . "0x4860") ; <CJK>
       (?$(IS$(B . "0x8F2D") ; <CJK>
       (?$(IS%(B . "0x8F3C") ; <CJK>
       (?$(IS&(B . "0x8FA7") ; <CJK>
       (?$(IS'(B . "0x8FA5") ; <CJK>
       (?$(IS((B . "0x48AB") ; <CJK>
       (?$(IS)(B . "0x48AC") ; <CJK>
       (?$(IS*(B . "0x48AA") ; <CJK>
       (?$(IS+(B . "0x9137") ; <CJK>
       (?$(IS,(B . "0x9195") ; <CJK>
       (?$(IS-(B . "0x918E") ; <CJK>
       (?$(IS.(B . "0x4904") ; <CJK>
       (?$(IS/(B . "0x9196") ; <CJK>
       (?$(IS0(B . "0x4908") ; <CJK>
       (?$(IS1(B . "0x9345") ; <CJK>
       (?$(IS2(B . "0x930A") ; <CJK>
       (?$(IS3(B . "0x4933") ; <CJK>
       (?$(IS4(B . "0x4934") ; <CJK>
       (?$(IS5(B . "0x92FD") ; <CJK>
       (?$(IS6(B . "0x9317") ; <CJK>
       (?$(IS7(B . "0x931C") ; <CJK>
       (?$(IS8(B . "0x9307") ; <CJK>
       (?$(IS9(B . "0x9331") ; <CJK>
       (?$(IS:(B . "0x9332") ; <CJK>
       (?$(IS;(B . "0x932C") ; <CJK>
       (?$(IS<(B . "0x9330") ; <CJK>
       (?$(IS=(B . "0x9303") ; <CJK>
       (?$(IS>(B . "0x9305") ; <CJK>
       (?$(IS?(B . "0x49A2") ; <CJK>
       (?$(IS@(B . "0x95C2") ; <CJK>
       (?$(ISA(B . "0x49A4") ; <CJK>
       (?$(ISB(B . "0x95B8") ; <CJK>
       (?$(ISC(B . "0x49A5") ; <CJK>
       (?$(ISD(B . "0x95C1") ; <CJK>
       (?$(ISE(B . "0x49A7") ; <CJK>
       (?$(ISF(B . "0x49A6") ; <CJK>
       (?$(ISG(B . "0x49E7") ; <CJK>
       (?$(ISH(B . "0x96AB") ; <CJK>
       (?$(ISI(B . "0x96B7") ; <CJK>
       (?$(ISJ(B . "0x49FF") ; <CJK>
       (?$(ISK(B . "0x49FE") ; <CJK>
       (?$(ISL(B . "0x9715") ; <CJK>
       (?$(ISM(B . "0x9714") ; <CJK>
       (?$(ISN(B . "0x4A1D") ; <CJK>
       (?$(ISO(B . "0x4A1C") ; <CJK>
       (?$(ISP(B . "0x970C") ; <CJK>
       (?$(ISQ(B . "0x9717") ; <CJK>
       (?$(ISR(B . "0x4A67") ; <CJK>
       (?$(ISS(B . "0x9793") ; <CJK>
       (?$(IST(B . "0x4A94") ; <CJK>
       (?$(ISU(B . "0x97D2") ; <CJK>
       (?$(ISV(B . "0x4AC5") ; <CJK>
       (?$(ISW(B . "0x4AC8") ; <CJK>
       (?$(ISX(B . "0x9836") ; <CJK>
       (?$(ISY(B . "0x9831") ; <CJK>
       (?$(ISZ(B . "0x9833") ; <CJK>
       (?$(IS[(B . "0x983C") ; <CJK>
       (?$(IS\(B . "0x982E") ; <CJK>
       (?$(IS](B . "0x983A") ; <CJK>
       (?$(IS^(B . "0x4AC9") ; <CJK>
       (?$(IS_(B . "0x983D") ; <CJK>
       (?$(IS`(B . "0x4AC7") ; <CJK>
       (?$(ISa(B . "0x98B5") ; <CJK>
       (?$(ISb(B . "0x9922") ; <CJK>
       (?$(ISc(B . "0x9923") ; <CJK>
       (?$(ISd(B . "0x9920") ; <CJK>
       (?$(ISe(B . "0x991C") ; <CJK>
       (?$(ISf(B . "0x991D") ; <CJK>
       (?$(ISg(B . "0x4B6C") ; <CJK>
       (?$(ISh(B . "0x99A0") ; <CJK>
       (?$(ISi(B . "0x4B8A") ; <CJK>
       (?$(ISj(B . "0x99EF") ; <CJK>
       (?$(ISk(B . "0x99E8") ; <CJK>
       (?$(ISl(B . "0x99EB") ; <CJK>
       (?$(ISm(B . "0x4B88") ; <CJK>
       (?$(ISn(B . "0x4B87") ; <CJK>
       (?$(ISo(B . "0x4B86") ; <CJK>
       (?$(ISp(B . "0x99E1") ; <CJK>
       (?$(ISq(B . "0x99E6") ; <CJK>
       (?$(ISr(B . "0x4BCF") ; <CJK>
       (?$(ISs(B . "0x4BD0") ; <CJK>
       (?$(ISt(B . "0x9AF8") ; <CJK>
       (?$(ISu(B . "0x9AF5") ; <CJK>
       (?$(ISv(B . "0x4C1C") ; <CJK>
       (?$(ISw(B . "0x4C23") ; <CJK>
       (?$(ISx(B . "0x9B83") ; <CJK>
       (?$(ISy(B . "0x9B94") ; <CJK>
       (?$(ISz(B . "0x9B84") ; <CJK>
       (?$(IS{(B . "0x4C49") ; <CJK>
       (?$(IS|(B . "0x9B8B") ; <CJK>
       (?$(IS}(B . "0x9B8F") ; <CJK>
       (?$(IS~(B . "0x4C43") ; <CJK>
       (?$(IT!(B . "0x9B8C") ; <CJK>
       (?$(IT"(B . "0x4C48") ; <CJK>
       (?$(IT#(B . "0x9B89") ; <CJK>
       (?$(IT$(B . "0x4C47") ; <CJK>
       (?$(IT%(B . "0x9B8E") ; <CJK>
       (?$(IT&(B . "0x4C46") ; <CJK>
       (?$(IT'(B . "0x4C3F") ; <CJK>
       (?$(IT((B . "0x4C44") ; <CJK>
       (?$(IT)(B . "0x9D24") ; <CJK>
       (?$(IT*(B . "0x9D0F") ; <CJK>
       (?$(IT+(B . "0x4CBE") ; <CJK>
       (?$(IT,(B . "0x9D13") ; <CJK>
       (?$(IT-(B . "0x9D0A") ; <CJK>
       (?$(IT.(B . "0x4CC2") ; <CJK>
       (?$(IT/(B . "0x4CBA") ; <CJK>
       (?$(IT0(B . "0x4CBC") ; <CJK>
       (?$(IT1(B . "0x4CC6") ; <CJK>
       (?$(IT2(B . "0x9D2A") ; <CJK>
       (?$(IT3(B . "0x9D1A") ; <CJK>
       (?$(IT4(B . "0x4CC8") ; <CJK>
       (?$(IT5(B . "0x9D27") ; <CJK>
       (?$(IT6(B . "0x9D16") ; <CJK>
       (?$(IT7(B . "0x9D21") ; <CJK>
       (?$(IT8(B . "0x4D23") ; <CJK>
       (?$(IT9(B . "0x9E85") ; <CJK>
       (?$(IT:(B . "0x9EAC") ; <CJK>
       (?$(IT;(B . "0x9EC6") ; <CJK>
       (?$(IT<(B . "0x9EC5") ; <CJK>
       (?$(IT=(B . "0x9ED7") ; <CJK>
       (?$(IT>(B . "0x9F53") ; <CJK>
       (?$(IT?(B . "0x349D") ; <CJK>
       (?$(IT@(B . "0x5128") ; <CJK>
       (?$(ITA(B . "0x5127") ; <CJK>
       (?$(ITB(B . "0x51DF") ; <CJK>
       (?$(ITC(B . "0x3524") ; <CJK>
       (?$(ITD(B . "0x5335") ; <CJK>
       (?$(ITE(B . "0x53B3") ; <CJK>
       (?$(ITF(B . "0x3607") ; <CJK>
       (?$(ITG(B . "0x568A") ; <CJK>
       (?$(ITH(B . "0x567D") ; <CJK>
       (?$(ITI(B . "0x5689") ; <CJK>
       (?$(ITJ(B . "0x3679") ; <CJK>
       (?$(ITK(B . "0x58CD") ; <CJK>
       (?$(ITL(B . "0x58D0") ; <CJK>
       (?$(ITM(B . "0x3678") ; <CJK>
       (?$(ITN(B . "0x5B2B") ; <CJK>
       (?$(ITO(B . "0x5B33") ; <CJK>
       (?$(ITP(B . "0x5B29") ; <CJK>
       (?$(ITQ(B . "0x5B35") ; <CJK>
       (?$(ITR(B . "0x5B31") ; <CJK>
       (?$(ITS(B . "0x5B37") ; <CJK>
       (?$(ITT(B . "0x5C36") ; <CJK>
       (?$(ITU(B . "0x5DBE") ; <CJK>
       (?$(ITV(B . "0x3819") ; <CJK>
       (?$(ITW(B . "0x5DB9") ; <CJK>
       (?$(ITX(B . "0x381C") ; <CJK>
       (?$(ITY(B . "0x5DBB") ; <CJK>
       (?$(ITZ(B . "0x3818") ; <CJK>
       (?$(IT[(B . "0x61E2") ; <CJK>
       (?$(IT\(B . "0x61DB") ; <CJK>
       (?$(IT](B . "0x61DD") ; <CJK>
       (?$(IT^(B . "0x61DC") ; <CJK>
       (?$(IT_(B . "0x61DA") ; <CJK>
       (?$(IT`(B . "0x2F8AF") ; <CJK>
       (?$(ITa(B . "0x61D9") ; <CJK>
       (?$(ITb(B . "0x39BD") ; <CJK>
       (?$(ITc(B . "0x3A5D") ; <CJK>
       (?$(ITd(B . "0x64DF") ; <CJK>
       (?$(ITe(B . "0x3A5A") ; <CJK>
       (?$(ITf(B . "0x3A5E") ; <CJK>
       (?$(ITg(B . "0x64E1") ; <CJK>
       (?$(ITh(B . "0x3A5C") ; <CJK>
       (?$(ITi(B . "0x64EE") ; <CJK>
       (?$(ITj(B . "0x3A5B") ; <CJK>
       (?$(ITk(B . "0x65B5") ; <CJK>
       (?$(ITl(B . "0x66D4") ; <CJK>
       (?$(ITm(B . "0x66D5") ; <CJK>
       (?$(ITn(B . "0x3B21") ; <CJK>
       (?$(ITo(B . "0x66D0") ; <CJK>
       (?$(ITp(B . "0x66D1") ; <CJK>
       (?$(ITq(B . "0x66CE") ; <CJK>
       (?$(ITr(B . "0x66D7") ; <CJK>
       (?$(ITs(B . "0x3B20") ; <CJK>
       (?$(ITt(B . "0x3B32") ; <CJK>
       (?$(ITu(B . "0x6A7D") ; <CJK>
       (?$(ITv(B . "0x6A8A") ; <CJK>
       (?$(ITw(B . "0x3BF2") ; <CJK>
       (?$(ITx(B . "0x6AA7") ; <CJK>
       (?$(ITy(B . "0x3BF5") ; <CJK>
       (?$(ITz(B . "0x6A99") ; <CJK>
       (?$(IT{(B . "0x6A82") ; <CJK>
       (?$(IT|(B . "0x6A88") ; <CJK>
       (?$(IT}(B . "0x3BEE") ; <CJK>
       (?$(IT~(B . "0x3BEC") ; <CJK>
       (?$(IU!(B . "0x6A86") ; <CJK>
       (?$(IU"(B . "0x3BEA") ; <CJK>
       (?$(IU#(B . "0x6A98") ; <CJK>
       (?$(IU$(B . "0x6A9D") ; <CJK>
       (?$(IU%(B . "0x3BED") ; <CJK>
       (?$(IU&(B . "0x3BF3") ; <CJK>
       (?$(IU'(B . "0x6A8F") ; <CJK>
       (?$(IU((B . "0x3BF6") ; <CJK>
       (?$(IU)(B . "0x6AAA") ; <CJK>
       (?$(IU*(B . "0x3C48") ; <CJK>
       (?$(IU+(B . "0x6B5D") ; <CJK>
       (?$(IU,(B . "0x3C49") ; <CJK>
       (?$(IU-(B . "0x6C0A") ; <CJK>
       (?$(IU.(B . "0x3D75") ; <CJK>
       (?$(IU/(B . "0x6FD7") ; <CJK>
       (?$(IU0(B . "0x6FD6") ; <CJK>
       (?$(IU1(B . "0x6FE5") ; <CJK>
       (?$(IU2(B . "0x3D6F") ; <CJK>
       (?$(IU3(B . "0x3D7B") ; <CJK>
       (?$(IU4(B . "0x3D73") ; <CJK>
       (?$(IU5(B . "0x6FD9") ; <CJK>
       (?$(IU6(B . "0x6FDA") ; <CJK>
       (?$(IU7(B . "0x6FEA") ; <CJK>
       (?$(IU8(B . "0x3D70") ; <CJK>
       (?$(IU9(B . "0x6FF6") ; <CJK>
       (?$(IU:(B . "0x24039") ; <CJK>
       (?$(IU;(B . "0x3D78") ; <CJK>
       (?$(IU<(B . "0x71E3") ; <CJK>
       (?$(IU=(B . "0x3DFE") ; <CJK>
       (?$(IU>(B . "0x71E9") ; <CJK>
       (?$(IU?(B . "0x3E00") ; <CJK>
       (?$(IU@(B . "0x71EB") ; <CJK>
       (?$(IUA(B . "0x71EF") ; <CJK>
       (?$(IUB(B . "0x71F3") ; <CJK>
       (?$(IUC(B . "0x71EA") ; <CJK>
       (?$(IUD(B . "0x3E01") ; <CJK>
       (?$(IUE(B . "0x2F921") ; <CJK>
       (?$(IUF(B . "0x3E55") ; <CJK>
       (?$(IUG(B . "0x3E56") ; <CJK>
       (?$(IUH(B . "0x3E9D") ; <CJK>
       (?$(IUI(B . "0x7371") ; <CJK>
       (?$(IUJ(B . "0x3EF9") ; <CJK>
       (?$(IUK(B . "0x74AE") ; <CJK>
       (?$(IUL(B . "0x3EFF") ; <CJK>
       (?$(IUM(B . "0x74B3") ; <CJK>
       (?$(IUN(B . "0x3EFD") ; <CJK>
       (?$(IUO(B . "0x74AC") ; <CJK>
       (?$(IUP(B . "0x3F43") ; <CJK>
       (?$(IUQ(B . "0x3F41") ; <CJK>
       (?$(IUR(B . "0x7583") ; <CJK>
       (?$(IUS(B . "0x7645") ; <CJK>
       (?$(IUT(B . "0x764E") ; <CJK>
       (?$(IUU(B . "0x7644") ; <CJK>
       (?$(IUV(B . "0x76A3") ; <CJK>
       (?$(IUW(B . "0x76A5") ; <CJK>
       (?$(IUX(B . "0x77A6") ; <CJK>
       (?$(IUY(B . "0x77A4") ; <CJK>
       (?$(IUZ(B . "0x406F") ; <CJK>
       (?$(IU[(B . "0x77A9") ; <CJK>
       (?$(IU\(B . "0x77AF") ; <CJK>
       (?$(IU](B . "0x408A") ; <CJK>
       (?$(IU^(B . "0x40E5") ; <CJK>
       (?$(IU_(B . "0x40E6") ; <CJK>
       (?$(IU`(B . "0x78F0") ; <CJK>
       (?$(IUa(B . "0x78F8") ; <CJK>
       (?$(IUb(B . "0x78F1") ; <CJK>
       (?$(IUc(B . "0x417F") ; <CJK>
       (?$(IUd(B . "0x7A49") ; <CJK>
       (?$(IUe(B . "0x41B5") ; <CJK>
       (?$(IUf(B . "0x41B6") ; <CJK>
       (?$(IUg(B . "0x41BB") ; <CJK>
       (?$(IUh(B . "0x7AC2") ; <CJK>
       (?$(IUi(B . "0x7AF2") ; <CJK>
       (?$(IUj(B . "0x7AF3") ; <CJK>
       (?$(IUk(B . "0x7BFA") ; <CJK>
       (?$(IUl(B . "0x4240") ; <CJK>
       (?$(IUm(B . "0x7BF6") ; <CJK>
       (?$(IUn(B . "0x7BFC") ; <CJK>
       (?$(IUo(B . "0x7C18") ; <CJK>
       (?$(IUp(B . "0x7C08") ; <CJK>
       (?$(IUq(B . "0x7C12") ; <CJK>
       (?$(IUr(B . "0x429D") ; <CJK>
       (?$(IUs(B . "0x429C") ; <CJK>
       (?$(IUt(B . "0x7CDB") ; <CJK>
       (?$(IUu(B . "0x7CDA") ; <CJK>
       (?$(IUv(B . "0x430F") ; <CJK>
       (?$(IUw(B . "0x4311") ; <CJK>
       (?$(IUx(B . "0x430D") ; <CJK>
       (?$(IUy(B . "0x7E2C") ; <CJK>
       (?$(IUz(B . "0x7E4D") ; <CJK>
       (?$(IU{(B . "0x4314") ; <CJK>
       (?$(IU|(B . "0x4313") ; <CJK>
       (?$(IU}(B . "0x7F46") ; <CJK>
       (?$(IU~(B . "0x7FF6") ; <CJK>
       (?$(IV!(B . "0x802B") ; <CJK>
       (?$(IV"(B . "0x8074") ; <CJK>
       (?$(IV#(B . "0x81B8") ; <CJK>
       (?$(IV$(B . "0x81C8") ; <CJK>
       (?$(IV%(B . "0x4482") ; <CJK>
       (?$(IV&(B . "0x4483") ; <CJK>
       (?$(IV'(B . "0x454D") ; <CJK>
       (?$(IV((B . "0x8592") ; <CJK>
       (?$(IV)(B . "0x8593") ; <CJK>
       (?$(IV*(B . "0x454F") ; <CJK>
       (?$(IV+(B . "0x857F") ; <CJK>
       (?$(IV,(B . "0x85AB") ; <CJK>
       (?$(IV-(B . "0x8597") ; <CJK>
       (?$(IV.(B . "0x454C") ; <CJK>
       (?$(IV/(B . "0x4551") ; <CJK>
       (?$(IV0(B . "0x85AC") ; <CJK>
       (?$(IV1(B . "0x45EE") ; <CJK>
       (?$(IV2(B . "0x45E8") ; <CJK>
       (?$(IV3(B . "0x4CCB") ; <CJK>
       (?$(IV4(B . "0x87CE") ; <CJK>
       (?$(IV5(B . "0x45EB") ; <CJK>
       (?$(IV6(B . "0x87CD") ; <CJK>
       (?$(IV7(B . "0x45E2") ; <CJK>
       (?$(IV8(B . "0x45E6") ; <CJK>
       (?$(IV9(B . "0x87C1") ; <CJK>
       (?$(IV:(B . "0x87B1") ; <CJK>
       (?$(IV;(B . "0x87C7") ; <CJK>
       (?$(IV<(B . "0x45EC") ; <CJK>
       (?$(IV=(B . "0x8940") ; <CJK>
       (?$(IV>(B . "0x4659") ; <CJK>
       (?$(IV?(B . "0x893F") ; <CJK>
       (?$(IV@(B . "0x8939") ; <CJK>
       (?$(IVA(B . "0x465D") ; <CJK>
       (?$(IVB(B . "0x8943") ; <CJK>
       (?$(IVC(B . "0x4657") ; <CJK>
       (?$(IVD(B . "0x465B") ; <CJK>
       (?$(IVE(B . "0x4656") ; <CJK>
       (?$(IVF(B . "0x89AB") ; <CJK>
       (?$(IVG(B . "0x46FE") ; <CJK>
       (?$(IVH(B . "0x8B1F") ; <CJK>
       (?$(IVI(B . "0x8B09") ; <CJK>
       (?$(IVJ(B . "0x8B0C") ; <CJK>
       (?$(IVK(B . "0x4700") ; <CJK>
       (?$(IVL(B . "0x4701") ; <CJK>
       (?$(IVM(B . "0x8C40") ; <CJK>
       (?$(IVN(B . "0x4742") ; <CJK>
       (?$(IVO(B . "0x8C96") ; <CJK>
       (?$(IVP(B . "0x4760") ; <CJK>
       (?$(IVQ(B . "0x8CF6") ; <CJK>
       (?$(IVR(B . "0x8CF7") ; <CJK>
       (?$(IVS(B . "0x481D") ; <CJK>
       (?$(IVT(B . "0x8E46") ; <CJK>
       (?$(IVU(B . "0x8E4F") ; <CJK>
       (?$(IVV(B . "0x483E") ; <CJK>
       (?$(IVW(B . "0x4869") ; <CJK>
       (?$(IVX(B . "0x4865") ; <CJK>
       (?$(IVY(B . "0x8F3D") ; <CJK>
       (?$(IVZ(B . "0x8F41") ; <CJK>
       (?$(IV[(B . "0x9366") ; <CJK>
       (?$(IV\(B . "0x9378") ; <CJK>
       (?$(IV](B . "0x935D") ; <CJK>
       (?$(IV^(B . "0x9369") ; <CJK>
       (?$(IV_(B . "0x9374") ; <CJK>
       (?$(IV`(B . "0x937D") ; <CJK>
       (?$(IVa(B . "0x936E") ; <CJK>
       (?$(IVb(B . "0x9372") ; <CJK>
       (?$(IVc(B . "0x9373") ; <CJK>
       (?$(IVd(B . "0x9362") ; <CJK>
       (?$(IVe(B . "0x9348") ; <CJK>
       (?$(IVf(B . "0x9353") ; <CJK>
       (?$(IVg(B . "0x935F") ; <CJK>
       (?$(IVh(B . "0x9368") ; <CJK>
       (?$(IVi(B . "0x4938") ; <CJK>
       (?$(IVj(B . "0x937F") ; <CJK>
       (?$(IVk(B . "0x936B") ; <CJK>
       (?$(IVl(B . "0x49AE") ; <CJK>
       (?$(IVm(B . "0x95C4") ; <CJK>
       (?$(IVn(B . "0x49AD") ; <CJK>
       (?$(IVo(B . "0x96AF") ; <CJK>
       (?$(IVp(B . "0x96AD") ; <CJK>
       (?$(IVq(B . "0x96B2") ; <CJK>
       (?$(IVr(B . "0x4A02") ; <CJK>
       (?$(IVs(B . "0x4A1F") ; <CJK>
       (?$(IVt(B . "0x971A") ; <CJK>
       (?$(IVu(B . "0x971B") ; <CJK>
       (?$(IVv(B . "0x4A22") ; <CJK>
       (?$(IVw(B . "0x4A20") ; <CJK>
       (?$(IVx(B . "0x2F9F5") ; <CJK>
       (?$(IVy(B . "0x4A6C") ; <CJK>
       (?$(IVz(B . "0x979B") ; <CJK>
       (?$(IV{(B . "0x979F") ; <CJK>
       (?$(IV|(B . "0x4A68") ; <CJK>
       (?$(IV}(B . "0x4A6D") ; <CJK>
       (?$(IV~(B . "0x4A6E") ; <CJK>
       (?$(IW!(B . "0x4AA0") ; <CJK>
       (?$(IW"(B . "0x4ACE") ; <CJK>
       (?$(IW#(B . "0x4AD0") ; <CJK>
       (?$(IW$(B . "0x4AD1") ; <CJK>
       (?$(IW%(B . "0x4ACB") ; <CJK>
       (?$(IW&(B . "0x9840") ; <CJK>
       (?$(IW'(B . "0x4AD2") ; <CJK>
       (?$(IW((B . "0x9847") ; <CJK>
       (?$(IW)(B . "0x4AD3") ; <CJK>
       (?$(IW*(B . "0x98B7") ; <CJK>
       (?$(IW+(B . "0x4B20") ; <CJK>
       (?$(IW,(B . "0x4B4E") ; <CJK>
       (?$(IW-(B . "0x4B4B") ; <CJK>
       (?$(IW.(B . "0x4B72") ; <CJK>
       (?$(IW/(B . "0x4B70") ; <CJK>
       (?$(IW0(B . "0x99A2") ; <CJK>
       (?$(IW1(B . "0x4B92") ; <CJK>
       (?$(IW2(B . "0x4B8F") ; <CJK>
       (?$(IW3(B . "0x9A00") ; <CJK>
       (?$(IW4(B . "0x99F3") ; <CJK>
       (?$(IW5(B . "0x4B90") ; <CJK>
       (?$(IW6(B . "0x29937") ; <CJK>
       (?$(IW7(B . "0x99F5") ; <CJK>
       (?$(IW8(B . "0x4BD9") ; <CJK>
       (?$(IW9(B . "0x4BD5") ; <CJK>
       (?$(IW:(B . "0x9ABD") ; <CJK>
       (?$(IW;(B . "0x9B00") ; <CJK>
       (?$(IW<(B . "0x9B02") ; <CJK>
       (?$(IW=(B . "0x4BFA") ; <CJK>
       (?$(IW>(B . "0x9B34") ; <CJK>
       (?$(IW?(B . "0x9B49") ; <CJK>
       (?$(IW@(B . "0x9B9F") ; <CJK>
       (?$(IWA(B . "0x4C4B") ; <CJK>
       (?$(IWB(B . "0x9BA3") ; <CJK>
       (?$(IWC(B . "0x9BCD") ; <CJK>
       (?$(IWD(B . "0x9B99") ; <CJK>
       (?$(IWE(B . "0x9B9D") ; <CJK>
       (?$(IWF(B . "0x4CD0") ; <CJK>
       (?$(IWG(B . "0x4CCE") ; <CJK>
       (?$(IWH(B . "0x9D39") ; <CJK>
       (?$(IWI(B . "0x4CCF") ; <CJK>
       (?$(IWJ(B . "0x9D44") ; <CJK>
       (?$(IWK(B . "0x4CC4") ; <CJK>
       (?$(IWL(B . "0x4CCC") ; <CJK>
       (?$(IWM(B . "0x9D35") ; <CJK>
       (?$(IWN(B . "0x4CD2") ; <CJK>
       (?$(IWO(B . "0x4D35") ; <CJK>
       (?$(IWP(B . "0x9EAF") ; <CJK>
       (?$(IWQ(B . "0x3E03") ; <CJK>
       (?$(IWR(B . "0x512F") ; <CJK>
       (?$(IWS(B . "0x349E") ; <CJK>
       (?$(IWT(B . "0x34AF") ; <CJK>
       (?$(IWU(B . "0x9F8E") ; <CJK>
       (?$(IWV(B . "0x360C") ; <CJK>
       (?$(IWW(B . "0x569F") ; <CJK>
       (?$(IWX(B . "0x569B") ; <CJK>
       (?$(IWY(B . "0x569E") ; <CJK>
       (?$(IWZ(B . "0x5696") ; <CJK>
       (?$(IW[(B . "0x5694") ; <CJK>
       (?$(IW\(B . "0x56A0") ; <CJK>
       (?$(IW](B . "0x367C") ; <CJK>
       (?$(IW^(B . "0x5B3B") ; <CJK>
       (?$(IW_(B . "0x3730") ; <CJK>
       (?$(IW`(B . "0x3731") ; <CJK>
       (?$(IWa(B . "0x5B3A") ; <CJK>
       (?$(IWb(B . "0x5DC1") ; <CJK>
       (?$(IWc(B . "0x5F4D") ; <CJK>
       (?$(IWd(B . "0x5F5D") ; <CJK>
       (?$(IWe(B . "0x61F3") ; <CJK>
       (?$(IWf(B . "0x39A1") ; <CJK>
       (?$(IWg(B . "0x399E") ; <CJK>
       (?$(IWh(B . "0x3A68") ; <CJK>
       (?$(IWi(B . "0x3A61") ; <CJK>
       (?$(IWj(B . "0x64F6") ; <CJK>
       (?$(IWk(B . "0x64E5") ; <CJK>
       (?$(IWl(B . "0x64EA") ; <CJK>
       (?$(IWm(B . "0x64E7") ; <CJK>
       (?$(IWn(B . "0x6505") ; <CJK>
       (?$(IWo(B . "0x3A65") ; <CJK>
       (?$(IWp(B . "0x64F9") ; <CJK>
       (?$(IWq(B . "0x3A66") ; <CJK>
       (?$(IWr(B . "0x3A6A") ; <CJK>
       (?$(IWs(B . "0x3AAB") ; <CJK>
       (?$(IWt(B . "0x6AAB") ; <CJK>
       (?$(IWu(B . "0x6AED") ; <CJK>
       (?$(IWv(B . "0x6AB2") ; <CJK>
       (?$(IWw(B . "0x6AB0") ; <CJK>
       (?$(IWx(B . "0x6AB5") ; <CJK>
       (?$(IWy(B . "0x6ABE") ; <CJK>
       (?$(IWz(B . "0x6AC1") ; <CJK>
       (?$(IW{(B . "0x6AC8") ; <CJK>
       (?$(IW|(B . "0x3BF9") ; <CJK>
       (?$(IW}(B . "0x6AC0") ; <CJK>
       (?$(IW~(B . "0x6ABC") ; <CJK>
       (?$(IX!(B . "0x6AB1") ; <CJK>
       (?$(IX"(B . "0x6AC4") ; <CJK>
       (?$(IX#(B . "0x6ABF") ; <CJK>
       (?$(IX$(B . "0x3C58") ; <CJK>
       (?$(IX%(B . "0x3C8A") ; <CJK>
       (?$(IX&(B . "0x7008") ; <CJK>
       (?$(IX'(B . "0x7003") ; <CJK>
       (?$(IX((B . "0x6FFD") ; <CJK>
       (?$(IX)(B . "0x7010") ; <CJK>
       (?$(IX*(B . "0x7002") ; <CJK>
       (?$(IX+(B . "0x7013") ; <CJK>
       (?$(IX,(B . "0x3E04") ; <CJK>
       (?$(IX-(B . "0x71FA") ; <CJK>
       (?$(IX.(B . "0x7200") ; <CJK>
       (?$(IX/(B . "0x74B9") ; <CJK>
       (?$(IX0(B . "0x74BC") ; <CJK>
       (?$(IX1(B . "0x3F02") ; <CJK>
       (?$(IX2(B . "0x765B") ; <CJK>
       (?$(IX3(B . "0x7651") ; <CJK>
       (?$(IX4(B . "0x764F") ; <CJK>
       (?$(IX5(B . "0x76EB") ; <CJK>
       (?$(IX6(B . "0x77B8") ; <CJK>
       (?$(IX7(B . "0x4079") ; <CJK>
       (?$(IX8(B . "0x77B9") ; <CJK>
       (?$(IX9(B . "0x77C1") ; <CJK>
       (?$(IX:(B . "0x77C0") ; <CJK>
       (?$(IX;(B . "0x77BE") ; <CJK>
       (?$(IX<(B . "0x790B") ; <CJK>
       (?$(IX=(B . "0x40EB") ; <CJK>
       (?$(IX>(B . "0x7907") ; <CJK>
       (?$(IX?(B . "0x790A") ; <CJK>
       (?$(IX@(B . "0x7908") ; <CJK>
       (?$(IXA(B . "0x40E9") ; <CJK>
       (?$(IXB(B . "0x790D") ; <CJK>
       (?$(IXC(B . "0x7906") ; <CJK>
       (?$(IXD(B . "0x7915") ; <CJK>
       (?$(IXE(B . "0x79AF") ; <CJK>
       (?$(IXF(B . "0x4120") ; <CJK>
       (?$(IXG(B . "0x4121") ; <CJK>
       (?$(IXH(B . "0x4181") ; <CJK>
       (?$(IXI(B . "0x7AF5") ; <CJK>
       (?$(IXJ(B . "0x424D") ; <CJK>
       (?$(IXK(B . "0x4259") ; <CJK>
       (?$(IXL(B . "0x7C2E") ; <CJK>
       (?$(IXM(B . "0x4258") ; <CJK>
       (?$(IXN(B . "0x7C1B") ; <CJK>
       (?$(IXO(B . "0x25CD1") ; <CJK>
       (?$(IXP(B . "0x7C1A") ; <CJK>
       (?$(IXQ(B . "0x7C24") ; <CJK>
       (?$(IXR(B . "0x42A5") ; <CJK>
       (?$(IXS(B . "0x42A9") ; <CJK>
       (?$(IXT(B . "0x7CE6") ; <CJK>
       (?$(IXU(B . "0x7CE3") ; <CJK>
       (?$(IXV(B . "0x431A") ; <CJK>
       (?$(IXW(B . "0x4319") ; <CJK>
       (?$(IXX(B . "0x7E5D") ; <CJK>
       (?$(IXY(B . "0x7E4F") ; <CJK>
       (?$(IXZ(B . "0x7E66") ; <CJK>
       (?$(IX[(B . "0x7E5B") ; <CJK>
       (?$(IX\(B . "0x7F47") ; <CJK>
       (?$(IX](B . "0x7FB4") ; <CJK>
       (?$(IX^(B . "0x4396") ; <CJK>
       (?$(IX_(B . "0x4398") ; <CJK>
       (?$(IX`(B . "0x4397") ; <CJK>
       (?$(IXa(B . "0x7FFA") ; <CJK>
       (?$(IXb(B . "0x802E") ; <CJK>
       (?$(IXc(B . "0x265DF") ; <CJK>
       (?$(IXd(B . "0x43C8") ; <CJK>
       (?$(IXe(B . "0x81CE") ; <CJK>
       (?$(IXf(B . "0x4443") ; <CJK>
       (?$(IXg(B . "0x4445") ; <CJK>
       (?$(IXh(B . "0x8219") ; <CJK>
       (?$(IXi(B . "0x4552") ; <CJK>
       (?$(IXj(B . "0x4557") ; <CJK>
       (?$(IXk(B . "0x85CC") ; <CJK>
       (?$(IXl(B . "0x85B2") ; <CJK>
       (?$(IXm(B . "0x4555") ; <CJK>
       (?$(IXn(B . "0x85BB") ; <CJK>
       (?$(IXo(B . "0x85C1") ; <CJK>
       (?$(IXp(B . "0x4556") ; <CJK>
       (?$(IXq(B . "0x4558") ; <CJK>
       (?$(IXr(B . "0x45F2") ; <CJK>
       (?$(IXs(B . "0x87E9") ; <CJK>
       (?$(IXt(B . "0x87EE") ; <CJK>
       (?$(IXu(B . "0x87F0") ; <CJK>
       (?$(IXv(B . "0x87D6") ; <CJK>
       (?$(IXw(B . "0x880E") ; <CJK>
       (?$(IXx(B . "0x87DA") ; <CJK>
       (?$(IXy(B . "0x8948") ; <CJK>
       (?$(IXz(B . "0x894A") ; <CJK>
       (?$(IX{(B . "0x894E") ; <CJK>
       (?$(IX|(B . "0x894D") ; <CJK>
       (?$(IX}(B . "0x89B1") ; <CJK>
       (?$(IX~(B . "0x89B0") ; <CJK>
       (?$(IY!(B . "0x89B3") ; <CJK>
       (?$(IY"(B . "0x4707") ; <CJK>
       (?$(IY#(B . "0x8B38") ; <CJK>
       (?$(IY$(B . "0x8B32") ; <CJK>
       (?$(IY%(B . "0x4708") ; <CJK>
       (?$(IY&(B . "0x8B2D") ; <CJK>
       (?$(IY'(B . "0x470A") ; <CJK>
       (?$(IY((B . "0x8B34") ; <CJK>
       (?$(IY)(B . "0x431B") ; <CJK>
       (?$(IY*(B . "0x8B29") ; <CJK>
       (?$(IY+(B . "0x8C74") ; <CJK>
       (?$(IY,(B . "0x4761") ; <CJK>
       (?$(IY-(B . "0x4762") ; <CJK>
       (?$(IY.(B . "0x8D03") ; <CJK>
       (?$(IY/(B . "0x47C2") ; <CJK>
       (?$(IY0(B . "0x47C6") ; <CJK>
       (?$(IY1(B . "0x8DA9") ; <CJK>
       (?$(IY2(B . "0x8E58") ; <CJK>
       (?$(IY3(B . "0x481E") ; <CJK>
       (?$(IY4(B . "0x4825") ; <CJK>
       (?$(IY5(B . "0x8EBF") ; <CJK>
       (?$(IY6(B . "0x8EC1") ; <CJK>
       (?$(IY7(B . "0x8F4A") ; <CJK>
       (?$(IY8(B . "0x8FAC") ; <CJK>
       (?$(IY9(B . "0x48B0") ; <CJK>
       (?$(IY:(B . "0x9089") ; <CJK>
       (?$(IY;(B . "0x913D") ; <CJK>
       (?$(IY<(B . "0x913C") ; <CJK>
       (?$(IY=(B . "0x91A9") ; <CJK>
       (?$(IY>(B . "0x93A0") ; <CJK>
       (?$(IY?(B . "0x493D") ; <CJK>
       (?$(IY@(B . "0x9390") ; <CJK>
       (?$(IYA(B . "0x493E") ; <CJK>
       (?$(IYB(B . "0x9393") ; <CJK>
       (?$(IYC(B . "0x938B") ; <CJK>
       (?$(IYD(B . "0x93AD") ; <CJK>
       (?$(IYE(B . "0x93BB") ; <CJK>
       (?$(IYF(B . "0x93B8") ; <CJK>
       (?$(IYG(B . "0x4946") ; <CJK>
       (?$(IYH(B . "0x4945") ; <CJK>
       (?$(IYI(B . "0x939C") ; <CJK>
       (?$(IYJ(B . "0x95D8") ; <CJK>
       (?$(IYK(B . "0x95D7") ; <CJK>
       (?$(IYL(B . "0x4A03") ; <CJK>
       (?$(IYM(B . "0x4A26") ; <CJK>
       (?$(IYN(B . "0x4A27") ; <CJK>
       (?$(IYO(B . "0x975D") ; <CJK>
       (?$(IYP(B . "0x97A9") ; <CJK>
       (?$(IYQ(B . "0x97DA") ; <CJK>
       (?$(IYR(B . "0x4A98") ; <CJK>
       (?$(IYS(B . "0x4AAD") ; <CJK>
       (?$(IYT(B . "0x4AD5") ; <CJK>
       (?$(IYU(B . "0x4ADA") ; <CJK>
       (?$(IYV(B . "0x9854") ; <CJK>
       (?$(IYW(B . "0x4AD9") ; <CJK>
       (?$(IYX(B . "0x9855") ; <CJK>
       (?$(IYY(B . "0x984B") ; <CJK>
       (?$(IYZ(B . "0x4ADD") ; <CJK>
       (?$(IY[(B . "0x983F") ; <CJK>
       (?$(IY\(B . "0x98B9") ; <CJK>
       (?$(IY](B . "0x4B15") ; <CJK>
       (?$(IY^(B . "0x4B16") ; <CJK>
       (?$(IY_(B . "0x4B17") ; <CJK>
       (?$(IY`(B . "0x4B21") ; <CJK>
       (?$(IYa(B . "0x9938") ; <CJK>
       (?$(IYb(B . "0x9936") ; <CJK>
       (?$(IYc(B . "0x9940") ; <CJK>
       (?$(IYd(B . "0x4B4C") ; <CJK>
       (?$(IYe(B . "0x993B") ; <CJK>
       (?$(IYf(B . "0x9939") ; <CJK>
       (?$(IYg(B . "0x99A4") ; <CJK>
       (?$(IYh(B . "0x4B96") ; <CJK>
       (?$(IYi(B . "0x4B98") ; <CJK>
       (?$(IYj(B . "0x9A08") ; <CJK>
       (?$(IYk(B . "0x9A0C") ; <CJK>
       (?$(IYl(B . "0x4B9B") ; <CJK>
       (?$(IYm(B . "0x9A10") ; <CJK>
       (?$(IYn(B . "0x4BFF") ; <CJK>
       (?$(IYo(B . "0x9B07") ; <CJK>
       (?$(IYp(B . "0x4C25") ; <CJK>
       (?$(IYq(B . "0x9BD2") ; <CJK>
       (?$(IYr(B . "0x4C4F") ; <CJK>
       (?$(IYs(B . "0x9BC2") ; <CJK>
       (?$(IYt(B . "0x9BBB") ; <CJK>
       (?$(IYu(B . "0x9BCC") ; <CJK>
       (?$(IYv(B . "0x9BCB") ; <CJK>
       (?$(IYw(B . "0x4C56") ; <CJK>
       (?$(IYx(B . "0x4C54") ; <CJK>
       (?$(IYy(B . "0x9D4D") ; <CJK>
       (?$(IYz(B . "0x9D63") ; <CJK>
       (?$(IY{(B . "0x9D4E") ; <CJK>
       (?$(IY|(B . "0x4CD8") ; <CJK>
       (?$(IY}(B . "0x9D50") ; <CJK>
       (?$(IY~(B . "0x9D55") ; <CJK>
       (?$(IZ!(B . "0x4CD7") ; <CJK>
       (?$(IZ"(B . "0x9D5E") ; <CJK>
       (?$(IZ#(B . "0x4D26") ; <CJK>
       (?$(IZ$(B . "0x9E90") ; <CJK>
       (?$(IZ%(B . "0x9EB2") ; <CJK>
       (?$(IZ&(B . "0x9EB1") ; <CJK>
       (?$(IZ'(B . "0x4D38") ; <CJK>
       (?$(IZ((B . "0x9ECA") ; <CJK>
       (?$(IZ)(B . "0x9F02") ; <CJK>
       (?$(IZ*(B . "0x9F27") ; <CJK>
       (?$(IZ+(B . "0x9F26") ; <CJK>
       (?$(IZ,(B . "0x4D8A") ; <CJK>
       (?$(IZ-(B . "0x56AF") ; <CJK>
       (?$(IZ.(B . "0x58E0") ; <CJK>
       (?$(IZ/(B . "0x58DC") ; <CJK>
       (?$(IZ0(B . "0x3734") ; <CJK>
       (?$(IZ1(B . "0x5B39") ; <CJK>
       (?$(IZ2(B . "0x3735") ; <CJK>
       (?$(IZ3(B . "0x2F86A") ; <CJK>
       (?$(IZ4(B . "0x5B7C") ; <CJK>
       (?$(IZ5(B . "0x5BF3") ; <CJK>
       (?$(IZ6(B . "0x2F870") ; <CJK>
       (?$(IZ7(B . "0x37A1") ; <CJK>
       (?$(IZ8(B . "0x5C6B") ; <CJK>
       (?$(IZ9(B . "0x5DC4") ; <CJK>
       (?$(IZ:(B . "0x650B") ; <CJK>
       (?$(IZ;(B . "0x6508") ; <CJK>
       (?$(IZ<(B . "0x650A") ; <CJK>
       (?$(IZ=(B . "0x3A6C") ; <CJK>
       (?$(IZ>(B . "0x3A6D") ; <CJK>
       (?$(IZ?(B . "0x65DC") ; <CJK>
       (?$(IZ@(B . "0x3B29") ; <CJK>
       (?$(IZA(B . "0x3B2A") ; <CJK>
       (?$(IZB(B . "0x66E1") ; <CJK>
       (?$(IZC(B . "0x66DF") ; <CJK>
       (?$(IZD(B . "0x6ACE") ; <CJK>
       (?$(IZE(B . "0x6AD4") ; <CJK>
       (?$(IZF(B . "0x6AE3") ; <CJK>
       (?$(IZG(B . "0x6AD7") ; <CJK>
       (?$(IZH(B . "0x6AE2") ; <CJK>
       (?$(IZI(B . "0x3C00") ; <CJK>
       (?$(IZJ(B . "0x3C08") ; <CJK>
       (?$(IZK(B . "0x3C06") ; <CJK>
       (?$(IZL(B . "0x3C05") ; <CJK>
       (?$(IZM(B . "0x6AD8") ; <CJK>
       (?$(IZN(B . "0x6AD5") ; <CJK>
       (?$(IZO(B . "0x6AD2") ; <CJK>
       (?$(IZP(B . "0x3CB1") ; <CJK>
       (?$(IZQ(B . "0x3D88") ; <CJK>
       (?$(IZR(B . "0x701E") ; <CJK>
       (?$(IZS(B . "0x702C") ; <CJK>
       (?$(IZT(B . "0x7025") ; <CJK>
       (?$(IZU(B . "0x6FF3") ; <CJK>
       (?$(IZV(B . "0x7204") ; <CJK>
       (?$(IZW(B . "0x7208") ; <CJK>
       (?$(IZX(B . "0x7215") ; <CJK>
       (?$(IZY(B . "0x3E09") ; <CJK>
       (?$(IZZ(B . "0x74C4") ; <CJK>
       (?$(IZ[(B . "0x74C9") ; <CJK>
       (?$(IZ\(B . "0x74C7") ; <CJK>
       (?$(IZ](B . "0x74C8") ; <CJK>
       (?$(IZ^(B . "0x76A9") ; <CJK>
       (?$(IZ_(B . "0x77C6") ; <CJK>
       (?$(IZ`(B . "0x77C5") ; <CJK>
       (?$(IZa(B . "0x7918") ; <CJK>
       (?$(IZb(B . "0x791A") ; <CJK>
       (?$(IZc(B . "0x7920") ; <CJK>
       (?$(IZd(B . "0x4122") ; <CJK>
       (?$(IZe(B . "0x7A66") ; <CJK>
       (?$(IZf(B . "0x7A64") ; <CJK>
       (?$(IZg(B . "0x7A6A") ; <CJK>
       (?$(IZh(B . "0x41D5") ; <CJK>
       (?$(IZi(B . "0x4261") ; <CJK>
       (?$(IZj(B . "0x425D") ; <CJK>
       (?$(IZk(B . "0x4262") ; <CJK>
       (?$(IZl(B . "0x424F") ; <CJK>
       (?$(IZm(B . "0x4260") ; <CJK>
       (?$(IZn(B . "0x7C35") ; <CJK>
       (?$(IZo(B . "0x7C34") ; <CJK>
       (?$(IZp(B . "0x42AA") ; <CJK>
       (?$(IZq(B . "0x4322") ; <CJK>
       (?$(IZr(B . "0x7E6C") ; <CJK>
       (?$(IZs(B . "0x4321") ; <CJK>
       (?$(IZt(B . "0x7E6E") ; <CJK>
       (?$(IZu(B . "0x7E71") ; <CJK>
       (?$(IZv(B . "0x4446") ; <CJK>
       (?$(IZw(B . "0x81D4") ; <CJK>
       (?$(IZx(B . "0x81D6") ; <CJK>
       (?$(IZy(B . "0x821A") ; <CJK>
       (?$(IZz(B . "0x8262") ; <CJK>
       (?$(IZ{(B . "0x8265") ; <CJK>
       (?$(IZ|(B . "0x8276") ; <CJK>
       (?$(IZ}(B . "0x85DB") ; <CJK>
       (?$(IZ~(B . "0x85D6") ; <CJK>
       (?$(I[!(B . "0x4562") ; <CJK>
       (?$(I["(B . "0x85E7") ; <CJK>
       (?$(I[#(B . "0x4560") ; <CJK>
       (?$(I[$(B . "0x4564") ; <CJK>
       (?$(I[%(B . "0x85F4") ; <CJK>
       (?$(I[&(B . "0x2F9B6") ; <CJK>
       (?$(I['(B . "0x87FD") ; <CJK>
       (?$(I[((B . "0x87D5") ; <CJK>
       (?$(I[)(B . "0x8807") ; <CJK>
       (?$(I[*(B . "0x45F6") ; <CJK>
       (?$(I[+(B . "0x880F") ; <CJK>
       (?$(I[,(B . "0x87F8") ; <CJK>
       (?$(I[-(B . "0x2F9C1") ; <CJK>
       (?$(I[.(B . "0x4619") ; <CJK>
       (?$(I[/(B . "0x8987") ; <CJK>
       (?$(I[0(B . "0x4691") ; <CJK>
       (?$(I[1(B . "0x89B5") ; <CJK>
       (?$(I[2(B . "0x89F5") ; <CJK>
       (?$(I[3(B . "0x470D") ; <CJK>
       (?$(I[4(B . "0x8B3F") ; <CJK>
       (?$(I[5(B . "0x8B43") ; <CJK>
       (?$(I[6(B . "0x8B4C") ; <CJK>
       (?$(I[7(B . "0x4765") ; <CJK>
       (?$(I[8(B . "0x8D0B") ; <CJK>
       (?$(I[9(B . "0x8E6B") ; <CJK>
       (?$(I[:(B . "0x8E68") ; <CJK>
       (?$(I[;(B . "0x8E70") ; <CJK>
       (?$(I[<(B . "0x8E75") ; <CJK>
       (?$(I[=(B . "0x8E77") ; <CJK>
       (?$(I[>(B . "0x483F") ; <CJK>
       (?$(I[?(B . "0x8EC3") ; <CJK>
       (?$(I[@(B . "0x494B") ; <CJK>
       (?$(I[A(B . "0x93E9") ; <CJK>
       (?$(I[B(B . "0x93EA") ; <CJK>
       (?$(I[C(B . "0x93CB") ; <CJK>
       (?$(I[D(B . "0x93C5") ; <CJK>
       (?$(I[E(B . "0x93C6") ; <CJK>
       (?$(I[F(B . "0x4948") ; <CJK>
       (?$(I[G(B . "0x93ED") ; <CJK>
       (?$(I[H(B . "0x93D3") ; <CJK>
       (?$(I[I(B . "0x4952") ; <CJK>
       (?$(I[J(B . "0x93E5") ; <CJK>
       (?$(I[K(B . "0x494A") ; <CJK>
       (?$(I[L(B . "0x4951") ; <CJK>
       (?$(I[M(B . "0x93DB") ; <CJK>
       (?$(I[N(B . "0x93EB") ; <CJK>
       (?$(I[O(B . "0x93E0") ; <CJK>
       (?$(I[P(B . "0x93C1") ; <CJK>
       (?$(I[Q(B . "0x4950") ; <CJK>
       (?$(I[R(B . "0x494C") ; <CJK>
       (?$(I[S(B . "0x95DD") ; <CJK>
       (?$(I[T(B . "0x49EE") ; <CJK>
       (?$(I[U(B . "0x4A04") ; <CJK>
       (?$(I[V(B . "0x4A06") ; <CJK>
       (?$(I[W(B . "0x4A2D") ; <CJK>
       (?$(I[X(B . "0x4A2E") ; <CJK>
       (?$(I[Y(B . "0x4A2F") ; <CJK>
       (?$(I[Z(B . "0x4A7B") ; <CJK>
       (?$(I[[(B . "0x4A78") ; <CJK>
       (?$(I[\(B . "0x4A77") ; <CJK>
       (?$(I[](B . "0x97B2") ; <CJK>
       (?$(I[^(B . "0x97B4") ; <CJK>
       (?$(I[_(B . "0x97B1") ; <CJK>
       (?$(I[`(B . "0x97B5") ; <CJK>
       (?$(I[a(B . "0x97F2") ; <CJK>
       (?$(I[b(B . "0x4AA2") ; <CJK>
       (?$(I[c(B . "0x4AA1") ; <CJK>
       (?$(I[d(B . "0x4AE3") ; <CJK>
       (?$(I[e(B . "0x9856") ; <CJK>
       (?$(I[f(B . "0x4B1A") ; <CJK>
       (?$(I[g(B . "0x4B19") ; <CJK>
       (?$(I[h(B . "0x4B57") ; <CJK>
       (?$(I[i(B . "0x9944") ; <CJK>
       (?$(I[j(B . "0x4B9E") ; <CJK>
       (?$(I[k(B . "0x9A26") ; <CJK>
       (?$(I[l(B . "0x9A1F") ; <CJK>
       (?$(I[m(B . "0x9A18") ; <CJK>
       (?$(I[n(B . "0x9A21") ; <CJK>
       (?$(I[o(B . "0x9A17") ; <CJK>
       (?$(I[p(B . "0x4BDD") ; <CJK>
       (?$(I[q(B . "0x9B09") ; <CJK>
       (?$(I[r(B . "0x4C05") ; <CJK>
       (?$(I[s(B . "0x4C28") ; <CJK>
       (?$(I[t(B . "0x9BC5") ; <CJK>
       (?$(I[u(B . "0x9BDF") ; <CJK>
       (?$(I[v(B . "0x4C60") ; <CJK>
       (?$(I[w(B . "0x9BE3") ; <CJK>
       (?$(I[x(B . "0x4C66") ; <CJK>
       (?$(I[y(B . "0x9BE9") ; <CJK>
       (?$(I[z(B . "0x9BEE") ; <CJK>
       (?$(I[{(B . "0x4C67") ; <CJK>
       (?$(I[|(B . "0x4C68") ; <CJK>
       (?$(I[}(B . "0x9D66") ; <CJK>
       (?$(I[~(B . "0x9D7A") ; <CJK>
       (?$(I\!(B . "0x4CDE") ; <CJK>
       (?$(I\"(B . "0x9D6E") ; <CJK>
       (?$(I\#(B . "0x9D91") ; <CJK>
       (?$(I\$(B . "0x9D83") ; <CJK>
       (?$(I\%(B . "0x9D76") ; <CJK>
       (?$(I\&(B . "0x9D7E") ; <CJK>
       (?$(I\'(B . "0x9D6D") ; <CJK>
       (?$(I\((B . "0x4CE1") ; <CJK>
       (?$(I\)(B . "0x9E95") ; <CJK>
       (?$(I\*(B . "0x9EE3") ; <CJK>
       (?$(I\+(B . "0x4D69") ; <CJK>
       (?$(I\,(B . "0x4D77") ; <CJK>
       (?$(I\-(B . "0x9F03") ; <CJK>
       (?$(I\.(B . "0x9F04") ; <CJK>
       (?$(I\/(B . "0x2FA19") ; <CJK>
       (?$(I\0(B . "0x9F17") ; <CJK>
       (?$(I\1(B . "0x34A6") ; <CJK>
       (?$(I\2(B . "0x5136") ; <CJK>
       (?$(I\3(B . "0x34A5") ; <CJK>
       (?$(I\4(B . "0x5336") ; <CJK>
       (?$(I\5(B . "0x3614") ; <CJK>
       (?$(I\6(B . "0x5B42") ; <CJK>
       (?$(I\7(B . "0x3736") ; <CJK>
       (?$(I\8(B . "0x3738") ; <CJK>
       (?$(I\9(B . "0x5B44") ; <CJK>
       (?$(I\:(B . "0x5B46") ; <CJK>
       (?$(I\;(B . "0x5B7E") ; <CJK>
       (?$(I\<(B . "0x5DCA") ; <CJK>
       (?$(I\=(B . "0x5DC8") ; <CJK>
       (?$(I\>(B . "0x5DCC") ; <CJK>
       (?$(I\?(B . "0x5EF0") ; <CJK>
       (?$(I\@(B . "0x3A70") ; <CJK>
       (?$(I\A(B . "0x6585") ; <CJK>
       (?$(I\B(B . "0x66E5") ; <CJK>
       (?$(I\C(B . "0x66E7") ; <CJK>
       (?$(I\D(B . "0x3B2B") ; <CJK>
       (?$(I\E(B . "0x3C11") ; <CJK>
       (?$(I\F(B . "0x3C0A") ; <CJK>
       (?$(I\G(B . "0x6AF4") ; <CJK>
       (?$(I\H(B . "0x3C0D") ; <CJK>
       (?$(I\I(B . "0x6AE9") ; <CJK>
       (?$(I\J(B . "0x3C16") ; <CJK>
       (?$(I\K(B . "0x3C10") ; <CJK>
       (?$(I\L(B . "0x3C09") ; <CJK>
       (?$(I\M(B . "0x3C0E") ; <CJK>
       (?$(I\N(B . "0x3C7A") ; <CJK>
       (?$(I\O(B . "0x703D") ; <CJK>
       (?$(I\P(B . "0x3D8C") ; <CJK>
       (?$(I\Q(B . "0x7036") ; <CJK>
       (?$(I\R(B . "0x3D91") ; <CJK>
       (?$(I\S(B . "0x7216") ; <CJK>
       (?$(I\T(B . "0x3E0A") ; <CJK>
       (?$(I\U(B . "0x7212") ; <CJK>
       (?$(I\V(B . "0x720F") ; <CJK>
       (?$(I\W(B . "0x7217") ; <CJK>
       (?$(I\X(B . "0x7211") ; <CJK>
       (?$(I\Y(B . "0x720B") ; <CJK>
       (?$(I\Z(B . "0x3E08") ; <CJK>
       (?$(I\[(B . "0x3E0B") ; <CJK>
       (?$(I\\(B . "0x74CD") ; <CJK>
       (?$(I\](B . "0x74D0") ; <CJK>
       (?$(I\^(B . "0x74CC") ; <CJK>
       (?$(I\_(B . "0x74CE") ; <CJK>
       (?$(I\`(B . "0x74D1") ; <CJK>
       (?$(I\a(B . "0x3F07") ; <CJK>
       (?$(I\b(B . "0x7589") ; <CJK>
       (?$(I\c(B . "0x40F2") ; <CJK>
       (?$(I\d(B . "0x7A6F") ; <CJK>
       (?$(I\e(B . "0x7C4B") ; <CJK>
       (?$(I\f(B . "0x7C44") ; <CJK>
       (?$(I\g(B . "0x7C55") ; <CJK>
       (?$(I\h(B . "0x42AE") ; <CJK>
       (?$(I\i(B . "0x4324") ; <CJK>
       (?$(I\j(B . "0x4326") ; <CJK>
       (?$(I\k(B . "0x4327") ; <CJK>
       (?$(I\l(B . "0x7E7F") ; <CJK>
       (?$(I\m(B . "0x8B71") ; <CJK>
       (?$(I\n(B . "0x4399") ; <CJK>
       (?$(I\o(B . "0x802F") ; <CJK>
       (?$(I\p(B . "0x807A") ; <CJK>
       (?$(I\q(B . "0x807B") ; <CJK>
       (?$(I\r(B . "0x807C") ; <CJK>
       (?$(I\s(B . "0x455F") ; <CJK>
       (?$(I\t(B . "0x456A") ; <CJK>
       (?$(I\u(B . "0x4571") ; <CJK>
       (?$(I\v(B . "0x85FC") ; <CJK>
       (?$(I\w(B . "0x8610") ; <CJK>
       (?$(I\x(B . "0x8602") ; <CJK>
       (?$(I\y(B . "0x456C") ; <CJK>
       (?$(I\z(B . "0x456F") ; <CJK>
       (?$(I\{(B . "0x85EE") ; <CJK>
       (?$(I\|(B . "0x8603") ; <CJK>
       (?$(I\}(B . "0x4568") ; <CJK>
       (?$(I\~(B . "0x860D") ; <CJK>
       (?$(I]!(B . "0x8613") ; <CJK>
       (?$(I]"(B . "0x8608") ; <CJK>
       (?$(I]#(B . "0x860F") ; <CJK>
       (?$(I]$(B . "0x8818") ; <CJK>
       (?$(I]%(B . "0x8812") ; <CJK>
       (?$(I]&(B . "0x4601") ; <CJK>
       (?$(I]'(B . "0x4668") ; <CJK>
       (?$(I]((B . "0x8967") ; <CJK>
       (?$(I])(B . "0x8965") ; <CJK>
       (?$(I]*(B . "0x89BB") ; <CJK>
       (?$(I]+(B . "0x8B69") ; <CJK>
       (?$(I],(B . "0x8B62") ; <CJK>
       (?$(I]-(B . "0x4713") ; <CJK>
       (?$(I].(B . "0x8B6E") ; <CJK>
       (?$(I]/(B . "0x4716") ; <CJK>
       (?$(I]0(B . "0x8B61") ; <CJK>
       (?$(I]1(B . "0x4718") ; <CJK>
       (?$(I]2(B . "0x8B64") ; <CJK>
       (?$(I]3(B . "0x8B4D") ; <CJK>
       (?$(I]4(B . "0x8C51") ; <CJK>
       (?$(I]5(B . "0x4789") ; <CJK>
       (?$(I]6(B . "0x47C8") ; <CJK>
       (?$(I]7(B . "0x8E83") ; <CJK>
       (?$(I]8(B . "0x8EC6") ; <CJK>
       (?$(I]9(B . "0x4884") ; <CJK>
       (?$(I]:(B . "0x941F") ; <CJK>
       (?$(I];(B . "0x4954") ; <CJK>
       (?$(I]<(B . "0x9404") ; <CJK>
       (?$(I]=(B . "0x9417") ; <CJK>
       (?$(I]>(B . "0x9408") ; <CJK>
       (?$(I]?(B . "0x9405") ; <CJK>
       (?$(I]@(B . "0x4956") ; <CJK>
       (?$(I]A(B . "0x93F3") ; <CJK>
       (?$(I]B(B . "0x941E") ; <CJK>
       (?$(I]C(B . "0x9402") ; <CJK>
       (?$(I]D(B . "0x941A") ; <CJK>
       (?$(I]E(B . "0x941B") ; <CJK>
       (?$(I]F(B . "0x9427") ; <CJK>
       (?$(I]G(B . "0x941C") ; <CJK>
       (?$(I]H(B . "0x495A") ; <CJK>
       (?$(I]I(B . "0x96B5") ; <CJK>
       (?$(I]J(B . "0x4A05") ; <CJK>
       (?$(I]K(B . "0x4A07") ; <CJK>
       (?$(I]L(B . "0x9733") ; <CJK>
       (?$(I]M(B . "0x4A31") ; <CJK>
       (?$(I]N(B . "0x9734") ; <CJK>
       (?$(I]O(B . "0x9731") ; <CJK>
       (?$(I]P(B . "0x97B8") ; <CJK>
       (?$(I]Q(B . "0x97BA") ; <CJK>
       (?$(I]R(B . "0x4AA3") ; <CJK>
       (?$(I]S(B . "0x97FC") ; <CJK>
       (?$(I]T(B . "0x4AEB") ; <CJK>
       (?$(I]U(B . "0x4B1C") ; <CJK>
       (?$(I]V(B . "0x98C3") ; <CJK>
       (?$(I]W(B . "0x4B5A") ; <CJK>
       (?$(I]X(B . "0x994D") ; <CJK>
       (?$(I]Y(B . "0x4B5B") ; <CJK>
       (?$(I]Z(B . "0x9A2F") ; <CJK>
       (?$(I][(B . "0x4BA6") ; <CJK>
       (?$(I]\(B . "0x4BAA") ; <CJK>
       (?$(I]](B . "0x4BA5") ; <CJK>
       (?$(I]^(B . "0x9AC9") ; <CJK>
       (?$(I]_(B . "0x4BE1") ; <CJK>
       (?$(I]`(B . "0x9AC8") ; <CJK>
       (?$(I]a(B . "0x9AC4") ; <CJK>
       (?$(I]b(B . "0x9B2A") ; <CJK>
       (?$(I]c(B . "0x9B38") ; <CJK>
       (?$(I]d(B . "0x9B50") ; <CJK>
       (?$(I]e(B . "0x4C2A") ; <CJK>
       (?$(I]f(B . "0x9C0A") ; <CJK>
       (?$(I]g(B . "0x9BFB") ; <CJK>
       (?$(I]h(B . "0x9C04") ; <CJK>
       (?$(I]i(B . "0x9BFC") ; <CJK>
       (?$(I]j(B . "0x9BFE") ; <CJK>
       (?$(I]k(B . "0x4C72") ; <CJK>
       (?$(I]l(B . "0x4C6F") ; <CJK>
       (?$(I]m(B . "0x4C73") ; <CJK>
       (?$(I]n(B . "0x9C02") ; <CJK>
       (?$(I]o(B . "0x9BF6") ; <CJK>
       (?$(I]p(B . "0x9C1B") ; <CJK>
       (?$(I]q(B . "0x9BF9") ; <CJK>
       (?$(I]r(B . "0x9C15") ; <CJK>
       (?$(I]s(B . "0x9C10") ; <CJK>
       (?$(I]t(B . "0x9BFF") ; <CJK>
       (?$(I]u(B . "0x9C00") ; <CJK>
       (?$(I]v(B . "0x9C0C") ; <CJK>
       (?$(I]w(B . "0x4C6B") ; <CJK>
       (?$(I]x(B . "0x4CE6") ; <CJK>
       (?$(I]y(B . "0x9D95") ; <CJK>
       (?$(I]z(B . "0x9DA5") ; <CJK>
       (?$(I]{(B . "0x4CE9") ; <CJK>
       (?$(I]|(B . "0x4CEC") ; <CJK>
       (?$(I]}(B . "0x4CE8") ; <CJK>
       (?$(I]~(B . "0x4CF0") ; <CJK>
       (?$(I^!(B . "0x9E98") ; <CJK>
       (?$(I^"(B . "0x9EC1") ; <CJK>
       (?$(I^#(B . "0x4D8C") ; <CJK>
       (?$(I^$(B . "0x9F5A") ; <CJK>
       (?$(I^%(B . "0x5164") ; <CJK>
       (?$(I^&(B . "0x56BB") ; <CJK>
       (?$(I^'(B . "0x3615") ; <CJK>
       (?$(I^((B . "0x58E6") ; <CJK>
       (?$(I^)(B . "0x5B49") ; <CJK>
       (?$(I^*(B . "0x5BF7") ; <CJK>
       (?$(I^+(B . "0x3771") ; <CJK>
       (?$(I^,(B . "0x3826") ; <CJK>
       (?$(I^-(B . "0x5DD0") ; <CJK>
       (?$(I^.(B . "0x38C6") ; <CJK>
       (?$(I^/(B . "0x5FC2") ; <CJK>
       (?$(I^0(B . "0x39A8") ; <CJK>
       (?$(I^1(B . "0x6511") ; <CJK>
       (?$(I^2(B . "0x3A73") ; <CJK>
       (?$(I^3(B . "0x6AFF") ; <CJK>
       (?$(I^4(B . "0x6AFE") ; <CJK>
       (?$(I^5(B . "0x6AFD") ; <CJK>
       (?$(I^6(B . "0x3C15") ; <CJK>
       (?$(I^7(B . "0x6B01") ; <CJK>
       (?$(I^8(B . "0x3D98") ; <CJK>
       (?$(I^9(B . "0x3D97") ; <CJK>
       (?$(I^:(B . "0x704B") ; <CJK>
       (?$(I^;(B . "0x704D") ; <CJK>
       (?$(I^<(B . "0x7047") ; <CJK>
       (?$(I^=(B . "0x74D3") ; <CJK>
       (?$(I^>(B . "0x7668") ; <CJK>
       (?$(I^?(B . "0x7667") ; <CJK>
       (?$(I^@(B . "0x3FD7") ; <CJK>
       (?$(I^A(B . "0x4080") ; <CJK>
       (?$(I^B(B . "0x77D1") ; <CJK>
       (?$(I^C(B . "0x7930") ; <CJK>
       (?$(I^D(B . "0x7932") ; <CJK>
       (?$(I^E(B . "0x792E") ; <CJK>
       (?$(I^F(B . "0x4188") ; <CJK>
       (?$(I^G(B . "0x9F9D") ; <CJK>
       (?$(I^H(B . "0x7AC9") ; <CJK>
       (?$(I^I(B . "0x7AC8") ; <CJK>
       (?$(I^J(B . "0x4269") ; <CJK>
       (?$(I^K(B . "0x7C56") ; <CJK>
       (?$(I^L(B . "0x7C51") ; <CJK>
       (?$(I^M(B . "0x426B") ; <CJK>
       (?$(I^N(B . "0x4329") ; <CJK>
       (?$(I^O(B . "0x4328") ; <CJK>
       (?$(I^P(B . "0x7E85") ; <CJK>
       (?$(I^Q(B . "0x7E89") ; <CJK>
       (?$(I^R(B . "0x7E8E") ; <CJK>
       (?$(I^S(B . "0x7E84") ; <CJK>
       (?$(I^T(B . "0x445F") ; <CJK>
       (?$(I^U(B . "0x826A") ; <CJK>
       (?$(I^V(B . "0x862B") ; <CJK>
       (?$(I^W(B . "0x862F") ; <CJK>
       (?$(I^X(B . "0x8628") ; <CJK>
       (?$(I^Y(B . "0x4574") ; <CJK>
       (?$(I^Z(B . "0x8616") ; <CJK>
       (?$(I^[(B . "0x8615") ; <CJK>
       (?$(I^\(B . "0x861D") ; <CJK>
       (?$(I^](B . "0x881A") ; <CJK>
       (?$(I^^(B . "0x4602") ; <CJK>
       (?$(I^_(B . "0x466A") ; <CJK>
       (?$(I^`(B . "0x4694") ; <CJK>
       (?$(I^a(B . "0x89BC") ; <CJK>
       (?$(I^b(B . "0x8B75") ; <CJK>
       (?$(I^c(B . "0x8B7C") ; <CJK>
       (?$(I^d(B . "0x478A") ; <CJK>
       (?$(I^e(B . "0x8D11") ; <CJK>
       (?$(I^f(B . "0x8D12") ; <CJK>
       (?$(I^g(B . "0x8F5C") ; <CJK>
       (?$(I^h(B . "0x91BB") ; <CJK>
       (?$(I^i(B . "0x4964") ; <CJK>
       (?$(I^j(B . "0x93F4") ; <CJK>
       (?$(I^k(B . "0x495E") ; <CJK>
       (?$(I^l(B . "0x4961") ; <CJK>
       (?$(I^m(B . "0x942D") ; <CJK>
       (?$(I^n(B . "0x4965") ; <CJK>
       (?$(I^o(B . "0x4966") ; <CJK>
       (?$(I^p(B . "0x96E4") ; <CJK>
       (?$(I^q(B . "0x9737") ; <CJK>
       (?$(I^r(B . "0x9736") ; <CJK>
       (?$(I^s(B . "0x9767") ; <CJK>
       (?$(I^t(B . "0x97BE") ; <CJK>
       (?$(I^u(B . "0x97BD") ; <CJK>
       (?$(I^v(B . "0x97E2") ; <CJK>
       (?$(I^w(B . "0x9868") ; <CJK>
       (?$(I^x(B . "0x9866") ; <CJK>
       (?$(I^y(B . "0x98C8") ; <CJK>
       (?$(I^z(B . "0x98CA") ; <CJK>
       (?$(I^{(B . "0x98C7") ; <CJK>
       (?$(I^|(B . "0x98DC") ; <CJK>
       (?$(I^}(B . "0x4B5F") ; <CJK>
       (?$(I^~(B . "0x994F") ; <CJK>
       (?$(I_!(B . "0x99A9") ; <CJK>
       (?$(I_"(B . "0x9A3C") ; <CJK>
       (?$(I_#(B . "0x4BAF") ; <CJK>
       (?$(I_$(B . "0x9A3B") ; <CJK>
       (?$(I_%(B . "0x9ACE") ; <CJK>
       (?$(I_&(B . "0x4C0D") ; <CJK>
       (?$(I_'(B . "0x9B14") ; <CJK>
       (?$(I_((B . "0x9B53") ; <CJK>
       (?$(I_)(B . "0x4C7C") ; <CJK>
       (?$(I_*(B . "0x9C2E") ; <CJK>
       (?$(I_+(B . "0x4C7A") ; <CJK>
       (?$(I_,(B . "0x9C1F") ; <CJK>
       (?$(I_-(B . "0x4C76") ; <CJK>
       (?$(I_.(B . "0x4C79") ; <CJK>
       (?$(I_/(B . "0x4C7D") ; <CJK>
       (?$(I_0(B . "0x4C77") ; <CJK>
       (?$(I_1(B . "0x9DB0") ; <CJK>
       (?$(I_2(B . "0x9DBD") ; <CJK>
       (?$(I_3(B . "0x4CF6") ; <CJK>
       (?$(I_4(B . "0x4CF1") ; <CJK>
       (?$(I_5(B . "0x9DAE") ; <CJK>
       (?$(I_6(B . "0x9DC4") ; <CJK>
       (?$(I_7(B . "0x9E7B") ; <CJK>
       (?$(I_8(B . "0x400B") ; <CJK>
       (?$(I_9(B . "0x4D29") ; <CJK>
       (?$(I_:(B . "0x9E9E") ; <CJK>
       (?$(I_;(B . "0x4D6F") ; <CJK>
       (?$(I_<(B . "0x9F05") ; <CJK>
       (?$(I_=(B . "0x4D9A") ; <CJK>
       (?$(I_>(B . "0x9F69") ; <CJK>
       (?$(I_?(B . "0x9FA1") ; <CJK>
       (?$(I_@(B . "0x56C7") ; <CJK>
       (?$(I_A(B . "0x571D") ; <CJK>
       (?$(I_B(B . "0x5B4A") ; <CJK>
       (?$(I_C(B . "0x5DD3") ; <CJK>
       (?$(I_D(B . "0x3869") ; <CJK>
       (?$(I_E(B . "0x5F72") ; <CJK>
       (?$(I_F(B . "0x6202") ; <CJK>
       (?$(I_G(B . "0x39AB") ; <CJK>
       (?$(I_H(B . "0x6235") ; <CJK>
       (?$(I_I(B . "0x6527") ; <CJK>
       (?$(I_J(B . "0x651E") ; <CJK>
       (?$(I_K(B . "0x651F") ; <CJK>
       (?$(I_L(B . "0x3B2C") ; <CJK>
       (?$(I_M(B . "0x3B2D") ; <CJK>
       (?$(I_N(B . "0x6B07") ; <CJK>
       (?$(I_O(B . "0x6B06") ; <CJK>
       (?$(I_P(B . "0x3C17") ; <CJK>
       (?$(I_Q(B . "0x3D9A") ; <CJK>
       (?$(I_R(B . "0x7054") ; <CJK>
       (?$(I_S(B . "0x721C") ; <CJK>
       (?$(I_T(B . "0x7220") ; <CJK>
       (?$(I_U(B . "0x7AF8") ; <CJK>
       (?$(I_V(B . "0x426E") ; <CJK>
       (?$(I_W(B . "0x7C5D") ; <CJK>
       (?$(I_X(B . "0x7C58") ; <CJK>
       (?$(I_Y(B . "0x432C") ; <CJK>
       (?$(I_Z(B . "0x7E92") ; <CJK>
       (?$(I_[(B . "0x7F4E") ; <CJK>
       (?$(I_\(B . "0x43CA") ; <CJK>
       (?$(I_](B . "0x4578") ; <CJK>
       (?$(I_^(B . "0x4606") ; <CJK>
       (?$(I__(B . "0x8827") ; <CJK>
       (?$(I_`(B . "0x4607") ; <CJK>
       (?$(I_a(B . "0x8B81") ; <CJK>
       (?$(I_b(B . "0x8B83") ; <CJK>
       (?$(I_c(B . "0x4720") ; <CJK>
       (?$(I_d(B . "0x8C44") ; <CJK>
       (?$(I_e(B . "0x4753") ; <CJK>
       (?$(I_f(B . "0x47CE") ; <CJK>
       (?$(I_g(B . "0x487A") ; <CJK>
       (?$(I_h(B . "0x4879") ; <CJK>
       (?$(I_i(B . "0x9442") ; <CJK>
       (?$(I_j(B . "0x944D") ; <CJK>
       (?$(I_k(B . "0x9454") ; <CJK>
       (?$(I_l(B . "0x944E") ; <CJK>
       (?$(I_m(B . "0x496B") ; <CJK>
       (?$(I_n(B . "0x9443") ; <CJK>
       (?$(I_o(B . "0x4967") ; <CJK>
       (?$(I_p(B . "0x496D") ; <CJK>
       (?$(I_q(B . "0x973C") ; <CJK>
       (?$(I_r(B . "0x9740") ; <CJK>
       (?$(I_s(B . "0x97C0") ; <CJK>
       (?$(I_t(B . "0x4A85") ; <CJK>
       (?$(I_u(B . "0x4AB0") ; <CJK>
       (?$(I_v(B . "0x4AF3") ; <CJK>
       (?$(I_w(B . "0x4B63") ; <CJK>
       (?$(I_x(B . "0x995A") ; <CJK>
       (?$(I_y(B . "0x9A51") ; <CJK>
       (?$(I_z(B . "0x4BB6") ; <CJK>
       (?$(I_{(B . "0x9ADD") ; <CJK>
       (?$(I_|(B . "0x4C82") ; <CJK>
       (?$(I_}(B . "0x4C7F") ; <CJK>
       (?$(I_~(B . "0x9C38") ; <CJK>
       (?$(I`!(B . "0x4C86") ; <CJK>
       (?$(I`"(B . "0x9C45") ; <CJK>
       (?$(I`#(B . "0x9C3A") ; <CJK>
       (?$(I`$(B . "0x4C84") ; <CJK>
       (?$(I`%(B . "0x9C35") ; <CJK>
       (?$(I`&(B . "0x4CFC") ; <CJK>
       (?$(I`'(B . "0x4CFD") ; <CJK>
       (?$(I`((B . "0x4CFA") ; <CJK>
       (?$(I`)(B . "0x9EF1") ; <CJK>
       (?$(I`*(B . "0x4D87") ; <CJK>
       (?$(I`+(B . "0x9F93") ; <CJK>
       (?$(I`,(B . "0x529A") ; <CJK>
       (?$(I`-(B . "0x361A") ; <CJK>
       (?$(I`.(B . "0x3619") ; <CJK>
       (?$(I`/(B . "0x8641") ; <CJK>
       (?$(I`0(B . "0x5DD7") ; <CJK>
       (?$(I`1(B . "0x3A75") ; <CJK>
       (?$(I`2(B . "0x6528") ; <CJK>
       (?$(I`3(B . "0x3C1A") ; <CJK>
       (?$(I`4(B . "0x3C1B") ; <CJK>
       (?$(I`5(B . "0x3C19") ; <CJK>
       (?$(I`6(B . "0x7053") ; <CJK>
       (?$(I`7(B . "0x7059") ; <CJK>
       (?$(I`8(B . "0x3D9C") ; <CJK>
       (?$(I`9(B . "0x7221") ; <CJK>
       (?$(I`:(B . "0x3E10") ; <CJK>
       (?$(I`;(B . "0x766F") ; <CJK>
       (?$(I`<(B . "0x7937") ; <CJK>
       (?$(I`=(B . "0x79B5") ; <CJK>
       (?$(I`>(B . "0x7C62") ; <CJK>
       (?$(I`?(B . "0x7C5E") ; <CJK>
       (?$(I`@(B . "0x7CF5") ; <CJK>
       (?$(I`A(B . "0x457B") ; <CJK>
       (?$(I`B(B . "0x457C") ; <CJK>
       (?$(I`C(B . "0x863D") ; <CJK>
       (?$(I`D(B . "0x4608") ; <CJK>
       (?$(I`E(B . "0x882D") ; <CJK>
       (?$(I`F(B . "0x8989") ; <CJK>
       (?$(I`G(B . "0x8B8D") ; <CJK>
       (?$(I`H(B . "0x8B87") ; <CJK>
       (?$(I`I(B . "0x8B90") ; <CJK>
       (?$(I`J(B . "0x8D1A") ; <CJK>
       (?$(I`K(B . "0x8E99") ; <CJK>
       (?$(I`L(B . "0x4841") ; <CJK>
       (?$(I`M(B . "0x48E3") ; <CJK>
       (?$(I`N(B . "0x4972") ; <CJK>
       (?$(I`O(B . "0x945F") ; <CJK>
       (?$(I`P(B . "0x4973") ; <CJK>
       (?$(I`Q(B . "0x4968") ; <CJK>
       (?$(I`R(B . "0x9456") ; <CJK>
       (?$(I`S(B . "0x9461") ; <CJK>
       (?$(I`T(B . "0x945B") ; <CJK>
       (?$(I`U(B . "0x945A") ; <CJK>
       (?$(I`V(B . "0x945C") ; <CJK>
       (?$(I`W(B . "0x9465") ; <CJK>
       (?$(I`X(B . "0x4A35") ; <CJK>
       (?$(I`Y(B . "0x9741") ; <CJK>
       (?$(I`Z(B . "0x4A88") ; <CJK>
       (?$(I`[(B . "0x4A9D") ; <CJK>
       (?$(I`\(B . "0x986E") ; <CJK>
       (?$(I`](B . "0x986C") ; <CJK>
       (?$(I`^(B . "0x986D") ; <CJK>
       (?$(I`_(B . "0x4275") ; <CJK>
       (?$(I``(B . "0x99AA") ; <CJK>
       (?$(I`a(B . "0x9A5C") ; <CJK>
       (?$(I`b(B . "0x9A58") ; <CJK>
       (?$(I`c(B . "0x9ADE") ; <CJK>
       (?$(I`d(B . "0x4C8F") ; <CJK>
       (?$(I`e(B . "0x9C4F") ; <CJK>
       (?$(I`f(B . "0x9C51") ; <CJK>
       (?$(I`g(B . "0x4C8E") ; <CJK>
       (?$(I`h(B . "0x9C53") ; <CJK>
       (?$(I`i(B . "0x4D05") ; <CJK>
       (?$(I`j(B . "0x4D04") ; <CJK>
       (?$(I`k(B . "0x4CFF") ; <CJK>
       (?$(I`l(B . "0x9DFC") ; <CJK>
       (?$(I`m(B . "0x9F39") ; <CJK>
       (?$(I`n(B . "0x4D9E") ; <CJK>
       (?$(I`o(B . "0x513E") ; <CJK>
       (?$(I`p(B . "0x3554") ; <CJK>
       (?$(I`q(B . "0x56D2") ; <CJK>
       (?$(I`r(B . "0x3681") ; <CJK>
       (?$(I`s(B . "0x5B4F") ; <CJK>
       (?$(I`t(B . "0x6B14") ; <CJK>
       (?$(I`u(B . "0x40FA") ; <CJK>
       (?$(I`v(B . "0x7A72") ; <CJK>
       (?$(I`w(B . "0x7A73") ; <CJK>
       (?$(I`x(B . "0x4332") ; <CJK>
       (?$(I`y(B . "0x4670") ; <CJK>
       (?$(I`z(B . "0x466E") ; <CJK>
       (?$(I`{(B . "0x8B91") ; <CJK>
       (?$(I`|(B . "0x2F9D6") ; <CJK>
       (?$(I`}(B . "0x487C") ; <CJK>
       (?$(I`~(B . "0x91BF") ; <CJK>
       (?$(Ia!(B . "0x4975") ; <CJK>
       (?$(Ia"(B . "0x946C") ; <CJK>
       (?$(Ia#(B . "0x4974") ; <CJK>
       (?$(Ia$(B . "0x4977") ; <CJK>
       (?$(Ia%(B . "0x96E6") ; <CJK>
       (?$(Ia&(B . "0x9745") ; <CJK>
       (?$(Ia'(B . "0x4A37") ; <CJK>
       (?$(Ia((B . "0x97C8") ; <CJK>
       (?$(Ia)(B . "0x97E4") ; <CJK>
       (?$(Ia*(B . "0x995D") ; <CJK>
       (?$(Ia+(B . "0x4BBA") ; <CJK>
       (?$(Ia,(B . "0x9B21") ; <CJK>
       (?$(Ia-(B . "0x4C11") ; <CJK>
       (?$(Ia.(B . "0x9B2C") ; <CJK>
       (?$(Ia/(B . "0x9B57") ; <CJK>
       (?$(Ia0(B . "0x4C92") ; <CJK>
       (?$(Ia1(B . "0x4C99") ; <CJK>
       (?$(Ia2(B . "0x9C5D") ; <CJK>
       (?$(Ia3(B . "0x9C61") ; <CJK>
       (?$(Ia4(B . "0x9C65") ; <CJK>
       (?$(Ia5(B . "0x9E08") ; <CJK>
       (?$(Ia6(B . "0x4D0A") ; <CJK>
       (?$(Ia7(B . "0x4D2A") ; <CJK>
       (?$(Ia8(B . "0x4D2B") ; <CJK>
       (?$(Ia9(B . "0x4D44") ; <CJK>
       (?$(Ia:(B . "0x4D79") ; <CJK>
       (?$(Ia;(B . "0x9F45") ; <CJK>
       (?$(Ia<(B . "0x34AA") ; <CJK>
       (?$(Ia=(B . "0x3748") ; <CJK>
       (?$(Ia>(B . "0x6205") ; <CJK>
       (?$(Ia?(B . "0x66EF") ; <CJK>
       (?$(Ia@(B . "0x6B1B") ; <CJK>
       (?$(IaA(B . "0x6B1D") ; <CJK>
       (?$(IaB(B . "0x7225") ; <CJK>
       (?$(IaC(B . "0x7224") ; <CJK>
       (?$(IaD(B . "0x7C6D") ; <CJK>
       (?$(IaE(B . "0x42B4") ; <CJK>
       (?$(IaF(B . "0x8642") ; <CJK>
       (?$(IaG(B . "0x8649") ; <CJK>
       (?$(IaH(B . "0x460D") ; <CJK>
       (?$(IaI(B . "0x8978") ; <CJK>
       (?$(IaJ(B . "0x898A") ; <CJK>
       (?$(IaK(B . "0x8B97") ; <CJK>
       (?$(IaL(B . "0x4754") ; <CJK>
       (?$(IaM(B . "0x8C9B") ; <CJK>
       (?$(IaN(B . "0x8D1C") ; <CJK>
       (?$(IaO(B . "0x4830") ; <CJK>
       (?$(IaP(B . "0x8EA2") ; <CJK>
       (?$(IaQ(B . "0x4A09") ; <CJK>
       (?$(IaR(B . "0x4A38") ; <CJK>
       (?$(IaS(B . "0x4A36") ; <CJK>
       (?$(IaT(B . "0x4A8B") ; <CJK>
       (?$(IaU(B . "0x4AF7") ; <CJK>
       (?$(IaV(B . "0x4B66") ; <CJK>
       (?$(IaW(B . "0x4BBD") ; <CJK>
       (?$(IaX(B . "0x4C1E") ; <CJK>
       (?$(IaY(B . "0x9C6C") ; <CJK>
       (?$(IaZ(B . "0x4C96") ; <CJK>
       (?$(Ia[(B . "0x9C6F") ; <CJK>
       (?$(Ia\(B . "0x4D0D") ; <CJK>
       (?$(Ia](B . "0x9E0E") ; <CJK>
       (?$(Ia^(B . "0x4D73") ; <CJK>
       (?$(Ia_(B . "0x9F08") ; <CJK>
       (?$(Ia`(B . "0x9F1D") ; <CJK>
       (?$(Iaa(B . "0x9FA3") ; <CJK>
       (?$(Iab(B . "0x373B") ; <CJK>
       (?$(Iac(B . "0x373C") ; <CJK>
       (?$(Iad(B . "0x5F60") ; <CJK>
       (?$(Iae(B . "0x6B1C") ; <CJK>
       (?$(Iaf(B . "0x3DA0") ; <CJK>
       (?$(Iag(B . "0x40FB") ; <CJK>
       (?$(Iah(B . "0x7C6F") ; <CJK>
       (?$(Iai(B . "0x7CF3") ; <CJK>
       (?$(Iaj(B . "0x4581") ; <CJK>
       (?$(Iak(B . "0x8B9B") ; <CJK>
       (?$(Ial(B . "0x8EA7") ; <CJK>
       (?$(Iam(B . "0x91C4") ; <CJK>
       (?$(Ian(B . "0x4978") ; <CJK>
       (?$(Iao(B . "0x947A") ; <CJK>
       (?$(Iap(B . "0x4A8D") ; <CJK>
       (?$(Iaq(B . "0x4B73") ; <CJK>
       (?$(Iar(B . "0x9A61") ; <CJK>
       (?$(Ias(B . "0x9A63") ; <CJK>
       (?$(Iat(B . "0x9AD7") ; <CJK>
       (?$(Iau(B . "0x9C76") ; <CJK>
       (?$(Iav(B . "0x4DA6") ; <CJK>
       (?$(Iaw(B . "0x9FA5") ; <CJK>
       (?$(Iax(B . "0x39AD") ; <CJK>
       (?$(Iay(B . "0x7067") ; <CJK>
       (?$(Iaz(B . "0x3E11") ; <CJK>
       (?$(Ia{(B . "0x72AB") ; <CJK>
       (?$(Ia|(B . "0x864A") ; <CJK>
       (?$(Ia}(B . "0x897D") ; <CJK>
       (?$(Ia~(B . "0x8B9D") ; <CJK>
       (?$(Ib!(B . "0x8C53") ; <CJK>
       (?$(Ib"(B . "0x8F65") ; <CJK>
       (?$(Ib#(B . "0x947B") ; <CJK>
       (?$(Ib$(B . "0x4A39") ; <CJK>
       (?$(Ib%(B . "0x98CD") ; <CJK>
       (?$(Ib&(B . "0x98DD") ; <CJK>
       (?$(Ib'(B . "0x4BBF") ; <CJK>
       (?$(Ib((B . "0x9B30") ; <CJK>
       (?$(Ib)(B . "0x9E16") ; <CJK>
       (?$(Ib*(B . "0x4D0F") ; <CJK>
       (?$(Ib+(B . "0x4DA7") ; <CJK>
       (?$(Ib,(B . "0x4DB5") ; <CJK>
       (?$(Ib-(B . "0x3FDC") ; <CJK>
       (?$(Ib.(B . "0x4831") ; <CJK>
       (?$(Ib/(B . "0x96E7") ; <CJK>
       (?$(Ib0(B . "0x9E18") ; <CJK>
       (?$(Ib1(B . "0x9EA2") ; <CJK>
       (?$(Ib2(B . "0x4DA8") ; <CJK>
       (?$(Ib3(B . "0x9F7C") ; <CJK>
       (?$(Ib4(B . "0x4125") ; <CJK>
       (?$(Ib5(B . "0x7E9E") ; <CJK>
       (?$(Ib6(B . "0x9484") ; <CJK>
       (?$(Ib7(B . "0x4BC1") ; <CJK>
       (?$(Ib8(B . "0x9E1C") ; <CJK>
       (?$(Ib9(B . "0x4190") ; <CJK>
       (?$(Ib:(B . "0x7C71") ; <CJK>
       (?$(Ib;(B . "0x97CA") ; <CJK>
       (?$(Ib<(B . "0x4696") ; <CJK>
       (?$(Ib=(B . "0x487F") ; <CJK>
       (?$(Ib>(B . "0x4D10") ; <CJK>
       (?$(Ib?(B . "0x9EA3") ; <CJK>
       (?$(Ib@(B . "0x4A0A") ; <CJK>
       (?$(IbA(B . "0x9C7B") ; <CJK>
       (?$(IbB(B . "0x9F97") ; <CJK>
       (?$(IbC(B . "0x4D12") ; <CJK>
       (?$(IbD(B . "0x4A3A") ; <CJK>
       (?$(IbE(B . "0x9750") ; <CJK>
       (?$(IbF(B . "0x4A3B") ; <CJK>
       ))))

(provide 'u-cns-3)

;;; u-cns-3.el ends here
 
