/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.nodes;

import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SortOrder;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNodeFilter;
import org.graalvm.visualvm.heapviewer.model.Progress;
import org.graalvm.visualvm.heapviewer.model.RootNode;
import org.graalvm.visualvm.heapviewer.truffle.TruffleObject;
import org.graalvm.visualvm.heapviewer.truffle.TruffleObjectsWrapper;
import org.graalvm.visualvm.heapviewer.truffle.TruffleType;
import org.graalvm.visualvm.heapviewer.truffle.nodes.Bundle;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerRenderer;
import org.graalvm.visualvm.heapviewer.ui.UIThresholds;
import org.graalvm.visualvm.heapviewer.utils.NodesComputer;
import org.graalvm.visualvm.heapviewer.utils.ProgressIterator;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.ui.swing.renderer.LabelRenderer;

public abstract class TruffleTypeNode<O extends TruffleObject, T extends TruffleType<O>>
extends HeapViewerNode {
    private final T type;

    protected TruffleTypeNode(T type) {
        this.type = type;
    }

    public abstract HeapViewerNode createNode(O var1);

    public abstract TruffleTypeNode<O, T> createCopy();

    public T getType() {
        return this.type;
    }

    public String getName() {
        return ((TruffleType)this.type).getName();
    }

    public int getObjectsCount() {
        return ((TruffleType)this.type).getObjectsCount();
    }

    public long getOwnSize() {
        return ((TruffleType)this.type).getAllObjectsSize();
    }

    public long getRetainedSize(Heap heap) {
        return ((TruffleType)this.type).getRetainedSizeByType(heap);
    }

    public TruffleObjectsWrapper<O> getObjectsWrapper() {
        return new TruffleObjectsWrapper<O>(){

            @Override
            public String getType() {
                return TruffleTypeNode.this.getName();
            }

            @Override
            public int getObjectsCount() {
                return TruffleTypeNode.this.getObjectsCount();
            }

            @Override
            public Iterator<O> getObjectsIterator() {
                return TruffleTypeNode.this.type.getObjectsIterator();
            }
        };
    }

    public boolean isLeaf() {
        return ((TruffleType)this.type).getObjectsCount() == 0 ? true : super.isLeaf();
    }

    public String toString() {
        return this.getName();
    }

    protected HeapViewerNode[] computeChildren(RootNode root) {
        int itemsCount = ((TruffleType)this.type).getObjectsCount();
        if (itemsCount <= UIThresholds.MAX_CLASS_INSTANCES) {
            Heap heap = root.getContext().getFragment().getHeap();
            HeapViewerNode[] nodes = new HeapViewerNode[itemsCount];
            Iterator iterator = ((TruffleType)this.type).getObjectsIterator();
            int i = 0;
            while (iterator.hasNext()) {
                TruffleObject object = (TruffleObject)iterator.next();
                nodes[i++] = this.createNode(object);
            }
            return nodes;
        }
        return super.computeChildren(root);
    }

    protected HeapViewerNode[] lazilyComputeChildren(Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
        NodesComputer computer = new NodesComputer<O>(((TruffleType)this.type).getObjectsCount(), UIThresholds.MAX_CLASS_INSTANCES){

            protected boolean sorts(DataType dataType) {
                return !DataType.COUNT.equals(dataType);
            }

            protected HeapViewerNode createNode(O object) {
                return TruffleTypeNode.this.createNode(object);
            }

            protected ProgressIterator<O> objectsIterator(int index, Progress progress) {
                Iterator iterator = TruffleTypeNode.this.type.getObjectsIterator();
                return new ProgressIterator(iterator, index, true, progress);
            }

            protected String getMoreNodesString(String moreNodesCount) {
                return Bundle.TruffleTypeNode_MoreNodes(moreNodesCount);
            }

            protected String getSamplesContainerString(String objectsCount) {
                return Bundle.TruffleTypeNode_SamplesContainer(objectsCount);
            }

            protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
                return Bundle.TruffleTypeNode_NodesContainer(firstNodeIdx, lastNodeIdx);
            }
        };
        return computer.computeNodes((HeapViewerNode)this, heap, viewID, null, dataTypes, sortOrders, progress);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TruffleTypeNode)) {
            return false;
        }
        return this.getName().equals(((TruffleTypeNode)((Object)o)).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    protected Object getValue(DataType type, Heap heap) {
        if (type == DataType.NAME) {
            return this.getName();
        }
        if (type == DataType.COUNT) {
            return this.getObjectsCount();
        }
        if (type == DataType.OWN_SIZE) {
            return this.getOwnSize();
        }
        if (type == DataType.RETAINED_SIZE) {
            return this.getRetainedSize(heap);
        }
        if (type == TruffleType.TYPE_NAME) {
            return this.getName();
        }
        if (type == TruffleObjectsWrapper.DATA_TYPE) {
            return this.getObjectsWrapper();
        }
        if (type == DataType.LOGICAL_VALUE) {
            return DataType.LOGICAL_VALUE.getNoValue();
        }
        if (type == DataType.OBJECT_ID) {
            return DataType.OBJECT_ID.getNoValue();
        }
        return super.getValue(type, heap);
    }

    protected void setupCopy(TruffleTypeNode<O, T> copy) {
        super.setupCopy(copy);
    }

    public static class Renderer
    extends LabelRenderer
    implements HeapViewerRenderer {
        public Renderer(Icon icon) {
            this.setIcon(icon);
            this.setFont(this.getFont().deriveFont(1));
        }
    }
}

