/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.TreeMap;
import org.jboss.galleon.util.ZipUtils;

public class HashUtils {
    private static final char[] TABLE = "0123456789abcdef".toCharArray();
    private static final MessageDigest DIGEST;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] hashPath(Path path) throws IOException {
        MessageDigest messageDigest = DIGEST;
        synchronized (messageDigest) {
            DIGEST.reset();
            HashUtils.updateDigest(DIGEST, path);
            return DIGEST.digest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String hashFile(Path path) throws IOException {
        MessageDigest messageDigest = DIGEST;
        synchronized (messageDigest) {
            DIGEST.reset();
            HashUtils.updateDigest(DIGEST, path);
            return HashUtils.bytesToHexString(DIGEST.digest());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String hash(String content) throws IOException {
        MessageDigest messageDigest = DIGEST;
        synchronized (messageDigest) {
            DIGEST.reset();
            DIGEST.update(content.getBytes(StandardCharsets.UTF_8));
            return HashUtils.bytesToHexString(DIGEST.digest());
        }
    }

    private static void updateDigest(MessageDigest digest, Path path) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
                TreeMap<String, Path> sortedChildren = new TreeMap<String, Path>();
                for (Path p : stream) {
                    sortedChildren.put(p.getFileName().toString(), p);
                }
                for (Path child : sortedChildren.values()) {
                    HashUtils.updateDigest(digest, child);
                }
            }
        }
        try (BufferedInputStream bis = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
            int read;
            byte[] bytes = new byte[8192];
            while ((read = bis.read(bytes)) > -1) {
                digest.update(bytes, 0, read);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] hashJar(Path jarFile, boolean ignoreManifest) throws IOException {
        MessageDigest messageDigest = DIGEST;
        synchronized (messageDigest) {
            DIGEST.reset();
            try (FileSystem zipfs = ZipUtils.newFileSystem(jarFile);){
                for (Path zipRoot : zipfs.getRootDirectories()) {
                    TreeMap<String, Path> sortedChildren = new TreeMap<String, Path>();
                    try (DirectoryStream<Path> stream = Files.newDirectoryStream(zipRoot);){
                        for (Path p : stream) {
                            String fileName = p.getFileName().toString();
                            if (ignoreManifest && fileName.equals("META-INF/")) continue;
                            sortedChildren.put(fileName, p);
                        }
                    }
                    for (Path child : sortedChildren.values()) {
                        HashUtils.updateDigest(DIGEST, child);
                    }
                }
            }
            return DIGEST.digest();
        }
    }

    public static String bytesToHexString(byte[] bytes) {
        StringBuilder builder = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            builder.append(TABLE[b >> 4 & 0xF]).append(TABLE[b & 0xF]);
        }
        return builder.toString();
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int x = Character.digit(s.charAt(j), 16) << 4;
            x |= Character.digit(s.charAt(++j), 16);
            ++j;
            data[i] = (byte)(x & 0xFF);
            ++i;
        }
        return data;
    }

    static {
        try {
            DIGEST = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

