/*
 * Decompiled with CFR 0.152.
 */
package ch.csnc.extension.httpclient;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang.StringUtils;

public class PKCS11Configuration {
    private final String name;
    private final String library;
    private final String description;
    private final int slotId;
    private final int slotListIndex;

    private PKCS11Configuration(String name, String library, String description, int slotId, int slotListIndex) {
        this.name = name;
        this.library = library;
        this.description = description;
        this.slotId = slotId;
        this.slotListIndex = slotListIndex;
    }

    public String getName() {
        return this.name;
    }

    public String getLibrary() {
        return this.library;
    }

    public String getDescription() {
        return this.description;
    }

    public int getSlotListIndex() {
        return this.slotListIndex;
    }

    public int getSlotId() {
        return this.slotId;
    }

    public String toString() {
        StringBuilder sbConfiguration = new StringBuilder(150);
        sbConfiguration.append("name = \"").append(PKCS11Configuration.escapeBackslashesAndQuotationMarks(this.name)).append("\"\n");
        sbConfiguration.append("library = ").append(this.library).append('\n');
        if (this.description != null && !this.description.isEmpty()) {
            sbConfiguration.append("description = ").append(this.description).append('\n');
        }
        if (this.slotListIndex != -1) {
            sbConfiguration.append("slotListIndex = ").append(this.slotListIndex);
        } else {
            sbConfiguration.append("slot = ").append(this.slotId);
        }
        sbConfiguration.append('\n');
        return sbConfiguration.toString();
    }

    private static String escapeBackslashesAndQuotationMarks(String value) {
        String[] searchValues = new String[]{"\\", "\""};
        String[] replacementValues = new String[]{"\\\\", "\\\""};
        return StringUtils.replaceEach(value, searchValues, replacementValues);
    }

    public InputStream toInpuStream() {
        return new ByteArrayInputStream(this.toString().getBytes(StandardCharsets.UTF_8));
    }

    public static PCKS11ConfigurationBuilder builder() {
        return new PCKS11ConfigurationBuilder();
    }

    public static final class PCKS11ConfigurationBuilder {
        private String name;
        private String library;
        private String description;
        private int slotId = -1;
        private int slotListIndex = 0;

        private PCKS11ConfigurationBuilder() {
        }

        public PCKS11ConfigurationBuilder setName(String name) {
            if (name == null || name.isEmpty()) {
                throw new IllegalArgumentException("Parameter name must not be null or empty.");
            }
            this.name = name;
            return this;
        }

        public PCKS11ConfigurationBuilder setLibrary(String library) {
            if (library == null || library.isEmpty()) {
                throw new IllegalArgumentException("Parameter library must not be null or empty.");
            }
            this.library = library;
            return this;
        }

        public PCKS11ConfigurationBuilder setDescription(String description) {
            this.description = description;
            return this;
        }

        public PCKS11ConfigurationBuilder setSlotListIndex(int slotListIndex) {
            if (slotListIndex < 0) {
                throw new IllegalArgumentException("Parameter slotListIndex must be greater or equal to zero.");
            }
            this.slotListIndex = slotListIndex;
            this.slotId = -1;
            return this;
        }

        public final PCKS11ConfigurationBuilder setSlotId(int slotId) {
            if (slotId < 0) {
                throw new IllegalArgumentException("Parameter slotId must be greater or equal to zero.");
            }
            this.slotId = slotId;
            this.slotListIndex = -1;
            return this;
        }

        public PKCS11Configuration build() {
            this.validateBuilderState();
            return new PKCS11Configuration(this.name, this.library, this.description, this.slotId, this.slotListIndex);
        }

        private void validateBuilderState() {
            if (this.name == null) {
                throw new IllegalStateException("A name must be set.");
            }
            if (this.library == null) {
                throw new IllegalStateException("A library must be set.");
            }
        }
    }
}

