/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.config.ir;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;
import org.logstash.common.IncompleteSourceWithMetadataException;
import org.logstash.common.SourceWithMetadata;

public final class PipelineConfig {
    private static final Logger logger = LogManager.getLogger(PipelineConfig.class);
    private RubyClass source;
    private String pipelineId;
    private List<SourceWithMetadata> confParts;
    private RubyObject settings;
    private LocalDateTime readAt;
    private String configHash;
    private volatile String configString;
    private volatile String metadata;
    private List<LineToSource> sourceRefs;
    private static final String NEWLINE = "\n";

    public PipelineConfig(RubyClass source, RubySymbol pipelineId, RubyObject uncastedConfigParts, RubyObject logstashSettings) {
        IRubyObject uncasted = uncastedConfigParts.checkArrayType();
        RubyArray configParts = !uncasted.isNil() ? (RubyArray)uncasted : RubyArray.newArray((Ruby)RubyUtil.RUBY, (IRubyObject)uncastedConfigParts);
        this.source = source;
        this.pipelineId = pipelineId.name(RubyUtil.RUBY.getCurrentContext()).asJavaString();
        SourceWithMetadata[] castedConfigParts = (SourceWithMetadata[])configParts.toJava(SourceWithMetadata[].class);
        List<SourceWithMetadata> confParts = Arrays.asList(castedConfigParts);
        confParts.sort(Comparator.comparing(SourceWithMetadata::getProtocol).thenComparing(SourceWithMetadata::getId));
        this.confParts = confParts;
        this.settings = logstashSettings;
        this.readAt = LocalDateTime.now();
    }

    public RubyClass getSource() {
        return this.source;
    }

    public String getPipelineId() {
        return this.pipelineId;
    }

    public List<SourceWithMetadata> getConfigParts() {
        return this.confParts;
    }

    public LocalDateTime getReadAt() {
        return this.readAt;
    }

    public RubyObject getSettings() {
        return this.settings;
    }

    public String configHash() {
        if (this.configHash == null) {
            this.configHash = DigestUtils.sha1Hex((String)(this.configString() + this.metadataString()));
        }
        return this.configHash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String configString() {
        if (this.configString == null) {
            PipelineConfig pipelineConfig = this;
            synchronized (pipelineConfig) {
                if (this.configString == null) {
                    StringBuilder compositeConfig = new StringBuilder();
                    for (SourceWithMetadata confPart : this.confParts) {
                        if (compositeConfig.lastIndexOf(NEWLINE) < compositeConfig.length() - 1) {
                            compositeConfig.append(NEWLINE);
                        }
                        compositeConfig.append(confPart.getText());
                    }
                    this.configString = compositeConfig.toString();
                }
            }
        }
        return this.configString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String metadataString() {
        if (this.metadata == null) {
            PipelineConfig pipelineConfig = this;
            synchronized (pipelineConfig) {
                if (this.metadata == null) {
                    this.metadata = this.confParts.stream().map(SourceWithMetadata::getMetadata).collect(Collectors.joining());
                }
            }
        }
        return this.metadata;
    }

    public boolean isSystem() {
        return this.settings.callMethod(RubyUtil.RUBY.getCurrentContext(), "get_value", (IRubyObject)RubyString.newString((Ruby)RubyUtil.RUBY, (String)"pipeline.system")).isTrue();
    }

    public boolean equals(Object other) {
        if (!(other instanceof PipelineConfig)) {
            return false;
        }
        PipelineConfig cother = (PipelineConfig)other;
        return this.configHash().equals(cother.configHash()) && this.pipelineId.equals(cother.pipelineId) && this.settings.equals((Object)cother.settings);
    }

    public int hashCode() {
        return this.configHash().hashCode();
    }

    public void displayDebugInformation() {
        logger.debug("-------- Logstash Config ---------");
        logger.debug("Config from source, source: {}, pipeline_id:: {}", (Object)this.source, (Object)this.pipelineId);
        for (SourceWithMetadata configPart : this.confParts) {
            logger.debug("Config string, protocol: {}, id: {}", (Object)configPart.getProtocol(), (Object)configPart.getId());
            logger.debug("\n\n{}", (Object)configPart.getText());
        }
        logger.debug("Merged config");
        logger.debug("\n\n{}", (Object)this.configString());
    }

    public SourceWithMetadata lookupSource(int globalLineNumber, int sourceColumn) throws IncompleteSourceWithMetadataException {
        LineToSource lts = this.sourceReferences().stream().filter(lts1 -> lts1.includeLine(globalLineNumber)).findFirst().orElseThrow(() -> new IllegalArgumentException("can't find the config segment related to line " + globalLineNumber));
        return new SourceWithMetadata(lts.source.getProtocol(), lts.source.getId(), globalLineNumber + 1 - lts.startLine, sourceColumn, lts.source.getText());
    }

    private List<LineToSource> sourceReferences() {
        if (this.sourceRefs == null) {
            int offset = 0;
            ArrayList<LineToSource> sourceRefs = new ArrayList<LineToSource>();
            for (SourceWithMetadata configPart : this.confParts) {
                int startLine = configPart.getLine() + offset + 1;
                int endLine = configPart.getLinesCount() + offset;
                LineToSource sourceSegment = new LineToSource(startLine, endLine, configPart);
                sourceRefs.add(sourceSegment);
                offset += configPart.getLinesCount();
            }
            this.sourceRefs = Collections.unmodifiableList(sourceRefs);
        }
        return this.sourceRefs;
    }

    private static class LineToSource {
        private final int startLine;
        private final int endLine;
        private final SourceWithMetadata source;

        LineToSource(int startLine, int endLine, SourceWithMetadata source) {
            this.startLine = startLine;
            this.endLine = endLine;
            this.source = source;
        }

        boolean includeLine(int lineNumber) {
            return this.startLine <= lineNumber && lineNumber <= this.endLine;
        }
    }
}

