"""Generated message classes for dataprocgdc version v1alpha1.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'dataprocgdc'


class ApplicationEnvironment(_messages.Message):
  r"""Represents the ApplicationEnvironment resource.

  Messages:
    AnnotationsValue: Optional. The annotations to associate with this
      application environment. Annotations may be used to store client
      information, but are not used by the server.
    LabelsValue: Optional. The labels to associate with this application
      environment. Labels may be used for filtering and billing tracking.

  Fields:
    annotations: Optional. The annotations to associate with this application
      environment. Annotations may be used to store client information, but
      are not used by the server.
    createTime: Output only. The timestamp when the resource was created.
    displayName: Optional. User-provided human-readable name to be used in
      user interfaces.
    labels: Optional. The labels to associate with this application
      environment. Labels may be used for filtering and billing tracking.
    name: Identifier. Fields 1-6 should exist for all declarative friendly
      resources per aip.dev/148 The name of the application environment.
      Format: projects/{project}/locations/{location}/serviceInstances/{servic
      e_instance}/applicationEnvironments/{application_environment_id}
    namespace: Optional. The name of the namespace in which to create this
      ApplicationEnvironment. This namespace must already exist in the cluster
    sparkApplicationEnvironmentConfig: Optional. The engine-specific
      configurations for this ApplicationEnvironment.
    uid: Output only. System generated unique identifier for this application
      environment, formatted as UUID4.
    updateTime: Output only. The timestamp when the resource was most recently
      updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""Optional. The annotations to associate with this application
    environment. Annotations may be used to store client information, but are
    not used by the server.

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. The labels to associate with this application environment.
    Labels may be used for filtering and billing tracking.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotations = _messages.MessageField('AnnotationsValue', 1)
  createTime = _messages.StringField(2)
  displayName = _messages.StringField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  namespace = _messages.StringField(6)
  sparkApplicationEnvironmentConfig = _messages.MessageField('SparkApplicationEnvironmentConfig', 7)
  uid = _messages.StringField(8)
  updateTime = _messages.StringField(9)


class AuxiliaryServicesConfig(_messages.Message):
  r"""Auxiliary Service Configs.

  Fields:
    sparkHistoryServer: Optional. Spark History Servor message.
  """

  sparkHistoryServer = _messages.MessageField('SparkHistoryServer', 1)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class DataprocgdcProjectsLocationsGetRequest(_messages.Message):
  r"""A DataprocgdcProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class DataprocgdcProjectsLocationsListRequest(_messages.Message):
  r"""A DataprocgdcProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class DataprocgdcProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A DataprocgdcProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class DataprocgdcProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A DataprocgdcProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class DataprocgdcProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A DataprocgdcProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class DataprocgdcProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A DataprocgdcProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class DataprocgdcProjectsLocationsServiceInstancesApplicationEnvironmentsCreateRequest(_messages.Message):
  r"""A DataprocgdcProjectsLocationsServiceInstancesApplicationEnvironmentsCre
  ateRequest object.

  Fields:
    applicationEnvironment: A ApplicationEnvironment resource to be passed as
      the request body.
    applicationEnvironmentId: Optional. The id of the application environment
    parent: Required. The parent location resource where this application
      environment will be created
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  applicationEnvironment = _messages.MessageField('ApplicationEnvironment', 1)
  applicationEnvironmentId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class DataprocgdcProjectsLocationsServiceInstancesApplicationEnvironmentsDeleteRequest(_messages.Message):
  r"""A DataprocgdcProjectsLocationsServiceInstancesApplicationEnvironmentsDel
  eteRequest object.

  Fields:
    allowMissing: Optional. If set to true, and the application is not found,
      the request will succeed but no action will be taken on the server
    etag: Optional. The etag of the application. If this is provided, it must
      match the server etag.
    name: Required. The name of the application to delete.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  allowMissing = _messages.BooleanField(1)
  etag = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class DataprocgdcProjectsLocationsServiceInstancesApplicationEnvironmentsGetRequest(_messages.Message):
  r"""A DataprocgdcProjectsLocationsServiceInstancesApplicationEnvironmentsGet
  Request object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class DataprocgdcProjectsLocationsServiceInstancesApplicationEnvironmentsListRequest(_messages.Message):
  r"""A DataprocgdcProjectsLocationsServiceInstancesApplicationEnvironmentsLis
  tRequest object.

  Fields:
    filter: Optional. Filtering results
    orderBy: Optional. Hint for how to order the results
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListSparkApplicationsRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class DataprocgdcProjectsLocationsServiceInstancesApplicationEnvironmentsPatchRequest(_messages.Message):
  r"""A DataprocgdcProjectsLocationsServiceInstancesApplicationEnvironmentsPat
  chRequest object.

  Fields:
    allowMissing: Optional. Whether to upsert this application if it does not
      exist already In this situation, `update_mask` is ignored.
    applicationEnvironment: A ApplicationEnvironment resource to be passed as
      the request body.
    name: Identifier. Fields 1-6 should exist for all declarative friendly
      resources per aip.dev/148 The name of the application environment.
      Format: projects/{project}/locations/{location}/serviceInstances/{servic
      e_instance}/applicationEnvironments/{application_environment_id}
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Required. The list of fields to update.
  """

  allowMissing = _messages.BooleanField(1)
  applicationEnvironment = _messages.MessageField('ApplicationEnvironment', 2)
  name = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)
  updateMask = _messages.StringField(5)


class DataprocgdcProjectsLocationsServiceInstancesCreateRequest(_messages.Message):
  r"""A DataprocgdcProjectsLocationsServiceInstancesCreateRequest object.

  Fields:
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    serviceInstance: A ServiceInstance resource to be passed as the request
      body.
    serviceInstanceId: Required. Id of the requesting object If auto-
      generating Id server-side, remove this field and service_instance_id
      from the method_signature of Create RPC
  """

  parent = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  serviceInstance = _messages.MessageField('ServiceInstance', 3)
  serviceInstanceId = _messages.StringField(4)


class DataprocgdcProjectsLocationsServiceInstancesDeleteRequest(_messages.Message):
  r"""A DataprocgdcProjectsLocationsServiceInstancesDeleteRequest object.

  Fields:
    allowMissing: Optional. If set to true, and the service instance is not
      found, the request will succeed but no action will be taken on the
      server
    etag: Optional. The etag of the service instance. If this is provided, it
      must match the server etag.
    force: Optional. If set to true, any jobs and job environments associated
      with this service instance will also be deleted. If false (default) the
      service instance can only be deleted if there are no job environments or
      jobs associated with the service instance.
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  allowMissing = _messages.BooleanField(1)
  etag = _messages.StringField(2)
  force = _messages.BooleanField(3)
  name = _messages.StringField(4, required=True)
  requestId = _messages.StringField(5)


class DataprocgdcProjectsLocationsServiceInstancesGetRequest(_messages.Message):
  r"""A DataprocgdcProjectsLocationsServiceInstancesGetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class DataprocgdcProjectsLocationsServiceInstancesListRequest(_messages.Message):
  r"""A DataprocgdcProjectsLocationsServiceInstancesListRequest object.

  Fields:
    filter: Optional. Filtering results
    orderBy: Optional. Hint for how to order the results
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListServiceInstancesRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class DataprocgdcProjectsLocationsServiceInstancesSparkApplicationsCreateRequest(_messages.Message):
  r"""A
  DataprocgdcProjectsLocationsServiceInstancesSparkApplicationsCreateRequest
  object.

  Fields:
    parent: Required. The parent location resource where this application will
      be created
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    sparkApplication: A SparkApplication resource to be passed as the request
      body.
    sparkApplicationId: Required. The id of the application
  """

  parent = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  sparkApplication = _messages.MessageField('SparkApplication', 3)
  sparkApplicationId = _messages.StringField(4)


class DataprocgdcProjectsLocationsServiceInstancesSparkApplicationsDeleteRequest(_messages.Message):
  r"""A
  DataprocgdcProjectsLocationsServiceInstancesSparkApplicationsDeleteRequest
  object.

  Fields:
    allowMissing: Optional. If set to true, and the application is not found,
      the request will succeed but no action will be taken on the server
    etag: Optional. The etag of the application. If this is provided, it must
      match the server etag.
    name: Required. The name of the application to delete.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  allowMissing = _messages.BooleanField(1)
  etag = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class DataprocgdcProjectsLocationsServiceInstancesSparkApplicationsGetRequest(_messages.Message):
  r"""A
  DataprocgdcProjectsLocationsServiceInstancesSparkApplicationsGetRequest
  object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class DataprocgdcProjectsLocationsServiceInstancesSparkApplicationsListRequest(_messages.Message):
  r"""A
  DataprocgdcProjectsLocationsServiceInstancesSparkApplicationsListRequest
  object.

  Fields:
    filter: Optional. Filtering results
    orderBy: Optional. Hint for how to order the results
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListSparkApplicationsRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class DataprocgdcProjectsLocationsServiceInstancesSparkApplicationsPatchRequest(_messages.Message):
  r"""A
  DataprocgdcProjectsLocationsServiceInstancesSparkApplicationsPatchRequest
  object.

  Fields:
    allowMissing: Optional. Whether to upsert this application if it does not
      exist already In this situation, `update_mask` is ignored.
    name: Identifier. Fields 1-6 should exist for all declarative friendly
      resources per aip.dev/148 The name of the application. Format: projects/
      {project}/locations/{location}/serviceInstances/{service_instance}/spark
      Applications/{application}
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    sparkApplication: A SparkApplication resource to be passed as the request
      body.
    updateMask: Required. The list of fields to update.
  """

  allowMissing = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  sparkApplication = _messages.MessageField('SparkApplication', 4)
  updateMask = _messages.StringField(5)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class GdceCluster(_messages.Message):
  r"""Gdce cluster information.

  Fields:
    gdceCluster: Required. Gdce cluster resource id.
  """

  gdceCluster = _messages.StringField(1)


class ListApplicationEnvironmentsResponse(_messages.Message):
  r"""Message for response to listing ApplicationEnvironments

  Fields:
    applicationEnvironments: The list of ApplicationEnvironment
    nextPageToken: Output only. A token identifying a page of results the
      server should return.
    unreachable: Output only. Locations that could not be reached.
  """

  applicationEnvironments = _messages.MessageField('ApplicationEnvironment', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListServiceInstancesResponse(_messages.Message):
  r"""Message for response to listing ServiceInstances

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    serviceInstances: The list of ServiceInstance
    unreachable: Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  serviceInstances = _messages.MessageField('ServiceInstance', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class ListSparkApplicationsResponse(_messages.Message):
  r"""Message for response to listing SparkApplications

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    sparkApplications: The list of SparkApplication
    unreachable: Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  sparkApplications = _messages.MessageField('SparkApplication', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents a Google Cloud location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class MaintenancePolicy(_messages.Message):
  r"""Maintenance policy for a service instance.

  Fields:
    maintenanceWindow: Optional. The maintenance window for the service
      instance.
  """

  maintenanceWindow = _messages.MessageField('MaintenanceWindow', 1)


class MaintenanceWindow(_messages.Message):
  r"""Maintenance window for a service instance.

  Enums:
    DayOfWeekValueValuesEnum: Optional. The day of the week when maintenance
      is scheduled.

  Fields:
    dayOfWeek: Optional. The day of the week when maintenance is scheduled.
    duration: Required. Duration of the time window, set by service producer.
    startTime: Optional. Time within the window to start the operations.
  """

  class DayOfWeekValueValuesEnum(_messages.Enum):
    r"""Optional. The day of the week when maintenance is scheduled.

    Values:
      DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
      MONDAY: Monday
      TUESDAY: Tuesday
      WEDNESDAY: Wednesday
      THURSDAY: Thursday
      FRIDAY: Friday
      SATURDAY: Saturday
      SUNDAY: Sunday
    """
    DAY_OF_WEEK_UNSPECIFIED = 0
    MONDAY = 1
    TUESDAY = 2
    WEDNESDAY = 3
    THURSDAY = 4
    FRIDAY = 5
    SATURDAY = 6
    SUNDAY = 7

  dayOfWeek = _messages.EnumField('DayOfWeekValueValuesEnum', 1)
  duration = _messages.StringField(2)
  startTime = _messages.MessageField('TimeOfDay', 3)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal, successful response of the operation. If the original
    method returns no data on success, such as `Delete`, the response is
    `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have been
      cancelled successfully have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  statusMessage = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class PySparkApplicationConfig(_messages.Message):
  r"""Represents the PySparkApplicationConfig.

  Fields:
    archiveUris: Optional. HCFS URIs of archives to be extracted into the
      working directory of each executor. Supported file types: .jar, .tar,
      .tar.gz, .tgz, and .zip.
    args: Optional. The arguments to pass to the driver. Do not include
      arguments, such as `--conf`, that can be set as job properties, since a
      collision may occur that causes an incorrect job submission.
    fileUris: Optional. HCFS URIs of files to be placed in the working
      directory of each executor. Useful for naively parallel tasks.
    jarFileUris: Optional. HCFS URIs of jar files to add to the CLASSPATHs of
      the Python driver and tasks.
    mainPythonFileUri: Required. The HCFS URI of the main Python file to use
      as the driver. Must be a .py file.
    pythonFileUris: Optional. HCFS file URIs of Python files to pass to the
      PySpark framework. Supported file types: .py, .egg, and .zip.
  """

  archiveUris = _messages.StringField(1, repeated=True)
  args = _messages.StringField(2, repeated=True)
  fileUris = _messages.StringField(3, repeated=True)
  jarFileUris = _messages.StringField(4, repeated=True)
  mainPythonFileUri = _messages.StringField(5)
  pythonFileUris = _messages.StringField(6, repeated=True)


class QueryList(_messages.Message):
  r"""Represents a list of queries.

  Fields:
    queries: Required. The queries to run.
  """

  queries = _messages.StringField(1, repeated=True)


class ServiceInstance(_messages.Message):
  r"""Message describing ServiceInstance object TODO(user) add appropriate
  visibility tags to the fields of this proto.

  Enums:
    RequestedStateValueValuesEnum: Output only. The intended state to which
      the service instance is reconciling.
    StateValueValuesEnum: Output only. The current state.

  Messages:
    AnnotationsValue: Optional. The annotations to associate with this service
      instance. Annotations may be used to store client information, but are
      not used by the server.
    LabelsValue: Optional. The labels to associate with this service instance.
      Labels may be used for filtering and billing tracking.

  Fields:
    annotations: Optional. The annotations to associate with this service
      instance. Annotations may be used to store client information, but are
      not used by the server.
    auxiliaryServicesConfig: Optional. Configuration of auxiliary services
      used by this instance.
    createTime: Output only. The timestamp when the resource was created.
    displayName: Optional. User-provided human-readable name to be used in
      user interfaces.
    effectiveServiceAccount: Output only. Effective service account associated
      with ServiceInstance. This will be the service_account if specified.
      Otherwise, it will be an automatically created per-resource P4SA that
      also automatically has Fleet Workload Identity bindings applied.
    gdceCluster: Optional. A GDCE cluster.
    labels: Optional. The labels to associate with this service instance.
      Labels may be used for filtering and billing tracking.
    maintenancePolicy: Optional. Maintenance policy for this service instance.
    name: Identifier. The name of the service instance.
    reconciling: Output only. Whether the service instance is currently
      reconciling. True if the current state of the resource does not match
      the intended state, and the system is working to reconcile them, whether
      or not the change was user initiated. Required by
      aip.dev/128#reconciliation
    requestedState: Output only. The intended state to which the service
      instance is reconciling.
    serviceAccount: Optional. Requested service account to associate with
      ServiceInstance.
    sparkServiceInstanceConfig: Optional. Spark-specific service instance
      configuration.
    state: Output only. The current state.
    stateMessage: Output only. A message explaining the current state.
    uid: Output only. System generated unique identifier for this service
      instance, formatted as UUID4.
    updateTime: Output only. The timestamp when the resource was most recently
      updated.
  """

  class RequestedStateValueValuesEnum(_messages.Enum):
    r"""Output only. The intended state to which the service instance is
    reconciling.

    Values:
      STATE_UNSPECIFIED: The service instance state is unknown.
      CREATING: The service instance is being created and is not yet ready to
        accept requests.
      ACTIVE: The service instance is running.
      DISCONNECTED: The service instance is running but disconnected from the
        Google network
      DELETING: The service instance is being deleted.
      STOPPING: The service instance is being stopped. Not in scope for
        private GA
      STOPPED: The service instance is stopped. Not in scope for private GA
      STARTING: The service instance is being started from being STOPPED. Not
        in scope for private GA
      UPDATING: The service instance is being updated
      FAILED: The service instance has encountered an unrecoverable error.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    ACTIVE = 2
    DISCONNECTED = 3
    DELETING = 4
    STOPPING = 5
    STOPPED = 6
    STARTING = 7
    UPDATING = 8
    FAILED = 9

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state.

    Values:
      STATE_UNSPECIFIED: The service instance state is unknown.
      CREATING: The service instance is being created and is not yet ready to
        accept requests.
      ACTIVE: The service instance is running.
      DISCONNECTED: The service instance is running but disconnected from the
        Google network
      DELETING: The service instance is being deleted.
      STOPPING: The service instance is being stopped. Not in scope for
        private GA
      STOPPED: The service instance is stopped. Not in scope for private GA
      STARTING: The service instance is being started from being STOPPED. Not
        in scope for private GA
      UPDATING: The service instance is being updated
      FAILED: The service instance has encountered an unrecoverable error.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    ACTIVE = 2
    DISCONNECTED = 3
    DELETING = 4
    STOPPING = 5
    STOPPED = 6
    STARTING = 7
    UPDATING = 8
    FAILED = 9

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""Optional. The annotations to associate with this service instance.
    Annotations may be used to store client information, but are not used by
    the server.

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. The labels to associate with this service instance. Labels
    may be used for filtering and billing tracking.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotations = _messages.MessageField('AnnotationsValue', 1)
  auxiliaryServicesConfig = _messages.MessageField('AuxiliaryServicesConfig', 2)
  createTime = _messages.StringField(3)
  displayName = _messages.StringField(4)
  effectiveServiceAccount = _messages.StringField(5)
  gdceCluster = _messages.MessageField('GdceCluster', 6)
  labels = _messages.MessageField('LabelsValue', 7)
  maintenancePolicy = _messages.MessageField('MaintenancePolicy', 8)
  name = _messages.StringField(9)
  reconciling = _messages.BooleanField(10)
  requestedState = _messages.EnumField('RequestedStateValueValuesEnum', 11)
  serviceAccount = _messages.StringField(12)
  sparkServiceInstanceConfig = _messages.MessageField('SparkServiceInstanceConfig', 13)
  state = _messages.EnumField('StateValueValuesEnum', 14)
  stateMessage = _messages.StringField(15)
  uid = _messages.StringField(16)
  updateTime = _messages.StringField(17)


class SparkApplication(_messages.Message):
  r"""Represents the SparkApplication resource.

  Enums:
    RequestedStateValueValuesEnum: Optional. The intended state to which the
      application is reconciling.
    StateValueValuesEnum: Output only. The current state.

  Messages:
    AnnotationsValue: Optional. The annotations to associate with this
      application. Annotations may be used to store client information, but
      are not used by the server.
    LabelsValue: Optional. The labels to associate with this application.
      Labels may be used for filtering and billing tracking.
    PropertiesValue: Optional. application-specific properties.

  Fields:
    annotations: Optional. The annotations to associate with this application.
      Annotations may be used to store client information, but are not used by
      the server.
    applicationEnvironment: Optional. An ApplicationEnvironment from which to
      inherit configuration properties.
    createTime: Output only. The timestamp when the resource was created.
    dependencyImages: Optional. List of container image uris for additional
      file dependencies. Dependent files are sequentially copied from each
      image. If a file with the same name exists in 2 images then the file
      from later image is used.
    displayName: Optional. User-provided human-readable name to be used in
      user interfaces.
    labels: Optional. The labels to associate with this application. Labels
      may be used for filtering and billing tracking.
    monitoringEndpoint: Output only. URL for a monitoring UI for this
      application (for eventual Spark PHS/UI support) Out of scope for private
      GA
    name: Identifier. Fields 1-6 should exist for all declarative friendly
      resources per aip.dev/148 The name of the application. Format: projects/
      {project}/locations/{location}/serviceInstances/{service_instance}/spark
      Applications/{application}
    namespace: Optional. The Kubernetes namespace in which to create the
      application. This namespace must already exist on the cluster.
    outputUri: Output only. An HCFS URI pointing to the location of stdout and
      stdout of the application Mainly useful for Pantheon and gcloud Not in
      scope for private GA
    properties: Optional. application-specific properties.
    pysparkApplicationConfig: PySpark application config.
    reconciling: Output only. Whether the application is currently
      reconciling. True if the current state of the resource does not match
      the intended state, and the system is working to reconcile them, whether
      or not the change was user initiated. Required by
      aip.dev/128#reconciliation
    requestedState: Optional. The intended state to which the application is
      reconciling.
    sparkApplicationConfig: Spark application config.
    sparkRApplicationConfig: SparkR application config.
    sparkSqlApplicationConfig: SparkSql application config.
    state: Output only. The current state.
    stateMessage: Output only. A message explaining the current state.
    uid: Output only. System generated unique identifier for this application,
      formatted as UUID4.
    updateTime: Output only. The timestamp when the resource was most recently
      updated.
    version: Optional. The Dataproc version of this application.
  """

  class RequestedStateValueValuesEnum(_messages.Enum):
    r"""Optional. The intended state to which the application is reconciling.

    Values:
      STATE_UNSPECIFIED: The application state is unknown.
      PENDING: The application is setting up and has not yet begun to execute
      RUNNING: The application is running.
      CANCELLING: The application is being cancelled.
      CANCELLED: The application was successfully cancelled
      SUCCEEDED: The application completed successfully.
      FAILED: The application exited with an error.
    """
    STATE_UNSPECIFIED = 0
    PENDING = 1
    RUNNING = 2
    CANCELLING = 3
    CANCELLED = 4
    SUCCEEDED = 5
    FAILED = 6

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state.

    Values:
      STATE_UNSPECIFIED: The application state is unknown.
      PENDING: The application is setting up and has not yet begun to execute
      RUNNING: The application is running.
      CANCELLING: The application is being cancelled.
      CANCELLED: The application was successfully cancelled
      SUCCEEDED: The application completed successfully.
      FAILED: The application exited with an error.
    """
    STATE_UNSPECIFIED = 0
    PENDING = 1
    RUNNING = 2
    CANCELLING = 3
    CANCELLED = 4
    SUCCEEDED = 5
    FAILED = 6

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""Optional. The annotations to associate with this application.
    Annotations may be used to store client information, but are not used by
    the server.

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. The labels to associate with this application. Labels may be
    used for filtering and billing tracking.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PropertiesValue(_messages.Message):
    r"""Optional. application-specific properties.

    Messages:
      AdditionalProperty: An additional property for a PropertiesValue object.

    Fields:
      additionalProperties: Additional properties of type PropertiesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a PropertiesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotations = _messages.MessageField('AnnotationsValue', 1)
  applicationEnvironment = _messages.StringField(2)
  createTime = _messages.StringField(3)
  dependencyImages = _messages.StringField(4, repeated=True)
  displayName = _messages.StringField(5)
  labels = _messages.MessageField('LabelsValue', 6)
  monitoringEndpoint = _messages.StringField(7)
  name = _messages.StringField(8)
  namespace = _messages.StringField(9)
  outputUri = _messages.StringField(10)
  properties = _messages.MessageField('PropertiesValue', 11)
  pysparkApplicationConfig = _messages.MessageField('PySparkApplicationConfig', 12)
  reconciling = _messages.BooleanField(13)
  requestedState = _messages.EnumField('RequestedStateValueValuesEnum', 14)
  sparkApplicationConfig = _messages.MessageField('SparkApplicationConfig', 15)
  sparkRApplicationConfig = _messages.MessageField('SparkRApplicationConfig', 16)
  sparkSqlApplicationConfig = _messages.MessageField('SparkSqlApplicationConfig', 17)
  state = _messages.EnumField('StateValueValuesEnum', 18)
  stateMessage = _messages.StringField(19)
  uid = _messages.StringField(20)
  updateTime = _messages.StringField(21)
  version = _messages.StringField(22)


class SparkApplicationConfig(_messages.Message):
  r"""Represents the SparkApplicationConfig.

  Fields:
    archiveUris: Optional. HCFS URIs of archives to be extracted into the
      working directory of each executor. Supported file types: `.jar`,
      `.tar`, `.tar.gz`, `.tgz`, and `.zip`.
    args: Optional. The arguments to pass to the driver. Do not include
      arguments that can be set as application properties, such as `--conf`,
      since a collision can occur that causes an incorrect application
      submission.
    fileUris: Optional. HCFS URIs of files to be placed in the working
      directory of each executor.
    jarFileUris: Optional. HCFS URIs of jar files to add to the classpath of
      the Spark driver and tasks.
    mainClass: The name of the driver main class. The jar file that contains
      the class must be in the classpath or specified in `jar_file_uris`.
    mainJarFileUri: The HCFS URI of the jar file that contains the main class.
  """

  archiveUris = _messages.StringField(1, repeated=True)
  args = _messages.StringField(2, repeated=True)
  fileUris = _messages.StringField(3, repeated=True)
  jarFileUris = _messages.StringField(4, repeated=True)
  mainClass = _messages.StringField(5)
  mainJarFileUri = _messages.StringField(6)


class SparkApplicationEnvironmentConfig(_messages.Message):
  r"""Represents the SparkApplicationEnvironmentConfig.

  Messages:
    DefaultPropertiesValue: Optional. A map of default Spark properties to
      apply to workloads in this application environment. These defaults may
      be overridden by per-application properties.

  Fields:
    defaultProperties: Optional. A map of default Spark properties to apply to
      workloads in this application environment. These defaults may be
      overridden by per-application properties.
    defaultVersion: Optional. The default Dataproc version to use for
      applications submitted to this application environment
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DefaultPropertiesValue(_messages.Message):
    r"""Optional. A map of default Spark properties to apply to workloads in
    this application environment. These defaults may be overridden by per-
    application properties.

    Messages:
      AdditionalProperty: An additional property for a DefaultPropertiesValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        DefaultPropertiesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DefaultPropertiesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  defaultProperties = _messages.MessageField('DefaultPropertiesValue', 1)
  defaultVersion = _messages.StringField(2)


class SparkApplicationOperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have been
      cancelled successfully have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  statusMessage = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class SparkHistoryServer(_messages.Message):
  r"""Spark History Server.

  Fields:
    sparkHistoryServerConfig: Optional. Spark History Server configurations
      for a given version.
  """

  sparkHistoryServerConfig = _messages.MessageField('SparkHistoryServerConfig', 1)


class SparkHistoryServerConfig(_messages.Message):
  r"""Spark History Server Config.

  Messages:
    ConfigurationsValue: Optional. Mapping of configurations.

  Fields:
    configurations: Optional. Mapping of configurations.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ConfigurationsValue(_messages.Message):
    r"""Optional. Mapping of configurations.

    Messages:
      AdditionalProperty: An additional property for a ConfigurationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type ConfigurationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ConfigurationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  configurations = _messages.MessageField('ConfigurationsValue', 1)


class SparkRApplicationConfig(_messages.Message):
  r"""Represents the SparkRApplicationConfig.

  Fields:
    archiveUris: Optional. HCFS URIs of archives to be extracted into the
      working directory of each executor. Supported file types: .jar, .tar,
      .tar.gz, .tgz, and .zip.
    args: Optional. The arguments to pass to the driver. Do not include
      arguments, such as `--conf`, that can be set as job properties, since a
      collision may occur that causes an incorrect job submission.
    fileUris: Optional. HCFS URIs of files to be placed in the working
      directory of each executor. Useful for naively parallel tasks.
    mainRFileUri: Required. The HCFS URI of the main R file to use as the
      driver. Must be a .R file.
  """

  archiveUris = _messages.StringField(1, repeated=True)
  args = _messages.StringField(2, repeated=True)
  fileUris = _messages.StringField(3, repeated=True)
  mainRFileUri = _messages.StringField(4)


class SparkServiceInstanceConfig(_messages.Message):
  r"""Spark-specific service instance configuration."""


class SparkSqlApplicationConfig(_messages.Message):
  r"""Represents the SparkRApplicationConfig.

  Messages:
    ScriptVariablesValue: Optional. Mapping of query variable names to values
      (equivalent to the Spark SQL command: SET `name="value";`).

  Fields:
    jarFileUris: Optional. HCFS URIs of jar files to be added to the Spark
      CLASSPATH.
    queryFileUri: The HCFS URI of the script that contains SQL queries.
    queryList: A list of queries.
    scriptVariables: Optional. Mapping of query variable names to values
      (equivalent to the Spark SQL command: SET `name="value";`).
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ScriptVariablesValue(_messages.Message):
    r"""Optional. Mapping of query variable names to values (equivalent to the
    Spark SQL command: SET `name="value";`).

    Messages:
      AdditionalProperty: An additional property for a ScriptVariablesValue
        object.

    Fields:
      additionalProperties: Additional properties of type ScriptVariablesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ScriptVariablesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  jarFileUris = _messages.StringField(1, repeated=True)
  queryFileUri = _messages.StringField(2)
  queryList = _messages.MessageField('QueryList', 3)
  scriptVariables = _messages.MessageField('ScriptVariablesValue', 4)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class TimeOfDay(_messages.Message):
  r"""Represents a time of day. The date and time zone are either not
  significant or are specified elsewhere. An API may choose to allow leap
  seconds. Related types are google.type.Date and `google.protobuf.Timestamp`.

  Fields:
    hours: Hours of a day in 24 hour format. Must be greater than or equal to
      0 and typically must be less than or equal to 23. An API may choose to
      allow the value "24:00:00" for scenarios like business closing time.
    minutes: Minutes of an hour. Must be greater than or equal to 0 and less
      than or equal to 59.
    nanos: Fractions of seconds, in nanoseconds. Must be greater than or equal
      to 0 and less than or equal to 999,999,999.
    seconds: Seconds of a minute. Must be greater than or equal to 0 and
      typically must be less than or equal to 59. An API may allow the value
      60 if it allows leap-seconds.
  """

  hours = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  minutes = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  nanos = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  seconds = _messages.IntegerField(4, variant=_messages.Variant.INT32)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
