#!/usr/bin/perl
#
# ADMIN_qm_sync.pl version 2.4
#
# DESCRIPTION:
# to be run frequently to sync the vicidial_users and remote agents to the QM
# agenti_noti table
#
# This program only needs to be run by one server
#
# Copyright (C) 2011  Matt Florell <vicidial@gmail.com>    LICENSE: AGPLv2
#
# CHANGES
# 110425-0853 - First Build
#

# constants
$US='__';
$MT[0]='';

### begin parsing run-time options ###
if (length($ARGV[0])>1)
	{
	$i=0;
	while ($#ARGV >= $i)
		{
		$args = "$args $ARGV[$i]";
		$i++;
		}

	if ($args =~ /--help/i)
		{
		print "allowed run time options:\n";
		print "  [-user] = will synchronize users\n";
		print "  [-remote-agents] = will check for remote agents and sync for the number of lines defined for each\n";
		print "  [-q] = quiet, no output\n";
		print "  [-test] = test\n";
		print "  [-debug] = verbose debug messages\n";
		print "  [-debugX] = Extra-verbose debug messages\n\n";
		exit;
		}
	else
		{
		if ($args =~ /-q/i)
			{
			$Q=1; # quiet
			}
		if ($args =~ /-debug/i)
			{
			$DB=1; # Debug flag
			if ($Q < 1) {print "\n----- DEBUGGING -----\n\n";}
			}
		if ($args =~ /--debugX/i)
			{
			$DBX=1;
			if ($Q < 1) {print "\n----- SUPER-DUPER DEBUGGING -----\n\n";}
			}
		if ($args =~ /-test/i)
			{
			$TEST=1;
			$T=1;
			if ($Q < 1) {print "\n----- TEST RUN, NO UPDATES -----\n\n";}
			}
		if ($args =~ /-user/i)
			{
			$SYNC_user=1;
			if ($Q < 1) {print "\n----- USER SYNC -----\n\n";}
			}
		if ($args =~ /-remote-agents/i)
			{
			$SYNC_remoteagents=1;
			if ($Q < 1) {print "\n----- REMOTE AGENT SYNC -----\n\n";}
			}
		}
	}
else
	{
	#	print "no command line options set\n";
	}
### end parsing run-time options ###


# default path to astguiclient configuration file:
$PATHconf =		'/etc/astguiclient.conf';

open(conf, "$PATHconf") || die "can't open $PATHconf: $!\n";
@conf = <conf>;
close(conf);
$i=0;
foreach(@conf)
	{
	$line = $conf[$i];
	$line =~ s/ |>|\n|\r|\t|\#.*|;.*//gi;
	if ( ($line =~ /^PATHhome/) && ($CLIhome < 1) )
		{$PATHhome = $line;   $PATHhome =~ s/.*=//gi;}
	if ( ($line =~ /^PATHlogs/) && ($CLIlogs < 1) )
		{$PATHlogs = $line;   $PATHlogs =~ s/.*=//gi;}
	if ( ($line =~ /^PATHagi/) && ($CLIagi < 1) )
		{$PATHagi = $line;   $PATHagi =~ s/.*=//gi;}
	if ( ($line =~ /^PATHweb/) && ($CLIweb < 1) )
		{$PATHweb = $line;   $PATHweb =~ s/.*=//gi;}
	if ( ($line =~ /^PATHsounds/) && ($CLIsounds < 1) )
		{$PATHsounds = $line;   $PATHsounds =~ s/.*=//gi;}
	if ( ($line =~ /^PATHmonitor/) && ($CLImonitor < 1) )
		{$PATHmonitor = $line;   $PATHmonitor =~ s/.*=//gi;}
	if ( ($line =~ /^VARserver_ip/) && ($CLIserver_ip < 1) )
		{$VARserver_ip = $line;   $VARserver_ip =~ s/.*=//gi;}
	if ( ($line =~ /^VARDB_server/) && ($CLIDB_server < 1) )
		{$VARDB_server = $line;   $VARDB_server =~ s/.*=//gi;}
	if ( ($line =~ /^VARDB_database/) && ($CLIDB_database < 1) )
		{$VARDB_database = $line;   $VARDB_database =~ s/.*=//gi;}
	if ( ($line =~ /^VARDB_user/) && ($CLIDB_user < 1) )
		{$VARDB_user = $line;   $VARDB_user =~ s/.*=//gi;}
	if ( ($line =~ /^VARDB_pass/) && ($CLIDB_pass < 1) )
		{$VARDB_pass = $line;   $VARDB_pass =~ s/.*=//gi;}
	if ( ($line =~ /^VARDB_port/) && ($CLIDB_port < 1) )
		{$VARDB_port = $line;   $VARDB_port =~ s/.*=//gi;}
	$i++;
	}

# Customized Variables
$server_ip = $VARserver_ip;		# Asterisk server IP

if (!$CLEANLOGfile) {$CLEANLOGfile = "$PATHlogs/qmsync.$Hyear-$Hmon-$Hmday";}

if (!$VARDB_port) {$VARDB_port='3306';}

use DBI;	  

$dbhA = DBI->connect("DBI:mysql:$VARDB_database:$VARDB_server:$VARDB_port", "$VARDB_user", "$VARDB_pass")
or die "Couldn't connect to database: " . DBI->errstr;

#############################################
##### START QUEUEMETRICS LOGGING LOOKUP #####
$stmtA = "SELECT enable_queuemetrics_logging,queuemetrics_server_ip,queuemetrics_dbname,queuemetrics_login,queuemetrics_pass,queuemetrics_log_id FROM system_settings;";
$sthA = $dbhA->prepare($stmtA) or die "preparing: ",$dbhA->errstr;
$sthA->execute or die "executing: $stmtA ", $dbhA->errstr;
$sthArows=$sthA->rows;
if ($sthArows > 0)
	{
	@aryA = $sthA->fetchrow_array;
	$enable_queuemetrics_logging =	$aryA[0];
	$queuemetrics_server_ip	=	$aryA[1];
	$queuemetrics_dbname =		$aryA[2];
	$queuemetrics_login=		$aryA[3];
	$queuemetrics_pass =		$aryA[4];
	$queuemetrics_log_id =		$aryA[5];
	}
$sthA->finish();
##### END QUEUEMETRICS LOGGING LOOKUP #####
###########################################


$dbhB = DBI->connect("DBI:mysql:$queuemetrics_dbname:$queuemetrics_server_ip:3306", "$queuemetrics_login", "$queuemetrics_pass")
 or die "Couldn't connect to database: " . DBI->errstr;

if ($DBX) {print "CONNECTED TO QM DATABASE:  $queuemetrics_server_ip|$queuemetrics_dbname\n";}





##### BEGIN sync of vicidial_users to agenti_noti #####
if ($SYNC_user > 0)
	{
	if ($DBX) {print "\n\n";}
	if ($DB) {print " - starting sync of vicidial_users to agenti_noti\n";}
	$found_records=0;
	$updated_records=0;
	$added_records=0;

	### Gather distinct users in vicidial_users
	$stmtA = "SELECT user,full_name from vicidial_users limit 100000;";
	if ($DBX) {print "$stmtA\n";}
	$sthA = $dbhA->prepare($stmtA) or die "preparing: ",$dbhA->errstr;
	$sthA->execute or die "executing: $stmtA ", $dbhA->errstr;
	$sthArowsU=$sthA->rows;

	$i=0;
	while ($sthArowsU > $i)
		{
		@aryA = $sthA->fetchrow_array;	
		$Vuser[$i]	=			$aryA[0];
		$Vfullname[$i]	=		$aryA[1];
		$i++;
		}
	$sthA->finish();

	$i=0;
	while ($sthArowsU > $i)
		{
		### Find if agent record exists with user id and fullname identical
		$stmtB = "SELECT count(*) FROM agenti_noti where nome_agente='Agent/$Vuser[$i]' and descr_agente='$Vfullname[$i]';";
		$sthB = $dbhB->prepare($stmtB) or die "preparing: ",$dbhB->errstr;
		$sthB->execute or die "executing: $stmtB ", $dbhB->errstr;
		$AN_records=$sthB->rows;
		if ($AN_records > 0)
			{
			@aryB = $sthB->fetchrow_array;
			$AN_count =		$aryB[0];
			}
		$sthB->finish();

		if ($AN_count < 1)
			{
			### Find if agent record exists with user id and fullname identical
			$stmtB = "SELECT count(*) FROM agenti_noti where nome_agente='Agent/$Vuser[$i]';";
			$sthB = $dbhB->prepare($stmtB) or die "preparing: ",$dbhB->errstr;
			$sthB->execute or die "executing: $stmtB ", $dbhB->errstr;
			$ANX_records=$sthB->rows;
			if ($ANX_records > 0)
				{
				@aryB = $sthB->fetchrow_array;
				$ANX_count =		$aryB[0];
				}
			$sthB->finish();

			if ($ANX_count < 1)
				{
				### add a new agenti_noti record 
				$stmtB = "INSERT INTO agenti_noti(nome_agente,descr_agente,location,current_terminal,xmpp_address,payroll_code,sys_dt_creazione,sys_user_creazione,sys_dt_modifica,sys_user_modifica,chiave_agente) values('agent/$Vuser[$i]','$Vfullname[$i]','7','-','','',NOW(),'32',NOW(),'32','');";
				if ($TEST < 1)
					{$Baffected_rows = $dbhB->do($stmtB);}
				if ($DB) {print "     AGENT record inserted: $Baffected_rows|$stmtB|\n";}

				$event_string = "AGENT INSERT: $i|$Vuser[$i]|$Vfullname[$i]|$Baffected_rows|$stmtB";
				&event_logger;

				$added_records++;
				}
			else
				{
				### update agenti_noti record with proper name
				$stmtB = "UPDATE agenti_noti SET descr_agente='$Vfullname[$i]' where nome_agente='agent/$Vuser[$i]' LIMIT 1;";
				if ($TEST < 1)
					{$Baffected_rows = $dbhB->do($stmtB);}
				if ($DB) {print "     AGENT record updated: $Baffected_rows|$stmtB|\n";}

				$event_string = "AGENT UPDATE: $i|$Vuser[$i]|$Vfullname[$i]|$Baffected_rows|$stmtB";
				&event_logger;

				$updated_records++;
				}
			}
		
		else
			{
			if ($DB) {print "   agent exists: $Vuser[$i] - $Vfullname[$i]\n";}
			$found_records++;
			}

		$i++;
		}

	if ($DB) {print " - finished user sync:\n";}
	if ($DB) {print "     records scanned:       $i\n";}
	if ($DB) {print "     records found:      $found_records\n";}
	if ($DB) {print "     records updated:    $updated_records\n";}
	if ($DB) {print "     records added:      $added_records\n";}
	}
##### END sync of vicidial_users to agenti_noti #####







##### BEGIN sync of vicidial_remote_agents to agenti_noti #####
if ($SYNC_remoteagents > 0)
	{
	if ($DBX) {print "\n\n";}
	if ($DB) {print " - starting sync of vicidial_remote_agents to agenti_noti\n";}
	$found_records=0;
	$updated_records=0;
	$added_records=0;

	### Gather distinct remote agents in vicidial_remote_agents
	$stmtA = "SELECT user_start,number_of_lines,full_name from vicidial_remote_agents vra,vicidial_users vu where vu.user=vra.user_start and number_of_lines > 0 limit 100000;";
	if ($DBX) {print "$stmtA\n";}
	$sthA = $dbhA->prepare($stmtA) or die "preparing: ",$dbhA->errstr;
	$sthA->execute or die "executing: $stmtA ", $dbhA->errstr;
	$sthArowsU=$sthA->rows;
	$i=0;
	while ($sthArowsU > $i)
		{
		@aryA = $sthA->fetchrow_array;	
		$Vuser[$i]	=				$aryA[0];
		$Vnumber_of_lines[$i] =		$aryA[1];
		$Vfullname[$i]	=			$aryA[2];
		$i++;
		}
	$sthA->finish();

	$i=0;
	while ($sthArowsU > $i)
		{
		$ra_count=0;
		while ($ra_count < $Vnumber_of_lines[$i])
			{
			$Vuser[$i]++;

			### Find if agent record exists with user id and fullname identical
			$stmtB = "SELECT count(*) FROM agenti_noti where nome_agente='Agent/$Vuser[$i]' and descr_agente='$Vfullname[$i]';";
			$sthB = $dbhB->prepare($stmtB) or die "preparing: ",$dbhB->errstr;
			$sthB->execute or die "executing: $stmtB ", $dbhB->errstr;
			$AN_records=$sthB->rows;
			if ($AN_records > 0)
				{
				@aryB = $sthB->fetchrow_array;
				$AN_count =		$aryB[0];
				}
			$sthB->finish();

			if ($AN_count < 1)
				{
				### Find if agent record exists with user id and fullname identical
				$stmtB = "SELECT count(*) FROM agenti_noti where nome_agente='Agent/$Vuser[$i]';";
				$sthB = $dbhB->prepare($stmtB) or die "preparing: ",$dbhB->errstr;
				$sthB->execute or die "executing: $stmtB ", $dbhB->errstr;
				$ANX_records=$sthB->rows;
				if ($ANX_records > 0)
					{
					@aryB = $sthB->fetchrow_array;
					$ANX_count =		$aryB[0];
					}
				$sthB->finish();

				if ($ANX_count < 1)
					{
					### add a new agenti_noti record 
					$stmtB = "INSERT INTO agenti_noti(nome_agente,descr_agente,location,current_terminal,xmpp_address,payroll_code,sys_dt_creazione,sys_user_creazione,sys_dt_modifica,sys_user_modifica,chiave_agente) values('agent/$Vuser[$i]','$Vfullname[$i]','7','-','','',NOW(),'32',NOW(),'32','');";
					if ($TEST < 1)
						{$Baffected_rows = $dbhB->do($stmtB);}
					if ($DB) {print "     AGENT record inserted: $Baffected_rows|$ra_count|$stmtB|\n";}

					$event_string = "AGENT INSERT: $i|$ra_count|$Vuser[$i]|$Vfullname[$i]|$Baffected_rows|$stmtB";
					&event_logger;

					$added_records++;
					}
				else
					{
					### update agenti_noti record with proper name
					$stmtB = "UPDATE agenti_noti SET descr_agente='$Vfullname[$i]' where nome_agente='agent/$Vuser[$i]' LIMIT 1;";
					if ($TEST < 1)
						{$Baffected_rows = $dbhB->do($stmtB);}
					if ($DB) {print "     AGENT record updated: $Baffected_rows|$ra_count|$stmtB|\n";}

					$event_string = "AGENT UPDATE: $i|$ra_count|$Vuser[$i]|$Vfullname[$i]|$Baffected_rows|$stmtB";
					&event_logger;

					$updated_records++;
					}
				}
			
			else
				{
				if ($DB) {print "   agent exists: $Vuser[$i] - $Vfullname[$i]\n";}
				$found_records++;
				}
			$ra_count++;
			}
		$i++;
		}

	if ($DB) {print " - finished remote agent sync:\n";}
	if ($DB) {print "     records scanned:       $i\n";}
	if ($DB) {print "     records found:      $found_records\n";}
	if ($DB) {print "     records updated:    $updated_records\n";}
	if ($DB) {print "     records added:      $added_records\n";}
	}
##### END sync of vicidial_remote_agents to agenti_noti #####










if ($DB) {print STDERR "\nDONE\n";}

$dbhB->disconnect();

exit;






sub event_logger
	{
	### open the log file for writing ###
	open(Lout, ">>$CLEANLOGfile")
			|| die "Can't open $CLEANLOGfile: $!\n";
	print Lout "$HDSQLdate|$event_string|\n";
	close(Lout);
	$event_string='';
	}
