untrusted comment: verify with openbsd-77-base.pub
RWSbCCUoGpcxVWxuK66uaMEsfxFa/ewkne5yMr36m3r6YFcsH+IoJ6X65CLn7nmv9s51mPKILhFjRi/tO1nTa2CqNMwrZdUd3g4=

OpenBSD 7.7 errata 004, June 17, 2025:

When using syncookies in pf(4), new TCP connections could run into
timeout due to integer underflow.

Apply by doing:
    signify -Vep /etc/signify/openbsd-77-base.pub -x 004_pfsyncook.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/net/pf.c
===================================================================
RCS file: /cvs/src/sys/net/pf.c,v
diff -u -p -r1.1208 pf.c
--- sys/net/pf.c	4 Mar 2025 11:52:44 -0000	1.1208
+++ sys/net/pf.c	3 Jun 2025 13:56:06 -0000
@@ -382,7 +382,7 @@ pf_set_protostate(struct pf_state *st, i
 	    !(TCPS_HAVEESTABLISHED(st->src.state) ||
 	    st->src.state == TCPS_CLOSED) &&
 	    (TCPS_HAVEESTABLISHED(newstate) || newstate == TCPS_CLOSED))
-		pf_status.states_halfopen--;
+		atomic_dec_int(&pf_status.states_halfopen);
 
 	st->src.state = newstate;
 }
@@ -4678,7 +4678,7 @@ pf_create_state(struct pf_pdesc *pd, str
 		pf_set_protostate(st, PF_PEER_SRC, TCPS_SYN_SENT);
 		pf_set_protostate(st, PF_PEER_DST, TCPS_CLOSED);
 		st->timeout = PFTM_TCP_FIRST_PACKET;
-		pf_status.states_halfopen++;
+		atomic_inc_int(&pf_status.states_halfopen);
 		break;
 	case IPPROTO_UDP:
 		pf_set_protostate(st, PF_PEER_SRC, PFUDPS_SINGLE);
