%% Generated by the Erlang ASN.1 BER compiler. Version: 5.4.1
%% Purpose: Encoding and decoding of the types in Safecurves-pkix-18.

-module('Safecurves-pkix-18').
-moduledoc false.
-compile(nowarn_unused_vars).
-dialyzer(no_improper_lists).
-dialyzer(no_match).
-include("Safecurves-pkix-18.hrl").
-asn1_info([{vsn,'5.4.1'},
            {module,'Safecurves-pkix-18'},
            {options,[{i,"/buildroot/otp/lib/public_key/asn1/../src"},
 warnings,ber,errors,
 {cwd,"/buildroot/otp/lib/public_key/asn1"},
 {outdir,"/buildroot/otp/lib/public_key/asn1/../src"},
 der,noobj,asn1config,
 {i,"."},
 {i,"/buildroot/otp/lib/public_key/asn1"}]}]).

-export([encoding_rule/0,maps/0,bit_string_format/0,
         legacy_erlang_types/0]).
-export(['dialyzer-suppressions'/1]).
-export([
enc_CurvePrivateKey/2,
'enc_kaa-X25519_AlgorithmIdentifier'/2,
'enc_kaa-X448_AlgorithmIdentifier'/2
]).

-export([
dec_CurvePrivateKey/2,
'dec_kaa-X25519_AlgorithmIdentifier'/2,
'dec_kaa-X448_AlgorithmIdentifier'/2
]).

-export([
'enc_sa-Ed25519'/3,
'enc_pk-Ed25519'/3,
'enc_kaa-X25519'/3,
'enc_pk-X25519'/3,
'enc_kaa-X448'/3,
'enc_pk-X448'/3,
'enc_kaa-X448_smimeCaps'/3,
'enc_kaa-X25519_smimeCaps'/3,
'enc_sa-Ed25519_smimeCaps'/3
]).

-export([
'dec_sa-Ed25519'/3,
'dec_pk-Ed25519'/3,
'dec_kaa-X25519'/3,
'dec_pk-X25519'/3,
'dec_kaa-X448'/3,
'dec_pk-X448'/3,
'dec_kaa-X448_smimeCaps'/3,
'dec_kaa-X25519_smimeCaps'/3,
'dec_sa-Ed25519_smimeCaps'/3
]).

-export([
getenc_KeyWrapAlgorithms/1,
getenc_internal_object_set_argument_4/1,
getenc_internal_object_set_argument_2/1
]).

-export([
getdec_KeyWrapAlgorithms/1,
getdec_internal_object_set_argument_4/1,
getdec_internal_object_set_argument_2/1
]).

-export([
'id-edwards-curve-algs'/0,
'id-X25519'/0,
'id-X448'/0,
'id-Ed25519'/0,
'id-Ed448'/0
]).

-export([info/0]).

-export([encode/2,decode/2]).

encoding_rule() -> ber.

maps() -> false.

bit_string_format() -> bitstring.

legacy_erlang_types() -> false.

encode(Type, Data) ->
try iolist_to_binary(element(1, encode_disp(Type, Data))) of
  Bytes ->
    {ok,Bytes}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.


decode(Type, Data) ->
try
   Result = decode_disp(Type, element(1, ber_decode_nif(Data))),
   {ok,Result}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.

encode_disp('CurvePrivateKey', Data) -> enc_CurvePrivateKey(Data);
encode_disp('kaa-X25519_AlgorithmIdentifier', Data) -> 'enc_kaa-X25519_AlgorithmIdentifier'(Data);
encode_disp('kaa-X448_AlgorithmIdentifier', Data) -> 'enc_kaa-X448_AlgorithmIdentifier'(Data);
encode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

decode_disp('CurvePrivateKey', Data) -> dec_CurvePrivateKey(Data);
decode_disp('kaa-X25519_AlgorithmIdentifier', Data) -> 'dec_kaa-X25519_AlgorithmIdentifier'(Data);
decode_disp('kaa-X448_AlgorithmIdentifier', Data) -> 'dec_kaa-X448_AlgorithmIdentifier'(Data);
decode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

info() ->
   case ?MODULE:module_info(attributes) of
     Attributes when is_list(Attributes) ->
       case lists:keyfind(asn1_info, 1, Attributes) of
         {_,Info} when is_list(Info) ->
           Info;
         _ ->
           []
       end;
     _ ->
       []
   end.


%%================================
%%  CurvePrivateKey
%%================================
enc_CurvePrivateKey(Val) ->
    enc_CurvePrivateKey(Val, [<<4>>]).

enc_CurvePrivateKey(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_CurvePrivateKey(Tlv) ->
   dec_CurvePrivateKey(Tlv, [4]).

dec_CurvePrivateKey(Tlv, TagIn) ->
decode_octet_string(Tlv, TagIn).



%%================================
%%  kaa-X25519_AlgorithmIdentifier
%%================================
'enc_kaa-X25519_AlgorithmIdentifier'(Val) ->
    'enc_kaa-X25519_AlgorithmIdentifier'(Val, [<<48>>]).

'enc_kaa-X25519_AlgorithmIdentifier'(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'Safecurves-pkix-18':'getenc_internal_object_set_argument_2'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_kaa-X25519_AlgorithmIdentifier'(Tlv) ->
   'dec_kaa-X25519_AlgorithmIdentifier'(Tlv, [16]).

'dec_kaa-X25519_AlgorithmIdentifier'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'Safecurves-pkix-18':'getdec_internal_object_set_argument_2'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'kaa-X25519_AlgorithmIdentifier',Term1,Term2},
Res1.


%%================================
%%  kaa-X448_AlgorithmIdentifier
%%================================
'enc_kaa-X448_AlgorithmIdentifier'(Val) ->
    'enc_kaa-X448_AlgorithmIdentifier'(Val, [<<48>>]).

'enc_kaa-X448_AlgorithmIdentifier'(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'Safecurves-pkix-18':'getenc_internal_object_set_argument_4'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_kaa-X448_AlgorithmIdentifier'(Tlv) ->
   'dec_kaa-X448_AlgorithmIdentifier'(Tlv, [16]).

'dec_kaa-X448_AlgorithmIdentifier'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'Safecurves-pkix-18':'getdec_internal_object_set_argument_4'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'kaa-X448_AlgorithmIdentifier',Term1,Term2},
Res1.
'id-edwards-curve-algs'() ->
{1,3,101}.

'id-X25519'() ->
{1,3,101,110}.

'id-X448'() ->
{1,3,101,111}.

'id-Ed25519'() ->
{1,3,101,112}.

'id-Ed448'() ->
{1,3,101,113}.




%%================================
%%  sa-Ed25519
%%================================
'enc_sa-Ed25519'('Value', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_sa-Ed25519'('Params', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_sa-Ed25519'(smimeCaps,  Val, [H|T]) ->
   'enc_sa-Ed25519_smimeCaps'(H, Val, T).


'dec_sa-Ed25519'('Value',  Bytes,_) ->
   Bytes;
'dec_sa-Ed25519'('Params',  Bytes,_) ->
   Bytes;
'dec_sa-Ed25519'(smimeCaps, Bytes,[H|T]) ->
   'dec_sa-Ed25519_smimeCaps'(H, Bytes, T).




%%================================
%%  pk-Ed25519
%%================================
'enc_pk-Ed25519'('KeyValue', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_pk-Ed25519'('Params', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_pk-Ed25519'('PrivateKey', Val, _RestPrimFieldName) ->
   enc_CurvePrivateKey(Val, [<<4>>]).


'dec_pk-Ed25519'('KeyValue',  Bytes,_) ->
   Bytes;
'dec_pk-Ed25519'('Params',  Bytes,_) ->
   Bytes;
'dec_pk-Ed25519'('PrivateKey', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_CurvePrivateKey(Tlv, [4]).

tlv_format(Bytes) when is_binary(Bytes) ->
  {Tlv,_} = ber_decode_nif(Bytes),
  Tlv;
tlv_format(Bytes) ->
  Bytes.



%%================================
%%  kaa-X25519
%%================================
'enc_kaa-X25519'('Params', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_kaa-X25519'('Ukm', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_kaa-X25519'(smimeCaps,  Val, [H|T]) ->
   'enc_kaa-X25519_smimeCaps'(H, Val, T).


'dec_kaa-X25519'('Params',  Bytes,_) ->
   Bytes;
'dec_kaa-X25519'('Ukm',  Bytes,_) ->
   Bytes;
'dec_kaa-X25519'(smimeCaps, Bytes,[H|T]) ->
   'dec_kaa-X25519_smimeCaps'(H, Bytes, T).




%%================================
%%  pk-X25519
%%================================
'enc_pk-X25519'('KeyValue', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_pk-X25519'('Params', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_pk-X25519'('PrivateKey', Val, _RestPrimFieldName) ->
   enc_CurvePrivateKey(Val, [<<4>>]).


'dec_pk-X25519'('KeyValue',  Bytes,_) ->
   Bytes;
'dec_pk-X25519'('Params',  Bytes,_) ->
   Bytes;
'dec_pk-X25519'('PrivateKey', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_CurvePrivateKey(Tlv, [4]).




%%================================
%%  kaa-X448
%%================================
'enc_kaa-X448'('Params', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_kaa-X448'('Ukm', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_kaa-X448'(smimeCaps,  Val, [H|T]) ->
   'enc_kaa-X448_smimeCaps'(H, Val, T).


'dec_kaa-X448'('Params',  Bytes,_) ->
   Bytes;
'dec_kaa-X448'('Ukm',  Bytes,_) ->
   Bytes;
'dec_kaa-X448'(smimeCaps, Bytes,[H|T]) ->
   'dec_kaa-X448_smimeCaps'(H, Bytes, T).




%%================================
%%  pk-X448
%%================================
'enc_pk-X448'('KeyValue', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_pk-X448'('Params', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_pk-X448'('PrivateKey', Val, _RestPrimFieldName) ->
   enc_CurvePrivateKey(Val, [<<4>>]).


'dec_pk-X448'('KeyValue',  Bytes,_) ->
   Bytes;
'dec_pk-X448'('Params',  Bytes,_) ->
   Bytes;
'dec_pk-X448'('PrivateKey', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_CurvePrivateKey(Tlv, [4]).




%%================================
%%  kaa-X448_smimeCaps
%%================================
'enc_kaa-X448_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   'enc_kaa-X448_AlgorithmIdentifier'(Val,[<<48>>]).


'dec_kaa-X448_smimeCaps'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_kaa-X448_AlgorithmIdentifier'(Tlv,[16]).




%%================================
%%  kaa-X25519_smimeCaps
%%================================
'enc_kaa-X25519_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   'enc_kaa-X25519_AlgorithmIdentifier'(Val,[<<48>>]).


'dec_kaa-X25519_smimeCaps'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_kaa-X25519_AlgorithmIdentifier'(Tlv,[16]).




%%================================
%%  sa-Ed25519_smimeCaps
%%================================
'enc_sa-Ed25519_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_sa-Ed25519_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  KeyWrapAlgorithms
%%================================
getenc_KeyWrapAlgorithms(Id) when Id =:= {2,16,840,1,101,3,4,1,5} ->
   fun(T,V,O) -> 'CMSAesRsaesOaep-2009':'enc_kwa-aes128-wrap'(T,V,O) end;
getenc_KeyWrapAlgorithms(Id) when Id =:= {2,16,840,1,101,3,4,1,45} ->
   fun(T,V,O) -> 'CMSAesRsaesOaep-2009':'enc_kwa-aes256-wrap'(T,V,O) end;
getenc_KeyWrapAlgorithms(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_KeyWrapAlgorithms(Id) when Id =:= {2,16,840,1,101,3,4,1,5} ->
   fun(T,V,O) -> 'CMSAesRsaesOaep-2009':'dec_kwa-aes128-wrap'(T,V,O) end;
getdec_KeyWrapAlgorithms(Id) when Id =:= {2,16,840,1,101,3,4,1,45} ->
   fun(T,V,O) -> 'CMSAesRsaesOaep-2009':'dec_kwa-aes256-wrap'(T,V,O) end;
getdec_KeyWrapAlgorithms(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_4
%%================================
getenc_internal_object_set_argument_4(Id) when Id =:= {2,16,840,1,101,3,4,1,5} ->
   fun(T,V,O) -> 'CMSAesRsaesOaep-2009':'enc_kwa-aes128-wrap'(T,V,O) end;
getenc_internal_object_set_argument_4(Id) when Id =:= {2,16,840,1,101,3,4,1,45} ->
   fun(T,V,O) -> 'CMSAesRsaesOaep-2009':'enc_kwa-aes256-wrap'(T,V,O) end;
getenc_internal_object_set_argument_4(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_4(Id) when Id =:= {2,16,840,1,101,3,4,1,5} ->
   fun(T,V,O) -> 'CMSAesRsaesOaep-2009':'dec_kwa-aes128-wrap'(T,V,O) end;
getdec_internal_object_set_argument_4(Id) when Id =:= {2,16,840,1,101,3,4,1,45} ->
   fun(T,V,O) -> 'CMSAesRsaesOaep-2009':'dec_kwa-aes256-wrap'(T,V,O) end;
getdec_internal_object_set_argument_4(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_2
%%================================
getenc_internal_object_set_argument_2(Id) when Id =:= {2,16,840,1,101,3,4,1,5} ->
   fun(T,V,O) -> 'CMSAesRsaesOaep-2009':'enc_kwa-aes128-wrap'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {2,16,840,1,101,3,4,1,45} ->
   fun(T,V,O) -> 'CMSAesRsaesOaep-2009':'enc_kwa-aes256-wrap'(T,V,O) end;
getenc_internal_object_set_argument_2(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_2(Id) when Id =:= {2,16,840,1,101,3,4,1,5} ->
   fun(T,V,O) -> 'CMSAesRsaesOaep-2009':'dec_kwa-aes128-wrap'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {2,16,840,1,101,3,4,1,45} ->
   fun(T,V,O) -> 'CMSAesRsaesOaep-2009':'dec_kwa-aes256-wrap'(T,V,O) end;
getdec_internal_object_set_argument_2(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.



%%%
%%% Run-time functions.
%%%

'dialyzer-suppressions'(Arg) ->
    ok.

ber_decode_nif(B) ->
    asn1rt_nif:decode_ber_tlv(B).

ber_encode([Tlv]) ->
    ber_encode(Tlv);
ber_encode(Tlv) when is_binary(Tlv) ->
    Tlv;
ber_encode(Tlv) ->
    asn1rt_nif:encode_ber_tlv(Tlv).

collect_parts(TlvList) ->
    collect_parts(TlvList, []).

collect_parts([{_, L} | Rest], Acc) when is_list(L) ->
    collect_parts(Rest, [collect_parts(L) | Acc]);
collect_parts([{3, <<Unused,Bits/binary>>} | Rest], _Acc) ->
    collect_parts_bit(Rest, [Bits], Unused);
collect_parts([{_T, V} | Rest], Acc) ->
    collect_parts(Rest, [V | Acc]);
collect_parts([], Acc) ->
    list_to_binary(lists:reverse(Acc)).

collect_parts_bit([{3, <<Unused,Bits/binary>>} | Rest], Acc, Uacc) ->
    collect_parts_bit(Rest, [Bits | Acc], Unused + Uacc);
collect_parts_bit([], Acc, Uacc) ->
    list_to_binary([Uacc | lists:reverse(Acc)]).

dec_subidentifiers(<<>>, _Av, Al) ->
    lists:reverse(Al);
dec_subidentifiers(<<1:1,H:7,T/binary>>, Av, Al) ->
    dec_subidentifiers(T, Av bsl 7 + H, Al);
dec_subidentifiers(<<H,T/binary>>, Av, Al) ->
    dec_subidentifiers(T, 0, [Av bsl 7 + H | Al]).

decode_object_identifier(Tlv, Tags) ->
    Val = match_tags(Tlv, Tags),
    [AddedObjVal | ObjVals] = dec_subidentifiers(Val, 0, []),
    {Val1, Val2} =
        if
            AddedObjVal < 40 ->
                {0, AddedObjVal};
            AddedObjVal < 80 ->
                {1, AddedObjVal - 40};
            true ->
                {2, AddedObjVal - 80}
        end,
    list_to_tuple([Val1, Val2 | ObjVals]).

decode_octet_string(Tlv, TagsIn) ->
    Bin = match_and_collect(Tlv, TagsIn),
    binary:copy(Bin).

decode_open_type(Tlv, TagIn) ->
    case match_tags(Tlv, TagIn) of
        Bin when is_binary(Bin) ->
            {InnerTlv, _} = ber_decode_nif(Bin),
            InnerTlv;
        TlvBytes ->
            TlvBytes
    end.

e_object_identifier({'OBJECT IDENTIFIER', V}) ->
    e_object_identifier(V);
e_object_identifier(V) when is_tuple(V) ->
    e_object_identifier(tuple_to_list(V));
e_object_identifier([E1, E2 | Tail]) ->
    Head = 40 * E1 + E2,
    {H, Lh} = mk_object_val(Head),
    {R, Lr} = lists:mapfoldl(fun enc_obj_id_tail/2, 0, Tail),
    {[H | R], Lh + Lr}.

enc_obj_id_tail(H, Len) ->
    {B, L} = mk_object_val(H),
    {B, Len + L}.

encode_length(L) when L =< 127 ->
    {[L], 1};
encode_length(L) ->
    Oct = minimum_octets(L),
    Len = length(Oct),
    if
        Len =< 126 ->
            {[128 bor Len | Oct], Len + 1};
        true ->
            exit({error, {asn1, too_long_length_oct, Len}})
    end.

encode_object_identifier(Val, TagIn) ->
    encode_tags(TagIn, e_object_identifier(Val)).

encode_open_type(Val, T) when is_list(Val) ->
    encode_open_type(list_to_binary(Val), T);
encode_open_type(Val, Tag) ->
    encode_tags(Tag, Val, byte_size(Val)).

encode_restricted_string(OctetList, TagIn) when is_binary(OctetList) ->
    encode_tags(TagIn, OctetList, byte_size(OctetList));
encode_restricted_string(OctetList, TagIn) when is_list(OctetList) ->
    encode_tags(TagIn, OctetList, length(OctetList)).

encode_tags(TagIn, {BytesSoFar, LenSoFar}) ->
    encode_tags(TagIn, BytesSoFar, LenSoFar).

encode_tags([Tag | Trest], BytesSoFar, LenSoFar) ->
    {Bytes2, L2} = encode_length(LenSoFar),
    encode_tags(Trest,
                [Tag, Bytes2 | BytesSoFar],
                LenSoFar + byte_size(Tag) + L2);
encode_tags([], BytesSoFar, LenSoFar) ->
    {BytesSoFar, LenSoFar}.

match_and_collect(Tlv, TagsIn) ->
    Val = match_tags(Tlv, TagsIn),
    case Val of
        [_ | _] = PartList ->
            collect_parts(PartList);
        Bin when is_binary(Bin) ->
            Bin
    end.

match_tags({T, V}, [T]) ->
    V;
match_tags({T, V}, [T | Tt]) ->
    match_tags(V, Tt);
match_tags([{T, V}], [T | Tt]) ->
    match_tags(V, Tt);
match_tags([{T, _V} | _] = Vlist, [T]) ->
    Vlist;
match_tags(Tlv, []) ->
    Tlv;
match_tags({Tag, _V} = Tlv, [T | _Tt]) ->
    exit({error, {asn1, {wrong_tag, {{expected, T}, {got, Tag, Tlv}}}}}).

minimum_octets(0, Acc) ->
    Acc;
minimum_octets(Val, Acc) ->
    minimum_octets(Val bsr 8, [Val band 255 | Acc]).

minimum_octets(Val) ->
    minimum_octets(Val, []).

mk_object_val(0, Ack, Len) ->
    {Ack, Len};
mk_object_val(Val, Ack, Len) ->
    mk_object_val(Val bsr 7, [Val band 127 bor 128 | Ack], Len + 1).

mk_object_val(Val) when Val =< 127 ->
    {[255 band Val], 1};
mk_object_val(Val) ->
    mk_object_val(Val bsr 7, [Val band 127], 1).
