/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.config;

import java.util.List;
import org.traccar.config.BooleanConfigKey;
import org.traccar.config.BooleanConfigSuffix;
import org.traccar.config.ConfigKey;
import org.traccar.config.ConfigSuffix;
import org.traccar.config.DoubleConfigKey;
import org.traccar.config.IntegerConfigKey;
import org.traccar.config.IntegerConfigSuffix;
import org.traccar.config.KeyType;
import org.traccar.config.LongConfigKey;
import org.traccar.config.LongConfigSuffix;
import org.traccar.config.PortConfigSuffix;
import org.traccar.config.StringConfigKey;
import org.traccar.config.StringConfigSuffix;

public final class Keys {
    public static final ConfigSuffix<String> PROTOCOL_ADDRESS = new StringConfigSuffix(".address", List.of(KeyType.CONFIG));
    public static final ConfigSuffix<Integer> PROTOCOL_PORT = new PortConfigSuffix(".port", List.of(KeyType.CONFIG));
    public static final ConfigSuffix<String> PROTOCOL_DEVICES = new StringConfigSuffix(".devices", List.of(KeyType.CONFIG));
    public static final ConfigSuffix<Long> PROTOCOL_INTERVAL = new LongConfigSuffix(".interval", List.of(KeyType.CONFIG));
    public static final ConfigSuffix<Boolean> PROTOCOL_SSL = new BooleanConfigSuffix(".ssl", List.of(KeyType.CONFIG));
    public static final ConfigSuffix<Integer> PROTOCOL_TIMEOUT = new IntegerConfigSuffix(".timeout", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> DEVICE_PASSWORD = new StringConfigKey("devicePassword", List.of(KeyType.DEVICE));
    public static final ConfigSuffix<String> PROTOCOL_DEVICE_PASSWORD = new StringConfigSuffix(".devicePassword", List.of(KeyType.CONFIG));
    public static final ConfigSuffix<Integer> PROTOCOL_MASK = new IntegerConfigSuffix(".mask", List.of(KeyType.CONFIG));
    public static final ConfigSuffix<Integer> PROTOCOL_MESSAGE_LENGTH = new IntegerConfigSuffix(".messageLength", List.of(KeyType.CONFIG));
    public static final ConfigSuffix<Boolean> PROTOCOL_EXTENDED = new BooleanConfigSuffix(".extended", List.of(KeyType.CONFIG));
    public static final ConfigSuffix<Boolean> PROTOCOL_UTF8 = new BooleanConfigSuffix(".utf8", List.of(KeyType.CONFIG));
    public static final ConfigSuffix<Boolean> PROTOCOL_CAN = new BooleanConfigSuffix(".can", List.of(KeyType.CONFIG));
    public static final ConfigSuffix<Boolean> PROTOCOL_ACK = new BooleanConfigSuffix(".ack", List.of(KeyType.CONFIG, KeyType.DEVICE), false);
    public static final ConfigSuffix<Boolean> PROTOCOL_IGNORE_FIX_TIME = new BooleanConfigSuffix(".ignoreFixTime", List.of(KeyType.CONFIG));
    public static final ConfigSuffix<Boolean> PROTOCOL_DECODE_LOW = new BooleanConfigSuffix(".decodeLow", List.of(KeyType.CONFIG));
    public static final ConfigSuffix<Boolean> PROTOCOL_LONG_DATE = new BooleanConfigSuffix(".longDate", List.of(KeyType.CONFIG));
    public static final ConfigSuffix<Boolean> PROTOCOL_DECIMAL_FUEL = new BooleanConfigSuffix(".decimalFuel", List.of(KeyType.CONFIG));
    public static final ConfigSuffix<Boolean> PROTOCOL_CUSTOM = new BooleanConfigSuffix(".custom", List.of(KeyType.CONFIG));
    public static final ConfigSuffix<String> PROTOCOL_FORM = new StringConfigSuffix(".form", List.of(KeyType.CONFIG));
    public static final ConfigSuffix<Integer> PROTOCOL_FRAME_MASK = new IntegerConfigSuffix(".frameMask", List.of(KeyType.CONFIG));
    public static final ConfigSuffix<String> PROTOCOL_CONFIG = new StringConfigSuffix(".config", List.of(KeyType.CONFIG));
    public static final ConfigSuffix<String> PROTOCOL_ALARM_MAP = new StringConfigSuffix(".alarmMap", List.of(KeyType.CONFIG));
    public static final ConfigSuffix<Boolean> PROTOCOL_PREFIX = new BooleanConfigSuffix(".prefix", List.of(KeyType.CONFIG));
    public static final ConfigSuffix<String> PROTOCOL_SERVER = new StringConfigSuffix(".server", List.of(KeyType.CONFIG));
    public static final ConfigKey<Integer> PROTOCOL_TYPE = new IntegerConfigKey("suntech.protocolType", List.of(KeyType.CONFIG, KeyType.DEVICE));
    public static final ConfigKey<Integer> PROTOCOL_HBM = new IntegerConfigKey("suntech.hbm", List.of(KeyType.CONFIG, KeyType.DEVICE));
    public static final ConfigSuffix<Boolean> PROTOCOL_INCLUDE_ADC = new BooleanConfigSuffix(".includeAdc", List.of(KeyType.CONFIG, KeyType.DEVICE));
    public static final ConfigSuffix<Boolean> PROTOCOL_INCLUDE_RPM = new BooleanConfigSuffix(".includeRpm", List.of(KeyType.CONFIG, KeyType.DEVICE));
    public static final ConfigSuffix<Boolean> PROTOCOL_INCLUDE_TEMPERATURE = new BooleanConfigSuffix(".includeTemp", List.of(KeyType.CONFIG, KeyType.DEVICE));
    public static final ConfigSuffix<Boolean> PROTOCOL_DISABLE_COMMANDS = new BooleanConfigSuffix(".disableCommands", List.of(KeyType.CONFIG));
    public static final ConfigSuffix<String> PROTOCOL_FORMAT = new StringConfigSuffix(".format", List.of(KeyType.CONFIG, KeyType.DEVICE));
    public static final ConfigSuffix<String> PROTOCOL_DATE_FORMAT = new StringConfigSuffix(".dateFormat", List.of(KeyType.DEVICE));
    public static final ConfigKey<String> DECODER_TIMEZONE = new StringConfigKey("decoder.timezone", List.of(KeyType.CONFIG, KeyType.DEVICE));
    public static final ConfigKey<String> ORBCOMM_ACCESS_ID = new StringConfigKey("orbcomm.accessId", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> ORBCOMM_PASSWORD = new StringConfigKey("orbcomm.password", List.of(KeyType.CONFIG));
    public static final ConfigSuffix<Boolean> PROTOCOL_ALTERNATIVE = new BooleanConfigSuffix(".alternative", List.of(KeyType.CONFIG, KeyType.DEVICE), false);
    public static final ConfigSuffix<Boolean> PROTOCOL_LANGUAGE = new BooleanConfigSuffix(".language", List.of(KeyType.CONFIG, KeyType.DEVICE), false);
    public static final ConfigKey<Long> SERVER_BUFFERING_THRESHOLD = new LongConfigKey("server.buffering.threshold", List.of(KeyType.CONFIG), 3000L);
    public static final ConfigKey<Integer> SERVER_TIMEOUT = new IntegerConfigKey("server.timeout", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> SERVER_DELAY_ACKNOWLEDGEMENT = new BooleanConfigKey("server.delayAcknowledgement", List.of(KeyType.CONFIG));
    public static final ConfigKey<Integer> SERVER_NETTY_BOSS_THREADS = new IntegerConfigKey("server.nettyBossThreads", List.of(KeyType.CONFIG), 0);
    public static final ConfigKey<Integer> SERVER_NETTY_WORKER_THREADS = new IntegerConfigKey("server.nettyThreads", List.of(KeyType.CONFIG), 0);
    public static final ConfigKey<String> SERVER_STATISTICS = new StringConfigKey("server.statistics", List.of(KeyType.CONFIG), "https://www.traccar.org/analytics/");
    public static final ConfigKey<Double> EVENT_FUEL_DROP_THRESHOLD = new DoubleConfigKey("fuelDropThreshold", List.of(KeyType.SERVER, KeyType.DEVICE), 0.0);
    public static final ConfigKey<Double> EVENT_FUEL_INCREASE_THRESHOLD = new DoubleConfigKey("fuelIncreaseThreshold", List.of(KeyType.SERVER, KeyType.DEVICE), 0.0);
    public static final ConfigKey<Double> EVENT_OVERSPEED_LIMIT = new DoubleConfigKey("speedLimit", List.of(KeyType.SERVER, KeyType.DEVICE), 0.0);
    public static final ConfigKey<Boolean> DEVICE_SHARE_DISABLE = new BooleanConfigKey("disableShare", List.of(KeyType.SERVER));
    public static final ConfigKey<Double> EVENT_OVERSPEED_THRESHOLD_MULTIPLIER = new DoubleConfigKey("event.overspeed.thresholdMultiplier", List.of(KeyType.CONFIG), 1.0);
    public static final ConfigKey<Long> EVENT_OVERSPEED_MINIMAL_DURATION = new LongConfigKey("event.overspeed.minimalDuration", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> EVENT_OVERSPEED_PREFER_LOWEST = new BooleanConfigKey("event.overspeed.preferLowest", List.of(KeyType.CONFIG));
    public static final ConfigKey<Double> EVENT_BEHAVIOR_ACCELERATION_THRESHOLD = new DoubleConfigKey("event.behavior.accelerationThreshold", List.of(KeyType.CONFIG));
    public static final ConfigKey<Double> EVENT_BEHAVIOR_BRAKING_THRESHOLD = new DoubleConfigKey("event.behavior.brakingThreshold", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> EVENT_IGNORE_DUPLICATE_ALERTS = new BooleanConfigKey("event.ignoreDuplicateAlerts", List.of(KeyType.CONFIG), true);
    public static final ConfigKey<Boolean> EVENT_MOTION_PROCESS_INVALID_POSITIONS = new BooleanConfigKey("event.motion.processInvalidPositions", List.of(KeyType.CONFIG, KeyType.DEVICE), false);
    public static final ConfigKey<Double> EVENT_MOTION_SPEED_THRESHOLD = new DoubleConfigKey("event.motion.speedThreshold", List.of(KeyType.CONFIG, KeyType.DEVICE), 0.01);
    public static final ConfigKey<Boolean> DATABASE_MEMORY = new BooleanConfigKey("database.memory", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> DATABASE_DRIVER_FILE = new StringConfigKey("database.driverFile", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> DATABASE_DRIVER = new StringConfigKey("database.driver", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> DATABASE_URL = new StringConfigKey("database.url", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> DATABASE_USER = new StringConfigKey("database.user", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> DATABASE_PASSWORD = new StringConfigKey("database.password", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> DATABASE_CHANGELOG = new StringConfigKey("database.changelog", List.of(KeyType.CONFIG), "./schema/changelog-master.xml");
    public static final ConfigKey<Integer> DATABASE_MAX_POOL_SIZE = new IntegerConfigKey("database.maxPoolSize", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> DATABASE_CHECK_CONNECTION = new StringConfigKey("database.checkConnection", List.of(KeyType.CONFIG), "SELECT 1");
    public static final ConfigKey<Boolean> DATABASE_SAVE_ORIGINAL = new BooleanConfigKey("database.saveOriginal", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> DATABASE_THROTTLE_UNKNOWN = new BooleanConfigKey("database.throttleUnknown", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> DATABASE_REGISTER_UNKNOWN = new BooleanConfigKey("database.registerUnknown", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> DATABASE_REGISTER_UNKNOWN_DEFAULT_CATEGORY = new StringConfigKey("database.registerUnknown.defaultCategory", List.of(KeyType.CONFIG));
    public static final ConfigKey<Long> DATABASE_REGISTER_UNKNOWN_DEFAULT_GROUP_ID = new LongConfigKey("database.registerUnknown.defaultGroupId", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> DATABASE_REGISTER_UNKNOWN_REGEX = new StringConfigKey("database.registerUnknown.regex", List.of(KeyType.CONFIG), "\\w{3,15}");
    public static final ConfigKey<Boolean> DATABASE_SAVE_EMPTY = new BooleanConfigKey("database.saveEmpty", List.of(KeyType.CONFIG));
    public static final ConfigKey<Integer> USERS_DEFAULT_DEVICE_LIMIT = new IntegerConfigKey("users.defaultDeviceLimit", List.of(KeyType.CONFIG), -1);
    public static final ConfigKey<Integer> USERS_DEFAULT_EXPIRATION_DAYS = new IntegerConfigKey("users.defaultExpirationDays", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> LDAP_URL = new StringConfigKey("ldap.url", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> LDAP_USER = new StringConfigKey("ldap.user", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> LDAP_PASSWORD = new StringConfigKey("ldap.password", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> LDAP_FORCE = new BooleanConfigKey("ldap.force", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> LDAP_BASE = new StringConfigKey("ldap.base", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> LDAP_ID_ATTRIBUTE = new StringConfigKey("ldap.idAttribute", List.of(KeyType.CONFIG), "uid");
    public static final ConfigKey<String> LDAP_NAME_ATTRIBUTE = new StringConfigKey("ldap.nameAttribute", List.of(KeyType.CONFIG), "cn");
    public static final ConfigKey<String> LDAP_MAIN_ATTRIBUTE = new StringConfigKey("ldap.mailAttribute", List.of(KeyType.CONFIG), "mail");
    public static final ConfigKey<String> LDAP_SEARCH_FILTER = new StringConfigKey("ldap.searchFilter", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> LDAP_ADMIN_FILTER = new StringConfigKey("ldap.adminFilter", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> LDAP_ADMIN_GROUP = new StringConfigKey("ldap.adminGroup", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> OPENID_FORCE = new BooleanConfigKey("openid.force", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> OPENID_CLIENT_ID = new StringConfigKey("openid.clientId", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> OPENID_CLIENT_SECRET = new StringConfigKey("openid.clientSecret", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> OPENID_ISSUER_URL = new StringConfigKey("openid.issuerUrl", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> OPENID_AUTH_URL = new StringConfigKey("openid.authUrl", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> OPENID_TOKEN_URL = new StringConfigKey("openid.tokenUrl", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> OPENID_USERINFO_URL = new StringConfigKey("openid.userInfoUrl", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> OPENID_GROUPS_CLAIM_NAME = new StringConfigKey("openid.groupsClaimName", List.of(KeyType.CONFIG), "groups");
    public static final ConfigKey<String> OPENID_ALLOW_GROUP = new StringConfigKey("openid.allowGroup", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> OPENID_ADMIN_GROUP = new StringConfigKey("openid.adminGroup", List.of(KeyType.CONFIG));
    public static final ConfigKey<Long> STATUS_TIMEOUT = new LongConfigKey("status.timeout", List.of(KeyType.CONFIG), 600L);
    public static final ConfigKey<String> STATUS_IGNORE_OFFLINE = new StringConfigKey("status.ignoreOffline", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> MEDIA_PATH = new StringConfigKey("media.path", List.of(KeyType.CONFIG), "./media");
    public static final ConfigKey<String> WEB_ADDRESS = new StringConfigKey("web.address", List.of(KeyType.CONFIG));
    public static final ConfigKey<Integer> WEB_PORT = new IntegerConfigKey("web.port", List.of(KeyType.CONFIG), 8082);
    public static final ConfigKey<Integer> WEB_MAX_REQUESTS_PER_SECOND = new IntegerConfigKey("web.maxRequestsPerSec", List.of(KeyType.CONFIG));
    public static final ConfigKey<Integer> WEB_MAX_REQUEST_SECONDS = new IntegerConfigKey("web.maxRequestSec", List.of(KeyType.CONFIG), 600);
    public static final ConfigKey<String> WEB_PATH = new StringConfigKey("web.path", List.of(KeyType.CONFIG), "./web");
    public static final ConfigKey<String> WEB_OVERRIDE = new StringConfigKey("web.override", List.of(KeyType.CONFIG), "./override");
    public static final ConfigKey<Long> WEB_TIMEOUT = new LongConfigKey("web.timeout", List.of(KeyType.CONFIG), 300000L);
    public static final ConfigKey<Integer> WEB_SESSION_TIMEOUT = new IntegerConfigKey("web.sessionTimeout", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> WEB_CONSOLE = new BooleanConfigKey("web.console", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> WEB_DEBUG = new BooleanConfigKey("web.debug", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> WEB_SERVICE_ACCOUNT_TOKEN = new StringConfigKey("web.serviceAccountToken", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> WEB_ORIGIN = new StringConfigKey("web.origin", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> WEB_CACHE_CONTROL = new StringConfigKey("web.cacheControl", List.of(KeyType.CONFIG), "max-age=3600,public");
    public static final ConfigKey<String> WEB_LOCALIZATION_PATH = new StringConfigKey("web.localizationPath", List.of(KeyType.CONFIG), "./templates/translations");
    public static final ConfigKey<Boolean> WEB_TOTP_ENABLE = new BooleanConfigKey("totpEnable", List.of(KeyType.SERVER));
    public static final ConfigKey<Boolean> WEB_TOTP_FORCE = new BooleanConfigKey("totpForce", List.of(KeyType.SERVER));
    public static final ConfigKey<String> SERVER_FORWARD = new StringConfigKey("server.forward", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> FORWARD_TYPE = new StringConfigKey("forward.type", List.of(KeyType.CONFIG), "url");
    public static final ConfigKey<String> FORWARD_EXCHANGE = new StringConfigKey("forward.exchange", List.of(KeyType.CONFIG), "traccar");
    public static final ConfigKey<String> FORWARD_TOPIC = new StringConfigKey("forward.topic", List.of(KeyType.CONFIG), "positions");
    public static final ConfigKey<String> FORWARD_URL = new StringConfigKey("forward.url", List.of(KeyType.CONFIG, KeyType.DEVICE));
    public static final ConfigKey<String> FORWARD_HEADER = new StringConfigKey("forward.header", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> FORWARD_RETRY_ENABLE = new BooleanConfigKey("forward.retry.enable", List.of(KeyType.CONFIG));
    public static final ConfigKey<Integer> FORWARD_RETRY_DELAY = new IntegerConfigKey("forward.retry.delay", List.of(KeyType.CONFIG), 100);
    public static final ConfigKey<Integer> FORWARD_RETRY_COUNT = new IntegerConfigKey("forward.retry.count", List.of(KeyType.CONFIG), 10);
    public static final ConfigKey<Integer> FORWARD_RETRY_LIMIT = new IntegerConfigKey("forward.retry.limit", List.of(KeyType.CONFIG), 100);
    public static final ConfigKey<String> EVENT_FORWARD_TYPE = new StringConfigKey("event.forward.type", List.of(KeyType.CONFIG), "json");
    public static final ConfigKey<String> EVENT_FORWARD_EXCHANGE = new StringConfigKey("event.forward.exchange", List.of(KeyType.CONFIG), "traccar");
    public static final ConfigKey<String> EVENT_FORWARD_TOPIC = new StringConfigKey("event.forward.topic", List.of(KeyType.CONFIG), "events");
    public static final ConfigKey<String> EVENT_FORWARD_URL = new StringConfigKey("event.forward.url", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> EVENT_FORWARD_HEADERS = new StringConfigKey("event.forward.header", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> TEMPLATES_ROOT = new StringConfigKey("templates.root", List.of(KeyType.CONFIG), "templates");
    public static final ConfigKey<Boolean> MAIL_DEBUG = new BooleanConfigKey("mail.debug", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> MAIL_SMTP_SYSTEM_ONLY = new BooleanConfigKey("mail.smtp.systemOnly", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> MAIL_SMTP_IGNORE_USER_CONFIG = new BooleanConfigKey("mail.smtp.ignoreUserConfig", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> MAIL_SMTP_HOST = new StringConfigKey("mail.smtp.host", List.of(KeyType.CONFIG, KeyType.USER));
    public static final ConfigKey<Integer> MAIL_SMTP_PORT = new IntegerConfigKey("mail.smtp.port", List.of(KeyType.CONFIG, KeyType.USER), 25);
    public static final ConfigKey<String> MAIL_TRANSPORT_PROTOCOL = new StringConfigKey("mail.transport.protocol", List.of(KeyType.CONFIG, KeyType.USER), "smtp");
    public static final ConfigKey<Boolean> MAIL_SMTP_STARTTLS_ENABLE = new BooleanConfigKey("mail.smtp.starttls.enable", List.of(KeyType.CONFIG, KeyType.USER));
    public static final ConfigKey<Boolean> MAIL_SMTP_STARTTLS_REQUIRED = new BooleanConfigKey("mail.smtp.starttls.required", List.of(KeyType.CONFIG, KeyType.USER));
    public static final ConfigKey<Boolean> MAIL_SMTP_SSL_ENABLE = new BooleanConfigKey("mail.smtp.ssl.enable", List.of(KeyType.CONFIG, KeyType.USER));
    public static final ConfigKey<String> MAIL_SMTP_SSL_TRUST = new StringConfigKey("mail.smtp.ssl.trust", List.of(KeyType.CONFIG, KeyType.USER));
    public static final ConfigKey<String> MAIL_SMTP_SSL_PROTOCOLS = new StringConfigKey("mail.smtp.ssl.protocols", List.of(KeyType.CONFIG, KeyType.USER));
    public static final ConfigKey<String> MAIL_SMTP_USERNAME = new StringConfigKey("mail.smtp.username", List.of(KeyType.CONFIG, KeyType.USER));
    public static final ConfigKey<String> MAIL_SMTP_PASSWORD = new StringConfigKey("mail.smtp.password", List.of(KeyType.CONFIG, KeyType.USER));
    public static final ConfigKey<String> MAIL_SMTP_FROM = new StringConfigKey("mail.smtp.from", List.of(KeyType.CONFIG, KeyType.USER));
    public static final ConfigKey<String> MAIL_SMTP_FROM_NAME = new StringConfigKey("mail.smtp.fromName", List.of(KeyType.CONFIG, KeyType.USER));
    public static final ConfigKey<String> SMS_HTTP_URL = new StringConfigKey("sms.http.url", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> SMS_HTTP_AUTHORIZATION_HEADER = new StringConfigKey("sms.http.authorizationHeader", List.of(KeyType.CONFIG), "Authorization");
    public static final ConfigKey<String> SMS_HTTP_AUTHORIZATION = new StringConfigKey("sms.http.authorization", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> SMS_HTTP_USER = new StringConfigKey("sms.http.user", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> SMS_HTTP_PASSWORD = new StringConfigKey("sms.http.password", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> SMS_HTTP_TEMPLATE = new StringConfigKey("sms.http.template", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> SMS_AWS_ACCESS = new StringConfigKey("sms.aws.access", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> SMS_AWS_SECRET = new StringConfigKey("sms.aws.secret", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> SMS_AWS_REGION = new StringConfigKey("sms.aws.region", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> COMMAND_SENDER = new StringConfigKey("command.sender", List.of(KeyType.DEVICE));
    public static final ConfigKey<String> COMMAND_CLIENT_SERVICE_ACCOUNT = new StringConfigKey("command.client.serviceAccount", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> COMMAND_FIND_HUB_URL = new StringConfigKey("command.findHub.url", List.of(KeyType.DEVICE));
    public static final ConfigKey<String> COMMAND_FIND_HUB_KEY = new StringConfigKey("command.findHub.key", List.of(KeyType.DEVICE));
    public static final ConfigKey<String> NOTIFICATOR_TYPES = new StringConfigKey("notificator.types", List.of(KeyType.CONFIG), "web,mail,command");
    public static final ConfigKey<Long> NOTIFICATOR_TIME_THRESHOLD = new LongConfigKey("notificator.timeThreshold", List.of(KeyType.CONFIG), 900000L);
    public static final ConfigKey<String> NOTIFICATOR_TRACCAR_KEY = new StringConfigKey("notificator.traccar.key", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> NOTIFICATOR_FIREBASE_SERVICE_ACCOUNT = new StringConfigKey("notificator.firebase.serviceAccount", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> NOTIFICATOR_PUSHOVER_USER = new StringConfigKey("notificator.pushover.user", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> NOTIFICATOR_PUSHOVER_TOKEN = new StringConfigKey("notificator.pushover.token", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> NOTIFICATOR_TELEGRAM_KEY = new StringConfigKey("notificator.telegram.key", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> NOTIFICATOR_TELEGRAM_CHAT_ID = new StringConfigKey("notificator.telegram.chatId", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> NOTIFICATOR_TELEGRAM_SEND_LOCATION = new BooleanConfigKey("notificator.telegram.sendLocation", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> NOTIFICATION_EXPIRATION_USER = new BooleanConfigKey("notification.expiration.user", List.of(KeyType.CONFIG));
    public static final ConfigKey<Long> NOTIFICATION_EXPIRATION_USER_REMINDER = new LongConfigKey("notification.expiration.user.reminder", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> NOTIFICATION_EXPIRATION_DEVICE = new BooleanConfigKey("notification.expiration.device", List.of(KeyType.CONFIG));
    public static final ConfigKey<Long> NOTIFICATION_EXPIRATION_DEVICE_REMINDER = new LongConfigKey("notification.expiration.device.reminder", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> NOTIFICATION_BLOCK_USERS = new StringConfigKey("notification.block.users", List.of(KeyType.CONFIG));
    public static final ConfigKey<Long> REPORT_PERIOD_LIMIT = new LongConfigKey("report.periodLimit", List.of(KeyType.CONFIG));
    public static final ConfigKey<Long> REPORT_FAST_THRESHOLD = new LongConfigKey("report.fastThreshold", List.of(KeyType.CONFIG), 86400L);
    public static final ConfigKey<Long> REPORT_TRIP_MINIMAL_TRIP_DISTANCE = new LongConfigKey("report.trip.minimalTripDistance", List.of(KeyType.CONFIG, KeyType.DEVICE), 500L);
    public static final ConfigKey<Long> REPORT_TRIP_MINIMAL_TRIP_DURATION = new LongConfigKey("report.trip.minimalTripDuration", List.of(KeyType.CONFIG, KeyType.DEVICE), 300L);
    public static final ConfigKey<Long> REPORT_TRIP_MINIMAL_PARKING_DURATION = new LongConfigKey("report.trip.minimalParkingDuration", List.of(KeyType.CONFIG, KeyType.DEVICE), 300L);
    public static final ConfigKey<Long> REPORT_TRIP_MINIMAL_NO_DATA_DURATION = new LongConfigKey("report.trip.minimalNoDataDuration", List.of(KeyType.CONFIG, KeyType.DEVICE), 3600L);
    public static final ConfigKey<Boolean> REPORT_TRIP_USE_IGNITION = new BooleanConfigKey("report.trip.useIgnition", List.of(KeyType.CONFIG, KeyType.DEVICE), false);
    public static final ConfigKey<Boolean> REPORT_IGNORE_ODOMETER = new BooleanConfigKey("report.ignoreOdometer", List.of(KeyType.CONFIG, KeyType.DEVICE), false);
    public static final ConfigKey<Boolean> FILTER_ENABLE = new BooleanConfigKey("filter.enable", List.of(KeyType.CONFIG), true);
    public static final ConfigKey<Boolean> FILTER_INVALID = new BooleanConfigKey("filter.invalid", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> FILTER_ZERO = new BooleanConfigKey("filter.zero", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> FILTER_DUPLICATE = new BooleanConfigKey("filter.duplicate", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> FILTER_OUTDATED = new BooleanConfigKey("filter.outdated", List.of(KeyType.CONFIG));
    public static final ConfigKey<Long> FILTER_FUTURE = new LongConfigKey("filter.future", List.of(KeyType.CONFIG), 86400L);
    public static final ConfigKey<Long> FILTER_PAST = new LongConfigKey("filter.past", List.of(KeyType.CONFIG));
    public static final ConfigKey<Integer> FILTER_ACCURACY = new IntegerConfigKey("filter.accuracy", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> FILTER_APPROXIMATE = new BooleanConfigKey("filter.approximate", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> FILTER_STATIC = new BooleanConfigKey("filter.static", List.of(KeyType.CONFIG));
    public static final ConfigKey<Integer> FILTER_DISTANCE = new IntegerConfigKey("filter.distance", List.of(KeyType.CONFIG));
    public static final ConfigKey<Integer> FILTER_MAX_SPEED = new IntegerConfigKey("filter.maxSpeed", List.of(KeyType.CONFIG));
    public static final ConfigKey<Integer> FILTER_MIN_PERIOD = new IntegerConfigKey("filter.minPeriod", List.of(KeyType.CONFIG));
    public static final ConfigKey<Integer> FILTER_DAILY_LIMIT = new IntegerConfigKey("filter.dailyLimit", List.of(KeyType.CONFIG));
    public static final ConfigKey<Integer> FILTER_DAILY_LIMIT_INTERVAL = new IntegerConfigKey("filter.dailyLimitInterval", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> FILTER_RELATIVE = new BooleanConfigKey("filter.relative", List.of(KeyType.CONFIG));
    public static final ConfigKey<Long> FILTER_SKIP_LIMIT = new LongConfigKey("filter.skipLimit", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> FILTER_SKIP_ATTRIBUTES_ENABLE = new BooleanConfigKey("filter.skipAttributes.enable", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> FILTER_SKIP_ATTRIBUTES = new StringConfigKey("filter.skipAttributes", List.of(KeyType.CONFIG, KeyType.DEVICE), "");
    public static final ConfigKey<String> TIME_OVERRIDE = new StringConfigKey("time.override", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> PROTOCOLS_ENABLE = new StringConfigKey("protocols.enable", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> TIME_PROTOCOLS = new StringConfigKey("time.protocols", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> COORDINATES_FILTER = new BooleanConfigKey("coordinates.filter", List.of(KeyType.CONFIG));
    public static final ConfigKey<Integer> COORDINATES_MIN_ERROR = new IntegerConfigKey("coordinates.minError", List.of(KeyType.CONFIG));
    public static final ConfigKey<Integer> COORDINATES_MAX_ERROR = new IntegerConfigKey("coordinates.maxError", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> PROCESSING_REMOTE_ADDRESS_ENABLE = new BooleanConfigKey("processing.remoteAddress.enable", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> PROCESSING_USE_LINKED_DRIVER = new BooleanConfigKey("processing.useLinkedDriver", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> PROCESSING_COPY_ATTRIBUTES_ENABLE = new BooleanConfigKey("processing.copyAttributes.enable", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> PROCESSING_COPY_ATTRIBUTES = new StringConfigKey("processing.copyAttributes", List.of(KeyType.CONFIG, KeyType.DEVICE));
    public static final ConfigKey<Boolean> PROCESSING_COMPUTED_ATTRIBUTES_DEVICE_ATTRIBUTES = new BooleanConfigKey("processing.computedAttributes.deviceAttributes", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> PROCESSING_COMPUTED_ATTRIBUTES_LAST_ATTRIBUTES = new BooleanConfigKey("processing.computedAttributes.lastAttributes", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> PROCESSING_COMPUTED_ATTRIBUTES_LOCAL_VARIABLES = new BooleanConfigKey("processing.computedAttributes.localVariables", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> PROCESSING_COMPUTED_ATTRIBUTES_LOOPS = new BooleanConfigKey("processing.computedAttributes.loops", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> PROCESSING_COMPUTED_ATTRIBUTES_NEW_INSTANCE_CREATION = new BooleanConfigKey("processing.computedAttributes.newInstanceCreation", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> GEOCODER_ENABLE = new BooleanConfigKey("geocoder.enable", List.of(KeyType.CONFIG), true);
    public static final ConfigKey<String> GEOCODER_TYPE = new StringConfigKey("geocoder.type", List.of(KeyType.CONFIG), "locationiq");
    public static final ConfigKey<String> GEOCODER_URL = new StringConfigKey("geocoder.url", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> GEOCODER_KEY = new StringConfigKey("geocoder.key", List.of(KeyType.CONFIG), "pk.689d849289c8c63708068b2ff1f63b2d");
    public static final ConfigKey<String> GEOCODER_LANGUAGE = new StringConfigKey("geocoder.language", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> GEOCODER_FORMAT = new StringConfigKey("geocoder.format", List.of(KeyType.CONFIG));
    public static final ConfigKey<Integer> GEOCODER_CACHE_SIZE = new IntegerConfigKey("geocoder.cacheSize", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> GEOCODER_IGNORE_POSITIONS = new BooleanConfigKey("geocoder.ignorePositions", List.of(KeyType.CONFIG), true);
    public static final ConfigKey<Boolean> GEOCODER_PROCESS_INVALID_POSITIONS = new BooleanConfigKey("geocoder.processInvalidPositions", List.of(KeyType.CONFIG));
    public static final ConfigKey<Integer> GEOCODER_REUSE_DISTANCE = new IntegerConfigKey("geocoder.reuseDistance", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> GEOCODER_ON_REQUEST = new BooleanConfigKey("geocoder.onRequest", List.of(KeyType.CONFIG), true);
    public static final ConfigKey<Boolean> GEOLOCATION_ENABLE = new BooleanConfigKey("geolocation.enable", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> GEOLOCATION_TYPE = new StringConfigKey("geolocation.type", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> GEOLOCATION_URL = new StringConfigKey("geolocation.url", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> GEOLOCATION_KEY = new StringConfigKey("geolocation.key", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> GEOLOCATION_PROCESS_INVALID_POSITIONS = new BooleanConfigKey("geolocation.processInvalidPositions", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> GEOLOCATION_REUSE = new BooleanConfigKey("geolocation.reuse", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> GEOLOCATION_REQUIRE_WIFI = new BooleanConfigKey("geolocation.requireWifi", List.of(KeyType.CONFIG));
    public static final ConfigKey<Integer> GEOLOCATION_MCC = new IntegerConfigKey("geolocation.mcc", List.of(KeyType.CONFIG));
    public static final ConfigKey<Integer> GEOLOCATION_MNC = new IntegerConfigKey("geolocation.mnc", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> SPEED_LIMIT_ENABLE = new BooleanConfigKey("speedLimit.enable", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> SPEED_LIMIT_TYPE = new StringConfigKey("speedLimit.type", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> SPEED_LIMIT_URL = new StringConfigKey("speedLimit.url", List.of(KeyType.CONFIG));
    public static final ConfigKey<Integer> SPEED_LIMIT_ACCURACY = new IntegerConfigKey("speedLimit.accuracy", List.of(KeyType.CONFIG), 100);
    public static final ConfigKey<String> LOCATION_LATITUDE_HEMISPHERE = new StringConfigKey("location.latitudeHemisphere", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> LOCATION_LONGITUDE_HEMISPHERE = new StringConfigKey("location.longitudeHemisphere", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> WEB_REQUEST_LOG_PATH = new StringConfigKey("web.requestLog.path", List.of(KeyType.CONFIG));
    public static final ConfigKey<Integer> WEB_REQUEST_LOG_RETAIN_DAYS = new IntegerConfigKey("web.requestLog.retainDays", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> WEB_DISABLE_HEALTH_CHECK = new BooleanConfigKey("web.disableHealthCheck", List.of(KeyType.CONFIG));
    public static final ConfigKey<Double> WEB_HEALTH_CHECK_DROP_THRESHOLD = new DoubleConfigKey("web.healthCheck.dropThreshold", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> WEB_SAME_SITE_COOKIE = new StringConfigKey("web.sameSiteCookie", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> WEB_PERSIST_SESSION = new BooleanConfigKey("web.persistSession", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> WEB_URL = new StringConfigKey("web.url", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> WEB_SHOW_UNKNOWN_DEVICES = new BooleanConfigKey("web.showUnknownDevices", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> WEB_SHARE_DEVICE_COMMANDS = new BooleanConfigKey("web.shareDevice.commands", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> WEB_SHARE_DEVICE_REPORTS = new BooleanConfigKey("web.shareDevice.reports", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> LOGGER_CONSOLE = new BooleanConfigKey("logger.console", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> LOGGER_QUERIES = new BooleanConfigKey("logger.queries", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> LOGGER_FILE = new StringConfigKey("logger.file", List.of(KeyType.CONFIG), "./logs/tracker-server.log");
    public static final ConfigKey<String> LOGGER_LEVEL = new StringConfigKey("logger.level", List.of(KeyType.CONFIG), "info");
    public static final ConfigKey<Boolean> LOGGER_FULL_STACK_TRACES = new BooleanConfigKey("logger.fullStackTraces", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> LOGGER_ROTATE = new BooleanConfigKey("logger.rotate", List.of(KeyType.CONFIG), true);
    public static final ConfigKey<Boolean> LOGGER_TEXT_PROTOCOL = new BooleanConfigKey("logger.decodeTextData", List.of(KeyType.CONFIG), true);
    public static final ConfigKey<String> LOGGER_ROTATE_INTERVAL = new StringConfigKey("logger.rotate.interval", List.of(KeyType.CONFIG), "day");
    public static final ConfigKey<String> LOGGER_ATTRIBUTES = new StringConfigKey("logger.attributes", List.of(KeyType.CONFIG), "time,position,speed,course,accuracy,result");
    public static final ConfigKey<String> BROADCAST_TYPE = new StringConfigKey("broadcast.type", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> BROADCAST_INTERFACE = new StringConfigKey("broadcast.interface", List.of(KeyType.CONFIG));
    public static final ConfigKey<String> BROADCAST_ADDRESS = new StringConfigKey("broadcast.address", List.of(KeyType.CONFIG));
    public static final ConfigKey<Integer> BROADCAST_PORT = new IntegerConfigKey("broadcast.port", List.of(KeyType.CONFIG));
    public static final ConfigKey<Boolean> BROADCAST_SECONDARY = new BooleanConfigKey("broadcast.secondary", List.of(KeyType.CONFIG));

    private Keys() {
    }
}

