/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.QueryParam;
import java.util.LinkedList;
import java.util.stream.Stream;
import org.traccar.api.BaseObjectResource;
import org.traccar.model.BaseModel;
import org.traccar.model.Device;
import org.traccar.model.Group;
import org.traccar.model.User;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Order;
import org.traccar.storage.query.Request;

public class ExtendedObjectResource<T extends BaseModel>
extends BaseObjectResource<T> {
    private final String sortField;

    public ExtendedObjectResource(Class<T> baseClass, String sortField) {
        super(baseClass);
        this.sortField = sortField;
    }

    @GET
    public Stream<T> get(@QueryParam(value="all") boolean all, @QueryParam(value="userId") long userId, @QueryParam(value="groupId") long groupId, @QueryParam(value="deviceId") long deviceId, @QueryParam(value="excludeAttributes") boolean excludeAttributes) throws StorageException {
        LinkedList<Condition> conditions = new LinkedList<Condition>();
        if (all) {
            if (this.permissionsService.notAdmin(this.getUserId())) {
                conditions.add(new Condition.Permission(User.class, this.getUserId(), this.baseClass));
            }
        } else if (userId == 0L) {
            conditions.add(new Condition.Permission(User.class, this.getUserId(), this.baseClass));
        } else {
            this.permissionsService.checkUser(this.getUserId(), userId);
            conditions.add(new Condition.Permission(User.class, userId, this.baseClass).excludeGroups());
        }
        if (groupId > 0L) {
            this.permissionsService.checkPermission(Group.class, this.getUserId(), groupId);
            conditions.add(new Condition.Permission(Group.class, groupId, this.baseClass).excludeGroups());
        }
        if (deviceId > 0L) {
            this.permissionsService.checkPermission(Device.class, this.getUserId(), deviceId);
            conditions.add(new Condition.Permission(Device.class, deviceId, this.baseClass).excludeGroups());
        }
        Columns columns = excludeAttributes ? new Columns.Exclude("attributes") : new Columns.All();
        return this.storage.getObjectsStream(this.baseClass, new Request(columns, Condition.merge(conditions), this.sortField != null ? new Order(this.sortField) : null));
    }
}

