/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.resource;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;

public class JvmElementAtOffsetHelper {
    @Inject
    private EObjectAtOffsetHelper eObjectAtOffsetHelper;
    @Inject
    private IJvmModelAssociations associations;

    public JvmIdentifiableElement getJvmIdentifiableElement(XtextResource resource, int offset) {
        EObject firstElement;
        EObject selectedElement = this.eObjectAtOffsetHelper.resolveElementAt(resource, offset);
        if (selectedElement == null) {
            return null;
        }
        if (selectedElement instanceof JvmIdentifiableElement) {
            return (JvmIdentifiableElement)selectedElement;
        }
        Set<EObject> jvmElements = this.associations.getJvmElements(selectedElement);
        if (!jvmElements.isEmpty() && (firstElement = (EObject)Iterables.getFirst(jvmElements, null)) instanceof JvmIdentifiableElement) {
            return (JvmIdentifiableElement)firstElement;
        }
        return null;
    }
}

