/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.internal.service;

import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.internal.types.StateDescriptionFragmentImpl;
import org.openhab.core.service.StateDescriptionService;
import org.openhab.core.types.StateDescription;
import org.openhab.core.types.StateDescriptionFragment;
import org.openhab.core.types.StateDescriptionFragmentProvider;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@NonNullByDefault
@Component
public class StateDescriptionServiceImpl
implements StateDescriptionService {
    private final Set<StateDescriptionFragmentProvider> stateDescriptionFragmentProviders = Collections.synchronizedSet(new TreeSet<StateDescriptionFragmentProvider>(new Comparator<StateDescriptionFragmentProvider>(){

        @Override
        public int compare(StateDescriptionFragmentProvider provider1, StateDescriptionFragmentProvider provider2) {
            return provider2.getRank().compareTo(provider1.getRank());
        }
    }));

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addStateDescriptionFragmentProvider(StateDescriptionFragmentProvider provider) {
        this.stateDescriptionFragmentProviders.add(provider);
    }

    public void removeStateDescriptionFragmentProvider(StateDescriptionFragmentProvider provider) {
        this.stateDescriptionFragmentProviders.remove(provider);
    }

    @Override
    public @Nullable StateDescription getStateDescription(String itemName, @Nullable Locale locale) {
        StateDescriptionFragment stateDescriptionFragment = this.getMergedStateDescriptionFragments(itemName, locale);
        return stateDescriptionFragment != null ? stateDescriptionFragment.toStateDescription() : null;
    }

    private @Nullable StateDescriptionFragment getMergedStateDescriptionFragments(String itemName, @Nullable Locale locale) {
        StateDescriptionFragmentImpl result = null;
        for (StateDescriptionFragmentProvider provider : this.stateDescriptionFragmentProviders) {
            StateDescriptionFragment fragment = provider.getStateDescriptionFragment(itemName, locale);
            if (fragment == null) continue;
            if (result == null) {
                result = new StateDescriptionFragmentImpl((StateDescriptionFragmentImpl)fragment);
                continue;
            }
            result.merge(fragment);
        }
        return result;
    }
}

