# frozen_string_literal: true
# :markup: markdown

=begin
--
This file is generated by the templates/template.rb script and should not be
modified manually. See templates/lib/prism/visitor.rb.erb
if you are looking to modify the template
++
=end

module Prism
  # A class that knows how to walk down the tree. None of the individual visit
  # methods are implemented on this visitor, so it forces the consumer to
  # implement each one that they need. For a default implementation that
  # continues walking the tree, see the Visitor class.
  class BasicVisitor
    # Calls `accept` on the given node if it is not `nil`, which in turn should
    # call back into this visitor by calling the appropriate `visit_*` method.
    def visit(node)
      # @type self: _Visitor
      node&.accept(self)
    end

    # Visits each node in `nodes` by calling `accept` on each one.
    def visit_all(nodes)
      # @type self: _Visitor
      nodes.each { |node| node&.accept(self) }
    end

    # Visits the child nodes of `node` by calling `accept` on each one.
    def visit_child_nodes(node)
      # @type self: _Visitor
      node.compact_child_nodes.each { |node| node.accept(self) }
    end
  end

  # A visitor is a class that provides a default implementation for every accept
  # method defined on the nodes. This means it can walk a tree without the
  # caller needing to define any special handling. This allows you to handle a
  # subset of the tree, while still walking the whole tree.
  #
  # For example, to find all of the method calls that call the `foo` method, you
  # could write:
  #
  #     class FooCalls < Prism::Visitor
  #       def visit_call_node(node)
  #         if node.name == :foo
  #           # Do something with the node
  #         end
  #
  #         # Call super so that the visitor continues walking the tree
  #         super
  #       end
  #     end
  #
  class Visitor < BasicVisitor
    # Visit a AliasGlobalVariableNode node
    def visit_alias_global_variable_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a AliasMethodNode node
    def visit_alias_method_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a AlternationPatternNode node
    def visit_alternation_pattern_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a AndNode node
    def visit_and_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a ArgumentsNode node
    def visit_arguments_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a ArrayNode node
    def visit_array_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a ArrayPatternNode node
    def visit_array_pattern_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a AssocNode node
    def visit_assoc_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a AssocSplatNode node
    def visit_assoc_splat_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a BackReferenceReadNode node
    def visit_back_reference_read_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a BeginNode node
    def visit_begin_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a BlockArgumentNode node
    def visit_block_argument_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a BlockLocalVariableNode node
    def visit_block_local_variable_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a BlockNode node
    def visit_block_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a BlockParameterNode node
    def visit_block_parameter_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a BlockParametersNode node
    def visit_block_parameters_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a BreakNode node
    def visit_break_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a CallAndWriteNode node
    def visit_call_and_write_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a CallNode node
    def visit_call_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a CallOperatorWriteNode node
    def visit_call_operator_write_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a CallOrWriteNode node
    def visit_call_or_write_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a CallTargetNode node
    def visit_call_target_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a CapturePatternNode node
    def visit_capture_pattern_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a CaseMatchNode node
    def visit_case_match_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a CaseNode node
    def visit_case_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a ClassNode node
    def visit_class_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a ClassVariableAndWriteNode node
    def visit_class_variable_and_write_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a ClassVariableOperatorWriteNode node
    def visit_class_variable_operator_write_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a ClassVariableOrWriteNode node
    def visit_class_variable_or_write_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a ClassVariableReadNode node
    def visit_class_variable_read_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a ClassVariableTargetNode node
    def visit_class_variable_target_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a ClassVariableWriteNode node
    def visit_class_variable_write_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a ConstantAndWriteNode node
    def visit_constant_and_write_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a ConstantOperatorWriteNode node
    def visit_constant_operator_write_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a ConstantOrWriteNode node
    def visit_constant_or_write_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a ConstantPathAndWriteNode node
    def visit_constant_path_and_write_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a ConstantPathNode node
    def visit_constant_path_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a ConstantPathOperatorWriteNode node
    def visit_constant_path_operator_write_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a ConstantPathOrWriteNode node
    def visit_constant_path_or_write_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a ConstantPathTargetNode node
    def visit_constant_path_target_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a ConstantPathWriteNode node
    def visit_constant_path_write_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a ConstantReadNode node
    def visit_constant_read_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a ConstantTargetNode node
    def visit_constant_target_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a ConstantWriteNode node
    def visit_constant_write_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a DefNode node
    def visit_def_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a DefinedNode node
    def visit_defined_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a ElseNode node
    def visit_else_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a EmbeddedStatementsNode node
    def visit_embedded_statements_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a EmbeddedVariableNode node
    def visit_embedded_variable_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a EnsureNode node
    def visit_ensure_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a FalseNode node
    def visit_false_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a FindPatternNode node
    def visit_find_pattern_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a FlipFlopNode node
    def visit_flip_flop_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a FloatNode node
    def visit_float_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a ForNode node
    def visit_for_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a ForwardingArgumentsNode node
    def visit_forwarding_arguments_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a ForwardingParameterNode node
    def visit_forwarding_parameter_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a ForwardingSuperNode node
    def visit_forwarding_super_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a GlobalVariableAndWriteNode node
    def visit_global_variable_and_write_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a GlobalVariableOperatorWriteNode node
    def visit_global_variable_operator_write_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a GlobalVariableOrWriteNode node
    def visit_global_variable_or_write_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a GlobalVariableReadNode node
    def visit_global_variable_read_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a GlobalVariableTargetNode node
    def visit_global_variable_target_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a GlobalVariableWriteNode node
    def visit_global_variable_write_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a HashNode node
    def visit_hash_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a HashPatternNode node
    def visit_hash_pattern_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a IfNode node
    def visit_if_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a ImaginaryNode node
    def visit_imaginary_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a ImplicitNode node
    def visit_implicit_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a ImplicitRestNode node
    def visit_implicit_rest_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a InNode node
    def visit_in_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a IndexAndWriteNode node
    def visit_index_and_write_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a IndexOperatorWriteNode node
    def visit_index_operator_write_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a IndexOrWriteNode node
    def visit_index_or_write_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a IndexTargetNode node
    def visit_index_target_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a InstanceVariableAndWriteNode node
    def visit_instance_variable_and_write_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a InstanceVariableOperatorWriteNode node
    def visit_instance_variable_operator_write_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a InstanceVariableOrWriteNode node
    def visit_instance_variable_or_write_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a InstanceVariableReadNode node
    def visit_instance_variable_read_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a InstanceVariableTargetNode node
    def visit_instance_variable_target_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a InstanceVariableWriteNode node
    def visit_instance_variable_write_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a IntegerNode node
    def visit_integer_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a InterpolatedMatchLastLineNode node
    def visit_interpolated_match_last_line_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a InterpolatedRegularExpressionNode node
    def visit_interpolated_regular_expression_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a InterpolatedStringNode node
    def visit_interpolated_string_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a InterpolatedSymbolNode node
    def visit_interpolated_symbol_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a InterpolatedXStringNode node
    def visit_interpolated_x_string_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a ItLocalVariableReadNode node
    def visit_it_local_variable_read_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a ItParametersNode node
    def visit_it_parameters_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a KeywordHashNode node
    def visit_keyword_hash_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a KeywordRestParameterNode node
    def visit_keyword_rest_parameter_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a LambdaNode node
    def visit_lambda_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a LocalVariableAndWriteNode node
    def visit_local_variable_and_write_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a LocalVariableOperatorWriteNode node
    def visit_local_variable_operator_write_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a LocalVariableOrWriteNode node
    def visit_local_variable_or_write_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a LocalVariableReadNode node
    def visit_local_variable_read_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a LocalVariableTargetNode node
    def visit_local_variable_target_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a LocalVariableWriteNode node
    def visit_local_variable_write_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a MatchLastLineNode node
    def visit_match_last_line_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a MatchPredicateNode node
    def visit_match_predicate_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a MatchRequiredNode node
    def visit_match_required_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a MatchWriteNode node
    def visit_match_write_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a MissingNode node
    def visit_missing_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a ModuleNode node
    def visit_module_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a MultiTargetNode node
    def visit_multi_target_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a MultiWriteNode node
    def visit_multi_write_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a NextNode node
    def visit_next_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a NilNode node
    def visit_nil_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a NoKeywordsParameterNode node
    def visit_no_keywords_parameter_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a NumberedParametersNode node
    def visit_numbered_parameters_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a NumberedReferenceReadNode node
    def visit_numbered_reference_read_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a OptionalKeywordParameterNode node
    def visit_optional_keyword_parameter_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a OptionalParameterNode node
    def visit_optional_parameter_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a OrNode node
    def visit_or_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a ParametersNode node
    def visit_parameters_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a ParenthesesNode node
    def visit_parentheses_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a PinnedExpressionNode node
    def visit_pinned_expression_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a PinnedVariableNode node
    def visit_pinned_variable_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a PostExecutionNode node
    def visit_post_execution_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a PreExecutionNode node
    def visit_pre_execution_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a ProgramNode node
    def visit_program_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a RangeNode node
    def visit_range_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a RationalNode node
    def visit_rational_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a RedoNode node
    def visit_redo_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a RegularExpressionNode node
    def visit_regular_expression_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a RequiredKeywordParameterNode node
    def visit_required_keyword_parameter_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a RequiredParameterNode node
    def visit_required_parameter_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a RescueModifierNode node
    def visit_rescue_modifier_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a RescueNode node
    def visit_rescue_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a RestParameterNode node
    def visit_rest_parameter_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a RetryNode node
    def visit_retry_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a ReturnNode node
    def visit_return_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a SelfNode node
    def visit_self_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a ShareableConstantNode node
    def visit_shareable_constant_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a SingletonClassNode node
    def visit_singleton_class_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a SourceEncodingNode node
    def visit_source_encoding_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a SourceFileNode node
    def visit_source_file_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a SourceLineNode node
    def visit_source_line_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a SplatNode node
    def visit_splat_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a StatementsNode node
    def visit_statements_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a StringNode node
    def visit_string_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a SuperNode node
    def visit_super_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a SymbolNode node
    def visit_symbol_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a TrueNode node
    def visit_true_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a UndefNode node
    def visit_undef_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a UnlessNode node
    def visit_unless_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a UntilNode node
    def visit_until_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a WhenNode node
    def visit_when_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a WhileNode node
    def visit_while_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a XStringNode node
    def visit_x_string_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end

    # Visit a YieldNode node
    def visit_yield_node(node)
      node.compact_child_nodes.each { |node| node.accept(self) }
    end
  end
end
