# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.3.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _orientmapdata
else:
    import _orientmapdata

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


import ooflib.SWIG.common.abstractimage
import ooflib.SWIG.common.coord
import ooflib.SWIG.engine.angle2color
import ooflib.SWIG.engine.corientation
import ooflib.SWIG.engine.fieldindex
import ooflib.SWIG.engine.planarity
import ooflib.SWIG.engine.outputval
import ooflib.SWIG.engine.IO.propertyoutput
import ooflib.SWIG.engine.mastercoord
import ooflib.SWIG.engine.property
import ooflib.SWIG.image.oofimage
import ooflib.SWIG.common.IO.bitoverlay
import ooflib.SWIG.common.timestamp
import ooflib.SWIG.common.ccolor
import ooflib.SWIG.common.boolarray
import ooflib.SWIG.common.doublearray
import ooflib.SWIG.common.ooferror
class OrientMap(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, iPoint, Point):
        _orientmapdata.OrientMap_swiginit(self, _orientmapdata.new_OrientMap(iPoint, Point))
    __swig_destroy__ = _orientmapdata.delete_OrientMap

    def angle(self, iPoint):
        return _orientmapdata.OrientMap_angle(self, iPoint)

    def sizeInPixels(self):
        return _orientmapdata.OrientMap_sizeInPixels(self)

    def size(self):
        return _orientmapdata.OrientMap_size(self)

    def pixelFromPoint(self, Point):
        return _orientmapdata.OrientMap_pixelFromPoint(self, Point)

    def pixelInBounds(self, iPoint):
        return _orientmapdata.OrientMap_pixelInBounds(self, iPoint)

    def createImage(self, arg2, arg3):
        return _orientmapdata.OrientMap_createImage(self, arg2, arg3)

    def setMicrostructure(self, arg2):
        return _orientmapdata.OrientMap_setMicrostructure(self, arg2)

    def getCMicrostructure(self):
        return _orientmapdata.OrientMap_getCMicrostructure(self)

# Register OrientMap in _orientmapdata:
_orientmapdata.OrientMap_swigregister(OrientMap)
class COrientMapReader(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        _orientmapdata.COrientMapReader_swiginit(self, _orientmapdata.new_COrientMapReader())

    def set_angle(self, data, iPoint, arg4):
        return _orientmapdata.COrientMapReader_set_angle(self, data, iPoint, arg4)
    __swig_destroy__ = _orientmapdata.delete_COrientMapReader

# Register COrientMapReader in _orientmapdata:
_orientmapdata.COrientMapReader_swigregister(COrientMapReader)
class OrientMapImage(ooflib.SWIG.common.abstractimage.AbstractImage):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, arg2, arg3):
        _orientmapdata.OrientMapImage_swiginit(self, _orientmapdata.new_OrientMapImage(arg2, arg3))
    __swig_destroy__ = _orientmapdata.delete_OrientMapImage

    def makeCanvasImage(self, arg2, arg3):
        return _orientmapdata.OrientMapImage_makeCanvasImage(self, arg2, arg3)

# Register OrientMapImage in _orientmapdata:
_orientmapdata.OrientMapImage_swigregister(OrientMapImage)

def registerOrientMap(arg1, arg2):
    return _orientmapdata.registerOrientMap(arg1, arg2)

def removeOrientMap(arg1):
    return _orientmapdata.removeOrientMap(arg1)
# -*- python -*-

# This software was produced by NIST, an agency of the U.S. government,
# and by statute is not subject to copyright in the United States.
# Recipients of this software assume all responsibilities associated
# with its operation, modification and maintenance. However, to
# facilitate maintenance we ask that before distributing modified
# versions of this software, you first contact the authors at
# oof_manager@nist.gov. 

_readerregistry = {}

from ooflib.SWIG.common import switchboard
from ooflib.SWIG.common import timestamp
from ooflib.SWIG.engine import material
from ooflib.SWIG.orientationmap import orientmapproperty
from ooflib.SWIG.engine.properties.orientation import orientation
from ooflib.SWIG.engine import ooferror
from ooflib.common import debug
from ooflib.common import registeredclass
from ooflib.common import microstructure
from ooflib.common.IO import xmlmenudump

## TODO: Document the file format expected by each OrientMapReader.

class OrientMapReader(COrientMapReader, registeredclass.RegisteredClass):
    registry = []

# OrientMapReaders can have an optional postProcess method, which
# is called only from Python.  It's called after the orientation
# data has been associated with a Microstructure.
    def postProcess(self, microstructure):
        pass

# In order to call the swigged methods in the COrientMapReader
# base class, COrientMapReader must be the first base class
# listed.  However, that means that by default the swig-generated
# __repr__ will be used instead of the RegisteredClass __repr__.
    def __repr__(self):
        return registeredclass.RegisteredClass.__repr__(self)

    tip="Methods for reading orientation maps."
    discussion=xmlmenudump.loadFile(
        'DISCUSSIONS/orientationmap/reg/orientationreader.xml')
    xrefs=["MenuItem-OOF.OrientationMap.Load"]


class OrientMapRegistration(registeredclass.Registration):
    def __init__(self, name, subclass, ordering, params=[], tip=None,
                 discussion=None):
        registeredclass.Registration.__init__(self, name,
                                              OrientMapReader, subclass, 
                                              ordering, params, 
                                              tip=tip, discussion=discussion)

##############

# Utility function which must be called whenever the orientation map
# in a Microstructure changes.  It sends the "material changed" signal
# for all Materials in the Microstructure that use orientation map
# data.

def orientationmapNotify(ms):
    matls = material.getMaterials(ms)
    for matl in matls:
        try:
            orient = matl.fetchProperty("Orientation")
        except ooferror.PyErrNoSuchProperty:
            pass
        else:
            if isinstance(orient, orientmapproperty.OrientationMapProp):
                switchboard.notify("material changed", matl.name())
    switchboard.notify("OrientationMap changed", ms)
    switchboard.notify("redraw")

########################################

## The OrientMapPlugIn class ensures that a Python reference is kept for
## each OrientMap object, until its Microstructure is destroyed, at
## which time the OrientMapPlugIn is destroyed automatically.

class OrientMapPlugIn(microstructure.MicrostructurePlugIn):
    def __init__(self, ms):
        microstructure.MicrostructurePlugIn.__init__(self, ms)
        self.data = None
        self.filename = None
        self.timestamp = timestamp.TimeStamp()
    def set_data(self, data, filename):
        self.data = data
        self.filename = filename
    def clear(self):
        self.data = None
        self.filename = None
        self.timestamp.increment()

microstructure.registerMicrostructurePlugIn(OrientMapPlugIn, "OrientationMap")

# The following utility functions take a Microstructure object as an
# argument (not a MicrostructureContext).

def getOrientationMap(ms):
    return ms.getPlugIn('OrientationMap').data

def hasOrientationMap(ms):
    return ms.hasPlugIn('OrientationMap')

def getOrientationMapTimestamp(ms):
    return ms.getPlugIn('OrientationMap').timestamp

def getOrientationMapFile(ms):
    return ms.getPlugIn('OrientationMap').filename

def clearOrientationMap(ms):
    ms.getPlugIn('OrientationMap').clear()

############################################

# Return the orientation at a point in a Microstructure, along with
# info about how it was obtained.

def getOrientationAtPoint(ms, point):
# First look for a Material containing an explicit Orientation Property
    mat = material.getMaterialFromPoint(ms, point)
    if mat:
        try:
            orientprop = mat.fetchProperty("Orientation")
            if isinstance(orientprop, orientation.OrientationProp):
                return orientprop.orientation(), "Property"
        except ooferror.PyErrNoSuchProperty:
            pass
# Look for an Orientation Map, whether or not there's an
# OrientationMapProp.
    orientmap = getOrientationMap(ms)
    if orientmap:
        return orientmap.angle(point), "Map"

############################################

def addPixelsToGroup(microstructure, groupname, pixels):
    microstructure.reserve()
    microstructure.begin_writing()
    try:
        group, newness = microstructure.getObject().getGroup(groupname)
        group.add(pixels)
    finally:
        microstructure.end_writing()
        microstructure.cancel_reservation()
    if newness:
        switchboard.notify("new pixel group", group)
    switchboard.notify("changed pixel group", group, microstructure.name())
    switchboard.notify("redraw")


