/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.db.DatabaseEntry;

public class DoubleBinding
extends TupleBinding<Double> {
    private static final int DOUBLE_SIZE = 8;

    @Override
    public Double entryToObject(TupleInput tupleInput) {
        return tupleInput.readDouble();
    }

    @Override
    public void objectToEntry(Double d, TupleOutput tupleOutput) {
        tupleOutput.writeDouble(d);
    }

    @Override
    protected TupleOutput getTupleOutput(Double d) {
        return DoubleBinding.sizedOutput();
    }

    public static double entryToDouble(DatabaseEntry databaseEntry) {
        return DoubleBinding.entryToInput(databaseEntry).readDouble();
    }

    public static void doubleToEntry(double d, DatabaseEntry databaseEntry) {
        DoubleBinding.outputToEntry(DoubleBinding.sizedOutput().writeDouble(d), databaseEntry);
    }

    static TupleOutput sizedOutput() {
        return new TupleOutput(new byte[8]);
    }
}

