/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.evolve;

import com.sleepycat.persist.evolve.Converter;
import com.sleepycat.persist.evolve.Deleter;
import com.sleepycat.persist.evolve.Mutation;
import com.sleepycat.persist.evolve.Renamer;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class Mutations
implements Serializable {
    private static final long serialVersionUID = -1744401530444812916L;
    private Map<Mutation, Renamer> renamers = new HashMap<Mutation, Renamer>();
    private Map<Mutation, Deleter> deleters = new HashMap<Mutation, Deleter>();
    private Map<Mutation, Converter> converters = new HashMap<Mutation, Converter>();

    public boolean isEmpty() {
        return this.renamers.isEmpty() && this.deleters.isEmpty() && this.converters.isEmpty();
    }

    public void addRenamer(Renamer renamer) {
        this.renamers.put(new Key(renamer), renamer);
    }

    public Renamer getRenamer(String string, int n, String string2) {
        return this.renamers.get(new Key(string, n, string2));
    }

    public Collection<Renamer> getRenamers() {
        return this.renamers.values();
    }

    public void addDeleter(Deleter deleter) {
        this.deleters.put(new Key(deleter), deleter);
    }

    public Deleter getDeleter(String string, int n, String string2) {
        return this.deleters.get(new Key(string, n, string2));
    }

    public Collection<Deleter> getDeleters() {
        return this.deleters.values();
    }

    public void addConverter(Converter converter) {
        this.converters.put(new Key(converter), converter);
    }

    public Converter getConverter(String string, int n, String string2) {
        return this.converters.get(new Key(string, n, string2));
    }

    public Collection<Converter> getConverters() {
        return this.converters.values();
    }

    public boolean equals(Object object) {
        if (object instanceof Mutations) {
            Mutations mutations = (Mutations)object;
            return this.renamers.equals(mutations.renamers) && this.deleters.equals(mutations.deleters) && this.converters.equals(mutations.converters);
        }
        return false;
    }

    public int hashCode() {
        return this.renamers.hashCode() + this.deleters.hashCode() + this.converters.hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.renamers.size() > 0) {
            stringBuffer.append(this.renamers.values());
        }
        if (this.deleters.size() > 0) {
            stringBuffer.append(this.deleters.values());
        }
        if (this.converters.size() > 0) {
            stringBuffer.append(this.converters.values());
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.toString();
        }
        return "[Empty Mutations]";
    }

    private static class Key
    extends Mutation {
        static final long serialVersionUID = 2793516787097085621L;

        Key(String string, int n, String string2) {
            super(string, n, string2);
        }

        Key(Mutation mutation) {
            super(mutation.getClassName(), mutation.getClassVersion(), mutation.getFieldName());
        }
    }
}

