
/* AssignmentTracker X http://www.atxproject.net - (c) 2003-2006, Colin Wheeler ( colin@atxproject.net )
 * ATXCoreController.h Created by Colin Wheeler on June 25, 2006
 * 
 * Contributor(s):
 *	Colin Wheeler
 * 
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU
 * General Public License version 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
 * Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with this program; if not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#import <Cocoa/Cocoa.h>
#import "ATXOutlineView.h"

enum ATXSourceListItemType {
	ATXAllAssignmentsStaticItem = 1, /**< Static All Assignments Item */
	ATXCourseAllAssignmentsItem,     /**< Root Course Source List Item */
	ATXCourseSubTypeItem,            /**< Sub Course Item for specific  */
	ATXSmartFolderItem,              /**< Smart Folder performs core data query  */
	ATXCustomFolderItem,             /**< Custom Folder for displaying specific assignments (non query) */
};

extern NSString *allSearchPredicateString;

@interface ATXCoreController : NSObject {
	/* Cocoa Pointers */
	NSNotificationCenter *nc;                                    /**<NSNotificationCenter Pointer */
	NSUserDefaults *defaults;                                    /**<NSUserDefaults Pointer */
	
	int lastUniqueId;                                            /**<lastUniqueId for sorting groups in the source list */
	NSMutableString *filterPredicateString;
	NSMutableArray *currentAssignments;                          /**<array that will be displayed in the table view */
	
	/* Sourcelist Pointers */
	IBOutlet ATXOutlineView *sourceListView;                     /**<ATXOutlineView source list for the assignments table */
	IBOutlet NSTreeController *sourceListTreeController;         /**< */
	IBOutlet NSArrayController *sourceList;
	
	IBOutlet NSArrayController *genericCategoriesController;
	IBOutlet NSArrayController *assignmentsPrioritiesController;
	IBOutlet NSArrayController *coursesController;
	IBOutlet NSArrayController *assignmentsTableController; //Controls what assignments are shown in the main table
	IBOutlet NSArrayController *sourceListArrayController;
	IBOutlet NSArrayController *assignmentStatusController; //
	IBOutlet NSArrayController *assignmentsWrapperController;
	
	IBOutlet NSWindow *docWindow;                              /**< */
	IBOutlet NSBox *presentationBox;
	IBOutlet NSView *startupWizardTestView;
	IBOutlet NSBox *assignmentViewAndEditBox;
	IBOutlet NSView *assignmentViewingView;
	IBOutlet NSView *assignmentEditingView;
	//
	IBOutlet NSView *toolbarSearchView;
	//
	IBOutlet NSDatePicker *assignedDatePicker;
	IBOutlet NSDatePicker *dueDatePicker;
	//
	IBOutlet NSTextView *assignmentNotesBox;
	//
	IBOutlet NSTableView *assignmentsTableView;
}
- (NSMutableString *)filterPredicateString;
- (void)setFilterPredicateString:(NSMutableString *)newFilterPredicateString;
//
- (NSManagedObjectContext *)managedObjectContext;
- (void)setupToolbar;
- (void)loadTheNib:(NSString *)nameOfNib withTestConnection:(NSView *)testView; /* Test if a view is loaded */

- (void)presentStartupWizard; /* Let ATXPresentationManager now this is a new document */
	//
- (NSMutableArray *)currentAssignments; /* the assignments displayed in the table view */
- (void)setTheCurrentAssignments:(NSArray *)newCurrentAssignments;
- (void)incrementTheUniqueID;
	//
- (void)sourceListSelectionDidChange;
	//
- (IBAction)setAssignmentsAsUneditable:(id)sender;
//
- (void)sortObjectsInArrayControllers;
- (void)addAssignment;
- (void)deleteAssignment;
//
- (int)getCoursesIndexWithName:(NSString *)courseSearchString;
@end

@interface ATXCoreController (SetupUtilities)
- (void)finishInitializingSetup;
- (void)setupInitialUserDefaults;
- (void)setupInitialSourceList;
- (void)setupGenericCategories;
- (void)setupAssignmentPriorities;
- (void)setupAssignmentStatuses;
@end

@interface ATXCoreController (Toolbar)
- (NSArray *)toolbarAllowedItemIdentifiers:(NSToolbar *)toolbar;
- (NSArray *)toolbarDefaultItemIdentifiers:(NSToolbar *)toolbar;
- (NSToolbarItem *)toolbar:(NSToolbar *)toolbar
	 itemForItemIdentifier:(NSString *) itemIdentifier
 willBeInsertedIntoToolbar:(BOOL)flag;
@end
