#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 415
#define LARGE_STATE_COUNT 187
#define SYMBOL_COUNT 248
#define ALIAS_COUNT 0
#define TOKEN_COUNT 172
#define EXTERNAL_TOKEN_COUNT 4
#define FIELD_COUNT 4
#define MAX_ALIAS_SEQUENCE_LENGTH 6
#define PRODUCTION_ID_COUNT 18

enum ts_symbol_identifiers {
  sym_name = 1,
  sym__begin = 2,
  anon_sym_LBRACE = 3,
  anon_sym_ATinheritdoc = 4,
  anon_sym_ATinheritDoc = 5,
  anon_sym_RBRACE = 6,
  anon_sym_ATapi = 7,
  anon_sym_ATfilesource = 8,
  anon_sym_ATignore = 9,
  anon_sym_ATinternal = 10,
  anon_sym_ATcategory = 11,
  anon_sym_ATcopyright = 12,
  anon_sym_ATtodo = 13,
  anon_sym_ATexample = 14,
  anon_sym_ATlicense = 15,
  anon_sym_ATpackage = 16,
  anon_sym_ATsource = 17,
  anon_sym_ATsubpackage = 18,
  anon_sym_ATuses = 19,
  anon_sym_ATauthor = 20,
  anon_sym_LT = 21,
  anon_sym_GT = 22,
  anon_sym_ATglobal = 23,
  anon_sym_ATlink = 24,
  anon_sym_ATmethod = 25,
  anon_sym_ATparam = 26,
  anon_sym_ATproperty = 27,
  anon_sym_ATproperty_DASHread = 28,
  anon_sym_ATproperty_DASHwrite = 29,
  anon_sym_ATreturn = 30,
  anon_sym_ATsee = 31,
  anon_sym_ATthrows = 32,
  anon_sym_ATvar = 33,
  anon_sym_ATdeprecated = 34,
  anon_sym_ATsince = 35,
  anon_sym_ATversion = 36,
  anon_sym_ATtemplate = 37,
  anon_sym_ATpsalm_DASHtemplate = 38,
  anon_sym_ATphpstan_DASHtemplate = 39,
  anon_sym_of = 40,
  anon_sym_ATimplements = 41,
  anon_sym_ATtemplate_DASHimplements = 42,
  anon_sym_ATextends = 43,
  anon_sym_ATtemplate_DASHextends = 44,
  anon_sym_ATuse = 45,
  anon_sym_ATtemplate_DASHuse = 46,
  anon_sym_ATafter = 47,
  anon_sym_ATafterClass = 48,
  anon_sym_ATannotation = 49,
  anon_sym_ATbackupGlobals = 50,
  anon_sym_ATbackupStaticAttributes = 51,
  anon_sym_ATbefore = 52,
  anon_sym_ATbeforeClass = 53,
  anon_sym_ATcodeCoverageIgnore = 54,
  anon_sym_ATcodeCoverageIgnore_STAR = 55,
  anon_sym_ATcodeCoverageIgnoreEnd = 56,
  anon_sym_ATcodeCoverageIgnoreStart = 57,
  anon_sym_ATcovers = 58,
  anon_sym_ATcoversDefaultClass = 59,
  anon_sym_ATcoversDefaultClasstoshortenannotations = 60,
  anon_sym_ATcoversNothing = 61,
  anon_sym_ATdataProvider = 62,
  anon_sym_ATdepends = 63,
  anon_sym_ATdependsannotationtoexpressdependencies = 64,
  anon_sym_ATdoesNotPerformAssertions = 65,
  anon_sym_ATgroup = 66,
  anon_sym_ATlarge = 67,
  anon_sym_ATmedium = 68,
  anon_sym_ATpreserveGlobalState = 69,
  anon_sym_ATrequires = 70,
  anon_sym_ATrequiresusages = 71,
  anon_sym_ATrunInSeparateProcess = 72,
  anon_sym_ATrunTestsInSeparateProcesses = 73,
  anon_sym_ATsmall = 74,
  anon_sym_ATtest = 75,
  anon_sym_ATtestWith = 76,
  anon_sym_ATtestdox = 77,
  anon_sym_ATticket = 78,
  anon_sym_ATpsalm_DASHconsistent_DASHconstructor = 79,
  anon_sym_ATpsalm_DASHconsistent_DASHtemplates = 80,
  anon_sym_ATpsalm_DASHvar = 81,
  anon_sym_ATpsalm_DASHparam = 82,
  anon_sym_ATpsalm_DASHreturn = 83,
  anon_sym_ATpsalm_DASHproperty = 84,
  anon_sym_ATpsalm_DASHproperty_DASHread = 85,
  anon_sym_ATpsalm_DASHproperty_DASHwrite = 86,
  anon_sym_ATpsalm_DASHmethod = 87,
  anon_sym_ATpsalm_DASHignore_DASHvar = 88,
  anon_sym_ATpsalm_DASHif_DASHthis_DASHis = 89,
  anon_sym_ATpsalm_DASHthis_DASHout = 90,
  anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn = 91,
  anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn = 92,
  anon_sym_ATpsalm_DASHseal_DASHproperties = 93,
  anon_sym_ATpsalm_DASHreadonly = 94,
  anon_sym_ATreadonly = 95,
  anon_sym_ATpsalm_DASHmutation_DASHfree = 96,
  anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree = 97,
  anon_sym_ATpsalm_DASHimmutable = 98,
  anon_sym_ATpsalm_DASHpure = 99,
  anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation = 100,
  anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation = 101,
  anon_sym_ATpsalm_DASHtrace = 102,
  anon_sym_ATno_DASHnamed_DASHarguments = 103,
  anon_sym_ATparam_DASHout = 104,
  anon_sym_ATpsalm_DASHparam_DASHout = 105,
  anon_sym_ATpsalm_DASHassert = 106,
  anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue = 107,
  anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse = 108,
  anon_sym_ATpsalm_DASHimport_DASHtype = 109,
  anon_sym_from = 110,
  anon_sym_as = 111,
  anon_sym_ATpsalm_DASHsuppress = 112,
  anon_sym_ATpsalm_DASHinternal = 113,
  anon_sym_ATpsalm_DASHrequire_DASHextends = 114,
  anon_sym_ATpsalm_DASHrequire_DASHimplements = 115,
  anon_sym_ATmixin = 116,
  anon_sym_LBRACK_RBRACK = 117,
  anon_sym_COMMA = 118,
  anon_sym_list = 119,
  anon_sym_array = 120,
  anon_sym_SQUOTE = 121,
  anon_sym_DQUOTE = 122,
  aux_sym__shaped_array_element_token1 = 123,
  anon_sym_QMARK = 124,
  anon_sym_COLON = 125,
  anon_sym_class_DASHstring = 126,
  anon_sym_interface_DASHstring = 127,
  anon_sym_positive_DASHint = 128,
  anon_sym_trait_DASHstring = 129,
  anon_sym_enum_DASHstring = 130,
  anon_sym_callable_DASHstring = 131,
  anon_sym_numeric_DASHstring = 132,
  anon_sym_literal_DASHstring = 133,
  anon_sym_lowercase_DASHstring = 134,
  anon_sym_non_DASHempty_DASHstring = 135,
  anon_sym_non_DASHempty_DASHlowercase_DASHstring = 136,
  anon_sym_BSLASH = 137,
  aux_sym_relative_name_token1 = 138,
  aux_sym_primitive_type_token1 = 139,
  anon_sym_iterable = 140,
  anon_sym_bool = 141,
  anon_sym_float = 142,
  anon_sym_int = 143,
  anon_sym_string = 144,
  anon_sym_void = 145,
  anon_sym_mixed = 146,
  anon_sym_false = 147,
  anon_sym_null = 148,
  anon_sym_true = 149,
  anon_sym_PIPE = 150,
  anon_sym_AMP = 151,
  anon_sym_LPAREN = 152,
  anon_sym_RPAREN = 153,
  anon_sym_DOLLAR = 154,
  sym_author_name = 155,
  sym_email_address = 156,
  aux_sym_version_token1 = 157,
  aux_sym_version_token2 = 158,
  anon_sym_ATpackage_version_AT = 159,
  sym__version_vector = 160,
  sym_uri = 161,
  anon_sym_LPAREN_RPAREN = 162,
  anon_sym_COLON_COLON = 163,
  anon_sym_EQ = 164,
  sym_default_value = 165,
  sym_static = 166,
  sym__end = 167,
  sym_text = 168,
  sym__text_after_type = 169,
  sym__text_in_inline_tag = 170,
  sym__text_not_version = 171,
  sym_document = 172,
  sym_description = 173,
  sym__description_after_type = 174,
  sym__description_not_version = 175,
  sym__description_in_inline_tag = 176,
  sym__description_in_inline_tag_with_nesting = 177,
  sym_tag = 178,
  sym_inline_tag = 179,
  sym__tag_without_description = 180,
  sym__tag_with_optional_description = 181,
  sym__tag_with_required_description = 182,
  sym__tag_with_incomplete_implementation = 183,
  sym__author_tag = 184,
  sym__global_tag = 185,
  sym__inline_internal_tag = 186,
  sym__link_tag = 187,
  sym__inline_link_tag = 188,
  sym__method_tag = 189,
  sym__param_tag = 190,
  sym__property_tag = 191,
  sym__return_tag = 192,
  sym__see_tag = 193,
  sym__inline_see_tag = 194,
  sym__throws_tag = 195,
  sym__var_tag = 196,
  sym__deprecated_tag = 197,
  sym__since_tag = 198,
  sym__version_tag = 199,
  sym__generic_template_tag = 200,
  sym__generic_implements_tag = 201,
  sym__generic_extends_tag = 202,
  sym__generic_use_tag = 203,
  sym__phpunit_tag = 204,
  sym__psalm_tag = 205,
  sym__mixin_tag = 206,
  sym__type = 207,
  sym__types = 208,
  sym__regular_types = 209,
  sym__phpdoc_array_types = 210,
  sym__psalm_generic_array_types = 211,
  sym__psalm_list_array_types = 212,
  sym__psalm_shaped_array_types = 213,
  sym__shaped_array_element = 214,
  sym__psalm_scalar_type = 215,
  sym_generic_type = 216,
  sym__type_argument_list = 217,
  sym__type_argument_named_type = 218,
  sym_named_type = 219,
  sym_namespace_name = 220,
  sym_relative_name = 221,
  sym_optional_type = 222,
  sym_primitive_type = 223,
  sym_qualified_name = 224,
  sym_union_type = 225,
  sym_intersection_type = 226,
  sym_disjunctive_normal_form_type = 227,
  sym_variable_name = 228,
  sym_version = 229,
  sym_fqsen = 230,
  sym_parameters = 231,
  sym_parameter = 232,
  aux_sym_document_repeat1 = 233,
  aux_sym_description_repeat1 = 234,
  aux_sym__description_after_type_repeat1 = 235,
  aux_sym__description_not_version_repeat1 = 236,
  aux_sym__description_in_inline_tag_repeat1 = 237,
  aux_sym__description_in_inline_tag_with_nesting_repeat1 = 238,
  aux_sym__phpdoc_array_types_repeat1 = 239,
  aux_sym__psalm_shaped_array_types_repeat1 = 240,
  aux_sym__type_argument_list_repeat1 = 241,
  aux_sym__type_argument_list_repeat2 = 242,
  aux_sym_namespace_name_repeat1 = 243,
  aux_sym_union_type_repeat1 = 244,
  aux_sym_intersection_type_repeat1 = 245,
  aux_sym_disjunctive_normal_form_type_repeat1 = 246,
  aux_sym_parameters_repeat1 = 247,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_name] = "name",
  [sym__begin] = "_begin",
  [anon_sym_LBRACE] = "{",
  [anon_sym_ATinheritdoc] = "tag_name",
  [anon_sym_ATinheritDoc] = "tag_name",
  [anon_sym_RBRACE] = "}",
  [anon_sym_ATapi] = "tag_name",
  [anon_sym_ATfilesource] = "tag_name",
  [anon_sym_ATignore] = "tag_name",
  [anon_sym_ATinternal] = "tag_name",
  [anon_sym_ATcategory] = "tag_name",
  [anon_sym_ATcopyright] = "tag_name",
  [anon_sym_ATtodo] = "tag_name",
  [anon_sym_ATexample] = "tag_name",
  [anon_sym_ATlicense] = "tag_name",
  [anon_sym_ATpackage] = "tag_name",
  [anon_sym_ATsource] = "tag_name",
  [anon_sym_ATsubpackage] = "tag_name",
  [anon_sym_ATuses] = "tag_name",
  [anon_sym_ATauthor] = "tag_name",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_ATglobal] = "tag_name",
  [anon_sym_ATlink] = "tag_name",
  [anon_sym_ATmethod] = "tag_name",
  [anon_sym_ATparam] = "tag_name",
  [anon_sym_ATproperty] = "tag_name",
  [anon_sym_ATproperty_DASHread] = "tag_name",
  [anon_sym_ATproperty_DASHwrite] = "tag_name",
  [anon_sym_ATreturn] = "tag_name",
  [anon_sym_ATsee] = "tag_name",
  [anon_sym_ATthrows] = "tag_name",
  [anon_sym_ATvar] = "tag_name",
  [anon_sym_ATdeprecated] = "tag_name",
  [anon_sym_ATsince] = "tag_name",
  [anon_sym_ATversion] = "tag_name",
  [anon_sym_ATtemplate] = "tag_name",
  [anon_sym_ATpsalm_DASHtemplate] = "tag_name",
  [anon_sym_ATphpstan_DASHtemplate] = "tag_name",
  [anon_sym_of] = "of",
  [anon_sym_ATimplements] = "tag_name",
  [anon_sym_ATtemplate_DASHimplements] = "tag_name",
  [anon_sym_ATextends] = "tag_name",
  [anon_sym_ATtemplate_DASHextends] = "tag_name",
  [anon_sym_ATuse] = "tag_name",
  [anon_sym_ATtemplate_DASHuse] = "tag_name",
  [anon_sym_ATafter] = "tag_name",
  [anon_sym_ATafterClass] = "tag_name",
  [anon_sym_ATannotation] = "tag_name",
  [anon_sym_ATbackupGlobals] = "tag_name",
  [anon_sym_ATbackupStaticAttributes] = "tag_name",
  [anon_sym_ATbefore] = "tag_name",
  [anon_sym_ATbeforeClass] = "tag_name",
  [anon_sym_ATcodeCoverageIgnore] = "tag_name",
  [anon_sym_ATcodeCoverageIgnore_STAR] = "tag_name",
  [anon_sym_ATcodeCoverageIgnoreEnd] = "tag_name",
  [anon_sym_ATcodeCoverageIgnoreStart] = "tag_name",
  [anon_sym_ATcovers] = "tag_name",
  [anon_sym_ATcoversDefaultClass] = "tag_name",
  [anon_sym_ATcoversDefaultClasstoshortenannotations] = "tag_name",
  [anon_sym_ATcoversNothing] = "tag_name",
  [anon_sym_ATdataProvider] = "tag_name",
  [anon_sym_ATdepends] = "tag_name",
  [anon_sym_ATdependsannotationtoexpressdependencies] = "tag_name",
  [anon_sym_ATdoesNotPerformAssertions] = "tag_name",
  [anon_sym_ATgroup] = "tag_name",
  [anon_sym_ATlarge] = "tag_name",
  [anon_sym_ATmedium] = "tag_name",
  [anon_sym_ATpreserveGlobalState] = "tag_name",
  [anon_sym_ATrequires] = "tag_name",
  [anon_sym_ATrequiresusages] = "tag_name",
  [anon_sym_ATrunInSeparateProcess] = "tag_name",
  [anon_sym_ATrunTestsInSeparateProcesses] = "tag_name",
  [anon_sym_ATsmall] = "tag_name",
  [anon_sym_ATtest] = "tag_name",
  [anon_sym_ATtestWith] = "tag_name",
  [anon_sym_ATtestdox] = "tag_name",
  [anon_sym_ATticket] = "tag_name",
  [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = "tag_name",
  [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = "tag_name",
  [anon_sym_ATpsalm_DASHvar] = "tag_name",
  [anon_sym_ATpsalm_DASHparam] = "tag_name",
  [anon_sym_ATpsalm_DASHreturn] = "tag_name",
  [anon_sym_ATpsalm_DASHproperty] = "tag_name",
  [anon_sym_ATpsalm_DASHproperty_DASHread] = "tag_name",
  [anon_sym_ATpsalm_DASHproperty_DASHwrite] = "tag_name",
  [anon_sym_ATpsalm_DASHmethod] = "tag_name",
  [anon_sym_ATpsalm_DASHignore_DASHvar] = "tag_name",
  [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = "tag_name",
  [anon_sym_ATpsalm_DASHthis_DASHout] = "tag_name",
  [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = "tag_name",
  [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = "tag_name",
  [anon_sym_ATpsalm_DASHseal_DASHproperties] = "tag_name",
  [anon_sym_ATpsalm_DASHreadonly] = "tag_name",
  [anon_sym_ATreadonly] = "tag_name",
  [anon_sym_ATpsalm_DASHmutation_DASHfree] = "tag_name",
  [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = "tag_name",
  [anon_sym_ATpsalm_DASHimmutable] = "tag_name",
  [anon_sym_ATpsalm_DASHpure] = "tag_name",
  [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = "tag_name",
  [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = "tag_name",
  [anon_sym_ATpsalm_DASHtrace] = "tag_name",
  [anon_sym_ATno_DASHnamed_DASHarguments] = "tag_name",
  [anon_sym_ATparam_DASHout] = "tag_name",
  [anon_sym_ATpsalm_DASHparam_DASHout] = "tag_name",
  [anon_sym_ATpsalm_DASHassert] = "tag_name",
  [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = "tag_name",
  [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = "tag_name",
  [anon_sym_ATpsalm_DASHimport_DASHtype] = "tag_name",
  [anon_sym_from] = "from",
  [anon_sym_as] = "as",
  [anon_sym_ATpsalm_DASHsuppress] = "tag_name",
  [anon_sym_ATpsalm_DASHinternal] = "tag_name",
  [anon_sym_ATpsalm_DASHrequire_DASHextends] = "tag_name",
  [anon_sym_ATpsalm_DASHrequire_DASHimplements] = "tag_name",
  [anon_sym_ATmixin] = "tag_name",
  [anon_sym_LBRACK_RBRACK] = "[]",
  [anon_sym_COMMA] = ",",
  [anon_sym_list] = "list",
  [anon_sym_array] = "array",
  [anon_sym_SQUOTE] = "'",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym__shaped_array_element_token1] = "name",
  [anon_sym_QMARK] = "\?",
  [anon_sym_COLON] = ":",
  [anon_sym_class_DASHstring] = "class-string",
  [anon_sym_interface_DASHstring] = "interface-string",
  [anon_sym_positive_DASHint] = "positive-int",
  [anon_sym_trait_DASHstring] = "trait-string",
  [anon_sym_enum_DASHstring] = "enum-string",
  [anon_sym_callable_DASHstring] = "callable-string",
  [anon_sym_numeric_DASHstring] = "numeric-string",
  [anon_sym_literal_DASHstring] = "literal-string",
  [anon_sym_lowercase_DASHstring] = "lowercase-string",
  [anon_sym_non_DASHempty_DASHstring] = "non-empty-string",
  [anon_sym_non_DASHempty_DASHlowercase_DASHstring] = "non-empty-lowercase-string",
  [anon_sym_BSLASH] = "\\",
  [aux_sym_relative_name_token1] = "namespace",
  [aux_sym_primitive_type_token1] = "callable",
  [anon_sym_iterable] = "iterable",
  [anon_sym_bool] = "bool",
  [anon_sym_float] = "float",
  [anon_sym_int] = "int",
  [anon_sym_string] = "string",
  [anon_sym_void] = "void",
  [anon_sym_mixed] = "mixed",
  [anon_sym_false] = "false",
  [anon_sym_null] = "null",
  [anon_sym_true] = "true",
  [anon_sym_PIPE] = "|",
  [anon_sym_AMP] = "&",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_DOLLAR] = "$",
  [sym_author_name] = "author_name",
  [sym_email_address] = "email_address",
  [aux_sym_version_token1] = "version_token1",
  [aux_sym_version_token2] = "version_token2",
  [anon_sym_ATpackage_version_AT] = "@package_version@",
  [sym__version_vector] = "_version_vector",
  [sym_uri] = "uri",
  [anon_sym_LPAREN_RPAREN] = "()",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_EQ] = "=",
  [sym_default_value] = "default_value",
  [sym_static] = "static",
  [sym__end] = "_end",
  [sym_text] = "text",
  [sym__text_after_type] = "text",
  [sym__text_in_inline_tag] = "text",
  [sym__text_not_version] = "text",
  [sym_document] = "document",
  [sym_description] = "description",
  [sym__description_after_type] = "_description_after_type",
  [sym__description_not_version] = "_description_not_version",
  [sym__description_in_inline_tag] = "_description_in_inline_tag",
  [sym__description_in_inline_tag_with_nesting] = "_description_in_inline_tag_with_nesting",
  [sym_tag] = "tag",
  [sym_inline_tag] = "inline_tag",
  [sym__tag_without_description] = "_tag_without_description",
  [sym__tag_with_optional_description] = "_tag_with_optional_description",
  [sym__tag_with_required_description] = "_tag_with_required_description",
  [sym__tag_with_incomplete_implementation] = "_tag_with_incomplete_implementation",
  [sym__author_tag] = "_author_tag",
  [sym__global_tag] = "_global_tag",
  [sym__inline_internal_tag] = "_inline_internal_tag",
  [sym__link_tag] = "_link_tag",
  [sym__inline_link_tag] = "_inline_link_tag",
  [sym__method_tag] = "_method_tag",
  [sym__param_tag] = "_param_tag",
  [sym__property_tag] = "_property_tag",
  [sym__return_tag] = "_return_tag",
  [sym__see_tag] = "_see_tag",
  [sym__inline_see_tag] = "_inline_see_tag",
  [sym__throws_tag] = "_throws_tag",
  [sym__var_tag] = "_var_tag",
  [sym__deprecated_tag] = "_deprecated_tag",
  [sym__since_tag] = "_since_tag",
  [sym__version_tag] = "_version_tag",
  [sym__generic_template_tag] = "_generic_template_tag",
  [sym__generic_implements_tag] = "_generic_implements_tag",
  [sym__generic_extends_tag] = "_generic_extends_tag",
  [sym__generic_use_tag] = "_generic_use_tag",
  [sym__phpunit_tag] = "_phpunit_tag",
  [sym__psalm_tag] = "_psalm_tag",
  [sym__mixin_tag] = "_mixin_tag",
  [sym__type] = "_type",
  [sym__types] = "_types",
  [sym__regular_types] = "_regular_types",
  [sym__phpdoc_array_types] = "array_type",
  [sym__psalm_generic_array_types] = "array_type",
  [sym__psalm_list_array_types] = "array_type",
  [sym__psalm_shaped_array_types] = "array_type",
  [sym__shaped_array_element] = "array_element",
  [sym__psalm_scalar_type] = "primitive_type",
  [sym_generic_type] = "generic_type",
  [sym__type_argument_list] = "_type_argument_list",
  [sym__type_argument_named_type] = "_type_argument_named_type",
  [sym_named_type] = "named_type",
  [sym_namespace_name] = "namespace_name",
  [sym_relative_name] = "relative_name",
  [sym_optional_type] = "optional_type",
  [sym_primitive_type] = "primitive_type",
  [sym_qualified_name] = "qualified_name",
  [sym_union_type] = "union_type",
  [sym_intersection_type] = "intersection_type",
  [sym_disjunctive_normal_form_type] = "disjunctive_normal_form_type",
  [sym_variable_name] = "variable_name",
  [sym_version] = "version",
  [sym_fqsen] = "fqsen",
  [sym_parameters] = "parameters",
  [sym_parameter] = "parameter",
  [aux_sym_document_repeat1] = "document_repeat1",
  [aux_sym_description_repeat1] = "description_repeat1",
  [aux_sym__description_after_type_repeat1] = "_description_after_type_repeat1",
  [aux_sym__description_not_version_repeat1] = "_description_not_version_repeat1",
  [aux_sym__description_in_inline_tag_repeat1] = "_description_in_inline_tag_repeat1",
  [aux_sym__description_in_inline_tag_with_nesting_repeat1] = "_description_in_inline_tag_with_nesting_repeat1",
  [aux_sym__phpdoc_array_types_repeat1] = "_phpdoc_array_types_repeat1",
  [aux_sym__psalm_shaped_array_types_repeat1] = "_psalm_shaped_array_types_repeat1",
  [aux_sym__type_argument_list_repeat1] = "_type_argument_list_repeat1",
  [aux_sym__type_argument_list_repeat2] = "_type_argument_list_repeat2",
  [aux_sym_namespace_name_repeat1] = "namespace_name_repeat1",
  [aux_sym_union_type_repeat1] = "union_type_repeat1",
  [aux_sym_intersection_type_repeat1] = "intersection_type_repeat1",
  [aux_sym_disjunctive_normal_form_type_repeat1] = "disjunctive_normal_form_type_repeat1",
  [aux_sym_parameters_repeat1] = "parameters_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_name] = sym_name,
  [sym__begin] = sym__begin,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_ATinheritdoc] = anon_sym_ATinheritdoc,
  [anon_sym_ATinheritDoc] = anon_sym_ATinheritdoc,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_ATapi] = anon_sym_ATinheritdoc,
  [anon_sym_ATfilesource] = anon_sym_ATinheritdoc,
  [anon_sym_ATignore] = anon_sym_ATinheritdoc,
  [anon_sym_ATinternal] = anon_sym_ATinheritdoc,
  [anon_sym_ATcategory] = anon_sym_ATinheritdoc,
  [anon_sym_ATcopyright] = anon_sym_ATinheritdoc,
  [anon_sym_ATtodo] = anon_sym_ATinheritdoc,
  [anon_sym_ATexample] = anon_sym_ATinheritdoc,
  [anon_sym_ATlicense] = anon_sym_ATinheritdoc,
  [anon_sym_ATpackage] = anon_sym_ATinheritdoc,
  [anon_sym_ATsource] = anon_sym_ATinheritdoc,
  [anon_sym_ATsubpackage] = anon_sym_ATinheritdoc,
  [anon_sym_ATuses] = anon_sym_ATinheritdoc,
  [anon_sym_ATauthor] = anon_sym_ATinheritdoc,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_ATglobal] = anon_sym_ATinheritdoc,
  [anon_sym_ATlink] = anon_sym_ATinheritdoc,
  [anon_sym_ATmethod] = anon_sym_ATinheritdoc,
  [anon_sym_ATparam] = anon_sym_ATinheritdoc,
  [anon_sym_ATproperty] = anon_sym_ATinheritdoc,
  [anon_sym_ATproperty_DASHread] = anon_sym_ATinheritdoc,
  [anon_sym_ATproperty_DASHwrite] = anon_sym_ATinheritdoc,
  [anon_sym_ATreturn] = anon_sym_ATinheritdoc,
  [anon_sym_ATsee] = anon_sym_ATinheritdoc,
  [anon_sym_ATthrows] = anon_sym_ATinheritdoc,
  [anon_sym_ATvar] = anon_sym_ATinheritdoc,
  [anon_sym_ATdeprecated] = anon_sym_ATinheritdoc,
  [anon_sym_ATsince] = anon_sym_ATinheritdoc,
  [anon_sym_ATversion] = anon_sym_ATinheritdoc,
  [anon_sym_ATtemplate] = anon_sym_ATinheritdoc,
  [anon_sym_ATpsalm_DASHtemplate] = anon_sym_ATinheritdoc,
  [anon_sym_ATphpstan_DASHtemplate] = anon_sym_ATinheritdoc,
  [anon_sym_of] = anon_sym_of,
  [anon_sym_ATimplements] = anon_sym_ATinheritdoc,
  [anon_sym_ATtemplate_DASHimplements] = anon_sym_ATinheritdoc,
  [anon_sym_ATextends] = anon_sym_ATinheritdoc,
  [anon_sym_ATtemplate_DASHextends] = anon_sym_ATinheritdoc,
  [anon_sym_ATuse] = anon_sym_ATinheritdoc,
  [anon_sym_ATtemplate_DASHuse] = anon_sym_ATinheritdoc,
  [anon_sym_ATafter] = anon_sym_ATinheritdoc,
  [anon_sym_ATafterClass] = anon_sym_ATinheritdoc,
  [anon_sym_ATannotation] = anon_sym_ATinheritdoc,
  [anon_sym_ATbackupGlobals] = anon_sym_ATinheritdoc,
  [anon_sym_ATbackupStaticAttributes] = anon_sym_ATinheritdoc,
  [anon_sym_ATbefore] = anon_sym_ATinheritdoc,
  [anon_sym_ATbeforeClass] = anon_sym_ATinheritdoc,
  [anon_sym_ATcodeCoverageIgnore] = anon_sym_ATinheritdoc,
  [anon_sym_ATcodeCoverageIgnore_STAR] = anon_sym_ATinheritdoc,
  [anon_sym_ATcodeCoverageIgnoreEnd] = anon_sym_ATinheritdoc,
  [anon_sym_ATcodeCoverageIgnoreStart] = anon_sym_ATinheritdoc,
  [anon_sym_ATcovers] = anon_sym_ATinheritdoc,
  [anon_sym_ATcoversDefaultClass] = anon_sym_ATinheritdoc,
  [anon_sym_ATcoversDefaultClasstoshortenannotations] = anon_sym_ATinheritdoc,
  [anon_sym_ATcoversNothing] = anon_sym_ATinheritdoc,
  [anon_sym_ATdataProvider] = anon_sym_ATinheritdoc,
  [anon_sym_ATdepends] = anon_sym_ATinheritdoc,
  [anon_sym_ATdependsannotationtoexpressdependencies] = anon_sym_ATinheritdoc,
  [anon_sym_ATdoesNotPerformAssertions] = anon_sym_ATinheritdoc,
  [anon_sym_ATgroup] = anon_sym_ATinheritdoc,
  [anon_sym_ATlarge] = anon_sym_ATinheritdoc,
  [anon_sym_ATmedium] = anon_sym_ATinheritdoc,
  [anon_sym_ATpreserveGlobalState] = anon_sym_ATinheritdoc,
  [anon_sym_ATrequires] = anon_sym_ATinheritdoc,
  [anon_sym_ATrequiresusages] = anon_sym_ATinheritdoc,
  [anon_sym_ATrunInSeparateProcess] = anon_sym_ATinheritdoc,
  [anon_sym_ATrunTestsInSeparateProcesses] = anon_sym_ATinheritdoc,
  [anon_sym_ATsmall] = anon_sym_ATinheritdoc,
  [anon_sym_ATtest] = anon_sym_ATinheritdoc,
  [anon_sym_ATtestWith] = anon_sym_ATinheritdoc,
  [anon_sym_ATtestdox] = anon_sym_ATinheritdoc,
  [anon_sym_ATticket] = anon_sym_ATinheritdoc,
  [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = anon_sym_ATinheritdoc,
  [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = anon_sym_ATinheritdoc,
  [anon_sym_ATpsalm_DASHvar] = anon_sym_ATinheritdoc,
  [anon_sym_ATpsalm_DASHparam] = anon_sym_ATinheritdoc,
  [anon_sym_ATpsalm_DASHreturn] = anon_sym_ATinheritdoc,
  [anon_sym_ATpsalm_DASHproperty] = anon_sym_ATinheritdoc,
  [anon_sym_ATpsalm_DASHproperty_DASHread] = anon_sym_ATinheritdoc,
  [anon_sym_ATpsalm_DASHproperty_DASHwrite] = anon_sym_ATinheritdoc,
  [anon_sym_ATpsalm_DASHmethod] = anon_sym_ATinheritdoc,
  [anon_sym_ATpsalm_DASHignore_DASHvar] = anon_sym_ATinheritdoc,
  [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = anon_sym_ATinheritdoc,
  [anon_sym_ATpsalm_DASHthis_DASHout] = anon_sym_ATinheritdoc,
  [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = anon_sym_ATinheritdoc,
  [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = anon_sym_ATinheritdoc,
  [anon_sym_ATpsalm_DASHseal_DASHproperties] = anon_sym_ATinheritdoc,
  [anon_sym_ATpsalm_DASHreadonly] = anon_sym_ATinheritdoc,
  [anon_sym_ATreadonly] = anon_sym_ATinheritdoc,
  [anon_sym_ATpsalm_DASHmutation_DASHfree] = anon_sym_ATinheritdoc,
  [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = anon_sym_ATinheritdoc,
  [anon_sym_ATpsalm_DASHimmutable] = anon_sym_ATinheritdoc,
  [anon_sym_ATpsalm_DASHpure] = anon_sym_ATinheritdoc,
  [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = anon_sym_ATinheritdoc,
  [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = anon_sym_ATinheritdoc,
  [anon_sym_ATpsalm_DASHtrace] = anon_sym_ATinheritdoc,
  [anon_sym_ATno_DASHnamed_DASHarguments] = anon_sym_ATinheritdoc,
  [anon_sym_ATparam_DASHout] = anon_sym_ATinheritdoc,
  [anon_sym_ATpsalm_DASHparam_DASHout] = anon_sym_ATinheritdoc,
  [anon_sym_ATpsalm_DASHassert] = anon_sym_ATinheritdoc,
  [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = anon_sym_ATinheritdoc,
  [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = anon_sym_ATinheritdoc,
  [anon_sym_ATpsalm_DASHimport_DASHtype] = anon_sym_ATinheritdoc,
  [anon_sym_from] = anon_sym_from,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_ATpsalm_DASHsuppress] = anon_sym_ATinheritdoc,
  [anon_sym_ATpsalm_DASHinternal] = anon_sym_ATinheritdoc,
  [anon_sym_ATpsalm_DASHrequire_DASHextends] = anon_sym_ATinheritdoc,
  [anon_sym_ATpsalm_DASHrequire_DASHimplements] = anon_sym_ATinheritdoc,
  [anon_sym_ATmixin] = anon_sym_ATinheritdoc,
  [anon_sym_LBRACK_RBRACK] = anon_sym_LBRACK_RBRACK,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_list] = anon_sym_list,
  [anon_sym_array] = anon_sym_array,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym__shaped_array_element_token1] = sym_name,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_class_DASHstring] = anon_sym_class_DASHstring,
  [anon_sym_interface_DASHstring] = anon_sym_interface_DASHstring,
  [anon_sym_positive_DASHint] = anon_sym_positive_DASHint,
  [anon_sym_trait_DASHstring] = anon_sym_trait_DASHstring,
  [anon_sym_enum_DASHstring] = anon_sym_enum_DASHstring,
  [anon_sym_callable_DASHstring] = anon_sym_callable_DASHstring,
  [anon_sym_numeric_DASHstring] = anon_sym_numeric_DASHstring,
  [anon_sym_literal_DASHstring] = anon_sym_literal_DASHstring,
  [anon_sym_lowercase_DASHstring] = anon_sym_lowercase_DASHstring,
  [anon_sym_non_DASHempty_DASHstring] = anon_sym_non_DASHempty_DASHstring,
  [anon_sym_non_DASHempty_DASHlowercase_DASHstring] = anon_sym_non_DASHempty_DASHlowercase_DASHstring,
  [anon_sym_BSLASH] = anon_sym_BSLASH,
  [aux_sym_relative_name_token1] = aux_sym_relative_name_token1,
  [aux_sym_primitive_type_token1] = aux_sym_primitive_type_token1,
  [anon_sym_iterable] = anon_sym_iterable,
  [anon_sym_bool] = anon_sym_bool,
  [anon_sym_float] = anon_sym_float,
  [anon_sym_int] = anon_sym_int,
  [anon_sym_string] = anon_sym_string,
  [anon_sym_void] = anon_sym_void,
  [anon_sym_mixed] = anon_sym_mixed,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_null] = anon_sym_null,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [sym_author_name] = sym_author_name,
  [sym_email_address] = sym_email_address,
  [aux_sym_version_token1] = aux_sym_version_token1,
  [aux_sym_version_token2] = aux_sym_version_token2,
  [anon_sym_ATpackage_version_AT] = anon_sym_ATpackage_version_AT,
  [sym__version_vector] = sym__version_vector,
  [sym_uri] = sym_uri,
  [anon_sym_LPAREN_RPAREN] = anon_sym_LPAREN_RPAREN,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_EQ] = anon_sym_EQ,
  [sym_default_value] = sym_default_value,
  [sym_static] = sym_static,
  [sym__end] = sym__end,
  [sym_text] = sym_text,
  [sym__text_after_type] = sym_text,
  [sym__text_in_inline_tag] = sym_text,
  [sym__text_not_version] = sym_text,
  [sym_document] = sym_document,
  [sym_description] = sym_description,
  [sym__description_after_type] = sym__description_after_type,
  [sym__description_not_version] = sym__description_not_version,
  [sym__description_in_inline_tag] = sym__description_in_inline_tag,
  [sym__description_in_inline_tag_with_nesting] = sym__description_in_inline_tag_with_nesting,
  [sym_tag] = sym_tag,
  [sym_inline_tag] = sym_inline_tag,
  [sym__tag_without_description] = sym__tag_without_description,
  [sym__tag_with_optional_description] = sym__tag_with_optional_description,
  [sym__tag_with_required_description] = sym__tag_with_required_description,
  [sym__tag_with_incomplete_implementation] = sym__tag_with_incomplete_implementation,
  [sym__author_tag] = sym__author_tag,
  [sym__global_tag] = sym__global_tag,
  [sym__inline_internal_tag] = sym__inline_internal_tag,
  [sym__link_tag] = sym__link_tag,
  [sym__inline_link_tag] = sym__inline_link_tag,
  [sym__method_tag] = sym__method_tag,
  [sym__param_tag] = sym__param_tag,
  [sym__property_tag] = sym__property_tag,
  [sym__return_tag] = sym__return_tag,
  [sym__see_tag] = sym__see_tag,
  [sym__inline_see_tag] = sym__inline_see_tag,
  [sym__throws_tag] = sym__throws_tag,
  [sym__var_tag] = sym__var_tag,
  [sym__deprecated_tag] = sym__deprecated_tag,
  [sym__since_tag] = sym__since_tag,
  [sym__version_tag] = sym__version_tag,
  [sym__generic_template_tag] = sym__generic_template_tag,
  [sym__generic_implements_tag] = sym__generic_implements_tag,
  [sym__generic_extends_tag] = sym__generic_extends_tag,
  [sym__generic_use_tag] = sym__generic_use_tag,
  [sym__phpunit_tag] = sym__phpunit_tag,
  [sym__psalm_tag] = sym__psalm_tag,
  [sym__mixin_tag] = sym__mixin_tag,
  [sym__type] = sym__type,
  [sym__types] = sym__types,
  [sym__regular_types] = sym__regular_types,
  [sym__phpdoc_array_types] = sym__phpdoc_array_types,
  [sym__psalm_generic_array_types] = sym__phpdoc_array_types,
  [sym__psalm_list_array_types] = sym__phpdoc_array_types,
  [sym__psalm_shaped_array_types] = sym__phpdoc_array_types,
  [sym__shaped_array_element] = sym__shaped_array_element,
  [sym__psalm_scalar_type] = sym_primitive_type,
  [sym_generic_type] = sym_generic_type,
  [sym__type_argument_list] = sym__type_argument_list,
  [sym__type_argument_named_type] = sym__type_argument_named_type,
  [sym_named_type] = sym_named_type,
  [sym_namespace_name] = sym_namespace_name,
  [sym_relative_name] = sym_relative_name,
  [sym_optional_type] = sym_optional_type,
  [sym_primitive_type] = sym_primitive_type,
  [sym_qualified_name] = sym_qualified_name,
  [sym_union_type] = sym_union_type,
  [sym_intersection_type] = sym_intersection_type,
  [sym_disjunctive_normal_form_type] = sym_disjunctive_normal_form_type,
  [sym_variable_name] = sym_variable_name,
  [sym_version] = sym_version,
  [sym_fqsen] = sym_fqsen,
  [sym_parameters] = sym_parameters,
  [sym_parameter] = sym_parameter,
  [aux_sym_document_repeat1] = aux_sym_document_repeat1,
  [aux_sym_description_repeat1] = aux_sym_description_repeat1,
  [aux_sym__description_after_type_repeat1] = aux_sym__description_after_type_repeat1,
  [aux_sym__description_not_version_repeat1] = aux_sym__description_not_version_repeat1,
  [aux_sym__description_in_inline_tag_repeat1] = aux_sym__description_in_inline_tag_repeat1,
  [aux_sym__description_in_inline_tag_with_nesting_repeat1] = aux_sym__description_in_inline_tag_with_nesting_repeat1,
  [aux_sym__phpdoc_array_types_repeat1] = aux_sym__phpdoc_array_types_repeat1,
  [aux_sym__psalm_shaped_array_types_repeat1] = aux_sym__psalm_shaped_array_types_repeat1,
  [aux_sym__type_argument_list_repeat1] = aux_sym__type_argument_list_repeat1,
  [aux_sym__type_argument_list_repeat2] = aux_sym__type_argument_list_repeat2,
  [aux_sym_namespace_name_repeat1] = aux_sym_namespace_name_repeat1,
  [aux_sym_union_type_repeat1] = aux_sym_union_type_repeat1,
  [aux_sym_intersection_type_repeat1] = aux_sym_intersection_type_repeat1,
  [aux_sym_disjunctive_normal_form_type_repeat1] = aux_sym_disjunctive_normal_form_type_repeat1,
  [aux_sym_parameters_repeat1] = aux_sym_parameters_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_name] = {
    .visible = true,
    .named = true,
  },
  [sym__begin] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATinheritdoc] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATinheritDoc] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATapi] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATfilesource] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATignore] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATinternal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATcategory] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATcopyright] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATtodo] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATexample] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATlicense] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATpackage] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATsource] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATsubpackage] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATuses] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATauthor] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATglobal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATlink] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATmethod] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATparam] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATproperty] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATproperty_DASHread] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATproperty_DASHwrite] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATreturn] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATsee] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATthrows] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATvar] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATdeprecated] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATsince] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATversion] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATtemplate] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATpsalm_DASHtemplate] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATphpstan_DASHtemplate] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_of] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATimplements] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATtemplate_DASHimplements] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATextends] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATtemplate_DASHextends] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATuse] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATtemplate_DASHuse] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATafter] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATafterClass] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATannotation] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATbackupGlobals] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATbackupStaticAttributes] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATbefore] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATbeforeClass] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATcodeCoverageIgnore] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATcodeCoverageIgnore_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATcodeCoverageIgnoreEnd] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATcodeCoverageIgnoreStart] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATcovers] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATcoversDefaultClass] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATcoversDefaultClasstoshortenannotations] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATcoversNothing] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATdataProvider] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATdepends] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATdependsannotationtoexpressdependencies] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATdoesNotPerformAssertions] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATgroup] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATlarge] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATmedium] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATpreserveGlobalState] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATrequires] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATrequiresusages] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATrunInSeparateProcess] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATrunTestsInSeparateProcesses] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATsmall] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATtest] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATtestWith] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATtestdox] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATticket] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATpsalm_DASHvar] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATpsalm_DASHparam] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATpsalm_DASHreturn] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATpsalm_DASHproperty] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATpsalm_DASHproperty_DASHread] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATpsalm_DASHproperty_DASHwrite] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATpsalm_DASHmethod] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATpsalm_DASHignore_DASHvar] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATpsalm_DASHthis_DASHout] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATpsalm_DASHseal_DASHproperties] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATpsalm_DASHreadonly] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATreadonly] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATpsalm_DASHmutation_DASHfree] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATpsalm_DASHimmutable] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATpsalm_DASHpure] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATpsalm_DASHtrace] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATno_DASHnamed_DASHarguments] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATparam_DASHout] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATpsalm_DASHparam_DASHout] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATpsalm_DASHassert] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATpsalm_DASHimport_DASHtype] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATpsalm_DASHsuppress] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATpsalm_DASHinternal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATpsalm_DASHrequire_DASHextends] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATpsalm_DASHrequire_DASHimplements] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATmixin] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACK_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_list] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_array] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__shaped_array_element_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class_DASHstring] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_interface_DASHstring] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_positive_DASHint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_trait_DASHstring] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum_DASHstring] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_callable_DASHstring] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_numeric_DASHstring] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_literal_DASHstring] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_lowercase_DASHstring] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_non_DASHempty_DASHstring] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_non_DASHempty_DASHlowercase_DASHstring] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_relative_name_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_primitive_type_token1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iterable] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bool] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_float] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_string] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_void] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mixed] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_null] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [sym_author_name] = {
    .visible = true,
    .named = true,
  },
  [sym_email_address] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_version_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_version_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_ATpackage_version_AT] = {
    .visible = true,
    .named = false,
  },
  [sym__version_vector] = {
    .visible = false,
    .named = true,
  },
  [sym_uri] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [sym_default_value] = {
    .visible = true,
    .named = true,
  },
  [sym_static] = {
    .visible = true,
    .named = true,
  },
  [sym__end] = {
    .visible = false,
    .named = true,
  },
  [sym_text] = {
    .visible = true,
    .named = true,
  },
  [sym__text_after_type] = {
    .visible = true,
    .named = true,
  },
  [sym__text_in_inline_tag] = {
    .visible = true,
    .named = true,
  },
  [sym__text_not_version] = {
    .visible = true,
    .named = true,
  },
  [sym_document] = {
    .visible = true,
    .named = true,
  },
  [sym_description] = {
    .visible = true,
    .named = true,
  },
  [sym__description_after_type] = {
    .visible = false,
    .named = true,
  },
  [sym__description_not_version] = {
    .visible = false,
    .named = true,
  },
  [sym__description_in_inline_tag] = {
    .visible = false,
    .named = true,
  },
  [sym__description_in_inline_tag_with_nesting] = {
    .visible = false,
    .named = true,
  },
  [sym_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_inline_tag] = {
    .visible = true,
    .named = true,
  },
  [sym__tag_without_description] = {
    .visible = false,
    .named = true,
  },
  [sym__tag_with_optional_description] = {
    .visible = false,
    .named = true,
  },
  [sym__tag_with_required_description] = {
    .visible = false,
    .named = true,
  },
  [sym__tag_with_incomplete_implementation] = {
    .visible = false,
    .named = true,
  },
  [sym__author_tag] = {
    .visible = false,
    .named = true,
  },
  [sym__global_tag] = {
    .visible = false,
    .named = true,
  },
  [sym__inline_internal_tag] = {
    .visible = false,
    .named = true,
  },
  [sym__link_tag] = {
    .visible = false,
    .named = true,
  },
  [sym__inline_link_tag] = {
    .visible = false,
    .named = true,
  },
  [sym__method_tag] = {
    .visible = false,
    .named = true,
  },
  [sym__param_tag] = {
    .visible = false,
    .named = true,
  },
  [sym__property_tag] = {
    .visible = false,
    .named = true,
  },
  [sym__return_tag] = {
    .visible = false,
    .named = true,
  },
  [sym__see_tag] = {
    .visible = false,
    .named = true,
  },
  [sym__inline_see_tag] = {
    .visible = false,
    .named = true,
  },
  [sym__throws_tag] = {
    .visible = false,
    .named = true,
  },
  [sym__var_tag] = {
    .visible = false,
    .named = true,
  },
  [sym__deprecated_tag] = {
    .visible = false,
    .named = true,
  },
  [sym__since_tag] = {
    .visible = false,
    .named = true,
  },
  [sym__version_tag] = {
    .visible = false,
    .named = true,
  },
  [sym__generic_template_tag] = {
    .visible = false,
    .named = true,
  },
  [sym__generic_implements_tag] = {
    .visible = false,
    .named = true,
  },
  [sym__generic_extends_tag] = {
    .visible = false,
    .named = true,
  },
  [sym__generic_use_tag] = {
    .visible = false,
    .named = true,
  },
  [sym__phpunit_tag] = {
    .visible = false,
    .named = true,
  },
  [sym__psalm_tag] = {
    .visible = false,
    .named = true,
  },
  [sym__mixin_tag] = {
    .visible = false,
    .named = true,
  },
  [sym__type] = {
    .visible = false,
    .named = true,
  },
  [sym__types] = {
    .visible = false,
    .named = true,
  },
  [sym__regular_types] = {
    .visible = false,
    .named = true,
  },
  [sym__phpdoc_array_types] = {
    .visible = true,
    .named = true,
  },
  [sym__psalm_generic_array_types] = {
    .visible = true,
    .named = true,
  },
  [sym__psalm_list_array_types] = {
    .visible = true,
    .named = true,
  },
  [sym__psalm_shaped_array_types] = {
    .visible = true,
    .named = true,
  },
  [sym__shaped_array_element] = {
    .visible = true,
    .named = true,
  },
  [sym__psalm_scalar_type] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_type] = {
    .visible = true,
    .named = true,
  },
  [sym__type_argument_list] = {
    .visible = false,
    .named = true,
  },
  [sym__type_argument_named_type] = {
    .visible = false,
    .named = true,
  },
  [sym_named_type] = {
    .visible = true,
    .named = true,
  },
  [sym_namespace_name] = {
    .visible = true,
    .named = true,
  },
  [sym_relative_name] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_type] = {
    .visible = true,
    .named = true,
  },
  [sym_primitive_type] = {
    .visible = true,
    .named = true,
  },
  [sym_qualified_name] = {
    .visible = true,
    .named = true,
  },
  [sym_union_type] = {
    .visible = true,
    .named = true,
  },
  [sym_intersection_type] = {
    .visible = true,
    .named = true,
  },
  [sym_disjunctive_normal_form_type] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_name] = {
    .visible = true,
    .named = true,
  },
  [sym_version] = {
    .visible = true,
    .named = true,
  },
  [sym_fqsen] = {
    .visible = true,
    .named = true,
  },
  [sym_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_document_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_description_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__description_after_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__description_not_version_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__description_in_inline_tag_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__description_in_inline_tag_with_nesting_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__phpdoc_array_types_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__psalm_shaped_array_types_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__type_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__type_argument_list_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_namespace_name_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_union_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_intersection_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_disjunctive_normal_form_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum ts_field_identifiers {
  field_array = 1,
  field_key = 2,
  field_prefix = 3,
  field_value = 4,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_array] = "array",
  [field_key] = "key",
  [field_prefix] = "prefix",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 3},
  [2] = {.index = 3, .length = 2},
  [4] = {.index = 5, .length = 1},
  [5] = {.index = 6, .length = 1},
  [6] = {.index = 7, .length = 2},
  [7] = {.index = 9, .length = 2},
  [8] = {.index = 11, .length = 2},
  [9] = {.index = 13, .length = 3},
  [10] = {.index = 11, .length = 2},
  [11] = {.index = 16, .length = 3},
  [12] = {.index = 19, .length = 2},
  [13] = {.index = 21, .length = 4},
  [14] = {.index = 25, .length = 4},
  [15] = {.index = 29, .length = 3},
  [16] = {.index = 32, .length = 5},
  [17] = {.index = 37, .length = 6},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_array, 0, .inherited = true},
    {field_key, 0, .inherited = true},
    {field_value, 0, .inherited = true},
  [3] =
    {field_array, 0, .inherited = true},
    {field_value, 0, .inherited = true},
  [5] =
    {field_prefix, 0},
  [6] =
    {field_value, 0},
  [7] =
    {field_prefix, 0},
    {field_prefix, 1},
  [9] =
    {field_key, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [11] =
    {field_array, 0},
    {field_value, 2},
  [13] =
    {field_prefix, 0},
    {field_prefix, 1},
    {field_prefix, 2},
  [16] =
    {field_key, 0},
    {field_key, 1},
    {field_value, 2},
  [19] =
    {field_key, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [21] =
    {field_prefix, 0},
    {field_prefix, 1},
    {field_prefix, 2},
    {field_prefix, 3},
  [25] =
    {field_key, 0},
    {field_key, 1},
    {field_key, 2},
    {field_value, 3},
  [29] =
    {field_array, 0},
    {field_key, 2},
    {field_value, 4},
  [32] =
    {field_key, 0},
    {field_key, 1},
    {field_key, 2},
    {field_key, 3},
    {field_value, 4},
  [37] =
    {field_key, 0},
    {field_key, 1},
    {field_key, 2},
    {field_key, 3},
    {field_key, 4},
    {field_value, 5},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [3] = {
    [0] = sym_description,
  },
  [8] = {
    [0] = sym_primitive_type,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  aux_sym__description_after_type_repeat1, 2,
    aux_sym__description_after_type_repeat1,
    sym_description,
  aux_sym__description_not_version_repeat1, 2,
    aux_sym__description_not_version_repeat1,
    sym_description,
  aux_sym__description_in_inline_tag_repeat1, 2,
    aux_sym__description_in_inline_tag_repeat1,
    sym_description,
  aux_sym__description_in_inline_tag_with_nesting_repeat1, 2,
    aux_sym__description_in_inline_tag_with_nesting_repeat1,
    sym_description,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 17,
  [28] = 17,
  [29] = 8,
  [30] = 30,
  [31] = 7,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 19,
  [36] = 20,
  [37] = 37,
  [38] = 30,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 13,
  [47] = 24,
  [48] = 9,
  [49] = 21,
  [50] = 50,
  [51] = 15,
  [52] = 52,
  [53] = 10,
  [54] = 14,
  [55] = 11,
  [56] = 16,
  [57] = 12,
  [58] = 18,
  [59] = 19,
  [60] = 25,
  [61] = 61,
  [62] = 26,
  [63] = 22,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 8,
  [71] = 7,
  [72] = 72,
  [73] = 42,
  [74] = 74,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 37,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 39,
  [90] = 44,
  [91] = 91,
  [92] = 66,
  [93] = 50,
  [94] = 72,
  [95] = 33,
  [96] = 96,
  [97] = 97,
  [98] = 69,
  [99] = 19,
  [100] = 43,
  [101] = 40,
  [102] = 102,
  [103] = 32,
  [104] = 104,
  [105] = 64,
  [106] = 65,
  [107] = 61,
  [108] = 108,
  [109] = 67,
  [110] = 110,
  [111] = 45,
  [112] = 41,
  [113] = 13,
  [114] = 114,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 9,
  [119] = 108,
  [120] = 74,
  [121] = 121,
  [122] = 12,
  [123] = 68,
  [124] = 124,
  [125] = 80,
  [126] = 104,
  [127] = 127,
  [128] = 16,
  [129] = 15,
  [130] = 14,
  [131] = 131,
  [132] = 11,
  [133] = 10,
  [134] = 134,
  [135] = 135,
  [136] = 136,
  [137] = 137,
  [138] = 138,
  [139] = 139,
  [140] = 140,
  [141] = 131,
  [142] = 142,
  [143] = 135,
  [144] = 135,
  [145] = 145,
  [146] = 146,
  [147] = 147,
  [148] = 148,
  [149] = 149,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 167,
  [168] = 168,
  [169] = 169,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 183,
  [184] = 184,
  [185] = 185,
  [186] = 186,
  [187] = 187,
  [188] = 188,
  [189] = 188,
  [190] = 188,
  [191] = 191,
  [192] = 188,
  [193] = 193,
  [194] = 194,
  [195] = 195,
  [196] = 193,
  [197] = 193,
  [198] = 193,
  [199] = 199,
  [200] = 200,
  [201] = 201,
  [202] = 202,
  [203] = 203,
  [204] = 204,
  [205] = 205,
  [206] = 206,
  [207] = 207,
  [208] = 208,
  [209] = 209,
  [210] = 210,
  [211] = 211,
  [212] = 212,
  [213] = 213,
  [214] = 214,
  [215] = 215,
  [216] = 213,
  [217] = 217,
  [218] = 215,
  [219] = 214,
  [220] = 217,
  [221] = 221,
  [222] = 222,
  [223] = 223,
  [224] = 224,
  [225] = 222,
  [226] = 224,
  [227] = 223,
  [228] = 228,
  [229] = 221,
  [230] = 228,
  [231] = 231,
  [232] = 232,
  [233] = 233,
  [234] = 233,
  [235] = 235,
  [236] = 236,
  [237] = 237,
  [238] = 238,
  [239] = 239,
  [240] = 239,
  [241] = 239,
  [242] = 242,
  [243] = 243,
  [244] = 244,
  [245] = 245,
  [246] = 246,
  [247] = 247,
  [248] = 248,
  [249] = 248,
  [250] = 248,
  [251] = 248,
  [252] = 34,
  [253] = 253,
  [254] = 254,
  [255] = 255,
  [256] = 256,
  [257] = 257,
  [258] = 257,
  [259] = 259,
  [260] = 7,
  [261] = 8,
  [262] = 262,
  [263] = 263,
  [264] = 19,
  [265] = 265,
  [266] = 266,
  [267] = 12,
  [268] = 13,
  [269] = 269,
  [270] = 270,
  [271] = 9,
  [272] = 272,
  [273] = 273,
  [274] = 274,
  [275] = 275,
  [276] = 276,
  [277] = 277,
  [278] = 278,
  [279] = 279,
  [280] = 276,
  [281] = 134,
  [282] = 276,
  [283] = 278,
  [284] = 279,
  [285] = 285,
  [286] = 276,
  [287] = 275,
  [288] = 288,
  [289] = 278,
  [290] = 279,
  [291] = 291,
  [292] = 288,
  [293] = 10,
  [294] = 15,
  [295] = 295,
  [296] = 14,
  [297] = 279,
  [298] = 298,
  [299] = 11,
  [300] = 300,
  [301] = 278,
  [302] = 302,
  [303] = 303,
  [304] = 304,
  [305] = 127,
  [306] = 135,
  [307] = 285,
  [308] = 16,
  [309] = 309,
  [310] = 310,
  [311] = 311,
  [312] = 312,
  [313] = 313,
  [314] = 142,
  [315] = 315,
  [316] = 316,
  [317] = 317,
  [318] = 318,
  [319] = 319,
  [320] = 320,
  [321] = 321,
  [322] = 137,
  [323] = 323,
  [324] = 150,
  [325] = 320,
  [326] = 326,
  [327] = 320,
  [328] = 328,
  [329] = 329,
  [330] = 330,
  [331] = 131,
  [332] = 332,
  [333] = 333,
  [334] = 334,
  [335] = 330,
  [336] = 320,
  [337] = 337,
  [338] = 338,
  [339] = 339,
  [340] = 311,
  [341] = 341,
  [342] = 136,
  [343] = 343,
  [344] = 344,
  [345] = 345,
  [346] = 346,
  [347] = 347,
  [348] = 348,
  [349] = 349,
  [350] = 350,
  [351] = 351,
  [352] = 352,
  [353] = 353,
  [354] = 354,
  [355] = 355,
  [356] = 356,
  [357] = 357,
  [358] = 358,
  [359] = 359,
  [360] = 355,
  [361] = 361,
  [362] = 362,
  [363] = 363,
  [364] = 364,
  [365] = 358,
  [366] = 363,
  [367] = 367,
  [368] = 368,
  [369] = 364,
  [370] = 353,
  [371] = 371,
  [372] = 372,
  [373] = 355,
  [374] = 367,
  [375] = 357,
  [376] = 368,
  [377] = 377,
  [378] = 378,
  [379] = 363,
  [380] = 380,
  [381] = 367,
  [382] = 353,
  [383] = 357,
  [384] = 384,
  [385] = 357,
  [386] = 386,
  [387] = 362,
  [388] = 388,
  [389] = 363,
  [390] = 361,
  [391] = 367,
  [392] = 392,
  [393] = 351,
  [394] = 394,
  [395] = 354,
  [396] = 396,
  [397] = 397,
  [398] = 398,
  [399] = 380,
  [400] = 400,
  [401] = 343,
  [402] = 402,
  [403] = 353,
  [404] = 404,
  [405] = 351,
  [406] = 354,
  [407] = 380,
  [408] = 343,
  [409] = 409,
  [410] = 351,
  [411] = 354,
  [412] = 380,
  [413] = 343,
  [414] = 414,
};

static TSCharacterRange sym_name_character_set_1[] = {
  {'0', '9'}, {'A', 'Z'}, {'_', '_'}, {'a', 'z'}, {0x80, 0x9f}, {0xa1, 0x200a}, {0x200c, 0x205f}, {0x2061, 0xfefe},
  {0xff00, 0xffff},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(911);
      if (lookahead == '\n') SKIP(910);
      if (lookahead == '\r') SKIP(0);
      if (lookahead == '"') ADVANCE(1028);
      if (lookahead == '$') ADVANCE(1132);
      if (lookahead == '&') ADVANCE(1129);
      if (lookahead == '\'') ADVANCE(1027);
      if (lookahead == '(') ADVANCE(1130);
      if (lookahead == ')') ADVANCE(1131);
      if (lookahead == '*') ADVANCE(55);
      if (lookahead == ',') ADVANCE(1026);
      if (lookahead == '/') ADVANCE(27);
      if (lookahead == ':') ADVANCE(1033);
      if (lookahead == '<') ADVANCE(932);
      if (lookahead == '=') ADVANCE(1146);
      if (lookahead == '>') ADVANCE(933);
      if (lookahead == '?') ADVANCE(1031);
      if (lookahead == '@') ADVANCE(82);
      if (lookahead == 'C') ADVANCE(1112);
      if (lookahead == 'N') ADVANCE(1113);
      if (lookahead == '[') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(1127);
      if (lookahead == 'c') ADVANCE(1057);
      if (lookahead == 'e') ADVANCE(1088);
      if (lookahead == 'h') ADVANCE(1105);
      if (lookahead == 'i') ADVANCE(1090);
      if (lookahead == 'l') ADVANCE(1082);
      if (lookahead == 'n') ADVANCE(1092);
      if (lookahead == 'p') ADVANCE(1091);
      if (lookahead == 't') ADVANCE(1096);
      if (lookahead == '{') ADVANCE(913);
      if (lookahead == '|') ADVANCE(1128);
      if (lookahead == '}') ADVANCE(916);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(0);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1029);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(1);
      if (lookahead == '\r') SKIP(2);
      if (lookahead == '"') ADVANCE(1028);
      if (lookahead == '$') ADVANCE(1132);
      if (lookahead == '&') ADVANCE(1129);
      if (lookahead == '\'') ADVANCE(1027);
      if (lookahead == '(') ADVANCE(1130);
      if (lookahead == ')') ADVANCE(1131);
      if (lookahead == '*') SKIP(1);
      if (lookahead == ',') ADVANCE(1026);
      if (lookahead == '/') ADVANCE(27);
      if (lookahead == ':') ADVANCE(1032);
      if (lookahead == '<') ADVANCE(932);
      if (lookahead == '>') ADVANCE(933);
      if (lookahead == '?') ADVANCE(1031);
      if (lookahead == 'C') ADVANCE(1112);
      if (lookahead == 'N') ADVANCE(1113);
      if (lookahead == '[') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(1127);
      if (lookahead == 'c') ADVANCE(1057);
      if (lookahead == 'e') ADVANCE(1088);
      if (lookahead == 'i') ADVANCE(1090);
      if (lookahead == 'l') ADVANCE(1082);
      if (lookahead == 'n') ADVANCE(1092);
      if (lookahead == 'p') ADVANCE(1091);
      if (lookahead == 't') ADVANCE(1096);
      if (lookahead == '|') ADVANCE(1128);
      if (lookahead == '}') ADVANCE(916);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(1);
      if (lookahead == 0x0b ||
          lookahead == '\f') SKIP(2);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1030);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(1);
      if (lookahead == '\r') SKIP(2);
      if (lookahead == '"') ADVANCE(1028);
      if (lookahead == '$') ADVANCE(1132);
      if (lookahead == '&') ADVANCE(1129);
      if (lookahead == '\'') ADVANCE(1027);
      if (lookahead == '(') ADVANCE(1130);
      if (lookahead == ')') ADVANCE(1131);
      if (lookahead == ',') ADVANCE(1026);
      if (lookahead == '/') ADVANCE(27);
      if (lookahead == ':') ADVANCE(1032);
      if (lookahead == '<') ADVANCE(932);
      if (lookahead == '>') ADVANCE(933);
      if (lookahead == '?') ADVANCE(1031);
      if (lookahead == 'C') ADVANCE(1112);
      if (lookahead == 'N') ADVANCE(1113);
      if (lookahead == '[') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(1127);
      if (lookahead == 'c') ADVANCE(1057);
      if (lookahead == 'e') ADVANCE(1088);
      if (lookahead == 'i') ADVANCE(1090);
      if (lookahead == 'l') ADVANCE(1082);
      if (lookahead == 'n') ADVANCE(1092);
      if (lookahead == 'p') ADVANCE(1091);
      if (lookahead == 't') ADVANCE(1096);
      if (lookahead == '|') ADVANCE(1128);
      if (lookahead == '}') ADVANCE(916);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(2);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1030);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(5);
      if (lookahead == '\r') SKIP(3);
      if (lookahead == '$') ADVANCE(1132);
      if (lookahead == '&') ADVANCE(1129);
      if (lookahead == '(') ADVANCE(25);
      if (lookahead == ')') ADVANCE(1131);
      if (lookahead == '*') ADVANCE(55);
      if (lookahead == ',') ADVANCE(1026);
      if (lookahead == ':') ADVANCE(58);
      if (lookahead == '<') ADVANCE(932);
      if (lookahead == '=') ADVANCE(1146);
      if (lookahead == '>') ADVANCE(933);
      if (lookahead == '@') ADVANCE(83);
      if (lookahead == '[') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(1127);
      if (lookahead == '{') ADVANCE(913);
      if (lookahead == '|') ADVANCE(1128);
      if (lookahead == '}') ADVANCE(916);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(3);
      if ((set_contains(sym_name_character_set_1, 9, lookahead)) &&
          (lookahead < '0' || '9' < lookahead)) ADVANCE(1126);
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(5);
      if (lookahead == '\r') SKIP(3);
      if (lookahead == '$') ADVANCE(1132);
      if (lookahead == '&') ADVANCE(1129);
      if (lookahead == '(') ADVANCE(25);
      if (lookahead == ')') ADVANCE(1131);
      if (lookahead == '*') ADVANCE(4);
      if (lookahead == ',') ADVANCE(1026);
      if (lookahead == '/') ADVANCE(1150);
      if (lookahead == ':') ADVANCE(58);
      if (lookahead == '<') ADVANCE(932);
      if (lookahead == '=') ADVANCE(1146);
      if (lookahead == '>') ADVANCE(933);
      if (lookahead == '@') ADVANCE(83);
      if (lookahead == '[') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(1127);
      if (lookahead == '{') ADVANCE(913);
      if (lookahead == '|') ADVANCE(1128);
      if (lookahead == '}') ADVANCE(916);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(5);
      if (lookahead == 0x0b ||
          lookahead == '\f') SKIP(3);
      if ((set_contains(sym_name_character_set_1, 9, lookahead)) &&
          (lookahead < '0' || '9' < lookahead)) ADVANCE(1126);
      END_STATE();
    case 5:
      if (lookahead == '\n') SKIP(5);
      if (lookahead == '\r') SKIP(3);
      if (lookahead == '$') ADVANCE(1132);
      if (lookahead == '&') ADVANCE(1129);
      if (lookahead == '(') ADVANCE(25);
      if (lookahead == ')') ADVANCE(1131);
      if (lookahead == '*') ADVANCE(4);
      if (lookahead == ',') ADVANCE(1026);
      if (lookahead == ':') ADVANCE(58);
      if (lookahead == '<') ADVANCE(932);
      if (lookahead == '=') ADVANCE(1146);
      if (lookahead == '>') ADVANCE(933);
      if (lookahead == '@') ADVANCE(83);
      if (lookahead == '[') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(1127);
      if (lookahead == '{') ADVANCE(913);
      if (lookahead == '|') ADVANCE(1128);
      if (lookahead == '}') ADVANCE(916);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(5);
      if (lookahead == 0x0b ||
          lookahead == '\f') SKIP(3);
      if ((set_contains(sym_name_character_set_1, 9, lookahead)) &&
          (lookahead < '0' || '9' < lookahead)) ADVANCE(1126);
      END_STATE();
    case 6:
      if (lookahead == '\n') SKIP(8);
      if (lookahead == '\r') SKIP(6);
      if (lookahead == '$') ADVANCE(906);
      if (lookahead == '*') ADVANCE(55);
      if (lookahead == '@') ADVANCE(82);
      if (lookahead == '{') ADVANCE(913);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(6);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(52);
      if (lookahead == '-' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(59);
      END_STATE();
    case 7:
      if (lookahead == '\n') SKIP(8);
      if (lookahead == '\r') SKIP(6);
      if (lookahead == '$') ADVANCE(906);
      if (lookahead == '*') ADVANCE(7);
      if (lookahead == '/') ADVANCE(1150);
      if (lookahead == '@') ADVANCE(82);
      if (lookahead == '{') ADVANCE(913);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(8);
      if (lookahead == 0x0b ||
          lookahead == '\f') SKIP(6);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(52);
      if (lookahead == '-' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(59);
      END_STATE();
    case 8:
      if (lookahead == '\n') SKIP(8);
      if (lookahead == '\r') SKIP(6);
      if (lookahead == '$') ADVANCE(906);
      if (lookahead == '*') ADVANCE(7);
      if (lookahead == '@') ADVANCE(82);
      if (lookahead == '{') ADVANCE(913);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(8);
      if (lookahead == 0x0b ||
          lookahead == '\f') SKIP(6);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(52);
      if (lookahead == '-' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(59);
      END_STATE();
    case 9:
      if (lookahead == '\n') SKIP(9);
      if (lookahead == '\r') SKIP(11);
      if (lookahead == '*') ADVANCE(1136);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(9);
      if (lookahead == 0x0b ||
          lookahead == '\f') SKIP(11);
      if (lookahead != 0) ADVANCE(1135);
      END_STATE();
    case 10:
      if (lookahead == '\n') SKIP(9);
      if (lookahead == '\r') SKIP(11);
      if (lookahead == '*') ADVANCE(1137);
      if (lookahead == '<') ADVANCE(1135);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(9);
      if (lookahead == 0x0b ||
          lookahead == '\f') SKIP(11);
      if (lookahead != 0) ADVANCE(1133);
      END_STATE();
    case 11:
      if (lookahead == '\n') SKIP(9);
      if (lookahead == '\r') SKIP(11);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(11);
      if (lookahead != 0) ADVANCE(1135);
      END_STATE();
    case 12:
      if (lookahead == '\n') ADVANCE(1147);
      if (lookahead == '\r') ADVANCE(1148);
      if (lookahead == ' ') SKIP(12);
      if (('\t' <= lookahead && lookahead <= '\f')) ADVANCE(1148);
      if (lookahead != 0 &&
          lookahead != ',') ADVANCE(1149);
      END_STATE();
    case 13:
      if (lookahead == '\n') SKIP(14);
      if (lookahead == '\r') SKIP(13);
      if (lookahead == '"') ADVANCE(1028);
      if (lookahead == '$') ADVANCE(1132);
      if (lookahead == '&') ADVANCE(1129);
      if (lookahead == '\'') ADVANCE(1027);
      if (lookahead == '(') ADVANCE(1130);
      if (lookahead == ')') ADVANCE(1131);
      if (lookahead == '*') ADVANCE(55);
      if (lookahead == ',') ADVANCE(1026);
      if (lookahead == '/') ADVANCE(27);
      if (lookahead == ':') ADVANCE(1033);
      if (lookahead == '<') ADVANCE(932);
      if (lookahead == '=') ADVANCE(1146);
      if (lookahead == '>') ADVANCE(933);
      if (lookahead == '?') ADVANCE(1031);
      if (lookahead == '@') ADVANCE(82);
      if (lookahead == 'C') ADVANCE(1112);
      if (lookahead == 'N') ADVANCE(1113);
      if (lookahead == '[') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(1127);
      if (lookahead == 'c') ADVANCE(1057);
      if (lookahead == 'e') ADVANCE(1088);
      if (lookahead == 'h') ADVANCE(1105);
      if (lookahead == 'i') ADVANCE(1090);
      if (lookahead == 'l') ADVANCE(1082);
      if (lookahead == 'n') ADVANCE(1092);
      if (lookahead == 'p') ADVANCE(1091);
      if (lookahead == 't') ADVANCE(1096);
      if (lookahead == '{') ADVANCE(913);
      if (lookahead == '|') ADVANCE(1128);
      if (lookahead == '}') ADVANCE(916);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(13);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1029);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 14:
      if (lookahead == '\n') SKIP(14);
      if (lookahead == '\r') SKIP(13);
      if (lookahead == '"') ADVANCE(1028);
      if (lookahead == '$') ADVANCE(1132);
      if (lookahead == '&') ADVANCE(1129);
      if (lookahead == '\'') ADVANCE(1027);
      if (lookahead == '(') ADVANCE(1130);
      if (lookahead == ')') ADVANCE(1131);
      if (lookahead == '*') ADVANCE(15);
      if (lookahead == ',') ADVANCE(1026);
      if (lookahead == '/') ADVANCE(27);
      if (lookahead == ':') ADVANCE(1033);
      if (lookahead == '<') ADVANCE(932);
      if (lookahead == '=') ADVANCE(1146);
      if (lookahead == '>') ADVANCE(933);
      if (lookahead == '?') ADVANCE(1031);
      if (lookahead == '@') ADVANCE(82);
      if (lookahead == 'C') ADVANCE(1112);
      if (lookahead == 'N') ADVANCE(1113);
      if (lookahead == '[') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(1127);
      if (lookahead == 'c') ADVANCE(1057);
      if (lookahead == 'e') ADVANCE(1088);
      if (lookahead == 'h') ADVANCE(1105);
      if (lookahead == 'i') ADVANCE(1090);
      if (lookahead == 'l') ADVANCE(1082);
      if (lookahead == 'n') ADVANCE(1092);
      if (lookahead == 'p') ADVANCE(1091);
      if (lookahead == 't') ADVANCE(1096);
      if (lookahead == '{') ADVANCE(913);
      if (lookahead == '|') ADVANCE(1128);
      if (lookahead == '}') ADVANCE(916);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(14);
      if (lookahead == 0x0b ||
          lookahead == '\f') SKIP(13);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1029);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 15:
      if (lookahead == '\n') SKIP(14);
      if (lookahead == '\r') SKIP(13);
      if (lookahead == '"') ADVANCE(1028);
      if (lookahead == '$') ADVANCE(1132);
      if (lookahead == '&') ADVANCE(1129);
      if (lookahead == '\'') ADVANCE(1027);
      if (lookahead == '(') ADVANCE(1130);
      if (lookahead == ')') ADVANCE(1131);
      if (lookahead == '*') ADVANCE(15);
      if (lookahead == ',') ADVANCE(1026);
      if (lookahead == '/') ADVANCE(1151);
      if (lookahead == ':') ADVANCE(1033);
      if (lookahead == '<') ADVANCE(932);
      if (lookahead == '=') ADVANCE(1146);
      if (lookahead == '>') ADVANCE(933);
      if (lookahead == '?') ADVANCE(1031);
      if (lookahead == '@') ADVANCE(82);
      if (lookahead == 'C') ADVANCE(1112);
      if (lookahead == 'N') ADVANCE(1113);
      if (lookahead == '[') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(1127);
      if (lookahead == 'c') ADVANCE(1057);
      if (lookahead == 'e') ADVANCE(1088);
      if (lookahead == 'h') ADVANCE(1105);
      if (lookahead == 'i') ADVANCE(1090);
      if (lookahead == 'l') ADVANCE(1082);
      if (lookahead == 'n') ADVANCE(1092);
      if (lookahead == 'p') ADVANCE(1091);
      if (lookahead == 't') ADVANCE(1096);
      if (lookahead == '{') ADVANCE(913);
      if (lookahead == '|') ADVANCE(1128);
      if (lookahead == '}') ADVANCE(916);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(14);
      if (lookahead == 0x0b ||
          lookahead == '\f') SKIP(13);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1029);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 16:
      if (lookahead == '\n') SKIP(17);
      if (lookahead == '\r') SKIP(18);
      if (lookahead == '*') ADVANCE(16);
      if (lookahead == '@') ADVANCE(61);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(17);
      if (lookahead == 0x0b ||
          lookahead == '\f') SKIP(18);
      if (lookahead != 0) ADVANCE(62);
      END_STATE();
    case 17:
      if (lookahead == '\n') SKIP(17);
      if (lookahead == '\r') SKIP(18);
      if (lookahead == '*') ADVANCE(16);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(17);
      if (lookahead == 0x0b ||
          lookahead == '\f') SKIP(18);
      if (lookahead != 0) ADVANCE(62);
      END_STATE();
    case 18:
      if (lookahead == '\n') SKIP(17);
      if (lookahead == '\r') SKIP(18);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(18);
      if (lookahead != 0) ADVANCE(62);
      END_STATE();
    case 19:
      if (lookahead == ' ') ADVANCE(199);
      END_STATE();
    case 20:
      if (lookahead == ' ') ADVANCE(753);
      END_STATE();
    case 21:
      if (lookahead == ' ') ADVANCE(798);
      END_STATE();
    case 22:
      if (lookahead == ' ') ADVANCE(245);
      END_STATE();
    case 23:
      if (lookahead == ' ') ADVANCE(154);
      END_STATE();
    case 24:
      if (lookahead == '$') ADVANCE(1142);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(24);
      END_STATE();
    case 25:
      if (lookahead == ')') ADVANCE(1144);
      END_STATE();
    case 26:
      if (lookahead == '*') ADVANCE(912);
      END_STATE();
    case 27:
      if (lookahead == '*') ADVANCE(26);
      END_STATE();
    case 28:
      if (lookahead == '-') ADVANCE(89);
      END_STATE();
    case 29:
      if (lookahead == '-') ADVANCE(329);
      END_STATE();
    case 30:
      if (lookahead == '-') ADVANCE(330);
      END_STATE();
    case 31:
      if (lookahead == '-') ADVANCE(178);
      END_STATE();
    case 32:
      if (lookahead == '-') ADVANCE(315);
      END_STATE();
    case 33:
      if (lookahead == '-') ADVANCE(432);
      END_STATE();
    case 34:
      if (lookahead == '-') ADVANCE(492);
      END_STATE();
    case 35:
      if (lookahead == '-') ADVANCE(327);
      END_STATE();
    case 36:
      if (lookahead == '-') ADVANCE(463);
      END_STATE();
    case 37:
      if (lookahead == '-') ADVANCE(607);
      END_STATE();
    case 38:
      if (lookahead == '-') ADVANCE(120);
      END_STATE();
    case 39:
      if (lookahead == '-') ADVANCE(784);
      END_STATE();
    case 40:
      if (lookahead == '-') ADVANCE(789);
      END_STATE();
    case 41:
      if (lookahead == '-') ADVANCE(602);
      END_STATE();
    case 42:
      if (lookahead == '-') ADVANCE(578);
      END_STATE();
    case 43:
      if (lookahead == '-') ADVANCE(382);
      END_STATE();
    case 44:
      if (lookahead == '-') ADVANCE(817);
      END_STATE();
    case 45:
      if (lookahead == '-') ADVANCE(663);
      END_STATE();
    case 46:
      if (lookahead == '-') ADVANCE(328);
      END_STATE();
    case 47:
      if (lookahead == '-') ADVANCE(688);
      END_STATE();
    case 48:
      if (lookahead == '-') ADVANCE(764);
      END_STATE();
    case 49:
      if (lookahead == '-') ADVANCE(473);
      END_STATE();
    case 50:
      if (lookahead == '-') ADVANCE(474);
      END_STATE();
    case 51:
      if (lookahead == '-') ADVANCE(619);
      END_STATE();
    case 52:
      if (lookahead == '.') ADVANCE(909);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(52);
      END_STATE();
    case 53:
      if (lookahead == '.') ADVANCE(54);
      if (lookahead == '@') ADVANCE(53);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ') ADVANCE(53);
      END_STATE();
    case 54:
      if (lookahead == '.') ADVANCE(1138);
      if (lookahead == '>') ADVANCE(53);
      if (lookahead == '@') ADVANCE(1138);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ') ADVANCE(1138);
      END_STATE();
    case 55:
      if (lookahead == '/') ADVANCE(1150);
      END_STATE();
    case 56:
      if (lookahead == '/') ADVANCE(908);
      END_STATE();
    case 57:
      if (lookahead == '/') ADVANCE(56);
      END_STATE();
    case 58:
      if (lookahead == ':') ADVANCE(1145);
      END_STATE();
    case 59:
      if (lookahead == ':') ADVANCE(1140);
      if (lookahead == '-' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(59);
      END_STATE();
    case 60:
      if (lookahead == '@') ADVANCE(1141);
      END_STATE();
    case 61:
      if (lookahead == '@') ADVANCE(53);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ') ADVANCE(53);
      END_STATE();
    case 62:
      if (lookahead == '@') ADVANCE(61);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ') ADVANCE(62);
      END_STATE();
    case 63:
      if (lookahead == 'A') ADVANCE(755);
      END_STATE();
    case 64:
      if (lookahead == 'A') ADVANCE(815);
      END_STATE();
    case 65:
      if (lookahead == 'C') ADVANCE(540);
      END_STATE();
    case 66:
      if (lookahead == 'C') ADVANCE(442);
      END_STATE();
    case 67:
      if (lookahead == 'D') ADVANCE(550);
      if (lookahead == 'd') ADVANCE(552);
      END_STATE();
    case 68:
      if (lookahead == 'G') ADVANCE(446);
      if (lookahead == 'S') ADVANCE(816);
      END_STATE();
    case 69:
      if (lookahead == 'G') ADVANCE(449);
      END_STATE();
    case 70:
      if (lookahead == 'I') ADVANCE(477);
      if (lookahead == 'T') ADVANCE(291);
      END_STATE();
    case 71:
      if (lookahead == 'I') ADVANCE(352);
      END_STATE();
    case 72:
      if (lookahead == 'I') ADVANCE(535);
      END_STATE();
    case 73:
      if (lookahead == 'N') ADVANCE(557);
      END_STATE();
    case 74:
      if (lookahead == 'P') ADVANCE(642);
      END_STATE();
    case 75:
      if (lookahead == 'P') ADVANCE(647);
      END_STATE();
    case 76:
      if (lookahead == 'P') ADVANCE(267);
      END_STATE();
    case 77:
      if (lookahead == 'P') ADVANCE(687);
      END_STATE();
    case 78:
      if (lookahead == 'S') ADVANCE(290);
      END_STATE();
    case 79:
      if (lookahead == 'S') ADVANCE(838);
      END_STATE();
    case 80:
      if (lookahead == 'S') ADVANCE(318);
      END_STATE();
    case 81:
      if (lookahead == ']') ADVANCE(1025);
      END_STATE();
    case 82:
      ADVANCE_MAP(
        'a', 321,
        'b', 84,
        'c', 119,
        'd', 91,
        'e', 891,
        'f', 362,
        'g', 417,
        'i', 348,
        'l', 85,
        'm', 203,
        'n', 537,
        'p', 86,
        'r', 204,
        's', 239,
        't', 205,
        'u', 725,
        'v', 93,
      );
      END_STATE();
    case 83:
      ADVANCE_MAP(
        'a', 321,
        'b', 84,
        'c', 119,
        'd', 91,
        'e', 891,
        'f', 362,
        'g', 417,
        'i', 348,
        'l', 85,
        'm', 203,
        'n', 537,
        'p', 152,
        'r', 204,
        's', 239,
        't', 205,
        'u', 725,
        'v', 93,
      );
      END_STATE();
    case 84:
      if (lookahead == 'a') ADVANCE(164);
      if (lookahead == 'e') ADVANCE(322);
      END_STATE();
    case 85:
      if (lookahead == 'a') ADVANCE(620);
      if (lookahead == 'i') ADVANCE(170);
      END_STATE();
    case 86:
      if (lookahead == 'a') ADVANCE(168);
      if (lookahead == 'h') ADVANCE(597);
      if (lookahead == 'r') ADVANCE(285);
      if (lookahead == 's') ADVANCE(92);
      END_STATE();
    case 87:
      if (lookahead == 'a') ADVANCE(464);
      if (lookahead == 't') ADVANCE(289);
      END_STATE();
    case 88:
      if (lookahead == 'a') ADVANCE(74);
      END_STATE();
    case 89:
      ADVANCE_MAP(
        'a', 427,
        'c', 561,
        'e', 895,
        'i', 323,
        'm', 287,
        'p', 114,
        'r', 303,
        's', 298,
        't', 304,
        'v', 115,
      );
      END_STATE();
    case 90:
      if (lookahead == 'a') ADVANCE(453);
      END_STATE();
    case 91:
      if (lookahead == 'a') ADVANCE(776);
      if (lookahead == 'e') ADVANCE(593);
      if (lookahead == 'o') ADVANCE(237);
      END_STATE();
    case 92:
      if (lookahead == 'a') ADVANCE(419);
      END_STATE();
    case 93:
      if (lookahead == 'a') ADVANCE(621);
      if (lookahead == 'e') ADVANCE(629);
      END_STATE();
    case 94:
      if (lookahead == 'a') ADVANCE(159);
      END_STATE();
    case 95:
      if (lookahead == 'a') ADVANCE(421);
      END_STATE();
    case 96:
      if (lookahead == 'a') ADVANCE(455);
      END_STATE();
    case 97:
      if (lookahead == 'a') ADVANCE(414);
      END_STATE();
    case 98:
      if (lookahead == 'a') ADVANCE(826);
      END_STATE();
    case 99:
      if (lookahead == 'a') ADVANCE(863);
      END_STATE();
    case 100:
      if (lookahead == 'a') ADVANCE(187);
      END_STATE();
    case 101:
      if (lookahead == 'a') ADVANCE(188);
      END_STATE();
    case 102:
      if (lookahead == 'a') ADVANCE(351);
      END_STATE();
    case 103:
      if (lookahead == 'a') ADVANCE(415);
      END_STATE();
    case 104:
      if (lookahead == 'a') ADVANCE(733);
      END_STATE();
    case 105:
      if (lookahead == 'a') ADVANCE(490);
      END_STATE();
    case 106:
      if (lookahead == 'a') ADVANCE(422);
      END_STATE();
    case 107:
      if (lookahead == 'a') ADVANCE(431);
      END_STATE();
    case 108:
      if (lookahead == 'a') ADVANCE(418);
      END_STATE();
    case 109:
      if (lookahead == 'a') ADVANCE(428);
      END_STATE();
    case 110:
      if (lookahead == 'a') ADVANCE(534);
      END_STATE();
    case 111:
      if (lookahead == 'a') ADVANCE(416);
      END_STATE();
    case 112:
      if (lookahead == 'a') ADVANCE(790);
      END_STATE();
    case 113:
      if (lookahead == 'a') ADVANCE(439);
      END_STATE();
    case 114:
      if (lookahead == 'a') ADVANCE(668);
      if (lookahead == 'r') ADVANCE(584);
      if (lookahead == 'u') ADVANCE(652);
      END_STATE();
    case 115:
      if (lookahead == 'a') ADVANCE(624);
      END_STATE();
    case 116:
      if (lookahead == 'a') ADVANCE(691);
      END_STATE();
    case 117:
      if (lookahead == 'a') ADVANCE(626);
      END_STATE();
    case 118:
      if (lookahead == 'a') ADVANCE(656);
      END_STATE();
    case 119:
      if (lookahead == 'a') ADVANCE(783);
      if (lookahead == 'o') ADVANCE(192);
      END_STATE();
    case 120:
      if (lookahead == 'a') ADVANCE(634);
      END_STATE();
    case 121:
      if (lookahead == 'a') ADVANCE(195);
      if (lookahead == 'q') ADVANCE(856);
      if (lookahead == 't') ADVANCE(862);
      END_STATE();
    case 122:
      if (lookahead == 'a') ADVANCE(344);
      END_STATE();
    case 123:
      if (lookahead == 'a') ADVANCE(461);
      END_STATE();
    case 124:
      if (lookahead == 'a') ADVANCE(734);
      END_STATE();
    case 125:
      if (lookahead == 'a') ADVANCE(434);
      END_STATE();
    case 126:
      if (lookahead == 'a') ADVANCE(799);
      END_STATE();
    case 127:
      if (lookahead == 'a') ADVANCE(182);
      END_STATE();
    case 128:
      if (lookahead == 'a') ADVANCE(201);
      if (lookahead == 'q') ADVANCE(873);
      if (lookahead == 't') ADVANCE(866);
      END_STATE();
    case 129:
      if (lookahead == 'a') ADVANCE(345);
      END_STATE();
    case 130:
      if (lookahead == 'a') ADVANCE(452);
      END_STATE();
    case 131:
      if (lookahead == 'a') ADVANCE(801);
      END_STATE();
    case 132:
      if (lookahead == 'a') ADVANCE(346);
      END_STATE();
    case 133:
      if (lookahead == 'a') ADVANCE(175);
      END_STATE();
    case 134:
      if (lookahead == 'a') ADVANCE(738);
      END_STATE();
    case 135:
      if (lookahead == 'a') ADVANCE(742);
      END_STATE();
    case 136:
      if (lookahead == 'a') ADVANCE(347);
      END_STATE();
    case 137:
      if (lookahead == 'a') ADVANCE(805);
      END_STATE();
    case 138:
      if (lookahead == 'a') ADVANCE(808);
      END_STATE();
    case 139:
      if (lookahead == 'a') ADVANCE(809);
      END_STATE();
    case 140:
      if (lookahead == 'a') ADVANCE(810);
      END_STATE();
    case 141:
      if (lookahead == 'a') ADVANCE(811);
      END_STATE();
    case 142:
      if (lookahead == 'a') ADVANCE(825);
      END_STATE();
    case 143:
      if (lookahead == 'a') ADVANCE(160);
      END_STATE();
    case 144:
      if (lookahead == 'a') ADVANCE(830);
      END_STATE();
    case 145:
      if (lookahead == 'a') ADVANCE(848);
      END_STATE();
    case 146:
      if (lookahead == 'a') ADVANCE(163);
      END_STATE();
    case 147:
      if (lookahead == 'a') ADVANCE(835);
      END_STATE();
    case 148:
      if (lookahead == 'a') ADVANCE(840);
      END_STATE();
    case 149:
      if (lookahead == 'a') ADVANCE(842);
      END_STATE();
    case 150:
      if (lookahead == 'a') ADVANCE(844);
      END_STATE();
    case 151:
      if (lookahead == 'a') ADVANCE(846);
      END_STATE();
    case 152:
      if (lookahead == 'a') ADVANCE(183);
      if (lookahead == 'h') ADVANCE(597);
      if (lookahead == 'r') ADVANCE(285);
      if (lookahead == 's') ADVANCE(92);
      END_STATE();
    case 153:
      if (lookahead == 'a') ADVANCE(694);
      END_STATE();
    case 154:
      if (lookahead == 'a') ADVANCE(536);
      END_STATE();
    case 155:
      if (lookahead == 'a') ADVANCE(855);
      END_STATE();
    case 156:
      if (lookahead == 'b') ADVANCE(599);
      END_STATE();
    case 157:
      if (lookahead == 'b') ADVANCE(875);
      END_STATE();
    case 158:
      if (lookahead == 'b') ADVANCE(97);
      END_STATE();
    case 159:
      if (lookahead == 'b') ADVANCE(435);
      END_STATE();
    case 160:
      if (lookahead == 'b') ADVANCE(436);
      END_STATE();
    case 161:
      if (lookahead == 'b') ADVANCE(107);
      END_STATE();
    case 162:
      if (lookahead == 'b') ADVANCE(108);
      END_STATE();
    case 163:
      if (lookahead == 'b') ADVANCE(447);
      END_STATE();
    case 164:
      if (lookahead == 'c') ADVANCE(410);
      END_STATE();
    case 165:
      if (lookahead == 'c') ADVANCE(915);
      END_STATE();
    case 166:
      if (lookahead == 'c') ADVANCE(914);
      END_STATE();
    case 167:
      if (lookahead == 'c') ADVANCE(64);
      END_STATE();
    case 168:
      if (lookahead == 'c') ADVANCE(408);
      if (lookahead == 'r') ADVANCE(90);
      END_STATE();
    case 169:
      if (lookahead == 'c') ADVANCE(409);
      END_STATE();
    case 170:
      if (lookahead == 'c') ADVANCE(249);
      if (lookahead == 'n') ADVANCE(407);
      END_STATE();
    case 171:
      if (lookahead == 'c') ADVANCE(210);
      END_STATE();
    case 172:
      if (lookahead == 'c') ADVANCE(213);
      END_STATE();
    case 173:
      if (lookahead == 'c') ADVANCE(135);
      END_STATE();
    case 174:
      if (lookahead == 'c') ADVANCE(219);
      END_STATE();
    case 175:
      if (lookahead == 'c') ADVANCE(222);
      END_STATE();
    case 176:
      if (lookahead == 'c') ADVANCE(823);
      END_STATE();
    case 177:
      if (lookahead == 'c') ADVANCE(299);
      END_STATE();
    case 178:
      if (lookahead == 'c') ADVANCE(571);
      if (lookahead == 't') ADVANCE(317);
      END_STATE();
    case 179:
      if (lookahead == 'c') ADVANCE(307);
      END_STATE();
    case 180:
      if (lookahead == 'c') ADVANCE(131);
      END_STATE();
    case 181:
      if (lookahead == 'c') ADVANCE(404);
      END_STATE();
    case 182:
      if (lookahead == 'c') ADVANCE(411);
      END_STATE();
    case 183:
      if (lookahead == 'c') ADVANCE(412);
      if (lookahead == 'r') ADVANCE(90);
      END_STATE();
    case 184:
      if (lookahead == 'd') ADVANCE(936);
      END_STATE();
    case 185:
      if (lookahead == 'd') ADVANCE(945);
      END_STATE();
    case 186:
      if (lookahead == 'd') ADVANCE(997);
      END_STATE();
    case 187:
      if (lookahead == 'd') ADVANCE(939);
      END_STATE();
    case 188:
      if (lookahead == 'd') ADVANCE(995);
      END_STATE();
    case 189:
      if (lookahead == 'd') ADVANCE(966);
      END_STATE();
    case 190:
      if (lookahead == 'd') ADVANCE(367);
      if (lookahead == 't') ADVANCE(354);
      END_STATE();
    case 191:
      if (lookahead == 'd') ADVANCE(38);
      END_STATE();
    case 192:
      if (lookahead == 'd') ADVANCE(208);
      if (lookahead == 'p') ADVANCE(904);
      if (lookahead == 'v') ADVANCE(252);
      END_STATE();
    case 193:
      if (lookahead == 'd') ADVANCE(539);
      END_STATE();
    case 194:
      if (lookahead == 'd') ADVANCE(700);
      END_STATE();
    case 195:
      if (lookahead == 'd') ADVANCE(558);
      END_STATE();
    case 196:
      if (lookahead == 'd') ADVANCE(701);
      END_STATE();
    case 197:
      if (lookahead == 'd') ADVANCE(711);
      END_STATE();
    case 198:
      if (lookahead == 'd') ADVANCE(716);
      END_STATE();
    case 199:
      if (lookahead == 'd') ADVANCE(292);
      END_STATE();
    case 200:
      if (lookahead == 'd') ADVANCE(282);
      END_STATE();
    case 201:
      if (lookahead == 'd') ADVANCE(565);
      END_STATE();
    case 202:
      if (lookahead == 'd') ADVANCE(269);
      END_STATE();
    case 203:
      if (lookahead == 'e') ADVANCE(190);
      if (lookahead == 'i') ADVANCE(893);
      END_STATE();
    case 204:
      if (lookahead == 'e') ADVANCE(121);
      if (lookahead == 'u') ADVANCE(475);
      END_STATE();
    case 205:
      if (lookahead == 'e') ADVANCE(462);
      if (lookahead == 'h') ADVANCE(630);
      if (lookahead == 'i') ADVANCE(169);
      if (lookahead == 'o') ADVANCE(193);
      END_STATE();
    case 206:
      if (lookahead == 'e') ADVANCE(942);
      END_STATE();
    case 207:
      if (lookahead == 'e') ADVANCE(955);
      END_STATE();
    case 208:
      if (lookahead == 'e') ADVANCE(65);
      END_STATE();
    case 209:
      if (lookahead == 'e') ADVANCE(977);
      END_STATE();
    case 210:
      if (lookahead == 'e') ADVANCE(946);
      END_STATE();
    case 211:
      if (lookahead == 'e') ADVANCE(962);
      END_STATE();
    case 212:
      if (lookahead == 'e') ADVANCE(919);
      END_STATE();
    case 213:
      if (lookahead == 'e') ADVANCE(928);
      END_STATE();
    case 214:
      if (lookahead == 'e') ADVANCE(924);
      END_STATE();
    case 215:
      if (lookahead == 'e') ADVANCE(925);
      END_STATE();
    case 216:
      if (lookahead == 'e') ADVANCE(927);
      END_STATE();
    case 217:
      if (lookahead == 'e') ADVANCE(69);
      END_STATE();
    case 218:
      if (lookahead == 'e') ADVANCE(948);
      END_STATE();
    case 219:
      if (lookahead == 'e') ADVANCE(918);
      END_STATE();
    case 220:
      if (lookahead == 'e') ADVANCE(1009);
      END_STATE();
    case 221:
      if (lookahead == 'e') ADVANCE(929);
      END_STATE();
    case 222:
      if (lookahead == 'e') ADVANCE(1012);
      END_STATE();
    case 223:
      if (lookahead == 'e') ADVANCE(956);
      END_STATE();
    case 224:
      if (lookahead == 'e') ADVANCE(940);
      END_STATE();
    case 225:
      if (lookahead == 'e') ADVANCE(949);
      END_STATE();
    case 226:
      if (lookahead == 'e') ADVANCE(1008);
      END_STATE();
    case 227:
      if (lookahead == 'e') ADVANCE(950);
      END_STATE();
    case 228:
      if (lookahead == 'e') ADVANCE(1019);
      END_STATE();
    case 229:
      if (lookahead == 'e') ADVANCE(964);
      END_STATE();
    case 230:
      if (lookahead == 'e') ADVANCE(979);
      END_STATE();
    case 231:
      if (lookahead == 'e') ADVANCE(1006);
      END_STATE();
    case 232:
      if (lookahead == 'e') ADVANCE(1017);
      END_STATE();
    case 233:
      if (lookahead == 'e') ADVANCE(996);
      END_STATE();
    case 234:
      if (lookahead == 'e') ADVANCE(1018);
      END_STATE();
    case 235:
      if (lookahead == 'e') ADVANCE(1007);
      END_STATE();
    case 236:
      if (lookahead == 'e') ADVANCE(926);
      END_STATE();
    case 237:
      if (lookahead == 'e') ADVANCE(697);
      END_STATE();
    case 238:
      if (lookahead == 'e') ADVANCE(324);
      END_STATE();
    case 239:
      if (lookahead == 'e') ADVANCE(206);
      if (lookahead == 'i') ADVANCE(488);
      if (lookahead == 'm') ADVANCE(95);
      if (lookahead == 'o') ADVANCE(857);
      if (lookahead == 'u') ADVANCE(156);
      END_STATE();
    case 240:
      if (lookahead == 'e') ADVANCE(350);
      END_STATE();
    case 241:
      if (lookahead == 'e') ADVANCE(71);
      END_STATE();
    case 242:
      if (lookahead == 'e') ADVANCE(180);
      END_STATE();
    case 243:
      if (lookahead == 'e') ADVANCE(191);
      END_STATE();
    case 244:
      if (lookahead == 'e') ADVANCE(460);
      END_STATE();
    case 245:
      if (lookahead == 'e') ADVANCE(896);
      END_STATE();
    case 246:
      if (lookahead == 'e') ADVANCE(731);
      END_STATE();
    case 247:
      if (lookahead == 'e') ADVANCE(489);
      if (lookahead == 'r') ADVANCE(242);
      END_STATE();
    case 248:
      if (lookahead == 'e') ADVANCE(767);
      END_STATE();
    case 249:
      if (lookahead == 'e') ADVANCE(521);
      END_STATE();
    case 250:
      if (lookahead == 'e') ADVANCE(622);
      END_STATE();
    case 251:
      if (lookahead == 'e') ADVANCE(185);
      END_STATE();
    case 252:
      if (lookahead == 'e') ADVANCE(631);
      END_STATE();
    case 253:
      if (lookahead == 'e') ADVANCE(29);
      END_STATE();
    case 254:
      if (lookahead == 'e') ADVANCE(702);
      END_STATE();
    case 255:
      if (lookahead == 'e') ADVANCE(635);
      END_STATE();
    case 256:
      if (lookahead == 'e') ADVANCE(636);
      END_STATE();
    case 257:
      if (lookahead == 'e') ADVANCE(32);
      END_STATE();
    case 258:
      if (lookahead == 'e') ADVANCE(509);
      END_STATE();
    case 259:
      if (lookahead == 'e') ADVANCE(664);
      END_STATE();
    case 260:
      if (lookahead == 'e') ADVANCE(637);
      END_STATE();
    case 261:
      if (lookahead == 'e') ADVANCE(100);
      END_STATE();
    case 262:
      if (lookahead == 'e') ADVANCE(48);
      END_STATE();
    case 263:
      if (lookahead == 'e') ADVANCE(45);
      END_STATE();
    case 264:
      if (lookahead == 'e') ADVANCE(689);
      END_STATE();
    case 265:
      if (lookahead == 'e') ADVANCE(101);
      END_STATE();
    case 266:
      if (lookahead == 'e') ADVANCE(709);
      END_STATE();
    case 267:
      if (lookahead == 'e') ADVANCE(684);
      END_STATE();
    case 268:
      if (lookahead == 'e') ADVANCE(648);
      END_STATE();
    case 269:
      if (lookahead == 'e') ADVANCE(625);
      END_STATE();
    case 270:
      if (lookahead == 'e') ADVANCE(651);
      END_STATE();
    case 271:
      if (lookahead == 'e') ADVANCE(717);
      END_STATE();
    case 272:
      if (lookahead == 'e') ADVANCE(666);
      END_STATE();
    case 273:
      if (lookahead == 'e') ADVANCE(718);
      END_STATE();
    case 274:
      if (lookahead == 'e') ADVANCE(653);
      END_STATE();
    case 275:
      if (lookahead == 'e') ADVANCE(721);
      END_STATE();
    case 276:
      if (lookahead == 'e') ADVANCE(695);
      END_STATE();
    case 277:
      if (lookahead == 'e') ADVANCE(722);
      END_STATE();
    case 278:
      if (lookahead == 'e') ADVANCE(820);
      END_STATE();
    case 279:
      if (lookahead == 'e') ADVANCE(494);
      END_STATE();
    case 280:
      if (lookahead == 'e') ADVANCE(724);
      END_STATE();
    case 281:
      if (lookahead == 'e') ADVANCE(520);
      END_STATE();
    case 282:
      if (lookahead == 'e') ADVANCE(499);
      END_STATE();
    case 283:
      if (lookahead == 'e') ADVANCE(231);
      END_STATE();
    case 284:
      if (lookahead == 'e') ADVANCE(235);
      END_STATE();
    case 285:
      if (lookahead == 'e') ADVANCE(747);
      if (lookahead == 'o') ADVANCE(608);
      END_STATE();
    case 286:
      if (lookahead == 'e') ADVANCE(459);
      END_STATE();
    case 287:
      if (lookahead == 'e') ADVANCE(819);
      if (lookahead == 'u') ADVANCE(849);
      END_STATE();
    case 288:
      if (lookahead == 'e') ADVANCE(894);
      if (lookahead == 'i') ADVANCE(471);
      if (lookahead == 'u') ADVANCE(740);
      END_STATE();
    case 289:
      if (lookahead == 'e') ADVANCE(518);
      END_STATE();
    case 290:
      if (lookahead == 'e') ADVANCE(606);
      END_STATE();
    case 291:
      if (lookahead == 'e') ADVANCE(732);
      END_STATE();
    case 292:
      if (lookahead == 'e') ADVANCE(604);
      END_STATE();
    case 293:
      if (lookahead == 'e') ADVANCE(522);
      END_STATE();
    case 294:
      if (lookahead == 'e') ADVANCE(737);
      END_STATE();
    case 295:
      if (lookahead == 'e') ADVANCE(512);
      END_STATE();
    case 296:
      if (lookahead == 'e') ADVANCE(524);
      END_STATE();
    case 297:
      if (lookahead == 'e') ADVANCE(513);
      END_STATE();
    case 298:
      if (lookahead == 'e') ADVANCE(106);
      if (lookahead == 'u') ADVANCE(600);
      END_STATE();
    case 299:
      if (lookahead == 'e') ADVANCE(739);
      END_STATE();
    case 300:
      if (lookahead == 'e') ADVANCE(514);
      END_STATE();
    case 301:
      if (lookahead == 'e') ADVANCE(741);
      END_STATE();
    case 302:
      if (lookahead == 'e') ADVANCE(516);
      END_STATE();
    case 303:
      if (lookahead == 'e') ADVANCE(128);
      END_STATE();
    case 304:
      if (lookahead == 'e') ADVANCE(468);
      if (lookahead == 'h') ADVANCE(374);
      if (lookahead == 'r') ADVANCE(133);
      END_STATE();
    case 305:
      if (lookahead == 'e') ADVANCE(75);
      END_STATE();
    case 306:
      if (lookahead == 'e') ADVANCE(685);
      END_STATE();
    case 307:
      if (lookahead == 'e') ADVANCE(748);
      END_STATE();
    case 308:
      if (lookahead == 'e') ADVANCE(822);
      END_STATE();
    case 309:
      if (lookahead == 'e') ADVANCE(77);
      END_STATE();
    case 310:
      if (lookahead == 'e') ADVANCE(690);
      END_STATE();
    case 311:
      if (lookahead == 'e') ADVANCE(692);
      END_STATE();
    case 312:
      if (lookahead == 'e') ADVANCE(47);
      END_STATE();
    case 313:
      if (lookahead == 'e') ADVANCE(466);
      END_STATE();
    case 314:
      if (lookahead == 'e') ADVANCE(467);
      END_STATE();
    case 315:
      if (lookahead == 'e') ADVANCE(897);
      if (lookahead == 'i') ADVANCE(472);
      END_STATE();
    case 316:
      if (lookahead == 'e') ADVANCE(469);
      END_STATE();
    case 317:
      if (lookahead == 'e') ADVANCE(470);
      END_STATE();
    case 318:
      if (lookahead == 'e') ADVANCE(617);
      END_STATE();
    case 319:
      if (lookahead == 'e') ADVANCE(49);
      END_STATE();
    case 320:
      if (lookahead == 'e') ADVANCE(50);
      END_STATE();
    case 321:
      if (lookahead == 'f') ADVANCE(781);
      if (lookahead == 'n') ADVANCE(491);
      if (lookahead == 'p') ADVANCE(363);
      if (lookahead == 'u') ADVANCE(765);
      END_STATE();
    case 322:
      if (lookahead == 'f') ADVANCE(555);
      END_STATE();
    case 323:
      if (lookahead == 'f') ADVANCE(39);
      if (lookahead == 'g') ADVANCE(530);
      if (lookahead == 'm') ADVANCE(458);
      if (lookahead == 'n') ADVANCE(833);
      END_STATE();
    case 324:
      if (lookahead == 'f') ADVANCE(99);
      END_STATE();
    case 325:
      if (lookahead == 'f') ADVANCE(30);
      END_STATE();
    case 326:
      if (lookahead == 'f') ADVANCE(568);
      END_STATE();
    case 327:
      if (lookahead == 'f') ADVANCE(662);
      END_STATE();
    case 328:
      if (lookahead == 'f') ADVANCE(669);
      END_STATE();
    case 329:
      if (lookahead == 'f') ADVANCE(125);
      if (lookahead == 'n') ADVANCE(872);
      if (lookahead == 'v') ADVANCE(117);
      END_STATE();
    case 330:
      if (lookahead == 'f') ADVANCE(113);
      if (lookahead == 't') ADVANCE(639);
      END_STATE();
    case 331:
      if (lookahead == 'g') ADVANCE(1038);
      END_STATE();
    case 332:
      if (lookahead == 'g') ADVANCE(1034);
      END_STATE();
    case 333:
      if (lookahead == 'g') ADVANCE(1037);
      END_STATE();
    case 334:
      if (lookahead == 'g') ADVANCE(971);
      END_STATE();
    case 335:
      if (lookahead == 'g') ADVANCE(1041);
      END_STATE();
    case 336:
      if (lookahead == 'g') ADVANCE(1040);
      END_STATE();
    case 337:
      if (lookahead == 'g') ADVANCE(1039);
      END_STATE();
    case 338:
      if (lookahead == 'g') ADVANCE(1035);
      END_STATE();
    case 339:
      if (lookahead == 'g') ADVANCE(1042);
      END_STATE();
    case 340:
      if (lookahead == 'g') ADVANCE(1043);
      END_STATE();
    case 341:
      if (lookahead == 'g') ADVANCE(1044);
      END_STATE();
    case 342:
      if (lookahead == 'g') ADVANCE(355);
      END_STATE();
    case 343:
      if (lookahead == 'g') ADVANCE(209);
      END_STATE();
    case 344:
      if (lookahead == 'g') ADVANCE(216);
      END_STATE();
    case 345:
      if (lookahead == 'g') ADVANCE(221);
      END_STATE();
    case 346:
      if (lookahead == 'g') ADVANCE(241);
      END_STATE();
    case 347:
      if (lookahead == 'g') ADVANCE(236);
      END_STATE();
    case 348:
      if (lookahead == 'g') ADVANCE(528);
      if (lookahead == 'm') ADVANCE(596);
      if (lookahead == 'n') ADVANCE(358);
      END_STATE();
    case 349:
      if (lookahead == 'g') ADVANCE(876);
      END_STATE();
    case 350:
      if (lookahead == 'g') ADVANCE(564);
      END_STATE();
    case 351:
      if (lookahead == 'g') ADVANCE(266);
      END_STATE();
    case 352:
      if (lookahead == 'g') ADVANCE(531);
      END_STATE();
    case 353:
      if (lookahead == 'h') ADVANCE(986);
      END_STATE();
    case 354:
      if (lookahead == 'h') ADVANCE(547);
      END_STATE();
    case 355:
      if (lookahead == 'h') ADVANCE(769);
      END_STATE();
    case 356:
      if (lookahead == 'h') ADVANCE(556);
      END_STATE();
    case 357:
      if (lookahead == 'h') ADVANCE(560);
      END_STATE();
    case 358:
      if (lookahead == 'h') ADVANCE(255);
      if (lookahead == 't') ADVANCE(256);
      END_STATE();
    case 359:
      if (lookahead == 'h') ADVANCE(379);
      END_STATE();
    case 360:
      if (lookahead == 'h') ADVANCE(381);
      END_STATE();
    case 361:
      if (lookahead == 'h') ADVANCE(574);
      END_STATE();
    case 362:
      if (lookahead == 'i') ADVANCE(437);
      END_STATE();
    case 363:
      if (lookahead == 'i') ADVANCE(917);
      END_STATE();
    case 364:
      if (lookahead == 'i') ADVANCE(325);
      END_STATE();
    case 365:
      if (lookahead == 'i') ADVANCE(342);
      END_STATE();
    case 366:
      if (lookahead == 'i') ADVANCE(885);
      END_STATE();
    case 367:
      if (lookahead == 'i') ADVANCE(858);
      END_STATE();
    case 368:
      if (lookahead == 'i') ADVANCE(157);
      END_STATE();
    case 369:
      if (lookahead == 'i') ADVANCE(202);
      END_STATE();
    case 370:
      if (lookahead == 'i') ADVANCE(167);
      END_STATE();
    case 371:
      if (lookahead == 'i') ADVANCE(476);
      END_STATE();
    case 372:
      if (lookahead == 'i') ADVANCE(768);
      END_STATE();
    case 373:
      if (lookahead == 'i') ADVANCE(779);
      END_STATE();
    case 374:
      if (lookahead == 'i') ADVANCE(729);
      END_STATE();
    case 375:
      if (lookahead == 'i') ADVANCE(493);
      END_STATE();
    case 376:
      if (lookahead == 'i') ADVANCE(672);
      END_STATE();
    case 377:
      if (lookahead == 'i') ADVANCE(749);
      END_STATE();
    case 378:
      if (lookahead == 'i') ADVANCE(495);
      END_STATE();
    case 379:
      if (lookahead == 'i') ADVANCE(730);
      END_STATE();
    case 380:
      if (lookahead == 'i') ADVANCE(496);
      END_STATE();
    case 381:
      if (lookahead == 'i') ADVANCE(498);
      END_STATE();
    case 382:
      if (lookahead == 'i') ADVANCE(710);
      END_STATE();
    case 383:
      if (lookahead == 'i') ADVANCE(501);
      END_STATE();
    case 384:
      if (lookahead == 'i') ADVANCE(502);
      END_STATE();
    case 385:
      if (lookahead == 'i') ADVANCE(504);
      END_STATE();
    case 386:
      if (lookahead == 'i') ADVANCE(505);
      END_STATE();
    case 387:
      if (lookahead == 'i') ADVANCE(507);
      END_STATE();
    case 388:
      if (lookahead == 'i') ADVANCE(508);
      END_STATE();
    case 389:
      if (lookahead == 'i') ADVANCE(510);
      END_STATE();
    case 390:
      if (lookahead == 'i') ADVANCE(559);
      END_STATE();
    case 391:
      if (lookahead == 'i') ADVANCE(511);
      END_STATE();
    case 392:
      if (lookahead == 'i') ADVANCE(563);
      END_STATE();
    case 393:
      if (lookahead == 'i') ADVANCE(657);
      END_STATE();
    case 394:
      if (lookahead == 'i') ADVANCE(567);
      END_STATE();
    case 395:
      if (lookahead == 'i') ADVANCE(569);
      END_STATE();
    case 396:
      if (lookahead == 'i') ADVANCE(806);
      END_STATE();
    case 397:
      if (lookahead == 'i') ADVANCE(271);
      END_STATE();
    case 398:
      if (lookahead == 'i') ADVANCE(570);
      END_STATE();
    case 399:
      if (lookahead == 'i') ADVANCE(572);
      END_STATE();
    case 400:
      if (lookahead == 'i') ADVANCE(573);
      END_STATE();
    case 401:
      if (lookahead == 'i') ADVANCE(575);
      END_STATE();
    case 402:
      if (lookahead == 'i') ADVANCE(577);
      END_STATE();
    case 403:
      if (lookahead == 'i') ADVANCE(812);
      END_STATE();
    case 404:
      if (lookahead == 'i') ADVANCE(280);
      END_STATE();
    case 405:
      if (lookahead == 'i') ADVANCE(586);
      END_STATE();
    case 406:
      if (lookahead == 'i') ADVANCE(886);
      END_STATE();
    case 407:
      if (lookahead == 'k') ADVANCE(935);
      END_STATE();
    case 408:
      if (lookahead == 'k') ADVANCE(122);
      END_STATE();
    case 409:
      if (lookahead == 'k') ADVANCE(248);
      END_STATE();
    case 410:
      if (lookahead == 'k') ADVANCE(860);
      END_STATE();
    case 411:
      if (lookahead == 'k') ADVANCE(129);
      END_STATE();
    case 412:
      if (lookahead == 'k') ADVANCE(136);
      END_STATE();
    case 413:
      if (lookahead == 'l') ADVANCE(984);
      END_STATE();
    case 414:
      if (lookahead == 'l') ADVANCE(934);
      END_STATE();
    case 415:
      if (lookahead == 'l') ADVANCE(920);
      END_STATE();
    case 416:
      if (lookahead == 'l') ADVANCE(1021);
      END_STATE();
    case 417:
      if (lookahead == 'l') ADVANCE(542);
      if (lookahead == 'r') ADVANCE(541);
      END_STATE();
    case 418:
      if (lookahead == 'l') ADVANCE(79);
      END_STATE();
    case 419:
      if (lookahead == 'l') ADVANCE(456);
      END_STATE();
    case 420:
      if (lookahead == 'l') ADVANCE(900);
      END_STATE();
    case 421:
      if (lookahead == 'l') ADVANCE(413);
      END_STATE();
    case 422:
      if (lookahead == 'l') ADVANCE(37);
      END_STATE();
    case 423:
      if (lookahead == 'l') ADVANCE(902);
      END_STATE();
    case 424:
      if (lookahead == 'l') ADVANCE(126);
      END_STATE();
    case 425:
      if (lookahead == 'l') ADVANCE(104);
      END_STATE();
    case 426:
      if (lookahead == 'l') ADVANCE(244);
      END_STATE();
    case 427:
      if (lookahead == 'l') ADVANCE(429);
      if (lookahead == 's') ADVANCE(750);
      END_STATE();
    case 428:
      if (lookahead == 'l') ADVANCE(36);
      END_STATE();
    case 429:
      if (lookahead == 'l') ADVANCE(543);
      END_STATE();
    case 430:
      if (lookahead == 'l') ADVANCE(214);
      END_STATE();
    case 431:
      if (lookahead == 'l') ADVANCE(707);
      END_STATE();
    case 432:
      if (lookahead == 'l') ADVANCE(548);
      if (lookahead == 's') ADVANCE(845);
      END_STATE();
    case 433:
      if (lookahead == 'l') ADVANCE(777);
      END_STATE();
    case 434:
      if (lookahead == 'l') ADVANCE(754);
      END_STATE();
    case 435:
      if (lookahead == 'l') ADVANCE(226);
      END_STATE();
    case 436:
      if (lookahead == 'l') ADVANCE(263);
      END_STATE();
    case 437:
      if (lookahead == 'l') ADVANCE(246);
      END_STATE();
    case 438:
      if (lookahead == 'l') ADVANCE(448);
      END_STATE();
    case 439:
      if (lookahead == 'l') ADVANCE(743);
      END_STATE();
    case 440:
      if (lookahead == 'l') ADVANCE(124);
      END_STATE();
    case 441:
      if (lookahead == 'l') ADVANCE(313);
      END_STATE();
    case 442:
      if (lookahead == 'l') ADVANCE(134);
      END_STATE();
    case 443:
      if (lookahead == 'l') ADVANCE(138);
      END_STATE();
    case 444:
      if (lookahead == 'l') ADVANCE(139);
      END_STATE();
    case 445:
      if (lookahead == 'l') ADVANCE(142);
      END_STATE();
    case 446:
      if (lookahead == 'l') ADVANCE(583);
      END_STATE();
    case 447:
      if (lookahead == 'l') ADVANCE(312);
      END_STATE();
    case 448:
      if (lookahead == 'l') ADVANCE(146);
      END_STATE();
    case 449:
      if (lookahead == 'l') ADVANCE(587);
      END_STATE();
    case 450:
      if (lookahead == 'l') ADVANCE(314);
      END_STATE();
    case 451:
      if (lookahead == 'l') ADVANCE(592);
      END_STATE();
    case 452:
      if (lookahead == 'l') ADVANCE(451);
      END_STATE();
    case 453:
      if (lookahead == 'm') ADVANCE(937);
      END_STATE();
    case 454:
      if (lookahead == 'm') ADVANCE(978);
      END_STATE();
    case 455:
      if (lookahead == 'm') ADVANCE(992);
      END_STATE();
    case 456:
      if (lookahead == 'm') ADVANCE(28);
      END_STATE();
    case 457:
      if (lookahead == 'm') ADVANCE(63);
      END_STATE();
    case 458:
      if (lookahead == 'm') ADVANCE(874);
      if (lookahead == 'p') ADVANCE(566);
      END_STATE();
    case 459:
      if (lookahead == 'm') ADVANCE(601);
      END_STATE();
    case 460:
      if (lookahead == 'm') ADVANCE(258);
      END_STATE();
    case 461:
      if (lookahead == 'm') ADVANCE(243);
      END_STATE();
    case 462:
      if (lookahead == 'm') ADVANCE(598);
      if (lookahead == 's') ADVANCE(766);
      END_STATE();
    case 463:
      if (lookahead == 'm') ADVANCE(878);
      END_STATE();
    case 464:
      if (lookahead == 'm') ADVANCE(605);
      END_STATE();
    case 465:
      if (lookahead == 'm') ADVANCE(297);
      END_STATE();
    case 466:
      if (lookahead == 'm') ADVANCE(300);
      END_STATE();
    case 467:
      if (lookahead == 'm') ADVANCE(302);
      END_STATE();
    case 468:
      if (lookahead == 'm') ADVANCE(614);
      END_STATE();
    case 469:
      if (lookahead == 'm') ADVANCE(615);
      END_STATE();
    case 470:
      if (lookahead == 'm') ADVANCE(616);
      END_STATE();
    case 471:
      if (lookahead == 'm') ADVANCE(613);
      END_STATE();
    case 472:
      if (lookahead == 'm') ADVANCE(618);
      END_STATE();
    case 473:
      if (lookahead == 'm') ADVANCE(879);
      END_STATE();
    case 474:
      if (lookahead == 'm') ADVANCE(880);
      END_STATE();
    case 475:
      if (lookahead == 'n') ADVANCE(70);
      END_STATE();
    case 476:
      if (lookahead == 'n') ADVANCE(1024);
      END_STATE();
    case 477:
      if (lookahead == 'n') ADVANCE(78);
      END_STATE();
    case 478:
      if (lookahead == 'n') ADVANCE(941);
      END_STATE();
    case 479:
      if (lookahead == 'n') ADVANCE(947);
      END_STATE();
    case 480:
      if (lookahead == 'n') ADVANCE(959);
      END_STATE();
    case 481:
      if (lookahead == 'n') ADVANCE(993);
      END_STATE();
    case 482:
      if (lookahead == 'n') ADVANCE(60);
      END_STATE();
    case 483:
      if (lookahead == 'n') ADVANCE(21);
      END_STATE();
    case 484:
      if (lookahead == 'n') ADVANCE(1010);
      END_STATE();
    case 485:
      if (lookahead == 'n') ADVANCE(1002);
      END_STATE();
    case 486:
      if (lookahead == 'n') ADVANCE(1001);
      END_STATE();
    case 487:
      if (lookahead == 'n') ADVANCE(1011);
      END_STATE();
    case 488:
      if (lookahead == 'n') ADVANCE(171);
      END_STATE();
    case 489:
      if (lookahead == 'n') ADVANCE(194);
      END_STATE();
    case 490:
      if (lookahead == 'n') ADVANCE(44);
      END_STATE();
    case 491:
      if (lookahead == 'n') ADVANCE(551);
      END_STATE();
    case 492:
      if (lookahead == 'n') ADVANCE(123);
      END_STATE();
    case 493:
      if (lookahead == 'n') ADVANCE(331);
      END_STATE();
    case 494:
      if (lookahead == 'n') ADVANCE(23);
      END_STATE();
    case 495:
      if (lookahead == 'n') ADVANCE(332);
      END_STATE();
    case 496:
      if (lookahead == 'n') ADVANCE(333);
      END_STATE();
    case 497:
      if (lookahead == 'n') ADVANCE(420);
      END_STATE();
    case 498:
      if (lookahead == 'n') ADVANCE(334);
      END_STATE();
    case 499:
      if (lookahead == 'n') ADVANCE(181);
      END_STATE();
    case 500:
      if (lookahead == 'n') ADVANCE(189);
      END_STATE();
    case 501:
      if (lookahead == 'n') ADVANCE(335);
      END_STATE();
    case 502:
      if (lookahead == 'n') ADVANCE(336);
      END_STATE();
    case 503:
      if (lookahead == 'n') ADVANCE(35);
      END_STATE();
    case 504:
      if (lookahead == 'n') ADVANCE(337);
      END_STATE();
    case 505:
      if (lookahead == 'n') ADVANCE(338);
      END_STATE();
    case 506:
      if (lookahead == 'n') ADVANCE(423);
      END_STATE();
    case 507:
      if (lookahead == 'n') ADVANCE(339);
      END_STATE();
    case 508:
      if (lookahead == 'n') ADVANCE(340);
      END_STATE();
    case 509:
      if (lookahead == 'n') ADVANCE(792);
      END_STATE();
    case 510:
      if (lookahead == 'n') ADVANCE(341);
      END_STATE();
    case 511:
      if (lookahead == 'n') ADVANCE(771);
      END_STATE();
    case 512:
      if (lookahead == 'n') ADVANCE(793);
      END_STATE();
    case 513:
      if (lookahead == 'n') ADVANCE(800);
      END_STATE();
    case 514:
      if (lookahead == 'n') ADVANCE(802);
      END_STATE();
    case 515:
      if (lookahead == 'n') ADVANCE(719);
      END_STATE();
    case 516:
      if (lookahead == 'n') ADVANCE(804);
      END_STATE();
    case 517:
      if (lookahead == 'n') ADVANCE(723);
      END_STATE();
    case 518:
      if (lookahead == 'n') ADVANCE(196);
      END_STATE();
    case 519:
      if (lookahead == 'n') ADVANCE(745);
      END_STATE();
    case 520:
      if (lookahead == 'n') ADVANCE(200);
      END_STATE();
    case 521:
      if (lookahead == 'n') ADVANCE(736);
      END_STATE();
    case 522:
      if (lookahead == 'n') ADVANCE(197);
      END_STATE();
    case 523:
      if (lookahead == 'n') ADVANCE(103);
      END_STATE();
    case 524:
      if (lookahead == 'n') ADVANCE(198);
      END_STATE();
    case 525:
      if (lookahead == 'n') ADVANCE(746);
      END_STATE();
    case 526:
      if (lookahead == 'n') ADVANCE(109);
      END_STATE();
    case 527:
      if (lookahead == 'n') ADVANCE(111);
      END_STATE();
    case 528:
      if (lookahead == 'n') ADVANCE(579);
      END_STATE();
    case 529:
      if (lookahead == 'n') ADVANCE(46);
      END_STATE();
    case 530:
      if (lookahead == 'n') ADVANCE(581);
      END_STATE();
    case 531:
      if (lookahead == 'n') ADVANCE(582);
      END_STATE();
    case 532:
      if (lookahead == 'n') ADVANCE(590);
      END_STATE();
    case 533:
      if (lookahead == 'n') ADVANCE(591);
      END_STATE();
    case 534:
      if (lookahead == 'n') ADVANCE(532);
      END_STATE();
    case 535:
      if (lookahead == 'n') ADVANCE(80);
      END_STATE();
    case 536:
      if (lookahead == 'n') ADVANCE(533);
      END_STATE();
    case 537:
      if (lookahead == 'o') ADVANCE(34);
      END_STATE();
    case 538:
      if (lookahead == 'o') ADVANCE(887);
      END_STATE();
    case 539:
      if (lookahead == 'o') ADVANCE(923);
      END_STATE();
    case 540:
      if (lookahead == 'o') ADVANCE(883);
      END_STATE();
    case 541:
      if (lookahead == 'o') ADVANCE(859);
      END_STATE();
    case 542:
      if (lookahead == 'o') ADVANCE(158);
      END_STATE();
    case 543:
      if (lookahead == 'o') ADVANCE(888);
      END_STATE();
    case 544:
      if (lookahead == 'o') ADVANCE(881);
      END_STATE();
    case 545:
      if (lookahead == 'o') ADVANCE(20);
      END_STATE();
    case 546:
      if (lookahead == 'o') ADVANCE(892);
      END_STATE();
    case 547:
      if (lookahead == 'o') ADVANCE(184);
      END_STATE();
    case 548:
      if (lookahead == 'o') ADVANCE(889);
      END_STATE();
    case 549:
      if (lookahead == 'o') ADVANCE(22);
      END_STATE();
    case 550:
      if (lookahead == 'o') ADVANCE(165);
      END_STATE();
    case 551:
      if (lookahead == 'o') ADVANCE(787);
      END_STATE();
    case 552:
      if (lookahead == 'o') ADVANCE(166);
      END_STATE();
    case 553:
      if (lookahead == 'o') ADVANCE(865);
      END_STATE();
    case 554:
      if (lookahead == 'o') ADVANCE(177);
      END_STATE();
    case 555:
      if (lookahead == 'o') ADVANCE(645);
      END_STATE();
    case 556:
      if (lookahead == 'o') ADVANCE(186);
      END_STATE();
    case 557:
      if (lookahead == 'o') ADVANCE(778);
      END_STATE();
    case 558:
      if (lookahead == 'o') ADVANCE(497);
      END_STATE();
    case 559:
      if (lookahead == 'o') ADVANCE(479);
      END_STATE();
    case 560:
      if (lookahead == 'o') ADVANCE(623);
      END_STATE();
    case 561:
      if (lookahead == 'o') ADVANCE(519);
      END_STATE();
    case 562:
      if (lookahead == 'o') ADVANCE(782);
      END_STATE();
    case 563:
      if (lookahead == 'o') ADVANCE(480);
      END_STATE();
    case 564:
      if (lookahead == 'o') ADVANCE(628);
      END_STATE();
    case 565:
      if (lookahead == 'o') ADVANCE(506);
      END_STATE();
    case 566:
      if (lookahead == 'o') ADVANCE(649);
      END_STATE();
    case 567:
      if (lookahead == 'o') ADVANCE(503);
      END_STATE();
    case 568:
      if (lookahead == 'o') ADVANCE(633);
      END_STATE();
    case 569:
      if (lookahead == 'o') ADVANCE(482);
      END_STATE();
    case 570:
      if (lookahead == 'o') ADVANCE(483);
      END_STATE();
    case 571:
      if (lookahead == 'o') ADVANCE(525);
      END_STATE();
    case 572:
      if (lookahead == 'o') ADVANCE(515);
      END_STATE();
    case 573:
      if (lookahead == 'o') ADVANCE(484);
      END_STATE();
    case 574:
      if (lookahead == 'o') ADVANCE(683);
      END_STATE();
    case 575:
      if (lookahead == 'o') ADVANCE(487);
      END_STATE();
    case 576:
      if (lookahead == 'o') ADVANCE(627);
      END_STATE();
    case 577:
      if (lookahead == 'o') ADVANCE(517);
      END_STATE();
    case 578:
      if (lookahead == 'o') ADVANCE(867);
      END_STATE();
    case 579:
      if (lookahead == 'o') ADVANCE(646);
      END_STATE();
    case 580:
      if (lookahead == 'o') ADVANCE(868);
      END_STATE();
    case 581:
      if (lookahead == 'o') ADVANCE(655);
      END_STATE();
    case 582:
      if (lookahead == 'o') ADVANCE(661);
      END_STATE();
    case 583:
      if (lookahead == 'o') ADVANCE(161);
      END_STATE();
    case 584:
      if (lookahead == 'o') ADVANCE(609);
      END_STATE();
    case 585:
      if (lookahead == 'o') ADVANCE(179);
      END_STATE();
    case 586:
      if (lookahead == 'o') ADVANCE(529);
      END_STATE();
    case 587:
      if (lookahead == 'o') ADVANCE(162);
      END_STATE();
    case 588:
      if (lookahead == 'o') ADVANCE(610);
      END_STATE();
    case 589:
      if (lookahead == 'o') ADVANCE(877);
      END_STATE();
    case 590:
      if (lookahead == 'o') ADVANCE(850);
      END_STATE();
    case 591:
      if (lookahead == 'o') ADVANCE(854);
      END_STATE();
    case 592:
      if (lookahead == 'o') ADVANCE(890);
      END_STATE();
    case 593:
      if (lookahead == 'p') ADVANCE(247);
      END_STATE();
    case 594:
      if (lookahead == 'p') ADVANCE(976);
      END_STATE();
    case 595:
      if (lookahead == 'p') ADVANCE(68);
      END_STATE();
    case 596:
      if (lookahead == 'p') ADVANCE(426);
      END_STATE();
    case 597:
      if (lookahead == 'p') ADVANCE(744);
      END_STATE();
    case 598:
      if (lookahead == 'p') ADVANCE(424);
      END_STATE();
    case 599:
      if (lookahead == 'p') ADVANCE(127);
      END_STATE();
    case 600:
      if (lookahead == 'p') ADVANCE(611);
      END_STATE();
    case 601:
      if (lookahead == 'p') ADVANCE(785);
      END_STATE();
    case 602:
      if (lookahead == 'p') ADVANCE(643);
      END_STATE();
    case 603:
      if (lookahead == 'p') ADVANCE(228);
      END_STATE();
    case 604:
      if (lookahead == 'p') ADVANCE(281);
      END_STATE();
    case 605:
      if (lookahead == 'p') ADVANCE(430);
      END_STATE();
    case 606:
      if (lookahead == 'p') ADVANCE(116);
      END_STATE();
    case 607:
      if (lookahead == 'p') ADVANCE(693);
      END_STATE();
    case 608:
      if (lookahead == 'p') ADVANCE(260);
      END_STATE();
    case 609:
      if (lookahead == 'p') ADVANCE(270);
      END_STATE();
    case 610:
      if (lookahead == 'p') ADVANCE(274);
      END_STATE();
    case 611:
      if (lookahead == 'p') ADVANCE(673);
      END_STATE();
    case 612:
      if (lookahead == 'p') ADVANCE(681);
      END_STATE();
    case 613:
      if (lookahead == 'p') ADVANCE(441);
      END_STATE();
    case 614:
      if (lookahead == 'p') ADVANCE(443);
      END_STATE();
    case 615:
      if (lookahead == 'p') ADVANCE(444);
      END_STATE();
    case 616:
      if (lookahead == 'p') ADVANCE(445);
      END_STATE();
    case 617:
      if (lookahead == 'p') ADVANCE(153);
      END_STATE();
    case 618:
      if (lookahead == 'p') ADVANCE(450);
      END_STATE();
    case 619:
      if (lookahead == 'p') ADVANCE(696);
      END_STATE();
    case 620:
      if (lookahead == 'r') ADVANCE(343);
      END_STATE();
    case 621:
      if (lookahead == 'r') ADVANCE(944);
      END_STATE();
    case 622:
      if (lookahead == 'r') ADVANCE(957);
      END_STATE();
    case 623:
      if (lookahead == 'r') ADVANCE(931);
      END_STATE();
    case 624:
      if (lookahead == 'r') ADVANCE(991);
      END_STATE();
    case 625:
      if (lookahead == 'r') ADVANCE(972);
      END_STATE();
    case 626:
      if (lookahead == 'r') ADVANCE(998);
      END_STATE();
    case 627:
      if (lookahead == 'r') ADVANCE(989);
      END_STATE();
    case 628:
      if (lookahead == 'r') ADVANCE(898);
      END_STATE();
    case 629:
      if (lookahead == 'r') ADVANCE(727);
      END_STATE();
    case 630:
      if (lookahead == 'r') ADVANCE(538);
      END_STATE();
    case 631:
      if (lookahead == 'r') ADVANCE(698);
      END_STATE();
    case 632:
      if (lookahead == 'r') ADVANCE(365);
      END_STATE();
    case 633:
      if (lookahead == 'r') ADVANCE(457);
      END_STATE();
    case 634:
      if (lookahead == 'r') ADVANCE(349);
      END_STATE();
    case 635:
      if (lookahead == 'r') ADVANCE(372);
      END_STATE();
    case 636:
      if (lookahead == 'r') ADVANCE(523);
      END_STATE();
    case 637:
      if (lookahead == 'r') ADVANCE(780);
      END_STATE();
    case 638:
      if (lookahead == 'r') ADVANCE(478);
      END_STATE();
    case 639:
      if (lookahead == 'r') ADVANCE(871);
      END_STATE();
    case 640:
      if (lookahead == 'r') ADVANCE(396);
      END_STATE();
    case 641:
      if (lookahead == 'r') ADVANCE(861);
      END_STATE();
    case 642:
      if (lookahead == 'r') ADVANCE(544);
      END_STATE();
    case 643:
      if (lookahead == 'r') ADVANCE(366);
      END_STATE();
    case 644:
      if (lookahead == 'r') ADVANCE(368);
      END_STATE();
    case 645:
      if (lookahead == 'r') ADVANCE(211);
      END_STATE();
    case 646:
      if (lookahead == 'r') ADVANCE(212);
      END_STATE();
    case 647:
      if (lookahead == 'r') ADVANCE(554);
      END_STATE();
    case 648:
      if (lookahead == 'r') ADVANCE(772);
      END_STATE();
    case 649:
      if (lookahead == 'r') ADVANCE(814);
      END_STATE();
    case 650:
      if (lookahead == 'r') ADVANCE(481);
      END_STATE();
    case 651:
      if (lookahead == 'r') ADVANCE(786);
      END_STATE();
    case 652:
      if (lookahead == 'r') ADVANCE(220);
      END_STATE();
    case 653:
      if (lookahead == 'r') ADVANCE(794);
      END_STATE();
    case 654:
      if (lookahead == 'r') ADVANCE(261);
      if (lookahead == 'w') ADVANCE(640);
      END_STATE();
    case 655:
      if (lookahead == 'r') ADVANCE(253);
      END_STATE();
    case 656:
      if (lookahead == 'r') ADVANCE(775);
      END_STATE();
    case 657:
      if (lookahead == 'r') ADVANCE(257);
      END_STATE();
    case 658:
      if (lookahead == 'r') ADVANCE(485);
      END_STATE();
    case 659:
      if (lookahead == 'r') ADVANCE(486);
      END_STATE();
    case 660:
      if (lookahead == 'r') ADVANCE(265);
      if (lookahead == 'w') ADVANCE(686);
      END_STATE();
    case 661:
      if (lookahead == 'r') ADVANCE(229);
      END_STATE();
    case 662:
      if (lookahead == 'r') ADVANCE(283);
      END_STATE();
    case 663:
      if (lookahead == 'r') ADVANCE(278);
      END_STATE();
    case 664:
      if (lookahead == 'r') ADVANCE(882);
      END_STATE();
    case 665:
      if (lookahead == 'r') ADVANCE(172);
      END_STATE();
    case 666:
      if (lookahead == 'r') ADVANCE(173);
      END_STATE();
    case 667:
      if (lookahead == 'r') ADVANCE(375);
      END_STATE();
    case 668:
      if (lookahead == 'r') ADVANCE(96);
      END_STATE();
    case 669:
      if (lookahead == 'r') ADVANCE(284);
      END_STATE();
    case 670:
      if (lookahead == 'r') ADVANCE(174);
      END_STATE();
    case 671:
      if (lookahead == 'r') ADVANCE(378);
      END_STATE();
    case 672:
      if (lookahead == 'r') ADVANCE(254);
      END_STATE();
    case 673:
      if (lookahead == 'r') ADVANCE(294);
      END_STATE();
    case 674:
      if (lookahead == 'r') ADVANCE(380);
      END_STATE();
    case 675:
      if (lookahead == 'r') ADVANCE(383);
      END_STATE();
    case 676:
      if (lookahead == 'r') ADVANCE(384);
      END_STATE();
    case 677:
      if (lookahead == 'r') ADVANCE(385);
      END_STATE();
    case 678:
      if (lookahead == 'r') ADVANCE(386);
      END_STATE();
    case 679:
      if (lookahead == 'r') ADVANCE(387);
      END_STATE();
    case 680:
      if (lookahead == 'r') ADVANCE(388);
      END_STATE();
    case 681:
      if (lookahead == 'r') ADVANCE(301);
      END_STATE();
    case 682:
      if (lookahead == 'r') ADVANCE(389);
      END_STATE();
    case 683:
      if (lookahead == 'r') ADVANCE(813);
      END_STATE();
    case 684:
      if (lookahead == 'r') ADVANCE(326);
      END_STATE();
    case 685:
      if (lookahead == 'r') ADVANCE(526);
      END_STATE();
    case 686:
      if (lookahead == 'r') ADVANCE(403);
      END_STATE();
    case 687:
      if (lookahead == 'r') ADVANCE(585);
      END_STATE();
    case 688:
      if (lookahead == 'r') ADVANCE(308);
      END_STATE();
    case 689:
      if (lookahead == 'r') ADVANCE(132);
      END_STATE();
    case 690:
      if (lookahead == 'r') ADVANCE(527);
      END_STATE();
    case 691:
      if (lookahead == 'r') ADVANCE(137);
      END_STATE();
    case 692:
      if (lookahead == 'r') ADVANCE(756);
      END_STATE();
    case 693:
      if (lookahead == 'r') ADVANCE(588);
      END_STATE();
    case 694:
      if (lookahead == 'r') ADVANCE(145);
      END_STATE();
    case 695:
      if (lookahead == 'r') ADVANCE(837);
      END_STATE();
    case 696:
      if (lookahead == 'r') ADVANCE(406);
      END_STATE();
    case 697:
      if (lookahead == 's') ADVANCE(73);
      END_STATE();
    case 698:
      if (lookahead == 's') ADVANCE(968);
      END_STATE();
    case 699:
      if (lookahead == 's') ADVANCE(943);
      END_STATE();
    case 700:
      if (lookahead == 's') ADVANCE(973);
      END_STATE();
    case 701:
      if (lookahead == 's') ADVANCE(953);
      END_STATE();
    case 702:
      if (lookahead == 's') ADVANCE(980);
      END_STATE();
    case 703:
      if (lookahead == 's') ADVANCE(72);
      END_STATE();
    case 704:
      if (lookahead == 's') ADVANCE(958);
      END_STATE();
    case 705:
      if (lookahead == 's') ADVANCE(951);
      END_STATE();
    case 706:
      if (lookahead == 's') ADVANCE(963);
      END_STATE();
    case 707:
      if (lookahead == 's') ADVANCE(960);
      END_STATE();
    case 708:
      if (lookahead == 's') ADVANCE(1020);
      END_STATE();
    case 709:
      if (lookahead == 's') ADVANCE(981);
      END_STATE();
    case 710:
      if (lookahead == 's') ADVANCE(999);
      END_STATE();
    case 711:
      if (lookahead == 's') ADVANCE(954);
      END_STATE();
    case 712:
      if (lookahead == 's') ADVANCE(969);
      END_STATE();
    case 713:
      if (lookahead == 's') ADVANCE(1013);
      END_STATE();
    case 714:
      if (lookahead == 's') ADVANCE(952);
      END_STATE();
    case 715:
      if (lookahead == 's') ADVANCE(982);
      END_STATE();
    case 716:
      if (lookahead == 's') ADVANCE(1022);
      END_STATE();
    case 717:
      if (lookahead == 's') ADVANCE(1003);
      END_STATE();
    case 718:
      if (lookahead == 's') ADVANCE(961);
      END_STATE();
    case 719:
      if (lookahead == 's') ADVANCE(975);
      END_STATE();
    case 720:
      if (lookahead == 's') ADVANCE(1023);
      END_STATE();
    case 721:
      if (lookahead == 's') ADVANCE(990);
      END_STATE();
    case 722:
      if (lookahead == 's') ADVANCE(983);
      END_STATE();
    case 723:
      if (lookahead == 's') ADVANCE(970);
      END_STATE();
    case 724:
      if (lookahead == 's') ADVANCE(974);
      END_STATE();
    case 725:
      if (lookahead == 's') ADVANCE(207);
      END_STATE();
    case 726:
      if (lookahead == 's') ADVANCE(19);
      END_STATE();
    case 727:
      if (lookahead == 's') ADVANCE(390);
      END_STATE();
    case 728:
      if (lookahead == 's') ADVANCE(796);
      END_STATE();
    case 729:
      if (lookahead == 's') ADVANCE(42);
      END_STATE();
    case 730:
      if (lookahead == 's') ADVANCE(43);
      END_STATE();
    case 731:
      if (lookahead == 's') ADVANCE(589);
      END_STATE();
    case 732:
      if (lookahead == 's') ADVANCE(791);
      END_STATE();
    case 733:
      if (lookahead == 's') ADVANCE(704);
      END_STATE();
    case 734:
      if (lookahead == 's') ADVANCE(706);
      END_STATE();
    case 735:
      if (lookahead == 's') ADVANCE(102);
      END_STATE();
    case 736:
      if (lookahead == 's') ADVANCE(215);
      END_STATE();
    case 737:
      if (lookahead == 's') ADVANCE(708);
      END_STATE();
    case 738:
      if (lookahead == 's') ADVANCE(712);
      END_STATE();
    case 739:
      if (lookahead == 's') ADVANCE(715);
      END_STATE();
    case 740:
      if (lookahead == 's') ADVANCE(223);
      END_STATE();
    case 741:
      if (lookahead == 's') ADVANCE(726);
      END_STATE();
    case 742:
      if (lookahead == 's') ADVANCE(262);
      END_STATE();
    case 743:
      if (lookahead == 's') ADVANCE(234);
      END_STATE();
    case 744:
      if (lookahead == 's') ADVANCE(788);
      END_STATE();
    case 745:
      if (lookahead == 's') ADVANCE(377);
      END_STATE();
    case 746:
      if (lookahead == 's') ADVANCE(807);
      END_STATE();
    case 747:
      if (lookahead == 's') ADVANCE(259);
      END_STATE();
    case 748:
      if (lookahead == 's') ADVANCE(751);
      END_STATE();
    case 749:
      if (lookahead == 's') ADVANCE(818);
      END_STATE();
    case 750:
      if (lookahead == 's') ADVANCE(268);
      END_STATE();
    case 751:
      if (lookahead == 's') ADVANCE(277);
      END_STATE();
    case 752:
      if (lookahead == 's') ADVANCE(276);
      END_STATE();
    case 753:
      if (lookahead == 's') ADVANCE(361);
      END_STATE();
    case 754:
      if (lookahead == 's') ADVANCE(143);
      END_STATE();
    case 755:
      if (lookahead == 's') ADVANCE(752);
      END_STATE();
    case 756:
      if (lookahead == 's') ADVANCE(395);
      END_STATE();
    case 757:
      if (lookahead == 's') ADVANCE(828);
      END_STATE();
    case 758:
      if (lookahead == 's') ADVANCE(832);
      END_STATE();
    case 759:
      if (lookahead == 's') ADVANCE(834);
      END_STATE();
    case 760:
      if (lookahead == 's') ADVANCE(836);
      END_STATE();
    case 761:
      if (lookahead == 's') ADVANCE(839);
      END_STATE();
    case 762:
      if (lookahead == 's') ADVANCE(841);
      END_STATE();
    case 763:
      if (lookahead == 's') ADVANCE(843);
      END_STATE();
    case 764:
      if (lookahead == 's') ADVANCE(847);
      END_STATE();
    case 765:
      if (lookahead == 't') ADVANCE(357);
      END_STATE();
    case 766:
      if (lookahead == 't') ADVANCE(985);
      END_STATE();
    case 767:
      if (lookahead == 't') ADVANCE(988);
      END_STATE();
    case 768:
      if (lookahead == 't') ADVANCE(67);
      END_STATE();
    case 769:
      if (lookahead == 't') ADVANCE(922);
      END_STATE();
    case 770:
      if (lookahead == 't') ADVANCE(1014);
      END_STATE();
    case 771:
      if (lookahead == 't') ADVANCE(1036);
      END_STATE();
    case 772:
      if (lookahead == 't') ADVANCE(1016);
      END_STATE();
    case 773:
      if (lookahead == 't') ADVANCE(1000);
      END_STATE();
    case 774:
      if (lookahead == 't') ADVANCE(1015);
      END_STATE();
    case 775:
      if (lookahead == 't') ADVANCE(967);
      END_STATE();
    case 776:
      if (lookahead == 't') ADVANCE(88);
      END_STATE();
    case 777:
      if (lookahead == 't') ADVANCE(66);
      END_STATE();
    case 778:
      if (lookahead == 't') ADVANCE(76);
      END_STATE();
    case 779:
      if (lookahead == 't') ADVANCE(353);
      END_STATE();
    case 780:
      if (lookahead == 't') ADVANCE(899);
      END_STATE();
    case 781:
      if (lookahead == 't') ADVANCE(250);
      END_STATE();
    case 782:
      if (lookahead == 't') ADVANCE(360);
      END_STATE();
    case 783:
      if (lookahead == 't') ADVANCE(240);
      END_STATE();
    case 784:
      if (lookahead == 't') ADVANCE(359);
      END_STATE();
    case 785:
      if (lookahead == 't') ADVANCE(903);
      END_STATE();
    case 786:
      if (lookahead == 't') ADVANCE(901);
      END_STATE();
    case 787:
      if (lookahead == 't') ADVANCE(98);
      END_STATE();
    case 788:
      if (lookahead == 't') ADVANCE(105);
      END_STATE();
    case 789:
      if (lookahead == 't') ADVANCE(905);
      END_STATE();
    case 790:
      if (lookahead == 't') ADVANCE(370);
      END_STATE();
    case 791:
      if (lookahead == 't') ADVANCE(703);
      END_STATE();
    case 792:
      if (lookahead == 't') ADVANCE(705);
      END_STATE();
    case 793:
      if (lookahead == 't') ADVANCE(31);
      END_STATE();
    case 794:
      if (lookahead == 't') ADVANCE(397);
      END_STATE();
    case 795:
      if (lookahead == 't') ADVANCE(94);
      END_STATE();
    case 796:
      if (lookahead == 't') ADVANCE(667);
      END_STATE();
    case 797:
      if (lookahead == 't') ADVANCE(545);
      END_STATE();
    case 798:
      if (lookahead == 't') ADVANCE(549);
      END_STATE();
    case 799:
      if (lookahead == 't') ADVANCE(218);
      END_STATE();
    case 800:
      if (lookahead == 't') ADVANCE(713);
      END_STATE();
    case 801:
      if (lookahead == 't') ADVANCE(251);
      END_STATE();
    case 802:
      if (lookahead == 't') ADVANCE(714);
      END_STATE();
    case 803:
      if (lookahead == 't') ADVANCE(644);
      END_STATE();
    case 804:
      if (lookahead == 't') ADVANCE(720);
      END_STATE();
    case 805:
      if (lookahead == 't') ADVANCE(305);
      END_STATE();
    case 806:
      if (lookahead == 't') ADVANCE(224);
      END_STATE();
    case 807:
      if (lookahead == 't') ADVANCE(641);
      END_STATE();
    case 808:
      if (lookahead == 't') ADVANCE(225);
      END_STATE();
    case 809:
      if (lookahead == 't') ADVANCE(227);
      END_STATE();
    case 810:
      if (lookahead == 't') ADVANCE(230);
      END_STATE();
    case 811:
      if (lookahead == 't') ADVANCE(319);
      END_STATE();
    case 812:
      if (lookahead == 't') ADVANCE(233);
      END_STATE();
    case 813:
      if (lookahead == 't') ADVANCE(279);
      END_STATE();
    case 814:
      if (lookahead == 't') ADVANCE(40);
      END_STATE();
    case 815:
      if (lookahead == 't') ADVANCE(803);
      END_STATE();
    case 816:
      if (lookahead == 't') ADVANCE(112);
      END_STATE();
    case 817:
      if (lookahead == 't') ADVANCE(316);
      END_STATE();
    case 818:
      if (lookahead == 't') ADVANCE(295);
      END_STATE();
    case 819:
      if (lookahead == 't') ADVANCE(356);
      END_STATE();
    case 820:
      if (lookahead == 't') ADVANCE(869);
      END_STATE();
    case 821:
      if (lookahead == 't') ADVANCE(118);
      END_STATE();
    case 822:
      if (lookahead == 't') ADVANCE(870);
      END_STATE();
    case 823:
      if (lookahead == 't') ADVANCE(576);
      END_STATE();
    case 824:
      if (lookahead == 't') ADVANCE(273);
      END_STATE();
    case 825:
      if (lookahead == 't') ADVANCE(275);
      END_STATE();
    case 826:
      if (lookahead == 't') ADVANCE(392);
      END_STATE();
    case 827:
      if (lookahead == 't') ADVANCE(293);
      END_STATE();
    case 828:
      if (lookahead == 't') ADVANCE(671);
      END_STATE();
    case 829:
      if (lookahead == 't') ADVANCE(306);
      END_STATE();
    case 830:
      if (lookahead == 't') ADVANCE(394);
      END_STATE();
    case 831:
      if (lookahead == 't') ADVANCE(296);
      END_STATE();
    case 832:
      if (lookahead == 't') ADVANCE(674);
      END_STATE();
    case 833:
      if (lookahead == 't') ADVANCE(310);
      END_STATE();
    case 834:
      if (lookahead == 't') ADVANCE(675);
      END_STATE();
    case 835:
      if (lookahead == 't') ADVANCE(398);
      END_STATE();
    case 836:
      if (lookahead == 't') ADVANCE(676);
      END_STATE();
    case 837:
      if (lookahead == 't') ADVANCE(399);
      END_STATE();
    case 838:
      if (lookahead == 't') ADVANCE(140);
      END_STATE();
    case 839:
      if (lookahead == 't') ADVANCE(677);
      END_STATE();
    case 840:
      if (lookahead == 't') ADVANCE(405);
      END_STATE();
    case 841:
      if (lookahead == 't') ADVANCE(678);
      END_STATE();
    case 842:
      if (lookahead == 't') ADVANCE(400);
      END_STATE();
    case 843:
      if (lookahead == 't') ADVANCE(679);
      END_STATE();
    case 844:
      if (lookahead == 't') ADVANCE(401);
      END_STATE();
    case 845:
      if (lookahead == 't') ADVANCE(680);
      END_STATE();
    case 846:
      if (lookahead == 't') ADVANCE(402);
      END_STATE();
    case 847:
      if (lookahead == 't') ADVANCE(682);
      END_STATE();
    case 848:
      if (lookahead == 't') ADVANCE(309);
      END_STATE();
    case 849:
      if (lookahead == 't') ADVANCE(144);
      END_STATE();
    case 850:
      if (lookahead == 't') ADVANCE(147);
      END_STATE();
    case 851:
      if (lookahead == 't') ADVANCE(148);
      END_STATE();
    case 852:
      if (lookahead == 't') ADVANCE(149);
      END_STATE();
    case 853:
      if (lookahead == 't') ADVANCE(150);
      END_STATE();
    case 854:
      if (lookahead == 't') ADVANCE(151);
      END_STATE();
    case 855:
      if (lookahead == 't') ADVANCE(320);
      END_STATE();
    case 856:
      if (lookahead == 'u') ADVANCE(376);
      END_STATE();
    case 857:
      if (lookahead == 'u') ADVANCE(665);
      END_STATE();
    case 858:
      if (lookahead == 'u') ADVANCE(454);
      END_STATE();
    case 859:
      if (lookahead == 'u') ADVANCE(594);
      END_STATE();
    case 860:
      if (lookahead == 'u') ADVANCE(595);
      END_STATE();
    case 861:
      if (lookahead == 'u') ADVANCE(176);
      END_STATE();
    case 862:
      if (lookahead == 'u') ADVANCE(638);
      END_STATE();
    case 863:
      if (lookahead == 'u') ADVANCE(433);
      END_STATE();
    case 864:
      if (lookahead == 'u') ADVANCE(735);
      END_STATE();
    case 865:
      if (lookahead == 'u') ADVANCE(770);
      END_STATE();
    case 866:
      if (lookahead == 'u') ADVANCE(650);
      END_STATE();
    case 867:
      if (lookahead == 'u') ADVANCE(773);
      END_STATE();
    case 868:
      if (lookahead == 'u') ADVANCE(774);
      END_STATE();
    case 869:
      if (lookahead == 'u') ADVANCE(658);
      END_STATE();
    case 870:
      if (lookahead == 'u') ADVANCE(659);
      END_STATE();
    case 871:
      if (lookahead == 'u') ADVANCE(232);
      END_STATE();
    case 872:
      if (lookahead == 'u') ADVANCE(438);
      END_STATE();
    case 873:
      if (lookahead == 'u') ADVANCE(393);
      END_STATE();
    case 874:
      if (lookahead == 'u') ADVANCE(795);
      END_STATE();
    case 875:
      if (lookahead == 'u') ADVANCE(824);
      END_STATE();
    case 876:
      if (lookahead == 'u') ADVANCE(465);
      END_STATE();
    case 877:
      if (lookahead == 'u') ADVANCE(670);
      END_STATE();
    case 878:
      if (lookahead == 'u') ADVANCE(851);
      END_STATE();
    case 879:
      if (lookahead == 'u') ADVANCE(852);
      END_STATE();
    case 880:
      if (lookahead == 'u') ADVANCE(853);
      END_STATE();
    case 881:
      if (lookahead == 'v') ADVANCE(369);
      END_STATE();
    case 882:
      if (lookahead == 'v') ADVANCE(217);
      END_STATE();
    case 883:
      if (lookahead == 'v') ADVANCE(264);
      END_STATE();
    case 884:
      if (lookahead == 'v') ADVANCE(311);
      END_STATE();
    case 885:
      if (lookahead == 'v') ADVANCE(141);
      END_STATE();
    case 886:
      if (lookahead == 'v') ADVANCE(155);
      END_STATE();
    case 887:
      if (lookahead == 'w') ADVANCE(699);
      END_STATE();
    case 888:
      if (lookahead == 'w') ADVANCE(41);
      END_STATE();
    case 889:
      if (lookahead == 'w') ADVANCE(272);
      END_STATE();
    case 890:
      if (lookahead == 'w') ADVANCE(51);
      END_STATE();
    case 891:
      if (lookahead == 'x') ADVANCE(87);
      END_STATE();
    case 892:
      if (lookahead == 'x') ADVANCE(987);
      END_STATE();
    case 893:
      if (lookahead == 'x') ADVANCE(371);
      END_STATE();
    case 894:
      if (lookahead == 'x') ADVANCE(827);
      END_STATE();
    case 895:
      if (lookahead == 'x') ADVANCE(829);
      END_STATE();
    case 896:
      if (lookahead == 'x') ADVANCE(612);
      END_STATE();
    case 897:
      if (lookahead == 'x') ADVANCE(831);
      END_STATE();
    case 898:
      if (lookahead == 'y') ADVANCE(921);
      END_STATE();
    case 899:
      if (lookahead == 'y') ADVANCE(938);
      END_STATE();
    case 900:
      if (lookahead == 'y') ADVANCE(1005);
      END_STATE();
    case 901:
      if (lookahead == 'y') ADVANCE(994);
      END_STATE();
    case 902:
      if (lookahead == 'y') ADVANCE(1004);
      END_STATE();
    case 903:
      if (lookahead == 'y') ADVANCE(33);
      END_STATE();
    case 904:
      if (lookahead == 'y') ADVANCE(632);
      END_STATE();
    case 905:
      if (lookahead == 'y') ADVANCE(603);
      END_STATE();
    case 906:
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(24);
      END_STATE();
    case 907:
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '<') ADVANCE(1134);
      END_STATE();
    case 908:
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '}') ADVANCE(1143);
      END_STATE();
    case 909:
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ') ADVANCE(1139);
      END_STATE();
    case 910:
      if (eof) ADVANCE(911);
      if (lookahead == '\n') SKIP(910);
      if (lookahead == '\r') SKIP(0);
      if (lookahead == '"') ADVANCE(1028);
      if (lookahead == '$') ADVANCE(1132);
      if (lookahead == '&') ADVANCE(1129);
      if (lookahead == '\'') ADVANCE(1027);
      if (lookahead == '(') ADVANCE(1130);
      if (lookahead == ')') ADVANCE(1131);
      if (lookahead == '*') ADVANCE(15);
      if (lookahead == ',') ADVANCE(1026);
      if (lookahead == '/') ADVANCE(27);
      if (lookahead == ':') ADVANCE(1033);
      if (lookahead == '<') ADVANCE(932);
      if (lookahead == '=') ADVANCE(1146);
      if (lookahead == '>') ADVANCE(933);
      if (lookahead == '?') ADVANCE(1031);
      if (lookahead == '@') ADVANCE(82);
      if (lookahead == 'C') ADVANCE(1112);
      if (lookahead == 'N') ADVANCE(1113);
      if (lookahead == '[') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(1127);
      if (lookahead == 'c') ADVANCE(1057);
      if (lookahead == 'e') ADVANCE(1088);
      if (lookahead == 'h') ADVANCE(1105);
      if (lookahead == 'i') ADVANCE(1090);
      if (lookahead == 'l') ADVANCE(1082);
      if (lookahead == 'n') ADVANCE(1092);
      if (lookahead == 'p') ADVANCE(1091);
      if (lookahead == 't') ADVANCE(1096);
      if (lookahead == '{') ADVANCE(913);
      if (lookahead == '|') ADVANCE(1128);
      if (lookahead == '}') ADVANCE(916);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(910);
      if (lookahead == 0x0b ||
          lookahead == '\f') SKIP(0);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1029);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 911:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 912:
      ACCEPT_TOKEN(sym__begin);
      if (lookahead == '*') ADVANCE(912);
      END_STATE();
    case 913:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 914:
      ACCEPT_TOKEN(anon_sym_ATinheritdoc);
      END_STATE();
    case 915:
      ACCEPT_TOKEN(anon_sym_ATinheritDoc);
      END_STATE();
    case 916:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 917:
      ACCEPT_TOKEN(anon_sym_ATapi);
      END_STATE();
    case 918:
      ACCEPT_TOKEN(anon_sym_ATfilesource);
      END_STATE();
    case 919:
      ACCEPT_TOKEN(anon_sym_ATignore);
      END_STATE();
    case 920:
      ACCEPT_TOKEN(anon_sym_ATinternal);
      END_STATE();
    case 921:
      ACCEPT_TOKEN(anon_sym_ATcategory);
      END_STATE();
    case 922:
      ACCEPT_TOKEN(anon_sym_ATcopyright);
      END_STATE();
    case 923:
      ACCEPT_TOKEN(anon_sym_ATtodo);
      END_STATE();
    case 924:
      ACCEPT_TOKEN(anon_sym_ATexample);
      END_STATE();
    case 925:
      ACCEPT_TOKEN(anon_sym_ATlicense);
      END_STATE();
    case 926:
      ACCEPT_TOKEN(anon_sym_ATpackage);
      END_STATE();
    case 927:
      ACCEPT_TOKEN(anon_sym_ATpackage);
      if (lookahead == '_') ADVANCE(884);
      END_STATE();
    case 928:
      ACCEPT_TOKEN(anon_sym_ATsource);
      END_STATE();
    case 929:
      ACCEPT_TOKEN(anon_sym_ATsubpackage);
      END_STATE();
    case 930:
      ACCEPT_TOKEN(anon_sym_ATuses);
      END_STATE();
    case 931:
      ACCEPT_TOKEN(anon_sym_ATauthor);
      END_STATE();
    case 932:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 933:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 934:
      ACCEPT_TOKEN(anon_sym_ATglobal);
      END_STATE();
    case 935:
      ACCEPT_TOKEN(anon_sym_ATlink);
      END_STATE();
    case 936:
      ACCEPT_TOKEN(anon_sym_ATmethod);
      END_STATE();
    case 937:
      ACCEPT_TOKEN(anon_sym_ATparam);
      if (lookahead == '-') ADVANCE(553);
      END_STATE();
    case 938:
      ACCEPT_TOKEN(anon_sym_ATproperty);
      if (lookahead == '-') ADVANCE(654);
      END_STATE();
    case 939:
      ACCEPT_TOKEN(anon_sym_ATproperty_DASHread);
      END_STATE();
    case 940:
      ACCEPT_TOKEN(anon_sym_ATproperty_DASHwrite);
      END_STATE();
    case 941:
      ACCEPT_TOKEN(anon_sym_ATreturn);
      END_STATE();
    case 942:
      ACCEPT_TOKEN(anon_sym_ATsee);
      END_STATE();
    case 943:
      ACCEPT_TOKEN(anon_sym_ATthrows);
      END_STATE();
    case 944:
      ACCEPT_TOKEN(anon_sym_ATvar);
      END_STATE();
    case 945:
      ACCEPT_TOKEN(anon_sym_ATdeprecated);
      END_STATE();
    case 946:
      ACCEPT_TOKEN(anon_sym_ATsince);
      END_STATE();
    case 947:
      ACCEPT_TOKEN(anon_sym_ATversion);
      END_STATE();
    case 948:
      ACCEPT_TOKEN(anon_sym_ATtemplate);
      if (lookahead == '-') ADVANCE(288);
      END_STATE();
    case 949:
      ACCEPT_TOKEN(anon_sym_ATpsalm_DASHtemplate);
      END_STATE();
    case 950:
      ACCEPT_TOKEN(anon_sym_ATphpstan_DASHtemplate);
      END_STATE();
    case 951:
      ACCEPT_TOKEN(anon_sym_ATimplements);
      END_STATE();
    case 952:
      ACCEPT_TOKEN(anon_sym_ATtemplate_DASHimplements);
      END_STATE();
    case 953:
      ACCEPT_TOKEN(anon_sym_ATextends);
      END_STATE();
    case 954:
      ACCEPT_TOKEN(anon_sym_ATtemplate_DASHextends);
      END_STATE();
    case 955:
      ACCEPT_TOKEN(anon_sym_ATuse);
      if (lookahead == 's') ADVANCE(930);
      END_STATE();
    case 956:
      ACCEPT_TOKEN(anon_sym_ATtemplate_DASHuse);
      END_STATE();
    case 957:
      ACCEPT_TOKEN(anon_sym_ATafter);
      if (lookahead == 'C') ADVANCE(425);
      END_STATE();
    case 958:
      ACCEPT_TOKEN(anon_sym_ATafterClass);
      END_STATE();
    case 959:
      ACCEPT_TOKEN(anon_sym_ATannotation);
      END_STATE();
    case 960:
      ACCEPT_TOKEN(anon_sym_ATbackupGlobals);
      END_STATE();
    case 961:
      ACCEPT_TOKEN(anon_sym_ATbackupStaticAttributes);
      END_STATE();
    case 962:
      ACCEPT_TOKEN(anon_sym_ATbefore);
      if (lookahead == 'C') ADVANCE(440);
      END_STATE();
    case 963:
      ACCEPT_TOKEN(anon_sym_ATbeforeClass);
      END_STATE();
    case 964:
      ACCEPT_TOKEN(anon_sym_ATcodeCoverageIgnore);
      if (lookahead == '*') ADVANCE(965);
      if (lookahead == 'E') ADVANCE(500);
      if (lookahead == 'S') ADVANCE(821);
      END_STATE();
    case 965:
      ACCEPT_TOKEN(anon_sym_ATcodeCoverageIgnore_STAR);
      END_STATE();
    case 966:
      ACCEPT_TOKEN(anon_sym_ATcodeCoverageIgnoreEnd);
      END_STATE();
    case 967:
      ACCEPT_TOKEN(anon_sym_ATcodeCoverageIgnoreStart);
      END_STATE();
    case 968:
      ACCEPT_TOKEN(anon_sym_ATcovers);
      if (lookahead == 'D') ADVANCE(238);
      if (lookahead == 'N') ADVANCE(562);
      END_STATE();
    case 969:
      ACCEPT_TOKEN(anon_sym_ATcoversDefaultClass);
      if (lookahead == ' ') ADVANCE(797);
      END_STATE();
    case 970:
      ACCEPT_TOKEN(anon_sym_ATcoversDefaultClasstoshortenannotations);
      END_STATE();
    case 971:
      ACCEPT_TOKEN(anon_sym_ATcoversNothing);
      END_STATE();
    case 972:
      ACCEPT_TOKEN(anon_sym_ATdataProvider);
      END_STATE();
    case 973:
      ACCEPT_TOKEN(anon_sym_ATdepends);
      if (lookahead == ' ') ADVANCE(110);
      END_STATE();
    case 974:
      ACCEPT_TOKEN(anon_sym_ATdependsannotationtoexpressdependencies);
      END_STATE();
    case 975:
      ACCEPT_TOKEN(anon_sym_ATdoesNotPerformAssertions);
      END_STATE();
    case 976:
      ACCEPT_TOKEN(anon_sym_ATgroup);
      END_STATE();
    case 977:
      ACCEPT_TOKEN(anon_sym_ATlarge);
      END_STATE();
    case 978:
      ACCEPT_TOKEN(anon_sym_ATmedium);
      END_STATE();
    case 979:
      ACCEPT_TOKEN(anon_sym_ATpreserveGlobalState);
      END_STATE();
    case 980:
      ACCEPT_TOKEN(anon_sym_ATrequires);
      if (lookahead == ' ') ADVANCE(864);
      END_STATE();
    case 981:
      ACCEPT_TOKEN(anon_sym_ATrequiresusages);
      END_STATE();
    case 982:
      ACCEPT_TOKEN(anon_sym_ATrunInSeparateProcess);
      END_STATE();
    case 983:
      ACCEPT_TOKEN(anon_sym_ATrunTestsInSeparateProcesses);
      END_STATE();
    case 984:
      ACCEPT_TOKEN(anon_sym_ATsmall);
      END_STATE();
    case 985:
      ACCEPT_TOKEN(anon_sym_ATtest);
      if (lookahead == 'W') ADVANCE(373);
      if (lookahead == 'd') ADVANCE(546);
      END_STATE();
    case 986:
      ACCEPT_TOKEN(anon_sym_ATtestWith);
      END_STATE();
    case 987:
      ACCEPT_TOKEN(anon_sym_ATtestdox);
      END_STATE();
    case 988:
      ACCEPT_TOKEN(anon_sym_ATticket);
      END_STATE();
    case 989:
      ACCEPT_TOKEN(anon_sym_ATpsalm_DASHconsistent_DASHconstructor);
      END_STATE();
    case 990:
      ACCEPT_TOKEN(anon_sym_ATpsalm_DASHconsistent_DASHtemplates);
      END_STATE();
    case 991:
      ACCEPT_TOKEN(anon_sym_ATpsalm_DASHvar);
      END_STATE();
    case 992:
      ACCEPT_TOKEN(anon_sym_ATpsalm_DASHparam);
      if (lookahead == '-') ADVANCE(580);
      END_STATE();
    case 993:
      ACCEPT_TOKEN(anon_sym_ATpsalm_DASHreturn);
      END_STATE();
    case 994:
      ACCEPT_TOKEN(anon_sym_ATpsalm_DASHproperty);
      if (lookahead == '-') ADVANCE(660);
      END_STATE();
    case 995:
      ACCEPT_TOKEN(anon_sym_ATpsalm_DASHproperty_DASHread);
      END_STATE();
    case 996:
      ACCEPT_TOKEN(anon_sym_ATpsalm_DASHproperty_DASHwrite);
      END_STATE();
    case 997:
      ACCEPT_TOKEN(anon_sym_ATpsalm_DASHmethod);
      END_STATE();
    case 998:
      ACCEPT_TOKEN(anon_sym_ATpsalm_DASHignore_DASHvar);
      END_STATE();
    case 999:
      ACCEPT_TOKEN(anon_sym_ATpsalm_DASHif_DASHthis_DASHis);
      END_STATE();
    case 1000:
      ACCEPT_TOKEN(anon_sym_ATpsalm_DASHthis_DASHout);
      END_STATE();
    case 1001:
      ACCEPT_TOKEN(anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn);
      END_STATE();
    case 1002:
      ACCEPT_TOKEN(anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn);
      END_STATE();
    case 1003:
      ACCEPT_TOKEN(anon_sym_ATpsalm_DASHseal_DASHproperties);
      END_STATE();
    case 1004:
      ACCEPT_TOKEN(anon_sym_ATpsalm_DASHreadonly);
      if (lookahead == '-') ADVANCE(130);
      END_STATE();
    case 1005:
      ACCEPT_TOKEN(anon_sym_ATreadonly);
      END_STATE();
    case 1006:
      ACCEPT_TOKEN(anon_sym_ATpsalm_DASHmutation_DASHfree);
      END_STATE();
    case 1007:
      ACCEPT_TOKEN(anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree);
      END_STATE();
    case 1008:
      ACCEPT_TOKEN(anon_sym_ATpsalm_DASHimmutable);
      END_STATE();
    case 1009:
      ACCEPT_TOKEN(anon_sym_ATpsalm_DASHpure);
      END_STATE();
    case 1010:
      ACCEPT_TOKEN(anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation);
      END_STATE();
    case 1011:
      ACCEPT_TOKEN(anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation);
      END_STATE();
    case 1012:
      ACCEPT_TOKEN(anon_sym_ATpsalm_DASHtrace);
      END_STATE();
    case 1013:
      ACCEPT_TOKEN(anon_sym_ATno_DASHnamed_DASHarguments);
      END_STATE();
    case 1014:
      ACCEPT_TOKEN(anon_sym_ATparam_DASHout);
      END_STATE();
    case 1015:
      ACCEPT_TOKEN(anon_sym_ATpsalm_DASHparam_DASHout);
      END_STATE();
    case 1016:
      ACCEPT_TOKEN(anon_sym_ATpsalm_DASHassert);
      if (lookahead == '-') ADVANCE(364);
      END_STATE();
    case 1017:
      ACCEPT_TOKEN(anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue);
      END_STATE();
    case 1018:
      ACCEPT_TOKEN(anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse);
      END_STATE();
    case 1019:
      ACCEPT_TOKEN(anon_sym_ATpsalm_DASHimport_DASHtype);
      END_STATE();
    case 1020:
      ACCEPT_TOKEN(anon_sym_ATpsalm_DASHsuppress);
      END_STATE();
    case 1021:
      ACCEPT_TOKEN(anon_sym_ATpsalm_DASHinternal);
      END_STATE();
    case 1022:
      ACCEPT_TOKEN(anon_sym_ATpsalm_DASHrequire_DASHextends);
      END_STATE();
    case 1023:
      ACCEPT_TOKEN(anon_sym_ATpsalm_DASHrequire_DASHimplements);
      END_STATE();
    case 1024:
      ACCEPT_TOKEN(anon_sym_ATmixin);
      END_STATE();
    case 1025:
      ACCEPT_TOKEN(anon_sym_LBRACK_RBRACK);
      END_STATE();
    case 1026:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 1027:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 1028:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 1029:
      ACCEPT_TOKEN(aux_sym__shaped_array_element_token1);
      if (lookahead == '.') ADVANCE(909);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1029);
      END_STATE();
    case 1030:
      ACCEPT_TOKEN(aux_sym__shaped_array_element_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(1030);
      END_STATE();
    case 1031:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 1032:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 1033:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(1145);
      END_STATE();
    case 1034:
      ACCEPT_TOKEN(anon_sym_class_DASHstring);
      END_STATE();
    case 1035:
      ACCEPT_TOKEN(anon_sym_interface_DASHstring);
      END_STATE();
    case 1036:
      ACCEPT_TOKEN(anon_sym_positive_DASHint);
      END_STATE();
    case 1037:
      ACCEPT_TOKEN(anon_sym_trait_DASHstring);
      END_STATE();
    case 1038:
      ACCEPT_TOKEN(anon_sym_enum_DASHstring);
      END_STATE();
    case 1039:
      ACCEPT_TOKEN(anon_sym_callable_DASHstring);
      END_STATE();
    case 1040:
      ACCEPT_TOKEN(anon_sym_numeric_DASHstring);
      END_STATE();
    case 1041:
      ACCEPT_TOKEN(anon_sym_literal_DASHstring);
      END_STATE();
    case 1042:
      ACCEPT_TOKEN(anon_sym_lowercase_DASHstring);
      END_STATE();
    case 1043:
      ACCEPT_TOKEN(anon_sym_non_DASHempty_DASHstring);
      END_STATE();
    case 1044:
      ACCEPT_TOKEN(anon_sym_non_DASHempty_DASHlowercase_DASHstring);
      END_STATE();
    case 1045:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == '-') ADVANCE(286);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1046:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == '-') ADVANCE(728);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1047:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == '-') ADVANCE(391);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1048:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == '-') ADVANCE(757);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1049:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == '-') ADVANCE(758);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1050:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == '-') ADVANCE(759);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1051:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == '-') ADVANCE(760);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1052:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == '-') ADVANCE(761);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1053:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == '-') ADVANCE(762);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1054:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == '-') ADVANCE(763);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1055:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(57);
      if (lookahead == 's') ADVANCE(1056);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1056:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == ':') ADVANCE(57);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1057:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'A') ADVANCE(1120);
      if (lookahead == 'a') ADVANCE(1061);
      if (lookahead == 'l') ADVANCE(1065);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1058:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'A') ADVANCE(1116);
      if (lookahead == 'a') ADVANCE(1059);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1059:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'B') ADVANCE(1121);
      if (lookahead == 'b') ADVANCE(1062);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1060:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'E') ADVANCE(1126);
      if (lookahead == 'e') ADVANCE(1052);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1061:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'L') ADVANCE(1122);
      if (lookahead == 'l') ADVANCE(1063);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1062:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'L') ADVANCE(1118);
      if (lookahead == 'l') ADVANCE(1060);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1063:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'L') ADVANCE(1114);
      if (lookahead == 'l') ADVANCE(1058);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1064:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'a') ADVANCE(1085);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1065:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'a') ADVANCE(1100);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1066:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'a') ADVANCE(1069);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1067:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'a') ADVANCE(1102);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1068:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'a') ADVANCE(1084);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1069:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'c') ADVANCE(1077);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1070:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'c') ADVANCE(1067);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1071:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'c') ADVANCE(1051);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1072:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'e') ADVANCE(1094);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1073:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'e') ADVANCE(1095);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1074:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'e') ADVANCE(1047);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1075:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'e') ADVANCE(1097);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1076:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'e') ADVANCE(1098);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1077:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'e') ADVANCE(1053);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1078:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'e') ADVANCE(1054);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1079:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'f') ADVANCE(1066);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1080:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'i') ADVANCE(1110);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1081:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'i') ADVANCE(1071);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1082:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'i') ADVANCE(1106);
      if (lookahead == 'o') ADVANCE(1111);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1083:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'i') ADVANCE(1107);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1084:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'i') ADVANCE(1108);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1085:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'l') ADVANCE(1050);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1086:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'm') ADVANCE(1046);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1087:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'm') ADVANCE(1075);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1088:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'n') ADVANCE(1109);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1089:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'n') ADVANCE(1045);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1090:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'n') ADVANCE(1104);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1091:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'o') ADVANCE(1099);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1092:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'o') ADVANCE(1089);
      if (lookahead == 'u') ADVANCE(1087);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1123);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1093:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'p') ADVANCE(1055);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1094:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'r') ADVANCE(1079);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1095:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'r') ADVANCE(1070);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1096:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'r') ADVANCE(1068);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1097:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'r') ADVANCE(1081);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1098:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'r') ADVANCE(1064);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1099:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 's') ADVANCE(1083);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1100:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 's') ADVANCE(1101);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1101:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 's') ADVANCE(1048);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1102:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 's') ADVANCE(1078);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1103:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 't') ADVANCE(1093);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1104:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 't') ADVANCE(1072);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1105:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 't') ADVANCE(1103);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1106:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 't') ADVANCE(1076);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1107:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 't') ADVANCE(1080);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1108:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 't') ADVANCE(1049);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1109:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'u') ADVANCE(1086);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1110:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'v') ADVANCE(1074);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1111:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'w') ADVANCE(1073);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1112:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1120);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1113:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1123);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1114:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1116);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1115:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(1117);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1116:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(1121);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1117:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(1118);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1118:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1126);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1119:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(1125);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1120:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1122);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1121:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1118);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1122:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(1114);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1123:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(1119);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1124:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(1115);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1125:
      ACCEPT_TOKEN(sym_name);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(1124);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1126:
      ACCEPT_TOKEN(sym_name);
      if (set_contains(sym_name_character_set_1, 9, lookahead)) ADVANCE(1126);
      END_STATE();
    case 1127:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      END_STATE();
    case 1128:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 1129:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 1130:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 1131:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 1132:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 1133:
      ACCEPT_TOKEN(sym_author_name);
      if (lookahead == ' ') ADVANCE(907);
      if (lookahead == '<') ADVANCE(1135);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(1133);
      END_STATE();
    case 1134:
      ACCEPT_TOKEN(sym_author_name);
      if (lookahead == ' ') ADVANCE(907);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '<') ADVANCE(1134);
      END_STATE();
    case 1135:
      ACCEPT_TOKEN(sym_author_name);
      if (lookahead == ' ') ADVANCE(907);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(1135);
      END_STATE();
    case 1136:
      ACCEPT_TOKEN(sym_author_name);
      if (lookahead == ' ') ADVANCE(10);
      if (lookahead == '*') ADVANCE(1136);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(1135);
      END_STATE();
    case 1137:
      ACCEPT_TOKEN(sym_author_name);
      if (lookahead == ' ') ADVANCE(10);
      if (lookahead == '*') ADVANCE(1137);
      if (lookahead == '<') ADVANCE(1135);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(1133);
      END_STATE();
    case 1138:
      ACCEPT_TOKEN(sym_email_address);
      if (lookahead == '.') ADVANCE(1138);
      if (lookahead == '>') ADVANCE(53);
      if (lookahead == '@') ADVANCE(1138);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ') ADVANCE(1138);
      END_STATE();
    case 1139:
      ACCEPT_TOKEN(aux_sym_version_token1);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ') ADVANCE(1139);
      END_STATE();
    case 1140:
      ACCEPT_TOKEN(aux_sym_version_token2);
      if (lookahead == ' ') ADVANCE(1140);
      END_STATE();
    case 1141:
      ACCEPT_TOKEN(anon_sym_ATpackage_version_AT);
      END_STATE();
    case 1142:
      ACCEPT_TOKEN(sym__version_vector);
      END_STATE();
    case 1143:
      ACCEPT_TOKEN(sym_uri);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '}') ADVANCE(1143);
      END_STATE();
    case 1144:
      ACCEPT_TOKEN(anon_sym_LPAREN_RPAREN);
      END_STATE();
    case 1145:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 1146:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 1147:
      ACCEPT_TOKEN(sym_default_value);
      if (lookahead == '\t') ADVANCE(1147);
      if (lookahead == '\n') ADVANCE(1147);
      if (lookahead == '\r') ADVANCE(1148);
      if (lookahead == ' ') ADVANCE(1147);
      if (lookahead == ')') ADVANCE(1149);
      if (lookahead == '*') ADVANCE(1147);
      if (lookahead == 0x0b ||
          lookahead == '\f') ADVANCE(1148);
      if (lookahead != 0 &&
          lookahead != ',') ADVANCE(1149);
      END_STATE();
    case 1148:
      ACCEPT_TOKEN(sym_default_value);
      if (lookahead == '\n') ADVANCE(1147);
      if (lookahead == '\r') ADVANCE(1148);
      if (lookahead == ' ') ADVANCE(1148);
      if (lookahead == ')') ADVANCE(1149);
      if (('\t' <= lookahead && lookahead <= '\f')) ADVANCE(1148);
      if (lookahead != 0 &&
          lookahead != ',') ADVANCE(1149);
      END_STATE();
    case 1149:
      ACCEPT_TOKEN(sym_default_value);
      if (lookahead != 0 &&
          lookahead != ')' &&
          lookahead != ',') ADVANCE(1149);
      END_STATE();
    case 1150:
      ACCEPT_TOKEN(sym__end);
      END_STATE();
    case 1151:
      ACCEPT_TOKEN(sym__end);
      if (lookahead == '*') ADVANCE(26);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == '\n') SKIP(1);
      if (lookahead == '\r') SKIP(0);
      if (lookahead == 'a') ADVANCE(2);
      if (lookahead == 'b') ADVANCE(3);
      if (lookahead == 'f') ADVANCE(4);
      if (lookahead == 'i') ADVANCE(5);
      if (lookahead == 'l') ADVANCE(6);
      if (lookahead == 'm') ADVANCE(7);
      if (lookahead == 'n') ADVANCE(8);
      if (lookahead == 'o') ADVANCE(9);
      if (lookahead == 's') ADVANCE(10);
      if (lookahead == 't') ADVANCE(11);
      if (lookahead == 'v') ADVANCE(12);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(1);
      if (lookahead == '\r') SKIP(0);
      if (lookahead == '*') SKIP(13);
      if (lookahead == 'a') ADVANCE(2);
      if (lookahead == 'b') ADVANCE(3);
      if (lookahead == 'f') ADVANCE(4);
      if (lookahead == 'i') ADVANCE(5);
      if (lookahead == 'l') ADVANCE(6);
      if (lookahead == 'm') ADVANCE(7);
      if (lookahead == 'n') ADVANCE(8);
      if (lookahead == 'o') ADVANCE(9);
      if (lookahead == 's') ADVANCE(10);
      if (lookahead == 't') ADVANCE(11);
      if (lookahead == 'v') ADVANCE(12);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(1);
      if (lookahead == 0x0b ||
          lookahead == '\f') SKIP(0);
      END_STATE();
    case 2:
      if (lookahead == 'r') ADVANCE(14);
      if (lookahead == 's') ADVANCE(15);
      END_STATE();
    case 3:
      if (lookahead == 'o') ADVANCE(16);
      END_STATE();
    case 4:
      if (lookahead == 'a') ADVANCE(17);
      if (lookahead == 'l') ADVANCE(18);
      if (lookahead == 'r') ADVANCE(19);
      END_STATE();
    case 5:
      if (lookahead == 'n') ADVANCE(20);
      if (lookahead == 't') ADVANCE(21);
      END_STATE();
    case 6:
      if (lookahead == 'i') ADVANCE(22);
      END_STATE();
    case 7:
      if (lookahead == 'i') ADVANCE(23);
      END_STATE();
    case 8:
      if (lookahead == 'u') ADVANCE(24);
      END_STATE();
    case 9:
      if (lookahead == 'f') ADVANCE(25);
      END_STATE();
    case 10:
      if (lookahead == 't') ADVANCE(26);
      END_STATE();
    case 11:
      if (lookahead == 'r') ADVANCE(27);
      END_STATE();
    case 12:
      if (lookahead == 'o') ADVANCE(28);
      END_STATE();
    case 13:
      if (lookahead == '\n') SKIP(1);
      if (lookahead == '\r') SKIP(0);
      if (lookahead == '*') SKIP(13);
      if (lookahead == 'a') ADVANCE(2);
      if (lookahead == 'b') ADVANCE(3);
      if (lookahead == 'f') ADVANCE(4);
      if (lookahead == 'i') ADVANCE(5);
      if (lookahead == 'l') ADVANCE(6);
      if (lookahead == 'm') ADVANCE(7);
      if (lookahead == 'n') ADVANCE(8);
      if (lookahead == 'o') ADVANCE(9);
      if (lookahead == 's') ADVANCE(10);
      if (lookahead == 't') ADVANCE(11);
      if (lookahead == 'v') ADVANCE(12);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(13);
      if (lookahead == 0x0b ||
          lookahead == '\f') SKIP(0);
      END_STATE();
    case 14:
      if (lookahead == 'r') ADVANCE(29);
      END_STATE();
    case 15:
      ACCEPT_TOKEN(anon_sym_as);
      END_STATE();
    case 16:
      if (lookahead == 'o') ADVANCE(30);
      END_STATE();
    case 17:
      if (lookahead == 'l') ADVANCE(31);
      END_STATE();
    case 18:
      if (lookahead == 'o') ADVANCE(32);
      END_STATE();
    case 19:
      if (lookahead == 'o') ADVANCE(33);
      END_STATE();
    case 20:
      if (lookahead == 't') ADVANCE(34);
      END_STATE();
    case 21:
      if (lookahead == 'e') ADVANCE(35);
      END_STATE();
    case 22:
      if (lookahead == 's') ADVANCE(36);
      END_STATE();
    case 23:
      if (lookahead == 'x') ADVANCE(37);
      END_STATE();
    case 24:
      if (lookahead == 'l') ADVANCE(38);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_of);
      END_STATE();
    case 26:
      if (lookahead == 'a') ADVANCE(39);
      if (lookahead == 'r') ADVANCE(40);
      END_STATE();
    case 27:
      if (lookahead == 'u') ADVANCE(41);
      END_STATE();
    case 28:
      if (lookahead == 'i') ADVANCE(42);
      END_STATE();
    case 29:
      if (lookahead == 'a') ADVANCE(43);
      END_STATE();
    case 30:
      if (lookahead == 'l') ADVANCE(44);
      END_STATE();
    case 31:
      if (lookahead == 's') ADVANCE(45);
      END_STATE();
    case 32:
      if (lookahead == 'a') ADVANCE(46);
      END_STATE();
    case 33:
      if (lookahead == 'm') ADVANCE(47);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_int);
      END_STATE();
    case 35:
      if (lookahead == 'r') ADVANCE(48);
      END_STATE();
    case 36:
      if (lookahead == 't') ADVANCE(49);
      END_STATE();
    case 37:
      if (lookahead == 'e') ADVANCE(50);
      END_STATE();
    case 38:
      if (lookahead == 'l') ADVANCE(51);
      END_STATE();
    case 39:
      if (lookahead == 't') ADVANCE(52);
      END_STATE();
    case 40:
      if (lookahead == 'i') ADVANCE(53);
      END_STATE();
    case 41:
      if (lookahead == 'e') ADVANCE(54);
      END_STATE();
    case 42:
      if (lookahead == 'd') ADVANCE(55);
      END_STATE();
    case 43:
      if (lookahead == 'y') ADVANCE(56);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_bool);
      END_STATE();
    case 45:
      if (lookahead == 'e') ADVANCE(57);
      END_STATE();
    case 46:
      if (lookahead == 't') ADVANCE(58);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 48:
      if (lookahead == 'a') ADVANCE(59);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_list);
      END_STATE();
    case 50:
      if (lookahead == 'd') ADVANCE(60);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_null);
      END_STATE();
    case 52:
      if (lookahead == 'i') ADVANCE(61);
      END_STATE();
    case 53:
      if (lookahead == 'n') ADVANCE(62);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_void);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_array);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_float);
      END_STATE();
    case 59:
      if (lookahead == 'b') ADVANCE(63);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_mixed);
      END_STATE();
    case 61:
      if (lookahead == 'c') ADVANCE(64);
      END_STATE();
    case 62:
      if (lookahead == 'g') ADVANCE(65);
      END_STATE();
    case 63:
      if (lookahead == 'l') ADVANCE(66);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_static);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_string);
      END_STATE();
    case 66:
      if (lookahead == 'e') ADVANCE(67);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_iterable);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 2},
  [2] = {.lex_state = 3, .external_lex_state = 2},
  [3] = {.lex_state = 3},
  [4] = {.lex_state = 3},
  [5] = {.lex_state = 3},
  [6] = {.lex_state = 3},
  [7] = {.lex_state = 3},
  [8] = {.lex_state = 3},
  [9] = {.lex_state = 3},
  [10] = {.lex_state = 3},
  [11] = {.lex_state = 3},
  [12] = {.lex_state = 3},
  [13] = {.lex_state = 3},
  [14] = {.lex_state = 3},
  [15] = {.lex_state = 3},
  [16] = {.lex_state = 3},
  [17] = {.lex_state = 3},
  [18] = {.lex_state = 3},
  [19] = {.lex_state = 3},
  [20] = {.lex_state = 3},
  [21] = {.lex_state = 3},
  [22] = {.lex_state = 3},
  [23] = {.lex_state = 6, .external_lex_state = 3},
  [24] = {.lex_state = 3},
  [25] = {.lex_state = 3},
  [26] = {.lex_state = 3},
  [27] = {.lex_state = 3, .external_lex_state = 4},
  [28] = {.lex_state = 3},
  [29] = {.lex_state = 3, .external_lex_state = 4},
  [30] = {.lex_state = 3},
  [31] = {.lex_state = 3, .external_lex_state = 4},
  [32] = {.lex_state = 3},
  [33] = {.lex_state = 3},
  [34] = {.lex_state = 3, .external_lex_state = 2},
  [35] = {.lex_state = 3, .external_lex_state = 4},
  [36] = {.lex_state = 3, .external_lex_state = 4},
  [37] = {.lex_state = 3},
  [38] = {.lex_state = 3, .external_lex_state = 4},
  [39] = {.lex_state = 3},
  [40] = {.lex_state = 3},
  [41] = {.lex_state = 3},
  [42] = {.lex_state = 3},
  [43] = {.lex_state = 3},
  [44] = {.lex_state = 3},
  [45] = {.lex_state = 3},
  [46] = {.lex_state = 3, .external_lex_state = 4},
  [47] = {.lex_state = 3, .external_lex_state = 4},
  [48] = {.lex_state = 3, .external_lex_state = 4},
  [49] = {.lex_state = 3, .external_lex_state = 4},
  [50] = {.lex_state = 3},
  [51] = {.lex_state = 3, .external_lex_state = 4},
  [52] = {.lex_state = 3, .external_lex_state = 4},
  [53] = {.lex_state = 3, .external_lex_state = 4},
  [54] = {.lex_state = 3, .external_lex_state = 4},
  [55] = {.lex_state = 3, .external_lex_state = 4},
  [56] = {.lex_state = 3, .external_lex_state = 4},
  [57] = {.lex_state = 3, .external_lex_state = 4},
  [58] = {.lex_state = 3, .external_lex_state = 4},
  [59] = {.lex_state = 3},
  [60] = {.lex_state = 3, .external_lex_state = 4},
  [61] = {.lex_state = 3},
  [62] = {.lex_state = 3, .external_lex_state = 4},
  [63] = {.lex_state = 3, .external_lex_state = 4},
  [64] = {.lex_state = 3},
  [65] = {.lex_state = 3},
  [66] = {.lex_state = 3},
  [67] = {.lex_state = 3},
  [68] = {.lex_state = 3},
  [69] = {.lex_state = 3},
  [70] = {.lex_state = 3, .external_lex_state = 2},
  [71] = {.lex_state = 3, .external_lex_state = 2},
  [72] = {.lex_state = 3},
  [73] = {.lex_state = 3, .external_lex_state = 4},
  [74] = {.lex_state = 3},
  [75] = {.lex_state = 3, .external_lex_state = 2},
  [76] = {.lex_state = 3, .external_lex_state = 4},
  [77] = {.lex_state = 3, .external_lex_state = 2},
  [78] = {.lex_state = 3, .external_lex_state = 2},
  [79] = {.lex_state = 3, .external_lex_state = 4},
  [80] = {.lex_state = 3},
  [81] = {.lex_state = 3, .external_lex_state = 2},
  [82] = {.lex_state = 3, .external_lex_state = 2},
  [83] = {.lex_state = 3, .external_lex_state = 2},
  [84] = {.lex_state = 3, .external_lex_state = 2},
  [85] = {.lex_state = 3, .external_lex_state = 2},
  [86] = {.lex_state = 3, .external_lex_state = 2},
  [87] = {.lex_state = 3, .external_lex_state = 2},
  [88] = {.lex_state = 3, .external_lex_state = 4},
  [89] = {.lex_state = 3, .external_lex_state = 4},
  [90] = {.lex_state = 3, .external_lex_state = 4},
  [91] = {.lex_state = 3, .external_lex_state = 2},
  [92] = {.lex_state = 3, .external_lex_state = 4},
  [93] = {.lex_state = 3, .external_lex_state = 4},
  [94] = {.lex_state = 3, .external_lex_state = 4},
  [95] = {.lex_state = 3, .external_lex_state = 4},
  [96] = {.lex_state = 3, .external_lex_state = 2},
  [97] = {.lex_state = 3, .external_lex_state = 2},
  [98] = {.lex_state = 3, .external_lex_state = 4},
  [99] = {.lex_state = 3, .external_lex_state = 2},
  [100] = {.lex_state = 3, .external_lex_state = 4},
  [101] = {.lex_state = 3, .external_lex_state = 4},
  [102] = {.lex_state = 3, .external_lex_state = 2},
  [103] = {.lex_state = 3, .external_lex_state = 4},
  [104] = {.lex_state = 3},
  [105] = {.lex_state = 3, .external_lex_state = 4},
  [106] = {.lex_state = 3, .external_lex_state = 4},
  [107] = {.lex_state = 3, .external_lex_state = 4},
  [108] = {.lex_state = 3},
  [109] = {.lex_state = 3, .external_lex_state = 4},
  [110] = {.lex_state = 3, .external_lex_state = 2},
  [111] = {.lex_state = 3, .external_lex_state = 4},
  [112] = {.lex_state = 3, .external_lex_state = 4},
  [113] = {.lex_state = 3, .external_lex_state = 2},
  [114] = {.lex_state = 3, .external_lex_state = 2},
  [115] = {.lex_state = 3, .external_lex_state = 3},
  [116] = {.lex_state = 3, .external_lex_state = 2},
  [117] = {.lex_state = 3, .external_lex_state = 4},
  [118] = {.lex_state = 3, .external_lex_state = 2},
  [119] = {.lex_state = 3, .external_lex_state = 4},
  [120] = {.lex_state = 3, .external_lex_state = 4},
  [121] = {.lex_state = 3, .external_lex_state = 3},
  [122] = {.lex_state = 3, .external_lex_state = 2},
  [123] = {.lex_state = 3, .external_lex_state = 4},
  [124] = {.lex_state = 3, .external_lex_state = 4},
  [125] = {.lex_state = 3, .external_lex_state = 4},
  [126] = {.lex_state = 3, .external_lex_state = 4},
  [127] = {.lex_state = 3, .external_lex_state = 2},
  [128] = {.lex_state = 3, .external_lex_state = 2},
  [129] = {.lex_state = 3, .external_lex_state = 2},
  [130] = {.lex_state = 3, .external_lex_state = 2},
  [131] = {.lex_state = 3},
  [132] = {.lex_state = 3, .external_lex_state = 2},
  [133] = {.lex_state = 3, .external_lex_state = 2},
  [134] = {.lex_state = 3, .external_lex_state = 2},
  [135] = {.lex_state = 3, .external_lex_state = 3},
  [136] = {.lex_state = 3, .external_lex_state = 2},
  [137] = {.lex_state = 3, .external_lex_state = 2},
  [138] = {.lex_state = 3, .external_lex_state = 2},
  [139] = {.lex_state = 3, .external_lex_state = 4},
  [140] = {.lex_state = 3, .external_lex_state = 2},
  [141] = {.lex_state = 3, .external_lex_state = 2},
  [142] = {.lex_state = 3, .external_lex_state = 2},
  [143] = {.lex_state = 3, .external_lex_state = 2},
  [144] = {.lex_state = 3, .external_lex_state = 4},
  [145] = {.lex_state = 3},
  [146] = {.lex_state = 3, .external_lex_state = 2},
  [147] = {.lex_state = 3, .external_lex_state = 2},
  [148] = {.lex_state = 3, .external_lex_state = 3},
  [149] = {.lex_state = 3, .external_lex_state = 2},
  [150] = {.lex_state = 3, .external_lex_state = 2},
  [151] = {.lex_state = 3},
  [152] = {.lex_state = 3},
  [153] = {.lex_state = 3},
  [154] = {.lex_state = 3},
  [155] = {.lex_state = 3},
  [156] = {.lex_state = 3},
  [157] = {.lex_state = 3},
  [158] = {.lex_state = 3},
  [159] = {.lex_state = 3},
  [160] = {.lex_state = 3},
  [161] = {.lex_state = 3},
  [162] = {.lex_state = 3},
  [163] = {.lex_state = 3},
  [164] = {.lex_state = 3},
  [165] = {.lex_state = 3},
  [166] = {.lex_state = 3},
  [167] = {.lex_state = 3},
  [168] = {.lex_state = 3},
  [169] = {.lex_state = 3},
  [170] = {.lex_state = 3},
  [171] = {.lex_state = 3},
  [172] = {.lex_state = 3},
  [173] = {.lex_state = 3},
  [174] = {.lex_state = 3},
  [175] = {.lex_state = 3},
  [176] = {.lex_state = 3},
  [177] = {.lex_state = 3},
  [178] = {.lex_state = 3},
  [179] = {.lex_state = 3},
  [180] = {.lex_state = 3},
  [181] = {.lex_state = 3},
  [182] = {.lex_state = 3},
  [183] = {.lex_state = 3},
  [184] = {.lex_state = 3},
  [185] = {.lex_state = 3},
  [186] = {.lex_state = 3},
  [187] = {.lex_state = 2},
  [188] = {.lex_state = 2},
  [189] = {.lex_state = 2},
  [190] = {.lex_state = 2},
  [191] = {.lex_state = 2},
  [192] = {.lex_state = 2},
  [193] = {.lex_state = 2},
  [194] = {.lex_state = 2},
  [195] = {.lex_state = 2},
  [196] = {.lex_state = 2},
  [197] = {.lex_state = 2},
  [198] = {.lex_state = 2},
  [199] = {.lex_state = 2},
  [200] = {.lex_state = 2},
  [201] = {.lex_state = 2},
  [202] = {.lex_state = 2},
  [203] = {.lex_state = 2},
  [204] = {.lex_state = 2},
  [205] = {.lex_state = 2},
  [206] = {.lex_state = 2},
  [207] = {.lex_state = 2},
  [208] = {.lex_state = 2},
  [209] = {.lex_state = 2},
  [210] = {.lex_state = 2},
  [211] = {.lex_state = 2},
  [212] = {.lex_state = 2},
  [213] = {.lex_state = 2},
  [214] = {.lex_state = 2},
  [215] = {.lex_state = 2},
  [216] = {.lex_state = 2},
  [217] = {.lex_state = 2},
  [218] = {.lex_state = 2},
  [219] = {.lex_state = 2},
  [220] = {.lex_state = 2},
  [221] = {.lex_state = 2},
  [222] = {.lex_state = 2},
  [223] = {.lex_state = 2},
  [224] = {.lex_state = 2},
  [225] = {.lex_state = 2},
  [226] = {.lex_state = 2},
  [227] = {.lex_state = 2},
  [228] = {.lex_state = 2},
  [229] = {.lex_state = 2},
  [230] = {.lex_state = 2},
  [231] = {.lex_state = 2},
  [232] = {.lex_state = 2},
  [233] = {.lex_state = 2},
  [234] = {.lex_state = 2},
  [235] = {.lex_state = 2},
  [236] = {.lex_state = 2},
  [237] = {.lex_state = 2},
  [238] = {.lex_state = 2},
  [239] = {.lex_state = 2},
  [240] = {.lex_state = 2},
  [241] = {.lex_state = 2},
  [242] = {.lex_state = 0},
  [243] = {.lex_state = 0},
  [244] = {.lex_state = 6, .external_lex_state = 3},
  [245] = {.lex_state = 2},
  [246] = {.lex_state = 2},
  [247] = {.lex_state = 6, .external_lex_state = 3},
  [248] = {.lex_state = 0},
  [249] = {.lex_state = 0},
  [250] = {.lex_state = 0},
  [251] = {.lex_state = 0},
  [252] = {.lex_state = 3, .external_lex_state = 5},
  [253] = {.lex_state = 2},
  [254] = {.lex_state = 2},
  [255] = {.lex_state = 2},
  [256] = {.lex_state = 2},
  [257] = {.lex_state = 2},
  [258] = {.lex_state = 2},
  [259] = {.lex_state = 2},
  [260] = {.lex_state = 3, .external_lex_state = 5},
  [261] = {.lex_state = 3, .external_lex_state = 5},
  [262] = {.lex_state = 0, .external_lex_state = 5},
  [263] = {.lex_state = 0, .external_lex_state = 2},
  [264] = {.lex_state = 3, .external_lex_state = 5},
  [265] = {.lex_state = 0, .external_lex_state = 5},
  [266] = {.lex_state = 0, .external_lex_state = 5},
  [267] = {.lex_state = 3, .external_lex_state = 5},
  [268] = {.lex_state = 3, .external_lex_state = 5},
  [269] = {.lex_state = 0, .external_lex_state = 5},
  [270] = {.lex_state = 0, .external_lex_state = 5},
  [271] = {.lex_state = 3, .external_lex_state = 5},
  [272] = {.lex_state = 0},
  [273] = {.lex_state = 0},
  [274] = {.lex_state = 0, .external_lex_state = 5},
  [275] = {.lex_state = 0},
  [276] = {.lex_state = 0},
  [277] = {.lex_state = 0, .external_lex_state = 5},
  [278] = {.lex_state = 0},
  [279] = {.lex_state = 2},
  [280] = {.lex_state = 0},
  [281] = {.lex_state = 3, .external_lex_state = 5},
  [282] = {.lex_state = 0},
  [283] = {.lex_state = 0},
  [284] = {.lex_state = 2},
  [285] = {.lex_state = 0},
  [286] = {.lex_state = 0},
  [287] = {.lex_state = 0},
  [288] = {.lex_state = 2},
  [289] = {.lex_state = 0},
  [290] = {.lex_state = 2},
  [291] = {.lex_state = 0},
  [292] = {.lex_state = 2},
  [293] = {.lex_state = 3, .external_lex_state = 5},
  [294] = {.lex_state = 3, .external_lex_state = 5},
  [295] = {.lex_state = 0},
  [296] = {.lex_state = 3, .external_lex_state = 5},
  [297] = {.lex_state = 2},
  [298] = {.lex_state = 0},
  [299] = {.lex_state = 3, .external_lex_state = 5},
  [300] = {.lex_state = 0, .external_lex_state = 5},
  [301] = {.lex_state = 0},
  [302] = {.lex_state = 0},
  [303] = {.lex_state = 0},
  [304] = {.lex_state = 0},
  [305] = {.lex_state = 3, .external_lex_state = 5},
  [306] = {.lex_state = 0, .external_lex_state = 5},
  [307] = {.lex_state = 0},
  [308] = {.lex_state = 3, .external_lex_state = 5},
  [309] = {.lex_state = 2},
  [310] = {.lex_state = 0},
  [311] = {.lex_state = 0},
  [312] = {.lex_state = 0, .external_lex_state = 5},
  [313] = {.lex_state = 0},
  [314] = {.lex_state = 0, .external_lex_state = 5},
  [315] = {.lex_state = 0},
  [316] = {.lex_state = 0},
  [317] = {.lex_state = 0},
  [318] = {.lex_state = 2},
  [319] = {.lex_state = 0},
  [320] = {.lex_state = 2},
  [321] = {.lex_state = 0},
  [322] = {.lex_state = 0, .external_lex_state = 5},
  [323] = {.lex_state = 0},
  [324] = {.lex_state = 0, .external_lex_state = 5},
  [325] = {.lex_state = 2},
  [326] = {.lex_state = 0},
  [327] = {.lex_state = 2},
  [328] = {.lex_state = 0},
  [329] = {.lex_state = 0},
  [330] = {.lex_state = 0},
  [331] = {.lex_state = 0, .external_lex_state = 5},
  [332] = {.lex_state = 0},
  [333] = {.lex_state = 0},
  [334] = {.lex_state = 0},
  [335] = {.lex_state = 0},
  [336] = {.lex_state = 2},
  [337] = {.lex_state = 0},
  [338] = {.lex_state = 0},
  [339] = {.lex_state = 0},
  [340] = {.lex_state = 0},
  [341] = {.lex_state = 0},
  [342] = {.lex_state = 0, .external_lex_state = 5},
  [343] = {.lex_state = 0},
  [344] = {.lex_state = 6},
  [345] = {.lex_state = 2},
  [346] = {.lex_state = 0},
  [347] = {.lex_state = 0},
  [348] = {.lex_state = 0},
  [349] = {.lex_state = 11},
  [350] = {.lex_state = 12},
  [351] = {.lex_state = 0},
  [352] = {.lex_state = 2},
  [353] = {.lex_state = 0},
  [354] = {.lex_state = 0},
  [355] = {.lex_state = 2},
  [356] = {.lex_state = 2},
  [357] = {.lex_state = 2},
  [358] = {.lex_state = 0},
  [359] = {.lex_state = 2},
  [360] = {.lex_state = 2},
  [361] = {.lex_state = 0},
  [362] = {.lex_state = 0},
  [363] = {.lex_state = 2},
  [364] = {.lex_state = 0},
  [365] = {.lex_state = 0},
  [366] = {.lex_state = 2},
  [367] = {.lex_state = 2},
  [368] = {.lex_state = 0},
  [369] = {.lex_state = 0},
  [370] = {.lex_state = 0},
  [371] = {.lex_state = 0},
  [372] = {.lex_state = 0},
  [373] = {.lex_state = 2},
  [374] = {.lex_state = 2},
  [375] = {.lex_state = 2},
  [376] = {.lex_state = 0},
  [377] = {.lex_state = 0},
  [378] = {.lex_state = 0},
  [379] = {.lex_state = 2},
  [380] = {.lex_state = 0},
  [381] = {.lex_state = 2},
  [382] = {.lex_state = 0},
  [383] = {.lex_state = 2},
  [384] = {.lex_state = 2},
  [385] = {.lex_state = 2},
  [386] = {.lex_state = 12},
  [387] = {.lex_state = 0},
  [388] = {.lex_state = 0},
  [389] = {.lex_state = 2},
  [390] = {.lex_state = 0},
  [391] = {.lex_state = 2},
  [392] = {.lex_state = 0},
  [393] = {.lex_state = 0},
  [394] = {.lex_state = 2},
  [395] = {.lex_state = 0},
  [396] = {.lex_state = 0},
  [397] = {.lex_state = 2},
  [398] = {.lex_state = 2},
  [399] = {.lex_state = 0},
  [400] = {.lex_state = 0},
  [401] = {.lex_state = 0},
  [402] = {.lex_state = 0},
  [403] = {.lex_state = 0},
  [404] = {.lex_state = 0},
  [405] = {.lex_state = 0},
  [406] = {.lex_state = 0},
  [407] = {.lex_state = 0},
  [408] = {.lex_state = 0},
  [409] = {.lex_state = 0},
  [410] = {.lex_state = 0},
  [411] = {.lex_state = 0},
  [412] = {.lex_state = 0},
  [413] = {.lex_state = 0},
  [414] = {.lex_state = 18},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_name] = ACTIONS(1),
    [sym__begin] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_ATinheritdoc] = ACTIONS(1),
    [anon_sym_ATinheritDoc] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_ATapi] = ACTIONS(1),
    [anon_sym_ATfilesource] = ACTIONS(1),
    [anon_sym_ATignore] = ACTIONS(1),
    [anon_sym_ATinternal] = ACTIONS(1),
    [anon_sym_ATcategory] = ACTIONS(1),
    [anon_sym_ATcopyright] = ACTIONS(1),
    [anon_sym_ATtodo] = ACTIONS(1),
    [anon_sym_ATexample] = ACTIONS(1),
    [anon_sym_ATlicense] = ACTIONS(1),
    [anon_sym_ATpackage] = ACTIONS(1),
    [anon_sym_ATsource] = ACTIONS(1),
    [anon_sym_ATsubpackage] = ACTIONS(1),
    [anon_sym_ATuses] = ACTIONS(1),
    [anon_sym_ATauthor] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_ATglobal] = ACTIONS(1),
    [anon_sym_ATlink] = ACTIONS(1),
    [anon_sym_ATmethod] = ACTIONS(1),
    [anon_sym_ATparam] = ACTIONS(1),
    [anon_sym_ATproperty] = ACTIONS(1),
    [anon_sym_ATproperty_DASHread] = ACTIONS(1),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(1),
    [anon_sym_ATreturn] = ACTIONS(1),
    [anon_sym_ATsee] = ACTIONS(1),
    [anon_sym_ATthrows] = ACTIONS(1),
    [anon_sym_ATvar] = ACTIONS(1),
    [anon_sym_ATdeprecated] = ACTIONS(1),
    [anon_sym_ATsince] = ACTIONS(1),
    [anon_sym_ATversion] = ACTIONS(1),
    [anon_sym_ATtemplate] = ACTIONS(1),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(1),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(1),
    [anon_sym_of] = ACTIONS(1),
    [anon_sym_ATimplements] = ACTIONS(1),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(1),
    [anon_sym_ATextends] = ACTIONS(1),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(1),
    [anon_sym_ATuse] = ACTIONS(1),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(1),
    [anon_sym_ATafter] = ACTIONS(1),
    [anon_sym_ATafterClass] = ACTIONS(1),
    [anon_sym_ATannotation] = ACTIONS(1),
    [anon_sym_ATbackupGlobals] = ACTIONS(1),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(1),
    [anon_sym_ATbefore] = ACTIONS(1),
    [anon_sym_ATbeforeClass] = ACTIONS(1),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(1),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(1),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(1),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(1),
    [anon_sym_ATcovers] = ACTIONS(1),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(1),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(1),
    [anon_sym_ATcoversNothing] = ACTIONS(1),
    [anon_sym_ATdataProvider] = ACTIONS(1),
    [anon_sym_ATdepends] = ACTIONS(1),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(1),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(1),
    [anon_sym_ATgroup] = ACTIONS(1),
    [anon_sym_ATlarge] = ACTIONS(1),
    [anon_sym_ATmedium] = ACTIONS(1),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(1),
    [anon_sym_ATrequires] = ACTIONS(1),
    [anon_sym_ATrequiresusages] = ACTIONS(1),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(1),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(1),
    [anon_sym_ATsmall] = ACTIONS(1),
    [anon_sym_ATtest] = ACTIONS(1),
    [anon_sym_ATtestWith] = ACTIONS(1),
    [anon_sym_ATtestdox] = ACTIONS(1),
    [anon_sym_ATticket] = ACTIONS(1),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(1),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(1),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(1),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(1),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(1),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(1),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(1),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(1),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(1),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(1),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(1),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(1),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(1),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(1),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(1),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(1),
    [anon_sym_ATreadonly] = ACTIONS(1),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(1),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(1),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(1),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(1),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(1),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(1),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(1),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(1),
    [anon_sym_ATparam_DASHout] = ACTIONS(1),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(1),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(1),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(1),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(1),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(1),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(1),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(1),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(1),
    [anon_sym_ATmixin] = ACTIONS(1),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_list] = ACTIONS(1),
    [anon_sym_array] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [aux_sym__shaped_array_element_token1] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_class_DASHstring] = ACTIONS(1),
    [anon_sym_interface_DASHstring] = ACTIONS(1),
    [anon_sym_positive_DASHint] = ACTIONS(1),
    [anon_sym_trait_DASHstring] = ACTIONS(1),
    [anon_sym_enum_DASHstring] = ACTIONS(1),
    [anon_sym_callable_DASHstring] = ACTIONS(1),
    [anon_sym_numeric_DASHstring] = ACTIONS(1),
    [anon_sym_literal_DASHstring] = ACTIONS(1),
    [anon_sym_lowercase_DASHstring] = ACTIONS(1),
    [anon_sym_non_DASHempty_DASHstring] = ACTIONS(1),
    [anon_sym_non_DASHempty_DASHlowercase_DASHstring] = ACTIONS(1),
    [anon_sym_BSLASH] = ACTIONS(1),
    [aux_sym_relative_name_token1] = ACTIONS(1),
    [aux_sym_primitive_type_token1] = ACTIONS(1),
    [anon_sym_iterable] = ACTIONS(1),
    [anon_sym_bool] = ACTIONS(1),
    [anon_sym_float] = ACTIONS(1),
    [anon_sym_int] = ACTIONS(1),
    [anon_sym_string] = ACTIONS(1),
    [anon_sym_void] = ACTIONS(1),
    [anon_sym_mixed] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [anon_sym_null] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [aux_sym_version_token1] = ACTIONS(1),
    [anon_sym_ATpackage_version_AT] = ACTIONS(1),
    [sym_uri] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [sym_static] = ACTIONS(1),
    [sym__end] = ACTIONS(1),
    [sym_text] = ACTIONS(1),
    [sym__text_after_type] = ACTIONS(1),
    [sym__text_in_inline_tag] = ACTIONS(1),
    [sym__text_not_version] = ACTIONS(1),
  },
  [1] = {
    [sym_document] = STATE(378),
    [sym__begin] = ACTIONS(3),
  },
  [2] = {
    [sym_description] = STATE(4),
    [sym_tag] = STATE(3),
    [sym_inline_tag] = STATE(116),
    [sym__tag_without_description] = STATE(178),
    [sym__tag_with_optional_description] = STATE(178),
    [sym__tag_with_required_description] = STATE(178),
    [sym__tag_with_incomplete_implementation] = STATE(178),
    [sym__author_tag] = STATE(178),
    [sym__global_tag] = STATE(178),
    [sym__link_tag] = STATE(178),
    [sym__method_tag] = STATE(178),
    [sym__param_tag] = STATE(178),
    [sym__property_tag] = STATE(178),
    [sym__return_tag] = STATE(178),
    [sym__see_tag] = STATE(178),
    [sym__throws_tag] = STATE(178),
    [sym__var_tag] = STATE(178),
    [sym__deprecated_tag] = STATE(178),
    [sym__since_tag] = STATE(178),
    [sym__version_tag] = STATE(178),
    [sym__generic_template_tag] = STATE(178),
    [sym__generic_implements_tag] = STATE(178),
    [sym__generic_extends_tag] = STATE(178),
    [sym__generic_use_tag] = STATE(178),
    [sym__phpunit_tag] = STATE(178),
    [sym__psalm_tag] = STATE(178),
    [sym__mixin_tag] = STATE(178),
    [aux_sym_document_repeat1] = STATE(3),
    [aux_sym_description_repeat1] = STATE(116),
    [anon_sym_LBRACE] = ACTIONS(5),
    [anon_sym_ATinheritdoc] = ACTIONS(7),
    [anon_sym_ATinheritDoc] = ACTIONS(7),
    [anon_sym_ATapi] = ACTIONS(7),
    [anon_sym_ATfilesource] = ACTIONS(7),
    [anon_sym_ATignore] = ACTIONS(9),
    [anon_sym_ATinternal] = ACTIONS(9),
    [anon_sym_ATcategory] = ACTIONS(11),
    [anon_sym_ATcopyright] = ACTIONS(11),
    [anon_sym_ATtodo] = ACTIONS(11),
    [anon_sym_ATexample] = ACTIONS(13),
    [anon_sym_ATlicense] = ACTIONS(13),
    [anon_sym_ATpackage] = ACTIONS(13),
    [anon_sym_ATsource] = ACTIONS(13),
    [anon_sym_ATsubpackage] = ACTIONS(13),
    [anon_sym_ATuses] = ACTIONS(13),
    [anon_sym_ATauthor] = ACTIONS(15),
    [anon_sym_ATglobal] = ACTIONS(17),
    [anon_sym_ATlink] = ACTIONS(19),
    [anon_sym_ATmethod] = ACTIONS(21),
    [anon_sym_ATparam] = ACTIONS(23),
    [anon_sym_ATproperty] = ACTIONS(25),
    [anon_sym_ATproperty_DASHread] = ACTIONS(27),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(27),
    [anon_sym_ATreturn] = ACTIONS(29),
    [anon_sym_ATsee] = ACTIONS(31),
    [anon_sym_ATthrows] = ACTIONS(33),
    [anon_sym_ATvar] = ACTIONS(35),
    [anon_sym_ATdeprecated] = ACTIONS(37),
    [anon_sym_ATsince] = ACTIONS(39),
    [anon_sym_ATversion] = ACTIONS(41),
    [anon_sym_ATtemplate] = ACTIONS(43),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(45),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(45),
    [anon_sym_ATimplements] = ACTIONS(47),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(47),
    [anon_sym_ATextends] = ACTIONS(49),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(49),
    [anon_sym_ATuse] = ACTIONS(51),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(53),
    [anon_sym_ATafter] = ACTIONS(55),
    [anon_sym_ATafterClass] = ACTIONS(57),
    [anon_sym_ATannotation] = ACTIONS(57),
    [anon_sym_ATbackupGlobals] = ACTIONS(57),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(57),
    [anon_sym_ATbefore] = ACTIONS(55),
    [anon_sym_ATbeforeClass] = ACTIONS(57),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(55),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(57),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(57),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(57),
    [anon_sym_ATcovers] = ACTIONS(55),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(55),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(57),
    [anon_sym_ATcoversNothing] = ACTIONS(57),
    [anon_sym_ATdataProvider] = ACTIONS(57),
    [anon_sym_ATdepends] = ACTIONS(55),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(57),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(57),
    [anon_sym_ATgroup] = ACTIONS(57),
    [anon_sym_ATlarge] = ACTIONS(57),
    [anon_sym_ATmedium] = ACTIONS(57),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(57),
    [anon_sym_ATrequires] = ACTIONS(55),
    [anon_sym_ATrequiresusages] = ACTIONS(57),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(57),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(57),
    [anon_sym_ATsmall] = ACTIONS(57),
    [anon_sym_ATtest] = ACTIONS(55),
    [anon_sym_ATtestWith] = ACTIONS(57),
    [anon_sym_ATtestdox] = ACTIONS(57),
    [anon_sym_ATticket] = ACTIONS(57),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(59),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(59),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(59),
    [anon_sym_ATreadonly] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(61),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(7),
    [anon_sym_ATparam_DASHout] = ACTIONS(63),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(63),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(65),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(63),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(63),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(67),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(69),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(69),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(69),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(69),
    [anon_sym_ATmixin] = ACTIONS(71),
    [sym__end] = ACTIONS(73),
    [sym_text] = ACTIONS(75),
  },
  [3] = {
    [sym_tag] = STATE(5),
    [sym__tag_without_description] = STATE(178),
    [sym__tag_with_optional_description] = STATE(178),
    [sym__tag_with_required_description] = STATE(178),
    [sym__tag_with_incomplete_implementation] = STATE(178),
    [sym__author_tag] = STATE(178),
    [sym__global_tag] = STATE(178),
    [sym__link_tag] = STATE(178),
    [sym__method_tag] = STATE(178),
    [sym__param_tag] = STATE(178),
    [sym__property_tag] = STATE(178),
    [sym__return_tag] = STATE(178),
    [sym__see_tag] = STATE(178),
    [sym__throws_tag] = STATE(178),
    [sym__var_tag] = STATE(178),
    [sym__deprecated_tag] = STATE(178),
    [sym__since_tag] = STATE(178),
    [sym__version_tag] = STATE(178),
    [sym__generic_template_tag] = STATE(178),
    [sym__generic_implements_tag] = STATE(178),
    [sym__generic_extends_tag] = STATE(178),
    [sym__generic_use_tag] = STATE(178),
    [sym__phpunit_tag] = STATE(178),
    [sym__psalm_tag] = STATE(178),
    [sym__mixin_tag] = STATE(178),
    [aux_sym_document_repeat1] = STATE(5),
    [anon_sym_ATinheritdoc] = ACTIONS(7),
    [anon_sym_ATinheritDoc] = ACTIONS(7),
    [anon_sym_ATapi] = ACTIONS(7),
    [anon_sym_ATfilesource] = ACTIONS(7),
    [anon_sym_ATignore] = ACTIONS(9),
    [anon_sym_ATinternal] = ACTIONS(9),
    [anon_sym_ATcategory] = ACTIONS(11),
    [anon_sym_ATcopyright] = ACTIONS(11),
    [anon_sym_ATtodo] = ACTIONS(11),
    [anon_sym_ATexample] = ACTIONS(13),
    [anon_sym_ATlicense] = ACTIONS(13),
    [anon_sym_ATpackage] = ACTIONS(13),
    [anon_sym_ATsource] = ACTIONS(13),
    [anon_sym_ATsubpackage] = ACTIONS(13),
    [anon_sym_ATuses] = ACTIONS(13),
    [anon_sym_ATauthor] = ACTIONS(15),
    [anon_sym_ATglobal] = ACTIONS(17),
    [anon_sym_ATlink] = ACTIONS(19),
    [anon_sym_ATmethod] = ACTIONS(21),
    [anon_sym_ATparam] = ACTIONS(23),
    [anon_sym_ATproperty] = ACTIONS(25),
    [anon_sym_ATproperty_DASHread] = ACTIONS(27),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(27),
    [anon_sym_ATreturn] = ACTIONS(29),
    [anon_sym_ATsee] = ACTIONS(31),
    [anon_sym_ATthrows] = ACTIONS(33),
    [anon_sym_ATvar] = ACTIONS(35),
    [anon_sym_ATdeprecated] = ACTIONS(37),
    [anon_sym_ATsince] = ACTIONS(39),
    [anon_sym_ATversion] = ACTIONS(41),
    [anon_sym_ATtemplate] = ACTIONS(43),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(45),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(45),
    [anon_sym_ATimplements] = ACTIONS(47),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(47),
    [anon_sym_ATextends] = ACTIONS(49),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(49),
    [anon_sym_ATuse] = ACTIONS(51),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(53),
    [anon_sym_ATafter] = ACTIONS(55),
    [anon_sym_ATafterClass] = ACTIONS(57),
    [anon_sym_ATannotation] = ACTIONS(57),
    [anon_sym_ATbackupGlobals] = ACTIONS(57),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(57),
    [anon_sym_ATbefore] = ACTIONS(55),
    [anon_sym_ATbeforeClass] = ACTIONS(57),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(55),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(57),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(57),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(57),
    [anon_sym_ATcovers] = ACTIONS(55),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(55),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(57),
    [anon_sym_ATcoversNothing] = ACTIONS(57),
    [anon_sym_ATdataProvider] = ACTIONS(57),
    [anon_sym_ATdepends] = ACTIONS(55),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(57),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(57),
    [anon_sym_ATgroup] = ACTIONS(57),
    [anon_sym_ATlarge] = ACTIONS(57),
    [anon_sym_ATmedium] = ACTIONS(57),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(57),
    [anon_sym_ATrequires] = ACTIONS(55),
    [anon_sym_ATrequiresusages] = ACTIONS(57),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(57),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(57),
    [anon_sym_ATsmall] = ACTIONS(57),
    [anon_sym_ATtest] = ACTIONS(55),
    [anon_sym_ATtestWith] = ACTIONS(57),
    [anon_sym_ATtestdox] = ACTIONS(57),
    [anon_sym_ATticket] = ACTIONS(57),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(59),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(59),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(59),
    [anon_sym_ATreadonly] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(61),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(7),
    [anon_sym_ATparam_DASHout] = ACTIONS(63),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(63),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(65),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(63),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(63),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(67),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(69),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(69),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(69),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(69),
    [anon_sym_ATmixin] = ACTIONS(71),
    [sym__end] = ACTIONS(77),
  },
  [4] = {
    [sym_tag] = STATE(6),
    [sym__tag_without_description] = STATE(178),
    [sym__tag_with_optional_description] = STATE(178),
    [sym__tag_with_required_description] = STATE(178),
    [sym__tag_with_incomplete_implementation] = STATE(178),
    [sym__author_tag] = STATE(178),
    [sym__global_tag] = STATE(178),
    [sym__link_tag] = STATE(178),
    [sym__method_tag] = STATE(178),
    [sym__param_tag] = STATE(178),
    [sym__property_tag] = STATE(178),
    [sym__return_tag] = STATE(178),
    [sym__see_tag] = STATE(178),
    [sym__throws_tag] = STATE(178),
    [sym__var_tag] = STATE(178),
    [sym__deprecated_tag] = STATE(178),
    [sym__since_tag] = STATE(178),
    [sym__version_tag] = STATE(178),
    [sym__generic_template_tag] = STATE(178),
    [sym__generic_implements_tag] = STATE(178),
    [sym__generic_extends_tag] = STATE(178),
    [sym__generic_use_tag] = STATE(178),
    [sym__phpunit_tag] = STATE(178),
    [sym__psalm_tag] = STATE(178),
    [sym__mixin_tag] = STATE(178),
    [aux_sym_document_repeat1] = STATE(6),
    [anon_sym_ATinheritdoc] = ACTIONS(7),
    [anon_sym_ATinheritDoc] = ACTIONS(7),
    [anon_sym_ATapi] = ACTIONS(7),
    [anon_sym_ATfilesource] = ACTIONS(7),
    [anon_sym_ATignore] = ACTIONS(9),
    [anon_sym_ATinternal] = ACTIONS(9),
    [anon_sym_ATcategory] = ACTIONS(11),
    [anon_sym_ATcopyright] = ACTIONS(11),
    [anon_sym_ATtodo] = ACTIONS(11),
    [anon_sym_ATexample] = ACTIONS(13),
    [anon_sym_ATlicense] = ACTIONS(13),
    [anon_sym_ATpackage] = ACTIONS(13),
    [anon_sym_ATsource] = ACTIONS(13),
    [anon_sym_ATsubpackage] = ACTIONS(13),
    [anon_sym_ATuses] = ACTIONS(13),
    [anon_sym_ATauthor] = ACTIONS(15),
    [anon_sym_ATglobal] = ACTIONS(17),
    [anon_sym_ATlink] = ACTIONS(19),
    [anon_sym_ATmethod] = ACTIONS(21),
    [anon_sym_ATparam] = ACTIONS(23),
    [anon_sym_ATproperty] = ACTIONS(25),
    [anon_sym_ATproperty_DASHread] = ACTIONS(27),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(27),
    [anon_sym_ATreturn] = ACTIONS(29),
    [anon_sym_ATsee] = ACTIONS(31),
    [anon_sym_ATthrows] = ACTIONS(33),
    [anon_sym_ATvar] = ACTIONS(35),
    [anon_sym_ATdeprecated] = ACTIONS(37),
    [anon_sym_ATsince] = ACTIONS(39),
    [anon_sym_ATversion] = ACTIONS(41),
    [anon_sym_ATtemplate] = ACTIONS(43),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(45),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(45),
    [anon_sym_ATimplements] = ACTIONS(47),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(47),
    [anon_sym_ATextends] = ACTIONS(49),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(49),
    [anon_sym_ATuse] = ACTIONS(51),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(53),
    [anon_sym_ATafter] = ACTIONS(55),
    [anon_sym_ATafterClass] = ACTIONS(57),
    [anon_sym_ATannotation] = ACTIONS(57),
    [anon_sym_ATbackupGlobals] = ACTIONS(57),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(57),
    [anon_sym_ATbefore] = ACTIONS(55),
    [anon_sym_ATbeforeClass] = ACTIONS(57),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(55),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(57),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(57),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(57),
    [anon_sym_ATcovers] = ACTIONS(55),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(55),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(57),
    [anon_sym_ATcoversNothing] = ACTIONS(57),
    [anon_sym_ATdataProvider] = ACTIONS(57),
    [anon_sym_ATdepends] = ACTIONS(55),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(57),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(57),
    [anon_sym_ATgroup] = ACTIONS(57),
    [anon_sym_ATlarge] = ACTIONS(57),
    [anon_sym_ATmedium] = ACTIONS(57),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(57),
    [anon_sym_ATrequires] = ACTIONS(55),
    [anon_sym_ATrequiresusages] = ACTIONS(57),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(57),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(57),
    [anon_sym_ATsmall] = ACTIONS(57),
    [anon_sym_ATtest] = ACTIONS(55),
    [anon_sym_ATtestWith] = ACTIONS(57),
    [anon_sym_ATtestdox] = ACTIONS(57),
    [anon_sym_ATticket] = ACTIONS(57),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(59),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(59),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(59),
    [anon_sym_ATreadonly] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(61),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(7),
    [anon_sym_ATparam_DASHout] = ACTIONS(63),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(63),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(65),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(63),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(63),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(67),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(69),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(69),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(69),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(69),
    [anon_sym_ATmixin] = ACTIONS(71),
    [sym__end] = ACTIONS(77),
  },
  [5] = {
    [sym_tag] = STATE(5),
    [sym__tag_without_description] = STATE(178),
    [sym__tag_with_optional_description] = STATE(178),
    [sym__tag_with_required_description] = STATE(178),
    [sym__tag_with_incomplete_implementation] = STATE(178),
    [sym__author_tag] = STATE(178),
    [sym__global_tag] = STATE(178),
    [sym__link_tag] = STATE(178),
    [sym__method_tag] = STATE(178),
    [sym__param_tag] = STATE(178),
    [sym__property_tag] = STATE(178),
    [sym__return_tag] = STATE(178),
    [sym__see_tag] = STATE(178),
    [sym__throws_tag] = STATE(178),
    [sym__var_tag] = STATE(178),
    [sym__deprecated_tag] = STATE(178),
    [sym__since_tag] = STATE(178),
    [sym__version_tag] = STATE(178),
    [sym__generic_template_tag] = STATE(178),
    [sym__generic_implements_tag] = STATE(178),
    [sym__generic_extends_tag] = STATE(178),
    [sym__generic_use_tag] = STATE(178),
    [sym__phpunit_tag] = STATE(178),
    [sym__psalm_tag] = STATE(178),
    [sym__mixin_tag] = STATE(178),
    [aux_sym_document_repeat1] = STATE(5),
    [anon_sym_ATinheritdoc] = ACTIONS(79),
    [anon_sym_ATinheritDoc] = ACTIONS(79),
    [anon_sym_ATapi] = ACTIONS(79),
    [anon_sym_ATfilesource] = ACTIONS(79),
    [anon_sym_ATignore] = ACTIONS(82),
    [anon_sym_ATinternal] = ACTIONS(82),
    [anon_sym_ATcategory] = ACTIONS(85),
    [anon_sym_ATcopyright] = ACTIONS(85),
    [anon_sym_ATtodo] = ACTIONS(85),
    [anon_sym_ATexample] = ACTIONS(88),
    [anon_sym_ATlicense] = ACTIONS(88),
    [anon_sym_ATpackage] = ACTIONS(88),
    [anon_sym_ATsource] = ACTIONS(88),
    [anon_sym_ATsubpackage] = ACTIONS(88),
    [anon_sym_ATuses] = ACTIONS(88),
    [anon_sym_ATauthor] = ACTIONS(91),
    [anon_sym_ATglobal] = ACTIONS(94),
    [anon_sym_ATlink] = ACTIONS(97),
    [anon_sym_ATmethod] = ACTIONS(100),
    [anon_sym_ATparam] = ACTIONS(103),
    [anon_sym_ATproperty] = ACTIONS(106),
    [anon_sym_ATproperty_DASHread] = ACTIONS(109),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(109),
    [anon_sym_ATreturn] = ACTIONS(112),
    [anon_sym_ATsee] = ACTIONS(115),
    [anon_sym_ATthrows] = ACTIONS(118),
    [anon_sym_ATvar] = ACTIONS(121),
    [anon_sym_ATdeprecated] = ACTIONS(124),
    [anon_sym_ATsince] = ACTIONS(127),
    [anon_sym_ATversion] = ACTIONS(130),
    [anon_sym_ATtemplate] = ACTIONS(133),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(136),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(136),
    [anon_sym_ATimplements] = ACTIONS(139),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(139),
    [anon_sym_ATextends] = ACTIONS(142),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(142),
    [anon_sym_ATuse] = ACTIONS(145),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(148),
    [anon_sym_ATafter] = ACTIONS(151),
    [anon_sym_ATafterClass] = ACTIONS(154),
    [anon_sym_ATannotation] = ACTIONS(154),
    [anon_sym_ATbackupGlobals] = ACTIONS(154),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(154),
    [anon_sym_ATbefore] = ACTIONS(151),
    [anon_sym_ATbeforeClass] = ACTIONS(154),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(151),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(154),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(154),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(154),
    [anon_sym_ATcovers] = ACTIONS(151),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(151),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(154),
    [anon_sym_ATcoversNothing] = ACTIONS(154),
    [anon_sym_ATdataProvider] = ACTIONS(154),
    [anon_sym_ATdepends] = ACTIONS(151),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(154),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(154),
    [anon_sym_ATgroup] = ACTIONS(154),
    [anon_sym_ATlarge] = ACTIONS(154),
    [anon_sym_ATmedium] = ACTIONS(154),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(154),
    [anon_sym_ATrequires] = ACTIONS(151),
    [anon_sym_ATrequiresusages] = ACTIONS(154),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(154),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(154),
    [anon_sym_ATsmall] = ACTIONS(154),
    [anon_sym_ATtest] = ACTIONS(151),
    [anon_sym_ATtestWith] = ACTIONS(154),
    [anon_sym_ATtestdox] = ACTIONS(154),
    [anon_sym_ATticket] = ACTIONS(154),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(79),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(79),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(79),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(157),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(79),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(157),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(79),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(79),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(79),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(79),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(79),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(79),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(79),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(79),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(79),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(157),
    [anon_sym_ATreadonly] = ACTIONS(79),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(79),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(79),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(79),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(79),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(79),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(79),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(160),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(79),
    [anon_sym_ATparam_DASHout] = ACTIONS(163),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(163),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(166),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(163),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(163),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(169),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(172),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(172),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(172),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(172),
    [anon_sym_ATmixin] = ACTIONS(175),
    [sym__end] = ACTIONS(178),
  },
  [6] = {
    [sym_tag] = STATE(5),
    [sym__tag_without_description] = STATE(178),
    [sym__tag_with_optional_description] = STATE(178),
    [sym__tag_with_required_description] = STATE(178),
    [sym__tag_with_incomplete_implementation] = STATE(178),
    [sym__author_tag] = STATE(178),
    [sym__global_tag] = STATE(178),
    [sym__link_tag] = STATE(178),
    [sym__method_tag] = STATE(178),
    [sym__param_tag] = STATE(178),
    [sym__property_tag] = STATE(178),
    [sym__return_tag] = STATE(178),
    [sym__see_tag] = STATE(178),
    [sym__throws_tag] = STATE(178),
    [sym__var_tag] = STATE(178),
    [sym__deprecated_tag] = STATE(178),
    [sym__since_tag] = STATE(178),
    [sym__version_tag] = STATE(178),
    [sym__generic_template_tag] = STATE(178),
    [sym__generic_implements_tag] = STATE(178),
    [sym__generic_extends_tag] = STATE(178),
    [sym__generic_use_tag] = STATE(178),
    [sym__phpunit_tag] = STATE(178),
    [sym__psalm_tag] = STATE(178),
    [sym__mixin_tag] = STATE(178),
    [aux_sym_document_repeat1] = STATE(5),
    [anon_sym_ATinheritdoc] = ACTIONS(7),
    [anon_sym_ATinheritDoc] = ACTIONS(7),
    [anon_sym_ATapi] = ACTIONS(7),
    [anon_sym_ATfilesource] = ACTIONS(7),
    [anon_sym_ATignore] = ACTIONS(9),
    [anon_sym_ATinternal] = ACTIONS(9),
    [anon_sym_ATcategory] = ACTIONS(11),
    [anon_sym_ATcopyright] = ACTIONS(11),
    [anon_sym_ATtodo] = ACTIONS(11),
    [anon_sym_ATexample] = ACTIONS(13),
    [anon_sym_ATlicense] = ACTIONS(13),
    [anon_sym_ATpackage] = ACTIONS(13),
    [anon_sym_ATsource] = ACTIONS(13),
    [anon_sym_ATsubpackage] = ACTIONS(13),
    [anon_sym_ATuses] = ACTIONS(13),
    [anon_sym_ATauthor] = ACTIONS(15),
    [anon_sym_ATglobal] = ACTIONS(17),
    [anon_sym_ATlink] = ACTIONS(19),
    [anon_sym_ATmethod] = ACTIONS(21),
    [anon_sym_ATparam] = ACTIONS(23),
    [anon_sym_ATproperty] = ACTIONS(25),
    [anon_sym_ATproperty_DASHread] = ACTIONS(27),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(27),
    [anon_sym_ATreturn] = ACTIONS(29),
    [anon_sym_ATsee] = ACTIONS(31),
    [anon_sym_ATthrows] = ACTIONS(33),
    [anon_sym_ATvar] = ACTIONS(35),
    [anon_sym_ATdeprecated] = ACTIONS(37),
    [anon_sym_ATsince] = ACTIONS(39),
    [anon_sym_ATversion] = ACTIONS(41),
    [anon_sym_ATtemplate] = ACTIONS(43),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(45),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(45),
    [anon_sym_ATimplements] = ACTIONS(47),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(47),
    [anon_sym_ATextends] = ACTIONS(49),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(49),
    [anon_sym_ATuse] = ACTIONS(51),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(53),
    [anon_sym_ATafter] = ACTIONS(55),
    [anon_sym_ATafterClass] = ACTIONS(57),
    [anon_sym_ATannotation] = ACTIONS(57),
    [anon_sym_ATbackupGlobals] = ACTIONS(57),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(57),
    [anon_sym_ATbefore] = ACTIONS(55),
    [anon_sym_ATbeforeClass] = ACTIONS(57),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(55),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(57),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(57),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(57),
    [anon_sym_ATcovers] = ACTIONS(55),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(55),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(57),
    [anon_sym_ATcoversNothing] = ACTIONS(57),
    [anon_sym_ATdataProvider] = ACTIONS(57),
    [anon_sym_ATdepends] = ACTIONS(55),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(57),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(57),
    [anon_sym_ATgroup] = ACTIONS(57),
    [anon_sym_ATlarge] = ACTIONS(57),
    [anon_sym_ATmedium] = ACTIONS(57),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(57),
    [anon_sym_ATrequires] = ACTIONS(55),
    [anon_sym_ATrequiresusages] = ACTIONS(57),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(57),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(57),
    [anon_sym_ATsmall] = ACTIONS(57),
    [anon_sym_ATtest] = ACTIONS(55),
    [anon_sym_ATtestWith] = ACTIONS(57),
    [anon_sym_ATtestdox] = ACTIONS(57),
    [anon_sym_ATticket] = ACTIONS(57),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(59),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(59),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(59),
    [anon_sym_ATreadonly] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(7),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(61),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(7),
    [anon_sym_ATparam_DASHout] = ACTIONS(63),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(63),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(65),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(63),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(63),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(67),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(69),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(69),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(69),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(69),
    [anon_sym_ATmixin] = ACTIONS(71),
    [sym__end] = ACTIONS(180),
  },
  [7] = {
    [aux_sym_namespace_name_repeat1] = STATE(323),
    [sym_name] = ACTIONS(182),
    [anon_sym_ATinheritdoc] = ACTIONS(184),
    [anon_sym_ATinheritDoc] = ACTIONS(184),
    [anon_sym_RBRACE] = ACTIONS(184),
    [anon_sym_ATapi] = ACTIONS(184),
    [anon_sym_ATfilesource] = ACTIONS(184),
    [anon_sym_ATignore] = ACTIONS(184),
    [anon_sym_ATinternal] = ACTIONS(184),
    [anon_sym_ATcategory] = ACTIONS(184),
    [anon_sym_ATcopyright] = ACTIONS(184),
    [anon_sym_ATtodo] = ACTIONS(184),
    [anon_sym_ATexample] = ACTIONS(184),
    [anon_sym_ATlicense] = ACTIONS(184),
    [anon_sym_ATpackage] = ACTIONS(184),
    [anon_sym_ATsource] = ACTIONS(184),
    [anon_sym_ATsubpackage] = ACTIONS(184),
    [anon_sym_ATuses] = ACTIONS(184),
    [anon_sym_ATauthor] = ACTIONS(184),
    [anon_sym_LT] = ACTIONS(184),
    [anon_sym_GT] = ACTIONS(184),
    [anon_sym_ATglobal] = ACTIONS(184),
    [anon_sym_ATlink] = ACTIONS(184),
    [anon_sym_ATmethod] = ACTIONS(184),
    [anon_sym_ATparam] = ACTIONS(182),
    [anon_sym_ATproperty] = ACTIONS(182),
    [anon_sym_ATproperty_DASHread] = ACTIONS(184),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(184),
    [anon_sym_ATreturn] = ACTIONS(184),
    [anon_sym_ATsee] = ACTIONS(184),
    [anon_sym_ATthrows] = ACTIONS(184),
    [anon_sym_ATvar] = ACTIONS(184),
    [anon_sym_ATdeprecated] = ACTIONS(184),
    [anon_sym_ATsince] = ACTIONS(184),
    [anon_sym_ATversion] = ACTIONS(184),
    [anon_sym_ATtemplate] = ACTIONS(182),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(184),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(184),
    [anon_sym_of] = ACTIONS(182),
    [anon_sym_ATimplements] = ACTIONS(184),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(184),
    [anon_sym_ATextends] = ACTIONS(184),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(184),
    [anon_sym_ATuse] = ACTIONS(182),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(184),
    [anon_sym_ATafter] = ACTIONS(182),
    [anon_sym_ATafterClass] = ACTIONS(184),
    [anon_sym_ATannotation] = ACTIONS(184),
    [anon_sym_ATbackupGlobals] = ACTIONS(184),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(184),
    [anon_sym_ATbefore] = ACTIONS(182),
    [anon_sym_ATbeforeClass] = ACTIONS(184),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(182),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(184),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(184),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(184),
    [anon_sym_ATcovers] = ACTIONS(182),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(182),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(184),
    [anon_sym_ATcoversNothing] = ACTIONS(184),
    [anon_sym_ATdataProvider] = ACTIONS(184),
    [anon_sym_ATdepends] = ACTIONS(182),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(184),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(184),
    [anon_sym_ATgroup] = ACTIONS(184),
    [anon_sym_ATlarge] = ACTIONS(184),
    [anon_sym_ATmedium] = ACTIONS(184),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(184),
    [anon_sym_ATrequires] = ACTIONS(182),
    [anon_sym_ATrequiresusages] = ACTIONS(184),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(184),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(184),
    [anon_sym_ATsmall] = ACTIONS(184),
    [anon_sym_ATtest] = ACTIONS(182),
    [anon_sym_ATtestWith] = ACTIONS(184),
    [anon_sym_ATtestdox] = ACTIONS(184),
    [anon_sym_ATticket] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(182),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(182),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(182),
    [anon_sym_ATreadonly] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(184),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(184),
    [anon_sym_ATparam_DASHout] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(182),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(184),
    [anon_sym_from] = ACTIONS(182),
    [anon_sym_as] = ACTIONS(182),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(184),
    [anon_sym_ATmixin] = ACTIONS(184),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(184),
    [anon_sym_COMMA] = ACTIONS(184),
    [anon_sym_BSLASH] = ACTIONS(186),
    [anon_sym_PIPE] = ACTIONS(184),
    [anon_sym_AMP] = ACTIONS(184),
    [anon_sym_RPAREN] = ACTIONS(184),
    [anon_sym_DOLLAR] = ACTIONS(184),
    [sym__end] = ACTIONS(184),
  },
  [8] = {
    [aux_sym_namespace_name_repeat1] = STATE(323),
    [sym_name] = ACTIONS(189),
    [anon_sym_ATinheritdoc] = ACTIONS(191),
    [anon_sym_ATinheritDoc] = ACTIONS(191),
    [anon_sym_RBRACE] = ACTIONS(191),
    [anon_sym_ATapi] = ACTIONS(191),
    [anon_sym_ATfilesource] = ACTIONS(191),
    [anon_sym_ATignore] = ACTIONS(191),
    [anon_sym_ATinternal] = ACTIONS(191),
    [anon_sym_ATcategory] = ACTIONS(191),
    [anon_sym_ATcopyright] = ACTIONS(191),
    [anon_sym_ATtodo] = ACTIONS(191),
    [anon_sym_ATexample] = ACTIONS(191),
    [anon_sym_ATlicense] = ACTIONS(191),
    [anon_sym_ATpackage] = ACTIONS(191),
    [anon_sym_ATsource] = ACTIONS(191),
    [anon_sym_ATsubpackage] = ACTIONS(191),
    [anon_sym_ATuses] = ACTIONS(191),
    [anon_sym_ATauthor] = ACTIONS(191),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_GT] = ACTIONS(191),
    [anon_sym_ATglobal] = ACTIONS(191),
    [anon_sym_ATlink] = ACTIONS(191),
    [anon_sym_ATmethod] = ACTIONS(191),
    [anon_sym_ATparam] = ACTIONS(189),
    [anon_sym_ATproperty] = ACTIONS(189),
    [anon_sym_ATproperty_DASHread] = ACTIONS(191),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(191),
    [anon_sym_ATreturn] = ACTIONS(191),
    [anon_sym_ATsee] = ACTIONS(191),
    [anon_sym_ATthrows] = ACTIONS(191),
    [anon_sym_ATvar] = ACTIONS(191),
    [anon_sym_ATdeprecated] = ACTIONS(191),
    [anon_sym_ATsince] = ACTIONS(191),
    [anon_sym_ATversion] = ACTIONS(191),
    [anon_sym_ATtemplate] = ACTIONS(189),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(191),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(191),
    [anon_sym_of] = ACTIONS(189),
    [anon_sym_ATimplements] = ACTIONS(191),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(191),
    [anon_sym_ATextends] = ACTIONS(191),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(191),
    [anon_sym_ATuse] = ACTIONS(189),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(191),
    [anon_sym_ATafter] = ACTIONS(189),
    [anon_sym_ATafterClass] = ACTIONS(191),
    [anon_sym_ATannotation] = ACTIONS(191),
    [anon_sym_ATbackupGlobals] = ACTIONS(191),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(191),
    [anon_sym_ATbefore] = ACTIONS(189),
    [anon_sym_ATbeforeClass] = ACTIONS(191),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(189),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(191),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(191),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(191),
    [anon_sym_ATcovers] = ACTIONS(189),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(189),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(191),
    [anon_sym_ATcoversNothing] = ACTIONS(191),
    [anon_sym_ATdataProvider] = ACTIONS(191),
    [anon_sym_ATdepends] = ACTIONS(189),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(191),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(191),
    [anon_sym_ATgroup] = ACTIONS(191),
    [anon_sym_ATlarge] = ACTIONS(191),
    [anon_sym_ATmedium] = ACTIONS(191),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(191),
    [anon_sym_ATrequires] = ACTIONS(189),
    [anon_sym_ATrequiresusages] = ACTIONS(191),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(191),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(191),
    [anon_sym_ATsmall] = ACTIONS(191),
    [anon_sym_ATtest] = ACTIONS(189),
    [anon_sym_ATtestWith] = ACTIONS(191),
    [anon_sym_ATtestdox] = ACTIONS(191),
    [anon_sym_ATticket] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(189),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(189),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(189),
    [anon_sym_ATreadonly] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(191),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(191),
    [anon_sym_ATparam_DASHout] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(189),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(191),
    [anon_sym_from] = ACTIONS(189),
    [anon_sym_as] = ACTIONS(189),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(191),
    [anon_sym_ATmixin] = ACTIONS(191),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(191),
    [anon_sym_COMMA] = ACTIONS(191),
    [anon_sym_BSLASH] = ACTIONS(186),
    [anon_sym_PIPE] = ACTIONS(191),
    [anon_sym_AMP] = ACTIONS(191),
    [anon_sym_RPAREN] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(191),
    [sym__end] = ACTIONS(191),
  },
  [9] = {
    [sym_name] = ACTIONS(193),
    [anon_sym_ATinheritdoc] = ACTIONS(195),
    [anon_sym_ATinheritDoc] = ACTIONS(195),
    [anon_sym_RBRACE] = ACTIONS(195),
    [anon_sym_ATapi] = ACTIONS(195),
    [anon_sym_ATfilesource] = ACTIONS(195),
    [anon_sym_ATignore] = ACTIONS(195),
    [anon_sym_ATinternal] = ACTIONS(195),
    [anon_sym_ATcategory] = ACTIONS(195),
    [anon_sym_ATcopyright] = ACTIONS(195),
    [anon_sym_ATtodo] = ACTIONS(195),
    [anon_sym_ATexample] = ACTIONS(195),
    [anon_sym_ATlicense] = ACTIONS(195),
    [anon_sym_ATpackage] = ACTIONS(195),
    [anon_sym_ATsource] = ACTIONS(195),
    [anon_sym_ATsubpackage] = ACTIONS(195),
    [anon_sym_ATuses] = ACTIONS(195),
    [anon_sym_ATauthor] = ACTIONS(195),
    [anon_sym_LT] = ACTIONS(195),
    [anon_sym_GT] = ACTIONS(195),
    [anon_sym_ATglobal] = ACTIONS(195),
    [anon_sym_ATlink] = ACTIONS(195),
    [anon_sym_ATmethod] = ACTIONS(195),
    [anon_sym_ATparam] = ACTIONS(193),
    [anon_sym_ATproperty] = ACTIONS(193),
    [anon_sym_ATproperty_DASHread] = ACTIONS(195),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(195),
    [anon_sym_ATreturn] = ACTIONS(195),
    [anon_sym_ATsee] = ACTIONS(195),
    [anon_sym_ATthrows] = ACTIONS(195),
    [anon_sym_ATvar] = ACTIONS(195),
    [anon_sym_ATdeprecated] = ACTIONS(195),
    [anon_sym_ATsince] = ACTIONS(195),
    [anon_sym_ATversion] = ACTIONS(195),
    [anon_sym_ATtemplate] = ACTIONS(193),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(195),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(195),
    [anon_sym_of] = ACTIONS(193),
    [anon_sym_ATimplements] = ACTIONS(195),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(195),
    [anon_sym_ATextends] = ACTIONS(195),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(195),
    [anon_sym_ATuse] = ACTIONS(193),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(195),
    [anon_sym_ATafter] = ACTIONS(193),
    [anon_sym_ATafterClass] = ACTIONS(195),
    [anon_sym_ATannotation] = ACTIONS(195),
    [anon_sym_ATbackupGlobals] = ACTIONS(195),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(195),
    [anon_sym_ATbefore] = ACTIONS(193),
    [anon_sym_ATbeforeClass] = ACTIONS(195),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(193),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(195),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(195),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(195),
    [anon_sym_ATcovers] = ACTIONS(193),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(193),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(195),
    [anon_sym_ATcoversNothing] = ACTIONS(195),
    [anon_sym_ATdataProvider] = ACTIONS(195),
    [anon_sym_ATdepends] = ACTIONS(193),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(195),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(195),
    [anon_sym_ATgroup] = ACTIONS(195),
    [anon_sym_ATlarge] = ACTIONS(195),
    [anon_sym_ATmedium] = ACTIONS(195),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(195),
    [anon_sym_ATrequires] = ACTIONS(193),
    [anon_sym_ATrequiresusages] = ACTIONS(195),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(195),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(195),
    [anon_sym_ATsmall] = ACTIONS(195),
    [anon_sym_ATtest] = ACTIONS(193),
    [anon_sym_ATtestWith] = ACTIONS(195),
    [anon_sym_ATtestdox] = ACTIONS(195),
    [anon_sym_ATticket] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(193),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(193),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(193),
    [anon_sym_ATreadonly] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(195),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(195),
    [anon_sym_ATparam_DASHout] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(193),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(195),
    [anon_sym_from] = ACTIONS(193),
    [anon_sym_as] = ACTIONS(193),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(195),
    [anon_sym_ATmixin] = ACTIONS(195),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(195),
    [anon_sym_COMMA] = ACTIONS(195),
    [anon_sym_PIPE] = ACTIONS(195),
    [anon_sym_AMP] = ACTIONS(195),
    [anon_sym_RPAREN] = ACTIONS(195),
    [anon_sym_DOLLAR] = ACTIONS(195),
    [sym__end] = ACTIONS(195),
  },
  [10] = {
    [sym_name] = ACTIONS(197),
    [anon_sym_ATinheritdoc] = ACTIONS(199),
    [anon_sym_ATinheritDoc] = ACTIONS(199),
    [anon_sym_RBRACE] = ACTIONS(199),
    [anon_sym_ATapi] = ACTIONS(199),
    [anon_sym_ATfilesource] = ACTIONS(199),
    [anon_sym_ATignore] = ACTIONS(199),
    [anon_sym_ATinternal] = ACTIONS(199),
    [anon_sym_ATcategory] = ACTIONS(199),
    [anon_sym_ATcopyright] = ACTIONS(199),
    [anon_sym_ATtodo] = ACTIONS(199),
    [anon_sym_ATexample] = ACTIONS(199),
    [anon_sym_ATlicense] = ACTIONS(199),
    [anon_sym_ATpackage] = ACTIONS(199),
    [anon_sym_ATsource] = ACTIONS(199),
    [anon_sym_ATsubpackage] = ACTIONS(199),
    [anon_sym_ATuses] = ACTIONS(199),
    [anon_sym_ATauthor] = ACTIONS(199),
    [anon_sym_LT] = ACTIONS(199),
    [anon_sym_GT] = ACTIONS(199),
    [anon_sym_ATglobal] = ACTIONS(199),
    [anon_sym_ATlink] = ACTIONS(199),
    [anon_sym_ATmethod] = ACTIONS(199),
    [anon_sym_ATparam] = ACTIONS(197),
    [anon_sym_ATproperty] = ACTIONS(197),
    [anon_sym_ATproperty_DASHread] = ACTIONS(199),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(199),
    [anon_sym_ATreturn] = ACTIONS(199),
    [anon_sym_ATsee] = ACTIONS(199),
    [anon_sym_ATthrows] = ACTIONS(199),
    [anon_sym_ATvar] = ACTIONS(199),
    [anon_sym_ATdeprecated] = ACTIONS(199),
    [anon_sym_ATsince] = ACTIONS(199),
    [anon_sym_ATversion] = ACTIONS(199),
    [anon_sym_ATtemplate] = ACTIONS(197),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(199),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(199),
    [anon_sym_of] = ACTIONS(197),
    [anon_sym_ATimplements] = ACTIONS(199),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(199),
    [anon_sym_ATextends] = ACTIONS(199),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(199),
    [anon_sym_ATuse] = ACTIONS(197),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(199),
    [anon_sym_ATafter] = ACTIONS(197),
    [anon_sym_ATafterClass] = ACTIONS(199),
    [anon_sym_ATannotation] = ACTIONS(199),
    [anon_sym_ATbackupGlobals] = ACTIONS(199),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(199),
    [anon_sym_ATbefore] = ACTIONS(197),
    [anon_sym_ATbeforeClass] = ACTIONS(199),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(197),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(199),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(199),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(199),
    [anon_sym_ATcovers] = ACTIONS(197),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(197),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(199),
    [anon_sym_ATcoversNothing] = ACTIONS(199),
    [anon_sym_ATdataProvider] = ACTIONS(199),
    [anon_sym_ATdepends] = ACTIONS(197),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(199),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(199),
    [anon_sym_ATgroup] = ACTIONS(199),
    [anon_sym_ATlarge] = ACTIONS(199),
    [anon_sym_ATmedium] = ACTIONS(199),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(199),
    [anon_sym_ATrequires] = ACTIONS(197),
    [anon_sym_ATrequiresusages] = ACTIONS(199),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(199),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(199),
    [anon_sym_ATsmall] = ACTIONS(199),
    [anon_sym_ATtest] = ACTIONS(197),
    [anon_sym_ATtestWith] = ACTIONS(199),
    [anon_sym_ATtestdox] = ACTIONS(199),
    [anon_sym_ATticket] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(197),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(197),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(197),
    [anon_sym_ATreadonly] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(199),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(199),
    [anon_sym_ATparam_DASHout] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(197),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(199),
    [anon_sym_from] = ACTIONS(197),
    [anon_sym_as] = ACTIONS(197),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(199),
    [anon_sym_ATmixin] = ACTIONS(199),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(199),
    [anon_sym_COMMA] = ACTIONS(199),
    [anon_sym_PIPE] = ACTIONS(199),
    [anon_sym_AMP] = ACTIONS(199),
    [anon_sym_RPAREN] = ACTIONS(199),
    [anon_sym_DOLLAR] = ACTIONS(199),
    [sym__end] = ACTIONS(199),
  },
  [11] = {
    [sym_name] = ACTIONS(201),
    [anon_sym_ATinheritdoc] = ACTIONS(203),
    [anon_sym_ATinheritDoc] = ACTIONS(203),
    [anon_sym_RBRACE] = ACTIONS(203),
    [anon_sym_ATapi] = ACTIONS(203),
    [anon_sym_ATfilesource] = ACTIONS(203),
    [anon_sym_ATignore] = ACTIONS(203),
    [anon_sym_ATinternal] = ACTIONS(203),
    [anon_sym_ATcategory] = ACTIONS(203),
    [anon_sym_ATcopyright] = ACTIONS(203),
    [anon_sym_ATtodo] = ACTIONS(203),
    [anon_sym_ATexample] = ACTIONS(203),
    [anon_sym_ATlicense] = ACTIONS(203),
    [anon_sym_ATpackage] = ACTIONS(203),
    [anon_sym_ATsource] = ACTIONS(203),
    [anon_sym_ATsubpackage] = ACTIONS(203),
    [anon_sym_ATuses] = ACTIONS(203),
    [anon_sym_ATauthor] = ACTIONS(203),
    [anon_sym_LT] = ACTIONS(203),
    [anon_sym_GT] = ACTIONS(203),
    [anon_sym_ATglobal] = ACTIONS(203),
    [anon_sym_ATlink] = ACTIONS(203),
    [anon_sym_ATmethod] = ACTIONS(203),
    [anon_sym_ATparam] = ACTIONS(201),
    [anon_sym_ATproperty] = ACTIONS(201),
    [anon_sym_ATproperty_DASHread] = ACTIONS(203),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(203),
    [anon_sym_ATreturn] = ACTIONS(203),
    [anon_sym_ATsee] = ACTIONS(203),
    [anon_sym_ATthrows] = ACTIONS(203),
    [anon_sym_ATvar] = ACTIONS(203),
    [anon_sym_ATdeprecated] = ACTIONS(203),
    [anon_sym_ATsince] = ACTIONS(203),
    [anon_sym_ATversion] = ACTIONS(203),
    [anon_sym_ATtemplate] = ACTIONS(201),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(203),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(203),
    [anon_sym_of] = ACTIONS(201),
    [anon_sym_ATimplements] = ACTIONS(203),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(203),
    [anon_sym_ATextends] = ACTIONS(203),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(203),
    [anon_sym_ATuse] = ACTIONS(201),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(203),
    [anon_sym_ATafter] = ACTIONS(201),
    [anon_sym_ATafterClass] = ACTIONS(203),
    [anon_sym_ATannotation] = ACTIONS(203),
    [anon_sym_ATbackupGlobals] = ACTIONS(203),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(203),
    [anon_sym_ATbefore] = ACTIONS(201),
    [anon_sym_ATbeforeClass] = ACTIONS(203),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(201),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(203),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(203),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(203),
    [anon_sym_ATcovers] = ACTIONS(201),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(201),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(203),
    [anon_sym_ATcoversNothing] = ACTIONS(203),
    [anon_sym_ATdataProvider] = ACTIONS(203),
    [anon_sym_ATdepends] = ACTIONS(201),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(203),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(203),
    [anon_sym_ATgroup] = ACTIONS(203),
    [anon_sym_ATlarge] = ACTIONS(203),
    [anon_sym_ATmedium] = ACTIONS(203),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(203),
    [anon_sym_ATrequires] = ACTIONS(201),
    [anon_sym_ATrequiresusages] = ACTIONS(203),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(203),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(203),
    [anon_sym_ATsmall] = ACTIONS(203),
    [anon_sym_ATtest] = ACTIONS(201),
    [anon_sym_ATtestWith] = ACTIONS(203),
    [anon_sym_ATtestdox] = ACTIONS(203),
    [anon_sym_ATticket] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(201),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(201),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(201),
    [anon_sym_ATreadonly] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(203),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(203),
    [anon_sym_ATparam_DASHout] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(201),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(203),
    [anon_sym_from] = ACTIONS(201),
    [anon_sym_as] = ACTIONS(201),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(203),
    [anon_sym_ATmixin] = ACTIONS(203),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(203),
    [anon_sym_COMMA] = ACTIONS(203),
    [anon_sym_PIPE] = ACTIONS(203),
    [anon_sym_AMP] = ACTIONS(203),
    [anon_sym_RPAREN] = ACTIONS(203),
    [anon_sym_DOLLAR] = ACTIONS(203),
    [sym__end] = ACTIONS(203),
  },
  [12] = {
    [sym_name] = ACTIONS(205),
    [anon_sym_ATinheritdoc] = ACTIONS(207),
    [anon_sym_ATinheritDoc] = ACTIONS(207),
    [anon_sym_RBRACE] = ACTIONS(207),
    [anon_sym_ATapi] = ACTIONS(207),
    [anon_sym_ATfilesource] = ACTIONS(207),
    [anon_sym_ATignore] = ACTIONS(207),
    [anon_sym_ATinternal] = ACTIONS(207),
    [anon_sym_ATcategory] = ACTIONS(207),
    [anon_sym_ATcopyright] = ACTIONS(207),
    [anon_sym_ATtodo] = ACTIONS(207),
    [anon_sym_ATexample] = ACTIONS(207),
    [anon_sym_ATlicense] = ACTIONS(207),
    [anon_sym_ATpackage] = ACTIONS(207),
    [anon_sym_ATsource] = ACTIONS(207),
    [anon_sym_ATsubpackage] = ACTIONS(207),
    [anon_sym_ATuses] = ACTIONS(207),
    [anon_sym_ATauthor] = ACTIONS(207),
    [anon_sym_LT] = ACTIONS(207),
    [anon_sym_GT] = ACTIONS(207),
    [anon_sym_ATglobal] = ACTIONS(207),
    [anon_sym_ATlink] = ACTIONS(207),
    [anon_sym_ATmethod] = ACTIONS(207),
    [anon_sym_ATparam] = ACTIONS(205),
    [anon_sym_ATproperty] = ACTIONS(205),
    [anon_sym_ATproperty_DASHread] = ACTIONS(207),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(207),
    [anon_sym_ATreturn] = ACTIONS(207),
    [anon_sym_ATsee] = ACTIONS(207),
    [anon_sym_ATthrows] = ACTIONS(207),
    [anon_sym_ATvar] = ACTIONS(207),
    [anon_sym_ATdeprecated] = ACTIONS(207),
    [anon_sym_ATsince] = ACTIONS(207),
    [anon_sym_ATversion] = ACTIONS(207),
    [anon_sym_ATtemplate] = ACTIONS(205),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(207),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(207),
    [anon_sym_of] = ACTIONS(205),
    [anon_sym_ATimplements] = ACTIONS(207),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(207),
    [anon_sym_ATextends] = ACTIONS(207),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(207),
    [anon_sym_ATuse] = ACTIONS(205),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(207),
    [anon_sym_ATafter] = ACTIONS(205),
    [anon_sym_ATafterClass] = ACTIONS(207),
    [anon_sym_ATannotation] = ACTIONS(207),
    [anon_sym_ATbackupGlobals] = ACTIONS(207),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(207),
    [anon_sym_ATbefore] = ACTIONS(205),
    [anon_sym_ATbeforeClass] = ACTIONS(207),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(205),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(207),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(207),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(207),
    [anon_sym_ATcovers] = ACTIONS(205),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(205),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(207),
    [anon_sym_ATcoversNothing] = ACTIONS(207),
    [anon_sym_ATdataProvider] = ACTIONS(207),
    [anon_sym_ATdepends] = ACTIONS(205),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(207),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(207),
    [anon_sym_ATgroup] = ACTIONS(207),
    [anon_sym_ATlarge] = ACTIONS(207),
    [anon_sym_ATmedium] = ACTIONS(207),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(207),
    [anon_sym_ATrequires] = ACTIONS(205),
    [anon_sym_ATrequiresusages] = ACTIONS(207),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(207),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(207),
    [anon_sym_ATsmall] = ACTIONS(207),
    [anon_sym_ATtest] = ACTIONS(205),
    [anon_sym_ATtestWith] = ACTIONS(207),
    [anon_sym_ATtestdox] = ACTIONS(207),
    [anon_sym_ATticket] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(205),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(205),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(205),
    [anon_sym_ATreadonly] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(207),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(207),
    [anon_sym_ATparam_DASHout] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(205),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(207),
    [anon_sym_from] = ACTIONS(205),
    [anon_sym_as] = ACTIONS(205),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(207),
    [anon_sym_ATmixin] = ACTIONS(207),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(207),
    [anon_sym_COMMA] = ACTIONS(207),
    [anon_sym_PIPE] = ACTIONS(207),
    [anon_sym_AMP] = ACTIONS(207),
    [anon_sym_RPAREN] = ACTIONS(207),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [sym__end] = ACTIONS(207),
  },
  [13] = {
    [sym_name] = ACTIONS(209),
    [anon_sym_ATinheritdoc] = ACTIONS(211),
    [anon_sym_ATinheritDoc] = ACTIONS(211),
    [anon_sym_RBRACE] = ACTIONS(211),
    [anon_sym_ATapi] = ACTIONS(211),
    [anon_sym_ATfilesource] = ACTIONS(211),
    [anon_sym_ATignore] = ACTIONS(211),
    [anon_sym_ATinternal] = ACTIONS(211),
    [anon_sym_ATcategory] = ACTIONS(211),
    [anon_sym_ATcopyright] = ACTIONS(211),
    [anon_sym_ATtodo] = ACTIONS(211),
    [anon_sym_ATexample] = ACTIONS(211),
    [anon_sym_ATlicense] = ACTIONS(211),
    [anon_sym_ATpackage] = ACTIONS(211),
    [anon_sym_ATsource] = ACTIONS(211),
    [anon_sym_ATsubpackage] = ACTIONS(211),
    [anon_sym_ATuses] = ACTIONS(211),
    [anon_sym_ATauthor] = ACTIONS(211),
    [anon_sym_LT] = ACTIONS(211),
    [anon_sym_GT] = ACTIONS(211),
    [anon_sym_ATglobal] = ACTIONS(211),
    [anon_sym_ATlink] = ACTIONS(211),
    [anon_sym_ATmethod] = ACTIONS(211),
    [anon_sym_ATparam] = ACTIONS(209),
    [anon_sym_ATproperty] = ACTIONS(209),
    [anon_sym_ATproperty_DASHread] = ACTIONS(211),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(211),
    [anon_sym_ATreturn] = ACTIONS(211),
    [anon_sym_ATsee] = ACTIONS(211),
    [anon_sym_ATthrows] = ACTIONS(211),
    [anon_sym_ATvar] = ACTIONS(211),
    [anon_sym_ATdeprecated] = ACTIONS(211),
    [anon_sym_ATsince] = ACTIONS(211),
    [anon_sym_ATversion] = ACTIONS(211),
    [anon_sym_ATtemplate] = ACTIONS(209),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(211),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(211),
    [anon_sym_of] = ACTIONS(209),
    [anon_sym_ATimplements] = ACTIONS(211),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(211),
    [anon_sym_ATextends] = ACTIONS(211),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(211),
    [anon_sym_ATuse] = ACTIONS(209),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(211),
    [anon_sym_ATafter] = ACTIONS(209),
    [anon_sym_ATafterClass] = ACTIONS(211),
    [anon_sym_ATannotation] = ACTIONS(211),
    [anon_sym_ATbackupGlobals] = ACTIONS(211),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(211),
    [anon_sym_ATbefore] = ACTIONS(209),
    [anon_sym_ATbeforeClass] = ACTIONS(211),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(209),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(211),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(211),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(211),
    [anon_sym_ATcovers] = ACTIONS(209),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(209),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(211),
    [anon_sym_ATcoversNothing] = ACTIONS(211),
    [anon_sym_ATdataProvider] = ACTIONS(211),
    [anon_sym_ATdepends] = ACTIONS(209),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(211),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(211),
    [anon_sym_ATgroup] = ACTIONS(211),
    [anon_sym_ATlarge] = ACTIONS(211),
    [anon_sym_ATmedium] = ACTIONS(211),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(211),
    [anon_sym_ATrequires] = ACTIONS(209),
    [anon_sym_ATrequiresusages] = ACTIONS(211),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(211),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(211),
    [anon_sym_ATsmall] = ACTIONS(211),
    [anon_sym_ATtest] = ACTIONS(209),
    [anon_sym_ATtestWith] = ACTIONS(211),
    [anon_sym_ATtestdox] = ACTIONS(211),
    [anon_sym_ATticket] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(209),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(209),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(209),
    [anon_sym_ATreadonly] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(211),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(211),
    [anon_sym_ATparam_DASHout] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(209),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(211),
    [anon_sym_from] = ACTIONS(209),
    [anon_sym_as] = ACTIONS(209),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(211),
    [anon_sym_ATmixin] = ACTIONS(211),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(211),
    [anon_sym_COMMA] = ACTIONS(211),
    [anon_sym_PIPE] = ACTIONS(211),
    [anon_sym_AMP] = ACTIONS(211),
    [anon_sym_RPAREN] = ACTIONS(211),
    [anon_sym_DOLLAR] = ACTIONS(211),
    [sym__end] = ACTIONS(211),
  },
  [14] = {
    [sym_name] = ACTIONS(213),
    [anon_sym_ATinheritdoc] = ACTIONS(215),
    [anon_sym_ATinheritDoc] = ACTIONS(215),
    [anon_sym_RBRACE] = ACTIONS(215),
    [anon_sym_ATapi] = ACTIONS(215),
    [anon_sym_ATfilesource] = ACTIONS(215),
    [anon_sym_ATignore] = ACTIONS(215),
    [anon_sym_ATinternal] = ACTIONS(215),
    [anon_sym_ATcategory] = ACTIONS(215),
    [anon_sym_ATcopyright] = ACTIONS(215),
    [anon_sym_ATtodo] = ACTIONS(215),
    [anon_sym_ATexample] = ACTIONS(215),
    [anon_sym_ATlicense] = ACTIONS(215),
    [anon_sym_ATpackage] = ACTIONS(215),
    [anon_sym_ATsource] = ACTIONS(215),
    [anon_sym_ATsubpackage] = ACTIONS(215),
    [anon_sym_ATuses] = ACTIONS(215),
    [anon_sym_ATauthor] = ACTIONS(215),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_GT] = ACTIONS(215),
    [anon_sym_ATglobal] = ACTIONS(215),
    [anon_sym_ATlink] = ACTIONS(215),
    [anon_sym_ATmethod] = ACTIONS(215),
    [anon_sym_ATparam] = ACTIONS(213),
    [anon_sym_ATproperty] = ACTIONS(213),
    [anon_sym_ATproperty_DASHread] = ACTIONS(215),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(215),
    [anon_sym_ATreturn] = ACTIONS(215),
    [anon_sym_ATsee] = ACTIONS(215),
    [anon_sym_ATthrows] = ACTIONS(215),
    [anon_sym_ATvar] = ACTIONS(215),
    [anon_sym_ATdeprecated] = ACTIONS(215),
    [anon_sym_ATsince] = ACTIONS(215),
    [anon_sym_ATversion] = ACTIONS(215),
    [anon_sym_ATtemplate] = ACTIONS(213),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(215),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(215),
    [anon_sym_of] = ACTIONS(213),
    [anon_sym_ATimplements] = ACTIONS(215),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(215),
    [anon_sym_ATextends] = ACTIONS(215),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(215),
    [anon_sym_ATuse] = ACTIONS(213),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(215),
    [anon_sym_ATafter] = ACTIONS(213),
    [anon_sym_ATafterClass] = ACTIONS(215),
    [anon_sym_ATannotation] = ACTIONS(215),
    [anon_sym_ATbackupGlobals] = ACTIONS(215),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(215),
    [anon_sym_ATbefore] = ACTIONS(213),
    [anon_sym_ATbeforeClass] = ACTIONS(215),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(213),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(215),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(215),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(215),
    [anon_sym_ATcovers] = ACTIONS(213),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(213),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(215),
    [anon_sym_ATcoversNothing] = ACTIONS(215),
    [anon_sym_ATdataProvider] = ACTIONS(215),
    [anon_sym_ATdepends] = ACTIONS(213),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(215),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(215),
    [anon_sym_ATgroup] = ACTIONS(215),
    [anon_sym_ATlarge] = ACTIONS(215),
    [anon_sym_ATmedium] = ACTIONS(215),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(215),
    [anon_sym_ATrequires] = ACTIONS(213),
    [anon_sym_ATrequiresusages] = ACTIONS(215),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(215),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(215),
    [anon_sym_ATsmall] = ACTIONS(215),
    [anon_sym_ATtest] = ACTIONS(213),
    [anon_sym_ATtestWith] = ACTIONS(215),
    [anon_sym_ATtestdox] = ACTIONS(215),
    [anon_sym_ATticket] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(213),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(213),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(213),
    [anon_sym_ATreadonly] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(215),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(215),
    [anon_sym_ATparam_DASHout] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(213),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(215),
    [anon_sym_from] = ACTIONS(213),
    [anon_sym_as] = ACTIONS(213),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(215),
    [anon_sym_ATmixin] = ACTIONS(215),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(215),
    [anon_sym_COMMA] = ACTIONS(215),
    [anon_sym_PIPE] = ACTIONS(215),
    [anon_sym_AMP] = ACTIONS(215),
    [anon_sym_RPAREN] = ACTIONS(215),
    [anon_sym_DOLLAR] = ACTIONS(215),
    [sym__end] = ACTIONS(215),
  },
  [15] = {
    [sym_name] = ACTIONS(217),
    [anon_sym_ATinheritdoc] = ACTIONS(219),
    [anon_sym_ATinheritDoc] = ACTIONS(219),
    [anon_sym_RBRACE] = ACTIONS(219),
    [anon_sym_ATapi] = ACTIONS(219),
    [anon_sym_ATfilesource] = ACTIONS(219),
    [anon_sym_ATignore] = ACTIONS(219),
    [anon_sym_ATinternal] = ACTIONS(219),
    [anon_sym_ATcategory] = ACTIONS(219),
    [anon_sym_ATcopyright] = ACTIONS(219),
    [anon_sym_ATtodo] = ACTIONS(219),
    [anon_sym_ATexample] = ACTIONS(219),
    [anon_sym_ATlicense] = ACTIONS(219),
    [anon_sym_ATpackage] = ACTIONS(219),
    [anon_sym_ATsource] = ACTIONS(219),
    [anon_sym_ATsubpackage] = ACTIONS(219),
    [anon_sym_ATuses] = ACTIONS(219),
    [anon_sym_ATauthor] = ACTIONS(219),
    [anon_sym_LT] = ACTIONS(219),
    [anon_sym_GT] = ACTIONS(219),
    [anon_sym_ATglobal] = ACTIONS(219),
    [anon_sym_ATlink] = ACTIONS(219),
    [anon_sym_ATmethod] = ACTIONS(219),
    [anon_sym_ATparam] = ACTIONS(217),
    [anon_sym_ATproperty] = ACTIONS(217),
    [anon_sym_ATproperty_DASHread] = ACTIONS(219),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(219),
    [anon_sym_ATreturn] = ACTIONS(219),
    [anon_sym_ATsee] = ACTIONS(219),
    [anon_sym_ATthrows] = ACTIONS(219),
    [anon_sym_ATvar] = ACTIONS(219),
    [anon_sym_ATdeprecated] = ACTIONS(219),
    [anon_sym_ATsince] = ACTIONS(219),
    [anon_sym_ATversion] = ACTIONS(219),
    [anon_sym_ATtemplate] = ACTIONS(217),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(219),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(219),
    [anon_sym_of] = ACTIONS(217),
    [anon_sym_ATimplements] = ACTIONS(219),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(219),
    [anon_sym_ATextends] = ACTIONS(219),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(219),
    [anon_sym_ATuse] = ACTIONS(217),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(219),
    [anon_sym_ATafter] = ACTIONS(217),
    [anon_sym_ATafterClass] = ACTIONS(219),
    [anon_sym_ATannotation] = ACTIONS(219),
    [anon_sym_ATbackupGlobals] = ACTIONS(219),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(219),
    [anon_sym_ATbefore] = ACTIONS(217),
    [anon_sym_ATbeforeClass] = ACTIONS(219),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(217),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(219),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(219),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(219),
    [anon_sym_ATcovers] = ACTIONS(217),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(217),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(219),
    [anon_sym_ATcoversNothing] = ACTIONS(219),
    [anon_sym_ATdataProvider] = ACTIONS(219),
    [anon_sym_ATdepends] = ACTIONS(217),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(219),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(219),
    [anon_sym_ATgroup] = ACTIONS(219),
    [anon_sym_ATlarge] = ACTIONS(219),
    [anon_sym_ATmedium] = ACTIONS(219),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(219),
    [anon_sym_ATrequires] = ACTIONS(217),
    [anon_sym_ATrequiresusages] = ACTIONS(219),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(219),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(219),
    [anon_sym_ATsmall] = ACTIONS(219),
    [anon_sym_ATtest] = ACTIONS(217),
    [anon_sym_ATtestWith] = ACTIONS(219),
    [anon_sym_ATtestdox] = ACTIONS(219),
    [anon_sym_ATticket] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(217),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(217),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(217),
    [anon_sym_ATreadonly] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(219),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(219),
    [anon_sym_ATparam_DASHout] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(217),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(219),
    [anon_sym_from] = ACTIONS(217),
    [anon_sym_as] = ACTIONS(217),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(219),
    [anon_sym_ATmixin] = ACTIONS(219),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(219),
    [anon_sym_COMMA] = ACTIONS(219),
    [anon_sym_PIPE] = ACTIONS(219),
    [anon_sym_AMP] = ACTIONS(219),
    [anon_sym_RPAREN] = ACTIONS(219),
    [anon_sym_DOLLAR] = ACTIONS(219),
    [sym__end] = ACTIONS(219),
  },
  [16] = {
    [sym_name] = ACTIONS(221),
    [anon_sym_ATinheritdoc] = ACTIONS(223),
    [anon_sym_ATinheritDoc] = ACTIONS(223),
    [anon_sym_RBRACE] = ACTIONS(223),
    [anon_sym_ATapi] = ACTIONS(223),
    [anon_sym_ATfilesource] = ACTIONS(223),
    [anon_sym_ATignore] = ACTIONS(223),
    [anon_sym_ATinternal] = ACTIONS(223),
    [anon_sym_ATcategory] = ACTIONS(223),
    [anon_sym_ATcopyright] = ACTIONS(223),
    [anon_sym_ATtodo] = ACTIONS(223),
    [anon_sym_ATexample] = ACTIONS(223),
    [anon_sym_ATlicense] = ACTIONS(223),
    [anon_sym_ATpackage] = ACTIONS(223),
    [anon_sym_ATsource] = ACTIONS(223),
    [anon_sym_ATsubpackage] = ACTIONS(223),
    [anon_sym_ATuses] = ACTIONS(223),
    [anon_sym_ATauthor] = ACTIONS(223),
    [anon_sym_LT] = ACTIONS(223),
    [anon_sym_GT] = ACTIONS(223),
    [anon_sym_ATglobal] = ACTIONS(223),
    [anon_sym_ATlink] = ACTIONS(223),
    [anon_sym_ATmethod] = ACTIONS(223),
    [anon_sym_ATparam] = ACTIONS(221),
    [anon_sym_ATproperty] = ACTIONS(221),
    [anon_sym_ATproperty_DASHread] = ACTIONS(223),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(223),
    [anon_sym_ATreturn] = ACTIONS(223),
    [anon_sym_ATsee] = ACTIONS(223),
    [anon_sym_ATthrows] = ACTIONS(223),
    [anon_sym_ATvar] = ACTIONS(223),
    [anon_sym_ATdeprecated] = ACTIONS(223),
    [anon_sym_ATsince] = ACTIONS(223),
    [anon_sym_ATversion] = ACTIONS(223),
    [anon_sym_ATtemplate] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(223),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(223),
    [anon_sym_of] = ACTIONS(221),
    [anon_sym_ATimplements] = ACTIONS(223),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(223),
    [anon_sym_ATextends] = ACTIONS(223),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(223),
    [anon_sym_ATuse] = ACTIONS(221),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(223),
    [anon_sym_ATafter] = ACTIONS(221),
    [anon_sym_ATafterClass] = ACTIONS(223),
    [anon_sym_ATannotation] = ACTIONS(223),
    [anon_sym_ATbackupGlobals] = ACTIONS(223),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(223),
    [anon_sym_ATbefore] = ACTIONS(221),
    [anon_sym_ATbeforeClass] = ACTIONS(223),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(221),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(223),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(223),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(223),
    [anon_sym_ATcovers] = ACTIONS(221),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(221),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(223),
    [anon_sym_ATcoversNothing] = ACTIONS(223),
    [anon_sym_ATdataProvider] = ACTIONS(223),
    [anon_sym_ATdepends] = ACTIONS(221),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(223),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(223),
    [anon_sym_ATgroup] = ACTIONS(223),
    [anon_sym_ATlarge] = ACTIONS(223),
    [anon_sym_ATmedium] = ACTIONS(223),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(223),
    [anon_sym_ATrequires] = ACTIONS(221),
    [anon_sym_ATrequiresusages] = ACTIONS(223),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(223),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(223),
    [anon_sym_ATsmall] = ACTIONS(223),
    [anon_sym_ATtest] = ACTIONS(221),
    [anon_sym_ATtestWith] = ACTIONS(223),
    [anon_sym_ATtestdox] = ACTIONS(223),
    [anon_sym_ATticket] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(221),
    [anon_sym_ATreadonly] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(223),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(223),
    [anon_sym_ATparam_DASHout] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(223),
    [anon_sym_from] = ACTIONS(221),
    [anon_sym_as] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(223),
    [anon_sym_ATmixin] = ACTIONS(223),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(223),
    [anon_sym_COMMA] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(223),
    [anon_sym_AMP] = ACTIONS(223),
    [anon_sym_RPAREN] = ACTIONS(223),
    [anon_sym_DOLLAR] = ACTIONS(223),
    [sym__end] = ACTIONS(223),
  },
  [17] = {
    [sym__type_argument_list] = STATE(11),
    [aux_sym_namespace_name_repeat1] = STATE(323),
    [sym_name] = ACTIONS(221),
    [anon_sym_ATinheritdoc] = ACTIONS(223),
    [anon_sym_ATinheritDoc] = ACTIONS(223),
    [anon_sym_ATapi] = ACTIONS(223),
    [anon_sym_ATfilesource] = ACTIONS(223),
    [anon_sym_ATignore] = ACTIONS(223),
    [anon_sym_ATinternal] = ACTIONS(223),
    [anon_sym_ATcategory] = ACTIONS(223),
    [anon_sym_ATcopyright] = ACTIONS(223),
    [anon_sym_ATtodo] = ACTIONS(223),
    [anon_sym_ATexample] = ACTIONS(223),
    [anon_sym_ATlicense] = ACTIONS(223),
    [anon_sym_ATpackage] = ACTIONS(223),
    [anon_sym_ATsource] = ACTIONS(223),
    [anon_sym_ATsubpackage] = ACTIONS(223),
    [anon_sym_ATuses] = ACTIONS(223),
    [anon_sym_ATauthor] = ACTIONS(223),
    [anon_sym_LT] = ACTIONS(225),
    [anon_sym_GT] = ACTIONS(223),
    [anon_sym_ATglobal] = ACTIONS(223),
    [anon_sym_ATlink] = ACTIONS(223),
    [anon_sym_ATmethod] = ACTIONS(223),
    [anon_sym_ATparam] = ACTIONS(221),
    [anon_sym_ATproperty] = ACTIONS(221),
    [anon_sym_ATproperty_DASHread] = ACTIONS(223),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(223),
    [anon_sym_ATreturn] = ACTIONS(223),
    [anon_sym_ATsee] = ACTIONS(223),
    [anon_sym_ATthrows] = ACTIONS(223),
    [anon_sym_ATvar] = ACTIONS(223),
    [anon_sym_ATdeprecated] = ACTIONS(223),
    [anon_sym_ATsince] = ACTIONS(223),
    [anon_sym_ATversion] = ACTIONS(223),
    [anon_sym_ATtemplate] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(223),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(223),
    [anon_sym_of] = ACTIONS(221),
    [anon_sym_ATimplements] = ACTIONS(223),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(223),
    [anon_sym_ATextends] = ACTIONS(223),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(223),
    [anon_sym_ATuse] = ACTIONS(221),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(223),
    [anon_sym_ATafter] = ACTIONS(221),
    [anon_sym_ATafterClass] = ACTIONS(223),
    [anon_sym_ATannotation] = ACTIONS(223),
    [anon_sym_ATbackupGlobals] = ACTIONS(223),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(223),
    [anon_sym_ATbefore] = ACTIONS(221),
    [anon_sym_ATbeforeClass] = ACTIONS(223),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(221),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(223),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(223),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(223),
    [anon_sym_ATcovers] = ACTIONS(221),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(221),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(223),
    [anon_sym_ATcoversNothing] = ACTIONS(223),
    [anon_sym_ATdataProvider] = ACTIONS(223),
    [anon_sym_ATdepends] = ACTIONS(221),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(223),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(223),
    [anon_sym_ATgroup] = ACTIONS(223),
    [anon_sym_ATlarge] = ACTIONS(223),
    [anon_sym_ATmedium] = ACTIONS(223),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(223),
    [anon_sym_ATrequires] = ACTIONS(221),
    [anon_sym_ATrequiresusages] = ACTIONS(223),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(223),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(223),
    [anon_sym_ATsmall] = ACTIONS(223),
    [anon_sym_ATtest] = ACTIONS(221),
    [anon_sym_ATtestWith] = ACTIONS(223),
    [anon_sym_ATtestdox] = ACTIONS(223),
    [anon_sym_ATticket] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(221),
    [anon_sym_ATreadonly] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(223),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(223),
    [anon_sym_ATparam_DASHout] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(223),
    [anon_sym_ATmixin] = ACTIONS(223),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(223),
    [anon_sym_COMMA] = ACTIONS(223),
    [anon_sym_BSLASH] = ACTIONS(186),
    [anon_sym_PIPE] = ACTIONS(223),
    [anon_sym_AMP] = ACTIONS(223),
    [anon_sym_RPAREN] = ACTIONS(223),
    [anon_sym_DOLLAR] = ACTIONS(223),
    [sym__end] = ACTIONS(223),
  },
  [18] = {
    [sym_name] = ACTIONS(228),
    [anon_sym_LBRACE] = ACTIONS(230),
    [anon_sym_ATinheritdoc] = ACTIONS(232),
    [anon_sym_ATinheritDoc] = ACTIONS(232),
    [anon_sym_ATapi] = ACTIONS(232),
    [anon_sym_ATfilesource] = ACTIONS(232),
    [anon_sym_ATignore] = ACTIONS(232),
    [anon_sym_ATinternal] = ACTIONS(232),
    [anon_sym_ATcategory] = ACTIONS(232),
    [anon_sym_ATcopyright] = ACTIONS(232),
    [anon_sym_ATtodo] = ACTIONS(232),
    [anon_sym_ATexample] = ACTIONS(232),
    [anon_sym_ATlicense] = ACTIONS(232),
    [anon_sym_ATpackage] = ACTIONS(232),
    [anon_sym_ATsource] = ACTIONS(232),
    [anon_sym_ATsubpackage] = ACTIONS(232),
    [anon_sym_ATuses] = ACTIONS(232),
    [anon_sym_ATauthor] = ACTIONS(232),
    [anon_sym_LT] = ACTIONS(232),
    [anon_sym_GT] = ACTIONS(232),
    [anon_sym_ATglobal] = ACTIONS(232),
    [anon_sym_ATlink] = ACTIONS(232),
    [anon_sym_ATmethod] = ACTIONS(232),
    [anon_sym_ATparam] = ACTIONS(228),
    [anon_sym_ATproperty] = ACTIONS(228),
    [anon_sym_ATproperty_DASHread] = ACTIONS(232),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(232),
    [anon_sym_ATreturn] = ACTIONS(232),
    [anon_sym_ATsee] = ACTIONS(232),
    [anon_sym_ATthrows] = ACTIONS(232),
    [anon_sym_ATvar] = ACTIONS(232),
    [anon_sym_ATdeprecated] = ACTIONS(232),
    [anon_sym_ATsince] = ACTIONS(232),
    [anon_sym_ATversion] = ACTIONS(232),
    [anon_sym_ATtemplate] = ACTIONS(228),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(232),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(232),
    [anon_sym_of] = ACTIONS(228),
    [anon_sym_ATimplements] = ACTIONS(232),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(232),
    [anon_sym_ATextends] = ACTIONS(232),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(232),
    [anon_sym_ATuse] = ACTIONS(228),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(232),
    [anon_sym_ATafter] = ACTIONS(228),
    [anon_sym_ATafterClass] = ACTIONS(232),
    [anon_sym_ATannotation] = ACTIONS(232),
    [anon_sym_ATbackupGlobals] = ACTIONS(232),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(232),
    [anon_sym_ATbefore] = ACTIONS(228),
    [anon_sym_ATbeforeClass] = ACTIONS(232),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(228),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(232),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(232),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(232),
    [anon_sym_ATcovers] = ACTIONS(228),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(228),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(232),
    [anon_sym_ATcoversNothing] = ACTIONS(232),
    [anon_sym_ATdataProvider] = ACTIONS(232),
    [anon_sym_ATdepends] = ACTIONS(228),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(232),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(232),
    [anon_sym_ATgroup] = ACTIONS(232),
    [anon_sym_ATlarge] = ACTIONS(232),
    [anon_sym_ATmedium] = ACTIONS(232),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(232),
    [anon_sym_ATrequires] = ACTIONS(228),
    [anon_sym_ATrequiresusages] = ACTIONS(232),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(232),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(232),
    [anon_sym_ATsmall] = ACTIONS(232),
    [anon_sym_ATtest] = ACTIONS(228),
    [anon_sym_ATtestWith] = ACTIONS(232),
    [anon_sym_ATtestdox] = ACTIONS(232),
    [anon_sym_ATticket] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(228),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(228),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(228),
    [anon_sym_ATreadonly] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(232),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(232),
    [anon_sym_ATparam_DASHout] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(228),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(232),
    [anon_sym_ATmixin] = ACTIONS(232),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(232),
    [anon_sym_COMMA] = ACTIONS(232),
    [anon_sym_PIPE] = ACTIONS(232),
    [anon_sym_AMP] = ACTIONS(232),
    [anon_sym_RPAREN] = ACTIONS(232),
    [anon_sym_DOLLAR] = ACTIONS(232),
    [sym__end] = ACTIONS(232),
  },
  [19] = {
    [sym__type_argument_list] = STATE(11),
    [sym_name] = ACTIONS(221),
    [anon_sym_ATinheritdoc] = ACTIONS(223),
    [anon_sym_ATinheritDoc] = ACTIONS(223),
    [anon_sym_ATapi] = ACTIONS(223),
    [anon_sym_ATfilesource] = ACTIONS(223),
    [anon_sym_ATignore] = ACTIONS(223),
    [anon_sym_ATinternal] = ACTIONS(223),
    [anon_sym_ATcategory] = ACTIONS(223),
    [anon_sym_ATcopyright] = ACTIONS(223),
    [anon_sym_ATtodo] = ACTIONS(223),
    [anon_sym_ATexample] = ACTIONS(223),
    [anon_sym_ATlicense] = ACTIONS(223),
    [anon_sym_ATpackage] = ACTIONS(223),
    [anon_sym_ATsource] = ACTIONS(223),
    [anon_sym_ATsubpackage] = ACTIONS(223),
    [anon_sym_ATuses] = ACTIONS(223),
    [anon_sym_ATauthor] = ACTIONS(223),
    [anon_sym_LT] = ACTIONS(225),
    [anon_sym_GT] = ACTIONS(223),
    [anon_sym_ATglobal] = ACTIONS(223),
    [anon_sym_ATlink] = ACTIONS(223),
    [anon_sym_ATmethod] = ACTIONS(223),
    [anon_sym_ATparam] = ACTIONS(221),
    [anon_sym_ATproperty] = ACTIONS(221),
    [anon_sym_ATproperty_DASHread] = ACTIONS(223),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(223),
    [anon_sym_ATreturn] = ACTIONS(223),
    [anon_sym_ATsee] = ACTIONS(223),
    [anon_sym_ATthrows] = ACTIONS(223),
    [anon_sym_ATvar] = ACTIONS(223),
    [anon_sym_ATdeprecated] = ACTIONS(223),
    [anon_sym_ATsince] = ACTIONS(223),
    [anon_sym_ATversion] = ACTIONS(223),
    [anon_sym_ATtemplate] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(223),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(223),
    [anon_sym_of] = ACTIONS(221),
    [anon_sym_ATimplements] = ACTIONS(223),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(223),
    [anon_sym_ATextends] = ACTIONS(223),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(223),
    [anon_sym_ATuse] = ACTIONS(221),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(223),
    [anon_sym_ATafter] = ACTIONS(221),
    [anon_sym_ATafterClass] = ACTIONS(223),
    [anon_sym_ATannotation] = ACTIONS(223),
    [anon_sym_ATbackupGlobals] = ACTIONS(223),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(223),
    [anon_sym_ATbefore] = ACTIONS(221),
    [anon_sym_ATbeforeClass] = ACTIONS(223),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(221),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(223),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(223),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(223),
    [anon_sym_ATcovers] = ACTIONS(221),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(221),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(223),
    [anon_sym_ATcoversNothing] = ACTIONS(223),
    [anon_sym_ATdataProvider] = ACTIONS(223),
    [anon_sym_ATdepends] = ACTIONS(221),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(223),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(223),
    [anon_sym_ATgroup] = ACTIONS(223),
    [anon_sym_ATlarge] = ACTIONS(223),
    [anon_sym_ATmedium] = ACTIONS(223),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(223),
    [anon_sym_ATrequires] = ACTIONS(221),
    [anon_sym_ATrequiresusages] = ACTIONS(223),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(223),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(223),
    [anon_sym_ATsmall] = ACTIONS(223),
    [anon_sym_ATtest] = ACTIONS(221),
    [anon_sym_ATtestWith] = ACTIONS(223),
    [anon_sym_ATtestdox] = ACTIONS(223),
    [anon_sym_ATticket] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(221),
    [anon_sym_ATreadonly] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(223),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(223),
    [anon_sym_ATparam_DASHout] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(223),
    [anon_sym_ATmixin] = ACTIONS(223),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(223),
    [anon_sym_COMMA] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(223),
    [anon_sym_AMP] = ACTIONS(223),
    [anon_sym_RPAREN] = ACTIONS(223),
    [anon_sym_DOLLAR] = ACTIONS(223),
    [sym__end] = ACTIONS(223),
  },
  [20] = {
    [aux_sym__phpdoc_array_types_repeat1] = STATE(26),
    [sym_name] = ACTIONS(234),
    [anon_sym_ATinheritdoc] = ACTIONS(236),
    [anon_sym_ATinheritDoc] = ACTIONS(236),
    [anon_sym_ATapi] = ACTIONS(236),
    [anon_sym_ATfilesource] = ACTIONS(236),
    [anon_sym_ATignore] = ACTIONS(236),
    [anon_sym_ATinternal] = ACTIONS(236),
    [anon_sym_ATcategory] = ACTIONS(236),
    [anon_sym_ATcopyright] = ACTIONS(236),
    [anon_sym_ATtodo] = ACTIONS(236),
    [anon_sym_ATexample] = ACTIONS(236),
    [anon_sym_ATlicense] = ACTIONS(236),
    [anon_sym_ATpackage] = ACTIONS(236),
    [anon_sym_ATsource] = ACTIONS(236),
    [anon_sym_ATsubpackage] = ACTIONS(236),
    [anon_sym_ATuses] = ACTIONS(236),
    [anon_sym_ATauthor] = ACTIONS(236),
    [anon_sym_LT] = ACTIONS(238),
    [anon_sym_GT] = ACTIONS(236),
    [anon_sym_ATglobal] = ACTIONS(236),
    [anon_sym_ATlink] = ACTIONS(236),
    [anon_sym_ATmethod] = ACTIONS(236),
    [anon_sym_ATparam] = ACTIONS(234),
    [anon_sym_ATproperty] = ACTIONS(234),
    [anon_sym_ATproperty_DASHread] = ACTIONS(236),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(236),
    [anon_sym_ATreturn] = ACTIONS(236),
    [anon_sym_ATsee] = ACTIONS(236),
    [anon_sym_ATthrows] = ACTIONS(236),
    [anon_sym_ATvar] = ACTIONS(236),
    [anon_sym_ATdeprecated] = ACTIONS(236),
    [anon_sym_ATsince] = ACTIONS(236),
    [anon_sym_ATversion] = ACTIONS(236),
    [anon_sym_ATtemplate] = ACTIONS(234),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(236),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(236),
    [anon_sym_of] = ACTIONS(234),
    [anon_sym_ATimplements] = ACTIONS(236),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(236),
    [anon_sym_ATextends] = ACTIONS(236),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(236),
    [anon_sym_ATuse] = ACTIONS(234),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(236),
    [anon_sym_ATafter] = ACTIONS(234),
    [anon_sym_ATafterClass] = ACTIONS(236),
    [anon_sym_ATannotation] = ACTIONS(236),
    [anon_sym_ATbackupGlobals] = ACTIONS(236),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(236),
    [anon_sym_ATbefore] = ACTIONS(234),
    [anon_sym_ATbeforeClass] = ACTIONS(236),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(234),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(236),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(236),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(236),
    [anon_sym_ATcovers] = ACTIONS(234),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(234),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(236),
    [anon_sym_ATcoversNothing] = ACTIONS(236),
    [anon_sym_ATdataProvider] = ACTIONS(236),
    [anon_sym_ATdepends] = ACTIONS(234),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(236),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(236),
    [anon_sym_ATgroup] = ACTIONS(236),
    [anon_sym_ATlarge] = ACTIONS(236),
    [anon_sym_ATmedium] = ACTIONS(236),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(236),
    [anon_sym_ATrequires] = ACTIONS(234),
    [anon_sym_ATrequiresusages] = ACTIONS(236),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(236),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(236),
    [anon_sym_ATsmall] = ACTIONS(236),
    [anon_sym_ATtest] = ACTIONS(234),
    [anon_sym_ATtestWith] = ACTIONS(236),
    [anon_sym_ATtestdox] = ACTIONS(236),
    [anon_sym_ATticket] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(234),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(234),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(234),
    [anon_sym_ATreadonly] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(236),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(236),
    [anon_sym_ATparam_DASHout] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(234),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(236),
    [anon_sym_ATmixin] = ACTIONS(236),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(240),
    [anon_sym_COMMA] = ACTIONS(236),
    [anon_sym_PIPE] = ACTIONS(236),
    [anon_sym_AMP] = ACTIONS(236),
    [anon_sym_RPAREN] = ACTIONS(236),
    [anon_sym_DOLLAR] = ACTIONS(236),
    [sym__end] = ACTIONS(236),
  },
  [21] = {
    [sym_name] = ACTIONS(242),
    [anon_sym_ATinheritdoc] = ACTIONS(244),
    [anon_sym_ATinheritDoc] = ACTIONS(244),
    [anon_sym_RBRACE] = ACTIONS(244),
    [anon_sym_ATapi] = ACTIONS(244),
    [anon_sym_ATfilesource] = ACTIONS(244),
    [anon_sym_ATignore] = ACTIONS(244),
    [anon_sym_ATinternal] = ACTIONS(244),
    [anon_sym_ATcategory] = ACTIONS(244),
    [anon_sym_ATcopyright] = ACTIONS(244),
    [anon_sym_ATtodo] = ACTIONS(244),
    [anon_sym_ATexample] = ACTIONS(244),
    [anon_sym_ATlicense] = ACTIONS(244),
    [anon_sym_ATpackage] = ACTIONS(244),
    [anon_sym_ATsource] = ACTIONS(244),
    [anon_sym_ATsubpackage] = ACTIONS(244),
    [anon_sym_ATuses] = ACTIONS(244),
    [anon_sym_ATauthor] = ACTIONS(244),
    [anon_sym_LT] = ACTIONS(244),
    [anon_sym_GT] = ACTIONS(244),
    [anon_sym_ATglobal] = ACTIONS(244),
    [anon_sym_ATlink] = ACTIONS(244),
    [anon_sym_ATmethod] = ACTIONS(244),
    [anon_sym_ATparam] = ACTIONS(242),
    [anon_sym_ATproperty] = ACTIONS(242),
    [anon_sym_ATproperty_DASHread] = ACTIONS(244),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(244),
    [anon_sym_ATreturn] = ACTIONS(244),
    [anon_sym_ATsee] = ACTIONS(244),
    [anon_sym_ATthrows] = ACTIONS(244),
    [anon_sym_ATvar] = ACTIONS(244),
    [anon_sym_ATdeprecated] = ACTIONS(244),
    [anon_sym_ATsince] = ACTIONS(244),
    [anon_sym_ATversion] = ACTIONS(244),
    [anon_sym_ATtemplate] = ACTIONS(242),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(244),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(244),
    [anon_sym_of] = ACTIONS(242),
    [anon_sym_ATimplements] = ACTIONS(244),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(244),
    [anon_sym_ATextends] = ACTIONS(244),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(244),
    [anon_sym_ATuse] = ACTIONS(242),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(244),
    [anon_sym_ATafter] = ACTIONS(242),
    [anon_sym_ATafterClass] = ACTIONS(244),
    [anon_sym_ATannotation] = ACTIONS(244),
    [anon_sym_ATbackupGlobals] = ACTIONS(244),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(244),
    [anon_sym_ATbefore] = ACTIONS(242),
    [anon_sym_ATbeforeClass] = ACTIONS(244),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(242),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(244),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(244),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(244),
    [anon_sym_ATcovers] = ACTIONS(242),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(242),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(244),
    [anon_sym_ATcoversNothing] = ACTIONS(244),
    [anon_sym_ATdataProvider] = ACTIONS(244),
    [anon_sym_ATdepends] = ACTIONS(242),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(244),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(244),
    [anon_sym_ATgroup] = ACTIONS(244),
    [anon_sym_ATlarge] = ACTIONS(244),
    [anon_sym_ATmedium] = ACTIONS(244),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(244),
    [anon_sym_ATrequires] = ACTIONS(242),
    [anon_sym_ATrequiresusages] = ACTIONS(244),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(244),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(244),
    [anon_sym_ATsmall] = ACTIONS(244),
    [anon_sym_ATtest] = ACTIONS(242),
    [anon_sym_ATtestWith] = ACTIONS(244),
    [anon_sym_ATtestdox] = ACTIONS(244),
    [anon_sym_ATticket] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(242),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(242),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(242),
    [anon_sym_ATreadonly] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(244),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(244),
    [anon_sym_ATparam_DASHout] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(242),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(244),
    [anon_sym_ATmixin] = ACTIONS(244),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(244),
    [anon_sym_COMMA] = ACTIONS(244),
    [anon_sym_PIPE] = ACTIONS(244),
    [anon_sym_AMP] = ACTIONS(244),
    [anon_sym_RPAREN] = ACTIONS(244),
    [anon_sym_DOLLAR] = ACTIONS(244),
    [sym__end] = ACTIONS(244),
  },
  [22] = {
    [sym_name] = ACTIONS(228),
    [anon_sym_ATinheritdoc] = ACTIONS(232),
    [anon_sym_ATinheritDoc] = ACTIONS(232),
    [anon_sym_RBRACE] = ACTIONS(232),
    [anon_sym_ATapi] = ACTIONS(232),
    [anon_sym_ATfilesource] = ACTIONS(232),
    [anon_sym_ATignore] = ACTIONS(232),
    [anon_sym_ATinternal] = ACTIONS(232),
    [anon_sym_ATcategory] = ACTIONS(232),
    [anon_sym_ATcopyright] = ACTIONS(232),
    [anon_sym_ATtodo] = ACTIONS(232),
    [anon_sym_ATexample] = ACTIONS(232),
    [anon_sym_ATlicense] = ACTIONS(232),
    [anon_sym_ATpackage] = ACTIONS(232),
    [anon_sym_ATsource] = ACTIONS(232),
    [anon_sym_ATsubpackage] = ACTIONS(232),
    [anon_sym_ATuses] = ACTIONS(232),
    [anon_sym_ATauthor] = ACTIONS(232),
    [anon_sym_LT] = ACTIONS(232),
    [anon_sym_GT] = ACTIONS(232),
    [anon_sym_ATglobal] = ACTIONS(232),
    [anon_sym_ATlink] = ACTIONS(232),
    [anon_sym_ATmethod] = ACTIONS(232),
    [anon_sym_ATparam] = ACTIONS(228),
    [anon_sym_ATproperty] = ACTIONS(228),
    [anon_sym_ATproperty_DASHread] = ACTIONS(232),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(232),
    [anon_sym_ATreturn] = ACTIONS(232),
    [anon_sym_ATsee] = ACTIONS(232),
    [anon_sym_ATthrows] = ACTIONS(232),
    [anon_sym_ATvar] = ACTIONS(232),
    [anon_sym_ATdeprecated] = ACTIONS(232),
    [anon_sym_ATsince] = ACTIONS(232),
    [anon_sym_ATversion] = ACTIONS(232),
    [anon_sym_ATtemplate] = ACTIONS(228),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(232),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(232),
    [anon_sym_of] = ACTIONS(228),
    [anon_sym_ATimplements] = ACTIONS(232),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(232),
    [anon_sym_ATextends] = ACTIONS(232),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(232),
    [anon_sym_ATuse] = ACTIONS(228),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(232),
    [anon_sym_ATafter] = ACTIONS(228),
    [anon_sym_ATafterClass] = ACTIONS(232),
    [anon_sym_ATannotation] = ACTIONS(232),
    [anon_sym_ATbackupGlobals] = ACTIONS(232),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(232),
    [anon_sym_ATbefore] = ACTIONS(228),
    [anon_sym_ATbeforeClass] = ACTIONS(232),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(228),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(232),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(232),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(232),
    [anon_sym_ATcovers] = ACTIONS(228),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(228),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(232),
    [anon_sym_ATcoversNothing] = ACTIONS(232),
    [anon_sym_ATdataProvider] = ACTIONS(232),
    [anon_sym_ATdepends] = ACTIONS(228),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(232),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(232),
    [anon_sym_ATgroup] = ACTIONS(232),
    [anon_sym_ATlarge] = ACTIONS(232),
    [anon_sym_ATmedium] = ACTIONS(232),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(232),
    [anon_sym_ATrequires] = ACTIONS(228),
    [anon_sym_ATrequiresusages] = ACTIONS(232),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(232),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(232),
    [anon_sym_ATsmall] = ACTIONS(232),
    [anon_sym_ATtest] = ACTIONS(228),
    [anon_sym_ATtestWith] = ACTIONS(232),
    [anon_sym_ATtestdox] = ACTIONS(232),
    [anon_sym_ATticket] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(228),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(228),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(228),
    [anon_sym_ATreadonly] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(232),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(232),
    [anon_sym_ATparam_DASHout] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(228),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(232),
    [anon_sym_ATmixin] = ACTIONS(232),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(232),
    [anon_sym_COMMA] = ACTIONS(232),
    [anon_sym_PIPE] = ACTIONS(232),
    [anon_sym_AMP] = ACTIONS(232),
    [anon_sym_RPAREN] = ACTIONS(232),
    [anon_sym_DOLLAR] = ACTIONS(232),
    [sym__end] = ACTIONS(232),
  },
  [23] = {
    [sym__description_not_version] = STATE(157),
    [sym_inline_tag] = STATE(148),
    [sym_version] = STATE(81),
    [aux_sym__description_not_version_repeat1] = STATE(115),
    [anon_sym_LBRACE] = ACTIONS(246),
    [anon_sym_ATinheritdoc] = ACTIONS(248),
    [anon_sym_ATinheritDoc] = ACTIONS(248),
    [anon_sym_ATapi] = ACTIONS(248),
    [anon_sym_ATfilesource] = ACTIONS(248),
    [anon_sym_ATignore] = ACTIONS(248),
    [anon_sym_ATinternal] = ACTIONS(248),
    [anon_sym_ATcategory] = ACTIONS(248),
    [anon_sym_ATcopyright] = ACTIONS(248),
    [anon_sym_ATtodo] = ACTIONS(248),
    [anon_sym_ATexample] = ACTIONS(248),
    [anon_sym_ATlicense] = ACTIONS(248),
    [anon_sym_ATpackage] = ACTIONS(250),
    [anon_sym_ATsource] = ACTIONS(248),
    [anon_sym_ATsubpackage] = ACTIONS(248),
    [anon_sym_ATuses] = ACTIONS(248),
    [anon_sym_ATauthor] = ACTIONS(248),
    [anon_sym_ATglobal] = ACTIONS(248),
    [anon_sym_ATlink] = ACTIONS(248),
    [anon_sym_ATmethod] = ACTIONS(248),
    [anon_sym_ATparam] = ACTIONS(250),
    [anon_sym_ATproperty] = ACTIONS(250),
    [anon_sym_ATproperty_DASHread] = ACTIONS(248),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(248),
    [anon_sym_ATreturn] = ACTIONS(248),
    [anon_sym_ATsee] = ACTIONS(248),
    [anon_sym_ATthrows] = ACTIONS(248),
    [anon_sym_ATvar] = ACTIONS(248),
    [anon_sym_ATdeprecated] = ACTIONS(248),
    [anon_sym_ATsince] = ACTIONS(248),
    [anon_sym_ATversion] = ACTIONS(248),
    [anon_sym_ATtemplate] = ACTIONS(250),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(248),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(248),
    [anon_sym_ATimplements] = ACTIONS(248),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(248),
    [anon_sym_ATextends] = ACTIONS(248),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(248),
    [anon_sym_ATuse] = ACTIONS(250),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(248),
    [anon_sym_ATafter] = ACTIONS(250),
    [anon_sym_ATafterClass] = ACTIONS(248),
    [anon_sym_ATannotation] = ACTIONS(248),
    [anon_sym_ATbackupGlobals] = ACTIONS(248),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(248),
    [anon_sym_ATbefore] = ACTIONS(250),
    [anon_sym_ATbeforeClass] = ACTIONS(248),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(250),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(248),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(248),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(248),
    [anon_sym_ATcovers] = ACTIONS(250),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(250),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(248),
    [anon_sym_ATcoversNothing] = ACTIONS(248),
    [anon_sym_ATdataProvider] = ACTIONS(248),
    [anon_sym_ATdepends] = ACTIONS(250),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(248),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(248),
    [anon_sym_ATgroup] = ACTIONS(248),
    [anon_sym_ATlarge] = ACTIONS(248),
    [anon_sym_ATmedium] = ACTIONS(248),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(248),
    [anon_sym_ATrequires] = ACTIONS(250),
    [anon_sym_ATrequiresusages] = ACTIONS(248),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(248),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(248),
    [anon_sym_ATsmall] = ACTIONS(248),
    [anon_sym_ATtest] = ACTIONS(250),
    [anon_sym_ATtestWith] = ACTIONS(248),
    [anon_sym_ATtestdox] = ACTIONS(248),
    [anon_sym_ATticket] = ACTIONS(248),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(248),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(248),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(248),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(250),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(248),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(250),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(248),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(248),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(248),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(248),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(248),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(248),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(248),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(248),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(248),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(250),
    [anon_sym_ATreadonly] = ACTIONS(248),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(248),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(248),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(248),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(248),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(248),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(248),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(248),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(248),
    [anon_sym_ATparam_DASHout] = ACTIONS(248),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(248),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(250),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(248),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(248),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(248),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(248),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(248),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(248),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(248),
    [anon_sym_ATmixin] = ACTIONS(248),
    [aux_sym_version_token1] = ACTIONS(252),
    [aux_sym_version_token2] = ACTIONS(254),
    [anon_sym_ATpackage_version_AT] = ACTIONS(252),
    [sym__version_vector] = ACTIONS(252),
    [sym__end] = ACTIONS(248),
    [sym__text_not_version] = ACTIONS(256),
  },
  [24] = {
    [aux_sym__phpdoc_array_types_repeat1] = STATE(24),
    [sym_name] = ACTIONS(258),
    [anon_sym_ATinheritdoc] = ACTIONS(260),
    [anon_sym_ATinheritDoc] = ACTIONS(260),
    [anon_sym_ATapi] = ACTIONS(260),
    [anon_sym_ATfilesource] = ACTIONS(260),
    [anon_sym_ATignore] = ACTIONS(260),
    [anon_sym_ATinternal] = ACTIONS(260),
    [anon_sym_ATcategory] = ACTIONS(260),
    [anon_sym_ATcopyright] = ACTIONS(260),
    [anon_sym_ATtodo] = ACTIONS(260),
    [anon_sym_ATexample] = ACTIONS(260),
    [anon_sym_ATlicense] = ACTIONS(260),
    [anon_sym_ATpackage] = ACTIONS(260),
    [anon_sym_ATsource] = ACTIONS(260),
    [anon_sym_ATsubpackage] = ACTIONS(260),
    [anon_sym_ATuses] = ACTIONS(260),
    [anon_sym_ATauthor] = ACTIONS(260),
    [anon_sym_GT] = ACTIONS(260),
    [anon_sym_ATglobal] = ACTIONS(260),
    [anon_sym_ATlink] = ACTIONS(260),
    [anon_sym_ATmethod] = ACTIONS(260),
    [anon_sym_ATparam] = ACTIONS(258),
    [anon_sym_ATproperty] = ACTIONS(258),
    [anon_sym_ATproperty_DASHread] = ACTIONS(260),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(260),
    [anon_sym_ATreturn] = ACTIONS(260),
    [anon_sym_ATsee] = ACTIONS(260),
    [anon_sym_ATthrows] = ACTIONS(260),
    [anon_sym_ATvar] = ACTIONS(260),
    [anon_sym_ATdeprecated] = ACTIONS(260),
    [anon_sym_ATsince] = ACTIONS(260),
    [anon_sym_ATversion] = ACTIONS(260),
    [anon_sym_ATtemplate] = ACTIONS(258),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(260),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(260),
    [anon_sym_of] = ACTIONS(258),
    [anon_sym_ATimplements] = ACTIONS(260),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(260),
    [anon_sym_ATextends] = ACTIONS(260),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(260),
    [anon_sym_ATuse] = ACTIONS(258),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(260),
    [anon_sym_ATafter] = ACTIONS(258),
    [anon_sym_ATafterClass] = ACTIONS(260),
    [anon_sym_ATannotation] = ACTIONS(260),
    [anon_sym_ATbackupGlobals] = ACTIONS(260),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(260),
    [anon_sym_ATbefore] = ACTIONS(258),
    [anon_sym_ATbeforeClass] = ACTIONS(260),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(258),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(260),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(260),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(260),
    [anon_sym_ATcovers] = ACTIONS(258),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(258),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(260),
    [anon_sym_ATcoversNothing] = ACTIONS(260),
    [anon_sym_ATdataProvider] = ACTIONS(260),
    [anon_sym_ATdepends] = ACTIONS(258),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(260),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(260),
    [anon_sym_ATgroup] = ACTIONS(260),
    [anon_sym_ATlarge] = ACTIONS(260),
    [anon_sym_ATmedium] = ACTIONS(260),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(260),
    [anon_sym_ATrequires] = ACTIONS(258),
    [anon_sym_ATrequiresusages] = ACTIONS(260),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(260),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(260),
    [anon_sym_ATsmall] = ACTIONS(260),
    [anon_sym_ATtest] = ACTIONS(258),
    [anon_sym_ATtestWith] = ACTIONS(260),
    [anon_sym_ATtestdox] = ACTIONS(260),
    [anon_sym_ATticket] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(258),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(258),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(258),
    [anon_sym_ATreadonly] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(260),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(260),
    [anon_sym_ATparam_DASHout] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(258),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(260),
    [anon_sym_ATmixin] = ACTIONS(260),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(262),
    [anon_sym_COMMA] = ACTIONS(260),
    [anon_sym_PIPE] = ACTIONS(260),
    [anon_sym_AMP] = ACTIONS(260),
    [anon_sym_RPAREN] = ACTIONS(260),
    [anon_sym_DOLLAR] = ACTIONS(260),
    [sym__end] = ACTIONS(260),
  },
  [25] = {
    [sym__type_argument_named_type] = STATE(37),
    [sym_name] = ACTIONS(265),
    [anon_sym_ATinheritdoc] = ACTIONS(267),
    [anon_sym_ATinheritDoc] = ACTIONS(267),
    [anon_sym_ATapi] = ACTIONS(267),
    [anon_sym_ATfilesource] = ACTIONS(267),
    [anon_sym_ATignore] = ACTIONS(267),
    [anon_sym_ATinternal] = ACTIONS(267),
    [anon_sym_ATcategory] = ACTIONS(267),
    [anon_sym_ATcopyright] = ACTIONS(267),
    [anon_sym_ATtodo] = ACTIONS(267),
    [anon_sym_ATexample] = ACTIONS(267),
    [anon_sym_ATlicense] = ACTIONS(267),
    [anon_sym_ATpackage] = ACTIONS(267),
    [anon_sym_ATsource] = ACTIONS(267),
    [anon_sym_ATsubpackage] = ACTIONS(267),
    [anon_sym_ATuses] = ACTIONS(267),
    [anon_sym_ATauthor] = ACTIONS(267),
    [anon_sym_LT] = ACTIONS(269),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_ATglobal] = ACTIONS(267),
    [anon_sym_ATlink] = ACTIONS(267),
    [anon_sym_ATmethod] = ACTIONS(267),
    [anon_sym_ATparam] = ACTIONS(265),
    [anon_sym_ATproperty] = ACTIONS(265),
    [anon_sym_ATproperty_DASHread] = ACTIONS(267),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(267),
    [anon_sym_ATreturn] = ACTIONS(267),
    [anon_sym_ATsee] = ACTIONS(267),
    [anon_sym_ATthrows] = ACTIONS(267),
    [anon_sym_ATvar] = ACTIONS(267),
    [anon_sym_ATdeprecated] = ACTIONS(267),
    [anon_sym_ATsince] = ACTIONS(267),
    [anon_sym_ATversion] = ACTIONS(267),
    [anon_sym_ATtemplate] = ACTIONS(265),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(267),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(267),
    [anon_sym_of] = ACTIONS(265),
    [anon_sym_ATimplements] = ACTIONS(267),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(267),
    [anon_sym_ATextends] = ACTIONS(267),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(267),
    [anon_sym_ATuse] = ACTIONS(265),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(267),
    [anon_sym_ATafter] = ACTIONS(265),
    [anon_sym_ATafterClass] = ACTIONS(267),
    [anon_sym_ATannotation] = ACTIONS(267),
    [anon_sym_ATbackupGlobals] = ACTIONS(267),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(267),
    [anon_sym_ATbefore] = ACTIONS(265),
    [anon_sym_ATbeforeClass] = ACTIONS(267),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(265),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(267),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(267),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(267),
    [anon_sym_ATcovers] = ACTIONS(265),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(265),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(267),
    [anon_sym_ATcoversNothing] = ACTIONS(267),
    [anon_sym_ATdataProvider] = ACTIONS(267),
    [anon_sym_ATdepends] = ACTIONS(265),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(267),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(267),
    [anon_sym_ATgroup] = ACTIONS(267),
    [anon_sym_ATlarge] = ACTIONS(267),
    [anon_sym_ATmedium] = ACTIONS(267),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(267),
    [anon_sym_ATrequires] = ACTIONS(265),
    [anon_sym_ATrequiresusages] = ACTIONS(267),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(267),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(267),
    [anon_sym_ATsmall] = ACTIONS(267),
    [anon_sym_ATtest] = ACTIONS(265),
    [anon_sym_ATtestWith] = ACTIONS(267),
    [anon_sym_ATtestdox] = ACTIONS(267),
    [anon_sym_ATticket] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(265),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(265),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(265),
    [anon_sym_ATreadonly] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(267),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(267),
    [anon_sym_ATparam_DASHout] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(265),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(267),
    [anon_sym_ATmixin] = ACTIONS(267),
    [anon_sym_COMMA] = ACTIONS(267),
    [anon_sym_PIPE] = ACTIONS(267),
    [anon_sym_AMP] = ACTIONS(267),
    [anon_sym_RPAREN] = ACTIONS(267),
    [anon_sym_DOLLAR] = ACTIONS(267),
    [sym__end] = ACTIONS(267),
  },
  [26] = {
    [aux_sym__phpdoc_array_types_repeat1] = STATE(24),
    [sym_name] = ACTIONS(271),
    [anon_sym_ATinheritdoc] = ACTIONS(273),
    [anon_sym_ATinheritDoc] = ACTIONS(273),
    [anon_sym_ATapi] = ACTIONS(273),
    [anon_sym_ATfilesource] = ACTIONS(273),
    [anon_sym_ATignore] = ACTIONS(273),
    [anon_sym_ATinternal] = ACTIONS(273),
    [anon_sym_ATcategory] = ACTIONS(273),
    [anon_sym_ATcopyright] = ACTIONS(273),
    [anon_sym_ATtodo] = ACTIONS(273),
    [anon_sym_ATexample] = ACTIONS(273),
    [anon_sym_ATlicense] = ACTIONS(273),
    [anon_sym_ATpackage] = ACTIONS(273),
    [anon_sym_ATsource] = ACTIONS(273),
    [anon_sym_ATsubpackage] = ACTIONS(273),
    [anon_sym_ATuses] = ACTIONS(273),
    [anon_sym_ATauthor] = ACTIONS(273),
    [anon_sym_GT] = ACTIONS(273),
    [anon_sym_ATglobal] = ACTIONS(273),
    [anon_sym_ATlink] = ACTIONS(273),
    [anon_sym_ATmethod] = ACTIONS(273),
    [anon_sym_ATparam] = ACTIONS(271),
    [anon_sym_ATproperty] = ACTIONS(271),
    [anon_sym_ATproperty_DASHread] = ACTIONS(273),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(273),
    [anon_sym_ATreturn] = ACTIONS(273),
    [anon_sym_ATsee] = ACTIONS(273),
    [anon_sym_ATthrows] = ACTIONS(273),
    [anon_sym_ATvar] = ACTIONS(273),
    [anon_sym_ATdeprecated] = ACTIONS(273),
    [anon_sym_ATsince] = ACTIONS(273),
    [anon_sym_ATversion] = ACTIONS(273),
    [anon_sym_ATtemplate] = ACTIONS(271),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(273),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(273),
    [anon_sym_of] = ACTIONS(271),
    [anon_sym_ATimplements] = ACTIONS(273),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(273),
    [anon_sym_ATextends] = ACTIONS(273),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(273),
    [anon_sym_ATuse] = ACTIONS(271),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(273),
    [anon_sym_ATafter] = ACTIONS(271),
    [anon_sym_ATafterClass] = ACTIONS(273),
    [anon_sym_ATannotation] = ACTIONS(273),
    [anon_sym_ATbackupGlobals] = ACTIONS(273),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(273),
    [anon_sym_ATbefore] = ACTIONS(271),
    [anon_sym_ATbeforeClass] = ACTIONS(273),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(271),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(273),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(273),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(273),
    [anon_sym_ATcovers] = ACTIONS(271),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(271),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(273),
    [anon_sym_ATcoversNothing] = ACTIONS(273),
    [anon_sym_ATdataProvider] = ACTIONS(273),
    [anon_sym_ATdepends] = ACTIONS(271),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(273),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(273),
    [anon_sym_ATgroup] = ACTIONS(273),
    [anon_sym_ATlarge] = ACTIONS(273),
    [anon_sym_ATmedium] = ACTIONS(273),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(273),
    [anon_sym_ATrequires] = ACTIONS(271),
    [anon_sym_ATrequiresusages] = ACTIONS(273),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(273),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(273),
    [anon_sym_ATsmall] = ACTIONS(273),
    [anon_sym_ATtest] = ACTIONS(271),
    [anon_sym_ATtestWith] = ACTIONS(273),
    [anon_sym_ATtestdox] = ACTIONS(273),
    [anon_sym_ATticket] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(271),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(271),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(271),
    [anon_sym_ATreadonly] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(273),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(273),
    [anon_sym_ATparam_DASHout] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(271),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(273),
    [anon_sym_ATmixin] = ACTIONS(273),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(275),
    [anon_sym_COMMA] = ACTIONS(273),
    [anon_sym_PIPE] = ACTIONS(273),
    [anon_sym_AMP] = ACTIONS(273),
    [anon_sym_RPAREN] = ACTIONS(273),
    [anon_sym_DOLLAR] = ACTIONS(273),
    [sym__end] = ACTIONS(273),
  },
  [27] = {
    [sym__type_argument_list] = STATE(55),
    [aux_sym_namespace_name_repeat1] = STATE(323),
    [anon_sym_LBRACE] = ACTIONS(223),
    [anon_sym_ATinheritdoc] = ACTIONS(223),
    [anon_sym_ATinheritDoc] = ACTIONS(223),
    [anon_sym_ATapi] = ACTIONS(223),
    [anon_sym_ATfilesource] = ACTIONS(223),
    [anon_sym_ATignore] = ACTIONS(223),
    [anon_sym_ATinternal] = ACTIONS(223),
    [anon_sym_ATcategory] = ACTIONS(223),
    [anon_sym_ATcopyright] = ACTIONS(223),
    [anon_sym_ATtodo] = ACTIONS(223),
    [anon_sym_ATexample] = ACTIONS(223),
    [anon_sym_ATlicense] = ACTIONS(223),
    [anon_sym_ATpackage] = ACTIONS(223),
    [anon_sym_ATsource] = ACTIONS(223),
    [anon_sym_ATsubpackage] = ACTIONS(223),
    [anon_sym_ATuses] = ACTIONS(223),
    [anon_sym_ATauthor] = ACTIONS(223),
    [anon_sym_LT] = ACTIONS(277),
    [anon_sym_ATglobal] = ACTIONS(223),
    [anon_sym_ATlink] = ACTIONS(223),
    [anon_sym_ATmethod] = ACTIONS(223),
    [anon_sym_ATparam] = ACTIONS(221),
    [anon_sym_ATproperty] = ACTIONS(221),
    [anon_sym_ATproperty_DASHread] = ACTIONS(223),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(223),
    [anon_sym_ATreturn] = ACTIONS(223),
    [anon_sym_ATsee] = ACTIONS(223),
    [anon_sym_ATthrows] = ACTIONS(223),
    [anon_sym_ATvar] = ACTIONS(223),
    [anon_sym_ATdeprecated] = ACTIONS(223),
    [anon_sym_ATsince] = ACTIONS(223),
    [anon_sym_ATversion] = ACTIONS(223),
    [anon_sym_ATtemplate] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(223),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(223),
    [anon_sym_ATimplements] = ACTIONS(223),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(223),
    [anon_sym_ATextends] = ACTIONS(223),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(223),
    [anon_sym_ATuse] = ACTIONS(221),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(223),
    [anon_sym_ATafter] = ACTIONS(221),
    [anon_sym_ATafterClass] = ACTIONS(223),
    [anon_sym_ATannotation] = ACTIONS(223),
    [anon_sym_ATbackupGlobals] = ACTIONS(223),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(223),
    [anon_sym_ATbefore] = ACTIONS(221),
    [anon_sym_ATbeforeClass] = ACTIONS(223),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(221),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(223),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(223),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(223),
    [anon_sym_ATcovers] = ACTIONS(221),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(221),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(223),
    [anon_sym_ATcoversNothing] = ACTIONS(223),
    [anon_sym_ATdataProvider] = ACTIONS(223),
    [anon_sym_ATdepends] = ACTIONS(221),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(223),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(223),
    [anon_sym_ATgroup] = ACTIONS(223),
    [anon_sym_ATlarge] = ACTIONS(223),
    [anon_sym_ATmedium] = ACTIONS(223),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(223),
    [anon_sym_ATrequires] = ACTIONS(221),
    [anon_sym_ATrequiresusages] = ACTIONS(223),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(223),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(223),
    [anon_sym_ATsmall] = ACTIONS(223),
    [anon_sym_ATtest] = ACTIONS(221),
    [anon_sym_ATtestWith] = ACTIONS(223),
    [anon_sym_ATtestdox] = ACTIONS(223),
    [anon_sym_ATticket] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(221),
    [anon_sym_ATreadonly] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(223),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(223),
    [anon_sym_ATparam_DASHout] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(223),
    [anon_sym_ATmixin] = ACTIONS(223),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(223),
    [anon_sym_BSLASH] = ACTIONS(186),
    [anon_sym_PIPE] = ACTIONS(223),
    [anon_sym_AMP] = ACTIONS(223),
    [anon_sym_DOLLAR] = ACTIONS(223),
    [sym__end] = ACTIONS(223),
    [sym__text_after_type] = ACTIONS(223),
  },
  [28] = {
    [sym__type_argument_list] = STATE(11),
    [aux_sym_namespace_name_repeat1] = STATE(323),
    [anon_sym_ATinheritdoc] = ACTIONS(223),
    [anon_sym_ATinheritDoc] = ACTIONS(223),
    [anon_sym_RBRACE] = ACTIONS(223),
    [anon_sym_ATapi] = ACTIONS(223),
    [anon_sym_ATfilesource] = ACTIONS(223),
    [anon_sym_ATignore] = ACTIONS(223),
    [anon_sym_ATinternal] = ACTIONS(223),
    [anon_sym_ATcategory] = ACTIONS(223),
    [anon_sym_ATcopyright] = ACTIONS(223),
    [anon_sym_ATtodo] = ACTIONS(223),
    [anon_sym_ATexample] = ACTIONS(223),
    [anon_sym_ATlicense] = ACTIONS(223),
    [anon_sym_ATpackage] = ACTIONS(223),
    [anon_sym_ATsource] = ACTIONS(223),
    [anon_sym_ATsubpackage] = ACTIONS(223),
    [anon_sym_ATuses] = ACTIONS(223),
    [anon_sym_ATauthor] = ACTIONS(223),
    [anon_sym_LT] = ACTIONS(280),
    [anon_sym_GT] = ACTIONS(223),
    [anon_sym_ATglobal] = ACTIONS(223),
    [anon_sym_ATlink] = ACTIONS(223),
    [anon_sym_ATmethod] = ACTIONS(223),
    [anon_sym_ATparam] = ACTIONS(221),
    [anon_sym_ATproperty] = ACTIONS(221),
    [anon_sym_ATproperty_DASHread] = ACTIONS(223),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(223),
    [anon_sym_ATreturn] = ACTIONS(223),
    [anon_sym_ATsee] = ACTIONS(223),
    [anon_sym_ATthrows] = ACTIONS(223),
    [anon_sym_ATvar] = ACTIONS(223),
    [anon_sym_ATdeprecated] = ACTIONS(223),
    [anon_sym_ATsince] = ACTIONS(223),
    [anon_sym_ATversion] = ACTIONS(223),
    [anon_sym_ATtemplate] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(223),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(223),
    [anon_sym_ATimplements] = ACTIONS(223),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(223),
    [anon_sym_ATextends] = ACTIONS(223),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(223),
    [anon_sym_ATuse] = ACTIONS(221),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(223),
    [anon_sym_ATafter] = ACTIONS(221),
    [anon_sym_ATafterClass] = ACTIONS(223),
    [anon_sym_ATannotation] = ACTIONS(223),
    [anon_sym_ATbackupGlobals] = ACTIONS(223),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(223),
    [anon_sym_ATbefore] = ACTIONS(221),
    [anon_sym_ATbeforeClass] = ACTIONS(223),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(221),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(223),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(223),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(223),
    [anon_sym_ATcovers] = ACTIONS(221),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(221),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(223),
    [anon_sym_ATcoversNothing] = ACTIONS(223),
    [anon_sym_ATdataProvider] = ACTIONS(223),
    [anon_sym_ATdepends] = ACTIONS(221),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(223),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(223),
    [anon_sym_ATgroup] = ACTIONS(223),
    [anon_sym_ATlarge] = ACTIONS(223),
    [anon_sym_ATmedium] = ACTIONS(223),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(223),
    [anon_sym_ATrequires] = ACTIONS(221),
    [anon_sym_ATrequiresusages] = ACTIONS(223),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(223),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(223),
    [anon_sym_ATsmall] = ACTIONS(223),
    [anon_sym_ATtest] = ACTIONS(221),
    [anon_sym_ATtestWith] = ACTIONS(223),
    [anon_sym_ATtestdox] = ACTIONS(223),
    [anon_sym_ATticket] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(221),
    [anon_sym_ATreadonly] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(223),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(223),
    [anon_sym_ATparam_DASHout] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(223),
    [anon_sym_from] = ACTIONS(223),
    [anon_sym_as] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(223),
    [anon_sym_ATmixin] = ACTIONS(223),
    [anon_sym_COMMA] = ACTIONS(223),
    [anon_sym_BSLASH] = ACTIONS(186),
    [sym__end] = ACTIONS(223),
  },
  [29] = {
    [aux_sym_namespace_name_repeat1] = STATE(323),
    [anon_sym_LBRACE] = ACTIONS(191),
    [anon_sym_ATinheritdoc] = ACTIONS(191),
    [anon_sym_ATinheritDoc] = ACTIONS(191),
    [anon_sym_ATapi] = ACTIONS(191),
    [anon_sym_ATfilesource] = ACTIONS(191),
    [anon_sym_ATignore] = ACTIONS(191),
    [anon_sym_ATinternal] = ACTIONS(191),
    [anon_sym_ATcategory] = ACTIONS(191),
    [anon_sym_ATcopyright] = ACTIONS(191),
    [anon_sym_ATtodo] = ACTIONS(191),
    [anon_sym_ATexample] = ACTIONS(191),
    [anon_sym_ATlicense] = ACTIONS(191),
    [anon_sym_ATpackage] = ACTIONS(191),
    [anon_sym_ATsource] = ACTIONS(191),
    [anon_sym_ATsubpackage] = ACTIONS(191),
    [anon_sym_ATuses] = ACTIONS(191),
    [anon_sym_ATauthor] = ACTIONS(191),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_ATglobal] = ACTIONS(191),
    [anon_sym_ATlink] = ACTIONS(191),
    [anon_sym_ATmethod] = ACTIONS(191),
    [anon_sym_ATparam] = ACTIONS(189),
    [anon_sym_ATproperty] = ACTIONS(189),
    [anon_sym_ATproperty_DASHread] = ACTIONS(191),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(191),
    [anon_sym_ATreturn] = ACTIONS(191),
    [anon_sym_ATsee] = ACTIONS(191),
    [anon_sym_ATthrows] = ACTIONS(191),
    [anon_sym_ATvar] = ACTIONS(191),
    [anon_sym_ATdeprecated] = ACTIONS(191),
    [anon_sym_ATsince] = ACTIONS(191),
    [anon_sym_ATversion] = ACTIONS(191),
    [anon_sym_ATtemplate] = ACTIONS(189),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(191),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(191),
    [anon_sym_ATimplements] = ACTIONS(191),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(191),
    [anon_sym_ATextends] = ACTIONS(191),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(191),
    [anon_sym_ATuse] = ACTIONS(189),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(191),
    [anon_sym_ATafter] = ACTIONS(189),
    [anon_sym_ATafterClass] = ACTIONS(191),
    [anon_sym_ATannotation] = ACTIONS(191),
    [anon_sym_ATbackupGlobals] = ACTIONS(191),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(191),
    [anon_sym_ATbefore] = ACTIONS(189),
    [anon_sym_ATbeforeClass] = ACTIONS(191),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(189),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(191),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(191),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(191),
    [anon_sym_ATcovers] = ACTIONS(189),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(189),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(191),
    [anon_sym_ATcoversNothing] = ACTIONS(191),
    [anon_sym_ATdataProvider] = ACTIONS(191),
    [anon_sym_ATdepends] = ACTIONS(189),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(191),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(191),
    [anon_sym_ATgroup] = ACTIONS(191),
    [anon_sym_ATlarge] = ACTIONS(191),
    [anon_sym_ATmedium] = ACTIONS(191),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(191),
    [anon_sym_ATrequires] = ACTIONS(189),
    [anon_sym_ATrequiresusages] = ACTIONS(191),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(191),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(191),
    [anon_sym_ATsmall] = ACTIONS(191),
    [anon_sym_ATtest] = ACTIONS(189),
    [anon_sym_ATtestWith] = ACTIONS(191),
    [anon_sym_ATtestdox] = ACTIONS(191),
    [anon_sym_ATticket] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(189),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(189),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(189),
    [anon_sym_ATreadonly] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(191),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(191),
    [anon_sym_ATparam_DASHout] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(189),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(191),
    [anon_sym_ATmixin] = ACTIONS(191),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(191),
    [anon_sym_BSLASH] = ACTIONS(186),
    [anon_sym_PIPE] = ACTIONS(191),
    [anon_sym_AMP] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(191),
    [sym__end] = ACTIONS(191),
    [sym__text_after_type] = ACTIONS(191),
  },
  [30] = {
    [aux_sym_union_type_repeat1] = STATE(66),
    [aux_sym_intersection_type_repeat1] = STATE(50),
    [aux_sym_disjunctive_normal_form_type_repeat1] = STATE(72),
    [sym_name] = ACTIONS(282),
    [anon_sym_ATinheritdoc] = ACTIONS(287),
    [anon_sym_ATinheritDoc] = ACTIONS(287),
    [anon_sym_ATapi] = ACTIONS(287),
    [anon_sym_ATfilesource] = ACTIONS(287),
    [anon_sym_ATignore] = ACTIONS(287),
    [anon_sym_ATinternal] = ACTIONS(287),
    [anon_sym_ATcategory] = ACTIONS(287),
    [anon_sym_ATcopyright] = ACTIONS(287),
    [anon_sym_ATtodo] = ACTIONS(287),
    [anon_sym_ATexample] = ACTIONS(287),
    [anon_sym_ATlicense] = ACTIONS(287),
    [anon_sym_ATpackage] = ACTIONS(287),
    [anon_sym_ATsource] = ACTIONS(287),
    [anon_sym_ATsubpackage] = ACTIONS(287),
    [anon_sym_ATuses] = ACTIONS(287),
    [anon_sym_ATauthor] = ACTIONS(287),
    [anon_sym_ATglobal] = ACTIONS(287),
    [anon_sym_ATlink] = ACTIONS(287),
    [anon_sym_ATmethod] = ACTIONS(287),
    [anon_sym_ATparam] = ACTIONS(282),
    [anon_sym_ATproperty] = ACTIONS(282),
    [anon_sym_ATproperty_DASHread] = ACTIONS(287),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(287),
    [anon_sym_ATreturn] = ACTIONS(287),
    [anon_sym_ATsee] = ACTIONS(287),
    [anon_sym_ATthrows] = ACTIONS(287),
    [anon_sym_ATvar] = ACTIONS(287),
    [anon_sym_ATdeprecated] = ACTIONS(287),
    [anon_sym_ATsince] = ACTIONS(287),
    [anon_sym_ATversion] = ACTIONS(287),
    [anon_sym_ATtemplate] = ACTIONS(282),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(287),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(287),
    [anon_sym_of] = ACTIONS(282),
    [anon_sym_ATimplements] = ACTIONS(287),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(287),
    [anon_sym_ATextends] = ACTIONS(287),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(287),
    [anon_sym_ATuse] = ACTIONS(282),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(287),
    [anon_sym_ATafter] = ACTIONS(282),
    [anon_sym_ATafterClass] = ACTIONS(287),
    [anon_sym_ATannotation] = ACTIONS(287),
    [anon_sym_ATbackupGlobals] = ACTIONS(287),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(287),
    [anon_sym_ATbefore] = ACTIONS(282),
    [anon_sym_ATbeforeClass] = ACTIONS(287),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(282),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(287),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(287),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(287),
    [anon_sym_ATcovers] = ACTIONS(282),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(282),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(287),
    [anon_sym_ATcoversNothing] = ACTIONS(287),
    [anon_sym_ATdataProvider] = ACTIONS(287),
    [anon_sym_ATdepends] = ACTIONS(282),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(287),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(287),
    [anon_sym_ATgroup] = ACTIONS(287),
    [anon_sym_ATlarge] = ACTIONS(287),
    [anon_sym_ATmedium] = ACTIONS(287),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(287),
    [anon_sym_ATrequires] = ACTIONS(282),
    [anon_sym_ATrequiresusages] = ACTIONS(287),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(287),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(287),
    [anon_sym_ATsmall] = ACTIONS(287),
    [anon_sym_ATtest] = ACTIONS(282),
    [anon_sym_ATtestWith] = ACTIONS(287),
    [anon_sym_ATtestdox] = ACTIONS(287),
    [anon_sym_ATticket] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(282),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(282),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(282),
    [anon_sym_ATreadonly] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(287),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(287),
    [anon_sym_ATparam_DASHout] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(282),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(287),
    [anon_sym_ATmixin] = ACTIONS(287),
    [anon_sym_COMMA] = ACTIONS(287),
    [anon_sym_PIPE] = ACTIONS(292),
    [anon_sym_AMP] = ACTIONS(294),
    [anon_sym_DOLLAR] = ACTIONS(287),
    [sym__end] = ACTIONS(287),
  },
  [31] = {
    [aux_sym_namespace_name_repeat1] = STATE(323),
    [anon_sym_LBRACE] = ACTIONS(184),
    [anon_sym_ATinheritdoc] = ACTIONS(184),
    [anon_sym_ATinheritDoc] = ACTIONS(184),
    [anon_sym_ATapi] = ACTIONS(184),
    [anon_sym_ATfilesource] = ACTIONS(184),
    [anon_sym_ATignore] = ACTIONS(184),
    [anon_sym_ATinternal] = ACTIONS(184),
    [anon_sym_ATcategory] = ACTIONS(184),
    [anon_sym_ATcopyright] = ACTIONS(184),
    [anon_sym_ATtodo] = ACTIONS(184),
    [anon_sym_ATexample] = ACTIONS(184),
    [anon_sym_ATlicense] = ACTIONS(184),
    [anon_sym_ATpackage] = ACTIONS(184),
    [anon_sym_ATsource] = ACTIONS(184),
    [anon_sym_ATsubpackage] = ACTIONS(184),
    [anon_sym_ATuses] = ACTIONS(184),
    [anon_sym_ATauthor] = ACTIONS(184),
    [anon_sym_LT] = ACTIONS(184),
    [anon_sym_ATglobal] = ACTIONS(184),
    [anon_sym_ATlink] = ACTIONS(184),
    [anon_sym_ATmethod] = ACTIONS(184),
    [anon_sym_ATparam] = ACTIONS(182),
    [anon_sym_ATproperty] = ACTIONS(182),
    [anon_sym_ATproperty_DASHread] = ACTIONS(184),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(184),
    [anon_sym_ATreturn] = ACTIONS(184),
    [anon_sym_ATsee] = ACTIONS(184),
    [anon_sym_ATthrows] = ACTIONS(184),
    [anon_sym_ATvar] = ACTIONS(184),
    [anon_sym_ATdeprecated] = ACTIONS(184),
    [anon_sym_ATsince] = ACTIONS(184),
    [anon_sym_ATversion] = ACTIONS(184),
    [anon_sym_ATtemplate] = ACTIONS(182),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(184),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(184),
    [anon_sym_ATimplements] = ACTIONS(184),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(184),
    [anon_sym_ATextends] = ACTIONS(184),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(184),
    [anon_sym_ATuse] = ACTIONS(182),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(184),
    [anon_sym_ATafter] = ACTIONS(182),
    [anon_sym_ATafterClass] = ACTIONS(184),
    [anon_sym_ATannotation] = ACTIONS(184),
    [anon_sym_ATbackupGlobals] = ACTIONS(184),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(184),
    [anon_sym_ATbefore] = ACTIONS(182),
    [anon_sym_ATbeforeClass] = ACTIONS(184),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(182),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(184),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(184),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(184),
    [anon_sym_ATcovers] = ACTIONS(182),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(182),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(184),
    [anon_sym_ATcoversNothing] = ACTIONS(184),
    [anon_sym_ATdataProvider] = ACTIONS(184),
    [anon_sym_ATdepends] = ACTIONS(182),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(184),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(184),
    [anon_sym_ATgroup] = ACTIONS(184),
    [anon_sym_ATlarge] = ACTIONS(184),
    [anon_sym_ATmedium] = ACTIONS(184),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(184),
    [anon_sym_ATrequires] = ACTIONS(182),
    [anon_sym_ATrequiresusages] = ACTIONS(184),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(184),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(184),
    [anon_sym_ATsmall] = ACTIONS(184),
    [anon_sym_ATtest] = ACTIONS(182),
    [anon_sym_ATtestWith] = ACTIONS(184),
    [anon_sym_ATtestdox] = ACTIONS(184),
    [anon_sym_ATticket] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(182),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(182),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(182),
    [anon_sym_ATreadonly] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(184),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(184),
    [anon_sym_ATparam_DASHout] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(182),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(184),
    [anon_sym_ATmixin] = ACTIONS(184),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(184),
    [anon_sym_BSLASH] = ACTIONS(186),
    [anon_sym_PIPE] = ACTIONS(184),
    [anon_sym_AMP] = ACTIONS(184),
    [anon_sym_DOLLAR] = ACTIONS(184),
    [sym__end] = ACTIONS(184),
    [sym__text_after_type] = ACTIONS(184),
  },
  [32] = {
    [sym_name] = ACTIONS(296),
    [anon_sym_ATinheritdoc] = ACTIONS(298),
    [anon_sym_ATinheritDoc] = ACTIONS(298),
    [anon_sym_ATapi] = ACTIONS(298),
    [anon_sym_ATfilesource] = ACTIONS(298),
    [anon_sym_ATignore] = ACTIONS(298),
    [anon_sym_ATinternal] = ACTIONS(298),
    [anon_sym_ATcategory] = ACTIONS(298),
    [anon_sym_ATcopyright] = ACTIONS(298),
    [anon_sym_ATtodo] = ACTIONS(298),
    [anon_sym_ATexample] = ACTIONS(298),
    [anon_sym_ATlicense] = ACTIONS(298),
    [anon_sym_ATpackage] = ACTIONS(298),
    [anon_sym_ATsource] = ACTIONS(298),
    [anon_sym_ATsubpackage] = ACTIONS(298),
    [anon_sym_ATuses] = ACTIONS(298),
    [anon_sym_ATauthor] = ACTIONS(298),
    [anon_sym_GT] = ACTIONS(298),
    [anon_sym_ATglobal] = ACTIONS(298),
    [anon_sym_ATlink] = ACTIONS(298),
    [anon_sym_ATmethod] = ACTIONS(298),
    [anon_sym_ATparam] = ACTIONS(296),
    [anon_sym_ATproperty] = ACTIONS(296),
    [anon_sym_ATproperty_DASHread] = ACTIONS(298),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(298),
    [anon_sym_ATreturn] = ACTIONS(298),
    [anon_sym_ATsee] = ACTIONS(298),
    [anon_sym_ATthrows] = ACTIONS(298),
    [anon_sym_ATvar] = ACTIONS(298),
    [anon_sym_ATdeprecated] = ACTIONS(298),
    [anon_sym_ATsince] = ACTIONS(298),
    [anon_sym_ATversion] = ACTIONS(298),
    [anon_sym_ATtemplate] = ACTIONS(296),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(298),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(298),
    [anon_sym_of] = ACTIONS(296),
    [anon_sym_ATimplements] = ACTIONS(298),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(298),
    [anon_sym_ATextends] = ACTIONS(298),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(298),
    [anon_sym_ATuse] = ACTIONS(296),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(298),
    [anon_sym_ATafter] = ACTIONS(296),
    [anon_sym_ATafterClass] = ACTIONS(298),
    [anon_sym_ATannotation] = ACTIONS(298),
    [anon_sym_ATbackupGlobals] = ACTIONS(298),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(298),
    [anon_sym_ATbefore] = ACTIONS(296),
    [anon_sym_ATbeforeClass] = ACTIONS(298),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(296),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(298),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(298),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(298),
    [anon_sym_ATcovers] = ACTIONS(296),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(296),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(298),
    [anon_sym_ATcoversNothing] = ACTIONS(298),
    [anon_sym_ATdataProvider] = ACTIONS(298),
    [anon_sym_ATdepends] = ACTIONS(296),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(298),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(298),
    [anon_sym_ATgroup] = ACTIONS(298),
    [anon_sym_ATlarge] = ACTIONS(298),
    [anon_sym_ATmedium] = ACTIONS(298),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(298),
    [anon_sym_ATrequires] = ACTIONS(296),
    [anon_sym_ATrequiresusages] = ACTIONS(298),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(298),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(298),
    [anon_sym_ATsmall] = ACTIONS(298),
    [anon_sym_ATtest] = ACTIONS(296),
    [anon_sym_ATtestWith] = ACTIONS(298),
    [anon_sym_ATtestdox] = ACTIONS(298),
    [anon_sym_ATticket] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(296),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(296),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(296),
    [anon_sym_ATreadonly] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(298),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(298),
    [anon_sym_ATparam_DASHout] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(296),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(298),
    [anon_sym_ATmixin] = ACTIONS(298),
    [anon_sym_COMMA] = ACTIONS(298),
    [anon_sym_PIPE] = ACTIONS(298),
    [anon_sym_AMP] = ACTIONS(298),
    [anon_sym_RPAREN] = ACTIONS(298),
    [anon_sym_DOLLAR] = ACTIONS(298),
    [sym__end] = ACTIONS(298),
  },
  [33] = {
    [sym_name] = ACTIONS(265),
    [anon_sym_ATinheritdoc] = ACTIONS(267),
    [anon_sym_ATinheritDoc] = ACTIONS(267),
    [anon_sym_ATapi] = ACTIONS(267),
    [anon_sym_ATfilesource] = ACTIONS(267),
    [anon_sym_ATignore] = ACTIONS(267),
    [anon_sym_ATinternal] = ACTIONS(267),
    [anon_sym_ATcategory] = ACTIONS(267),
    [anon_sym_ATcopyright] = ACTIONS(267),
    [anon_sym_ATtodo] = ACTIONS(267),
    [anon_sym_ATexample] = ACTIONS(267),
    [anon_sym_ATlicense] = ACTIONS(267),
    [anon_sym_ATpackage] = ACTIONS(267),
    [anon_sym_ATsource] = ACTIONS(267),
    [anon_sym_ATsubpackage] = ACTIONS(267),
    [anon_sym_ATuses] = ACTIONS(267),
    [anon_sym_ATauthor] = ACTIONS(267),
    [anon_sym_GT] = ACTIONS(267),
    [anon_sym_ATglobal] = ACTIONS(267),
    [anon_sym_ATlink] = ACTIONS(267),
    [anon_sym_ATmethod] = ACTIONS(267),
    [anon_sym_ATparam] = ACTIONS(265),
    [anon_sym_ATproperty] = ACTIONS(265),
    [anon_sym_ATproperty_DASHread] = ACTIONS(267),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(267),
    [anon_sym_ATreturn] = ACTIONS(267),
    [anon_sym_ATsee] = ACTIONS(267),
    [anon_sym_ATthrows] = ACTIONS(267),
    [anon_sym_ATvar] = ACTIONS(267),
    [anon_sym_ATdeprecated] = ACTIONS(267),
    [anon_sym_ATsince] = ACTIONS(267),
    [anon_sym_ATversion] = ACTIONS(267),
    [anon_sym_ATtemplate] = ACTIONS(265),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(267),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(267),
    [anon_sym_of] = ACTIONS(265),
    [anon_sym_ATimplements] = ACTIONS(267),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(267),
    [anon_sym_ATextends] = ACTIONS(267),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(267),
    [anon_sym_ATuse] = ACTIONS(265),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(267),
    [anon_sym_ATafter] = ACTIONS(265),
    [anon_sym_ATafterClass] = ACTIONS(267),
    [anon_sym_ATannotation] = ACTIONS(267),
    [anon_sym_ATbackupGlobals] = ACTIONS(267),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(267),
    [anon_sym_ATbefore] = ACTIONS(265),
    [anon_sym_ATbeforeClass] = ACTIONS(267),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(265),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(267),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(267),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(267),
    [anon_sym_ATcovers] = ACTIONS(265),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(265),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(267),
    [anon_sym_ATcoversNothing] = ACTIONS(267),
    [anon_sym_ATdataProvider] = ACTIONS(267),
    [anon_sym_ATdepends] = ACTIONS(265),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(267),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(267),
    [anon_sym_ATgroup] = ACTIONS(267),
    [anon_sym_ATlarge] = ACTIONS(267),
    [anon_sym_ATmedium] = ACTIONS(267),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(267),
    [anon_sym_ATrequires] = ACTIONS(265),
    [anon_sym_ATrequiresusages] = ACTIONS(267),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(267),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(267),
    [anon_sym_ATsmall] = ACTIONS(267),
    [anon_sym_ATtest] = ACTIONS(265),
    [anon_sym_ATtestWith] = ACTIONS(267),
    [anon_sym_ATtestdox] = ACTIONS(267),
    [anon_sym_ATticket] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(265),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(265),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(265),
    [anon_sym_ATreadonly] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(267),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(267),
    [anon_sym_ATparam_DASHout] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(265),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(267),
    [anon_sym_ATmixin] = ACTIONS(267),
    [anon_sym_COMMA] = ACTIONS(267),
    [anon_sym_PIPE] = ACTIONS(267),
    [anon_sym_AMP] = ACTIONS(267),
    [anon_sym_RPAREN] = ACTIONS(267),
    [anon_sym_DOLLAR] = ACTIONS(267),
    [sym__end] = ACTIONS(267),
  },
  [34] = {
    [sym__type_argument_list] = STATE(132),
    [aux_sym_namespace_name_repeat1] = STATE(323),
    [anon_sym_LBRACE] = ACTIONS(223),
    [anon_sym_ATinheritdoc] = ACTIONS(223),
    [anon_sym_ATinheritDoc] = ACTIONS(223),
    [anon_sym_ATapi] = ACTIONS(223),
    [anon_sym_ATfilesource] = ACTIONS(223),
    [anon_sym_ATignore] = ACTIONS(223),
    [anon_sym_ATinternal] = ACTIONS(223),
    [anon_sym_ATcategory] = ACTIONS(223),
    [anon_sym_ATcopyright] = ACTIONS(223),
    [anon_sym_ATtodo] = ACTIONS(223),
    [anon_sym_ATexample] = ACTIONS(223),
    [anon_sym_ATlicense] = ACTIONS(223),
    [anon_sym_ATpackage] = ACTIONS(223),
    [anon_sym_ATsource] = ACTIONS(223),
    [anon_sym_ATsubpackage] = ACTIONS(223),
    [anon_sym_ATuses] = ACTIONS(223),
    [anon_sym_ATauthor] = ACTIONS(223),
    [anon_sym_LT] = ACTIONS(300),
    [anon_sym_ATglobal] = ACTIONS(223),
    [anon_sym_ATlink] = ACTIONS(223),
    [anon_sym_ATmethod] = ACTIONS(223),
    [anon_sym_ATparam] = ACTIONS(221),
    [anon_sym_ATproperty] = ACTIONS(221),
    [anon_sym_ATproperty_DASHread] = ACTIONS(223),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(223),
    [anon_sym_ATreturn] = ACTIONS(223),
    [anon_sym_ATsee] = ACTIONS(223),
    [anon_sym_ATthrows] = ACTIONS(223),
    [anon_sym_ATvar] = ACTIONS(223),
    [anon_sym_ATdeprecated] = ACTIONS(223),
    [anon_sym_ATsince] = ACTIONS(223),
    [anon_sym_ATversion] = ACTIONS(223),
    [anon_sym_ATtemplate] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(223),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(223),
    [anon_sym_ATimplements] = ACTIONS(223),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(223),
    [anon_sym_ATextends] = ACTIONS(223),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(223),
    [anon_sym_ATuse] = ACTIONS(221),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(223),
    [anon_sym_ATafter] = ACTIONS(221),
    [anon_sym_ATafterClass] = ACTIONS(223),
    [anon_sym_ATannotation] = ACTIONS(223),
    [anon_sym_ATbackupGlobals] = ACTIONS(223),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(223),
    [anon_sym_ATbefore] = ACTIONS(221),
    [anon_sym_ATbeforeClass] = ACTIONS(223),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(221),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(223),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(223),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(223),
    [anon_sym_ATcovers] = ACTIONS(221),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(221),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(223),
    [anon_sym_ATcoversNothing] = ACTIONS(223),
    [anon_sym_ATdataProvider] = ACTIONS(223),
    [anon_sym_ATdepends] = ACTIONS(221),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(223),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(223),
    [anon_sym_ATgroup] = ACTIONS(223),
    [anon_sym_ATlarge] = ACTIONS(223),
    [anon_sym_ATmedium] = ACTIONS(223),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(223),
    [anon_sym_ATrequires] = ACTIONS(221),
    [anon_sym_ATrequiresusages] = ACTIONS(223),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(223),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(223),
    [anon_sym_ATsmall] = ACTIONS(223),
    [anon_sym_ATtest] = ACTIONS(221),
    [anon_sym_ATtestWith] = ACTIONS(223),
    [anon_sym_ATtestdox] = ACTIONS(223),
    [anon_sym_ATticket] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(221),
    [anon_sym_ATreadonly] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(223),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(223),
    [anon_sym_ATparam_DASHout] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(223),
    [anon_sym_ATmixin] = ACTIONS(223),
    [anon_sym_BSLASH] = ACTIONS(186),
    [anon_sym_LPAREN_RPAREN] = ACTIONS(302),
    [anon_sym_COLON_COLON] = ACTIONS(223),
    [sym__end] = ACTIONS(223),
    [sym_text] = ACTIONS(223),
  },
  [35] = {
    [sym__type_argument_list] = STATE(55),
    [anon_sym_LBRACE] = ACTIONS(223),
    [anon_sym_ATinheritdoc] = ACTIONS(223),
    [anon_sym_ATinheritDoc] = ACTIONS(223),
    [anon_sym_ATapi] = ACTIONS(223),
    [anon_sym_ATfilesource] = ACTIONS(223),
    [anon_sym_ATignore] = ACTIONS(223),
    [anon_sym_ATinternal] = ACTIONS(223),
    [anon_sym_ATcategory] = ACTIONS(223),
    [anon_sym_ATcopyright] = ACTIONS(223),
    [anon_sym_ATtodo] = ACTIONS(223),
    [anon_sym_ATexample] = ACTIONS(223),
    [anon_sym_ATlicense] = ACTIONS(223),
    [anon_sym_ATpackage] = ACTIONS(223),
    [anon_sym_ATsource] = ACTIONS(223),
    [anon_sym_ATsubpackage] = ACTIONS(223),
    [anon_sym_ATuses] = ACTIONS(223),
    [anon_sym_ATauthor] = ACTIONS(223),
    [anon_sym_LT] = ACTIONS(277),
    [anon_sym_ATglobal] = ACTIONS(223),
    [anon_sym_ATlink] = ACTIONS(223),
    [anon_sym_ATmethod] = ACTIONS(223),
    [anon_sym_ATparam] = ACTIONS(221),
    [anon_sym_ATproperty] = ACTIONS(221),
    [anon_sym_ATproperty_DASHread] = ACTIONS(223),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(223),
    [anon_sym_ATreturn] = ACTIONS(223),
    [anon_sym_ATsee] = ACTIONS(223),
    [anon_sym_ATthrows] = ACTIONS(223),
    [anon_sym_ATvar] = ACTIONS(223),
    [anon_sym_ATdeprecated] = ACTIONS(223),
    [anon_sym_ATsince] = ACTIONS(223),
    [anon_sym_ATversion] = ACTIONS(223),
    [anon_sym_ATtemplate] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(223),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(223),
    [anon_sym_ATimplements] = ACTIONS(223),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(223),
    [anon_sym_ATextends] = ACTIONS(223),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(223),
    [anon_sym_ATuse] = ACTIONS(221),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(223),
    [anon_sym_ATafter] = ACTIONS(221),
    [anon_sym_ATafterClass] = ACTIONS(223),
    [anon_sym_ATannotation] = ACTIONS(223),
    [anon_sym_ATbackupGlobals] = ACTIONS(223),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(223),
    [anon_sym_ATbefore] = ACTIONS(221),
    [anon_sym_ATbeforeClass] = ACTIONS(223),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(221),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(223),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(223),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(223),
    [anon_sym_ATcovers] = ACTIONS(221),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(221),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(223),
    [anon_sym_ATcoversNothing] = ACTIONS(223),
    [anon_sym_ATdataProvider] = ACTIONS(223),
    [anon_sym_ATdepends] = ACTIONS(221),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(223),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(223),
    [anon_sym_ATgroup] = ACTIONS(223),
    [anon_sym_ATlarge] = ACTIONS(223),
    [anon_sym_ATmedium] = ACTIONS(223),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(223),
    [anon_sym_ATrequires] = ACTIONS(221),
    [anon_sym_ATrequiresusages] = ACTIONS(223),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(223),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(223),
    [anon_sym_ATsmall] = ACTIONS(223),
    [anon_sym_ATtest] = ACTIONS(221),
    [anon_sym_ATtestWith] = ACTIONS(223),
    [anon_sym_ATtestdox] = ACTIONS(223),
    [anon_sym_ATticket] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(221),
    [anon_sym_ATreadonly] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(223),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(223),
    [anon_sym_ATparam_DASHout] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(223),
    [anon_sym_ATmixin] = ACTIONS(223),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(223),
    [anon_sym_AMP] = ACTIONS(223),
    [anon_sym_DOLLAR] = ACTIONS(223),
    [sym__end] = ACTIONS(223),
    [sym__text_after_type] = ACTIONS(223),
  },
  [36] = {
    [aux_sym__phpdoc_array_types_repeat1] = STATE(62),
    [anon_sym_LBRACE] = ACTIONS(236),
    [anon_sym_ATinheritdoc] = ACTIONS(236),
    [anon_sym_ATinheritDoc] = ACTIONS(236),
    [anon_sym_ATapi] = ACTIONS(236),
    [anon_sym_ATfilesource] = ACTIONS(236),
    [anon_sym_ATignore] = ACTIONS(236),
    [anon_sym_ATinternal] = ACTIONS(236),
    [anon_sym_ATcategory] = ACTIONS(236),
    [anon_sym_ATcopyright] = ACTIONS(236),
    [anon_sym_ATtodo] = ACTIONS(236),
    [anon_sym_ATexample] = ACTIONS(236),
    [anon_sym_ATlicense] = ACTIONS(236),
    [anon_sym_ATpackage] = ACTIONS(236),
    [anon_sym_ATsource] = ACTIONS(236),
    [anon_sym_ATsubpackage] = ACTIONS(236),
    [anon_sym_ATuses] = ACTIONS(236),
    [anon_sym_ATauthor] = ACTIONS(236),
    [anon_sym_LT] = ACTIONS(304),
    [anon_sym_ATglobal] = ACTIONS(236),
    [anon_sym_ATlink] = ACTIONS(236),
    [anon_sym_ATmethod] = ACTIONS(236),
    [anon_sym_ATparam] = ACTIONS(234),
    [anon_sym_ATproperty] = ACTIONS(234),
    [anon_sym_ATproperty_DASHread] = ACTIONS(236),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(236),
    [anon_sym_ATreturn] = ACTIONS(236),
    [anon_sym_ATsee] = ACTIONS(236),
    [anon_sym_ATthrows] = ACTIONS(236),
    [anon_sym_ATvar] = ACTIONS(236),
    [anon_sym_ATdeprecated] = ACTIONS(236),
    [anon_sym_ATsince] = ACTIONS(236),
    [anon_sym_ATversion] = ACTIONS(236),
    [anon_sym_ATtemplate] = ACTIONS(234),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(236),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(236),
    [anon_sym_ATimplements] = ACTIONS(236),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(236),
    [anon_sym_ATextends] = ACTIONS(236),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(236),
    [anon_sym_ATuse] = ACTIONS(234),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(236),
    [anon_sym_ATafter] = ACTIONS(234),
    [anon_sym_ATafterClass] = ACTIONS(236),
    [anon_sym_ATannotation] = ACTIONS(236),
    [anon_sym_ATbackupGlobals] = ACTIONS(236),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(236),
    [anon_sym_ATbefore] = ACTIONS(234),
    [anon_sym_ATbeforeClass] = ACTIONS(236),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(234),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(236),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(236),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(236),
    [anon_sym_ATcovers] = ACTIONS(234),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(234),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(236),
    [anon_sym_ATcoversNothing] = ACTIONS(236),
    [anon_sym_ATdataProvider] = ACTIONS(236),
    [anon_sym_ATdepends] = ACTIONS(234),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(236),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(236),
    [anon_sym_ATgroup] = ACTIONS(236),
    [anon_sym_ATlarge] = ACTIONS(236),
    [anon_sym_ATmedium] = ACTIONS(236),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(236),
    [anon_sym_ATrequires] = ACTIONS(234),
    [anon_sym_ATrequiresusages] = ACTIONS(236),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(236),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(236),
    [anon_sym_ATsmall] = ACTIONS(236),
    [anon_sym_ATtest] = ACTIONS(234),
    [anon_sym_ATtestWith] = ACTIONS(236),
    [anon_sym_ATtestdox] = ACTIONS(236),
    [anon_sym_ATticket] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(234),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(234),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(234),
    [anon_sym_ATreadonly] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(236),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(236),
    [anon_sym_ATparam_DASHout] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(234),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(236),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(236),
    [anon_sym_ATmixin] = ACTIONS(236),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(306),
    [anon_sym_PIPE] = ACTIONS(236),
    [anon_sym_AMP] = ACTIONS(236),
    [anon_sym_DOLLAR] = ACTIONS(236),
    [sym__end] = ACTIONS(236),
    [sym__text_after_type] = ACTIONS(236),
  },
  [37] = {
    [sym_name] = ACTIONS(308),
    [anon_sym_ATinheritdoc] = ACTIONS(310),
    [anon_sym_ATinheritDoc] = ACTIONS(310),
    [anon_sym_ATapi] = ACTIONS(310),
    [anon_sym_ATfilesource] = ACTIONS(310),
    [anon_sym_ATignore] = ACTIONS(310),
    [anon_sym_ATinternal] = ACTIONS(310),
    [anon_sym_ATcategory] = ACTIONS(310),
    [anon_sym_ATcopyright] = ACTIONS(310),
    [anon_sym_ATtodo] = ACTIONS(310),
    [anon_sym_ATexample] = ACTIONS(310),
    [anon_sym_ATlicense] = ACTIONS(310),
    [anon_sym_ATpackage] = ACTIONS(310),
    [anon_sym_ATsource] = ACTIONS(310),
    [anon_sym_ATsubpackage] = ACTIONS(310),
    [anon_sym_ATuses] = ACTIONS(310),
    [anon_sym_ATauthor] = ACTIONS(310),
    [anon_sym_GT] = ACTIONS(310),
    [anon_sym_ATglobal] = ACTIONS(310),
    [anon_sym_ATlink] = ACTIONS(310),
    [anon_sym_ATmethod] = ACTIONS(310),
    [anon_sym_ATparam] = ACTIONS(308),
    [anon_sym_ATproperty] = ACTIONS(308),
    [anon_sym_ATproperty_DASHread] = ACTIONS(310),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(310),
    [anon_sym_ATreturn] = ACTIONS(310),
    [anon_sym_ATsee] = ACTIONS(310),
    [anon_sym_ATthrows] = ACTIONS(310),
    [anon_sym_ATvar] = ACTIONS(310),
    [anon_sym_ATdeprecated] = ACTIONS(310),
    [anon_sym_ATsince] = ACTIONS(310),
    [anon_sym_ATversion] = ACTIONS(310),
    [anon_sym_ATtemplate] = ACTIONS(308),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(310),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(310),
    [anon_sym_of] = ACTIONS(308),
    [anon_sym_ATimplements] = ACTIONS(310),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(310),
    [anon_sym_ATextends] = ACTIONS(310),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(310),
    [anon_sym_ATuse] = ACTIONS(308),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(310),
    [anon_sym_ATafter] = ACTIONS(308),
    [anon_sym_ATafterClass] = ACTIONS(310),
    [anon_sym_ATannotation] = ACTIONS(310),
    [anon_sym_ATbackupGlobals] = ACTIONS(310),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(310),
    [anon_sym_ATbefore] = ACTIONS(308),
    [anon_sym_ATbeforeClass] = ACTIONS(310),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(308),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(310),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(310),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(310),
    [anon_sym_ATcovers] = ACTIONS(308),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(308),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(310),
    [anon_sym_ATcoversNothing] = ACTIONS(310),
    [anon_sym_ATdataProvider] = ACTIONS(310),
    [anon_sym_ATdepends] = ACTIONS(308),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(310),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(310),
    [anon_sym_ATgroup] = ACTIONS(310),
    [anon_sym_ATlarge] = ACTIONS(310),
    [anon_sym_ATmedium] = ACTIONS(310),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(310),
    [anon_sym_ATrequires] = ACTIONS(308),
    [anon_sym_ATrequiresusages] = ACTIONS(310),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(310),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(310),
    [anon_sym_ATsmall] = ACTIONS(310),
    [anon_sym_ATtest] = ACTIONS(308),
    [anon_sym_ATtestWith] = ACTIONS(310),
    [anon_sym_ATtestdox] = ACTIONS(310),
    [anon_sym_ATticket] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(308),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(308),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(308),
    [anon_sym_ATreadonly] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(310),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(310),
    [anon_sym_ATparam_DASHout] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(308),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(310),
    [anon_sym_ATmixin] = ACTIONS(310),
    [anon_sym_COMMA] = ACTIONS(310),
    [anon_sym_PIPE] = ACTIONS(310),
    [anon_sym_AMP] = ACTIONS(310),
    [anon_sym_RPAREN] = ACTIONS(310),
    [anon_sym_DOLLAR] = ACTIONS(310),
    [sym__end] = ACTIONS(310),
  },
  [38] = {
    [aux_sym_union_type_repeat1] = STATE(92),
    [aux_sym_intersection_type_repeat1] = STATE(93),
    [aux_sym_disjunctive_normal_form_type_repeat1] = STATE(94),
    [anon_sym_LBRACE] = ACTIONS(287),
    [anon_sym_ATinheritdoc] = ACTIONS(287),
    [anon_sym_ATinheritDoc] = ACTIONS(287),
    [anon_sym_ATapi] = ACTIONS(287),
    [anon_sym_ATfilesource] = ACTIONS(287),
    [anon_sym_ATignore] = ACTIONS(287),
    [anon_sym_ATinternal] = ACTIONS(287),
    [anon_sym_ATcategory] = ACTIONS(287),
    [anon_sym_ATcopyright] = ACTIONS(287),
    [anon_sym_ATtodo] = ACTIONS(287),
    [anon_sym_ATexample] = ACTIONS(287),
    [anon_sym_ATlicense] = ACTIONS(287),
    [anon_sym_ATpackage] = ACTIONS(287),
    [anon_sym_ATsource] = ACTIONS(287),
    [anon_sym_ATsubpackage] = ACTIONS(287),
    [anon_sym_ATuses] = ACTIONS(287),
    [anon_sym_ATauthor] = ACTIONS(287),
    [anon_sym_ATglobal] = ACTIONS(287),
    [anon_sym_ATlink] = ACTIONS(287),
    [anon_sym_ATmethod] = ACTIONS(287),
    [anon_sym_ATparam] = ACTIONS(282),
    [anon_sym_ATproperty] = ACTIONS(282),
    [anon_sym_ATproperty_DASHread] = ACTIONS(287),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(287),
    [anon_sym_ATreturn] = ACTIONS(287),
    [anon_sym_ATsee] = ACTIONS(287),
    [anon_sym_ATthrows] = ACTIONS(287),
    [anon_sym_ATvar] = ACTIONS(287),
    [anon_sym_ATdeprecated] = ACTIONS(287),
    [anon_sym_ATsince] = ACTIONS(287),
    [anon_sym_ATversion] = ACTIONS(287),
    [anon_sym_ATtemplate] = ACTIONS(282),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(287),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(287),
    [anon_sym_ATimplements] = ACTIONS(287),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(287),
    [anon_sym_ATextends] = ACTIONS(287),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(287),
    [anon_sym_ATuse] = ACTIONS(282),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(287),
    [anon_sym_ATafter] = ACTIONS(282),
    [anon_sym_ATafterClass] = ACTIONS(287),
    [anon_sym_ATannotation] = ACTIONS(287),
    [anon_sym_ATbackupGlobals] = ACTIONS(287),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(287),
    [anon_sym_ATbefore] = ACTIONS(282),
    [anon_sym_ATbeforeClass] = ACTIONS(287),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(282),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(287),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(287),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(287),
    [anon_sym_ATcovers] = ACTIONS(282),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(282),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(287),
    [anon_sym_ATcoversNothing] = ACTIONS(287),
    [anon_sym_ATdataProvider] = ACTIONS(287),
    [anon_sym_ATdepends] = ACTIONS(282),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(287),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(287),
    [anon_sym_ATgroup] = ACTIONS(287),
    [anon_sym_ATlarge] = ACTIONS(287),
    [anon_sym_ATmedium] = ACTIONS(287),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(287),
    [anon_sym_ATrequires] = ACTIONS(282),
    [anon_sym_ATrequiresusages] = ACTIONS(287),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(287),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(287),
    [anon_sym_ATsmall] = ACTIONS(287),
    [anon_sym_ATtest] = ACTIONS(282),
    [anon_sym_ATtestWith] = ACTIONS(287),
    [anon_sym_ATtestdox] = ACTIONS(287),
    [anon_sym_ATticket] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(282),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(282),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(282),
    [anon_sym_ATreadonly] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(287),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(287),
    [anon_sym_ATparam_DASHout] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(282),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(287),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(287),
    [anon_sym_ATmixin] = ACTIONS(287),
    [anon_sym_PIPE] = ACTIONS(312),
    [anon_sym_AMP] = ACTIONS(314),
    [anon_sym_DOLLAR] = ACTIONS(287),
    [sym__end] = ACTIONS(287),
    [sym__text_after_type] = ACTIONS(287),
  },
  [39] = {
    [sym_name] = ACTIONS(316),
    [anon_sym_ATinheritdoc] = ACTIONS(318),
    [anon_sym_ATinheritDoc] = ACTIONS(318),
    [anon_sym_ATapi] = ACTIONS(318),
    [anon_sym_ATfilesource] = ACTIONS(318),
    [anon_sym_ATignore] = ACTIONS(318),
    [anon_sym_ATinternal] = ACTIONS(318),
    [anon_sym_ATcategory] = ACTIONS(318),
    [anon_sym_ATcopyright] = ACTIONS(318),
    [anon_sym_ATtodo] = ACTIONS(318),
    [anon_sym_ATexample] = ACTIONS(318),
    [anon_sym_ATlicense] = ACTIONS(318),
    [anon_sym_ATpackage] = ACTIONS(318),
    [anon_sym_ATsource] = ACTIONS(318),
    [anon_sym_ATsubpackage] = ACTIONS(318),
    [anon_sym_ATuses] = ACTIONS(318),
    [anon_sym_ATauthor] = ACTIONS(318),
    [anon_sym_GT] = ACTIONS(318),
    [anon_sym_ATglobal] = ACTIONS(318),
    [anon_sym_ATlink] = ACTIONS(318),
    [anon_sym_ATmethod] = ACTIONS(318),
    [anon_sym_ATparam] = ACTIONS(316),
    [anon_sym_ATproperty] = ACTIONS(316),
    [anon_sym_ATproperty_DASHread] = ACTIONS(318),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(318),
    [anon_sym_ATreturn] = ACTIONS(318),
    [anon_sym_ATsee] = ACTIONS(318),
    [anon_sym_ATthrows] = ACTIONS(318),
    [anon_sym_ATvar] = ACTIONS(318),
    [anon_sym_ATdeprecated] = ACTIONS(318),
    [anon_sym_ATsince] = ACTIONS(318),
    [anon_sym_ATversion] = ACTIONS(318),
    [anon_sym_ATtemplate] = ACTIONS(316),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(318),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(318),
    [anon_sym_of] = ACTIONS(316),
    [anon_sym_ATimplements] = ACTIONS(318),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(318),
    [anon_sym_ATextends] = ACTIONS(318),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(318),
    [anon_sym_ATuse] = ACTIONS(316),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(318),
    [anon_sym_ATafter] = ACTIONS(316),
    [anon_sym_ATafterClass] = ACTIONS(318),
    [anon_sym_ATannotation] = ACTIONS(318),
    [anon_sym_ATbackupGlobals] = ACTIONS(318),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(318),
    [anon_sym_ATbefore] = ACTIONS(316),
    [anon_sym_ATbeforeClass] = ACTIONS(318),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(316),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(318),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(318),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(318),
    [anon_sym_ATcovers] = ACTIONS(316),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(316),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(318),
    [anon_sym_ATcoversNothing] = ACTIONS(318),
    [anon_sym_ATdataProvider] = ACTIONS(318),
    [anon_sym_ATdepends] = ACTIONS(316),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(318),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(318),
    [anon_sym_ATgroup] = ACTIONS(318),
    [anon_sym_ATlarge] = ACTIONS(318),
    [anon_sym_ATmedium] = ACTIONS(318),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(318),
    [anon_sym_ATrequires] = ACTIONS(316),
    [anon_sym_ATrequiresusages] = ACTIONS(318),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(318),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(318),
    [anon_sym_ATsmall] = ACTIONS(318),
    [anon_sym_ATtest] = ACTIONS(316),
    [anon_sym_ATtestWith] = ACTIONS(318),
    [anon_sym_ATtestdox] = ACTIONS(318),
    [anon_sym_ATticket] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(316),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(316),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(316),
    [anon_sym_ATreadonly] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(318),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(318),
    [anon_sym_ATparam_DASHout] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(316),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(318),
    [anon_sym_ATmixin] = ACTIONS(318),
    [anon_sym_COMMA] = ACTIONS(318),
    [anon_sym_PIPE] = ACTIONS(318),
    [anon_sym_AMP] = ACTIONS(318),
    [anon_sym_RPAREN] = ACTIONS(318),
    [anon_sym_DOLLAR] = ACTIONS(318),
    [sym__end] = ACTIONS(318),
  },
  [40] = {
    [sym_name] = ACTIONS(320),
    [anon_sym_ATinheritdoc] = ACTIONS(322),
    [anon_sym_ATinheritDoc] = ACTIONS(322),
    [anon_sym_ATapi] = ACTIONS(322),
    [anon_sym_ATfilesource] = ACTIONS(322),
    [anon_sym_ATignore] = ACTIONS(322),
    [anon_sym_ATinternal] = ACTIONS(322),
    [anon_sym_ATcategory] = ACTIONS(322),
    [anon_sym_ATcopyright] = ACTIONS(322),
    [anon_sym_ATtodo] = ACTIONS(322),
    [anon_sym_ATexample] = ACTIONS(322),
    [anon_sym_ATlicense] = ACTIONS(322),
    [anon_sym_ATpackage] = ACTIONS(322),
    [anon_sym_ATsource] = ACTIONS(322),
    [anon_sym_ATsubpackage] = ACTIONS(322),
    [anon_sym_ATuses] = ACTIONS(322),
    [anon_sym_ATauthor] = ACTIONS(322),
    [anon_sym_GT] = ACTIONS(322),
    [anon_sym_ATglobal] = ACTIONS(322),
    [anon_sym_ATlink] = ACTIONS(322),
    [anon_sym_ATmethod] = ACTIONS(322),
    [anon_sym_ATparam] = ACTIONS(320),
    [anon_sym_ATproperty] = ACTIONS(320),
    [anon_sym_ATproperty_DASHread] = ACTIONS(322),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(322),
    [anon_sym_ATreturn] = ACTIONS(322),
    [anon_sym_ATsee] = ACTIONS(322),
    [anon_sym_ATthrows] = ACTIONS(322),
    [anon_sym_ATvar] = ACTIONS(322),
    [anon_sym_ATdeprecated] = ACTIONS(322),
    [anon_sym_ATsince] = ACTIONS(322),
    [anon_sym_ATversion] = ACTIONS(322),
    [anon_sym_ATtemplate] = ACTIONS(320),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(322),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(322),
    [anon_sym_of] = ACTIONS(320),
    [anon_sym_ATimplements] = ACTIONS(322),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(322),
    [anon_sym_ATextends] = ACTIONS(322),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(322),
    [anon_sym_ATuse] = ACTIONS(320),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(322),
    [anon_sym_ATafter] = ACTIONS(320),
    [anon_sym_ATafterClass] = ACTIONS(322),
    [anon_sym_ATannotation] = ACTIONS(322),
    [anon_sym_ATbackupGlobals] = ACTIONS(322),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(322),
    [anon_sym_ATbefore] = ACTIONS(320),
    [anon_sym_ATbeforeClass] = ACTIONS(322),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(320),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(322),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(322),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(322),
    [anon_sym_ATcovers] = ACTIONS(320),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(320),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(322),
    [anon_sym_ATcoversNothing] = ACTIONS(322),
    [anon_sym_ATdataProvider] = ACTIONS(322),
    [anon_sym_ATdepends] = ACTIONS(320),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(322),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(322),
    [anon_sym_ATgroup] = ACTIONS(322),
    [anon_sym_ATlarge] = ACTIONS(322),
    [anon_sym_ATmedium] = ACTIONS(322),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(322),
    [anon_sym_ATrequires] = ACTIONS(320),
    [anon_sym_ATrequiresusages] = ACTIONS(322),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(322),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(322),
    [anon_sym_ATsmall] = ACTIONS(322),
    [anon_sym_ATtest] = ACTIONS(320),
    [anon_sym_ATtestWith] = ACTIONS(322),
    [anon_sym_ATtestdox] = ACTIONS(322),
    [anon_sym_ATticket] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(320),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(320),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(320),
    [anon_sym_ATreadonly] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(322),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(322),
    [anon_sym_ATparam_DASHout] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(320),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(322),
    [anon_sym_ATmixin] = ACTIONS(322),
    [anon_sym_COMMA] = ACTIONS(322),
    [anon_sym_PIPE] = ACTIONS(322),
    [anon_sym_AMP] = ACTIONS(322),
    [anon_sym_RPAREN] = ACTIONS(322),
    [anon_sym_DOLLAR] = ACTIONS(322),
    [sym__end] = ACTIONS(322),
  },
  [41] = {
    [sym_name] = ACTIONS(324),
    [anon_sym_ATinheritdoc] = ACTIONS(326),
    [anon_sym_ATinheritDoc] = ACTIONS(326),
    [anon_sym_ATapi] = ACTIONS(326),
    [anon_sym_ATfilesource] = ACTIONS(326),
    [anon_sym_ATignore] = ACTIONS(326),
    [anon_sym_ATinternal] = ACTIONS(326),
    [anon_sym_ATcategory] = ACTIONS(326),
    [anon_sym_ATcopyright] = ACTIONS(326),
    [anon_sym_ATtodo] = ACTIONS(326),
    [anon_sym_ATexample] = ACTIONS(326),
    [anon_sym_ATlicense] = ACTIONS(326),
    [anon_sym_ATpackage] = ACTIONS(326),
    [anon_sym_ATsource] = ACTIONS(326),
    [anon_sym_ATsubpackage] = ACTIONS(326),
    [anon_sym_ATuses] = ACTIONS(326),
    [anon_sym_ATauthor] = ACTIONS(326),
    [anon_sym_GT] = ACTIONS(326),
    [anon_sym_ATglobal] = ACTIONS(326),
    [anon_sym_ATlink] = ACTIONS(326),
    [anon_sym_ATmethod] = ACTIONS(326),
    [anon_sym_ATparam] = ACTIONS(324),
    [anon_sym_ATproperty] = ACTIONS(324),
    [anon_sym_ATproperty_DASHread] = ACTIONS(326),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(326),
    [anon_sym_ATreturn] = ACTIONS(326),
    [anon_sym_ATsee] = ACTIONS(326),
    [anon_sym_ATthrows] = ACTIONS(326),
    [anon_sym_ATvar] = ACTIONS(326),
    [anon_sym_ATdeprecated] = ACTIONS(326),
    [anon_sym_ATsince] = ACTIONS(326),
    [anon_sym_ATversion] = ACTIONS(326),
    [anon_sym_ATtemplate] = ACTIONS(324),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(326),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(326),
    [anon_sym_of] = ACTIONS(324),
    [anon_sym_ATimplements] = ACTIONS(326),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(326),
    [anon_sym_ATextends] = ACTIONS(326),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(326),
    [anon_sym_ATuse] = ACTIONS(324),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(326),
    [anon_sym_ATafter] = ACTIONS(324),
    [anon_sym_ATafterClass] = ACTIONS(326),
    [anon_sym_ATannotation] = ACTIONS(326),
    [anon_sym_ATbackupGlobals] = ACTIONS(326),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(326),
    [anon_sym_ATbefore] = ACTIONS(324),
    [anon_sym_ATbeforeClass] = ACTIONS(326),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(324),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(326),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(326),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(326),
    [anon_sym_ATcovers] = ACTIONS(324),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(324),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(326),
    [anon_sym_ATcoversNothing] = ACTIONS(326),
    [anon_sym_ATdataProvider] = ACTIONS(326),
    [anon_sym_ATdepends] = ACTIONS(324),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(326),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(326),
    [anon_sym_ATgroup] = ACTIONS(326),
    [anon_sym_ATlarge] = ACTIONS(326),
    [anon_sym_ATmedium] = ACTIONS(326),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(326),
    [anon_sym_ATrequires] = ACTIONS(324),
    [anon_sym_ATrequiresusages] = ACTIONS(326),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(326),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(326),
    [anon_sym_ATsmall] = ACTIONS(326),
    [anon_sym_ATtest] = ACTIONS(324),
    [anon_sym_ATtestWith] = ACTIONS(326),
    [anon_sym_ATtestdox] = ACTIONS(326),
    [anon_sym_ATticket] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(324),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(324),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(324),
    [anon_sym_ATreadonly] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(326),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(326),
    [anon_sym_ATparam_DASHout] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(324),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(326),
    [anon_sym_ATmixin] = ACTIONS(326),
    [anon_sym_COMMA] = ACTIONS(326),
    [anon_sym_PIPE] = ACTIONS(326),
    [anon_sym_AMP] = ACTIONS(326),
    [anon_sym_RPAREN] = ACTIONS(326),
    [anon_sym_DOLLAR] = ACTIONS(326),
    [sym__end] = ACTIONS(326),
  },
  [42] = {
    [sym_name] = ACTIONS(328),
    [anon_sym_ATinheritdoc] = ACTIONS(330),
    [anon_sym_ATinheritDoc] = ACTIONS(330),
    [anon_sym_ATapi] = ACTIONS(330),
    [anon_sym_ATfilesource] = ACTIONS(330),
    [anon_sym_ATignore] = ACTIONS(330),
    [anon_sym_ATinternal] = ACTIONS(330),
    [anon_sym_ATcategory] = ACTIONS(330),
    [anon_sym_ATcopyright] = ACTIONS(330),
    [anon_sym_ATtodo] = ACTIONS(330),
    [anon_sym_ATexample] = ACTIONS(330),
    [anon_sym_ATlicense] = ACTIONS(330),
    [anon_sym_ATpackage] = ACTIONS(330),
    [anon_sym_ATsource] = ACTIONS(330),
    [anon_sym_ATsubpackage] = ACTIONS(330),
    [anon_sym_ATuses] = ACTIONS(330),
    [anon_sym_ATauthor] = ACTIONS(330),
    [anon_sym_GT] = ACTIONS(330),
    [anon_sym_ATglobal] = ACTIONS(330),
    [anon_sym_ATlink] = ACTIONS(330),
    [anon_sym_ATmethod] = ACTIONS(330),
    [anon_sym_ATparam] = ACTIONS(328),
    [anon_sym_ATproperty] = ACTIONS(328),
    [anon_sym_ATproperty_DASHread] = ACTIONS(330),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(330),
    [anon_sym_ATreturn] = ACTIONS(330),
    [anon_sym_ATsee] = ACTIONS(330),
    [anon_sym_ATthrows] = ACTIONS(330),
    [anon_sym_ATvar] = ACTIONS(330),
    [anon_sym_ATdeprecated] = ACTIONS(330),
    [anon_sym_ATsince] = ACTIONS(330),
    [anon_sym_ATversion] = ACTIONS(330),
    [anon_sym_ATtemplate] = ACTIONS(328),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(330),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(330),
    [anon_sym_of] = ACTIONS(328),
    [anon_sym_ATimplements] = ACTIONS(330),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(330),
    [anon_sym_ATextends] = ACTIONS(330),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(330),
    [anon_sym_ATuse] = ACTIONS(328),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(330),
    [anon_sym_ATafter] = ACTIONS(328),
    [anon_sym_ATafterClass] = ACTIONS(330),
    [anon_sym_ATannotation] = ACTIONS(330),
    [anon_sym_ATbackupGlobals] = ACTIONS(330),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(330),
    [anon_sym_ATbefore] = ACTIONS(328),
    [anon_sym_ATbeforeClass] = ACTIONS(330),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(328),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(330),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(330),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(330),
    [anon_sym_ATcovers] = ACTIONS(328),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(328),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(330),
    [anon_sym_ATcoversNothing] = ACTIONS(330),
    [anon_sym_ATdataProvider] = ACTIONS(330),
    [anon_sym_ATdepends] = ACTIONS(328),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(330),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(330),
    [anon_sym_ATgroup] = ACTIONS(330),
    [anon_sym_ATlarge] = ACTIONS(330),
    [anon_sym_ATmedium] = ACTIONS(330),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(330),
    [anon_sym_ATrequires] = ACTIONS(328),
    [anon_sym_ATrequiresusages] = ACTIONS(330),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(330),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(330),
    [anon_sym_ATsmall] = ACTIONS(330),
    [anon_sym_ATtest] = ACTIONS(328),
    [anon_sym_ATtestWith] = ACTIONS(330),
    [anon_sym_ATtestdox] = ACTIONS(330),
    [anon_sym_ATticket] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(328),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(328),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(328),
    [anon_sym_ATreadonly] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(330),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(330),
    [anon_sym_ATparam_DASHout] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(328),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(330),
    [anon_sym_ATmixin] = ACTIONS(330),
    [anon_sym_COMMA] = ACTIONS(330),
    [anon_sym_PIPE] = ACTIONS(330),
    [anon_sym_AMP] = ACTIONS(330),
    [anon_sym_RPAREN] = ACTIONS(330),
    [anon_sym_DOLLAR] = ACTIONS(330),
    [sym__end] = ACTIONS(330),
  },
  [43] = {
    [sym_name] = ACTIONS(332),
    [anon_sym_ATinheritdoc] = ACTIONS(334),
    [anon_sym_ATinheritDoc] = ACTIONS(334),
    [anon_sym_ATapi] = ACTIONS(334),
    [anon_sym_ATfilesource] = ACTIONS(334),
    [anon_sym_ATignore] = ACTIONS(334),
    [anon_sym_ATinternal] = ACTIONS(334),
    [anon_sym_ATcategory] = ACTIONS(334),
    [anon_sym_ATcopyright] = ACTIONS(334),
    [anon_sym_ATtodo] = ACTIONS(334),
    [anon_sym_ATexample] = ACTIONS(334),
    [anon_sym_ATlicense] = ACTIONS(334),
    [anon_sym_ATpackage] = ACTIONS(334),
    [anon_sym_ATsource] = ACTIONS(334),
    [anon_sym_ATsubpackage] = ACTIONS(334),
    [anon_sym_ATuses] = ACTIONS(334),
    [anon_sym_ATauthor] = ACTIONS(334),
    [anon_sym_GT] = ACTIONS(334),
    [anon_sym_ATglobal] = ACTIONS(334),
    [anon_sym_ATlink] = ACTIONS(334),
    [anon_sym_ATmethod] = ACTIONS(334),
    [anon_sym_ATparam] = ACTIONS(332),
    [anon_sym_ATproperty] = ACTIONS(332),
    [anon_sym_ATproperty_DASHread] = ACTIONS(334),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(334),
    [anon_sym_ATreturn] = ACTIONS(334),
    [anon_sym_ATsee] = ACTIONS(334),
    [anon_sym_ATthrows] = ACTIONS(334),
    [anon_sym_ATvar] = ACTIONS(334),
    [anon_sym_ATdeprecated] = ACTIONS(334),
    [anon_sym_ATsince] = ACTIONS(334),
    [anon_sym_ATversion] = ACTIONS(334),
    [anon_sym_ATtemplate] = ACTIONS(332),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(334),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(334),
    [anon_sym_of] = ACTIONS(332),
    [anon_sym_ATimplements] = ACTIONS(334),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(334),
    [anon_sym_ATextends] = ACTIONS(334),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(334),
    [anon_sym_ATuse] = ACTIONS(332),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(334),
    [anon_sym_ATafter] = ACTIONS(332),
    [anon_sym_ATafterClass] = ACTIONS(334),
    [anon_sym_ATannotation] = ACTIONS(334),
    [anon_sym_ATbackupGlobals] = ACTIONS(334),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(334),
    [anon_sym_ATbefore] = ACTIONS(332),
    [anon_sym_ATbeforeClass] = ACTIONS(334),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(332),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(334),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(334),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(334),
    [anon_sym_ATcovers] = ACTIONS(332),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(332),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(334),
    [anon_sym_ATcoversNothing] = ACTIONS(334),
    [anon_sym_ATdataProvider] = ACTIONS(334),
    [anon_sym_ATdepends] = ACTIONS(332),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(334),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(334),
    [anon_sym_ATgroup] = ACTIONS(334),
    [anon_sym_ATlarge] = ACTIONS(334),
    [anon_sym_ATmedium] = ACTIONS(334),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(334),
    [anon_sym_ATrequires] = ACTIONS(332),
    [anon_sym_ATrequiresusages] = ACTIONS(334),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(334),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(334),
    [anon_sym_ATsmall] = ACTIONS(334),
    [anon_sym_ATtest] = ACTIONS(332),
    [anon_sym_ATtestWith] = ACTIONS(334),
    [anon_sym_ATtestdox] = ACTIONS(334),
    [anon_sym_ATticket] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(332),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(332),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(332),
    [anon_sym_ATreadonly] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(334),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(334),
    [anon_sym_ATparam_DASHout] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(332),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(334),
    [anon_sym_ATmixin] = ACTIONS(334),
    [anon_sym_COMMA] = ACTIONS(334),
    [anon_sym_PIPE] = ACTIONS(334),
    [anon_sym_AMP] = ACTIONS(334),
    [anon_sym_RPAREN] = ACTIONS(334),
    [anon_sym_DOLLAR] = ACTIONS(334),
    [sym__end] = ACTIONS(334),
  },
  [44] = {
    [sym_name] = ACTIONS(336),
    [anon_sym_ATinheritdoc] = ACTIONS(338),
    [anon_sym_ATinheritDoc] = ACTIONS(338),
    [anon_sym_ATapi] = ACTIONS(338),
    [anon_sym_ATfilesource] = ACTIONS(338),
    [anon_sym_ATignore] = ACTIONS(338),
    [anon_sym_ATinternal] = ACTIONS(338),
    [anon_sym_ATcategory] = ACTIONS(338),
    [anon_sym_ATcopyright] = ACTIONS(338),
    [anon_sym_ATtodo] = ACTIONS(338),
    [anon_sym_ATexample] = ACTIONS(338),
    [anon_sym_ATlicense] = ACTIONS(338),
    [anon_sym_ATpackage] = ACTIONS(338),
    [anon_sym_ATsource] = ACTIONS(338),
    [anon_sym_ATsubpackage] = ACTIONS(338),
    [anon_sym_ATuses] = ACTIONS(338),
    [anon_sym_ATauthor] = ACTIONS(338),
    [anon_sym_GT] = ACTIONS(338),
    [anon_sym_ATglobal] = ACTIONS(338),
    [anon_sym_ATlink] = ACTIONS(338),
    [anon_sym_ATmethod] = ACTIONS(338),
    [anon_sym_ATparam] = ACTIONS(336),
    [anon_sym_ATproperty] = ACTIONS(336),
    [anon_sym_ATproperty_DASHread] = ACTIONS(338),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(338),
    [anon_sym_ATreturn] = ACTIONS(338),
    [anon_sym_ATsee] = ACTIONS(338),
    [anon_sym_ATthrows] = ACTIONS(338),
    [anon_sym_ATvar] = ACTIONS(338),
    [anon_sym_ATdeprecated] = ACTIONS(338),
    [anon_sym_ATsince] = ACTIONS(338),
    [anon_sym_ATversion] = ACTIONS(338),
    [anon_sym_ATtemplate] = ACTIONS(336),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(338),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(338),
    [anon_sym_of] = ACTIONS(336),
    [anon_sym_ATimplements] = ACTIONS(338),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(338),
    [anon_sym_ATextends] = ACTIONS(338),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(338),
    [anon_sym_ATuse] = ACTIONS(336),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(338),
    [anon_sym_ATafter] = ACTIONS(336),
    [anon_sym_ATafterClass] = ACTIONS(338),
    [anon_sym_ATannotation] = ACTIONS(338),
    [anon_sym_ATbackupGlobals] = ACTIONS(338),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(338),
    [anon_sym_ATbefore] = ACTIONS(336),
    [anon_sym_ATbeforeClass] = ACTIONS(338),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(336),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(338),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(338),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(338),
    [anon_sym_ATcovers] = ACTIONS(336),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(336),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(338),
    [anon_sym_ATcoversNothing] = ACTIONS(338),
    [anon_sym_ATdataProvider] = ACTIONS(338),
    [anon_sym_ATdepends] = ACTIONS(336),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(338),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(338),
    [anon_sym_ATgroup] = ACTIONS(338),
    [anon_sym_ATlarge] = ACTIONS(338),
    [anon_sym_ATmedium] = ACTIONS(338),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(338),
    [anon_sym_ATrequires] = ACTIONS(336),
    [anon_sym_ATrequiresusages] = ACTIONS(338),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(338),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(338),
    [anon_sym_ATsmall] = ACTIONS(338),
    [anon_sym_ATtest] = ACTIONS(336),
    [anon_sym_ATtestWith] = ACTIONS(338),
    [anon_sym_ATtestdox] = ACTIONS(338),
    [anon_sym_ATticket] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(336),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(336),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(336),
    [anon_sym_ATreadonly] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(338),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(338),
    [anon_sym_ATparam_DASHout] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(336),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(338),
    [anon_sym_ATmixin] = ACTIONS(338),
    [anon_sym_COMMA] = ACTIONS(338),
    [anon_sym_PIPE] = ACTIONS(338),
    [anon_sym_AMP] = ACTIONS(338),
    [anon_sym_RPAREN] = ACTIONS(338),
    [anon_sym_DOLLAR] = ACTIONS(338),
    [sym__end] = ACTIONS(338),
  },
  [45] = {
    [sym_name] = ACTIONS(340),
    [anon_sym_ATinheritdoc] = ACTIONS(342),
    [anon_sym_ATinheritDoc] = ACTIONS(342),
    [anon_sym_ATapi] = ACTIONS(342),
    [anon_sym_ATfilesource] = ACTIONS(342),
    [anon_sym_ATignore] = ACTIONS(342),
    [anon_sym_ATinternal] = ACTIONS(342),
    [anon_sym_ATcategory] = ACTIONS(342),
    [anon_sym_ATcopyright] = ACTIONS(342),
    [anon_sym_ATtodo] = ACTIONS(342),
    [anon_sym_ATexample] = ACTIONS(342),
    [anon_sym_ATlicense] = ACTIONS(342),
    [anon_sym_ATpackage] = ACTIONS(342),
    [anon_sym_ATsource] = ACTIONS(342),
    [anon_sym_ATsubpackage] = ACTIONS(342),
    [anon_sym_ATuses] = ACTIONS(342),
    [anon_sym_ATauthor] = ACTIONS(342),
    [anon_sym_GT] = ACTIONS(342),
    [anon_sym_ATglobal] = ACTIONS(342),
    [anon_sym_ATlink] = ACTIONS(342),
    [anon_sym_ATmethod] = ACTIONS(342),
    [anon_sym_ATparam] = ACTIONS(340),
    [anon_sym_ATproperty] = ACTIONS(340),
    [anon_sym_ATproperty_DASHread] = ACTIONS(342),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(342),
    [anon_sym_ATreturn] = ACTIONS(342),
    [anon_sym_ATsee] = ACTIONS(342),
    [anon_sym_ATthrows] = ACTIONS(342),
    [anon_sym_ATvar] = ACTIONS(342),
    [anon_sym_ATdeprecated] = ACTIONS(342),
    [anon_sym_ATsince] = ACTIONS(342),
    [anon_sym_ATversion] = ACTIONS(342),
    [anon_sym_ATtemplate] = ACTIONS(340),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(342),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(342),
    [anon_sym_of] = ACTIONS(340),
    [anon_sym_ATimplements] = ACTIONS(342),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(342),
    [anon_sym_ATextends] = ACTIONS(342),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(342),
    [anon_sym_ATuse] = ACTIONS(340),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(342),
    [anon_sym_ATafter] = ACTIONS(340),
    [anon_sym_ATafterClass] = ACTIONS(342),
    [anon_sym_ATannotation] = ACTIONS(342),
    [anon_sym_ATbackupGlobals] = ACTIONS(342),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(342),
    [anon_sym_ATbefore] = ACTIONS(340),
    [anon_sym_ATbeforeClass] = ACTIONS(342),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(340),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(342),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(342),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(342),
    [anon_sym_ATcovers] = ACTIONS(340),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(340),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(342),
    [anon_sym_ATcoversNothing] = ACTIONS(342),
    [anon_sym_ATdataProvider] = ACTIONS(342),
    [anon_sym_ATdepends] = ACTIONS(340),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(342),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(342),
    [anon_sym_ATgroup] = ACTIONS(342),
    [anon_sym_ATlarge] = ACTIONS(342),
    [anon_sym_ATmedium] = ACTIONS(342),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(342),
    [anon_sym_ATrequires] = ACTIONS(340),
    [anon_sym_ATrequiresusages] = ACTIONS(342),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(342),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(342),
    [anon_sym_ATsmall] = ACTIONS(342),
    [anon_sym_ATtest] = ACTIONS(340),
    [anon_sym_ATtestWith] = ACTIONS(342),
    [anon_sym_ATtestdox] = ACTIONS(342),
    [anon_sym_ATticket] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(340),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(340),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(340),
    [anon_sym_ATreadonly] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(342),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(342),
    [anon_sym_ATparam_DASHout] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(340),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(342),
    [anon_sym_ATmixin] = ACTIONS(342),
    [anon_sym_COMMA] = ACTIONS(342),
    [anon_sym_PIPE] = ACTIONS(342),
    [anon_sym_AMP] = ACTIONS(342),
    [anon_sym_RPAREN] = ACTIONS(342),
    [anon_sym_DOLLAR] = ACTIONS(342),
    [sym__end] = ACTIONS(342),
  },
  [46] = {
    [anon_sym_LBRACE] = ACTIONS(211),
    [anon_sym_ATinheritdoc] = ACTIONS(211),
    [anon_sym_ATinheritDoc] = ACTIONS(211),
    [anon_sym_ATapi] = ACTIONS(211),
    [anon_sym_ATfilesource] = ACTIONS(211),
    [anon_sym_ATignore] = ACTIONS(211),
    [anon_sym_ATinternal] = ACTIONS(211),
    [anon_sym_ATcategory] = ACTIONS(211),
    [anon_sym_ATcopyright] = ACTIONS(211),
    [anon_sym_ATtodo] = ACTIONS(211),
    [anon_sym_ATexample] = ACTIONS(211),
    [anon_sym_ATlicense] = ACTIONS(211),
    [anon_sym_ATpackage] = ACTIONS(211),
    [anon_sym_ATsource] = ACTIONS(211),
    [anon_sym_ATsubpackage] = ACTIONS(211),
    [anon_sym_ATuses] = ACTIONS(211),
    [anon_sym_ATauthor] = ACTIONS(211),
    [anon_sym_LT] = ACTIONS(211),
    [anon_sym_ATglobal] = ACTIONS(211),
    [anon_sym_ATlink] = ACTIONS(211),
    [anon_sym_ATmethod] = ACTIONS(211),
    [anon_sym_ATparam] = ACTIONS(209),
    [anon_sym_ATproperty] = ACTIONS(209),
    [anon_sym_ATproperty_DASHread] = ACTIONS(211),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(211),
    [anon_sym_ATreturn] = ACTIONS(211),
    [anon_sym_ATsee] = ACTIONS(211),
    [anon_sym_ATthrows] = ACTIONS(211),
    [anon_sym_ATvar] = ACTIONS(211),
    [anon_sym_ATdeprecated] = ACTIONS(211),
    [anon_sym_ATsince] = ACTIONS(211),
    [anon_sym_ATversion] = ACTIONS(211),
    [anon_sym_ATtemplate] = ACTIONS(209),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(211),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(211),
    [anon_sym_ATimplements] = ACTIONS(211),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(211),
    [anon_sym_ATextends] = ACTIONS(211),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(211),
    [anon_sym_ATuse] = ACTIONS(209),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(211),
    [anon_sym_ATafter] = ACTIONS(209),
    [anon_sym_ATafterClass] = ACTIONS(211),
    [anon_sym_ATannotation] = ACTIONS(211),
    [anon_sym_ATbackupGlobals] = ACTIONS(211),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(211),
    [anon_sym_ATbefore] = ACTIONS(209),
    [anon_sym_ATbeforeClass] = ACTIONS(211),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(209),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(211),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(211),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(211),
    [anon_sym_ATcovers] = ACTIONS(209),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(209),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(211),
    [anon_sym_ATcoversNothing] = ACTIONS(211),
    [anon_sym_ATdataProvider] = ACTIONS(211),
    [anon_sym_ATdepends] = ACTIONS(209),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(211),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(211),
    [anon_sym_ATgroup] = ACTIONS(211),
    [anon_sym_ATlarge] = ACTIONS(211),
    [anon_sym_ATmedium] = ACTIONS(211),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(211),
    [anon_sym_ATrequires] = ACTIONS(209),
    [anon_sym_ATrequiresusages] = ACTIONS(211),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(211),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(211),
    [anon_sym_ATsmall] = ACTIONS(211),
    [anon_sym_ATtest] = ACTIONS(209),
    [anon_sym_ATtestWith] = ACTIONS(211),
    [anon_sym_ATtestdox] = ACTIONS(211),
    [anon_sym_ATticket] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(209),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(209),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(209),
    [anon_sym_ATreadonly] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(211),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(211),
    [anon_sym_ATparam_DASHout] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(209),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(211),
    [anon_sym_ATmixin] = ACTIONS(211),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(211),
    [anon_sym_PIPE] = ACTIONS(211),
    [anon_sym_AMP] = ACTIONS(211),
    [anon_sym_DOLLAR] = ACTIONS(211),
    [sym__end] = ACTIONS(211),
    [sym__text_after_type] = ACTIONS(211),
  },
  [47] = {
    [aux_sym__phpdoc_array_types_repeat1] = STATE(47),
    [anon_sym_LBRACE] = ACTIONS(260),
    [anon_sym_ATinheritdoc] = ACTIONS(260),
    [anon_sym_ATinheritDoc] = ACTIONS(260),
    [anon_sym_ATapi] = ACTIONS(260),
    [anon_sym_ATfilesource] = ACTIONS(260),
    [anon_sym_ATignore] = ACTIONS(260),
    [anon_sym_ATinternal] = ACTIONS(260),
    [anon_sym_ATcategory] = ACTIONS(260),
    [anon_sym_ATcopyright] = ACTIONS(260),
    [anon_sym_ATtodo] = ACTIONS(260),
    [anon_sym_ATexample] = ACTIONS(260),
    [anon_sym_ATlicense] = ACTIONS(260),
    [anon_sym_ATpackage] = ACTIONS(260),
    [anon_sym_ATsource] = ACTIONS(260),
    [anon_sym_ATsubpackage] = ACTIONS(260),
    [anon_sym_ATuses] = ACTIONS(260),
    [anon_sym_ATauthor] = ACTIONS(260),
    [anon_sym_ATglobal] = ACTIONS(260),
    [anon_sym_ATlink] = ACTIONS(260),
    [anon_sym_ATmethod] = ACTIONS(260),
    [anon_sym_ATparam] = ACTIONS(258),
    [anon_sym_ATproperty] = ACTIONS(258),
    [anon_sym_ATproperty_DASHread] = ACTIONS(260),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(260),
    [anon_sym_ATreturn] = ACTIONS(260),
    [anon_sym_ATsee] = ACTIONS(260),
    [anon_sym_ATthrows] = ACTIONS(260),
    [anon_sym_ATvar] = ACTIONS(260),
    [anon_sym_ATdeprecated] = ACTIONS(260),
    [anon_sym_ATsince] = ACTIONS(260),
    [anon_sym_ATversion] = ACTIONS(260),
    [anon_sym_ATtemplate] = ACTIONS(258),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(260),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(260),
    [anon_sym_ATimplements] = ACTIONS(260),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(260),
    [anon_sym_ATextends] = ACTIONS(260),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(260),
    [anon_sym_ATuse] = ACTIONS(258),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(260),
    [anon_sym_ATafter] = ACTIONS(258),
    [anon_sym_ATafterClass] = ACTIONS(260),
    [anon_sym_ATannotation] = ACTIONS(260),
    [anon_sym_ATbackupGlobals] = ACTIONS(260),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(260),
    [anon_sym_ATbefore] = ACTIONS(258),
    [anon_sym_ATbeforeClass] = ACTIONS(260),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(258),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(260),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(260),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(260),
    [anon_sym_ATcovers] = ACTIONS(258),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(258),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(260),
    [anon_sym_ATcoversNothing] = ACTIONS(260),
    [anon_sym_ATdataProvider] = ACTIONS(260),
    [anon_sym_ATdepends] = ACTIONS(258),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(260),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(260),
    [anon_sym_ATgroup] = ACTIONS(260),
    [anon_sym_ATlarge] = ACTIONS(260),
    [anon_sym_ATmedium] = ACTIONS(260),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(260),
    [anon_sym_ATrequires] = ACTIONS(258),
    [anon_sym_ATrequiresusages] = ACTIONS(260),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(260),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(260),
    [anon_sym_ATsmall] = ACTIONS(260),
    [anon_sym_ATtest] = ACTIONS(258),
    [anon_sym_ATtestWith] = ACTIONS(260),
    [anon_sym_ATtestdox] = ACTIONS(260),
    [anon_sym_ATticket] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(258),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(258),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(258),
    [anon_sym_ATreadonly] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(260),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(260),
    [anon_sym_ATparam_DASHout] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(258),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(260),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(260),
    [anon_sym_ATmixin] = ACTIONS(260),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(344),
    [anon_sym_PIPE] = ACTIONS(260),
    [anon_sym_AMP] = ACTIONS(260),
    [anon_sym_DOLLAR] = ACTIONS(260),
    [sym__end] = ACTIONS(260),
    [sym__text_after_type] = ACTIONS(260),
  },
  [48] = {
    [anon_sym_LBRACE] = ACTIONS(195),
    [anon_sym_ATinheritdoc] = ACTIONS(195),
    [anon_sym_ATinheritDoc] = ACTIONS(195),
    [anon_sym_ATapi] = ACTIONS(195),
    [anon_sym_ATfilesource] = ACTIONS(195),
    [anon_sym_ATignore] = ACTIONS(195),
    [anon_sym_ATinternal] = ACTIONS(195),
    [anon_sym_ATcategory] = ACTIONS(195),
    [anon_sym_ATcopyright] = ACTIONS(195),
    [anon_sym_ATtodo] = ACTIONS(195),
    [anon_sym_ATexample] = ACTIONS(195),
    [anon_sym_ATlicense] = ACTIONS(195),
    [anon_sym_ATpackage] = ACTIONS(195),
    [anon_sym_ATsource] = ACTIONS(195),
    [anon_sym_ATsubpackage] = ACTIONS(195),
    [anon_sym_ATuses] = ACTIONS(195),
    [anon_sym_ATauthor] = ACTIONS(195),
    [anon_sym_LT] = ACTIONS(195),
    [anon_sym_ATglobal] = ACTIONS(195),
    [anon_sym_ATlink] = ACTIONS(195),
    [anon_sym_ATmethod] = ACTIONS(195),
    [anon_sym_ATparam] = ACTIONS(193),
    [anon_sym_ATproperty] = ACTIONS(193),
    [anon_sym_ATproperty_DASHread] = ACTIONS(195),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(195),
    [anon_sym_ATreturn] = ACTIONS(195),
    [anon_sym_ATsee] = ACTIONS(195),
    [anon_sym_ATthrows] = ACTIONS(195),
    [anon_sym_ATvar] = ACTIONS(195),
    [anon_sym_ATdeprecated] = ACTIONS(195),
    [anon_sym_ATsince] = ACTIONS(195),
    [anon_sym_ATversion] = ACTIONS(195),
    [anon_sym_ATtemplate] = ACTIONS(193),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(195),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(195),
    [anon_sym_ATimplements] = ACTIONS(195),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(195),
    [anon_sym_ATextends] = ACTIONS(195),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(195),
    [anon_sym_ATuse] = ACTIONS(193),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(195),
    [anon_sym_ATafter] = ACTIONS(193),
    [anon_sym_ATafterClass] = ACTIONS(195),
    [anon_sym_ATannotation] = ACTIONS(195),
    [anon_sym_ATbackupGlobals] = ACTIONS(195),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(195),
    [anon_sym_ATbefore] = ACTIONS(193),
    [anon_sym_ATbeforeClass] = ACTIONS(195),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(193),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(195),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(195),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(195),
    [anon_sym_ATcovers] = ACTIONS(193),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(193),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(195),
    [anon_sym_ATcoversNothing] = ACTIONS(195),
    [anon_sym_ATdataProvider] = ACTIONS(195),
    [anon_sym_ATdepends] = ACTIONS(193),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(195),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(195),
    [anon_sym_ATgroup] = ACTIONS(195),
    [anon_sym_ATlarge] = ACTIONS(195),
    [anon_sym_ATmedium] = ACTIONS(195),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(195),
    [anon_sym_ATrequires] = ACTIONS(193),
    [anon_sym_ATrequiresusages] = ACTIONS(195),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(195),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(195),
    [anon_sym_ATsmall] = ACTIONS(195),
    [anon_sym_ATtest] = ACTIONS(193),
    [anon_sym_ATtestWith] = ACTIONS(195),
    [anon_sym_ATtestdox] = ACTIONS(195),
    [anon_sym_ATticket] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(193),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(193),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(193),
    [anon_sym_ATreadonly] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(195),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(195),
    [anon_sym_ATparam_DASHout] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(193),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(195),
    [anon_sym_ATmixin] = ACTIONS(195),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(195),
    [anon_sym_PIPE] = ACTIONS(195),
    [anon_sym_AMP] = ACTIONS(195),
    [anon_sym_DOLLAR] = ACTIONS(195),
    [sym__end] = ACTIONS(195),
    [sym__text_after_type] = ACTIONS(195),
  },
  [49] = {
    [anon_sym_LBRACE] = ACTIONS(244),
    [anon_sym_ATinheritdoc] = ACTIONS(244),
    [anon_sym_ATinheritDoc] = ACTIONS(244),
    [anon_sym_ATapi] = ACTIONS(244),
    [anon_sym_ATfilesource] = ACTIONS(244),
    [anon_sym_ATignore] = ACTIONS(244),
    [anon_sym_ATinternal] = ACTIONS(244),
    [anon_sym_ATcategory] = ACTIONS(244),
    [anon_sym_ATcopyright] = ACTIONS(244),
    [anon_sym_ATtodo] = ACTIONS(244),
    [anon_sym_ATexample] = ACTIONS(244),
    [anon_sym_ATlicense] = ACTIONS(244),
    [anon_sym_ATpackage] = ACTIONS(244),
    [anon_sym_ATsource] = ACTIONS(244),
    [anon_sym_ATsubpackage] = ACTIONS(244),
    [anon_sym_ATuses] = ACTIONS(244),
    [anon_sym_ATauthor] = ACTIONS(244),
    [anon_sym_LT] = ACTIONS(244),
    [anon_sym_ATglobal] = ACTIONS(244),
    [anon_sym_ATlink] = ACTIONS(244),
    [anon_sym_ATmethod] = ACTIONS(244),
    [anon_sym_ATparam] = ACTIONS(242),
    [anon_sym_ATproperty] = ACTIONS(242),
    [anon_sym_ATproperty_DASHread] = ACTIONS(244),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(244),
    [anon_sym_ATreturn] = ACTIONS(244),
    [anon_sym_ATsee] = ACTIONS(244),
    [anon_sym_ATthrows] = ACTIONS(244),
    [anon_sym_ATvar] = ACTIONS(244),
    [anon_sym_ATdeprecated] = ACTIONS(244),
    [anon_sym_ATsince] = ACTIONS(244),
    [anon_sym_ATversion] = ACTIONS(244),
    [anon_sym_ATtemplate] = ACTIONS(242),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(244),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(244),
    [anon_sym_ATimplements] = ACTIONS(244),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(244),
    [anon_sym_ATextends] = ACTIONS(244),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(244),
    [anon_sym_ATuse] = ACTIONS(242),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(244),
    [anon_sym_ATafter] = ACTIONS(242),
    [anon_sym_ATafterClass] = ACTIONS(244),
    [anon_sym_ATannotation] = ACTIONS(244),
    [anon_sym_ATbackupGlobals] = ACTIONS(244),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(244),
    [anon_sym_ATbefore] = ACTIONS(242),
    [anon_sym_ATbeforeClass] = ACTIONS(244),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(242),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(244),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(244),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(244),
    [anon_sym_ATcovers] = ACTIONS(242),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(242),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(244),
    [anon_sym_ATcoversNothing] = ACTIONS(244),
    [anon_sym_ATdataProvider] = ACTIONS(244),
    [anon_sym_ATdepends] = ACTIONS(242),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(244),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(244),
    [anon_sym_ATgroup] = ACTIONS(244),
    [anon_sym_ATlarge] = ACTIONS(244),
    [anon_sym_ATmedium] = ACTIONS(244),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(244),
    [anon_sym_ATrequires] = ACTIONS(242),
    [anon_sym_ATrequiresusages] = ACTIONS(244),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(244),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(244),
    [anon_sym_ATsmall] = ACTIONS(244),
    [anon_sym_ATtest] = ACTIONS(242),
    [anon_sym_ATtestWith] = ACTIONS(244),
    [anon_sym_ATtestdox] = ACTIONS(244),
    [anon_sym_ATticket] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(242),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(242),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(242),
    [anon_sym_ATreadonly] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(244),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(244),
    [anon_sym_ATparam_DASHout] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(242),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(244),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(244),
    [anon_sym_ATmixin] = ACTIONS(244),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(244),
    [anon_sym_PIPE] = ACTIONS(244),
    [anon_sym_AMP] = ACTIONS(244),
    [anon_sym_DOLLAR] = ACTIONS(244),
    [sym__end] = ACTIONS(244),
    [sym__text_after_type] = ACTIONS(244),
  },
  [50] = {
    [aux_sym_intersection_type_repeat1] = STATE(61),
    [sym_name] = ACTIONS(347),
    [anon_sym_ATinheritdoc] = ACTIONS(349),
    [anon_sym_ATinheritDoc] = ACTIONS(349),
    [anon_sym_ATapi] = ACTIONS(349),
    [anon_sym_ATfilesource] = ACTIONS(349),
    [anon_sym_ATignore] = ACTIONS(349),
    [anon_sym_ATinternal] = ACTIONS(349),
    [anon_sym_ATcategory] = ACTIONS(349),
    [anon_sym_ATcopyright] = ACTIONS(349),
    [anon_sym_ATtodo] = ACTIONS(349),
    [anon_sym_ATexample] = ACTIONS(349),
    [anon_sym_ATlicense] = ACTIONS(349),
    [anon_sym_ATpackage] = ACTIONS(349),
    [anon_sym_ATsource] = ACTIONS(349),
    [anon_sym_ATsubpackage] = ACTIONS(349),
    [anon_sym_ATuses] = ACTIONS(349),
    [anon_sym_ATauthor] = ACTIONS(349),
    [anon_sym_ATglobal] = ACTIONS(349),
    [anon_sym_ATlink] = ACTIONS(349),
    [anon_sym_ATmethod] = ACTIONS(349),
    [anon_sym_ATparam] = ACTIONS(347),
    [anon_sym_ATproperty] = ACTIONS(347),
    [anon_sym_ATproperty_DASHread] = ACTIONS(349),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(349),
    [anon_sym_ATreturn] = ACTIONS(349),
    [anon_sym_ATsee] = ACTIONS(349),
    [anon_sym_ATthrows] = ACTIONS(349),
    [anon_sym_ATvar] = ACTIONS(349),
    [anon_sym_ATdeprecated] = ACTIONS(349),
    [anon_sym_ATsince] = ACTIONS(349),
    [anon_sym_ATversion] = ACTIONS(349),
    [anon_sym_ATtemplate] = ACTIONS(347),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(349),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(349),
    [anon_sym_of] = ACTIONS(347),
    [anon_sym_ATimplements] = ACTIONS(349),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(349),
    [anon_sym_ATextends] = ACTIONS(349),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(349),
    [anon_sym_ATuse] = ACTIONS(347),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(349),
    [anon_sym_ATafter] = ACTIONS(347),
    [anon_sym_ATafterClass] = ACTIONS(349),
    [anon_sym_ATannotation] = ACTIONS(349),
    [anon_sym_ATbackupGlobals] = ACTIONS(349),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(349),
    [anon_sym_ATbefore] = ACTIONS(347),
    [anon_sym_ATbeforeClass] = ACTIONS(349),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(347),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(349),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(349),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(349),
    [anon_sym_ATcovers] = ACTIONS(347),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(347),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(349),
    [anon_sym_ATcoversNothing] = ACTIONS(349),
    [anon_sym_ATdataProvider] = ACTIONS(349),
    [anon_sym_ATdepends] = ACTIONS(347),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(349),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(349),
    [anon_sym_ATgroup] = ACTIONS(349),
    [anon_sym_ATlarge] = ACTIONS(349),
    [anon_sym_ATmedium] = ACTIONS(349),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(349),
    [anon_sym_ATrequires] = ACTIONS(347),
    [anon_sym_ATrequiresusages] = ACTIONS(349),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(349),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(349),
    [anon_sym_ATsmall] = ACTIONS(349),
    [anon_sym_ATtest] = ACTIONS(347),
    [anon_sym_ATtestWith] = ACTIONS(349),
    [anon_sym_ATtestdox] = ACTIONS(349),
    [anon_sym_ATticket] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(347),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(347),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(347),
    [anon_sym_ATreadonly] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(349),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(349),
    [anon_sym_ATparam_DASHout] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(347),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(349),
    [anon_sym_ATmixin] = ACTIONS(349),
    [anon_sym_COMMA] = ACTIONS(349),
    [anon_sym_AMP] = ACTIONS(294),
    [anon_sym_RPAREN] = ACTIONS(349),
    [anon_sym_DOLLAR] = ACTIONS(349),
    [sym__end] = ACTIONS(349),
  },
  [51] = {
    [anon_sym_LBRACE] = ACTIONS(219),
    [anon_sym_ATinheritdoc] = ACTIONS(219),
    [anon_sym_ATinheritDoc] = ACTIONS(219),
    [anon_sym_ATapi] = ACTIONS(219),
    [anon_sym_ATfilesource] = ACTIONS(219),
    [anon_sym_ATignore] = ACTIONS(219),
    [anon_sym_ATinternal] = ACTIONS(219),
    [anon_sym_ATcategory] = ACTIONS(219),
    [anon_sym_ATcopyright] = ACTIONS(219),
    [anon_sym_ATtodo] = ACTIONS(219),
    [anon_sym_ATexample] = ACTIONS(219),
    [anon_sym_ATlicense] = ACTIONS(219),
    [anon_sym_ATpackage] = ACTIONS(219),
    [anon_sym_ATsource] = ACTIONS(219),
    [anon_sym_ATsubpackage] = ACTIONS(219),
    [anon_sym_ATuses] = ACTIONS(219),
    [anon_sym_ATauthor] = ACTIONS(219),
    [anon_sym_LT] = ACTIONS(219),
    [anon_sym_ATglobal] = ACTIONS(219),
    [anon_sym_ATlink] = ACTIONS(219),
    [anon_sym_ATmethod] = ACTIONS(219),
    [anon_sym_ATparam] = ACTIONS(217),
    [anon_sym_ATproperty] = ACTIONS(217),
    [anon_sym_ATproperty_DASHread] = ACTIONS(219),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(219),
    [anon_sym_ATreturn] = ACTIONS(219),
    [anon_sym_ATsee] = ACTIONS(219),
    [anon_sym_ATthrows] = ACTIONS(219),
    [anon_sym_ATvar] = ACTIONS(219),
    [anon_sym_ATdeprecated] = ACTIONS(219),
    [anon_sym_ATsince] = ACTIONS(219),
    [anon_sym_ATversion] = ACTIONS(219),
    [anon_sym_ATtemplate] = ACTIONS(217),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(219),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(219),
    [anon_sym_ATimplements] = ACTIONS(219),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(219),
    [anon_sym_ATextends] = ACTIONS(219),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(219),
    [anon_sym_ATuse] = ACTIONS(217),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(219),
    [anon_sym_ATafter] = ACTIONS(217),
    [anon_sym_ATafterClass] = ACTIONS(219),
    [anon_sym_ATannotation] = ACTIONS(219),
    [anon_sym_ATbackupGlobals] = ACTIONS(219),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(219),
    [anon_sym_ATbefore] = ACTIONS(217),
    [anon_sym_ATbeforeClass] = ACTIONS(219),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(217),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(219),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(219),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(219),
    [anon_sym_ATcovers] = ACTIONS(217),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(217),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(219),
    [anon_sym_ATcoversNothing] = ACTIONS(219),
    [anon_sym_ATdataProvider] = ACTIONS(219),
    [anon_sym_ATdepends] = ACTIONS(217),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(219),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(219),
    [anon_sym_ATgroup] = ACTIONS(219),
    [anon_sym_ATlarge] = ACTIONS(219),
    [anon_sym_ATmedium] = ACTIONS(219),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(219),
    [anon_sym_ATrequires] = ACTIONS(217),
    [anon_sym_ATrequiresusages] = ACTIONS(219),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(219),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(219),
    [anon_sym_ATsmall] = ACTIONS(219),
    [anon_sym_ATtest] = ACTIONS(217),
    [anon_sym_ATtestWith] = ACTIONS(219),
    [anon_sym_ATtestdox] = ACTIONS(219),
    [anon_sym_ATticket] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(217),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(217),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(217),
    [anon_sym_ATreadonly] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(219),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(219),
    [anon_sym_ATparam_DASHout] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(217),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(219),
    [anon_sym_ATmixin] = ACTIONS(219),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(219),
    [anon_sym_PIPE] = ACTIONS(219),
    [anon_sym_AMP] = ACTIONS(219),
    [anon_sym_DOLLAR] = ACTIONS(219),
    [sym__end] = ACTIONS(219),
    [sym__text_after_type] = ACTIONS(219),
  },
  [52] = {
    [sym__description_after_type] = STATE(186),
    [sym_inline_tag] = STATE(139),
    [sym_variable_name] = STATE(82),
    [aux_sym__description_after_type_repeat1] = STATE(124),
    [anon_sym_LBRACE] = ACTIONS(351),
    [anon_sym_ATinheritdoc] = ACTIONS(353),
    [anon_sym_ATinheritDoc] = ACTIONS(353),
    [anon_sym_ATapi] = ACTIONS(353),
    [anon_sym_ATfilesource] = ACTIONS(353),
    [anon_sym_ATignore] = ACTIONS(353),
    [anon_sym_ATinternal] = ACTIONS(353),
    [anon_sym_ATcategory] = ACTIONS(353),
    [anon_sym_ATcopyright] = ACTIONS(353),
    [anon_sym_ATtodo] = ACTIONS(353),
    [anon_sym_ATexample] = ACTIONS(353),
    [anon_sym_ATlicense] = ACTIONS(353),
    [anon_sym_ATpackage] = ACTIONS(353),
    [anon_sym_ATsource] = ACTIONS(353),
    [anon_sym_ATsubpackage] = ACTIONS(353),
    [anon_sym_ATuses] = ACTIONS(353),
    [anon_sym_ATauthor] = ACTIONS(353),
    [anon_sym_ATglobal] = ACTIONS(353),
    [anon_sym_ATlink] = ACTIONS(353),
    [anon_sym_ATmethod] = ACTIONS(353),
    [anon_sym_ATparam] = ACTIONS(355),
    [anon_sym_ATproperty] = ACTIONS(355),
    [anon_sym_ATproperty_DASHread] = ACTIONS(353),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(353),
    [anon_sym_ATreturn] = ACTIONS(353),
    [anon_sym_ATsee] = ACTIONS(353),
    [anon_sym_ATthrows] = ACTIONS(353),
    [anon_sym_ATvar] = ACTIONS(353),
    [anon_sym_ATdeprecated] = ACTIONS(353),
    [anon_sym_ATsince] = ACTIONS(353),
    [anon_sym_ATversion] = ACTIONS(353),
    [anon_sym_ATtemplate] = ACTIONS(355),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(353),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(353),
    [anon_sym_ATimplements] = ACTIONS(353),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(353),
    [anon_sym_ATextends] = ACTIONS(353),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(353),
    [anon_sym_ATuse] = ACTIONS(355),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(353),
    [anon_sym_ATafter] = ACTIONS(355),
    [anon_sym_ATafterClass] = ACTIONS(353),
    [anon_sym_ATannotation] = ACTIONS(353),
    [anon_sym_ATbackupGlobals] = ACTIONS(353),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(353),
    [anon_sym_ATbefore] = ACTIONS(355),
    [anon_sym_ATbeforeClass] = ACTIONS(353),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(355),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(353),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(353),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(353),
    [anon_sym_ATcovers] = ACTIONS(355),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(355),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(353),
    [anon_sym_ATcoversNothing] = ACTIONS(353),
    [anon_sym_ATdataProvider] = ACTIONS(353),
    [anon_sym_ATdepends] = ACTIONS(355),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(353),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(353),
    [anon_sym_ATgroup] = ACTIONS(353),
    [anon_sym_ATlarge] = ACTIONS(353),
    [anon_sym_ATmedium] = ACTIONS(353),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(353),
    [anon_sym_ATrequires] = ACTIONS(355),
    [anon_sym_ATrequiresusages] = ACTIONS(353),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(353),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(353),
    [anon_sym_ATsmall] = ACTIONS(353),
    [anon_sym_ATtest] = ACTIONS(355),
    [anon_sym_ATtestWith] = ACTIONS(353),
    [anon_sym_ATtestdox] = ACTIONS(353),
    [anon_sym_ATticket] = ACTIONS(353),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(353),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(353),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(353),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(355),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(353),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(355),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(353),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(353),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(353),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(353),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(353),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(353),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(353),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(353),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(353),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(355),
    [anon_sym_ATreadonly] = ACTIONS(353),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(353),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(353),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(353),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(353),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(353),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(353),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(353),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(353),
    [anon_sym_ATparam_DASHout] = ACTIONS(353),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(353),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(355),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(353),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(353),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(353),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(353),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(353),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(353),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(353),
    [anon_sym_ATmixin] = ACTIONS(353),
    [anon_sym_DOLLAR] = ACTIONS(357),
    [sym__end] = ACTIONS(353),
    [sym__text_after_type] = ACTIONS(359),
  },
  [53] = {
    [anon_sym_LBRACE] = ACTIONS(199),
    [anon_sym_ATinheritdoc] = ACTIONS(199),
    [anon_sym_ATinheritDoc] = ACTIONS(199),
    [anon_sym_ATapi] = ACTIONS(199),
    [anon_sym_ATfilesource] = ACTIONS(199),
    [anon_sym_ATignore] = ACTIONS(199),
    [anon_sym_ATinternal] = ACTIONS(199),
    [anon_sym_ATcategory] = ACTIONS(199),
    [anon_sym_ATcopyright] = ACTIONS(199),
    [anon_sym_ATtodo] = ACTIONS(199),
    [anon_sym_ATexample] = ACTIONS(199),
    [anon_sym_ATlicense] = ACTIONS(199),
    [anon_sym_ATpackage] = ACTIONS(199),
    [anon_sym_ATsource] = ACTIONS(199),
    [anon_sym_ATsubpackage] = ACTIONS(199),
    [anon_sym_ATuses] = ACTIONS(199),
    [anon_sym_ATauthor] = ACTIONS(199),
    [anon_sym_LT] = ACTIONS(199),
    [anon_sym_ATglobal] = ACTIONS(199),
    [anon_sym_ATlink] = ACTIONS(199),
    [anon_sym_ATmethod] = ACTIONS(199),
    [anon_sym_ATparam] = ACTIONS(197),
    [anon_sym_ATproperty] = ACTIONS(197),
    [anon_sym_ATproperty_DASHread] = ACTIONS(199),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(199),
    [anon_sym_ATreturn] = ACTIONS(199),
    [anon_sym_ATsee] = ACTIONS(199),
    [anon_sym_ATthrows] = ACTIONS(199),
    [anon_sym_ATvar] = ACTIONS(199),
    [anon_sym_ATdeprecated] = ACTIONS(199),
    [anon_sym_ATsince] = ACTIONS(199),
    [anon_sym_ATversion] = ACTIONS(199),
    [anon_sym_ATtemplate] = ACTIONS(197),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(199),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(199),
    [anon_sym_ATimplements] = ACTIONS(199),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(199),
    [anon_sym_ATextends] = ACTIONS(199),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(199),
    [anon_sym_ATuse] = ACTIONS(197),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(199),
    [anon_sym_ATafter] = ACTIONS(197),
    [anon_sym_ATafterClass] = ACTIONS(199),
    [anon_sym_ATannotation] = ACTIONS(199),
    [anon_sym_ATbackupGlobals] = ACTIONS(199),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(199),
    [anon_sym_ATbefore] = ACTIONS(197),
    [anon_sym_ATbeforeClass] = ACTIONS(199),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(197),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(199),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(199),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(199),
    [anon_sym_ATcovers] = ACTIONS(197),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(197),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(199),
    [anon_sym_ATcoversNothing] = ACTIONS(199),
    [anon_sym_ATdataProvider] = ACTIONS(199),
    [anon_sym_ATdepends] = ACTIONS(197),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(199),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(199),
    [anon_sym_ATgroup] = ACTIONS(199),
    [anon_sym_ATlarge] = ACTIONS(199),
    [anon_sym_ATmedium] = ACTIONS(199),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(199),
    [anon_sym_ATrequires] = ACTIONS(197),
    [anon_sym_ATrequiresusages] = ACTIONS(199),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(199),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(199),
    [anon_sym_ATsmall] = ACTIONS(199),
    [anon_sym_ATtest] = ACTIONS(197),
    [anon_sym_ATtestWith] = ACTIONS(199),
    [anon_sym_ATtestdox] = ACTIONS(199),
    [anon_sym_ATticket] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(197),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(197),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(197),
    [anon_sym_ATreadonly] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(199),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(199),
    [anon_sym_ATparam_DASHout] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(197),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(199),
    [anon_sym_ATmixin] = ACTIONS(199),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(199),
    [anon_sym_PIPE] = ACTIONS(199),
    [anon_sym_AMP] = ACTIONS(199),
    [anon_sym_DOLLAR] = ACTIONS(199),
    [sym__end] = ACTIONS(199),
    [sym__text_after_type] = ACTIONS(199),
  },
  [54] = {
    [anon_sym_LBRACE] = ACTIONS(215),
    [anon_sym_ATinheritdoc] = ACTIONS(215),
    [anon_sym_ATinheritDoc] = ACTIONS(215),
    [anon_sym_ATapi] = ACTIONS(215),
    [anon_sym_ATfilesource] = ACTIONS(215),
    [anon_sym_ATignore] = ACTIONS(215),
    [anon_sym_ATinternal] = ACTIONS(215),
    [anon_sym_ATcategory] = ACTIONS(215),
    [anon_sym_ATcopyright] = ACTIONS(215),
    [anon_sym_ATtodo] = ACTIONS(215),
    [anon_sym_ATexample] = ACTIONS(215),
    [anon_sym_ATlicense] = ACTIONS(215),
    [anon_sym_ATpackage] = ACTIONS(215),
    [anon_sym_ATsource] = ACTIONS(215),
    [anon_sym_ATsubpackage] = ACTIONS(215),
    [anon_sym_ATuses] = ACTIONS(215),
    [anon_sym_ATauthor] = ACTIONS(215),
    [anon_sym_LT] = ACTIONS(215),
    [anon_sym_ATglobal] = ACTIONS(215),
    [anon_sym_ATlink] = ACTIONS(215),
    [anon_sym_ATmethod] = ACTIONS(215),
    [anon_sym_ATparam] = ACTIONS(213),
    [anon_sym_ATproperty] = ACTIONS(213),
    [anon_sym_ATproperty_DASHread] = ACTIONS(215),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(215),
    [anon_sym_ATreturn] = ACTIONS(215),
    [anon_sym_ATsee] = ACTIONS(215),
    [anon_sym_ATthrows] = ACTIONS(215),
    [anon_sym_ATvar] = ACTIONS(215),
    [anon_sym_ATdeprecated] = ACTIONS(215),
    [anon_sym_ATsince] = ACTIONS(215),
    [anon_sym_ATversion] = ACTIONS(215),
    [anon_sym_ATtemplate] = ACTIONS(213),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(215),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(215),
    [anon_sym_ATimplements] = ACTIONS(215),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(215),
    [anon_sym_ATextends] = ACTIONS(215),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(215),
    [anon_sym_ATuse] = ACTIONS(213),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(215),
    [anon_sym_ATafter] = ACTIONS(213),
    [anon_sym_ATafterClass] = ACTIONS(215),
    [anon_sym_ATannotation] = ACTIONS(215),
    [anon_sym_ATbackupGlobals] = ACTIONS(215),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(215),
    [anon_sym_ATbefore] = ACTIONS(213),
    [anon_sym_ATbeforeClass] = ACTIONS(215),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(213),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(215),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(215),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(215),
    [anon_sym_ATcovers] = ACTIONS(213),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(213),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(215),
    [anon_sym_ATcoversNothing] = ACTIONS(215),
    [anon_sym_ATdataProvider] = ACTIONS(215),
    [anon_sym_ATdepends] = ACTIONS(213),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(215),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(215),
    [anon_sym_ATgroup] = ACTIONS(215),
    [anon_sym_ATlarge] = ACTIONS(215),
    [anon_sym_ATmedium] = ACTIONS(215),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(215),
    [anon_sym_ATrequires] = ACTIONS(213),
    [anon_sym_ATrequiresusages] = ACTIONS(215),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(215),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(215),
    [anon_sym_ATsmall] = ACTIONS(215),
    [anon_sym_ATtest] = ACTIONS(213),
    [anon_sym_ATtestWith] = ACTIONS(215),
    [anon_sym_ATtestdox] = ACTIONS(215),
    [anon_sym_ATticket] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(213),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(213),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(213),
    [anon_sym_ATreadonly] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(215),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(215),
    [anon_sym_ATparam_DASHout] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(213),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(215),
    [anon_sym_ATmixin] = ACTIONS(215),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(215),
    [anon_sym_PIPE] = ACTIONS(215),
    [anon_sym_AMP] = ACTIONS(215),
    [anon_sym_DOLLAR] = ACTIONS(215),
    [sym__end] = ACTIONS(215),
    [sym__text_after_type] = ACTIONS(215),
  },
  [55] = {
    [anon_sym_LBRACE] = ACTIONS(203),
    [anon_sym_ATinheritdoc] = ACTIONS(203),
    [anon_sym_ATinheritDoc] = ACTIONS(203),
    [anon_sym_ATapi] = ACTIONS(203),
    [anon_sym_ATfilesource] = ACTIONS(203),
    [anon_sym_ATignore] = ACTIONS(203),
    [anon_sym_ATinternal] = ACTIONS(203),
    [anon_sym_ATcategory] = ACTIONS(203),
    [anon_sym_ATcopyright] = ACTIONS(203),
    [anon_sym_ATtodo] = ACTIONS(203),
    [anon_sym_ATexample] = ACTIONS(203),
    [anon_sym_ATlicense] = ACTIONS(203),
    [anon_sym_ATpackage] = ACTIONS(203),
    [anon_sym_ATsource] = ACTIONS(203),
    [anon_sym_ATsubpackage] = ACTIONS(203),
    [anon_sym_ATuses] = ACTIONS(203),
    [anon_sym_ATauthor] = ACTIONS(203),
    [anon_sym_LT] = ACTIONS(203),
    [anon_sym_ATglobal] = ACTIONS(203),
    [anon_sym_ATlink] = ACTIONS(203),
    [anon_sym_ATmethod] = ACTIONS(203),
    [anon_sym_ATparam] = ACTIONS(201),
    [anon_sym_ATproperty] = ACTIONS(201),
    [anon_sym_ATproperty_DASHread] = ACTIONS(203),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(203),
    [anon_sym_ATreturn] = ACTIONS(203),
    [anon_sym_ATsee] = ACTIONS(203),
    [anon_sym_ATthrows] = ACTIONS(203),
    [anon_sym_ATvar] = ACTIONS(203),
    [anon_sym_ATdeprecated] = ACTIONS(203),
    [anon_sym_ATsince] = ACTIONS(203),
    [anon_sym_ATversion] = ACTIONS(203),
    [anon_sym_ATtemplate] = ACTIONS(201),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(203),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(203),
    [anon_sym_ATimplements] = ACTIONS(203),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(203),
    [anon_sym_ATextends] = ACTIONS(203),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(203),
    [anon_sym_ATuse] = ACTIONS(201),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(203),
    [anon_sym_ATafter] = ACTIONS(201),
    [anon_sym_ATafterClass] = ACTIONS(203),
    [anon_sym_ATannotation] = ACTIONS(203),
    [anon_sym_ATbackupGlobals] = ACTIONS(203),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(203),
    [anon_sym_ATbefore] = ACTIONS(201),
    [anon_sym_ATbeforeClass] = ACTIONS(203),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(201),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(203),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(203),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(203),
    [anon_sym_ATcovers] = ACTIONS(201),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(201),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(203),
    [anon_sym_ATcoversNothing] = ACTIONS(203),
    [anon_sym_ATdataProvider] = ACTIONS(203),
    [anon_sym_ATdepends] = ACTIONS(201),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(203),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(203),
    [anon_sym_ATgroup] = ACTIONS(203),
    [anon_sym_ATlarge] = ACTIONS(203),
    [anon_sym_ATmedium] = ACTIONS(203),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(203),
    [anon_sym_ATrequires] = ACTIONS(201),
    [anon_sym_ATrequiresusages] = ACTIONS(203),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(203),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(203),
    [anon_sym_ATsmall] = ACTIONS(203),
    [anon_sym_ATtest] = ACTIONS(201),
    [anon_sym_ATtestWith] = ACTIONS(203),
    [anon_sym_ATtestdox] = ACTIONS(203),
    [anon_sym_ATticket] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(201),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(201),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(201),
    [anon_sym_ATreadonly] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(203),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(203),
    [anon_sym_ATparam_DASHout] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(201),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(203),
    [anon_sym_ATmixin] = ACTIONS(203),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(203),
    [anon_sym_PIPE] = ACTIONS(203),
    [anon_sym_AMP] = ACTIONS(203),
    [anon_sym_DOLLAR] = ACTIONS(203),
    [sym__end] = ACTIONS(203),
    [sym__text_after_type] = ACTIONS(203),
  },
  [56] = {
    [anon_sym_LBRACE] = ACTIONS(223),
    [anon_sym_ATinheritdoc] = ACTIONS(223),
    [anon_sym_ATinheritDoc] = ACTIONS(223),
    [anon_sym_ATapi] = ACTIONS(223),
    [anon_sym_ATfilesource] = ACTIONS(223),
    [anon_sym_ATignore] = ACTIONS(223),
    [anon_sym_ATinternal] = ACTIONS(223),
    [anon_sym_ATcategory] = ACTIONS(223),
    [anon_sym_ATcopyright] = ACTIONS(223),
    [anon_sym_ATtodo] = ACTIONS(223),
    [anon_sym_ATexample] = ACTIONS(223),
    [anon_sym_ATlicense] = ACTIONS(223),
    [anon_sym_ATpackage] = ACTIONS(223),
    [anon_sym_ATsource] = ACTIONS(223),
    [anon_sym_ATsubpackage] = ACTIONS(223),
    [anon_sym_ATuses] = ACTIONS(223),
    [anon_sym_ATauthor] = ACTIONS(223),
    [anon_sym_LT] = ACTIONS(223),
    [anon_sym_ATglobal] = ACTIONS(223),
    [anon_sym_ATlink] = ACTIONS(223),
    [anon_sym_ATmethod] = ACTIONS(223),
    [anon_sym_ATparam] = ACTIONS(221),
    [anon_sym_ATproperty] = ACTIONS(221),
    [anon_sym_ATproperty_DASHread] = ACTIONS(223),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(223),
    [anon_sym_ATreturn] = ACTIONS(223),
    [anon_sym_ATsee] = ACTIONS(223),
    [anon_sym_ATthrows] = ACTIONS(223),
    [anon_sym_ATvar] = ACTIONS(223),
    [anon_sym_ATdeprecated] = ACTIONS(223),
    [anon_sym_ATsince] = ACTIONS(223),
    [anon_sym_ATversion] = ACTIONS(223),
    [anon_sym_ATtemplate] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(223),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(223),
    [anon_sym_ATimplements] = ACTIONS(223),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(223),
    [anon_sym_ATextends] = ACTIONS(223),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(223),
    [anon_sym_ATuse] = ACTIONS(221),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(223),
    [anon_sym_ATafter] = ACTIONS(221),
    [anon_sym_ATafterClass] = ACTIONS(223),
    [anon_sym_ATannotation] = ACTIONS(223),
    [anon_sym_ATbackupGlobals] = ACTIONS(223),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(223),
    [anon_sym_ATbefore] = ACTIONS(221),
    [anon_sym_ATbeforeClass] = ACTIONS(223),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(221),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(223),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(223),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(223),
    [anon_sym_ATcovers] = ACTIONS(221),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(221),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(223),
    [anon_sym_ATcoversNothing] = ACTIONS(223),
    [anon_sym_ATdataProvider] = ACTIONS(223),
    [anon_sym_ATdepends] = ACTIONS(221),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(223),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(223),
    [anon_sym_ATgroup] = ACTIONS(223),
    [anon_sym_ATlarge] = ACTIONS(223),
    [anon_sym_ATmedium] = ACTIONS(223),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(223),
    [anon_sym_ATrequires] = ACTIONS(221),
    [anon_sym_ATrequiresusages] = ACTIONS(223),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(223),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(223),
    [anon_sym_ATsmall] = ACTIONS(223),
    [anon_sym_ATtest] = ACTIONS(221),
    [anon_sym_ATtestWith] = ACTIONS(223),
    [anon_sym_ATtestdox] = ACTIONS(223),
    [anon_sym_ATticket] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(221),
    [anon_sym_ATreadonly] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(223),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(223),
    [anon_sym_ATparam_DASHout] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(223),
    [anon_sym_ATmixin] = ACTIONS(223),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(223),
    [anon_sym_AMP] = ACTIONS(223),
    [anon_sym_DOLLAR] = ACTIONS(223),
    [sym__end] = ACTIONS(223),
    [sym__text_after_type] = ACTIONS(223),
  },
  [57] = {
    [anon_sym_LBRACE] = ACTIONS(207),
    [anon_sym_ATinheritdoc] = ACTIONS(207),
    [anon_sym_ATinheritDoc] = ACTIONS(207),
    [anon_sym_ATapi] = ACTIONS(207),
    [anon_sym_ATfilesource] = ACTIONS(207),
    [anon_sym_ATignore] = ACTIONS(207),
    [anon_sym_ATinternal] = ACTIONS(207),
    [anon_sym_ATcategory] = ACTIONS(207),
    [anon_sym_ATcopyright] = ACTIONS(207),
    [anon_sym_ATtodo] = ACTIONS(207),
    [anon_sym_ATexample] = ACTIONS(207),
    [anon_sym_ATlicense] = ACTIONS(207),
    [anon_sym_ATpackage] = ACTIONS(207),
    [anon_sym_ATsource] = ACTIONS(207),
    [anon_sym_ATsubpackage] = ACTIONS(207),
    [anon_sym_ATuses] = ACTIONS(207),
    [anon_sym_ATauthor] = ACTIONS(207),
    [anon_sym_LT] = ACTIONS(207),
    [anon_sym_ATglobal] = ACTIONS(207),
    [anon_sym_ATlink] = ACTIONS(207),
    [anon_sym_ATmethod] = ACTIONS(207),
    [anon_sym_ATparam] = ACTIONS(205),
    [anon_sym_ATproperty] = ACTIONS(205),
    [anon_sym_ATproperty_DASHread] = ACTIONS(207),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(207),
    [anon_sym_ATreturn] = ACTIONS(207),
    [anon_sym_ATsee] = ACTIONS(207),
    [anon_sym_ATthrows] = ACTIONS(207),
    [anon_sym_ATvar] = ACTIONS(207),
    [anon_sym_ATdeprecated] = ACTIONS(207),
    [anon_sym_ATsince] = ACTIONS(207),
    [anon_sym_ATversion] = ACTIONS(207),
    [anon_sym_ATtemplate] = ACTIONS(205),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(207),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(207),
    [anon_sym_ATimplements] = ACTIONS(207),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(207),
    [anon_sym_ATextends] = ACTIONS(207),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(207),
    [anon_sym_ATuse] = ACTIONS(205),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(207),
    [anon_sym_ATafter] = ACTIONS(205),
    [anon_sym_ATafterClass] = ACTIONS(207),
    [anon_sym_ATannotation] = ACTIONS(207),
    [anon_sym_ATbackupGlobals] = ACTIONS(207),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(207),
    [anon_sym_ATbefore] = ACTIONS(205),
    [anon_sym_ATbeforeClass] = ACTIONS(207),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(205),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(207),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(207),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(207),
    [anon_sym_ATcovers] = ACTIONS(205),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(205),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(207),
    [anon_sym_ATcoversNothing] = ACTIONS(207),
    [anon_sym_ATdataProvider] = ACTIONS(207),
    [anon_sym_ATdepends] = ACTIONS(205),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(207),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(207),
    [anon_sym_ATgroup] = ACTIONS(207),
    [anon_sym_ATlarge] = ACTIONS(207),
    [anon_sym_ATmedium] = ACTIONS(207),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(207),
    [anon_sym_ATrequires] = ACTIONS(205),
    [anon_sym_ATrequiresusages] = ACTIONS(207),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(207),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(207),
    [anon_sym_ATsmall] = ACTIONS(207),
    [anon_sym_ATtest] = ACTIONS(205),
    [anon_sym_ATtestWith] = ACTIONS(207),
    [anon_sym_ATtestdox] = ACTIONS(207),
    [anon_sym_ATticket] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(205),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(205),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(205),
    [anon_sym_ATreadonly] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(207),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(207),
    [anon_sym_ATparam_DASHout] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(205),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(207),
    [anon_sym_ATmixin] = ACTIONS(207),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(207),
    [anon_sym_PIPE] = ACTIONS(207),
    [anon_sym_AMP] = ACTIONS(207),
    [anon_sym_DOLLAR] = ACTIONS(207),
    [sym__end] = ACTIONS(207),
    [sym__text_after_type] = ACTIONS(207),
  },
  [58] = {
    [anon_sym_LBRACE] = ACTIONS(361),
    [anon_sym_ATinheritdoc] = ACTIONS(232),
    [anon_sym_ATinheritDoc] = ACTIONS(232),
    [anon_sym_ATapi] = ACTIONS(232),
    [anon_sym_ATfilesource] = ACTIONS(232),
    [anon_sym_ATignore] = ACTIONS(232),
    [anon_sym_ATinternal] = ACTIONS(232),
    [anon_sym_ATcategory] = ACTIONS(232),
    [anon_sym_ATcopyright] = ACTIONS(232),
    [anon_sym_ATtodo] = ACTIONS(232),
    [anon_sym_ATexample] = ACTIONS(232),
    [anon_sym_ATlicense] = ACTIONS(232),
    [anon_sym_ATpackage] = ACTIONS(232),
    [anon_sym_ATsource] = ACTIONS(232),
    [anon_sym_ATsubpackage] = ACTIONS(232),
    [anon_sym_ATuses] = ACTIONS(232),
    [anon_sym_ATauthor] = ACTIONS(232),
    [anon_sym_LT] = ACTIONS(232),
    [anon_sym_ATglobal] = ACTIONS(232),
    [anon_sym_ATlink] = ACTIONS(232),
    [anon_sym_ATmethod] = ACTIONS(232),
    [anon_sym_ATparam] = ACTIONS(228),
    [anon_sym_ATproperty] = ACTIONS(228),
    [anon_sym_ATproperty_DASHread] = ACTIONS(232),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(232),
    [anon_sym_ATreturn] = ACTIONS(232),
    [anon_sym_ATsee] = ACTIONS(232),
    [anon_sym_ATthrows] = ACTIONS(232),
    [anon_sym_ATvar] = ACTIONS(232),
    [anon_sym_ATdeprecated] = ACTIONS(232),
    [anon_sym_ATsince] = ACTIONS(232),
    [anon_sym_ATversion] = ACTIONS(232),
    [anon_sym_ATtemplate] = ACTIONS(228),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(232),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(232),
    [anon_sym_ATimplements] = ACTIONS(232),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(232),
    [anon_sym_ATextends] = ACTIONS(232),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(232),
    [anon_sym_ATuse] = ACTIONS(228),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(232),
    [anon_sym_ATafter] = ACTIONS(228),
    [anon_sym_ATafterClass] = ACTIONS(232),
    [anon_sym_ATannotation] = ACTIONS(232),
    [anon_sym_ATbackupGlobals] = ACTIONS(232),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(232),
    [anon_sym_ATbefore] = ACTIONS(228),
    [anon_sym_ATbeforeClass] = ACTIONS(232),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(228),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(232),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(232),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(232),
    [anon_sym_ATcovers] = ACTIONS(228),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(228),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(232),
    [anon_sym_ATcoversNothing] = ACTIONS(232),
    [anon_sym_ATdataProvider] = ACTIONS(232),
    [anon_sym_ATdepends] = ACTIONS(228),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(232),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(232),
    [anon_sym_ATgroup] = ACTIONS(232),
    [anon_sym_ATlarge] = ACTIONS(232),
    [anon_sym_ATmedium] = ACTIONS(232),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(232),
    [anon_sym_ATrequires] = ACTIONS(228),
    [anon_sym_ATrequiresusages] = ACTIONS(232),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(232),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(232),
    [anon_sym_ATsmall] = ACTIONS(232),
    [anon_sym_ATtest] = ACTIONS(228),
    [anon_sym_ATtestWith] = ACTIONS(232),
    [anon_sym_ATtestdox] = ACTIONS(232),
    [anon_sym_ATticket] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(228),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(228),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(228),
    [anon_sym_ATreadonly] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(232),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(232),
    [anon_sym_ATparam_DASHout] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(228),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(232),
    [anon_sym_ATmixin] = ACTIONS(232),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(232),
    [anon_sym_PIPE] = ACTIONS(232),
    [anon_sym_AMP] = ACTIONS(232),
    [anon_sym_DOLLAR] = ACTIONS(232),
    [sym__end] = ACTIONS(232),
    [sym__text_after_type] = ACTIONS(232),
  },
  [59] = {
    [sym__type_argument_list] = STATE(11),
    [anon_sym_ATinheritdoc] = ACTIONS(223),
    [anon_sym_ATinheritDoc] = ACTIONS(223),
    [anon_sym_RBRACE] = ACTIONS(223),
    [anon_sym_ATapi] = ACTIONS(223),
    [anon_sym_ATfilesource] = ACTIONS(223),
    [anon_sym_ATignore] = ACTIONS(223),
    [anon_sym_ATinternal] = ACTIONS(223),
    [anon_sym_ATcategory] = ACTIONS(223),
    [anon_sym_ATcopyright] = ACTIONS(223),
    [anon_sym_ATtodo] = ACTIONS(223),
    [anon_sym_ATexample] = ACTIONS(223),
    [anon_sym_ATlicense] = ACTIONS(223),
    [anon_sym_ATpackage] = ACTIONS(223),
    [anon_sym_ATsource] = ACTIONS(223),
    [anon_sym_ATsubpackage] = ACTIONS(223),
    [anon_sym_ATuses] = ACTIONS(223),
    [anon_sym_ATauthor] = ACTIONS(223),
    [anon_sym_LT] = ACTIONS(280),
    [anon_sym_GT] = ACTIONS(223),
    [anon_sym_ATglobal] = ACTIONS(223),
    [anon_sym_ATlink] = ACTIONS(223),
    [anon_sym_ATmethod] = ACTIONS(223),
    [anon_sym_ATparam] = ACTIONS(221),
    [anon_sym_ATproperty] = ACTIONS(221),
    [anon_sym_ATproperty_DASHread] = ACTIONS(223),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(223),
    [anon_sym_ATreturn] = ACTIONS(223),
    [anon_sym_ATsee] = ACTIONS(223),
    [anon_sym_ATthrows] = ACTIONS(223),
    [anon_sym_ATvar] = ACTIONS(223),
    [anon_sym_ATdeprecated] = ACTIONS(223),
    [anon_sym_ATsince] = ACTIONS(223),
    [anon_sym_ATversion] = ACTIONS(223),
    [anon_sym_ATtemplate] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(223),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(223),
    [anon_sym_ATimplements] = ACTIONS(223),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(223),
    [anon_sym_ATextends] = ACTIONS(223),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(223),
    [anon_sym_ATuse] = ACTIONS(221),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(223),
    [anon_sym_ATafter] = ACTIONS(221),
    [anon_sym_ATafterClass] = ACTIONS(223),
    [anon_sym_ATannotation] = ACTIONS(223),
    [anon_sym_ATbackupGlobals] = ACTIONS(223),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(223),
    [anon_sym_ATbefore] = ACTIONS(221),
    [anon_sym_ATbeforeClass] = ACTIONS(223),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(221),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(223),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(223),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(223),
    [anon_sym_ATcovers] = ACTIONS(221),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(221),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(223),
    [anon_sym_ATcoversNothing] = ACTIONS(223),
    [anon_sym_ATdataProvider] = ACTIONS(223),
    [anon_sym_ATdepends] = ACTIONS(221),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(223),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(223),
    [anon_sym_ATgroup] = ACTIONS(223),
    [anon_sym_ATlarge] = ACTIONS(223),
    [anon_sym_ATmedium] = ACTIONS(223),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(223),
    [anon_sym_ATrequires] = ACTIONS(221),
    [anon_sym_ATrequiresusages] = ACTIONS(223),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(223),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(223),
    [anon_sym_ATsmall] = ACTIONS(223),
    [anon_sym_ATtest] = ACTIONS(221),
    [anon_sym_ATtestWith] = ACTIONS(223),
    [anon_sym_ATtestdox] = ACTIONS(223),
    [anon_sym_ATticket] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(221),
    [anon_sym_ATreadonly] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(223),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(223),
    [anon_sym_ATparam_DASHout] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(223),
    [anon_sym_from] = ACTIONS(223),
    [anon_sym_as] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(223),
    [anon_sym_ATmixin] = ACTIONS(223),
    [anon_sym_COMMA] = ACTIONS(223),
    [sym__end] = ACTIONS(223),
  },
  [60] = {
    [sym__type_argument_named_type] = STATE(79),
    [anon_sym_LBRACE] = ACTIONS(267),
    [anon_sym_ATinheritdoc] = ACTIONS(267),
    [anon_sym_ATinheritDoc] = ACTIONS(267),
    [anon_sym_ATapi] = ACTIONS(267),
    [anon_sym_ATfilesource] = ACTIONS(267),
    [anon_sym_ATignore] = ACTIONS(267),
    [anon_sym_ATinternal] = ACTIONS(267),
    [anon_sym_ATcategory] = ACTIONS(267),
    [anon_sym_ATcopyright] = ACTIONS(267),
    [anon_sym_ATtodo] = ACTIONS(267),
    [anon_sym_ATexample] = ACTIONS(267),
    [anon_sym_ATlicense] = ACTIONS(267),
    [anon_sym_ATpackage] = ACTIONS(267),
    [anon_sym_ATsource] = ACTIONS(267),
    [anon_sym_ATsubpackage] = ACTIONS(267),
    [anon_sym_ATuses] = ACTIONS(267),
    [anon_sym_ATauthor] = ACTIONS(267),
    [anon_sym_LT] = ACTIONS(363),
    [anon_sym_ATglobal] = ACTIONS(267),
    [anon_sym_ATlink] = ACTIONS(267),
    [anon_sym_ATmethod] = ACTIONS(267),
    [anon_sym_ATparam] = ACTIONS(265),
    [anon_sym_ATproperty] = ACTIONS(265),
    [anon_sym_ATproperty_DASHread] = ACTIONS(267),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(267),
    [anon_sym_ATreturn] = ACTIONS(267),
    [anon_sym_ATsee] = ACTIONS(267),
    [anon_sym_ATthrows] = ACTIONS(267),
    [anon_sym_ATvar] = ACTIONS(267),
    [anon_sym_ATdeprecated] = ACTIONS(267),
    [anon_sym_ATsince] = ACTIONS(267),
    [anon_sym_ATversion] = ACTIONS(267),
    [anon_sym_ATtemplate] = ACTIONS(265),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(267),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(267),
    [anon_sym_ATimplements] = ACTIONS(267),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(267),
    [anon_sym_ATextends] = ACTIONS(267),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(267),
    [anon_sym_ATuse] = ACTIONS(265),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(267),
    [anon_sym_ATafter] = ACTIONS(265),
    [anon_sym_ATafterClass] = ACTIONS(267),
    [anon_sym_ATannotation] = ACTIONS(267),
    [anon_sym_ATbackupGlobals] = ACTIONS(267),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(267),
    [anon_sym_ATbefore] = ACTIONS(265),
    [anon_sym_ATbeforeClass] = ACTIONS(267),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(265),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(267),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(267),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(267),
    [anon_sym_ATcovers] = ACTIONS(265),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(265),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(267),
    [anon_sym_ATcoversNothing] = ACTIONS(267),
    [anon_sym_ATdataProvider] = ACTIONS(267),
    [anon_sym_ATdepends] = ACTIONS(265),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(267),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(267),
    [anon_sym_ATgroup] = ACTIONS(267),
    [anon_sym_ATlarge] = ACTIONS(267),
    [anon_sym_ATmedium] = ACTIONS(267),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(267),
    [anon_sym_ATrequires] = ACTIONS(265),
    [anon_sym_ATrequiresusages] = ACTIONS(267),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(267),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(267),
    [anon_sym_ATsmall] = ACTIONS(267),
    [anon_sym_ATtest] = ACTIONS(265),
    [anon_sym_ATtestWith] = ACTIONS(267),
    [anon_sym_ATtestdox] = ACTIONS(267),
    [anon_sym_ATticket] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(265),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(265),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(265),
    [anon_sym_ATreadonly] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(267),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(267),
    [anon_sym_ATparam_DASHout] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(265),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(267),
    [anon_sym_ATmixin] = ACTIONS(267),
    [anon_sym_PIPE] = ACTIONS(267),
    [anon_sym_AMP] = ACTIONS(267),
    [anon_sym_DOLLAR] = ACTIONS(267),
    [sym__end] = ACTIONS(267),
    [sym__text_after_type] = ACTIONS(267),
  },
  [61] = {
    [aux_sym_intersection_type_repeat1] = STATE(61),
    [sym_name] = ACTIONS(365),
    [anon_sym_ATinheritdoc] = ACTIONS(367),
    [anon_sym_ATinheritDoc] = ACTIONS(367),
    [anon_sym_ATapi] = ACTIONS(367),
    [anon_sym_ATfilesource] = ACTIONS(367),
    [anon_sym_ATignore] = ACTIONS(367),
    [anon_sym_ATinternal] = ACTIONS(367),
    [anon_sym_ATcategory] = ACTIONS(367),
    [anon_sym_ATcopyright] = ACTIONS(367),
    [anon_sym_ATtodo] = ACTIONS(367),
    [anon_sym_ATexample] = ACTIONS(367),
    [anon_sym_ATlicense] = ACTIONS(367),
    [anon_sym_ATpackage] = ACTIONS(367),
    [anon_sym_ATsource] = ACTIONS(367),
    [anon_sym_ATsubpackage] = ACTIONS(367),
    [anon_sym_ATuses] = ACTIONS(367),
    [anon_sym_ATauthor] = ACTIONS(367),
    [anon_sym_ATglobal] = ACTIONS(367),
    [anon_sym_ATlink] = ACTIONS(367),
    [anon_sym_ATmethod] = ACTIONS(367),
    [anon_sym_ATparam] = ACTIONS(365),
    [anon_sym_ATproperty] = ACTIONS(365),
    [anon_sym_ATproperty_DASHread] = ACTIONS(367),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(367),
    [anon_sym_ATreturn] = ACTIONS(367),
    [anon_sym_ATsee] = ACTIONS(367),
    [anon_sym_ATthrows] = ACTIONS(367),
    [anon_sym_ATvar] = ACTIONS(367),
    [anon_sym_ATdeprecated] = ACTIONS(367),
    [anon_sym_ATsince] = ACTIONS(367),
    [anon_sym_ATversion] = ACTIONS(367),
    [anon_sym_ATtemplate] = ACTIONS(365),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(367),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(367),
    [anon_sym_of] = ACTIONS(365),
    [anon_sym_ATimplements] = ACTIONS(367),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(367),
    [anon_sym_ATextends] = ACTIONS(367),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(367),
    [anon_sym_ATuse] = ACTIONS(365),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(367),
    [anon_sym_ATafter] = ACTIONS(365),
    [anon_sym_ATafterClass] = ACTIONS(367),
    [anon_sym_ATannotation] = ACTIONS(367),
    [anon_sym_ATbackupGlobals] = ACTIONS(367),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(367),
    [anon_sym_ATbefore] = ACTIONS(365),
    [anon_sym_ATbeforeClass] = ACTIONS(367),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(365),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(367),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(367),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(367),
    [anon_sym_ATcovers] = ACTIONS(365),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(365),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(367),
    [anon_sym_ATcoversNothing] = ACTIONS(367),
    [anon_sym_ATdataProvider] = ACTIONS(367),
    [anon_sym_ATdepends] = ACTIONS(365),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(367),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(367),
    [anon_sym_ATgroup] = ACTIONS(367),
    [anon_sym_ATlarge] = ACTIONS(367),
    [anon_sym_ATmedium] = ACTIONS(367),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(367),
    [anon_sym_ATrequires] = ACTIONS(365),
    [anon_sym_ATrequiresusages] = ACTIONS(367),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(367),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(367),
    [anon_sym_ATsmall] = ACTIONS(367),
    [anon_sym_ATtest] = ACTIONS(365),
    [anon_sym_ATtestWith] = ACTIONS(367),
    [anon_sym_ATtestdox] = ACTIONS(367),
    [anon_sym_ATticket] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(365),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(365),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(365),
    [anon_sym_ATreadonly] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(367),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(367),
    [anon_sym_ATparam_DASHout] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(365),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(367),
    [anon_sym_ATmixin] = ACTIONS(367),
    [anon_sym_COMMA] = ACTIONS(367),
    [anon_sym_AMP] = ACTIONS(369),
    [anon_sym_RPAREN] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(367),
    [sym__end] = ACTIONS(367),
  },
  [62] = {
    [aux_sym__phpdoc_array_types_repeat1] = STATE(47),
    [anon_sym_LBRACE] = ACTIONS(273),
    [anon_sym_ATinheritdoc] = ACTIONS(273),
    [anon_sym_ATinheritDoc] = ACTIONS(273),
    [anon_sym_ATapi] = ACTIONS(273),
    [anon_sym_ATfilesource] = ACTIONS(273),
    [anon_sym_ATignore] = ACTIONS(273),
    [anon_sym_ATinternal] = ACTIONS(273),
    [anon_sym_ATcategory] = ACTIONS(273),
    [anon_sym_ATcopyright] = ACTIONS(273),
    [anon_sym_ATtodo] = ACTIONS(273),
    [anon_sym_ATexample] = ACTIONS(273),
    [anon_sym_ATlicense] = ACTIONS(273),
    [anon_sym_ATpackage] = ACTIONS(273),
    [anon_sym_ATsource] = ACTIONS(273),
    [anon_sym_ATsubpackage] = ACTIONS(273),
    [anon_sym_ATuses] = ACTIONS(273),
    [anon_sym_ATauthor] = ACTIONS(273),
    [anon_sym_ATglobal] = ACTIONS(273),
    [anon_sym_ATlink] = ACTIONS(273),
    [anon_sym_ATmethod] = ACTIONS(273),
    [anon_sym_ATparam] = ACTIONS(271),
    [anon_sym_ATproperty] = ACTIONS(271),
    [anon_sym_ATproperty_DASHread] = ACTIONS(273),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(273),
    [anon_sym_ATreturn] = ACTIONS(273),
    [anon_sym_ATsee] = ACTIONS(273),
    [anon_sym_ATthrows] = ACTIONS(273),
    [anon_sym_ATvar] = ACTIONS(273),
    [anon_sym_ATdeprecated] = ACTIONS(273),
    [anon_sym_ATsince] = ACTIONS(273),
    [anon_sym_ATversion] = ACTIONS(273),
    [anon_sym_ATtemplate] = ACTIONS(271),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(273),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(273),
    [anon_sym_ATimplements] = ACTIONS(273),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(273),
    [anon_sym_ATextends] = ACTIONS(273),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(273),
    [anon_sym_ATuse] = ACTIONS(271),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(273),
    [anon_sym_ATafter] = ACTIONS(271),
    [anon_sym_ATafterClass] = ACTIONS(273),
    [anon_sym_ATannotation] = ACTIONS(273),
    [anon_sym_ATbackupGlobals] = ACTIONS(273),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(273),
    [anon_sym_ATbefore] = ACTIONS(271),
    [anon_sym_ATbeforeClass] = ACTIONS(273),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(271),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(273),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(273),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(273),
    [anon_sym_ATcovers] = ACTIONS(271),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(271),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(273),
    [anon_sym_ATcoversNothing] = ACTIONS(273),
    [anon_sym_ATdataProvider] = ACTIONS(273),
    [anon_sym_ATdepends] = ACTIONS(271),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(273),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(273),
    [anon_sym_ATgroup] = ACTIONS(273),
    [anon_sym_ATlarge] = ACTIONS(273),
    [anon_sym_ATmedium] = ACTIONS(273),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(273),
    [anon_sym_ATrequires] = ACTIONS(271),
    [anon_sym_ATrequiresusages] = ACTIONS(273),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(273),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(273),
    [anon_sym_ATsmall] = ACTIONS(273),
    [anon_sym_ATtest] = ACTIONS(271),
    [anon_sym_ATtestWith] = ACTIONS(273),
    [anon_sym_ATtestdox] = ACTIONS(273),
    [anon_sym_ATticket] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(271),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(271),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(271),
    [anon_sym_ATreadonly] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(273),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(273),
    [anon_sym_ATparam_DASHout] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(271),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(273),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(273),
    [anon_sym_ATmixin] = ACTIONS(273),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(372),
    [anon_sym_PIPE] = ACTIONS(273),
    [anon_sym_AMP] = ACTIONS(273),
    [anon_sym_DOLLAR] = ACTIONS(273),
    [sym__end] = ACTIONS(273),
    [sym__text_after_type] = ACTIONS(273),
  },
  [63] = {
    [anon_sym_LBRACE] = ACTIONS(232),
    [anon_sym_ATinheritdoc] = ACTIONS(232),
    [anon_sym_ATinheritDoc] = ACTIONS(232),
    [anon_sym_ATapi] = ACTIONS(232),
    [anon_sym_ATfilesource] = ACTIONS(232),
    [anon_sym_ATignore] = ACTIONS(232),
    [anon_sym_ATinternal] = ACTIONS(232),
    [anon_sym_ATcategory] = ACTIONS(232),
    [anon_sym_ATcopyright] = ACTIONS(232),
    [anon_sym_ATtodo] = ACTIONS(232),
    [anon_sym_ATexample] = ACTIONS(232),
    [anon_sym_ATlicense] = ACTIONS(232),
    [anon_sym_ATpackage] = ACTIONS(232),
    [anon_sym_ATsource] = ACTIONS(232),
    [anon_sym_ATsubpackage] = ACTIONS(232),
    [anon_sym_ATuses] = ACTIONS(232),
    [anon_sym_ATauthor] = ACTIONS(232),
    [anon_sym_LT] = ACTIONS(232),
    [anon_sym_ATglobal] = ACTIONS(232),
    [anon_sym_ATlink] = ACTIONS(232),
    [anon_sym_ATmethod] = ACTIONS(232),
    [anon_sym_ATparam] = ACTIONS(228),
    [anon_sym_ATproperty] = ACTIONS(228),
    [anon_sym_ATproperty_DASHread] = ACTIONS(232),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(232),
    [anon_sym_ATreturn] = ACTIONS(232),
    [anon_sym_ATsee] = ACTIONS(232),
    [anon_sym_ATthrows] = ACTIONS(232),
    [anon_sym_ATvar] = ACTIONS(232),
    [anon_sym_ATdeprecated] = ACTIONS(232),
    [anon_sym_ATsince] = ACTIONS(232),
    [anon_sym_ATversion] = ACTIONS(232),
    [anon_sym_ATtemplate] = ACTIONS(228),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(232),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(232),
    [anon_sym_ATimplements] = ACTIONS(232),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(232),
    [anon_sym_ATextends] = ACTIONS(232),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(232),
    [anon_sym_ATuse] = ACTIONS(228),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(232),
    [anon_sym_ATafter] = ACTIONS(228),
    [anon_sym_ATafterClass] = ACTIONS(232),
    [anon_sym_ATannotation] = ACTIONS(232),
    [anon_sym_ATbackupGlobals] = ACTIONS(232),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(232),
    [anon_sym_ATbefore] = ACTIONS(228),
    [anon_sym_ATbeforeClass] = ACTIONS(232),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(228),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(232),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(232),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(232),
    [anon_sym_ATcovers] = ACTIONS(228),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(228),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(232),
    [anon_sym_ATcoversNothing] = ACTIONS(232),
    [anon_sym_ATdataProvider] = ACTIONS(232),
    [anon_sym_ATdepends] = ACTIONS(228),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(232),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(232),
    [anon_sym_ATgroup] = ACTIONS(232),
    [anon_sym_ATlarge] = ACTIONS(232),
    [anon_sym_ATmedium] = ACTIONS(232),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(232),
    [anon_sym_ATrequires] = ACTIONS(228),
    [anon_sym_ATrequiresusages] = ACTIONS(232),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(232),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(232),
    [anon_sym_ATsmall] = ACTIONS(232),
    [anon_sym_ATtest] = ACTIONS(228),
    [anon_sym_ATtestWith] = ACTIONS(232),
    [anon_sym_ATtestdox] = ACTIONS(232),
    [anon_sym_ATticket] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(228),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(228),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(228),
    [anon_sym_ATreadonly] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(232),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(232),
    [anon_sym_ATparam_DASHout] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(228),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(232),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(232),
    [anon_sym_ATmixin] = ACTIONS(232),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(232),
    [anon_sym_PIPE] = ACTIONS(232),
    [anon_sym_AMP] = ACTIONS(232),
    [anon_sym_DOLLAR] = ACTIONS(232),
    [sym__end] = ACTIONS(232),
    [sym__text_after_type] = ACTIONS(232),
  },
  [64] = {
    [aux_sym_disjunctive_normal_form_type_repeat1] = STATE(67),
    [sym_name] = ACTIONS(374),
    [anon_sym_ATinheritdoc] = ACTIONS(376),
    [anon_sym_ATinheritDoc] = ACTIONS(376),
    [anon_sym_ATapi] = ACTIONS(376),
    [anon_sym_ATfilesource] = ACTIONS(376),
    [anon_sym_ATignore] = ACTIONS(376),
    [anon_sym_ATinternal] = ACTIONS(376),
    [anon_sym_ATcategory] = ACTIONS(376),
    [anon_sym_ATcopyright] = ACTIONS(376),
    [anon_sym_ATtodo] = ACTIONS(376),
    [anon_sym_ATexample] = ACTIONS(376),
    [anon_sym_ATlicense] = ACTIONS(376),
    [anon_sym_ATpackage] = ACTIONS(376),
    [anon_sym_ATsource] = ACTIONS(376),
    [anon_sym_ATsubpackage] = ACTIONS(376),
    [anon_sym_ATuses] = ACTIONS(376),
    [anon_sym_ATauthor] = ACTIONS(376),
    [anon_sym_ATglobal] = ACTIONS(376),
    [anon_sym_ATlink] = ACTIONS(376),
    [anon_sym_ATmethod] = ACTIONS(376),
    [anon_sym_ATparam] = ACTIONS(374),
    [anon_sym_ATproperty] = ACTIONS(374),
    [anon_sym_ATproperty_DASHread] = ACTIONS(376),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(376),
    [anon_sym_ATreturn] = ACTIONS(376),
    [anon_sym_ATsee] = ACTIONS(376),
    [anon_sym_ATthrows] = ACTIONS(376),
    [anon_sym_ATvar] = ACTIONS(376),
    [anon_sym_ATdeprecated] = ACTIONS(376),
    [anon_sym_ATsince] = ACTIONS(376),
    [anon_sym_ATversion] = ACTIONS(376),
    [anon_sym_ATtemplate] = ACTIONS(374),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(376),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(376),
    [anon_sym_of] = ACTIONS(374),
    [anon_sym_ATimplements] = ACTIONS(376),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(376),
    [anon_sym_ATextends] = ACTIONS(376),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(376),
    [anon_sym_ATuse] = ACTIONS(374),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(376),
    [anon_sym_ATafter] = ACTIONS(374),
    [anon_sym_ATafterClass] = ACTIONS(376),
    [anon_sym_ATannotation] = ACTIONS(376),
    [anon_sym_ATbackupGlobals] = ACTIONS(376),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(376),
    [anon_sym_ATbefore] = ACTIONS(374),
    [anon_sym_ATbeforeClass] = ACTIONS(376),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(374),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(376),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(376),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(376),
    [anon_sym_ATcovers] = ACTIONS(374),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(374),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(376),
    [anon_sym_ATcoversNothing] = ACTIONS(376),
    [anon_sym_ATdataProvider] = ACTIONS(376),
    [anon_sym_ATdepends] = ACTIONS(374),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(376),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(376),
    [anon_sym_ATgroup] = ACTIONS(376),
    [anon_sym_ATlarge] = ACTIONS(376),
    [anon_sym_ATmedium] = ACTIONS(376),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(376),
    [anon_sym_ATrequires] = ACTIONS(374),
    [anon_sym_ATrequiresusages] = ACTIONS(376),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(376),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(376),
    [anon_sym_ATsmall] = ACTIONS(376),
    [anon_sym_ATtest] = ACTIONS(374),
    [anon_sym_ATtestWith] = ACTIONS(376),
    [anon_sym_ATtestdox] = ACTIONS(376),
    [anon_sym_ATticket] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(374),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(374),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(374),
    [anon_sym_ATreadonly] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(376),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(376),
    [anon_sym_ATparam_DASHout] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(374),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(376),
    [anon_sym_ATmixin] = ACTIONS(376),
    [anon_sym_COMMA] = ACTIONS(376),
    [anon_sym_PIPE] = ACTIONS(378),
    [anon_sym_DOLLAR] = ACTIONS(376),
    [sym__end] = ACTIONS(376),
  },
  [65] = {
    [aux_sym_union_type_repeat1] = STATE(65),
    [sym_name] = ACTIONS(380),
    [anon_sym_ATinheritdoc] = ACTIONS(382),
    [anon_sym_ATinheritDoc] = ACTIONS(382),
    [anon_sym_ATapi] = ACTIONS(382),
    [anon_sym_ATfilesource] = ACTIONS(382),
    [anon_sym_ATignore] = ACTIONS(382),
    [anon_sym_ATinternal] = ACTIONS(382),
    [anon_sym_ATcategory] = ACTIONS(382),
    [anon_sym_ATcopyright] = ACTIONS(382),
    [anon_sym_ATtodo] = ACTIONS(382),
    [anon_sym_ATexample] = ACTIONS(382),
    [anon_sym_ATlicense] = ACTIONS(382),
    [anon_sym_ATpackage] = ACTIONS(382),
    [anon_sym_ATsource] = ACTIONS(382),
    [anon_sym_ATsubpackage] = ACTIONS(382),
    [anon_sym_ATuses] = ACTIONS(382),
    [anon_sym_ATauthor] = ACTIONS(382),
    [anon_sym_ATglobal] = ACTIONS(382),
    [anon_sym_ATlink] = ACTIONS(382),
    [anon_sym_ATmethod] = ACTIONS(382),
    [anon_sym_ATparam] = ACTIONS(380),
    [anon_sym_ATproperty] = ACTIONS(380),
    [anon_sym_ATproperty_DASHread] = ACTIONS(382),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(382),
    [anon_sym_ATreturn] = ACTIONS(382),
    [anon_sym_ATsee] = ACTIONS(382),
    [anon_sym_ATthrows] = ACTIONS(382),
    [anon_sym_ATvar] = ACTIONS(382),
    [anon_sym_ATdeprecated] = ACTIONS(382),
    [anon_sym_ATsince] = ACTIONS(382),
    [anon_sym_ATversion] = ACTIONS(382),
    [anon_sym_ATtemplate] = ACTIONS(380),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(382),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(382),
    [anon_sym_of] = ACTIONS(380),
    [anon_sym_ATimplements] = ACTIONS(382),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(382),
    [anon_sym_ATextends] = ACTIONS(382),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(382),
    [anon_sym_ATuse] = ACTIONS(380),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(382),
    [anon_sym_ATafter] = ACTIONS(380),
    [anon_sym_ATafterClass] = ACTIONS(382),
    [anon_sym_ATannotation] = ACTIONS(382),
    [anon_sym_ATbackupGlobals] = ACTIONS(382),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(382),
    [anon_sym_ATbefore] = ACTIONS(380),
    [anon_sym_ATbeforeClass] = ACTIONS(382),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(380),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(382),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(382),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(382),
    [anon_sym_ATcovers] = ACTIONS(380),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(380),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(382),
    [anon_sym_ATcoversNothing] = ACTIONS(382),
    [anon_sym_ATdataProvider] = ACTIONS(382),
    [anon_sym_ATdepends] = ACTIONS(380),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(382),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(382),
    [anon_sym_ATgroup] = ACTIONS(382),
    [anon_sym_ATlarge] = ACTIONS(382),
    [anon_sym_ATmedium] = ACTIONS(382),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(382),
    [anon_sym_ATrequires] = ACTIONS(380),
    [anon_sym_ATrequiresusages] = ACTIONS(382),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(382),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(382),
    [anon_sym_ATsmall] = ACTIONS(382),
    [anon_sym_ATtest] = ACTIONS(380),
    [anon_sym_ATtestWith] = ACTIONS(382),
    [anon_sym_ATtestdox] = ACTIONS(382),
    [anon_sym_ATticket] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(380),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(380),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(380),
    [anon_sym_ATreadonly] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(382),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(382),
    [anon_sym_ATparam_DASHout] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(380),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(382),
    [anon_sym_ATmixin] = ACTIONS(382),
    [anon_sym_COMMA] = ACTIONS(382),
    [anon_sym_PIPE] = ACTIONS(384),
    [anon_sym_DOLLAR] = ACTIONS(382),
    [sym__end] = ACTIONS(382),
  },
  [66] = {
    [aux_sym_union_type_repeat1] = STATE(65),
    [sym_name] = ACTIONS(387),
    [anon_sym_ATinheritdoc] = ACTIONS(389),
    [anon_sym_ATinheritDoc] = ACTIONS(389),
    [anon_sym_ATapi] = ACTIONS(389),
    [anon_sym_ATfilesource] = ACTIONS(389),
    [anon_sym_ATignore] = ACTIONS(389),
    [anon_sym_ATinternal] = ACTIONS(389),
    [anon_sym_ATcategory] = ACTIONS(389),
    [anon_sym_ATcopyright] = ACTIONS(389),
    [anon_sym_ATtodo] = ACTIONS(389),
    [anon_sym_ATexample] = ACTIONS(389),
    [anon_sym_ATlicense] = ACTIONS(389),
    [anon_sym_ATpackage] = ACTIONS(389),
    [anon_sym_ATsource] = ACTIONS(389),
    [anon_sym_ATsubpackage] = ACTIONS(389),
    [anon_sym_ATuses] = ACTIONS(389),
    [anon_sym_ATauthor] = ACTIONS(389),
    [anon_sym_ATglobal] = ACTIONS(389),
    [anon_sym_ATlink] = ACTIONS(389),
    [anon_sym_ATmethod] = ACTIONS(389),
    [anon_sym_ATparam] = ACTIONS(387),
    [anon_sym_ATproperty] = ACTIONS(387),
    [anon_sym_ATproperty_DASHread] = ACTIONS(389),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(389),
    [anon_sym_ATreturn] = ACTIONS(389),
    [anon_sym_ATsee] = ACTIONS(389),
    [anon_sym_ATthrows] = ACTIONS(389),
    [anon_sym_ATvar] = ACTIONS(389),
    [anon_sym_ATdeprecated] = ACTIONS(389),
    [anon_sym_ATsince] = ACTIONS(389),
    [anon_sym_ATversion] = ACTIONS(389),
    [anon_sym_ATtemplate] = ACTIONS(387),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(389),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(389),
    [anon_sym_of] = ACTIONS(387),
    [anon_sym_ATimplements] = ACTIONS(389),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(389),
    [anon_sym_ATextends] = ACTIONS(389),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(389),
    [anon_sym_ATuse] = ACTIONS(387),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(389),
    [anon_sym_ATafter] = ACTIONS(387),
    [anon_sym_ATafterClass] = ACTIONS(389),
    [anon_sym_ATannotation] = ACTIONS(389),
    [anon_sym_ATbackupGlobals] = ACTIONS(389),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(389),
    [anon_sym_ATbefore] = ACTIONS(387),
    [anon_sym_ATbeforeClass] = ACTIONS(389),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(387),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(389),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(389),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(389),
    [anon_sym_ATcovers] = ACTIONS(387),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(387),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(389),
    [anon_sym_ATcoversNothing] = ACTIONS(389),
    [anon_sym_ATdataProvider] = ACTIONS(389),
    [anon_sym_ATdepends] = ACTIONS(387),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(389),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(389),
    [anon_sym_ATgroup] = ACTIONS(389),
    [anon_sym_ATlarge] = ACTIONS(389),
    [anon_sym_ATmedium] = ACTIONS(389),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(389),
    [anon_sym_ATrequires] = ACTIONS(387),
    [anon_sym_ATrequiresusages] = ACTIONS(389),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(389),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(389),
    [anon_sym_ATsmall] = ACTIONS(389),
    [anon_sym_ATtest] = ACTIONS(387),
    [anon_sym_ATtestWith] = ACTIONS(389),
    [anon_sym_ATtestdox] = ACTIONS(389),
    [anon_sym_ATticket] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(387),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(387),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(387),
    [anon_sym_ATreadonly] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(389),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(389),
    [anon_sym_ATparam_DASHout] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(387),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(389),
    [anon_sym_ATmixin] = ACTIONS(389),
    [anon_sym_COMMA] = ACTIONS(389),
    [anon_sym_PIPE] = ACTIONS(391),
    [anon_sym_DOLLAR] = ACTIONS(389),
    [sym__end] = ACTIONS(389),
  },
  [67] = {
    [aux_sym_disjunctive_normal_form_type_repeat1] = STATE(67),
    [sym_name] = ACTIONS(393),
    [anon_sym_ATinheritdoc] = ACTIONS(395),
    [anon_sym_ATinheritDoc] = ACTIONS(395),
    [anon_sym_ATapi] = ACTIONS(395),
    [anon_sym_ATfilesource] = ACTIONS(395),
    [anon_sym_ATignore] = ACTIONS(395),
    [anon_sym_ATinternal] = ACTIONS(395),
    [anon_sym_ATcategory] = ACTIONS(395),
    [anon_sym_ATcopyright] = ACTIONS(395),
    [anon_sym_ATtodo] = ACTIONS(395),
    [anon_sym_ATexample] = ACTIONS(395),
    [anon_sym_ATlicense] = ACTIONS(395),
    [anon_sym_ATpackage] = ACTIONS(395),
    [anon_sym_ATsource] = ACTIONS(395),
    [anon_sym_ATsubpackage] = ACTIONS(395),
    [anon_sym_ATuses] = ACTIONS(395),
    [anon_sym_ATauthor] = ACTIONS(395),
    [anon_sym_ATglobal] = ACTIONS(395),
    [anon_sym_ATlink] = ACTIONS(395),
    [anon_sym_ATmethod] = ACTIONS(395),
    [anon_sym_ATparam] = ACTIONS(393),
    [anon_sym_ATproperty] = ACTIONS(393),
    [anon_sym_ATproperty_DASHread] = ACTIONS(395),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(395),
    [anon_sym_ATreturn] = ACTIONS(395),
    [anon_sym_ATsee] = ACTIONS(395),
    [anon_sym_ATthrows] = ACTIONS(395),
    [anon_sym_ATvar] = ACTIONS(395),
    [anon_sym_ATdeprecated] = ACTIONS(395),
    [anon_sym_ATsince] = ACTIONS(395),
    [anon_sym_ATversion] = ACTIONS(395),
    [anon_sym_ATtemplate] = ACTIONS(393),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(395),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(395),
    [anon_sym_of] = ACTIONS(393),
    [anon_sym_ATimplements] = ACTIONS(395),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(395),
    [anon_sym_ATextends] = ACTIONS(395),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(395),
    [anon_sym_ATuse] = ACTIONS(393),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(395),
    [anon_sym_ATafter] = ACTIONS(393),
    [anon_sym_ATafterClass] = ACTIONS(395),
    [anon_sym_ATannotation] = ACTIONS(395),
    [anon_sym_ATbackupGlobals] = ACTIONS(395),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(395),
    [anon_sym_ATbefore] = ACTIONS(393),
    [anon_sym_ATbeforeClass] = ACTIONS(395),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(393),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(395),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(395),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(395),
    [anon_sym_ATcovers] = ACTIONS(393),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(393),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(395),
    [anon_sym_ATcoversNothing] = ACTIONS(395),
    [anon_sym_ATdataProvider] = ACTIONS(395),
    [anon_sym_ATdepends] = ACTIONS(393),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(395),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(395),
    [anon_sym_ATgroup] = ACTIONS(395),
    [anon_sym_ATlarge] = ACTIONS(395),
    [anon_sym_ATmedium] = ACTIONS(395),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(395),
    [anon_sym_ATrequires] = ACTIONS(393),
    [anon_sym_ATrequiresusages] = ACTIONS(395),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(395),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(395),
    [anon_sym_ATsmall] = ACTIONS(395),
    [anon_sym_ATtest] = ACTIONS(393),
    [anon_sym_ATtestWith] = ACTIONS(395),
    [anon_sym_ATtestdox] = ACTIONS(395),
    [anon_sym_ATticket] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(393),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(393),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(393),
    [anon_sym_ATreadonly] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(395),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(395),
    [anon_sym_ATparam_DASHout] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(393),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(395),
    [anon_sym_ATmixin] = ACTIONS(395),
    [anon_sym_COMMA] = ACTIONS(395),
    [anon_sym_PIPE] = ACTIONS(397),
    [anon_sym_DOLLAR] = ACTIONS(395),
    [sym__end] = ACTIONS(395),
  },
  [68] = {
    [sym_name] = ACTIONS(365),
    [anon_sym_ATinheritdoc] = ACTIONS(367),
    [anon_sym_ATinheritDoc] = ACTIONS(367),
    [anon_sym_ATapi] = ACTIONS(367),
    [anon_sym_ATfilesource] = ACTIONS(367),
    [anon_sym_ATignore] = ACTIONS(367),
    [anon_sym_ATinternal] = ACTIONS(367),
    [anon_sym_ATcategory] = ACTIONS(367),
    [anon_sym_ATcopyright] = ACTIONS(367),
    [anon_sym_ATtodo] = ACTIONS(367),
    [anon_sym_ATexample] = ACTIONS(367),
    [anon_sym_ATlicense] = ACTIONS(367),
    [anon_sym_ATpackage] = ACTIONS(367),
    [anon_sym_ATsource] = ACTIONS(367),
    [anon_sym_ATsubpackage] = ACTIONS(367),
    [anon_sym_ATuses] = ACTIONS(367),
    [anon_sym_ATauthor] = ACTIONS(367),
    [anon_sym_ATglobal] = ACTIONS(367),
    [anon_sym_ATlink] = ACTIONS(367),
    [anon_sym_ATmethod] = ACTIONS(367),
    [anon_sym_ATparam] = ACTIONS(365),
    [anon_sym_ATproperty] = ACTIONS(365),
    [anon_sym_ATproperty_DASHread] = ACTIONS(367),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(367),
    [anon_sym_ATreturn] = ACTIONS(367),
    [anon_sym_ATsee] = ACTIONS(367),
    [anon_sym_ATthrows] = ACTIONS(367),
    [anon_sym_ATvar] = ACTIONS(367),
    [anon_sym_ATdeprecated] = ACTIONS(367),
    [anon_sym_ATsince] = ACTIONS(367),
    [anon_sym_ATversion] = ACTIONS(367),
    [anon_sym_ATtemplate] = ACTIONS(365),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(367),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(367),
    [anon_sym_of] = ACTIONS(365),
    [anon_sym_ATimplements] = ACTIONS(367),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(367),
    [anon_sym_ATextends] = ACTIONS(367),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(367),
    [anon_sym_ATuse] = ACTIONS(365),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(367),
    [anon_sym_ATafter] = ACTIONS(365),
    [anon_sym_ATafterClass] = ACTIONS(367),
    [anon_sym_ATannotation] = ACTIONS(367),
    [anon_sym_ATbackupGlobals] = ACTIONS(367),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(367),
    [anon_sym_ATbefore] = ACTIONS(365),
    [anon_sym_ATbeforeClass] = ACTIONS(367),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(365),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(367),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(367),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(367),
    [anon_sym_ATcovers] = ACTIONS(365),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(365),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(367),
    [anon_sym_ATcoversNothing] = ACTIONS(367),
    [anon_sym_ATdataProvider] = ACTIONS(367),
    [anon_sym_ATdepends] = ACTIONS(365),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(367),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(367),
    [anon_sym_ATgroup] = ACTIONS(367),
    [anon_sym_ATlarge] = ACTIONS(367),
    [anon_sym_ATmedium] = ACTIONS(367),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(367),
    [anon_sym_ATrequires] = ACTIONS(365),
    [anon_sym_ATrequiresusages] = ACTIONS(367),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(367),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(367),
    [anon_sym_ATsmall] = ACTIONS(367),
    [anon_sym_ATtest] = ACTIONS(365),
    [anon_sym_ATtestWith] = ACTIONS(367),
    [anon_sym_ATtestdox] = ACTIONS(367),
    [anon_sym_ATticket] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(365),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(365),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(365),
    [anon_sym_ATreadonly] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(367),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(367),
    [anon_sym_ATparam_DASHout] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(365),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(367),
    [anon_sym_ATmixin] = ACTIONS(367),
    [anon_sym_COMMA] = ACTIONS(367),
    [anon_sym_AMP] = ACTIONS(367),
    [anon_sym_RPAREN] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(367),
    [sym__end] = ACTIONS(367),
  },
  [69] = {
    [aux_sym_disjunctive_normal_form_type_repeat1] = STATE(64),
    [sym_name] = ACTIONS(400),
    [anon_sym_ATinheritdoc] = ACTIONS(402),
    [anon_sym_ATinheritDoc] = ACTIONS(402),
    [anon_sym_ATapi] = ACTIONS(402),
    [anon_sym_ATfilesource] = ACTIONS(402),
    [anon_sym_ATignore] = ACTIONS(402),
    [anon_sym_ATinternal] = ACTIONS(402),
    [anon_sym_ATcategory] = ACTIONS(402),
    [anon_sym_ATcopyright] = ACTIONS(402),
    [anon_sym_ATtodo] = ACTIONS(402),
    [anon_sym_ATexample] = ACTIONS(402),
    [anon_sym_ATlicense] = ACTIONS(402),
    [anon_sym_ATpackage] = ACTIONS(402),
    [anon_sym_ATsource] = ACTIONS(402),
    [anon_sym_ATsubpackage] = ACTIONS(402),
    [anon_sym_ATuses] = ACTIONS(402),
    [anon_sym_ATauthor] = ACTIONS(402),
    [anon_sym_ATglobal] = ACTIONS(402),
    [anon_sym_ATlink] = ACTIONS(402),
    [anon_sym_ATmethod] = ACTIONS(402),
    [anon_sym_ATparam] = ACTIONS(400),
    [anon_sym_ATproperty] = ACTIONS(400),
    [anon_sym_ATproperty_DASHread] = ACTIONS(402),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(402),
    [anon_sym_ATreturn] = ACTIONS(402),
    [anon_sym_ATsee] = ACTIONS(402),
    [anon_sym_ATthrows] = ACTIONS(402),
    [anon_sym_ATvar] = ACTIONS(402),
    [anon_sym_ATdeprecated] = ACTIONS(402),
    [anon_sym_ATsince] = ACTIONS(402),
    [anon_sym_ATversion] = ACTIONS(402),
    [anon_sym_ATtemplate] = ACTIONS(400),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(402),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(402),
    [anon_sym_of] = ACTIONS(400),
    [anon_sym_ATimplements] = ACTIONS(402),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(402),
    [anon_sym_ATextends] = ACTIONS(402),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(402),
    [anon_sym_ATuse] = ACTIONS(400),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(402),
    [anon_sym_ATafter] = ACTIONS(400),
    [anon_sym_ATafterClass] = ACTIONS(402),
    [anon_sym_ATannotation] = ACTIONS(402),
    [anon_sym_ATbackupGlobals] = ACTIONS(402),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(402),
    [anon_sym_ATbefore] = ACTIONS(400),
    [anon_sym_ATbeforeClass] = ACTIONS(402),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(400),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(402),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(402),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(402),
    [anon_sym_ATcovers] = ACTIONS(400),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(400),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(402),
    [anon_sym_ATcoversNothing] = ACTIONS(402),
    [anon_sym_ATdataProvider] = ACTIONS(402),
    [anon_sym_ATdepends] = ACTIONS(400),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(402),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(402),
    [anon_sym_ATgroup] = ACTIONS(402),
    [anon_sym_ATlarge] = ACTIONS(402),
    [anon_sym_ATmedium] = ACTIONS(402),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(402),
    [anon_sym_ATrequires] = ACTIONS(400),
    [anon_sym_ATrequiresusages] = ACTIONS(402),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(402),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(402),
    [anon_sym_ATsmall] = ACTIONS(402),
    [anon_sym_ATtest] = ACTIONS(400),
    [anon_sym_ATtestWith] = ACTIONS(402),
    [anon_sym_ATtestdox] = ACTIONS(402),
    [anon_sym_ATticket] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(400),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(400),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(400),
    [anon_sym_ATreadonly] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(402),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(402),
    [anon_sym_ATparam_DASHout] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(400),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(402),
    [anon_sym_ATmixin] = ACTIONS(402),
    [anon_sym_COMMA] = ACTIONS(402),
    [anon_sym_PIPE] = ACTIONS(378),
    [anon_sym_DOLLAR] = ACTIONS(402),
    [sym__end] = ACTIONS(402),
  },
  [70] = {
    [aux_sym_namespace_name_repeat1] = STATE(323),
    [anon_sym_LBRACE] = ACTIONS(191),
    [anon_sym_ATinheritdoc] = ACTIONS(191),
    [anon_sym_ATinheritDoc] = ACTIONS(191),
    [anon_sym_ATapi] = ACTIONS(191),
    [anon_sym_ATfilesource] = ACTIONS(191),
    [anon_sym_ATignore] = ACTIONS(191),
    [anon_sym_ATinternal] = ACTIONS(191),
    [anon_sym_ATcategory] = ACTIONS(191),
    [anon_sym_ATcopyright] = ACTIONS(191),
    [anon_sym_ATtodo] = ACTIONS(191),
    [anon_sym_ATexample] = ACTIONS(191),
    [anon_sym_ATlicense] = ACTIONS(191),
    [anon_sym_ATpackage] = ACTIONS(191),
    [anon_sym_ATsource] = ACTIONS(191),
    [anon_sym_ATsubpackage] = ACTIONS(191),
    [anon_sym_ATuses] = ACTIONS(191),
    [anon_sym_ATauthor] = ACTIONS(191),
    [anon_sym_LT] = ACTIONS(191),
    [anon_sym_ATglobal] = ACTIONS(191),
    [anon_sym_ATlink] = ACTIONS(191),
    [anon_sym_ATmethod] = ACTIONS(191),
    [anon_sym_ATparam] = ACTIONS(189),
    [anon_sym_ATproperty] = ACTIONS(189),
    [anon_sym_ATproperty_DASHread] = ACTIONS(191),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(191),
    [anon_sym_ATreturn] = ACTIONS(191),
    [anon_sym_ATsee] = ACTIONS(191),
    [anon_sym_ATthrows] = ACTIONS(191),
    [anon_sym_ATvar] = ACTIONS(191),
    [anon_sym_ATdeprecated] = ACTIONS(191),
    [anon_sym_ATsince] = ACTIONS(191),
    [anon_sym_ATversion] = ACTIONS(191),
    [anon_sym_ATtemplate] = ACTIONS(189),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(191),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(191),
    [anon_sym_ATimplements] = ACTIONS(191),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(191),
    [anon_sym_ATextends] = ACTIONS(191),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(191),
    [anon_sym_ATuse] = ACTIONS(189),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(191),
    [anon_sym_ATafter] = ACTIONS(189),
    [anon_sym_ATafterClass] = ACTIONS(191),
    [anon_sym_ATannotation] = ACTIONS(191),
    [anon_sym_ATbackupGlobals] = ACTIONS(191),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(191),
    [anon_sym_ATbefore] = ACTIONS(189),
    [anon_sym_ATbeforeClass] = ACTIONS(191),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(189),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(191),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(191),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(191),
    [anon_sym_ATcovers] = ACTIONS(189),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(189),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(191),
    [anon_sym_ATcoversNothing] = ACTIONS(191),
    [anon_sym_ATdataProvider] = ACTIONS(191),
    [anon_sym_ATdepends] = ACTIONS(189),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(191),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(191),
    [anon_sym_ATgroup] = ACTIONS(191),
    [anon_sym_ATlarge] = ACTIONS(191),
    [anon_sym_ATmedium] = ACTIONS(191),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(191),
    [anon_sym_ATrequires] = ACTIONS(189),
    [anon_sym_ATrequiresusages] = ACTIONS(191),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(191),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(191),
    [anon_sym_ATsmall] = ACTIONS(191),
    [anon_sym_ATtest] = ACTIONS(189),
    [anon_sym_ATtestWith] = ACTIONS(191),
    [anon_sym_ATtestdox] = ACTIONS(191),
    [anon_sym_ATticket] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(189),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(189),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(189),
    [anon_sym_ATreadonly] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(191),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(191),
    [anon_sym_ATparam_DASHout] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(189),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(191),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(191),
    [anon_sym_ATmixin] = ACTIONS(191),
    [anon_sym_BSLASH] = ACTIONS(186),
    [anon_sym_COLON_COLON] = ACTIONS(191),
    [sym__end] = ACTIONS(191),
    [sym_text] = ACTIONS(191),
  },
  [71] = {
    [aux_sym_namespace_name_repeat1] = STATE(323),
    [anon_sym_LBRACE] = ACTIONS(184),
    [anon_sym_ATinheritdoc] = ACTIONS(184),
    [anon_sym_ATinheritDoc] = ACTIONS(184),
    [anon_sym_ATapi] = ACTIONS(184),
    [anon_sym_ATfilesource] = ACTIONS(184),
    [anon_sym_ATignore] = ACTIONS(184),
    [anon_sym_ATinternal] = ACTIONS(184),
    [anon_sym_ATcategory] = ACTIONS(184),
    [anon_sym_ATcopyright] = ACTIONS(184),
    [anon_sym_ATtodo] = ACTIONS(184),
    [anon_sym_ATexample] = ACTIONS(184),
    [anon_sym_ATlicense] = ACTIONS(184),
    [anon_sym_ATpackage] = ACTIONS(184),
    [anon_sym_ATsource] = ACTIONS(184),
    [anon_sym_ATsubpackage] = ACTIONS(184),
    [anon_sym_ATuses] = ACTIONS(184),
    [anon_sym_ATauthor] = ACTIONS(184),
    [anon_sym_LT] = ACTIONS(184),
    [anon_sym_ATglobal] = ACTIONS(184),
    [anon_sym_ATlink] = ACTIONS(184),
    [anon_sym_ATmethod] = ACTIONS(184),
    [anon_sym_ATparam] = ACTIONS(182),
    [anon_sym_ATproperty] = ACTIONS(182),
    [anon_sym_ATproperty_DASHread] = ACTIONS(184),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(184),
    [anon_sym_ATreturn] = ACTIONS(184),
    [anon_sym_ATsee] = ACTIONS(184),
    [anon_sym_ATthrows] = ACTIONS(184),
    [anon_sym_ATvar] = ACTIONS(184),
    [anon_sym_ATdeprecated] = ACTIONS(184),
    [anon_sym_ATsince] = ACTIONS(184),
    [anon_sym_ATversion] = ACTIONS(184),
    [anon_sym_ATtemplate] = ACTIONS(182),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(184),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(184),
    [anon_sym_ATimplements] = ACTIONS(184),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(184),
    [anon_sym_ATextends] = ACTIONS(184),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(184),
    [anon_sym_ATuse] = ACTIONS(182),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(184),
    [anon_sym_ATafter] = ACTIONS(182),
    [anon_sym_ATafterClass] = ACTIONS(184),
    [anon_sym_ATannotation] = ACTIONS(184),
    [anon_sym_ATbackupGlobals] = ACTIONS(184),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(184),
    [anon_sym_ATbefore] = ACTIONS(182),
    [anon_sym_ATbeforeClass] = ACTIONS(184),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(182),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(184),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(184),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(184),
    [anon_sym_ATcovers] = ACTIONS(182),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(182),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(184),
    [anon_sym_ATcoversNothing] = ACTIONS(184),
    [anon_sym_ATdataProvider] = ACTIONS(184),
    [anon_sym_ATdepends] = ACTIONS(182),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(184),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(184),
    [anon_sym_ATgroup] = ACTIONS(184),
    [anon_sym_ATlarge] = ACTIONS(184),
    [anon_sym_ATmedium] = ACTIONS(184),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(184),
    [anon_sym_ATrequires] = ACTIONS(182),
    [anon_sym_ATrequiresusages] = ACTIONS(184),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(184),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(184),
    [anon_sym_ATsmall] = ACTIONS(184),
    [anon_sym_ATtest] = ACTIONS(182),
    [anon_sym_ATtestWith] = ACTIONS(184),
    [anon_sym_ATtestdox] = ACTIONS(184),
    [anon_sym_ATticket] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(182),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(182),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(182),
    [anon_sym_ATreadonly] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(184),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(184),
    [anon_sym_ATparam_DASHout] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(182),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(184),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(184),
    [anon_sym_ATmixin] = ACTIONS(184),
    [anon_sym_BSLASH] = ACTIONS(186),
    [anon_sym_COLON_COLON] = ACTIONS(184),
    [sym__end] = ACTIONS(184),
    [sym_text] = ACTIONS(184),
  },
  [72] = {
    [aux_sym_disjunctive_normal_form_type_repeat1] = STATE(67),
    [sym_name] = ACTIONS(404),
    [anon_sym_ATinheritdoc] = ACTIONS(406),
    [anon_sym_ATinheritDoc] = ACTIONS(406),
    [anon_sym_ATapi] = ACTIONS(406),
    [anon_sym_ATfilesource] = ACTIONS(406),
    [anon_sym_ATignore] = ACTIONS(406),
    [anon_sym_ATinternal] = ACTIONS(406),
    [anon_sym_ATcategory] = ACTIONS(406),
    [anon_sym_ATcopyright] = ACTIONS(406),
    [anon_sym_ATtodo] = ACTIONS(406),
    [anon_sym_ATexample] = ACTIONS(406),
    [anon_sym_ATlicense] = ACTIONS(406),
    [anon_sym_ATpackage] = ACTIONS(406),
    [anon_sym_ATsource] = ACTIONS(406),
    [anon_sym_ATsubpackage] = ACTIONS(406),
    [anon_sym_ATuses] = ACTIONS(406),
    [anon_sym_ATauthor] = ACTIONS(406),
    [anon_sym_ATglobal] = ACTIONS(406),
    [anon_sym_ATlink] = ACTIONS(406),
    [anon_sym_ATmethod] = ACTIONS(406),
    [anon_sym_ATparam] = ACTIONS(404),
    [anon_sym_ATproperty] = ACTIONS(404),
    [anon_sym_ATproperty_DASHread] = ACTIONS(406),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(406),
    [anon_sym_ATreturn] = ACTIONS(406),
    [anon_sym_ATsee] = ACTIONS(406),
    [anon_sym_ATthrows] = ACTIONS(406),
    [anon_sym_ATvar] = ACTIONS(406),
    [anon_sym_ATdeprecated] = ACTIONS(406),
    [anon_sym_ATsince] = ACTIONS(406),
    [anon_sym_ATversion] = ACTIONS(406),
    [anon_sym_ATtemplate] = ACTIONS(404),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(406),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(406),
    [anon_sym_of] = ACTIONS(404),
    [anon_sym_ATimplements] = ACTIONS(406),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(406),
    [anon_sym_ATextends] = ACTIONS(406),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(406),
    [anon_sym_ATuse] = ACTIONS(404),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(406),
    [anon_sym_ATafter] = ACTIONS(404),
    [anon_sym_ATafterClass] = ACTIONS(406),
    [anon_sym_ATannotation] = ACTIONS(406),
    [anon_sym_ATbackupGlobals] = ACTIONS(406),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(406),
    [anon_sym_ATbefore] = ACTIONS(404),
    [anon_sym_ATbeforeClass] = ACTIONS(406),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(404),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(406),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(406),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(406),
    [anon_sym_ATcovers] = ACTIONS(404),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(404),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(406),
    [anon_sym_ATcoversNothing] = ACTIONS(406),
    [anon_sym_ATdataProvider] = ACTIONS(406),
    [anon_sym_ATdepends] = ACTIONS(404),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(406),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(406),
    [anon_sym_ATgroup] = ACTIONS(406),
    [anon_sym_ATlarge] = ACTIONS(406),
    [anon_sym_ATmedium] = ACTIONS(406),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(406),
    [anon_sym_ATrequires] = ACTIONS(404),
    [anon_sym_ATrequiresusages] = ACTIONS(406),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(406),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(406),
    [anon_sym_ATsmall] = ACTIONS(406),
    [anon_sym_ATtest] = ACTIONS(404),
    [anon_sym_ATtestWith] = ACTIONS(406),
    [anon_sym_ATtestdox] = ACTIONS(406),
    [anon_sym_ATticket] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(404),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(404),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(404),
    [anon_sym_ATreadonly] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(406),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(406),
    [anon_sym_ATparam_DASHout] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(404),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(406),
    [anon_sym_ATmixin] = ACTIONS(406),
    [anon_sym_COMMA] = ACTIONS(406),
    [anon_sym_PIPE] = ACTIONS(378),
    [anon_sym_DOLLAR] = ACTIONS(406),
    [sym__end] = ACTIONS(406),
  },
  [73] = {
    [anon_sym_LBRACE] = ACTIONS(330),
    [anon_sym_ATinheritdoc] = ACTIONS(330),
    [anon_sym_ATinheritDoc] = ACTIONS(330),
    [anon_sym_ATapi] = ACTIONS(330),
    [anon_sym_ATfilesource] = ACTIONS(330),
    [anon_sym_ATignore] = ACTIONS(330),
    [anon_sym_ATinternal] = ACTIONS(330),
    [anon_sym_ATcategory] = ACTIONS(330),
    [anon_sym_ATcopyright] = ACTIONS(330),
    [anon_sym_ATtodo] = ACTIONS(330),
    [anon_sym_ATexample] = ACTIONS(330),
    [anon_sym_ATlicense] = ACTIONS(330),
    [anon_sym_ATpackage] = ACTIONS(330),
    [anon_sym_ATsource] = ACTIONS(330),
    [anon_sym_ATsubpackage] = ACTIONS(330),
    [anon_sym_ATuses] = ACTIONS(330),
    [anon_sym_ATauthor] = ACTIONS(330),
    [anon_sym_ATglobal] = ACTIONS(330),
    [anon_sym_ATlink] = ACTIONS(330),
    [anon_sym_ATmethod] = ACTIONS(330),
    [anon_sym_ATparam] = ACTIONS(328),
    [anon_sym_ATproperty] = ACTIONS(328),
    [anon_sym_ATproperty_DASHread] = ACTIONS(330),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(330),
    [anon_sym_ATreturn] = ACTIONS(330),
    [anon_sym_ATsee] = ACTIONS(330),
    [anon_sym_ATthrows] = ACTIONS(330),
    [anon_sym_ATvar] = ACTIONS(330),
    [anon_sym_ATdeprecated] = ACTIONS(330),
    [anon_sym_ATsince] = ACTIONS(330),
    [anon_sym_ATversion] = ACTIONS(330),
    [anon_sym_ATtemplate] = ACTIONS(328),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(330),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(330),
    [anon_sym_ATimplements] = ACTIONS(330),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(330),
    [anon_sym_ATextends] = ACTIONS(330),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(330),
    [anon_sym_ATuse] = ACTIONS(328),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(330),
    [anon_sym_ATafter] = ACTIONS(328),
    [anon_sym_ATafterClass] = ACTIONS(330),
    [anon_sym_ATannotation] = ACTIONS(330),
    [anon_sym_ATbackupGlobals] = ACTIONS(330),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(330),
    [anon_sym_ATbefore] = ACTIONS(328),
    [anon_sym_ATbeforeClass] = ACTIONS(330),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(328),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(330),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(330),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(330),
    [anon_sym_ATcovers] = ACTIONS(328),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(328),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(330),
    [anon_sym_ATcoversNothing] = ACTIONS(330),
    [anon_sym_ATdataProvider] = ACTIONS(330),
    [anon_sym_ATdepends] = ACTIONS(328),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(330),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(330),
    [anon_sym_ATgroup] = ACTIONS(330),
    [anon_sym_ATlarge] = ACTIONS(330),
    [anon_sym_ATmedium] = ACTIONS(330),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(330),
    [anon_sym_ATrequires] = ACTIONS(328),
    [anon_sym_ATrequiresusages] = ACTIONS(330),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(330),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(330),
    [anon_sym_ATsmall] = ACTIONS(330),
    [anon_sym_ATtest] = ACTIONS(328),
    [anon_sym_ATtestWith] = ACTIONS(330),
    [anon_sym_ATtestdox] = ACTIONS(330),
    [anon_sym_ATticket] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(328),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(328),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(328),
    [anon_sym_ATreadonly] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(330),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(330),
    [anon_sym_ATparam_DASHout] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(328),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(330),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(330),
    [anon_sym_ATmixin] = ACTIONS(330),
    [anon_sym_PIPE] = ACTIONS(330),
    [anon_sym_AMP] = ACTIONS(330),
    [anon_sym_DOLLAR] = ACTIONS(330),
    [sym__end] = ACTIONS(330),
    [sym__text_after_type] = ACTIONS(330),
  },
  [74] = {
    [sym_name] = ACTIONS(393),
    [anon_sym_ATinheritdoc] = ACTIONS(395),
    [anon_sym_ATinheritDoc] = ACTIONS(395),
    [anon_sym_ATapi] = ACTIONS(395),
    [anon_sym_ATfilesource] = ACTIONS(395),
    [anon_sym_ATignore] = ACTIONS(395),
    [anon_sym_ATinternal] = ACTIONS(395),
    [anon_sym_ATcategory] = ACTIONS(395),
    [anon_sym_ATcopyright] = ACTIONS(395),
    [anon_sym_ATtodo] = ACTIONS(395),
    [anon_sym_ATexample] = ACTIONS(395),
    [anon_sym_ATlicense] = ACTIONS(395),
    [anon_sym_ATpackage] = ACTIONS(395),
    [anon_sym_ATsource] = ACTIONS(395),
    [anon_sym_ATsubpackage] = ACTIONS(395),
    [anon_sym_ATuses] = ACTIONS(395),
    [anon_sym_ATauthor] = ACTIONS(395),
    [anon_sym_ATglobal] = ACTIONS(395),
    [anon_sym_ATlink] = ACTIONS(395),
    [anon_sym_ATmethod] = ACTIONS(395),
    [anon_sym_ATparam] = ACTIONS(393),
    [anon_sym_ATproperty] = ACTIONS(393),
    [anon_sym_ATproperty_DASHread] = ACTIONS(395),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(395),
    [anon_sym_ATreturn] = ACTIONS(395),
    [anon_sym_ATsee] = ACTIONS(395),
    [anon_sym_ATthrows] = ACTIONS(395),
    [anon_sym_ATvar] = ACTIONS(395),
    [anon_sym_ATdeprecated] = ACTIONS(395),
    [anon_sym_ATsince] = ACTIONS(395),
    [anon_sym_ATversion] = ACTIONS(395),
    [anon_sym_ATtemplate] = ACTIONS(393),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(395),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(395),
    [anon_sym_of] = ACTIONS(393),
    [anon_sym_ATimplements] = ACTIONS(395),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(395),
    [anon_sym_ATextends] = ACTIONS(395),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(395),
    [anon_sym_ATuse] = ACTIONS(393),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(395),
    [anon_sym_ATafter] = ACTIONS(393),
    [anon_sym_ATafterClass] = ACTIONS(395),
    [anon_sym_ATannotation] = ACTIONS(395),
    [anon_sym_ATbackupGlobals] = ACTIONS(395),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(395),
    [anon_sym_ATbefore] = ACTIONS(393),
    [anon_sym_ATbeforeClass] = ACTIONS(395),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(393),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(395),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(395),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(395),
    [anon_sym_ATcovers] = ACTIONS(393),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(393),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(395),
    [anon_sym_ATcoversNothing] = ACTIONS(395),
    [anon_sym_ATdataProvider] = ACTIONS(395),
    [anon_sym_ATdepends] = ACTIONS(393),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(395),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(395),
    [anon_sym_ATgroup] = ACTIONS(395),
    [anon_sym_ATlarge] = ACTIONS(395),
    [anon_sym_ATmedium] = ACTIONS(395),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(395),
    [anon_sym_ATrequires] = ACTIONS(393),
    [anon_sym_ATrequiresusages] = ACTIONS(395),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(395),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(395),
    [anon_sym_ATsmall] = ACTIONS(395),
    [anon_sym_ATtest] = ACTIONS(393),
    [anon_sym_ATtestWith] = ACTIONS(395),
    [anon_sym_ATtestdox] = ACTIONS(395),
    [anon_sym_ATticket] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(393),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(393),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(393),
    [anon_sym_ATreadonly] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(395),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(395),
    [anon_sym_ATparam_DASHout] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(393),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(395),
    [anon_sym_ATmixin] = ACTIONS(395),
    [anon_sym_COMMA] = ACTIONS(395),
    [anon_sym_PIPE] = ACTIONS(395),
    [anon_sym_DOLLAR] = ACTIONS(395),
    [sym__end] = ACTIONS(395),
  },
  [75] = {
    [sym_description] = STATE(179),
    [sym_inline_tag] = STATE(116),
    [aux_sym_description_repeat1] = STATE(116),
    [anon_sym_LBRACE] = ACTIONS(5),
    [anon_sym_ATinheritdoc] = ACTIONS(408),
    [anon_sym_ATinheritDoc] = ACTIONS(408),
    [anon_sym_ATapi] = ACTIONS(408),
    [anon_sym_ATfilesource] = ACTIONS(408),
    [anon_sym_ATignore] = ACTIONS(408),
    [anon_sym_ATinternal] = ACTIONS(408),
    [anon_sym_ATcategory] = ACTIONS(408),
    [anon_sym_ATcopyright] = ACTIONS(408),
    [anon_sym_ATtodo] = ACTIONS(408),
    [anon_sym_ATexample] = ACTIONS(408),
    [anon_sym_ATlicense] = ACTIONS(408),
    [anon_sym_ATpackage] = ACTIONS(408),
    [anon_sym_ATsource] = ACTIONS(408),
    [anon_sym_ATsubpackage] = ACTIONS(408),
    [anon_sym_ATuses] = ACTIONS(408),
    [anon_sym_ATauthor] = ACTIONS(408),
    [anon_sym_ATglobal] = ACTIONS(408),
    [anon_sym_ATlink] = ACTIONS(408),
    [anon_sym_ATmethod] = ACTIONS(408),
    [anon_sym_ATparam] = ACTIONS(410),
    [anon_sym_ATproperty] = ACTIONS(410),
    [anon_sym_ATproperty_DASHread] = ACTIONS(408),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(408),
    [anon_sym_ATreturn] = ACTIONS(408),
    [anon_sym_ATsee] = ACTIONS(408),
    [anon_sym_ATthrows] = ACTIONS(408),
    [anon_sym_ATvar] = ACTIONS(408),
    [anon_sym_ATdeprecated] = ACTIONS(408),
    [anon_sym_ATsince] = ACTIONS(408),
    [anon_sym_ATversion] = ACTIONS(408),
    [anon_sym_ATtemplate] = ACTIONS(410),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(408),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(408),
    [anon_sym_ATimplements] = ACTIONS(408),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(408),
    [anon_sym_ATextends] = ACTIONS(408),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(408),
    [anon_sym_ATuse] = ACTIONS(410),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(408),
    [anon_sym_ATafter] = ACTIONS(410),
    [anon_sym_ATafterClass] = ACTIONS(408),
    [anon_sym_ATannotation] = ACTIONS(408),
    [anon_sym_ATbackupGlobals] = ACTIONS(408),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(408),
    [anon_sym_ATbefore] = ACTIONS(410),
    [anon_sym_ATbeforeClass] = ACTIONS(408),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(410),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(408),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(408),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(408),
    [anon_sym_ATcovers] = ACTIONS(410),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(410),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(408),
    [anon_sym_ATcoversNothing] = ACTIONS(408),
    [anon_sym_ATdataProvider] = ACTIONS(408),
    [anon_sym_ATdepends] = ACTIONS(410),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(408),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(408),
    [anon_sym_ATgroup] = ACTIONS(408),
    [anon_sym_ATlarge] = ACTIONS(408),
    [anon_sym_ATmedium] = ACTIONS(408),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(408),
    [anon_sym_ATrequires] = ACTIONS(410),
    [anon_sym_ATrequiresusages] = ACTIONS(408),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(408),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(408),
    [anon_sym_ATsmall] = ACTIONS(408),
    [anon_sym_ATtest] = ACTIONS(410),
    [anon_sym_ATtestWith] = ACTIONS(408),
    [anon_sym_ATtestdox] = ACTIONS(408),
    [anon_sym_ATticket] = ACTIONS(408),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(408),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(408),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(408),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(410),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(408),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(410),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(408),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(408),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(408),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(408),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(408),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(408),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(408),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(408),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(408),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(410),
    [anon_sym_ATreadonly] = ACTIONS(408),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(408),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(408),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(408),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(408),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(408),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(408),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(408),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(408),
    [anon_sym_ATparam_DASHout] = ACTIONS(408),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(408),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(410),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(408),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(408),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(408),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(408),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(408),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(408),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(408),
    [anon_sym_ATmixin] = ACTIONS(408),
    [sym__end] = ACTIONS(408),
    [sym_text] = ACTIONS(75),
  },
  [76] = {
    [sym__description_after_type] = STATE(184),
    [sym_inline_tag] = STATE(139),
    [aux_sym__description_after_type_repeat1] = STATE(124),
    [anon_sym_LBRACE] = ACTIONS(351),
    [anon_sym_ATinheritdoc] = ACTIONS(412),
    [anon_sym_ATinheritDoc] = ACTIONS(412),
    [anon_sym_ATapi] = ACTIONS(412),
    [anon_sym_ATfilesource] = ACTIONS(412),
    [anon_sym_ATignore] = ACTIONS(412),
    [anon_sym_ATinternal] = ACTIONS(412),
    [anon_sym_ATcategory] = ACTIONS(412),
    [anon_sym_ATcopyright] = ACTIONS(412),
    [anon_sym_ATtodo] = ACTIONS(412),
    [anon_sym_ATexample] = ACTIONS(412),
    [anon_sym_ATlicense] = ACTIONS(412),
    [anon_sym_ATpackage] = ACTIONS(412),
    [anon_sym_ATsource] = ACTIONS(412),
    [anon_sym_ATsubpackage] = ACTIONS(412),
    [anon_sym_ATuses] = ACTIONS(412),
    [anon_sym_ATauthor] = ACTIONS(412),
    [anon_sym_ATglobal] = ACTIONS(412),
    [anon_sym_ATlink] = ACTIONS(412),
    [anon_sym_ATmethod] = ACTIONS(412),
    [anon_sym_ATparam] = ACTIONS(414),
    [anon_sym_ATproperty] = ACTIONS(414),
    [anon_sym_ATproperty_DASHread] = ACTIONS(412),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(412),
    [anon_sym_ATreturn] = ACTIONS(412),
    [anon_sym_ATsee] = ACTIONS(412),
    [anon_sym_ATthrows] = ACTIONS(412),
    [anon_sym_ATvar] = ACTIONS(412),
    [anon_sym_ATdeprecated] = ACTIONS(412),
    [anon_sym_ATsince] = ACTIONS(412),
    [anon_sym_ATversion] = ACTIONS(412),
    [anon_sym_ATtemplate] = ACTIONS(414),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(412),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(412),
    [anon_sym_ATimplements] = ACTIONS(412),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(412),
    [anon_sym_ATextends] = ACTIONS(412),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(412),
    [anon_sym_ATuse] = ACTIONS(414),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(412),
    [anon_sym_ATafter] = ACTIONS(414),
    [anon_sym_ATafterClass] = ACTIONS(412),
    [anon_sym_ATannotation] = ACTIONS(412),
    [anon_sym_ATbackupGlobals] = ACTIONS(412),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(412),
    [anon_sym_ATbefore] = ACTIONS(414),
    [anon_sym_ATbeforeClass] = ACTIONS(412),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(414),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(412),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(412),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(412),
    [anon_sym_ATcovers] = ACTIONS(414),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(414),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(412),
    [anon_sym_ATcoversNothing] = ACTIONS(412),
    [anon_sym_ATdataProvider] = ACTIONS(412),
    [anon_sym_ATdepends] = ACTIONS(414),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(412),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(412),
    [anon_sym_ATgroup] = ACTIONS(412),
    [anon_sym_ATlarge] = ACTIONS(412),
    [anon_sym_ATmedium] = ACTIONS(412),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(412),
    [anon_sym_ATrequires] = ACTIONS(414),
    [anon_sym_ATrequiresusages] = ACTIONS(412),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(412),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(412),
    [anon_sym_ATsmall] = ACTIONS(412),
    [anon_sym_ATtest] = ACTIONS(414),
    [anon_sym_ATtestWith] = ACTIONS(412),
    [anon_sym_ATtestdox] = ACTIONS(412),
    [anon_sym_ATticket] = ACTIONS(412),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(412),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(412),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(412),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(414),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(412),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(414),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(412),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(412),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(412),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(412),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(412),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(412),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(412),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(412),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(412),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(414),
    [anon_sym_ATreadonly] = ACTIONS(412),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(412),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(412),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(412),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(412),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(412),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(412),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(412),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(412),
    [anon_sym_ATparam_DASHout] = ACTIONS(412),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(412),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(414),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(412),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(412),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(412),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(412),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(412),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(412),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(412),
    [anon_sym_ATmixin] = ACTIONS(412),
    [sym__end] = ACTIONS(412),
    [sym__text_after_type] = ACTIONS(359),
  },
  [77] = {
    [sym_description] = STATE(182),
    [sym_inline_tag] = STATE(116),
    [aux_sym_description_repeat1] = STATE(116),
    [anon_sym_LBRACE] = ACTIONS(5),
    [anon_sym_ATinheritdoc] = ACTIONS(416),
    [anon_sym_ATinheritDoc] = ACTIONS(416),
    [anon_sym_ATapi] = ACTIONS(416),
    [anon_sym_ATfilesource] = ACTIONS(416),
    [anon_sym_ATignore] = ACTIONS(416),
    [anon_sym_ATinternal] = ACTIONS(416),
    [anon_sym_ATcategory] = ACTIONS(416),
    [anon_sym_ATcopyright] = ACTIONS(416),
    [anon_sym_ATtodo] = ACTIONS(416),
    [anon_sym_ATexample] = ACTIONS(416),
    [anon_sym_ATlicense] = ACTIONS(416),
    [anon_sym_ATpackage] = ACTIONS(416),
    [anon_sym_ATsource] = ACTIONS(416),
    [anon_sym_ATsubpackage] = ACTIONS(416),
    [anon_sym_ATuses] = ACTIONS(416),
    [anon_sym_ATauthor] = ACTIONS(416),
    [anon_sym_ATglobal] = ACTIONS(416),
    [anon_sym_ATlink] = ACTIONS(416),
    [anon_sym_ATmethod] = ACTIONS(416),
    [anon_sym_ATparam] = ACTIONS(418),
    [anon_sym_ATproperty] = ACTIONS(418),
    [anon_sym_ATproperty_DASHread] = ACTIONS(416),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(416),
    [anon_sym_ATreturn] = ACTIONS(416),
    [anon_sym_ATsee] = ACTIONS(416),
    [anon_sym_ATthrows] = ACTIONS(416),
    [anon_sym_ATvar] = ACTIONS(416),
    [anon_sym_ATdeprecated] = ACTIONS(416),
    [anon_sym_ATsince] = ACTIONS(416),
    [anon_sym_ATversion] = ACTIONS(416),
    [anon_sym_ATtemplate] = ACTIONS(418),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(416),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(416),
    [anon_sym_ATimplements] = ACTIONS(416),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(416),
    [anon_sym_ATextends] = ACTIONS(416),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(416),
    [anon_sym_ATuse] = ACTIONS(418),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(416),
    [anon_sym_ATafter] = ACTIONS(418),
    [anon_sym_ATafterClass] = ACTIONS(416),
    [anon_sym_ATannotation] = ACTIONS(416),
    [anon_sym_ATbackupGlobals] = ACTIONS(416),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(416),
    [anon_sym_ATbefore] = ACTIONS(418),
    [anon_sym_ATbeforeClass] = ACTIONS(416),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(418),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(416),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(416),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(416),
    [anon_sym_ATcovers] = ACTIONS(418),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(418),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(416),
    [anon_sym_ATcoversNothing] = ACTIONS(416),
    [anon_sym_ATdataProvider] = ACTIONS(416),
    [anon_sym_ATdepends] = ACTIONS(418),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(416),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(416),
    [anon_sym_ATgroup] = ACTIONS(416),
    [anon_sym_ATlarge] = ACTIONS(416),
    [anon_sym_ATmedium] = ACTIONS(416),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(416),
    [anon_sym_ATrequires] = ACTIONS(418),
    [anon_sym_ATrequiresusages] = ACTIONS(416),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(416),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(416),
    [anon_sym_ATsmall] = ACTIONS(416),
    [anon_sym_ATtest] = ACTIONS(418),
    [anon_sym_ATtestWith] = ACTIONS(416),
    [anon_sym_ATtestdox] = ACTIONS(416),
    [anon_sym_ATticket] = ACTIONS(416),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(416),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(416),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(416),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(418),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(416),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(418),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(416),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(416),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(416),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(416),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(416),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(416),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(416),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(416),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(416),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(418),
    [anon_sym_ATreadonly] = ACTIONS(416),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(416),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(416),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(416),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(416),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(416),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(416),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(416),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(416),
    [anon_sym_ATparam_DASHout] = ACTIONS(416),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(416),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(418),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(416),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(416),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(416),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(416),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(416),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(416),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(416),
    [anon_sym_ATmixin] = ACTIONS(416),
    [sym__end] = ACTIONS(416),
    [sym_text] = ACTIONS(75),
  },
  [78] = {
    [sym_description] = STATE(180),
    [sym_inline_tag] = STATE(116),
    [aux_sym_description_repeat1] = STATE(116),
    [anon_sym_LBRACE] = ACTIONS(5),
    [anon_sym_ATinheritdoc] = ACTIONS(420),
    [anon_sym_ATinheritDoc] = ACTIONS(420),
    [anon_sym_ATapi] = ACTIONS(420),
    [anon_sym_ATfilesource] = ACTIONS(420),
    [anon_sym_ATignore] = ACTIONS(420),
    [anon_sym_ATinternal] = ACTIONS(420),
    [anon_sym_ATcategory] = ACTIONS(420),
    [anon_sym_ATcopyright] = ACTIONS(420),
    [anon_sym_ATtodo] = ACTIONS(420),
    [anon_sym_ATexample] = ACTIONS(420),
    [anon_sym_ATlicense] = ACTIONS(420),
    [anon_sym_ATpackage] = ACTIONS(420),
    [anon_sym_ATsource] = ACTIONS(420),
    [anon_sym_ATsubpackage] = ACTIONS(420),
    [anon_sym_ATuses] = ACTIONS(420),
    [anon_sym_ATauthor] = ACTIONS(420),
    [anon_sym_ATglobal] = ACTIONS(420),
    [anon_sym_ATlink] = ACTIONS(420),
    [anon_sym_ATmethod] = ACTIONS(420),
    [anon_sym_ATparam] = ACTIONS(422),
    [anon_sym_ATproperty] = ACTIONS(422),
    [anon_sym_ATproperty_DASHread] = ACTIONS(420),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(420),
    [anon_sym_ATreturn] = ACTIONS(420),
    [anon_sym_ATsee] = ACTIONS(420),
    [anon_sym_ATthrows] = ACTIONS(420),
    [anon_sym_ATvar] = ACTIONS(420),
    [anon_sym_ATdeprecated] = ACTIONS(420),
    [anon_sym_ATsince] = ACTIONS(420),
    [anon_sym_ATversion] = ACTIONS(420),
    [anon_sym_ATtemplate] = ACTIONS(422),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(420),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(420),
    [anon_sym_ATimplements] = ACTIONS(420),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(420),
    [anon_sym_ATextends] = ACTIONS(420),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(420),
    [anon_sym_ATuse] = ACTIONS(422),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(420),
    [anon_sym_ATafter] = ACTIONS(422),
    [anon_sym_ATafterClass] = ACTIONS(420),
    [anon_sym_ATannotation] = ACTIONS(420),
    [anon_sym_ATbackupGlobals] = ACTIONS(420),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(420),
    [anon_sym_ATbefore] = ACTIONS(422),
    [anon_sym_ATbeforeClass] = ACTIONS(420),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(422),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(420),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(420),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(420),
    [anon_sym_ATcovers] = ACTIONS(422),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(422),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(420),
    [anon_sym_ATcoversNothing] = ACTIONS(420),
    [anon_sym_ATdataProvider] = ACTIONS(420),
    [anon_sym_ATdepends] = ACTIONS(422),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(420),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(420),
    [anon_sym_ATgroup] = ACTIONS(420),
    [anon_sym_ATlarge] = ACTIONS(420),
    [anon_sym_ATmedium] = ACTIONS(420),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(420),
    [anon_sym_ATrequires] = ACTIONS(422),
    [anon_sym_ATrequiresusages] = ACTIONS(420),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(420),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(420),
    [anon_sym_ATsmall] = ACTIONS(420),
    [anon_sym_ATtest] = ACTIONS(422),
    [anon_sym_ATtestWith] = ACTIONS(420),
    [anon_sym_ATtestdox] = ACTIONS(420),
    [anon_sym_ATticket] = ACTIONS(420),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(420),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(420),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(420),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(422),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(420),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(422),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(420),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(420),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(420),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(420),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(420),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(420),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(420),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(420),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(420),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(422),
    [anon_sym_ATreadonly] = ACTIONS(420),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(420),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(420),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(420),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(420),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(420),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(420),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(420),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(420),
    [anon_sym_ATparam_DASHout] = ACTIONS(420),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(420),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(422),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(420),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(420),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(420),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(420),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(420),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(420),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(420),
    [anon_sym_ATmixin] = ACTIONS(420),
    [sym__end] = ACTIONS(420),
    [sym_text] = ACTIONS(75),
  },
  [79] = {
    [anon_sym_LBRACE] = ACTIONS(310),
    [anon_sym_ATinheritdoc] = ACTIONS(310),
    [anon_sym_ATinheritDoc] = ACTIONS(310),
    [anon_sym_ATapi] = ACTIONS(310),
    [anon_sym_ATfilesource] = ACTIONS(310),
    [anon_sym_ATignore] = ACTIONS(310),
    [anon_sym_ATinternal] = ACTIONS(310),
    [anon_sym_ATcategory] = ACTIONS(310),
    [anon_sym_ATcopyright] = ACTIONS(310),
    [anon_sym_ATtodo] = ACTIONS(310),
    [anon_sym_ATexample] = ACTIONS(310),
    [anon_sym_ATlicense] = ACTIONS(310),
    [anon_sym_ATpackage] = ACTIONS(310),
    [anon_sym_ATsource] = ACTIONS(310),
    [anon_sym_ATsubpackage] = ACTIONS(310),
    [anon_sym_ATuses] = ACTIONS(310),
    [anon_sym_ATauthor] = ACTIONS(310),
    [anon_sym_ATglobal] = ACTIONS(310),
    [anon_sym_ATlink] = ACTIONS(310),
    [anon_sym_ATmethod] = ACTIONS(310),
    [anon_sym_ATparam] = ACTIONS(308),
    [anon_sym_ATproperty] = ACTIONS(308),
    [anon_sym_ATproperty_DASHread] = ACTIONS(310),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(310),
    [anon_sym_ATreturn] = ACTIONS(310),
    [anon_sym_ATsee] = ACTIONS(310),
    [anon_sym_ATthrows] = ACTIONS(310),
    [anon_sym_ATvar] = ACTIONS(310),
    [anon_sym_ATdeprecated] = ACTIONS(310),
    [anon_sym_ATsince] = ACTIONS(310),
    [anon_sym_ATversion] = ACTIONS(310),
    [anon_sym_ATtemplate] = ACTIONS(308),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(310),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(310),
    [anon_sym_ATimplements] = ACTIONS(310),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(310),
    [anon_sym_ATextends] = ACTIONS(310),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(310),
    [anon_sym_ATuse] = ACTIONS(308),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(310),
    [anon_sym_ATafter] = ACTIONS(308),
    [anon_sym_ATafterClass] = ACTIONS(310),
    [anon_sym_ATannotation] = ACTIONS(310),
    [anon_sym_ATbackupGlobals] = ACTIONS(310),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(310),
    [anon_sym_ATbefore] = ACTIONS(308),
    [anon_sym_ATbeforeClass] = ACTIONS(310),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(308),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(310),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(310),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(310),
    [anon_sym_ATcovers] = ACTIONS(308),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(308),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(310),
    [anon_sym_ATcoversNothing] = ACTIONS(310),
    [anon_sym_ATdataProvider] = ACTIONS(310),
    [anon_sym_ATdepends] = ACTIONS(308),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(310),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(310),
    [anon_sym_ATgroup] = ACTIONS(310),
    [anon_sym_ATlarge] = ACTIONS(310),
    [anon_sym_ATmedium] = ACTIONS(310),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(310),
    [anon_sym_ATrequires] = ACTIONS(308),
    [anon_sym_ATrequiresusages] = ACTIONS(310),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(310),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(310),
    [anon_sym_ATsmall] = ACTIONS(310),
    [anon_sym_ATtest] = ACTIONS(308),
    [anon_sym_ATtestWith] = ACTIONS(310),
    [anon_sym_ATtestdox] = ACTIONS(310),
    [anon_sym_ATticket] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(308),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(308),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(308),
    [anon_sym_ATreadonly] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(310),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(310),
    [anon_sym_ATparam_DASHout] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(308),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(310),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(310),
    [anon_sym_ATmixin] = ACTIONS(310),
    [anon_sym_PIPE] = ACTIONS(310),
    [anon_sym_AMP] = ACTIONS(310),
    [anon_sym_DOLLAR] = ACTIONS(310),
    [sym__end] = ACTIONS(310),
    [sym__text_after_type] = ACTIONS(310),
  },
  [80] = {
    [sym_name] = ACTIONS(424),
    [anon_sym_ATinheritdoc] = ACTIONS(427),
    [anon_sym_ATinheritDoc] = ACTIONS(427),
    [anon_sym_ATapi] = ACTIONS(427),
    [anon_sym_ATfilesource] = ACTIONS(427),
    [anon_sym_ATignore] = ACTIONS(427),
    [anon_sym_ATinternal] = ACTIONS(427),
    [anon_sym_ATcategory] = ACTIONS(427),
    [anon_sym_ATcopyright] = ACTIONS(427),
    [anon_sym_ATtodo] = ACTIONS(427),
    [anon_sym_ATexample] = ACTIONS(427),
    [anon_sym_ATlicense] = ACTIONS(427),
    [anon_sym_ATpackage] = ACTIONS(427),
    [anon_sym_ATsource] = ACTIONS(427),
    [anon_sym_ATsubpackage] = ACTIONS(427),
    [anon_sym_ATuses] = ACTIONS(427),
    [anon_sym_ATauthor] = ACTIONS(427),
    [anon_sym_ATglobal] = ACTIONS(427),
    [anon_sym_ATlink] = ACTIONS(427),
    [anon_sym_ATmethod] = ACTIONS(427),
    [anon_sym_ATparam] = ACTIONS(424),
    [anon_sym_ATproperty] = ACTIONS(424),
    [anon_sym_ATproperty_DASHread] = ACTIONS(427),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(427),
    [anon_sym_ATreturn] = ACTIONS(427),
    [anon_sym_ATsee] = ACTIONS(427),
    [anon_sym_ATthrows] = ACTIONS(427),
    [anon_sym_ATvar] = ACTIONS(427),
    [anon_sym_ATdeprecated] = ACTIONS(427),
    [anon_sym_ATsince] = ACTIONS(427),
    [anon_sym_ATversion] = ACTIONS(427),
    [anon_sym_ATtemplate] = ACTIONS(424),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(427),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(427),
    [anon_sym_of] = ACTIONS(424),
    [anon_sym_ATimplements] = ACTIONS(427),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(427),
    [anon_sym_ATextends] = ACTIONS(427),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(427),
    [anon_sym_ATuse] = ACTIONS(424),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(427),
    [anon_sym_ATafter] = ACTIONS(424),
    [anon_sym_ATafterClass] = ACTIONS(427),
    [anon_sym_ATannotation] = ACTIONS(427),
    [anon_sym_ATbackupGlobals] = ACTIONS(427),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(427),
    [anon_sym_ATbefore] = ACTIONS(424),
    [anon_sym_ATbeforeClass] = ACTIONS(427),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(424),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(427),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(427),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(427),
    [anon_sym_ATcovers] = ACTIONS(424),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(424),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(427),
    [anon_sym_ATcoversNothing] = ACTIONS(427),
    [anon_sym_ATdataProvider] = ACTIONS(427),
    [anon_sym_ATdepends] = ACTIONS(424),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(427),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(427),
    [anon_sym_ATgroup] = ACTIONS(427),
    [anon_sym_ATlarge] = ACTIONS(427),
    [anon_sym_ATmedium] = ACTIONS(427),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(427),
    [anon_sym_ATrequires] = ACTIONS(424),
    [anon_sym_ATrequiresusages] = ACTIONS(427),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(427),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(427),
    [anon_sym_ATsmall] = ACTIONS(427),
    [anon_sym_ATtest] = ACTIONS(424),
    [anon_sym_ATtestWith] = ACTIONS(427),
    [anon_sym_ATtestdox] = ACTIONS(427),
    [anon_sym_ATticket] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(424),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(424),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(424),
    [anon_sym_ATreadonly] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(427),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(427),
    [anon_sym_ATparam_DASHout] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(424),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(427),
    [anon_sym_ATmixin] = ACTIONS(427),
    [anon_sym_COMMA] = ACTIONS(427),
    [anon_sym_PIPE] = ACTIONS(427),
    [anon_sym_DOLLAR] = ACTIONS(427),
    [sym__end] = ACTIONS(427),
  },
  [81] = {
    [sym_description] = STATE(183),
    [sym_inline_tag] = STATE(116),
    [aux_sym_description_repeat1] = STATE(116),
    [anon_sym_LBRACE] = ACTIONS(5),
    [anon_sym_ATinheritdoc] = ACTIONS(430),
    [anon_sym_ATinheritDoc] = ACTIONS(430),
    [anon_sym_ATapi] = ACTIONS(430),
    [anon_sym_ATfilesource] = ACTIONS(430),
    [anon_sym_ATignore] = ACTIONS(430),
    [anon_sym_ATinternal] = ACTIONS(430),
    [anon_sym_ATcategory] = ACTIONS(430),
    [anon_sym_ATcopyright] = ACTIONS(430),
    [anon_sym_ATtodo] = ACTIONS(430),
    [anon_sym_ATexample] = ACTIONS(430),
    [anon_sym_ATlicense] = ACTIONS(430),
    [anon_sym_ATpackage] = ACTIONS(430),
    [anon_sym_ATsource] = ACTIONS(430),
    [anon_sym_ATsubpackage] = ACTIONS(430),
    [anon_sym_ATuses] = ACTIONS(430),
    [anon_sym_ATauthor] = ACTIONS(430),
    [anon_sym_ATglobal] = ACTIONS(430),
    [anon_sym_ATlink] = ACTIONS(430),
    [anon_sym_ATmethod] = ACTIONS(430),
    [anon_sym_ATparam] = ACTIONS(432),
    [anon_sym_ATproperty] = ACTIONS(432),
    [anon_sym_ATproperty_DASHread] = ACTIONS(430),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(430),
    [anon_sym_ATreturn] = ACTIONS(430),
    [anon_sym_ATsee] = ACTIONS(430),
    [anon_sym_ATthrows] = ACTIONS(430),
    [anon_sym_ATvar] = ACTIONS(430),
    [anon_sym_ATdeprecated] = ACTIONS(430),
    [anon_sym_ATsince] = ACTIONS(430),
    [anon_sym_ATversion] = ACTIONS(430),
    [anon_sym_ATtemplate] = ACTIONS(432),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(430),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(430),
    [anon_sym_ATimplements] = ACTIONS(430),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(430),
    [anon_sym_ATextends] = ACTIONS(430),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(430),
    [anon_sym_ATuse] = ACTIONS(432),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(430),
    [anon_sym_ATafter] = ACTIONS(432),
    [anon_sym_ATafterClass] = ACTIONS(430),
    [anon_sym_ATannotation] = ACTIONS(430),
    [anon_sym_ATbackupGlobals] = ACTIONS(430),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(430),
    [anon_sym_ATbefore] = ACTIONS(432),
    [anon_sym_ATbeforeClass] = ACTIONS(430),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(432),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(430),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(430),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(430),
    [anon_sym_ATcovers] = ACTIONS(432),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(432),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(430),
    [anon_sym_ATcoversNothing] = ACTIONS(430),
    [anon_sym_ATdataProvider] = ACTIONS(430),
    [anon_sym_ATdepends] = ACTIONS(432),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(430),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(430),
    [anon_sym_ATgroup] = ACTIONS(430),
    [anon_sym_ATlarge] = ACTIONS(430),
    [anon_sym_ATmedium] = ACTIONS(430),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(430),
    [anon_sym_ATrequires] = ACTIONS(432),
    [anon_sym_ATrequiresusages] = ACTIONS(430),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(430),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(430),
    [anon_sym_ATsmall] = ACTIONS(430),
    [anon_sym_ATtest] = ACTIONS(432),
    [anon_sym_ATtestWith] = ACTIONS(430),
    [anon_sym_ATtestdox] = ACTIONS(430),
    [anon_sym_ATticket] = ACTIONS(430),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(430),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(430),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(430),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(432),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(430),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(432),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(430),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(430),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(430),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(430),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(430),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(430),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(430),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(430),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(430),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(432),
    [anon_sym_ATreadonly] = ACTIONS(430),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(430),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(430),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(430),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(430),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(430),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(430),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(430),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(430),
    [anon_sym_ATparam_DASHout] = ACTIONS(430),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(430),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(432),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(430),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(430),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(430),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(430),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(430),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(430),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(430),
    [anon_sym_ATmixin] = ACTIONS(430),
    [sym__end] = ACTIONS(430),
    [sym_text] = ACTIONS(75),
  },
  [82] = {
    [sym_description] = STATE(170),
    [sym_inline_tag] = STATE(116),
    [aux_sym_description_repeat1] = STATE(116),
    [anon_sym_LBRACE] = ACTIONS(5),
    [anon_sym_ATinheritdoc] = ACTIONS(434),
    [anon_sym_ATinheritDoc] = ACTIONS(434),
    [anon_sym_ATapi] = ACTIONS(434),
    [anon_sym_ATfilesource] = ACTIONS(434),
    [anon_sym_ATignore] = ACTIONS(434),
    [anon_sym_ATinternal] = ACTIONS(434),
    [anon_sym_ATcategory] = ACTIONS(434),
    [anon_sym_ATcopyright] = ACTIONS(434),
    [anon_sym_ATtodo] = ACTIONS(434),
    [anon_sym_ATexample] = ACTIONS(434),
    [anon_sym_ATlicense] = ACTIONS(434),
    [anon_sym_ATpackage] = ACTIONS(434),
    [anon_sym_ATsource] = ACTIONS(434),
    [anon_sym_ATsubpackage] = ACTIONS(434),
    [anon_sym_ATuses] = ACTIONS(434),
    [anon_sym_ATauthor] = ACTIONS(434),
    [anon_sym_ATglobal] = ACTIONS(434),
    [anon_sym_ATlink] = ACTIONS(434),
    [anon_sym_ATmethod] = ACTIONS(434),
    [anon_sym_ATparam] = ACTIONS(436),
    [anon_sym_ATproperty] = ACTIONS(436),
    [anon_sym_ATproperty_DASHread] = ACTIONS(434),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(434),
    [anon_sym_ATreturn] = ACTIONS(434),
    [anon_sym_ATsee] = ACTIONS(434),
    [anon_sym_ATthrows] = ACTIONS(434),
    [anon_sym_ATvar] = ACTIONS(434),
    [anon_sym_ATdeprecated] = ACTIONS(434),
    [anon_sym_ATsince] = ACTIONS(434),
    [anon_sym_ATversion] = ACTIONS(434),
    [anon_sym_ATtemplate] = ACTIONS(436),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(434),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(434),
    [anon_sym_ATimplements] = ACTIONS(434),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(434),
    [anon_sym_ATextends] = ACTIONS(434),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(434),
    [anon_sym_ATuse] = ACTIONS(436),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(434),
    [anon_sym_ATafter] = ACTIONS(436),
    [anon_sym_ATafterClass] = ACTIONS(434),
    [anon_sym_ATannotation] = ACTIONS(434),
    [anon_sym_ATbackupGlobals] = ACTIONS(434),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(434),
    [anon_sym_ATbefore] = ACTIONS(436),
    [anon_sym_ATbeforeClass] = ACTIONS(434),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(436),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(434),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(434),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(434),
    [anon_sym_ATcovers] = ACTIONS(436),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(436),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(434),
    [anon_sym_ATcoversNothing] = ACTIONS(434),
    [anon_sym_ATdataProvider] = ACTIONS(434),
    [anon_sym_ATdepends] = ACTIONS(436),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(434),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(434),
    [anon_sym_ATgroup] = ACTIONS(434),
    [anon_sym_ATlarge] = ACTIONS(434),
    [anon_sym_ATmedium] = ACTIONS(434),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(434),
    [anon_sym_ATrequires] = ACTIONS(436),
    [anon_sym_ATrequiresusages] = ACTIONS(434),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(434),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(434),
    [anon_sym_ATsmall] = ACTIONS(434),
    [anon_sym_ATtest] = ACTIONS(436),
    [anon_sym_ATtestWith] = ACTIONS(434),
    [anon_sym_ATtestdox] = ACTIONS(434),
    [anon_sym_ATticket] = ACTIONS(434),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(434),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(434),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(434),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(436),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(434),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(436),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(434),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(434),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(434),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(434),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(434),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(434),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(434),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(434),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(434),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(436),
    [anon_sym_ATreadonly] = ACTIONS(434),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(434),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(434),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(434),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(434),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(434),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(434),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(434),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(434),
    [anon_sym_ATparam_DASHout] = ACTIONS(434),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(434),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(436),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(434),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(434),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(434),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(434),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(434),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(434),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(434),
    [anon_sym_ATmixin] = ACTIONS(434),
    [sym__end] = ACTIONS(434),
    [sym_text] = ACTIONS(75),
  },
  [83] = {
    [sym_description] = STATE(173),
    [sym_inline_tag] = STATE(116),
    [aux_sym_description_repeat1] = STATE(116),
    [anon_sym_LBRACE] = ACTIONS(5),
    [anon_sym_ATinheritdoc] = ACTIONS(438),
    [anon_sym_ATinheritDoc] = ACTIONS(438),
    [anon_sym_ATapi] = ACTIONS(438),
    [anon_sym_ATfilesource] = ACTIONS(438),
    [anon_sym_ATignore] = ACTIONS(438),
    [anon_sym_ATinternal] = ACTIONS(438),
    [anon_sym_ATcategory] = ACTIONS(438),
    [anon_sym_ATcopyright] = ACTIONS(438),
    [anon_sym_ATtodo] = ACTIONS(438),
    [anon_sym_ATexample] = ACTIONS(438),
    [anon_sym_ATlicense] = ACTIONS(438),
    [anon_sym_ATpackage] = ACTIONS(438),
    [anon_sym_ATsource] = ACTIONS(438),
    [anon_sym_ATsubpackage] = ACTIONS(438),
    [anon_sym_ATuses] = ACTIONS(438),
    [anon_sym_ATauthor] = ACTIONS(438),
    [anon_sym_ATglobal] = ACTIONS(438),
    [anon_sym_ATlink] = ACTIONS(438),
    [anon_sym_ATmethod] = ACTIONS(438),
    [anon_sym_ATparam] = ACTIONS(440),
    [anon_sym_ATproperty] = ACTIONS(440),
    [anon_sym_ATproperty_DASHread] = ACTIONS(438),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(438),
    [anon_sym_ATreturn] = ACTIONS(438),
    [anon_sym_ATsee] = ACTIONS(438),
    [anon_sym_ATthrows] = ACTIONS(438),
    [anon_sym_ATvar] = ACTIONS(438),
    [anon_sym_ATdeprecated] = ACTIONS(438),
    [anon_sym_ATsince] = ACTIONS(438),
    [anon_sym_ATversion] = ACTIONS(438),
    [anon_sym_ATtemplate] = ACTIONS(440),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(438),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(438),
    [anon_sym_ATimplements] = ACTIONS(438),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(438),
    [anon_sym_ATextends] = ACTIONS(438),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(438),
    [anon_sym_ATuse] = ACTIONS(440),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(438),
    [anon_sym_ATafter] = ACTIONS(440),
    [anon_sym_ATafterClass] = ACTIONS(438),
    [anon_sym_ATannotation] = ACTIONS(438),
    [anon_sym_ATbackupGlobals] = ACTIONS(438),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(438),
    [anon_sym_ATbefore] = ACTIONS(440),
    [anon_sym_ATbeforeClass] = ACTIONS(438),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(440),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(438),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(438),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(438),
    [anon_sym_ATcovers] = ACTIONS(440),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(440),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(438),
    [anon_sym_ATcoversNothing] = ACTIONS(438),
    [anon_sym_ATdataProvider] = ACTIONS(438),
    [anon_sym_ATdepends] = ACTIONS(440),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(438),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(438),
    [anon_sym_ATgroup] = ACTIONS(438),
    [anon_sym_ATlarge] = ACTIONS(438),
    [anon_sym_ATmedium] = ACTIONS(438),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(438),
    [anon_sym_ATrequires] = ACTIONS(440),
    [anon_sym_ATrequiresusages] = ACTIONS(438),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(438),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(438),
    [anon_sym_ATsmall] = ACTIONS(438),
    [anon_sym_ATtest] = ACTIONS(440),
    [anon_sym_ATtestWith] = ACTIONS(438),
    [anon_sym_ATtestdox] = ACTIONS(438),
    [anon_sym_ATticket] = ACTIONS(438),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(438),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(438),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(438),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(440),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(438),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(440),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(438),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(438),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(438),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(438),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(438),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(438),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(438),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(438),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(438),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(440),
    [anon_sym_ATreadonly] = ACTIONS(438),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(438),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(438),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(438),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(438),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(438),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(438),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(438),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(438),
    [anon_sym_ATparam_DASHout] = ACTIONS(438),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(438),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(440),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(438),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(438),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(438),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(438),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(438),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(438),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(438),
    [anon_sym_ATmixin] = ACTIONS(438),
    [sym__end] = ACTIONS(438),
    [sym_text] = ACTIONS(75),
  },
  [84] = {
    [sym_description] = STATE(175),
    [sym_inline_tag] = STATE(116),
    [aux_sym_description_repeat1] = STATE(116),
    [anon_sym_LBRACE] = ACTIONS(5),
    [anon_sym_ATinheritdoc] = ACTIONS(442),
    [anon_sym_ATinheritDoc] = ACTIONS(442),
    [anon_sym_ATapi] = ACTIONS(442),
    [anon_sym_ATfilesource] = ACTIONS(442),
    [anon_sym_ATignore] = ACTIONS(442),
    [anon_sym_ATinternal] = ACTIONS(442),
    [anon_sym_ATcategory] = ACTIONS(442),
    [anon_sym_ATcopyright] = ACTIONS(442),
    [anon_sym_ATtodo] = ACTIONS(442),
    [anon_sym_ATexample] = ACTIONS(442),
    [anon_sym_ATlicense] = ACTIONS(442),
    [anon_sym_ATpackage] = ACTIONS(442),
    [anon_sym_ATsource] = ACTIONS(442),
    [anon_sym_ATsubpackage] = ACTIONS(442),
    [anon_sym_ATuses] = ACTIONS(442),
    [anon_sym_ATauthor] = ACTIONS(442),
    [anon_sym_ATglobal] = ACTIONS(442),
    [anon_sym_ATlink] = ACTIONS(442),
    [anon_sym_ATmethod] = ACTIONS(442),
    [anon_sym_ATparam] = ACTIONS(444),
    [anon_sym_ATproperty] = ACTIONS(444),
    [anon_sym_ATproperty_DASHread] = ACTIONS(442),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(442),
    [anon_sym_ATreturn] = ACTIONS(442),
    [anon_sym_ATsee] = ACTIONS(442),
    [anon_sym_ATthrows] = ACTIONS(442),
    [anon_sym_ATvar] = ACTIONS(442),
    [anon_sym_ATdeprecated] = ACTIONS(442),
    [anon_sym_ATsince] = ACTIONS(442),
    [anon_sym_ATversion] = ACTIONS(442),
    [anon_sym_ATtemplate] = ACTIONS(444),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(442),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(442),
    [anon_sym_ATimplements] = ACTIONS(442),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(442),
    [anon_sym_ATextends] = ACTIONS(442),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(442),
    [anon_sym_ATuse] = ACTIONS(444),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(442),
    [anon_sym_ATafter] = ACTIONS(444),
    [anon_sym_ATafterClass] = ACTIONS(442),
    [anon_sym_ATannotation] = ACTIONS(442),
    [anon_sym_ATbackupGlobals] = ACTIONS(442),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(442),
    [anon_sym_ATbefore] = ACTIONS(444),
    [anon_sym_ATbeforeClass] = ACTIONS(442),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(444),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(442),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(442),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(442),
    [anon_sym_ATcovers] = ACTIONS(444),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(444),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(442),
    [anon_sym_ATcoversNothing] = ACTIONS(442),
    [anon_sym_ATdataProvider] = ACTIONS(442),
    [anon_sym_ATdepends] = ACTIONS(444),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(442),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(442),
    [anon_sym_ATgroup] = ACTIONS(442),
    [anon_sym_ATlarge] = ACTIONS(442),
    [anon_sym_ATmedium] = ACTIONS(442),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(442),
    [anon_sym_ATrequires] = ACTIONS(444),
    [anon_sym_ATrequiresusages] = ACTIONS(442),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(442),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(442),
    [anon_sym_ATsmall] = ACTIONS(442),
    [anon_sym_ATtest] = ACTIONS(444),
    [anon_sym_ATtestWith] = ACTIONS(442),
    [anon_sym_ATtestdox] = ACTIONS(442),
    [anon_sym_ATticket] = ACTIONS(442),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(442),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(442),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(442),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(444),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(442),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(444),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(442),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(442),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(442),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(442),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(442),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(442),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(442),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(442),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(442),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(444),
    [anon_sym_ATreadonly] = ACTIONS(442),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(442),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(442),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(442),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(442),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(442),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(442),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(442),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(442),
    [anon_sym_ATparam_DASHout] = ACTIONS(442),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(442),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(444),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(442),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(442),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(442),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(442),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(442),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(442),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(442),
    [anon_sym_ATmixin] = ACTIONS(442),
    [sym__end] = ACTIONS(442),
    [sym_text] = ACTIONS(75),
  },
  [85] = {
    [sym_description] = STATE(181),
    [sym_inline_tag] = STATE(116),
    [aux_sym_description_repeat1] = STATE(116),
    [anon_sym_LBRACE] = ACTIONS(5),
    [anon_sym_ATinheritdoc] = ACTIONS(446),
    [anon_sym_ATinheritDoc] = ACTIONS(446),
    [anon_sym_ATapi] = ACTIONS(446),
    [anon_sym_ATfilesource] = ACTIONS(446),
    [anon_sym_ATignore] = ACTIONS(446),
    [anon_sym_ATinternal] = ACTIONS(446),
    [anon_sym_ATcategory] = ACTIONS(446),
    [anon_sym_ATcopyright] = ACTIONS(446),
    [anon_sym_ATtodo] = ACTIONS(446),
    [anon_sym_ATexample] = ACTIONS(446),
    [anon_sym_ATlicense] = ACTIONS(446),
    [anon_sym_ATpackage] = ACTIONS(446),
    [anon_sym_ATsource] = ACTIONS(446),
    [anon_sym_ATsubpackage] = ACTIONS(446),
    [anon_sym_ATuses] = ACTIONS(446),
    [anon_sym_ATauthor] = ACTIONS(446),
    [anon_sym_ATglobal] = ACTIONS(446),
    [anon_sym_ATlink] = ACTIONS(446),
    [anon_sym_ATmethod] = ACTIONS(446),
    [anon_sym_ATparam] = ACTIONS(448),
    [anon_sym_ATproperty] = ACTIONS(448),
    [anon_sym_ATproperty_DASHread] = ACTIONS(446),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(446),
    [anon_sym_ATreturn] = ACTIONS(446),
    [anon_sym_ATsee] = ACTIONS(446),
    [anon_sym_ATthrows] = ACTIONS(446),
    [anon_sym_ATvar] = ACTIONS(446),
    [anon_sym_ATdeprecated] = ACTIONS(446),
    [anon_sym_ATsince] = ACTIONS(446),
    [anon_sym_ATversion] = ACTIONS(446),
    [anon_sym_ATtemplate] = ACTIONS(448),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(446),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(446),
    [anon_sym_ATimplements] = ACTIONS(446),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(446),
    [anon_sym_ATextends] = ACTIONS(446),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(446),
    [anon_sym_ATuse] = ACTIONS(448),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(446),
    [anon_sym_ATafter] = ACTIONS(448),
    [anon_sym_ATafterClass] = ACTIONS(446),
    [anon_sym_ATannotation] = ACTIONS(446),
    [anon_sym_ATbackupGlobals] = ACTIONS(446),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(446),
    [anon_sym_ATbefore] = ACTIONS(448),
    [anon_sym_ATbeforeClass] = ACTIONS(446),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(448),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(446),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(446),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(446),
    [anon_sym_ATcovers] = ACTIONS(448),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(448),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(446),
    [anon_sym_ATcoversNothing] = ACTIONS(446),
    [anon_sym_ATdataProvider] = ACTIONS(446),
    [anon_sym_ATdepends] = ACTIONS(448),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(446),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(446),
    [anon_sym_ATgroup] = ACTIONS(446),
    [anon_sym_ATlarge] = ACTIONS(446),
    [anon_sym_ATmedium] = ACTIONS(446),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(446),
    [anon_sym_ATrequires] = ACTIONS(448),
    [anon_sym_ATrequiresusages] = ACTIONS(446),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(446),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(446),
    [anon_sym_ATsmall] = ACTIONS(446),
    [anon_sym_ATtest] = ACTIONS(448),
    [anon_sym_ATtestWith] = ACTIONS(446),
    [anon_sym_ATtestdox] = ACTIONS(446),
    [anon_sym_ATticket] = ACTIONS(446),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(446),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(446),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(446),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(448),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(446),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(448),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(446),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(446),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(446),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(446),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(446),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(446),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(446),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(446),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(446),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(448),
    [anon_sym_ATreadonly] = ACTIONS(446),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(446),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(446),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(446),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(446),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(446),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(446),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(446),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(446),
    [anon_sym_ATparam_DASHout] = ACTIONS(446),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(446),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(448),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(446),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(446),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(446),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(446),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(446),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(446),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(446),
    [anon_sym_ATmixin] = ACTIONS(446),
    [sym__end] = ACTIONS(446),
    [sym_text] = ACTIONS(75),
  },
  [86] = {
    [sym_description] = STATE(155),
    [sym_inline_tag] = STATE(116),
    [aux_sym_description_repeat1] = STATE(116),
    [anon_sym_LBRACE] = ACTIONS(5),
    [anon_sym_ATinheritdoc] = ACTIONS(450),
    [anon_sym_ATinheritDoc] = ACTIONS(450),
    [anon_sym_ATapi] = ACTIONS(450),
    [anon_sym_ATfilesource] = ACTIONS(450),
    [anon_sym_ATignore] = ACTIONS(450),
    [anon_sym_ATinternal] = ACTIONS(450),
    [anon_sym_ATcategory] = ACTIONS(450),
    [anon_sym_ATcopyright] = ACTIONS(450),
    [anon_sym_ATtodo] = ACTIONS(450),
    [anon_sym_ATexample] = ACTIONS(450),
    [anon_sym_ATlicense] = ACTIONS(450),
    [anon_sym_ATpackage] = ACTIONS(450),
    [anon_sym_ATsource] = ACTIONS(450),
    [anon_sym_ATsubpackage] = ACTIONS(450),
    [anon_sym_ATuses] = ACTIONS(450),
    [anon_sym_ATauthor] = ACTIONS(450),
    [anon_sym_ATglobal] = ACTIONS(450),
    [anon_sym_ATlink] = ACTIONS(450),
    [anon_sym_ATmethod] = ACTIONS(450),
    [anon_sym_ATparam] = ACTIONS(452),
    [anon_sym_ATproperty] = ACTIONS(452),
    [anon_sym_ATproperty_DASHread] = ACTIONS(450),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(450),
    [anon_sym_ATreturn] = ACTIONS(450),
    [anon_sym_ATsee] = ACTIONS(450),
    [anon_sym_ATthrows] = ACTIONS(450),
    [anon_sym_ATvar] = ACTIONS(450),
    [anon_sym_ATdeprecated] = ACTIONS(450),
    [anon_sym_ATsince] = ACTIONS(450),
    [anon_sym_ATversion] = ACTIONS(450),
    [anon_sym_ATtemplate] = ACTIONS(452),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(450),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(450),
    [anon_sym_ATimplements] = ACTIONS(450),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(450),
    [anon_sym_ATextends] = ACTIONS(450),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(450),
    [anon_sym_ATuse] = ACTIONS(452),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(450),
    [anon_sym_ATafter] = ACTIONS(452),
    [anon_sym_ATafterClass] = ACTIONS(450),
    [anon_sym_ATannotation] = ACTIONS(450),
    [anon_sym_ATbackupGlobals] = ACTIONS(450),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(450),
    [anon_sym_ATbefore] = ACTIONS(452),
    [anon_sym_ATbeforeClass] = ACTIONS(450),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(452),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(450),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(450),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(450),
    [anon_sym_ATcovers] = ACTIONS(452),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(452),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(450),
    [anon_sym_ATcoversNothing] = ACTIONS(450),
    [anon_sym_ATdataProvider] = ACTIONS(450),
    [anon_sym_ATdepends] = ACTIONS(452),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(450),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(450),
    [anon_sym_ATgroup] = ACTIONS(450),
    [anon_sym_ATlarge] = ACTIONS(450),
    [anon_sym_ATmedium] = ACTIONS(450),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(450),
    [anon_sym_ATrequires] = ACTIONS(452),
    [anon_sym_ATrequiresusages] = ACTIONS(450),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(450),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(450),
    [anon_sym_ATsmall] = ACTIONS(450),
    [anon_sym_ATtest] = ACTIONS(452),
    [anon_sym_ATtestWith] = ACTIONS(450),
    [anon_sym_ATtestdox] = ACTIONS(450),
    [anon_sym_ATticket] = ACTIONS(450),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(450),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(450),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(450),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(452),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(450),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(452),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(450),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(450),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(450),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(450),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(450),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(450),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(450),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(450),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(450),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(452),
    [anon_sym_ATreadonly] = ACTIONS(450),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(450),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(450),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(450),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(450),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(450),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(450),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(450),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(450),
    [anon_sym_ATparam_DASHout] = ACTIONS(450),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(450),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(452),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(450),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(450),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(450),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(450),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(450),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(450),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(450),
    [anon_sym_ATmixin] = ACTIONS(450),
    [sym__end] = ACTIONS(450),
    [sym_text] = ACTIONS(75),
  },
  [87] = {
    [sym_description] = STATE(174),
    [sym_inline_tag] = STATE(116),
    [aux_sym_description_repeat1] = STATE(116),
    [anon_sym_LBRACE] = ACTIONS(5),
    [anon_sym_ATinheritdoc] = ACTIONS(454),
    [anon_sym_ATinheritDoc] = ACTIONS(454),
    [anon_sym_ATapi] = ACTIONS(454),
    [anon_sym_ATfilesource] = ACTIONS(454),
    [anon_sym_ATignore] = ACTIONS(454),
    [anon_sym_ATinternal] = ACTIONS(454),
    [anon_sym_ATcategory] = ACTIONS(454),
    [anon_sym_ATcopyright] = ACTIONS(454),
    [anon_sym_ATtodo] = ACTIONS(454),
    [anon_sym_ATexample] = ACTIONS(454),
    [anon_sym_ATlicense] = ACTIONS(454),
    [anon_sym_ATpackage] = ACTIONS(454),
    [anon_sym_ATsource] = ACTIONS(454),
    [anon_sym_ATsubpackage] = ACTIONS(454),
    [anon_sym_ATuses] = ACTIONS(454),
    [anon_sym_ATauthor] = ACTIONS(454),
    [anon_sym_ATglobal] = ACTIONS(454),
    [anon_sym_ATlink] = ACTIONS(454),
    [anon_sym_ATmethod] = ACTIONS(454),
    [anon_sym_ATparam] = ACTIONS(456),
    [anon_sym_ATproperty] = ACTIONS(456),
    [anon_sym_ATproperty_DASHread] = ACTIONS(454),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(454),
    [anon_sym_ATreturn] = ACTIONS(454),
    [anon_sym_ATsee] = ACTIONS(454),
    [anon_sym_ATthrows] = ACTIONS(454),
    [anon_sym_ATvar] = ACTIONS(454),
    [anon_sym_ATdeprecated] = ACTIONS(454),
    [anon_sym_ATsince] = ACTIONS(454),
    [anon_sym_ATversion] = ACTIONS(454),
    [anon_sym_ATtemplate] = ACTIONS(456),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(454),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(454),
    [anon_sym_ATimplements] = ACTIONS(454),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(454),
    [anon_sym_ATextends] = ACTIONS(454),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(454),
    [anon_sym_ATuse] = ACTIONS(456),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(454),
    [anon_sym_ATafter] = ACTIONS(456),
    [anon_sym_ATafterClass] = ACTIONS(454),
    [anon_sym_ATannotation] = ACTIONS(454),
    [anon_sym_ATbackupGlobals] = ACTIONS(454),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(454),
    [anon_sym_ATbefore] = ACTIONS(456),
    [anon_sym_ATbeforeClass] = ACTIONS(454),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(456),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(454),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(454),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(454),
    [anon_sym_ATcovers] = ACTIONS(456),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(456),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(454),
    [anon_sym_ATcoversNothing] = ACTIONS(454),
    [anon_sym_ATdataProvider] = ACTIONS(454),
    [anon_sym_ATdepends] = ACTIONS(456),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(454),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(454),
    [anon_sym_ATgroup] = ACTIONS(454),
    [anon_sym_ATlarge] = ACTIONS(454),
    [anon_sym_ATmedium] = ACTIONS(454),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(454),
    [anon_sym_ATrequires] = ACTIONS(456),
    [anon_sym_ATrequiresusages] = ACTIONS(454),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(454),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(454),
    [anon_sym_ATsmall] = ACTIONS(454),
    [anon_sym_ATtest] = ACTIONS(456),
    [anon_sym_ATtestWith] = ACTIONS(454),
    [anon_sym_ATtestdox] = ACTIONS(454),
    [anon_sym_ATticket] = ACTIONS(454),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(454),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(454),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(454),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(456),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(454),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(456),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(454),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(454),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(454),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(454),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(454),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(454),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(454),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(454),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(454),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(456),
    [anon_sym_ATreadonly] = ACTIONS(454),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(454),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(454),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(454),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(454),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(454),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(454),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(454),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(454),
    [anon_sym_ATparam_DASHout] = ACTIONS(454),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(454),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(456),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(454),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(454),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(454),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(454),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(454),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(454),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(454),
    [anon_sym_ATmixin] = ACTIONS(454),
    [sym__end] = ACTIONS(454),
    [sym_text] = ACTIONS(75),
  },
  [88] = {
    [sym__description_after_type] = STATE(172),
    [sym_inline_tag] = STATE(139),
    [aux_sym__description_after_type_repeat1] = STATE(124),
    [anon_sym_LBRACE] = ACTIONS(351),
    [anon_sym_ATinheritdoc] = ACTIONS(458),
    [anon_sym_ATinheritDoc] = ACTIONS(458),
    [anon_sym_ATapi] = ACTIONS(458),
    [anon_sym_ATfilesource] = ACTIONS(458),
    [anon_sym_ATignore] = ACTIONS(458),
    [anon_sym_ATinternal] = ACTIONS(458),
    [anon_sym_ATcategory] = ACTIONS(458),
    [anon_sym_ATcopyright] = ACTIONS(458),
    [anon_sym_ATtodo] = ACTIONS(458),
    [anon_sym_ATexample] = ACTIONS(458),
    [anon_sym_ATlicense] = ACTIONS(458),
    [anon_sym_ATpackage] = ACTIONS(458),
    [anon_sym_ATsource] = ACTIONS(458),
    [anon_sym_ATsubpackage] = ACTIONS(458),
    [anon_sym_ATuses] = ACTIONS(458),
    [anon_sym_ATauthor] = ACTIONS(458),
    [anon_sym_ATglobal] = ACTIONS(458),
    [anon_sym_ATlink] = ACTIONS(458),
    [anon_sym_ATmethod] = ACTIONS(458),
    [anon_sym_ATparam] = ACTIONS(460),
    [anon_sym_ATproperty] = ACTIONS(460),
    [anon_sym_ATproperty_DASHread] = ACTIONS(458),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(458),
    [anon_sym_ATreturn] = ACTIONS(458),
    [anon_sym_ATsee] = ACTIONS(458),
    [anon_sym_ATthrows] = ACTIONS(458),
    [anon_sym_ATvar] = ACTIONS(458),
    [anon_sym_ATdeprecated] = ACTIONS(458),
    [anon_sym_ATsince] = ACTIONS(458),
    [anon_sym_ATversion] = ACTIONS(458),
    [anon_sym_ATtemplate] = ACTIONS(460),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(458),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(458),
    [anon_sym_ATimplements] = ACTIONS(458),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(458),
    [anon_sym_ATextends] = ACTIONS(458),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(458),
    [anon_sym_ATuse] = ACTIONS(460),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(458),
    [anon_sym_ATafter] = ACTIONS(460),
    [anon_sym_ATafterClass] = ACTIONS(458),
    [anon_sym_ATannotation] = ACTIONS(458),
    [anon_sym_ATbackupGlobals] = ACTIONS(458),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(458),
    [anon_sym_ATbefore] = ACTIONS(460),
    [anon_sym_ATbeforeClass] = ACTIONS(458),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(460),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(458),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(458),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(458),
    [anon_sym_ATcovers] = ACTIONS(460),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(460),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(458),
    [anon_sym_ATcoversNothing] = ACTIONS(458),
    [anon_sym_ATdataProvider] = ACTIONS(458),
    [anon_sym_ATdepends] = ACTIONS(460),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(458),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(458),
    [anon_sym_ATgroup] = ACTIONS(458),
    [anon_sym_ATlarge] = ACTIONS(458),
    [anon_sym_ATmedium] = ACTIONS(458),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(458),
    [anon_sym_ATrequires] = ACTIONS(460),
    [anon_sym_ATrequiresusages] = ACTIONS(458),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(458),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(458),
    [anon_sym_ATsmall] = ACTIONS(458),
    [anon_sym_ATtest] = ACTIONS(460),
    [anon_sym_ATtestWith] = ACTIONS(458),
    [anon_sym_ATtestdox] = ACTIONS(458),
    [anon_sym_ATticket] = ACTIONS(458),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(458),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(458),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(458),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(460),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(458),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(460),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(458),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(458),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(458),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(458),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(458),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(458),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(458),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(458),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(458),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(460),
    [anon_sym_ATreadonly] = ACTIONS(458),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(458),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(458),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(458),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(458),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(458),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(458),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(458),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(458),
    [anon_sym_ATparam_DASHout] = ACTIONS(458),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(458),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(460),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(458),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(458),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(458),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(458),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(458),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(458),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(458),
    [anon_sym_ATmixin] = ACTIONS(458),
    [sym__end] = ACTIONS(458),
    [sym__text_after_type] = ACTIONS(359),
  },
  [89] = {
    [anon_sym_LBRACE] = ACTIONS(318),
    [anon_sym_ATinheritdoc] = ACTIONS(318),
    [anon_sym_ATinheritDoc] = ACTIONS(318),
    [anon_sym_ATapi] = ACTIONS(318),
    [anon_sym_ATfilesource] = ACTIONS(318),
    [anon_sym_ATignore] = ACTIONS(318),
    [anon_sym_ATinternal] = ACTIONS(318),
    [anon_sym_ATcategory] = ACTIONS(318),
    [anon_sym_ATcopyright] = ACTIONS(318),
    [anon_sym_ATtodo] = ACTIONS(318),
    [anon_sym_ATexample] = ACTIONS(318),
    [anon_sym_ATlicense] = ACTIONS(318),
    [anon_sym_ATpackage] = ACTIONS(318),
    [anon_sym_ATsource] = ACTIONS(318),
    [anon_sym_ATsubpackage] = ACTIONS(318),
    [anon_sym_ATuses] = ACTIONS(318),
    [anon_sym_ATauthor] = ACTIONS(318),
    [anon_sym_ATglobal] = ACTIONS(318),
    [anon_sym_ATlink] = ACTIONS(318),
    [anon_sym_ATmethod] = ACTIONS(318),
    [anon_sym_ATparam] = ACTIONS(316),
    [anon_sym_ATproperty] = ACTIONS(316),
    [anon_sym_ATproperty_DASHread] = ACTIONS(318),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(318),
    [anon_sym_ATreturn] = ACTIONS(318),
    [anon_sym_ATsee] = ACTIONS(318),
    [anon_sym_ATthrows] = ACTIONS(318),
    [anon_sym_ATvar] = ACTIONS(318),
    [anon_sym_ATdeprecated] = ACTIONS(318),
    [anon_sym_ATsince] = ACTIONS(318),
    [anon_sym_ATversion] = ACTIONS(318),
    [anon_sym_ATtemplate] = ACTIONS(316),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(318),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(318),
    [anon_sym_ATimplements] = ACTIONS(318),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(318),
    [anon_sym_ATextends] = ACTIONS(318),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(318),
    [anon_sym_ATuse] = ACTIONS(316),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(318),
    [anon_sym_ATafter] = ACTIONS(316),
    [anon_sym_ATafterClass] = ACTIONS(318),
    [anon_sym_ATannotation] = ACTIONS(318),
    [anon_sym_ATbackupGlobals] = ACTIONS(318),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(318),
    [anon_sym_ATbefore] = ACTIONS(316),
    [anon_sym_ATbeforeClass] = ACTIONS(318),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(316),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(318),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(318),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(318),
    [anon_sym_ATcovers] = ACTIONS(316),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(316),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(318),
    [anon_sym_ATcoversNothing] = ACTIONS(318),
    [anon_sym_ATdataProvider] = ACTIONS(318),
    [anon_sym_ATdepends] = ACTIONS(316),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(318),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(318),
    [anon_sym_ATgroup] = ACTIONS(318),
    [anon_sym_ATlarge] = ACTIONS(318),
    [anon_sym_ATmedium] = ACTIONS(318),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(318),
    [anon_sym_ATrequires] = ACTIONS(316),
    [anon_sym_ATrequiresusages] = ACTIONS(318),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(318),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(318),
    [anon_sym_ATsmall] = ACTIONS(318),
    [anon_sym_ATtest] = ACTIONS(316),
    [anon_sym_ATtestWith] = ACTIONS(318),
    [anon_sym_ATtestdox] = ACTIONS(318),
    [anon_sym_ATticket] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(316),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(316),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(316),
    [anon_sym_ATreadonly] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(318),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(318),
    [anon_sym_ATparam_DASHout] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(316),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(318),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(318),
    [anon_sym_ATmixin] = ACTIONS(318),
    [anon_sym_PIPE] = ACTIONS(318),
    [anon_sym_AMP] = ACTIONS(318),
    [anon_sym_DOLLAR] = ACTIONS(318),
    [sym__end] = ACTIONS(318),
    [sym__text_after_type] = ACTIONS(318),
  },
  [90] = {
    [anon_sym_LBRACE] = ACTIONS(338),
    [anon_sym_ATinheritdoc] = ACTIONS(338),
    [anon_sym_ATinheritDoc] = ACTIONS(338),
    [anon_sym_ATapi] = ACTIONS(338),
    [anon_sym_ATfilesource] = ACTIONS(338),
    [anon_sym_ATignore] = ACTIONS(338),
    [anon_sym_ATinternal] = ACTIONS(338),
    [anon_sym_ATcategory] = ACTIONS(338),
    [anon_sym_ATcopyright] = ACTIONS(338),
    [anon_sym_ATtodo] = ACTIONS(338),
    [anon_sym_ATexample] = ACTIONS(338),
    [anon_sym_ATlicense] = ACTIONS(338),
    [anon_sym_ATpackage] = ACTIONS(338),
    [anon_sym_ATsource] = ACTIONS(338),
    [anon_sym_ATsubpackage] = ACTIONS(338),
    [anon_sym_ATuses] = ACTIONS(338),
    [anon_sym_ATauthor] = ACTIONS(338),
    [anon_sym_ATglobal] = ACTIONS(338),
    [anon_sym_ATlink] = ACTIONS(338),
    [anon_sym_ATmethod] = ACTIONS(338),
    [anon_sym_ATparam] = ACTIONS(336),
    [anon_sym_ATproperty] = ACTIONS(336),
    [anon_sym_ATproperty_DASHread] = ACTIONS(338),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(338),
    [anon_sym_ATreturn] = ACTIONS(338),
    [anon_sym_ATsee] = ACTIONS(338),
    [anon_sym_ATthrows] = ACTIONS(338),
    [anon_sym_ATvar] = ACTIONS(338),
    [anon_sym_ATdeprecated] = ACTIONS(338),
    [anon_sym_ATsince] = ACTIONS(338),
    [anon_sym_ATversion] = ACTIONS(338),
    [anon_sym_ATtemplate] = ACTIONS(336),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(338),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(338),
    [anon_sym_ATimplements] = ACTIONS(338),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(338),
    [anon_sym_ATextends] = ACTIONS(338),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(338),
    [anon_sym_ATuse] = ACTIONS(336),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(338),
    [anon_sym_ATafter] = ACTIONS(336),
    [anon_sym_ATafterClass] = ACTIONS(338),
    [anon_sym_ATannotation] = ACTIONS(338),
    [anon_sym_ATbackupGlobals] = ACTIONS(338),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(338),
    [anon_sym_ATbefore] = ACTIONS(336),
    [anon_sym_ATbeforeClass] = ACTIONS(338),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(336),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(338),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(338),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(338),
    [anon_sym_ATcovers] = ACTIONS(336),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(336),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(338),
    [anon_sym_ATcoversNothing] = ACTIONS(338),
    [anon_sym_ATdataProvider] = ACTIONS(338),
    [anon_sym_ATdepends] = ACTIONS(336),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(338),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(338),
    [anon_sym_ATgroup] = ACTIONS(338),
    [anon_sym_ATlarge] = ACTIONS(338),
    [anon_sym_ATmedium] = ACTIONS(338),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(338),
    [anon_sym_ATrequires] = ACTIONS(336),
    [anon_sym_ATrequiresusages] = ACTIONS(338),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(338),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(338),
    [anon_sym_ATsmall] = ACTIONS(338),
    [anon_sym_ATtest] = ACTIONS(336),
    [anon_sym_ATtestWith] = ACTIONS(338),
    [anon_sym_ATtestdox] = ACTIONS(338),
    [anon_sym_ATticket] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(336),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(336),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(336),
    [anon_sym_ATreadonly] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(338),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(338),
    [anon_sym_ATparam_DASHout] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(336),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(338),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(338),
    [anon_sym_ATmixin] = ACTIONS(338),
    [anon_sym_PIPE] = ACTIONS(338),
    [anon_sym_AMP] = ACTIONS(338),
    [anon_sym_DOLLAR] = ACTIONS(338),
    [sym__end] = ACTIONS(338),
    [sym__text_after_type] = ACTIONS(338),
  },
  [91] = {
    [sym_description] = STATE(177),
    [sym_inline_tag] = STATE(116),
    [aux_sym_description_repeat1] = STATE(116),
    [anon_sym_LBRACE] = ACTIONS(5),
    [anon_sym_ATinheritdoc] = ACTIONS(462),
    [anon_sym_ATinheritDoc] = ACTIONS(462),
    [anon_sym_ATapi] = ACTIONS(462),
    [anon_sym_ATfilesource] = ACTIONS(462),
    [anon_sym_ATignore] = ACTIONS(462),
    [anon_sym_ATinternal] = ACTIONS(462),
    [anon_sym_ATcategory] = ACTIONS(462),
    [anon_sym_ATcopyright] = ACTIONS(462),
    [anon_sym_ATtodo] = ACTIONS(462),
    [anon_sym_ATexample] = ACTIONS(462),
    [anon_sym_ATlicense] = ACTIONS(462),
    [anon_sym_ATpackage] = ACTIONS(462),
    [anon_sym_ATsource] = ACTIONS(462),
    [anon_sym_ATsubpackage] = ACTIONS(462),
    [anon_sym_ATuses] = ACTIONS(462),
    [anon_sym_ATauthor] = ACTIONS(462),
    [anon_sym_ATglobal] = ACTIONS(462),
    [anon_sym_ATlink] = ACTIONS(462),
    [anon_sym_ATmethod] = ACTIONS(462),
    [anon_sym_ATparam] = ACTIONS(464),
    [anon_sym_ATproperty] = ACTIONS(464),
    [anon_sym_ATproperty_DASHread] = ACTIONS(462),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(462),
    [anon_sym_ATreturn] = ACTIONS(462),
    [anon_sym_ATsee] = ACTIONS(462),
    [anon_sym_ATthrows] = ACTIONS(462),
    [anon_sym_ATvar] = ACTIONS(462),
    [anon_sym_ATdeprecated] = ACTIONS(462),
    [anon_sym_ATsince] = ACTIONS(462),
    [anon_sym_ATversion] = ACTIONS(462),
    [anon_sym_ATtemplate] = ACTIONS(464),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(462),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(462),
    [anon_sym_ATimplements] = ACTIONS(462),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(462),
    [anon_sym_ATextends] = ACTIONS(462),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(462),
    [anon_sym_ATuse] = ACTIONS(464),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(462),
    [anon_sym_ATafter] = ACTIONS(464),
    [anon_sym_ATafterClass] = ACTIONS(462),
    [anon_sym_ATannotation] = ACTIONS(462),
    [anon_sym_ATbackupGlobals] = ACTIONS(462),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(462),
    [anon_sym_ATbefore] = ACTIONS(464),
    [anon_sym_ATbeforeClass] = ACTIONS(462),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(464),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(462),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(462),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(462),
    [anon_sym_ATcovers] = ACTIONS(464),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(464),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(462),
    [anon_sym_ATcoversNothing] = ACTIONS(462),
    [anon_sym_ATdataProvider] = ACTIONS(462),
    [anon_sym_ATdepends] = ACTIONS(464),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(462),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(462),
    [anon_sym_ATgroup] = ACTIONS(462),
    [anon_sym_ATlarge] = ACTIONS(462),
    [anon_sym_ATmedium] = ACTIONS(462),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(462),
    [anon_sym_ATrequires] = ACTIONS(464),
    [anon_sym_ATrequiresusages] = ACTIONS(462),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(462),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(462),
    [anon_sym_ATsmall] = ACTIONS(462),
    [anon_sym_ATtest] = ACTIONS(464),
    [anon_sym_ATtestWith] = ACTIONS(462),
    [anon_sym_ATtestdox] = ACTIONS(462),
    [anon_sym_ATticket] = ACTIONS(462),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(462),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(462),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(462),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(464),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(462),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(464),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(462),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(462),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(462),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(462),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(462),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(462),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(462),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(462),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(462),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(464),
    [anon_sym_ATreadonly] = ACTIONS(462),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(462),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(462),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(462),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(462),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(462),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(462),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(462),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(462),
    [anon_sym_ATparam_DASHout] = ACTIONS(462),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(462),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(464),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(462),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(462),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(462),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(462),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(462),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(462),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(462),
    [anon_sym_ATmixin] = ACTIONS(462),
    [sym__end] = ACTIONS(462),
    [sym_text] = ACTIONS(75),
  },
  [92] = {
    [aux_sym_union_type_repeat1] = STATE(106),
    [anon_sym_LBRACE] = ACTIONS(389),
    [anon_sym_ATinheritdoc] = ACTIONS(389),
    [anon_sym_ATinheritDoc] = ACTIONS(389),
    [anon_sym_ATapi] = ACTIONS(389),
    [anon_sym_ATfilesource] = ACTIONS(389),
    [anon_sym_ATignore] = ACTIONS(389),
    [anon_sym_ATinternal] = ACTIONS(389),
    [anon_sym_ATcategory] = ACTIONS(389),
    [anon_sym_ATcopyright] = ACTIONS(389),
    [anon_sym_ATtodo] = ACTIONS(389),
    [anon_sym_ATexample] = ACTIONS(389),
    [anon_sym_ATlicense] = ACTIONS(389),
    [anon_sym_ATpackage] = ACTIONS(389),
    [anon_sym_ATsource] = ACTIONS(389),
    [anon_sym_ATsubpackage] = ACTIONS(389),
    [anon_sym_ATuses] = ACTIONS(389),
    [anon_sym_ATauthor] = ACTIONS(389),
    [anon_sym_ATglobal] = ACTIONS(389),
    [anon_sym_ATlink] = ACTIONS(389),
    [anon_sym_ATmethod] = ACTIONS(389),
    [anon_sym_ATparam] = ACTIONS(387),
    [anon_sym_ATproperty] = ACTIONS(387),
    [anon_sym_ATproperty_DASHread] = ACTIONS(389),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(389),
    [anon_sym_ATreturn] = ACTIONS(389),
    [anon_sym_ATsee] = ACTIONS(389),
    [anon_sym_ATthrows] = ACTIONS(389),
    [anon_sym_ATvar] = ACTIONS(389),
    [anon_sym_ATdeprecated] = ACTIONS(389),
    [anon_sym_ATsince] = ACTIONS(389),
    [anon_sym_ATversion] = ACTIONS(389),
    [anon_sym_ATtemplate] = ACTIONS(387),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(389),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(389),
    [anon_sym_ATimplements] = ACTIONS(389),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(389),
    [anon_sym_ATextends] = ACTIONS(389),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(389),
    [anon_sym_ATuse] = ACTIONS(387),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(389),
    [anon_sym_ATafter] = ACTIONS(387),
    [anon_sym_ATafterClass] = ACTIONS(389),
    [anon_sym_ATannotation] = ACTIONS(389),
    [anon_sym_ATbackupGlobals] = ACTIONS(389),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(389),
    [anon_sym_ATbefore] = ACTIONS(387),
    [anon_sym_ATbeforeClass] = ACTIONS(389),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(387),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(389),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(389),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(389),
    [anon_sym_ATcovers] = ACTIONS(387),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(387),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(389),
    [anon_sym_ATcoversNothing] = ACTIONS(389),
    [anon_sym_ATdataProvider] = ACTIONS(389),
    [anon_sym_ATdepends] = ACTIONS(387),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(389),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(389),
    [anon_sym_ATgroup] = ACTIONS(389),
    [anon_sym_ATlarge] = ACTIONS(389),
    [anon_sym_ATmedium] = ACTIONS(389),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(389),
    [anon_sym_ATrequires] = ACTIONS(387),
    [anon_sym_ATrequiresusages] = ACTIONS(389),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(389),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(389),
    [anon_sym_ATsmall] = ACTIONS(389),
    [anon_sym_ATtest] = ACTIONS(387),
    [anon_sym_ATtestWith] = ACTIONS(389),
    [anon_sym_ATtestdox] = ACTIONS(389),
    [anon_sym_ATticket] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(387),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(387),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(387),
    [anon_sym_ATreadonly] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(389),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(389),
    [anon_sym_ATparam_DASHout] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(387),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(389),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(389),
    [anon_sym_ATmixin] = ACTIONS(389),
    [anon_sym_PIPE] = ACTIONS(466),
    [anon_sym_DOLLAR] = ACTIONS(389),
    [sym__end] = ACTIONS(389),
    [sym__text_after_type] = ACTIONS(389),
  },
  [93] = {
    [aux_sym_intersection_type_repeat1] = STATE(107),
    [anon_sym_LBRACE] = ACTIONS(349),
    [anon_sym_ATinheritdoc] = ACTIONS(349),
    [anon_sym_ATinheritDoc] = ACTIONS(349),
    [anon_sym_ATapi] = ACTIONS(349),
    [anon_sym_ATfilesource] = ACTIONS(349),
    [anon_sym_ATignore] = ACTIONS(349),
    [anon_sym_ATinternal] = ACTIONS(349),
    [anon_sym_ATcategory] = ACTIONS(349),
    [anon_sym_ATcopyright] = ACTIONS(349),
    [anon_sym_ATtodo] = ACTIONS(349),
    [anon_sym_ATexample] = ACTIONS(349),
    [anon_sym_ATlicense] = ACTIONS(349),
    [anon_sym_ATpackage] = ACTIONS(349),
    [anon_sym_ATsource] = ACTIONS(349),
    [anon_sym_ATsubpackage] = ACTIONS(349),
    [anon_sym_ATuses] = ACTIONS(349),
    [anon_sym_ATauthor] = ACTIONS(349),
    [anon_sym_ATglobal] = ACTIONS(349),
    [anon_sym_ATlink] = ACTIONS(349),
    [anon_sym_ATmethod] = ACTIONS(349),
    [anon_sym_ATparam] = ACTIONS(347),
    [anon_sym_ATproperty] = ACTIONS(347),
    [anon_sym_ATproperty_DASHread] = ACTIONS(349),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(349),
    [anon_sym_ATreturn] = ACTIONS(349),
    [anon_sym_ATsee] = ACTIONS(349),
    [anon_sym_ATthrows] = ACTIONS(349),
    [anon_sym_ATvar] = ACTIONS(349),
    [anon_sym_ATdeprecated] = ACTIONS(349),
    [anon_sym_ATsince] = ACTIONS(349),
    [anon_sym_ATversion] = ACTIONS(349),
    [anon_sym_ATtemplate] = ACTIONS(347),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(349),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(349),
    [anon_sym_ATimplements] = ACTIONS(349),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(349),
    [anon_sym_ATextends] = ACTIONS(349),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(349),
    [anon_sym_ATuse] = ACTIONS(347),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(349),
    [anon_sym_ATafter] = ACTIONS(347),
    [anon_sym_ATafterClass] = ACTIONS(349),
    [anon_sym_ATannotation] = ACTIONS(349),
    [anon_sym_ATbackupGlobals] = ACTIONS(349),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(349),
    [anon_sym_ATbefore] = ACTIONS(347),
    [anon_sym_ATbeforeClass] = ACTIONS(349),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(347),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(349),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(349),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(349),
    [anon_sym_ATcovers] = ACTIONS(347),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(347),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(349),
    [anon_sym_ATcoversNothing] = ACTIONS(349),
    [anon_sym_ATdataProvider] = ACTIONS(349),
    [anon_sym_ATdepends] = ACTIONS(347),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(349),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(349),
    [anon_sym_ATgroup] = ACTIONS(349),
    [anon_sym_ATlarge] = ACTIONS(349),
    [anon_sym_ATmedium] = ACTIONS(349),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(349),
    [anon_sym_ATrequires] = ACTIONS(347),
    [anon_sym_ATrequiresusages] = ACTIONS(349),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(349),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(349),
    [anon_sym_ATsmall] = ACTIONS(349),
    [anon_sym_ATtest] = ACTIONS(347),
    [anon_sym_ATtestWith] = ACTIONS(349),
    [anon_sym_ATtestdox] = ACTIONS(349),
    [anon_sym_ATticket] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(347),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(347),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(347),
    [anon_sym_ATreadonly] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(349),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(349),
    [anon_sym_ATparam_DASHout] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(347),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(349),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(349),
    [anon_sym_ATmixin] = ACTIONS(349),
    [anon_sym_AMP] = ACTIONS(314),
    [anon_sym_DOLLAR] = ACTIONS(349),
    [sym__end] = ACTIONS(349),
    [sym__text_after_type] = ACTIONS(349),
  },
  [94] = {
    [aux_sym_disjunctive_normal_form_type_repeat1] = STATE(109),
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_ATinheritdoc] = ACTIONS(406),
    [anon_sym_ATinheritDoc] = ACTIONS(406),
    [anon_sym_ATapi] = ACTIONS(406),
    [anon_sym_ATfilesource] = ACTIONS(406),
    [anon_sym_ATignore] = ACTIONS(406),
    [anon_sym_ATinternal] = ACTIONS(406),
    [anon_sym_ATcategory] = ACTIONS(406),
    [anon_sym_ATcopyright] = ACTIONS(406),
    [anon_sym_ATtodo] = ACTIONS(406),
    [anon_sym_ATexample] = ACTIONS(406),
    [anon_sym_ATlicense] = ACTIONS(406),
    [anon_sym_ATpackage] = ACTIONS(406),
    [anon_sym_ATsource] = ACTIONS(406),
    [anon_sym_ATsubpackage] = ACTIONS(406),
    [anon_sym_ATuses] = ACTIONS(406),
    [anon_sym_ATauthor] = ACTIONS(406),
    [anon_sym_ATglobal] = ACTIONS(406),
    [anon_sym_ATlink] = ACTIONS(406),
    [anon_sym_ATmethod] = ACTIONS(406),
    [anon_sym_ATparam] = ACTIONS(404),
    [anon_sym_ATproperty] = ACTIONS(404),
    [anon_sym_ATproperty_DASHread] = ACTIONS(406),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(406),
    [anon_sym_ATreturn] = ACTIONS(406),
    [anon_sym_ATsee] = ACTIONS(406),
    [anon_sym_ATthrows] = ACTIONS(406),
    [anon_sym_ATvar] = ACTIONS(406),
    [anon_sym_ATdeprecated] = ACTIONS(406),
    [anon_sym_ATsince] = ACTIONS(406),
    [anon_sym_ATversion] = ACTIONS(406),
    [anon_sym_ATtemplate] = ACTIONS(404),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(406),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(406),
    [anon_sym_ATimplements] = ACTIONS(406),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(406),
    [anon_sym_ATextends] = ACTIONS(406),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(406),
    [anon_sym_ATuse] = ACTIONS(404),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(406),
    [anon_sym_ATafter] = ACTIONS(404),
    [anon_sym_ATafterClass] = ACTIONS(406),
    [anon_sym_ATannotation] = ACTIONS(406),
    [anon_sym_ATbackupGlobals] = ACTIONS(406),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(406),
    [anon_sym_ATbefore] = ACTIONS(404),
    [anon_sym_ATbeforeClass] = ACTIONS(406),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(404),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(406),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(406),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(406),
    [anon_sym_ATcovers] = ACTIONS(404),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(404),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(406),
    [anon_sym_ATcoversNothing] = ACTIONS(406),
    [anon_sym_ATdataProvider] = ACTIONS(406),
    [anon_sym_ATdepends] = ACTIONS(404),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(406),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(406),
    [anon_sym_ATgroup] = ACTIONS(406),
    [anon_sym_ATlarge] = ACTIONS(406),
    [anon_sym_ATmedium] = ACTIONS(406),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(406),
    [anon_sym_ATrequires] = ACTIONS(404),
    [anon_sym_ATrequiresusages] = ACTIONS(406),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(406),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(406),
    [anon_sym_ATsmall] = ACTIONS(406),
    [anon_sym_ATtest] = ACTIONS(404),
    [anon_sym_ATtestWith] = ACTIONS(406),
    [anon_sym_ATtestdox] = ACTIONS(406),
    [anon_sym_ATticket] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(404),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(404),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(404),
    [anon_sym_ATreadonly] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(406),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(406),
    [anon_sym_ATparam_DASHout] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(404),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(406),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(406),
    [anon_sym_ATmixin] = ACTIONS(406),
    [anon_sym_PIPE] = ACTIONS(468),
    [anon_sym_DOLLAR] = ACTIONS(406),
    [sym__end] = ACTIONS(406),
    [sym__text_after_type] = ACTIONS(406),
  },
  [95] = {
    [anon_sym_LBRACE] = ACTIONS(267),
    [anon_sym_ATinheritdoc] = ACTIONS(267),
    [anon_sym_ATinheritDoc] = ACTIONS(267),
    [anon_sym_ATapi] = ACTIONS(267),
    [anon_sym_ATfilesource] = ACTIONS(267),
    [anon_sym_ATignore] = ACTIONS(267),
    [anon_sym_ATinternal] = ACTIONS(267),
    [anon_sym_ATcategory] = ACTIONS(267),
    [anon_sym_ATcopyright] = ACTIONS(267),
    [anon_sym_ATtodo] = ACTIONS(267),
    [anon_sym_ATexample] = ACTIONS(267),
    [anon_sym_ATlicense] = ACTIONS(267),
    [anon_sym_ATpackage] = ACTIONS(267),
    [anon_sym_ATsource] = ACTIONS(267),
    [anon_sym_ATsubpackage] = ACTIONS(267),
    [anon_sym_ATuses] = ACTIONS(267),
    [anon_sym_ATauthor] = ACTIONS(267),
    [anon_sym_ATglobal] = ACTIONS(267),
    [anon_sym_ATlink] = ACTIONS(267),
    [anon_sym_ATmethod] = ACTIONS(267),
    [anon_sym_ATparam] = ACTIONS(265),
    [anon_sym_ATproperty] = ACTIONS(265),
    [anon_sym_ATproperty_DASHread] = ACTIONS(267),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(267),
    [anon_sym_ATreturn] = ACTIONS(267),
    [anon_sym_ATsee] = ACTIONS(267),
    [anon_sym_ATthrows] = ACTIONS(267),
    [anon_sym_ATvar] = ACTIONS(267),
    [anon_sym_ATdeprecated] = ACTIONS(267),
    [anon_sym_ATsince] = ACTIONS(267),
    [anon_sym_ATversion] = ACTIONS(267),
    [anon_sym_ATtemplate] = ACTIONS(265),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(267),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(267),
    [anon_sym_ATimplements] = ACTIONS(267),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(267),
    [anon_sym_ATextends] = ACTIONS(267),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(267),
    [anon_sym_ATuse] = ACTIONS(265),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(267),
    [anon_sym_ATafter] = ACTIONS(265),
    [anon_sym_ATafterClass] = ACTIONS(267),
    [anon_sym_ATannotation] = ACTIONS(267),
    [anon_sym_ATbackupGlobals] = ACTIONS(267),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(267),
    [anon_sym_ATbefore] = ACTIONS(265),
    [anon_sym_ATbeforeClass] = ACTIONS(267),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(265),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(267),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(267),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(267),
    [anon_sym_ATcovers] = ACTIONS(265),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(265),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(267),
    [anon_sym_ATcoversNothing] = ACTIONS(267),
    [anon_sym_ATdataProvider] = ACTIONS(267),
    [anon_sym_ATdepends] = ACTIONS(265),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(267),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(267),
    [anon_sym_ATgroup] = ACTIONS(267),
    [anon_sym_ATlarge] = ACTIONS(267),
    [anon_sym_ATmedium] = ACTIONS(267),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(267),
    [anon_sym_ATrequires] = ACTIONS(265),
    [anon_sym_ATrequiresusages] = ACTIONS(267),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(267),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(267),
    [anon_sym_ATsmall] = ACTIONS(267),
    [anon_sym_ATtest] = ACTIONS(265),
    [anon_sym_ATtestWith] = ACTIONS(267),
    [anon_sym_ATtestdox] = ACTIONS(267),
    [anon_sym_ATticket] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(265),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(265),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(265),
    [anon_sym_ATreadonly] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(267),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(267),
    [anon_sym_ATparam_DASHout] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(265),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(267),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(267),
    [anon_sym_ATmixin] = ACTIONS(267),
    [anon_sym_PIPE] = ACTIONS(267),
    [anon_sym_AMP] = ACTIONS(267),
    [anon_sym_DOLLAR] = ACTIONS(267),
    [sym__end] = ACTIONS(267),
    [sym__text_after_type] = ACTIONS(267),
  },
  [96] = {
    [sym_description] = STATE(169),
    [sym_inline_tag] = STATE(116),
    [aux_sym_description_repeat1] = STATE(116),
    [anon_sym_LBRACE] = ACTIONS(5),
    [anon_sym_ATinheritdoc] = ACTIONS(470),
    [anon_sym_ATinheritDoc] = ACTIONS(470),
    [anon_sym_ATapi] = ACTIONS(470),
    [anon_sym_ATfilesource] = ACTIONS(470),
    [anon_sym_ATignore] = ACTIONS(470),
    [anon_sym_ATinternal] = ACTIONS(470),
    [anon_sym_ATcategory] = ACTIONS(470),
    [anon_sym_ATcopyright] = ACTIONS(470),
    [anon_sym_ATtodo] = ACTIONS(470),
    [anon_sym_ATexample] = ACTIONS(470),
    [anon_sym_ATlicense] = ACTIONS(470),
    [anon_sym_ATpackage] = ACTIONS(470),
    [anon_sym_ATsource] = ACTIONS(470),
    [anon_sym_ATsubpackage] = ACTIONS(470),
    [anon_sym_ATuses] = ACTIONS(470),
    [anon_sym_ATauthor] = ACTIONS(470),
    [anon_sym_ATglobal] = ACTIONS(470),
    [anon_sym_ATlink] = ACTIONS(470),
    [anon_sym_ATmethod] = ACTIONS(470),
    [anon_sym_ATparam] = ACTIONS(472),
    [anon_sym_ATproperty] = ACTIONS(472),
    [anon_sym_ATproperty_DASHread] = ACTIONS(470),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(470),
    [anon_sym_ATreturn] = ACTIONS(470),
    [anon_sym_ATsee] = ACTIONS(470),
    [anon_sym_ATthrows] = ACTIONS(470),
    [anon_sym_ATvar] = ACTIONS(470),
    [anon_sym_ATdeprecated] = ACTIONS(470),
    [anon_sym_ATsince] = ACTIONS(470),
    [anon_sym_ATversion] = ACTIONS(470),
    [anon_sym_ATtemplate] = ACTIONS(472),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(470),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(470),
    [anon_sym_ATimplements] = ACTIONS(470),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(470),
    [anon_sym_ATextends] = ACTIONS(470),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(470),
    [anon_sym_ATuse] = ACTIONS(472),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(470),
    [anon_sym_ATafter] = ACTIONS(472),
    [anon_sym_ATafterClass] = ACTIONS(470),
    [anon_sym_ATannotation] = ACTIONS(470),
    [anon_sym_ATbackupGlobals] = ACTIONS(470),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(470),
    [anon_sym_ATbefore] = ACTIONS(472),
    [anon_sym_ATbeforeClass] = ACTIONS(470),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(472),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(470),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(470),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(470),
    [anon_sym_ATcovers] = ACTIONS(472),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(472),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(470),
    [anon_sym_ATcoversNothing] = ACTIONS(470),
    [anon_sym_ATdataProvider] = ACTIONS(470),
    [anon_sym_ATdepends] = ACTIONS(472),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(470),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(470),
    [anon_sym_ATgroup] = ACTIONS(470),
    [anon_sym_ATlarge] = ACTIONS(470),
    [anon_sym_ATmedium] = ACTIONS(470),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(470),
    [anon_sym_ATrequires] = ACTIONS(472),
    [anon_sym_ATrequiresusages] = ACTIONS(470),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(470),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(470),
    [anon_sym_ATsmall] = ACTIONS(470),
    [anon_sym_ATtest] = ACTIONS(472),
    [anon_sym_ATtestWith] = ACTIONS(470),
    [anon_sym_ATtestdox] = ACTIONS(470),
    [anon_sym_ATticket] = ACTIONS(470),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(470),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(470),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(470),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(472),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(470),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(472),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(470),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(470),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(470),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(470),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(470),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(470),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(470),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(470),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(470),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(472),
    [anon_sym_ATreadonly] = ACTIONS(470),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(470),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(470),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(470),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(470),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(470),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(470),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(470),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(470),
    [anon_sym_ATparam_DASHout] = ACTIONS(470),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(470),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(472),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(470),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(470),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(470),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(470),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(470),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(470),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(470),
    [anon_sym_ATmixin] = ACTIONS(470),
    [sym__end] = ACTIONS(470),
    [sym_text] = ACTIONS(75),
  },
  [97] = {
    [sym_description] = STATE(176),
    [sym_inline_tag] = STATE(116),
    [aux_sym_description_repeat1] = STATE(116),
    [anon_sym_LBRACE] = ACTIONS(5),
    [anon_sym_ATinheritdoc] = ACTIONS(474),
    [anon_sym_ATinheritDoc] = ACTIONS(474),
    [anon_sym_ATapi] = ACTIONS(474),
    [anon_sym_ATfilesource] = ACTIONS(474),
    [anon_sym_ATignore] = ACTIONS(474),
    [anon_sym_ATinternal] = ACTIONS(474),
    [anon_sym_ATcategory] = ACTIONS(474),
    [anon_sym_ATcopyright] = ACTIONS(474),
    [anon_sym_ATtodo] = ACTIONS(474),
    [anon_sym_ATexample] = ACTIONS(474),
    [anon_sym_ATlicense] = ACTIONS(474),
    [anon_sym_ATpackage] = ACTIONS(474),
    [anon_sym_ATsource] = ACTIONS(474),
    [anon_sym_ATsubpackage] = ACTIONS(474),
    [anon_sym_ATuses] = ACTIONS(474),
    [anon_sym_ATauthor] = ACTIONS(474),
    [anon_sym_ATglobal] = ACTIONS(474),
    [anon_sym_ATlink] = ACTIONS(474),
    [anon_sym_ATmethod] = ACTIONS(474),
    [anon_sym_ATparam] = ACTIONS(476),
    [anon_sym_ATproperty] = ACTIONS(476),
    [anon_sym_ATproperty_DASHread] = ACTIONS(474),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(474),
    [anon_sym_ATreturn] = ACTIONS(474),
    [anon_sym_ATsee] = ACTIONS(474),
    [anon_sym_ATthrows] = ACTIONS(474),
    [anon_sym_ATvar] = ACTIONS(474),
    [anon_sym_ATdeprecated] = ACTIONS(474),
    [anon_sym_ATsince] = ACTIONS(474),
    [anon_sym_ATversion] = ACTIONS(474),
    [anon_sym_ATtemplate] = ACTIONS(476),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(474),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(474),
    [anon_sym_ATimplements] = ACTIONS(474),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(474),
    [anon_sym_ATextends] = ACTIONS(474),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(474),
    [anon_sym_ATuse] = ACTIONS(476),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(474),
    [anon_sym_ATafter] = ACTIONS(476),
    [anon_sym_ATafterClass] = ACTIONS(474),
    [anon_sym_ATannotation] = ACTIONS(474),
    [anon_sym_ATbackupGlobals] = ACTIONS(474),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(474),
    [anon_sym_ATbefore] = ACTIONS(476),
    [anon_sym_ATbeforeClass] = ACTIONS(474),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(476),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(474),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(474),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(474),
    [anon_sym_ATcovers] = ACTIONS(476),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(476),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(474),
    [anon_sym_ATcoversNothing] = ACTIONS(474),
    [anon_sym_ATdataProvider] = ACTIONS(474),
    [anon_sym_ATdepends] = ACTIONS(476),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(474),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(474),
    [anon_sym_ATgroup] = ACTIONS(474),
    [anon_sym_ATlarge] = ACTIONS(474),
    [anon_sym_ATmedium] = ACTIONS(474),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(474),
    [anon_sym_ATrequires] = ACTIONS(476),
    [anon_sym_ATrequiresusages] = ACTIONS(474),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(474),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(474),
    [anon_sym_ATsmall] = ACTIONS(474),
    [anon_sym_ATtest] = ACTIONS(476),
    [anon_sym_ATtestWith] = ACTIONS(474),
    [anon_sym_ATtestdox] = ACTIONS(474),
    [anon_sym_ATticket] = ACTIONS(474),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(474),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(474),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(474),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(476),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(474),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(476),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(474),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(474),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(474),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(474),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(474),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(474),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(474),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(474),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(474),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(476),
    [anon_sym_ATreadonly] = ACTIONS(474),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(474),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(474),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(474),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(474),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(474),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(474),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(474),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(474),
    [anon_sym_ATparam_DASHout] = ACTIONS(474),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(474),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(476),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(474),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(474),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(474),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(474),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(474),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(474),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(474),
    [anon_sym_ATmixin] = ACTIONS(474),
    [sym__end] = ACTIONS(474),
    [sym_text] = ACTIONS(75),
  },
  [98] = {
    [aux_sym_disjunctive_normal_form_type_repeat1] = STATE(105),
    [anon_sym_LBRACE] = ACTIONS(402),
    [anon_sym_ATinheritdoc] = ACTIONS(402),
    [anon_sym_ATinheritDoc] = ACTIONS(402),
    [anon_sym_ATapi] = ACTIONS(402),
    [anon_sym_ATfilesource] = ACTIONS(402),
    [anon_sym_ATignore] = ACTIONS(402),
    [anon_sym_ATinternal] = ACTIONS(402),
    [anon_sym_ATcategory] = ACTIONS(402),
    [anon_sym_ATcopyright] = ACTIONS(402),
    [anon_sym_ATtodo] = ACTIONS(402),
    [anon_sym_ATexample] = ACTIONS(402),
    [anon_sym_ATlicense] = ACTIONS(402),
    [anon_sym_ATpackage] = ACTIONS(402),
    [anon_sym_ATsource] = ACTIONS(402),
    [anon_sym_ATsubpackage] = ACTIONS(402),
    [anon_sym_ATuses] = ACTIONS(402),
    [anon_sym_ATauthor] = ACTIONS(402),
    [anon_sym_ATglobal] = ACTIONS(402),
    [anon_sym_ATlink] = ACTIONS(402),
    [anon_sym_ATmethod] = ACTIONS(402),
    [anon_sym_ATparam] = ACTIONS(400),
    [anon_sym_ATproperty] = ACTIONS(400),
    [anon_sym_ATproperty_DASHread] = ACTIONS(402),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(402),
    [anon_sym_ATreturn] = ACTIONS(402),
    [anon_sym_ATsee] = ACTIONS(402),
    [anon_sym_ATthrows] = ACTIONS(402),
    [anon_sym_ATvar] = ACTIONS(402),
    [anon_sym_ATdeprecated] = ACTIONS(402),
    [anon_sym_ATsince] = ACTIONS(402),
    [anon_sym_ATversion] = ACTIONS(402),
    [anon_sym_ATtemplate] = ACTIONS(400),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(402),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(402),
    [anon_sym_ATimplements] = ACTIONS(402),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(402),
    [anon_sym_ATextends] = ACTIONS(402),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(402),
    [anon_sym_ATuse] = ACTIONS(400),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(402),
    [anon_sym_ATafter] = ACTIONS(400),
    [anon_sym_ATafterClass] = ACTIONS(402),
    [anon_sym_ATannotation] = ACTIONS(402),
    [anon_sym_ATbackupGlobals] = ACTIONS(402),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(402),
    [anon_sym_ATbefore] = ACTIONS(400),
    [anon_sym_ATbeforeClass] = ACTIONS(402),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(400),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(402),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(402),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(402),
    [anon_sym_ATcovers] = ACTIONS(400),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(400),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(402),
    [anon_sym_ATcoversNothing] = ACTIONS(402),
    [anon_sym_ATdataProvider] = ACTIONS(402),
    [anon_sym_ATdepends] = ACTIONS(400),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(402),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(402),
    [anon_sym_ATgroup] = ACTIONS(402),
    [anon_sym_ATlarge] = ACTIONS(402),
    [anon_sym_ATmedium] = ACTIONS(402),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(402),
    [anon_sym_ATrequires] = ACTIONS(400),
    [anon_sym_ATrequiresusages] = ACTIONS(402),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(402),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(402),
    [anon_sym_ATsmall] = ACTIONS(402),
    [anon_sym_ATtest] = ACTIONS(400),
    [anon_sym_ATtestWith] = ACTIONS(402),
    [anon_sym_ATtestdox] = ACTIONS(402),
    [anon_sym_ATticket] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(400),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(400),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(400),
    [anon_sym_ATreadonly] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(402),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(402),
    [anon_sym_ATparam_DASHout] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(400),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(402),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(402),
    [anon_sym_ATmixin] = ACTIONS(402),
    [anon_sym_PIPE] = ACTIONS(468),
    [anon_sym_DOLLAR] = ACTIONS(402),
    [sym__end] = ACTIONS(402),
    [sym__text_after_type] = ACTIONS(402),
  },
  [99] = {
    [sym__type_argument_list] = STATE(132),
    [anon_sym_LBRACE] = ACTIONS(223),
    [anon_sym_ATinheritdoc] = ACTIONS(223),
    [anon_sym_ATinheritDoc] = ACTIONS(223),
    [anon_sym_ATapi] = ACTIONS(223),
    [anon_sym_ATfilesource] = ACTIONS(223),
    [anon_sym_ATignore] = ACTIONS(223),
    [anon_sym_ATinternal] = ACTIONS(223),
    [anon_sym_ATcategory] = ACTIONS(223),
    [anon_sym_ATcopyright] = ACTIONS(223),
    [anon_sym_ATtodo] = ACTIONS(223),
    [anon_sym_ATexample] = ACTIONS(223),
    [anon_sym_ATlicense] = ACTIONS(223),
    [anon_sym_ATpackage] = ACTIONS(223),
    [anon_sym_ATsource] = ACTIONS(223),
    [anon_sym_ATsubpackage] = ACTIONS(223),
    [anon_sym_ATuses] = ACTIONS(223),
    [anon_sym_ATauthor] = ACTIONS(223),
    [anon_sym_LT] = ACTIONS(300),
    [anon_sym_ATglobal] = ACTIONS(223),
    [anon_sym_ATlink] = ACTIONS(223),
    [anon_sym_ATmethod] = ACTIONS(223),
    [anon_sym_ATparam] = ACTIONS(221),
    [anon_sym_ATproperty] = ACTIONS(221),
    [anon_sym_ATproperty_DASHread] = ACTIONS(223),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(223),
    [anon_sym_ATreturn] = ACTIONS(223),
    [anon_sym_ATsee] = ACTIONS(223),
    [anon_sym_ATthrows] = ACTIONS(223),
    [anon_sym_ATvar] = ACTIONS(223),
    [anon_sym_ATdeprecated] = ACTIONS(223),
    [anon_sym_ATsince] = ACTIONS(223),
    [anon_sym_ATversion] = ACTIONS(223),
    [anon_sym_ATtemplate] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(223),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(223),
    [anon_sym_ATimplements] = ACTIONS(223),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(223),
    [anon_sym_ATextends] = ACTIONS(223),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(223),
    [anon_sym_ATuse] = ACTIONS(221),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(223),
    [anon_sym_ATafter] = ACTIONS(221),
    [anon_sym_ATafterClass] = ACTIONS(223),
    [anon_sym_ATannotation] = ACTIONS(223),
    [anon_sym_ATbackupGlobals] = ACTIONS(223),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(223),
    [anon_sym_ATbefore] = ACTIONS(221),
    [anon_sym_ATbeforeClass] = ACTIONS(223),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(221),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(223),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(223),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(223),
    [anon_sym_ATcovers] = ACTIONS(221),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(221),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(223),
    [anon_sym_ATcoversNothing] = ACTIONS(223),
    [anon_sym_ATdataProvider] = ACTIONS(223),
    [anon_sym_ATdepends] = ACTIONS(221),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(223),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(223),
    [anon_sym_ATgroup] = ACTIONS(223),
    [anon_sym_ATlarge] = ACTIONS(223),
    [anon_sym_ATmedium] = ACTIONS(223),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(223),
    [anon_sym_ATrequires] = ACTIONS(221),
    [anon_sym_ATrequiresusages] = ACTIONS(223),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(223),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(223),
    [anon_sym_ATsmall] = ACTIONS(223),
    [anon_sym_ATtest] = ACTIONS(221),
    [anon_sym_ATtestWith] = ACTIONS(223),
    [anon_sym_ATtestdox] = ACTIONS(223),
    [anon_sym_ATticket] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(221),
    [anon_sym_ATreadonly] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(223),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(223),
    [anon_sym_ATparam_DASHout] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(223),
    [anon_sym_ATmixin] = ACTIONS(223),
    [anon_sym_COLON_COLON] = ACTIONS(223),
    [sym__end] = ACTIONS(223),
    [sym_text] = ACTIONS(223),
  },
  [100] = {
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_ATinheritdoc] = ACTIONS(334),
    [anon_sym_ATinheritDoc] = ACTIONS(334),
    [anon_sym_ATapi] = ACTIONS(334),
    [anon_sym_ATfilesource] = ACTIONS(334),
    [anon_sym_ATignore] = ACTIONS(334),
    [anon_sym_ATinternal] = ACTIONS(334),
    [anon_sym_ATcategory] = ACTIONS(334),
    [anon_sym_ATcopyright] = ACTIONS(334),
    [anon_sym_ATtodo] = ACTIONS(334),
    [anon_sym_ATexample] = ACTIONS(334),
    [anon_sym_ATlicense] = ACTIONS(334),
    [anon_sym_ATpackage] = ACTIONS(334),
    [anon_sym_ATsource] = ACTIONS(334),
    [anon_sym_ATsubpackage] = ACTIONS(334),
    [anon_sym_ATuses] = ACTIONS(334),
    [anon_sym_ATauthor] = ACTIONS(334),
    [anon_sym_ATglobal] = ACTIONS(334),
    [anon_sym_ATlink] = ACTIONS(334),
    [anon_sym_ATmethod] = ACTIONS(334),
    [anon_sym_ATparam] = ACTIONS(332),
    [anon_sym_ATproperty] = ACTIONS(332),
    [anon_sym_ATproperty_DASHread] = ACTIONS(334),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(334),
    [anon_sym_ATreturn] = ACTIONS(334),
    [anon_sym_ATsee] = ACTIONS(334),
    [anon_sym_ATthrows] = ACTIONS(334),
    [anon_sym_ATvar] = ACTIONS(334),
    [anon_sym_ATdeprecated] = ACTIONS(334),
    [anon_sym_ATsince] = ACTIONS(334),
    [anon_sym_ATversion] = ACTIONS(334),
    [anon_sym_ATtemplate] = ACTIONS(332),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(334),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(334),
    [anon_sym_ATimplements] = ACTIONS(334),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(334),
    [anon_sym_ATextends] = ACTIONS(334),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(334),
    [anon_sym_ATuse] = ACTIONS(332),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(334),
    [anon_sym_ATafter] = ACTIONS(332),
    [anon_sym_ATafterClass] = ACTIONS(334),
    [anon_sym_ATannotation] = ACTIONS(334),
    [anon_sym_ATbackupGlobals] = ACTIONS(334),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(334),
    [anon_sym_ATbefore] = ACTIONS(332),
    [anon_sym_ATbeforeClass] = ACTIONS(334),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(332),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(334),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(334),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(334),
    [anon_sym_ATcovers] = ACTIONS(332),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(332),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(334),
    [anon_sym_ATcoversNothing] = ACTIONS(334),
    [anon_sym_ATdataProvider] = ACTIONS(334),
    [anon_sym_ATdepends] = ACTIONS(332),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(334),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(334),
    [anon_sym_ATgroup] = ACTIONS(334),
    [anon_sym_ATlarge] = ACTIONS(334),
    [anon_sym_ATmedium] = ACTIONS(334),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(334),
    [anon_sym_ATrequires] = ACTIONS(332),
    [anon_sym_ATrequiresusages] = ACTIONS(334),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(334),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(334),
    [anon_sym_ATsmall] = ACTIONS(334),
    [anon_sym_ATtest] = ACTIONS(332),
    [anon_sym_ATtestWith] = ACTIONS(334),
    [anon_sym_ATtestdox] = ACTIONS(334),
    [anon_sym_ATticket] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(332),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(332),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(332),
    [anon_sym_ATreadonly] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(334),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(334),
    [anon_sym_ATparam_DASHout] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(332),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(334),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(334),
    [anon_sym_ATmixin] = ACTIONS(334),
    [anon_sym_PIPE] = ACTIONS(334),
    [anon_sym_AMP] = ACTIONS(334),
    [anon_sym_DOLLAR] = ACTIONS(334),
    [sym__end] = ACTIONS(334),
    [sym__text_after_type] = ACTIONS(334),
  },
  [101] = {
    [anon_sym_LBRACE] = ACTIONS(322),
    [anon_sym_ATinheritdoc] = ACTIONS(322),
    [anon_sym_ATinheritDoc] = ACTIONS(322),
    [anon_sym_ATapi] = ACTIONS(322),
    [anon_sym_ATfilesource] = ACTIONS(322),
    [anon_sym_ATignore] = ACTIONS(322),
    [anon_sym_ATinternal] = ACTIONS(322),
    [anon_sym_ATcategory] = ACTIONS(322),
    [anon_sym_ATcopyright] = ACTIONS(322),
    [anon_sym_ATtodo] = ACTIONS(322),
    [anon_sym_ATexample] = ACTIONS(322),
    [anon_sym_ATlicense] = ACTIONS(322),
    [anon_sym_ATpackage] = ACTIONS(322),
    [anon_sym_ATsource] = ACTIONS(322),
    [anon_sym_ATsubpackage] = ACTIONS(322),
    [anon_sym_ATuses] = ACTIONS(322),
    [anon_sym_ATauthor] = ACTIONS(322),
    [anon_sym_ATglobal] = ACTIONS(322),
    [anon_sym_ATlink] = ACTIONS(322),
    [anon_sym_ATmethod] = ACTIONS(322),
    [anon_sym_ATparam] = ACTIONS(320),
    [anon_sym_ATproperty] = ACTIONS(320),
    [anon_sym_ATproperty_DASHread] = ACTIONS(322),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(322),
    [anon_sym_ATreturn] = ACTIONS(322),
    [anon_sym_ATsee] = ACTIONS(322),
    [anon_sym_ATthrows] = ACTIONS(322),
    [anon_sym_ATvar] = ACTIONS(322),
    [anon_sym_ATdeprecated] = ACTIONS(322),
    [anon_sym_ATsince] = ACTIONS(322),
    [anon_sym_ATversion] = ACTIONS(322),
    [anon_sym_ATtemplate] = ACTIONS(320),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(322),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(322),
    [anon_sym_ATimplements] = ACTIONS(322),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(322),
    [anon_sym_ATextends] = ACTIONS(322),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(322),
    [anon_sym_ATuse] = ACTIONS(320),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(322),
    [anon_sym_ATafter] = ACTIONS(320),
    [anon_sym_ATafterClass] = ACTIONS(322),
    [anon_sym_ATannotation] = ACTIONS(322),
    [anon_sym_ATbackupGlobals] = ACTIONS(322),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(322),
    [anon_sym_ATbefore] = ACTIONS(320),
    [anon_sym_ATbeforeClass] = ACTIONS(322),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(320),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(322),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(322),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(322),
    [anon_sym_ATcovers] = ACTIONS(320),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(320),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(322),
    [anon_sym_ATcoversNothing] = ACTIONS(322),
    [anon_sym_ATdataProvider] = ACTIONS(322),
    [anon_sym_ATdepends] = ACTIONS(320),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(322),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(322),
    [anon_sym_ATgroup] = ACTIONS(322),
    [anon_sym_ATlarge] = ACTIONS(322),
    [anon_sym_ATmedium] = ACTIONS(322),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(322),
    [anon_sym_ATrequires] = ACTIONS(320),
    [anon_sym_ATrequiresusages] = ACTIONS(322),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(322),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(322),
    [anon_sym_ATsmall] = ACTIONS(322),
    [anon_sym_ATtest] = ACTIONS(320),
    [anon_sym_ATtestWith] = ACTIONS(322),
    [anon_sym_ATtestdox] = ACTIONS(322),
    [anon_sym_ATticket] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(320),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(320),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(320),
    [anon_sym_ATreadonly] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(322),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(322),
    [anon_sym_ATparam_DASHout] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(320),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(322),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(322),
    [anon_sym_ATmixin] = ACTIONS(322),
    [anon_sym_PIPE] = ACTIONS(322),
    [anon_sym_AMP] = ACTIONS(322),
    [anon_sym_DOLLAR] = ACTIONS(322),
    [sym__end] = ACTIONS(322),
    [sym__text_after_type] = ACTIONS(322),
  },
  [102] = {
    [sym_description] = STATE(164),
    [sym_inline_tag] = STATE(116),
    [aux_sym_description_repeat1] = STATE(116),
    [anon_sym_LBRACE] = ACTIONS(5),
    [anon_sym_ATinheritdoc] = ACTIONS(478),
    [anon_sym_ATinheritDoc] = ACTIONS(478),
    [anon_sym_ATapi] = ACTIONS(478),
    [anon_sym_ATfilesource] = ACTIONS(478),
    [anon_sym_ATignore] = ACTIONS(478),
    [anon_sym_ATinternal] = ACTIONS(478),
    [anon_sym_ATcategory] = ACTIONS(478),
    [anon_sym_ATcopyright] = ACTIONS(478),
    [anon_sym_ATtodo] = ACTIONS(478),
    [anon_sym_ATexample] = ACTIONS(478),
    [anon_sym_ATlicense] = ACTIONS(478),
    [anon_sym_ATpackage] = ACTIONS(478),
    [anon_sym_ATsource] = ACTIONS(478),
    [anon_sym_ATsubpackage] = ACTIONS(478),
    [anon_sym_ATuses] = ACTIONS(478),
    [anon_sym_ATauthor] = ACTIONS(478),
    [anon_sym_ATglobal] = ACTIONS(478),
    [anon_sym_ATlink] = ACTIONS(478),
    [anon_sym_ATmethod] = ACTIONS(478),
    [anon_sym_ATparam] = ACTIONS(480),
    [anon_sym_ATproperty] = ACTIONS(480),
    [anon_sym_ATproperty_DASHread] = ACTIONS(478),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(478),
    [anon_sym_ATreturn] = ACTIONS(478),
    [anon_sym_ATsee] = ACTIONS(478),
    [anon_sym_ATthrows] = ACTIONS(478),
    [anon_sym_ATvar] = ACTIONS(478),
    [anon_sym_ATdeprecated] = ACTIONS(478),
    [anon_sym_ATsince] = ACTIONS(478),
    [anon_sym_ATversion] = ACTIONS(478),
    [anon_sym_ATtemplate] = ACTIONS(480),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(478),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(478),
    [anon_sym_ATimplements] = ACTIONS(478),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(478),
    [anon_sym_ATextends] = ACTIONS(478),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(478),
    [anon_sym_ATuse] = ACTIONS(480),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(478),
    [anon_sym_ATafter] = ACTIONS(480),
    [anon_sym_ATafterClass] = ACTIONS(478),
    [anon_sym_ATannotation] = ACTIONS(478),
    [anon_sym_ATbackupGlobals] = ACTIONS(478),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(478),
    [anon_sym_ATbefore] = ACTIONS(480),
    [anon_sym_ATbeforeClass] = ACTIONS(478),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(480),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(478),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(478),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(478),
    [anon_sym_ATcovers] = ACTIONS(480),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(480),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(478),
    [anon_sym_ATcoversNothing] = ACTIONS(478),
    [anon_sym_ATdataProvider] = ACTIONS(478),
    [anon_sym_ATdepends] = ACTIONS(480),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(478),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(478),
    [anon_sym_ATgroup] = ACTIONS(478),
    [anon_sym_ATlarge] = ACTIONS(478),
    [anon_sym_ATmedium] = ACTIONS(478),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(478),
    [anon_sym_ATrequires] = ACTIONS(480),
    [anon_sym_ATrequiresusages] = ACTIONS(478),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(478),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(478),
    [anon_sym_ATsmall] = ACTIONS(478),
    [anon_sym_ATtest] = ACTIONS(480),
    [anon_sym_ATtestWith] = ACTIONS(478),
    [anon_sym_ATtestdox] = ACTIONS(478),
    [anon_sym_ATticket] = ACTIONS(478),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(478),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(478),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(478),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(480),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(478),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(480),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(478),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(478),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(478),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(478),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(478),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(478),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(478),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(478),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(478),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(480),
    [anon_sym_ATreadonly] = ACTIONS(478),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(478),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(478),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(478),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(478),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(478),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(478),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(478),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(478),
    [anon_sym_ATparam_DASHout] = ACTIONS(478),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(478),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(480),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(478),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(478),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(478),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(478),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(478),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(478),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(478),
    [anon_sym_ATmixin] = ACTIONS(478),
    [sym__end] = ACTIONS(478),
    [sym_text] = ACTIONS(75),
  },
  [103] = {
    [anon_sym_LBRACE] = ACTIONS(298),
    [anon_sym_ATinheritdoc] = ACTIONS(298),
    [anon_sym_ATinheritDoc] = ACTIONS(298),
    [anon_sym_ATapi] = ACTIONS(298),
    [anon_sym_ATfilesource] = ACTIONS(298),
    [anon_sym_ATignore] = ACTIONS(298),
    [anon_sym_ATinternal] = ACTIONS(298),
    [anon_sym_ATcategory] = ACTIONS(298),
    [anon_sym_ATcopyright] = ACTIONS(298),
    [anon_sym_ATtodo] = ACTIONS(298),
    [anon_sym_ATexample] = ACTIONS(298),
    [anon_sym_ATlicense] = ACTIONS(298),
    [anon_sym_ATpackage] = ACTIONS(298),
    [anon_sym_ATsource] = ACTIONS(298),
    [anon_sym_ATsubpackage] = ACTIONS(298),
    [anon_sym_ATuses] = ACTIONS(298),
    [anon_sym_ATauthor] = ACTIONS(298),
    [anon_sym_ATglobal] = ACTIONS(298),
    [anon_sym_ATlink] = ACTIONS(298),
    [anon_sym_ATmethod] = ACTIONS(298),
    [anon_sym_ATparam] = ACTIONS(296),
    [anon_sym_ATproperty] = ACTIONS(296),
    [anon_sym_ATproperty_DASHread] = ACTIONS(298),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(298),
    [anon_sym_ATreturn] = ACTIONS(298),
    [anon_sym_ATsee] = ACTIONS(298),
    [anon_sym_ATthrows] = ACTIONS(298),
    [anon_sym_ATvar] = ACTIONS(298),
    [anon_sym_ATdeprecated] = ACTIONS(298),
    [anon_sym_ATsince] = ACTIONS(298),
    [anon_sym_ATversion] = ACTIONS(298),
    [anon_sym_ATtemplate] = ACTIONS(296),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(298),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(298),
    [anon_sym_ATimplements] = ACTIONS(298),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(298),
    [anon_sym_ATextends] = ACTIONS(298),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(298),
    [anon_sym_ATuse] = ACTIONS(296),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(298),
    [anon_sym_ATafter] = ACTIONS(296),
    [anon_sym_ATafterClass] = ACTIONS(298),
    [anon_sym_ATannotation] = ACTIONS(298),
    [anon_sym_ATbackupGlobals] = ACTIONS(298),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(298),
    [anon_sym_ATbefore] = ACTIONS(296),
    [anon_sym_ATbeforeClass] = ACTIONS(298),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(296),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(298),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(298),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(298),
    [anon_sym_ATcovers] = ACTIONS(296),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(296),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(298),
    [anon_sym_ATcoversNothing] = ACTIONS(298),
    [anon_sym_ATdataProvider] = ACTIONS(298),
    [anon_sym_ATdepends] = ACTIONS(296),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(298),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(298),
    [anon_sym_ATgroup] = ACTIONS(298),
    [anon_sym_ATlarge] = ACTIONS(298),
    [anon_sym_ATmedium] = ACTIONS(298),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(298),
    [anon_sym_ATrequires] = ACTIONS(296),
    [anon_sym_ATrequiresusages] = ACTIONS(298),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(298),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(298),
    [anon_sym_ATsmall] = ACTIONS(298),
    [anon_sym_ATtest] = ACTIONS(296),
    [anon_sym_ATtestWith] = ACTIONS(298),
    [anon_sym_ATtestdox] = ACTIONS(298),
    [anon_sym_ATticket] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(296),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(296),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(296),
    [anon_sym_ATreadonly] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(298),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(298),
    [anon_sym_ATparam_DASHout] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(296),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(298),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(298),
    [anon_sym_ATmixin] = ACTIONS(298),
    [anon_sym_PIPE] = ACTIONS(298),
    [anon_sym_AMP] = ACTIONS(298),
    [anon_sym_DOLLAR] = ACTIONS(298),
    [sym__end] = ACTIONS(298),
    [sym__text_after_type] = ACTIONS(298),
  },
  [104] = {
    [sym_name] = ACTIONS(482),
    [anon_sym_ATinheritdoc] = ACTIONS(484),
    [anon_sym_ATinheritDoc] = ACTIONS(484),
    [anon_sym_ATapi] = ACTIONS(484),
    [anon_sym_ATfilesource] = ACTIONS(484),
    [anon_sym_ATignore] = ACTIONS(484),
    [anon_sym_ATinternal] = ACTIONS(484),
    [anon_sym_ATcategory] = ACTIONS(484),
    [anon_sym_ATcopyright] = ACTIONS(484),
    [anon_sym_ATtodo] = ACTIONS(484),
    [anon_sym_ATexample] = ACTIONS(484),
    [anon_sym_ATlicense] = ACTIONS(484),
    [anon_sym_ATpackage] = ACTIONS(484),
    [anon_sym_ATsource] = ACTIONS(484),
    [anon_sym_ATsubpackage] = ACTIONS(484),
    [anon_sym_ATuses] = ACTIONS(484),
    [anon_sym_ATauthor] = ACTIONS(484),
    [anon_sym_ATglobal] = ACTIONS(484),
    [anon_sym_ATlink] = ACTIONS(484),
    [anon_sym_ATmethod] = ACTIONS(484),
    [anon_sym_ATparam] = ACTIONS(482),
    [anon_sym_ATproperty] = ACTIONS(482),
    [anon_sym_ATproperty_DASHread] = ACTIONS(484),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(484),
    [anon_sym_ATreturn] = ACTIONS(484),
    [anon_sym_ATsee] = ACTIONS(484),
    [anon_sym_ATthrows] = ACTIONS(484),
    [anon_sym_ATvar] = ACTIONS(484),
    [anon_sym_ATdeprecated] = ACTIONS(484),
    [anon_sym_ATsince] = ACTIONS(484),
    [anon_sym_ATversion] = ACTIONS(484),
    [anon_sym_ATtemplate] = ACTIONS(482),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(484),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(484),
    [anon_sym_of] = ACTIONS(482),
    [anon_sym_ATimplements] = ACTIONS(484),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(484),
    [anon_sym_ATextends] = ACTIONS(484),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(484),
    [anon_sym_ATuse] = ACTIONS(482),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(484),
    [anon_sym_ATafter] = ACTIONS(482),
    [anon_sym_ATafterClass] = ACTIONS(484),
    [anon_sym_ATannotation] = ACTIONS(484),
    [anon_sym_ATbackupGlobals] = ACTIONS(484),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(484),
    [anon_sym_ATbefore] = ACTIONS(482),
    [anon_sym_ATbeforeClass] = ACTIONS(484),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(482),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(484),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(484),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(484),
    [anon_sym_ATcovers] = ACTIONS(482),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(482),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(484),
    [anon_sym_ATcoversNothing] = ACTIONS(484),
    [anon_sym_ATdataProvider] = ACTIONS(484),
    [anon_sym_ATdepends] = ACTIONS(482),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(484),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(484),
    [anon_sym_ATgroup] = ACTIONS(484),
    [anon_sym_ATlarge] = ACTIONS(484),
    [anon_sym_ATmedium] = ACTIONS(484),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(484),
    [anon_sym_ATrequires] = ACTIONS(482),
    [anon_sym_ATrequiresusages] = ACTIONS(484),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(484),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(484),
    [anon_sym_ATsmall] = ACTIONS(484),
    [anon_sym_ATtest] = ACTIONS(482),
    [anon_sym_ATtestWith] = ACTIONS(484),
    [anon_sym_ATtestdox] = ACTIONS(484),
    [anon_sym_ATticket] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(482),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(482),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(482),
    [anon_sym_ATreadonly] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(484),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(484),
    [anon_sym_ATparam_DASHout] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(482),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(484),
    [anon_sym_ATmixin] = ACTIONS(484),
    [anon_sym_COMMA] = ACTIONS(484),
    [anon_sym_PIPE] = ACTIONS(484),
    [anon_sym_DOLLAR] = ACTIONS(484),
    [sym__end] = ACTIONS(484),
  },
  [105] = {
    [aux_sym_disjunctive_normal_form_type_repeat1] = STATE(109),
    [anon_sym_LBRACE] = ACTIONS(376),
    [anon_sym_ATinheritdoc] = ACTIONS(376),
    [anon_sym_ATinheritDoc] = ACTIONS(376),
    [anon_sym_ATapi] = ACTIONS(376),
    [anon_sym_ATfilesource] = ACTIONS(376),
    [anon_sym_ATignore] = ACTIONS(376),
    [anon_sym_ATinternal] = ACTIONS(376),
    [anon_sym_ATcategory] = ACTIONS(376),
    [anon_sym_ATcopyright] = ACTIONS(376),
    [anon_sym_ATtodo] = ACTIONS(376),
    [anon_sym_ATexample] = ACTIONS(376),
    [anon_sym_ATlicense] = ACTIONS(376),
    [anon_sym_ATpackage] = ACTIONS(376),
    [anon_sym_ATsource] = ACTIONS(376),
    [anon_sym_ATsubpackage] = ACTIONS(376),
    [anon_sym_ATuses] = ACTIONS(376),
    [anon_sym_ATauthor] = ACTIONS(376),
    [anon_sym_ATglobal] = ACTIONS(376),
    [anon_sym_ATlink] = ACTIONS(376),
    [anon_sym_ATmethod] = ACTIONS(376),
    [anon_sym_ATparam] = ACTIONS(374),
    [anon_sym_ATproperty] = ACTIONS(374),
    [anon_sym_ATproperty_DASHread] = ACTIONS(376),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(376),
    [anon_sym_ATreturn] = ACTIONS(376),
    [anon_sym_ATsee] = ACTIONS(376),
    [anon_sym_ATthrows] = ACTIONS(376),
    [anon_sym_ATvar] = ACTIONS(376),
    [anon_sym_ATdeprecated] = ACTIONS(376),
    [anon_sym_ATsince] = ACTIONS(376),
    [anon_sym_ATversion] = ACTIONS(376),
    [anon_sym_ATtemplate] = ACTIONS(374),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(376),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(376),
    [anon_sym_ATimplements] = ACTIONS(376),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(376),
    [anon_sym_ATextends] = ACTIONS(376),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(376),
    [anon_sym_ATuse] = ACTIONS(374),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(376),
    [anon_sym_ATafter] = ACTIONS(374),
    [anon_sym_ATafterClass] = ACTIONS(376),
    [anon_sym_ATannotation] = ACTIONS(376),
    [anon_sym_ATbackupGlobals] = ACTIONS(376),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(376),
    [anon_sym_ATbefore] = ACTIONS(374),
    [anon_sym_ATbeforeClass] = ACTIONS(376),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(374),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(376),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(376),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(376),
    [anon_sym_ATcovers] = ACTIONS(374),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(374),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(376),
    [anon_sym_ATcoversNothing] = ACTIONS(376),
    [anon_sym_ATdataProvider] = ACTIONS(376),
    [anon_sym_ATdepends] = ACTIONS(374),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(376),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(376),
    [anon_sym_ATgroup] = ACTIONS(376),
    [anon_sym_ATlarge] = ACTIONS(376),
    [anon_sym_ATmedium] = ACTIONS(376),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(376),
    [anon_sym_ATrequires] = ACTIONS(374),
    [anon_sym_ATrequiresusages] = ACTIONS(376),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(376),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(376),
    [anon_sym_ATsmall] = ACTIONS(376),
    [anon_sym_ATtest] = ACTIONS(374),
    [anon_sym_ATtestWith] = ACTIONS(376),
    [anon_sym_ATtestdox] = ACTIONS(376),
    [anon_sym_ATticket] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(374),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(374),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(374),
    [anon_sym_ATreadonly] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(376),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(376),
    [anon_sym_ATparam_DASHout] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(374),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(376),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(376),
    [anon_sym_ATmixin] = ACTIONS(376),
    [anon_sym_PIPE] = ACTIONS(468),
    [anon_sym_DOLLAR] = ACTIONS(376),
    [sym__end] = ACTIONS(376),
    [sym__text_after_type] = ACTIONS(376),
  },
  [106] = {
    [aux_sym_union_type_repeat1] = STATE(106),
    [anon_sym_LBRACE] = ACTIONS(382),
    [anon_sym_ATinheritdoc] = ACTIONS(382),
    [anon_sym_ATinheritDoc] = ACTIONS(382),
    [anon_sym_ATapi] = ACTIONS(382),
    [anon_sym_ATfilesource] = ACTIONS(382),
    [anon_sym_ATignore] = ACTIONS(382),
    [anon_sym_ATinternal] = ACTIONS(382),
    [anon_sym_ATcategory] = ACTIONS(382),
    [anon_sym_ATcopyright] = ACTIONS(382),
    [anon_sym_ATtodo] = ACTIONS(382),
    [anon_sym_ATexample] = ACTIONS(382),
    [anon_sym_ATlicense] = ACTIONS(382),
    [anon_sym_ATpackage] = ACTIONS(382),
    [anon_sym_ATsource] = ACTIONS(382),
    [anon_sym_ATsubpackage] = ACTIONS(382),
    [anon_sym_ATuses] = ACTIONS(382),
    [anon_sym_ATauthor] = ACTIONS(382),
    [anon_sym_ATglobal] = ACTIONS(382),
    [anon_sym_ATlink] = ACTIONS(382),
    [anon_sym_ATmethod] = ACTIONS(382),
    [anon_sym_ATparam] = ACTIONS(380),
    [anon_sym_ATproperty] = ACTIONS(380),
    [anon_sym_ATproperty_DASHread] = ACTIONS(382),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(382),
    [anon_sym_ATreturn] = ACTIONS(382),
    [anon_sym_ATsee] = ACTIONS(382),
    [anon_sym_ATthrows] = ACTIONS(382),
    [anon_sym_ATvar] = ACTIONS(382),
    [anon_sym_ATdeprecated] = ACTIONS(382),
    [anon_sym_ATsince] = ACTIONS(382),
    [anon_sym_ATversion] = ACTIONS(382),
    [anon_sym_ATtemplate] = ACTIONS(380),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(382),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(382),
    [anon_sym_ATimplements] = ACTIONS(382),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(382),
    [anon_sym_ATextends] = ACTIONS(382),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(382),
    [anon_sym_ATuse] = ACTIONS(380),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(382),
    [anon_sym_ATafter] = ACTIONS(380),
    [anon_sym_ATafterClass] = ACTIONS(382),
    [anon_sym_ATannotation] = ACTIONS(382),
    [anon_sym_ATbackupGlobals] = ACTIONS(382),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(382),
    [anon_sym_ATbefore] = ACTIONS(380),
    [anon_sym_ATbeforeClass] = ACTIONS(382),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(380),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(382),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(382),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(382),
    [anon_sym_ATcovers] = ACTIONS(380),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(380),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(382),
    [anon_sym_ATcoversNothing] = ACTIONS(382),
    [anon_sym_ATdataProvider] = ACTIONS(382),
    [anon_sym_ATdepends] = ACTIONS(380),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(382),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(382),
    [anon_sym_ATgroup] = ACTIONS(382),
    [anon_sym_ATlarge] = ACTIONS(382),
    [anon_sym_ATmedium] = ACTIONS(382),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(382),
    [anon_sym_ATrequires] = ACTIONS(380),
    [anon_sym_ATrequiresusages] = ACTIONS(382),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(382),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(382),
    [anon_sym_ATsmall] = ACTIONS(382),
    [anon_sym_ATtest] = ACTIONS(380),
    [anon_sym_ATtestWith] = ACTIONS(382),
    [anon_sym_ATtestdox] = ACTIONS(382),
    [anon_sym_ATticket] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(380),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(380),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(380),
    [anon_sym_ATreadonly] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(382),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(382),
    [anon_sym_ATparam_DASHout] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(380),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(382),
    [anon_sym_ATmixin] = ACTIONS(382),
    [anon_sym_PIPE] = ACTIONS(486),
    [anon_sym_DOLLAR] = ACTIONS(382),
    [sym__end] = ACTIONS(382),
    [sym__text_after_type] = ACTIONS(382),
  },
  [107] = {
    [aux_sym_intersection_type_repeat1] = STATE(107),
    [anon_sym_LBRACE] = ACTIONS(367),
    [anon_sym_ATinheritdoc] = ACTIONS(367),
    [anon_sym_ATinheritDoc] = ACTIONS(367),
    [anon_sym_ATapi] = ACTIONS(367),
    [anon_sym_ATfilesource] = ACTIONS(367),
    [anon_sym_ATignore] = ACTIONS(367),
    [anon_sym_ATinternal] = ACTIONS(367),
    [anon_sym_ATcategory] = ACTIONS(367),
    [anon_sym_ATcopyright] = ACTIONS(367),
    [anon_sym_ATtodo] = ACTIONS(367),
    [anon_sym_ATexample] = ACTIONS(367),
    [anon_sym_ATlicense] = ACTIONS(367),
    [anon_sym_ATpackage] = ACTIONS(367),
    [anon_sym_ATsource] = ACTIONS(367),
    [anon_sym_ATsubpackage] = ACTIONS(367),
    [anon_sym_ATuses] = ACTIONS(367),
    [anon_sym_ATauthor] = ACTIONS(367),
    [anon_sym_ATglobal] = ACTIONS(367),
    [anon_sym_ATlink] = ACTIONS(367),
    [anon_sym_ATmethod] = ACTIONS(367),
    [anon_sym_ATparam] = ACTIONS(365),
    [anon_sym_ATproperty] = ACTIONS(365),
    [anon_sym_ATproperty_DASHread] = ACTIONS(367),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(367),
    [anon_sym_ATreturn] = ACTIONS(367),
    [anon_sym_ATsee] = ACTIONS(367),
    [anon_sym_ATthrows] = ACTIONS(367),
    [anon_sym_ATvar] = ACTIONS(367),
    [anon_sym_ATdeprecated] = ACTIONS(367),
    [anon_sym_ATsince] = ACTIONS(367),
    [anon_sym_ATversion] = ACTIONS(367),
    [anon_sym_ATtemplate] = ACTIONS(365),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(367),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(367),
    [anon_sym_ATimplements] = ACTIONS(367),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(367),
    [anon_sym_ATextends] = ACTIONS(367),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(367),
    [anon_sym_ATuse] = ACTIONS(365),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(367),
    [anon_sym_ATafter] = ACTIONS(365),
    [anon_sym_ATafterClass] = ACTIONS(367),
    [anon_sym_ATannotation] = ACTIONS(367),
    [anon_sym_ATbackupGlobals] = ACTIONS(367),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(367),
    [anon_sym_ATbefore] = ACTIONS(365),
    [anon_sym_ATbeforeClass] = ACTIONS(367),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(365),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(367),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(367),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(367),
    [anon_sym_ATcovers] = ACTIONS(365),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(365),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(367),
    [anon_sym_ATcoversNothing] = ACTIONS(367),
    [anon_sym_ATdataProvider] = ACTIONS(367),
    [anon_sym_ATdepends] = ACTIONS(365),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(367),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(367),
    [anon_sym_ATgroup] = ACTIONS(367),
    [anon_sym_ATlarge] = ACTIONS(367),
    [anon_sym_ATmedium] = ACTIONS(367),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(367),
    [anon_sym_ATrequires] = ACTIONS(365),
    [anon_sym_ATrequiresusages] = ACTIONS(367),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(367),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(367),
    [anon_sym_ATsmall] = ACTIONS(367),
    [anon_sym_ATtest] = ACTIONS(365),
    [anon_sym_ATtestWith] = ACTIONS(367),
    [anon_sym_ATtestdox] = ACTIONS(367),
    [anon_sym_ATticket] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(365),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(365),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(365),
    [anon_sym_ATreadonly] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(367),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(367),
    [anon_sym_ATparam_DASHout] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(365),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(367),
    [anon_sym_ATmixin] = ACTIONS(367),
    [anon_sym_AMP] = ACTIONS(489),
    [anon_sym_DOLLAR] = ACTIONS(367),
    [sym__end] = ACTIONS(367),
    [sym__text_after_type] = ACTIONS(367),
  },
  [108] = {
    [sym_name] = ACTIONS(380),
    [anon_sym_ATinheritdoc] = ACTIONS(382),
    [anon_sym_ATinheritDoc] = ACTIONS(382),
    [anon_sym_ATapi] = ACTIONS(382),
    [anon_sym_ATfilesource] = ACTIONS(382),
    [anon_sym_ATignore] = ACTIONS(382),
    [anon_sym_ATinternal] = ACTIONS(382),
    [anon_sym_ATcategory] = ACTIONS(382),
    [anon_sym_ATcopyright] = ACTIONS(382),
    [anon_sym_ATtodo] = ACTIONS(382),
    [anon_sym_ATexample] = ACTIONS(382),
    [anon_sym_ATlicense] = ACTIONS(382),
    [anon_sym_ATpackage] = ACTIONS(382),
    [anon_sym_ATsource] = ACTIONS(382),
    [anon_sym_ATsubpackage] = ACTIONS(382),
    [anon_sym_ATuses] = ACTIONS(382),
    [anon_sym_ATauthor] = ACTIONS(382),
    [anon_sym_ATglobal] = ACTIONS(382),
    [anon_sym_ATlink] = ACTIONS(382),
    [anon_sym_ATmethod] = ACTIONS(382),
    [anon_sym_ATparam] = ACTIONS(380),
    [anon_sym_ATproperty] = ACTIONS(380),
    [anon_sym_ATproperty_DASHread] = ACTIONS(382),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(382),
    [anon_sym_ATreturn] = ACTIONS(382),
    [anon_sym_ATsee] = ACTIONS(382),
    [anon_sym_ATthrows] = ACTIONS(382),
    [anon_sym_ATvar] = ACTIONS(382),
    [anon_sym_ATdeprecated] = ACTIONS(382),
    [anon_sym_ATsince] = ACTIONS(382),
    [anon_sym_ATversion] = ACTIONS(382),
    [anon_sym_ATtemplate] = ACTIONS(380),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(382),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(382),
    [anon_sym_of] = ACTIONS(380),
    [anon_sym_ATimplements] = ACTIONS(382),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(382),
    [anon_sym_ATextends] = ACTIONS(382),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(382),
    [anon_sym_ATuse] = ACTIONS(380),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(382),
    [anon_sym_ATafter] = ACTIONS(380),
    [anon_sym_ATafterClass] = ACTIONS(382),
    [anon_sym_ATannotation] = ACTIONS(382),
    [anon_sym_ATbackupGlobals] = ACTIONS(382),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(382),
    [anon_sym_ATbefore] = ACTIONS(380),
    [anon_sym_ATbeforeClass] = ACTIONS(382),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(380),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(382),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(382),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(382),
    [anon_sym_ATcovers] = ACTIONS(380),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(380),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(382),
    [anon_sym_ATcoversNothing] = ACTIONS(382),
    [anon_sym_ATdataProvider] = ACTIONS(382),
    [anon_sym_ATdepends] = ACTIONS(380),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(382),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(382),
    [anon_sym_ATgroup] = ACTIONS(382),
    [anon_sym_ATlarge] = ACTIONS(382),
    [anon_sym_ATmedium] = ACTIONS(382),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(382),
    [anon_sym_ATrequires] = ACTIONS(380),
    [anon_sym_ATrequiresusages] = ACTIONS(382),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(382),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(382),
    [anon_sym_ATsmall] = ACTIONS(382),
    [anon_sym_ATtest] = ACTIONS(380),
    [anon_sym_ATtestWith] = ACTIONS(382),
    [anon_sym_ATtestdox] = ACTIONS(382),
    [anon_sym_ATticket] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(380),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(380),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(380),
    [anon_sym_ATreadonly] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(382),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(382),
    [anon_sym_ATparam_DASHout] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(380),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(382),
    [anon_sym_ATmixin] = ACTIONS(382),
    [anon_sym_COMMA] = ACTIONS(382),
    [anon_sym_PIPE] = ACTIONS(382),
    [anon_sym_DOLLAR] = ACTIONS(382),
    [sym__end] = ACTIONS(382),
  },
  [109] = {
    [aux_sym_disjunctive_normal_form_type_repeat1] = STATE(109),
    [anon_sym_LBRACE] = ACTIONS(395),
    [anon_sym_ATinheritdoc] = ACTIONS(395),
    [anon_sym_ATinheritDoc] = ACTIONS(395),
    [anon_sym_ATapi] = ACTIONS(395),
    [anon_sym_ATfilesource] = ACTIONS(395),
    [anon_sym_ATignore] = ACTIONS(395),
    [anon_sym_ATinternal] = ACTIONS(395),
    [anon_sym_ATcategory] = ACTIONS(395),
    [anon_sym_ATcopyright] = ACTIONS(395),
    [anon_sym_ATtodo] = ACTIONS(395),
    [anon_sym_ATexample] = ACTIONS(395),
    [anon_sym_ATlicense] = ACTIONS(395),
    [anon_sym_ATpackage] = ACTIONS(395),
    [anon_sym_ATsource] = ACTIONS(395),
    [anon_sym_ATsubpackage] = ACTIONS(395),
    [anon_sym_ATuses] = ACTIONS(395),
    [anon_sym_ATauthor] = ACTIONS(395),
    [anon_sym_ATglobal] = ACTIONS(395),
    [anon_sym_ATlink] = ACTIONS(395),
    [anon_sym_ATmethod] = ACTIONS(395),
    [anon_sym_ATparam] = ACTIONS(393),
    [anon_sym_ATproperty] = ACTIONS(393),
    [anon_sym_ATproperty_DASHread] = ACTIONS(395),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(395),
    [anon_sym_ATreturn] = ACTIONS(395),
    [anon_sym_ATsee] = ACTIONS(395),
    [anon_sym_ATthrows] = ACTIONS(395),
    [anon_sym_ATvar] = ACTIONS(395),
    [anon_sym_ATdeprecated] = ACTIONS(395),
    [anon_sym_ATsince] = ACTIONS(395),
    [anon_sym_ATversion] = ACTIONS(395),
    [anon_sym_ATtemplate] = ACTIONS(393),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(395),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(395),
    [anon_sym_ATimplements] = ACTIONS(395),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(395),
    [anon_sym_ATextends] = ACTIONS(395),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(395),
    [anon_sym_ATuse] = ACTIONS(393),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(395),
    [anon_sym_ATafter] = ACTIONS(393),
    [anon_sym_ATafterClass] = ACTIONS(395),
    [anon_sym_ATannotation] = ACTIONS(395),
    [anon_sym_ATbackupGlobals] = ACTIONS(395),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(395),
    [anon_sym_ATbefore] = ACTIONS(393),
    [anon_sym_ATbeforeClass] = ACTIONS(395),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(393),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(395),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(395),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(395),
    [anon_sym_ATcovers] = ACTIONS(393),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(393),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(395),
    [anon_sym_ATcoversNothing] = ACTIONS(395),
    [anon_sym_ATdataProvider] = ACTIONS(395),
    [anon_sym_ATdepends] = ACTIONS(393),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(395),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(395),
    [anon_sym_ATgroup] = ACTIONS(395),
    [anon_sym_ATlarge] = ACTIONS(395),
    [anon_sym_ATmedium] = ACTIONS(395),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(395),
    [anon_sym_ATrequires] = ACTIONS(393),
    [anon_sym_ATrequiresusages] = ACTIONS(395),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(395),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(395),
    [anon_sym_ATsmall] = ACTIONS(395),
    [anon_sym_ATtest] = ACTIONS(393),
    [anon_sym_ATtestWith] = ACTIONS(395),
    [anon_sym_ATtestdox] = ACTIONS(395),
    [anon_sym_ATticket] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(393),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(393),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(393),
    [anon_sym_ATreadonly] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(395),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(395),
    [anon_sym_ATparam_DASHout] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(393),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(395),
    [anon_sym_ATmixin] = ACTIONS(395),
    [anon_sym_PIPE] = ACTIONS(492),
    [anon_sym_DOLLAR] = ACTIONS(395),
    [sym__end] = ACTIONS(395),
    [sym__text_after_type] = ACTIONS(395),
  },
  [110] = {
    [sym_description] = STATE(168),
    [sym_inline_tag] = STATE(116),
    [aux_sym_description_repeat1] = STATE(116),
    [anon_sym_LBRACE] = ACTIONS(5),
    [anon_sym_ATinheritdoc] = ACTIONS(495),
    [anon_sym_ATinheritDoc] = ACTIONS(495),
    [anon_sym_ATapi] = ACTIONS(495),
    [anon_sym_ATfilesource] = ACTIONS(495),
    [anon_sym_ATignore] = ACTIONS(495),
    [anon_sym_ATinternal] = ACTIONS(495),
    [anon_sym_ATcategory] = ACTIONS(495),
    [anon_sym_ATcopyright] = ACTIONS(495),
    [anon_sym_ATtodo] = ACTIONS(495),
    [anon_sym_ATexample] = ACTIONS(495),
    [anon_sym_ATlicense] = ACTIONS(495),
    [anon_sym_ATpackage] = ACTIONS(495),
    [anon_sym_ATsource] = ACTIONS(495),
    [anon_sym_ATsubpackage] = ACTIONS(495),
    [anon_sym_ATuses] = ACTIONS(495),
    [anon_sym_ATauthor] = ACTIONS(495),
    [anon_sym_ATglobal] = ACTIONS(495),
    [anon_sym_ATlink] = ACTIONS(495),
    [anon_sym_ATmethod] = ACTIONS(495),
    [anon_sym_ATparam] = ACTIONS(497),
    [anon_sym_ATproperty] = ACTIONS(497),
    [anon_sym_ATproperty_DASHread] = ACTIONS(495),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(495),
    [anon_sym_ATreturn] = ACTIONS(495),
    [anon_sym_ATsee] = ACTIONS(495),
    [anon_sym_ATthrows] = ACTIONS(495),
    [anon_sym_ATvar] = ACTIONS(495),
    [anon_sym_ATdeprecated] = ACTIONS(495),
    [anon_sym_ATsince] = ACTIONS(495),
    [anon_sym_ATversion] = ACTIONS(495),
    [anon_sym_ATtemplate] = ACTIONS(497),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(495),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(495),
    [anon_sym_ATimplements] = ACTIONS(495),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(495),
    [anon_sym_ATextends] = ACTIONS(495),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(495),
    [anon_sym_ATuse] = ACTIONS(497),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(495),
    [anon_sym_ATafter] = ACTIONS(497),
    [anon_sym_ATafterClass] = ACTIONS(495),
    [anon_sym_ATannotation] = ACTIONS(495),
    [anon_sym_ATbackupGlobals] = ACTIONS(495),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(495),
    [anon_sym_ATbefore] = ACTIONS(497),
    [anon_sym_ATbeforeClass] = ACTIONS(495),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(497),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(495),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(495),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(495),
    [anon_sym_ATcovers] = ACTIONS(497),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(497),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(495),
    [anon_sym_ATcoversNothing] = ACTIONS(495),
    [anon_sym_ATdataProvider] = ACTIONS(495),
    [anon_sym_ATdepends] = ACTIONS(497),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(495),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(495),
    [anon_sym_ATgroup] = ACTIONS(495),
    [anon_sym_ATlarge] = ACTIONS(495),
    [anon_sym_ATmedium] = ACTIONS(495),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(495),
    [anon_sym_ATrequires] = ACTIONS(497),
    [anon_sym_ATrequiresusages] = ACTIONS(495),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(495),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(495),
    [anon_sym_ATsmall] = ACTIONS(495),
    [anon_sym_ATtest] = ACTIONS(497),
    [anon_sym_ATtestWith] = ACTIONS(495),
    [anon_sym_ATtestdox] = ACTIONS(495),
    [anon_sym_ATticket] = ACTIONS(495),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(495),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(495),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(495),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(497),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(495),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(497),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(495),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(495),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(495),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(495),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(495),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(495),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(495),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(495),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(495),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(497),
    [anon_sym_ATreadonly] = ACTIONS(495),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(495),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(495),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(495),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(495),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(495),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(495),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(495),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(495),
    [anon_sym_ATparam_DASHout] = ACTIONS(495),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(495),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(497),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(495),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(495),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(495),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(495),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(495),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(495),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(495),
    [anon_sym_ATmixin] = ACTIONS(495),
    [sym__end] = ACTIONS(495),
    [sym_text] = ACTIONS(75),
  },
  [111] = {
    [anon_sym_LBRACE] = ACTIONS(342),
    [anon_sym_ATinheritdoc] = ACTIONS(342),
    [anon_sym_ATinheritDoc] = ACTIONS(342),
    [anon_sym_ATapi] = ACTIONS(342),
    [anon_sym_ATfilesource] = ACTIONS(342),
    [anon_sym_ATignore] = ACTIONS(342),
    [anon_sym_ATinternal] = ACTIONS(342),
    [anon_sym_ATcategory] = ACTIONS(342),
    [anon_sym_ATcopyright] = ACTIONS(342),
    [anon_sym_ATtodo] = ACTIONS(342),
    [anon_sym_ATexample] = ACTIONS(342),
    [anon_sym_ATlicense] = ACTIONS(342),
    [anon_sym_ATpackage] = ACTIONS(342),
    [anon_sym_ATsource] = ACTIONS(342),
    [anon_sym_ATsubpackage] = ACTIONS(342),
    [anon_sym_ATuses] = ACTIONS(342),
    [anon_sym_ATauthor] = ACTIONS(342),
    [anon_sym_ATglobal] = ACTIONS(342),
    [anon_sym_ATlink] = ACTIONS(342),
    [anon_sym_ATmethod] = ACTIONS(342),
    [anon_sym_ATparam] = ACTIONS(340),
    [anon_sym_ATproperty] = ACTIONS(340),
    [anon_sym_ATproperty_DASHread] = ACTIONS(342),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(342),
    [anon_sym_ATreturn] = ACTIONS(342),
    [anon_sym_ATsee] = ACTIONS(342),
    [anon_sym_ATthrows] = ACTIONS(342),
    [anon_sym_ATvar] = ACTIONS(342),
    [anon_sym_ATdeprecated] = ACTIONS(342),
    [anon_sym_ATsince] = ACTIONS(342),
    [anon_sym_ATversion] = ACTIONS(342),
    [anon_sym_ATtemplate] = ACTIONS(340),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(342),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(342),
    [anon_sym_ATimplements] = ACTIONS(342),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(342),
    [anon_sym_ATextends] = ACTIONS(342),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(342),
    [anon_sym_ATuse] = ACTIONS(340),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(342),
    [anon_sym_ATafter] = ACTIONS(340),
    [anon_sym_ATafterClass] = ACTIONS(342),
    [anon_sym_ATannotation] = ACTIONS(342),
    [anon_sym_ATbackupGlobals] = ACTIONS(342),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(342),
    [anon_sym_ATbefore] = ACTIONS(340),
    [anon_sym_ATbeforeClass] = ACTIONS(342),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(340),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(342),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(342),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(342),
    [anon_sym_ATcovers] = ACTIONS(340),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(340),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(342),
    [anon_sym_ATcoversNothing] = ACTIONS(342),
    [anon_sym_ATdataProvider] = ACTIONS(342),
    [anon_sym_ATdepends] = ACTIONS(340),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(342),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(342),
    [anon_sym_ATgroup] = ACTIONS(342),
    [anon_sym_ATlarge] = ACTIONS(342),
    [anon_sym_ATmedium] = ACTIONS(342),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(342),
    [anon_sym_ATrequires] = ACTIONS(340),
    [anon_sym_ATrequiresusages] = ACTIONS(342),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(342),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(342),
    [anon_sym_ATsmall] = ACTIONS(342),
    [anon_sym_ATtest] = ACTIONS(340),
    [anon_sym_ATtestWith] = ACTIONS(342),
    [anon_sym_ATtestdox] = ACTIONS(342),
    [anon_sym_ATticket] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(340),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(340),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(340),
    [anon_sym_ATreadonly] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(342),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(342),
    [anon_sym_ATparam_DASHout] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(340),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(342),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(342),
    [anon_sym_ATmixin] = ACTIONS(342),
    [anon_sym_PIPE] = ACTIONS(342),
    [anon_sym_AMP] = ACTIONS(342),
    [anon_sym_DOLLAR] = ACTIONS(342),
    [sym__end] = ACTIONS(342),
    [sym__text_after_type] = ACTIONS(342),
  },
  [112] = {
    [anon_sym_LBRACE] = ACTIONS(326),
    [anon_sym_ATinheritdoc] = ACTIONS(326),
    [anon_sym_ATinheritDoc] = ACTIONS(326),
    [anon_sym_ATapi] = ACTIONS(326),
    [anon_sym_ATfilesource] = ACTIONS(326),
    [anon_sym_ATignore] = ACTIONS(326),
    [anon_sym_ATinternal] = ACTIONS(326),
    [anon_sym_ATcategory] = ACTIONS(326),
    [anon_sym_ATcopyright] = ACTIONS(326),
    [anon_sym_ATtodo] = ACTIONS(326),
    [anon_sym_ATexample] = ACTIONS(326),
    [anon_sym_ATlicense] = ACTIONS(326),
    [anon_sym_ATpackage] = ACTIONS(326),
    [anon_sym_ATsource] = ACTIONS(326),
    [anon_sym_ATsubpackage] = ACTIONS(326),
    [anon_sym_ATuses] = ACTIONS(326),
    [anon_sym_ATauthor] = ACTIONS(326),
    [anon_sym_ATglobal] = ACTIONS(326),
    [anon_sym_ATlink] = ACTIONS(326),
    [anon_sym_ATmethod] = ACTIONS(326),
    [anon_sym_ATparam] = ACTIONS(324),
    [anon_sym_ATproperty] = ACTIONS(324),
    [anon_sym_ATproperty_DASHread] = ACTIONS(326),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(326),
    [anon_sym_ATreturn] = ACTIONS(326),
    [anon_sym_ATsee] = ACTIONS(326),
    [anon_sym_ATthrows] = ACTIONS(326),
    [anon_sym_ATvar] = ACTIONS(326),
    [anon_sym_ATdeprecated] = ACTIONS(326),
    [anon_sym_ATsince] = ACTIONS(326),
    [anon_sym_ATversion] = ACTIONS(326),
    [anon_sym_ATtemplate] = ACTIONS(324),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(326),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(326),
    [anon_sym_ATimplements] = ACTIONS(326),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(326),
    [anon_sym_ATextends] = ACTIONS(326),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(326),
    [anon_sym_ATuse] = ACTIONS(324),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(326),
    [anon_sym_ATafter] = ACTIONS(324),
    [anon_sym_ATafterClass] = ACTIONS(326),
    [anon_sym_ATannotation] = ACTIONS(326),
    [anon_sym_ATbackupGlobals] = ACTIONS(326),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(326),
    [anon_sym_ATbefore] = ACTIONS(324),
    [anon_sym_ATbeforeClass] = ACTIONS(326),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(324),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(326),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(326),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(326),
    [anon_sym_ATcovers] = ACTIONS(324),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(324),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(326),
    [anon_sym_ATcoversNothing] = ACTIONS(326),
    [anon_sym_ATdataProvider] = ACTIONS(326),
    [anon_sym_ATdepends] = ACTIONS(324),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(326),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(326),
    [anon_sym_ATgroup] = ACTIONS(326),
    [anon_sym_ATlarge] = ACTIONS(326),
    [anon_sym_ATmedium] = ACTIONS(326),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(326),
    [anon_sym_ATrequires] = ACTIONS(324),
    [anon_sym_ATrequiresusages] = ACTIONS(326),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(326),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(326),
    [anon_sym_ATsmall] = ACTIONS(326),
    [anon_sym_ATtest] = ACTIONS(324),
    [anon_sym_ATtestWith] = ACTIONS(326),
    [anon_sym_ATtestdox] = ACTIONS(326),
    [anon_sym_ATticket] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(324),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(324),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(324),
    [anon_sym_ATreadonly] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(326),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(326),
    [anon_sym_ATparam_DASHout] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(324),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(326),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(326),
    [anon_sym_ATmixin] = ACTIONS(326),
    [anon_sym_PIPE] = ACTIONS(326),
    [anon_sym_AMP] = ACTIONS(326),
    [anon_sym_DOLLAR] = ACTIONS(326),
    [sym__end] = ACTIONS(326),
    [sym__text_after_type] = ACTIONS(326),
  },
  [113] = {
    [anon_sym_LBRACE] = ACTIONS(211),
    [anon_sym_ATinheritdoc] = ACTIONS(211),
    [anon_sym_ATinheritDoc] = ACTIONS(211),
    [anon_sym_ATapi] = ACTIONS(211),
    [anon_sym_ATfilesource] = ACTIONS(211),
    [anon_sym_ATignore] = ACTIONS(211),
    [anon_sym_ATinternal] = ACTIONS(211),
    [anon_sym_ATcategory] = ACTIONS(211),
    [anon_sym_ATcopyright] = ACTIONS(211),
    [anon_sym_ATtodo] = ACTIONS(211),
    [anon_sym_ATexample] = ACTIONS(211),
    [anon_sym_ATlicense] = ACTIONS(211),
    [anon_sym_ATpackage] = ACTIONS(211),
    [anon_sym_ATsource] = ACTIONS(211),
    [anon_sym_ATsubpackage] = ACTIONS(211),
    [anon_sym_ATuses] = ACTIONS(211),
    [anon_sym_ATauthor] = ACTIONS(211),
    [anon_sym_LT] = ACTIONS(211),
    [anon_sym_ATglobal] = ACTIONS(211),
    [anon_sym_ATlink] = ACTIONS(211),
    [anon_sym_ATmethod] = ACTIONS(211),
    [anon_sym_ATparam] = ACTIONS(209),
    [anon_sym_ATproperty] = ACTIONS(209),
    [anon_sym_ATproperty_DASHread] = ACTIONS(211),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(211),
    [anon_sym_ATreturn] = ACTIONS(211),
    [anon_sym_ATsee] = ACTIONS(211),
    [anon_sym_ATthrows] = ACTIONS(211),
    [anon_sym_ATvar] = ACTIONS(211),
    [anon_sym_ATdeprecated] = ACTIONS(211),
    [anon_sym_ATsince] = ACTIONS(211),
    [anon_sym_ATversion] = ACTIONS(211),
    [anon_sym_ATtemplate] = ACTIONS(209),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(211),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(211),
    [anon_sym_ATimplements] = ACTIONS(211),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(211),
    [anon_sym_ATextends] = ACTIONS(211),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(211),
    [anon_sym_ATuse] = ACTIONS(209),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(211),
    [anon_sym_ATafter] = ACTIONS(209),
    [anon_sym_ATafterClass] = ACTIONS(211),
    [anon_sym_ATannotation] = ACTIONS(211),
    [anon_sym_ATbackupGlobals] = ACTIONS(211),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(211),
    [anon_sym_ATbefore] = ACTIONS(209),
    [anon_sym_ATbeforeClass] = ACTIONS(211),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(209),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(211),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(211),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(211),
    [anon_sym_ATcovers] = ACTIONS(209),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(209),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(211),
    [anon_sym_ATcoversNothing] = ACTIONS(211),
    [anon_sym_ATdataProvider] = ACTIONS(211),
    [anon_sym_ATdepends] = ACTIONS(209),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(211),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(211),
    [anon_sym_ATgroup] = ACTIONS(211),
    [anon_sym_ATlarge] = ACTIONS(211),
    [anon_sym_ATmedium] = ACTIONS(211),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(211),
    [anon_sym_ATrequires] = ACTIONS(209),
    [anon_sym_ATrequiresusages] = ACTIONS(211),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(211),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(211),
    [anon_sym_ATsmall] = ACTIONS(211),
    [anon_sym_ATtest] = ACTIONS(209),
    [anon_sym_ATtestWith] = ACTIONS(211),
    [anon_sym_ATtestdox] = ACTIONS(211),
    [anon_sym_ATticket] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(209),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(209),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(209),
    [anon_sym_ATreadonly] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(211),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(211),
    [anon_sym_ATparam_DASHout] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(209),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(211),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(211),
    [anon_sym_ATmixin] = ACTIONS(211),
    [anon_sym_COLON_COLON] = ACTIONS(211),
    [sym__end] = ACTIONS(211),
    [sym_text] = ACTIONS(211),
  },
  [114] = {
    [sym_inline_tag] = STATE(114),
    [aux_sym_description_repeat1] = STATE(114),
    [anon_sym_LBRACE] = ACTIONS(499),
    [anon_sym_ATinheritdoc] = ACTIONS(502),
    [anon_sym_ATinheritDoc] = ACTIONS(502),
    [anon_sym_ATapi] = ACTIONS(502),
    [anon_sym_ATfilesource] = ACTIONS(502),
    [anon_sym_ATignore] = ACTIONS(502),
    [anon_sym_ATinternal] = ACTIONS(502),
    [anon_sym_ATcategory] = ACTIONS(502),
    [anon_sym_ATcopyright] = ACTIONS(502),
    [anon_sym_ATtodo] = ACTIONS(502),
    [anon_sym_ATexample] = ACTIONS(502),
    [anon_sym_ATlicense] = ACTIONS(502),
    [anon_sym_ATpackage] = ACTIONS(502),
    [anon_sym_ATsource] = ACTIONS(502),
    [anon_sym_ATsubpackage] = ACTIONS(502),
    [anon_sym_ATuses] = ACTIONS(502),
    [anon_sym_ATauthor] = ACTIONS(502),
    [anon_sym_ATglobal] = ACTIONS(502),
    [anon_sym_ATlink] = ACTIONS(502),
    [anon_sym_ATmethod] = ACTIONS(502),
    [anon_sym_ATparam] = ACTIONS(504),
    [anon_sym_ATproperty] = ACTIONS(504),
    [anon_sym_ATproperty_DASHread] = ACTIONS(502),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(502),
    [anon_sym_ATreturn] = ACTIONS(502),
    [anon_sym_ATsee] = ACTIONS(502),
    [anon_sym_ATthrows] = ACTIONS(502),
    [anon_sym_ATvar] = ACTIONS(502),
    [anon_sym_ATdeprecated] = ACTIONS(502),
    [anon_sym_ATsince] = ACTIONS(502),
    [anon_sym_ATversion] = ACTIONS(502),
    [anon_sym_ATtemplate] = ACTIONS(504),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(502),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(502),
    [anon_sym_ATimplements] = ACTIONS(502),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(502),
    [anon_sym_ATextends] = ACTIONS(502),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(502),
    [anon_sym_ATuse] = ACTIONS(504),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(502),
    [anon_sym_ATafter] = ACTIONS(504),
    [anon_sym_ATafterClass] = ACTIONS(502),
    [anon_sym_ATannotation] = ACTIONS(502),
    [anon_sym_ATbackupGlobals] = ACTIONS(502),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(502),
    [anon_sym_ATbefore] = ACTIONS(504),
    [anon_sym_ATbeforeClass] = ACTIONS(502),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(504),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(502),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(502),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(502),
    [anon_sym_ATcovers] = ACTIONS(504),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(504),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(502),
    [anon_sym_ATcoversNothing] = ACTIONS(502),
    [anon_sym_ATdataProvider] = ACTIONS(502),
    [anon_sym_ATdepends] = ACTIONS(504),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(502),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(502),
    [anon_sym_ATgroup] = ACTIONS(502),
    [anon_sym_ATlarge] = ACTIONS(502),
    [anon_sym_ATmedium] = ACTIONS(502),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(502),
    [anon_sym_ATrequires] = ACTIONS(504),
    [anon_sym_ATrequiresusages] = ACTIONS(502),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(502),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(502),
    [anon_sym_ATsmall] = ACTIONS(502),
    [anon_sym_ATtest] = ACTIONS(504),
    [anon_sym_ATtestWith] = ACTIONS(502),
    [anon_sym_ATtestdox] = ACTIONS(502),
    [anon_sym_ATticket] = ACTIONS(502),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(502),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(502),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(502),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(504),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(502),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(504),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(502),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(502),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(502),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(502),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(502),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(502),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(502),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(502),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(502),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(504),
    [anon_sym_ATreadonly] = ACTIONS(502),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(502),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(502),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(502),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(502),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(502),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(502),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(502),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(502),
    [anon_sym_ATparam_DASHout] = ACTIONS(502),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(502),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(504),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(502),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(502),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(502),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(502),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(502),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(502),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(502),
    [anon_sym_ATmixin] = ACTIONS(502),
    [sym__end] = ACTIONS(502),
    [sym_text] = ACTIONS(506),
  },
  [115] = {
    [sym_inline_tag] = STATE(148),
    [aux_sym__description_not_version_repeat1] = STATE(121),
    [anon_sym_LBRACE] = ACTIONS(246),
    [anon_sym_ATinheritdoc] = ACTIONS(509),
    [anon_sym_ATinheritDoc] = ACTIONS(509),
    [anon_sym_ATapi] = ACTIONS(509),
    [anon_sym_ATfilesource] = ACTIONS(509),
    [anon_sym_ATignore] = ACTIONS(509),
    [anon_sym_ATinternal] = ACTIONS(509),
    [anon_sym_ATcategory] = ACTIONS(509),
    [anon_sym_ATcopyright] = ACTIONS(509),
    [anon_sym_ATtodo] = ACTIONS(509),
    [anon_sym_ATexample] = ACTIONS(509),
    [anon_sym_ATlicense] = ACTIONS(509),
    [anon_sym_ATpackage] = ACTIONS(509),
    [anon_sym_ATsource] = ACTIONS(509),
    [anon_sym_ATsubpackage] = ACTIONS(509),
    [anon_sym_ATuses] = ACTIONS(509),
    [anon_sym_ATauthor] = ACTIONS(509),
    [anon_sym_ATglobal] = ACTIONS(509),
    [anon_sym_ATlink] = ACTIONS(509),
    [anon_sym_ATmethod] = ACTIONS(509),
    [anon_sym_ATparam] = ACTIONS(511),
    [anon_sym_ATproperty] = ACTIONS(511),
    [anon_sym_ATproperty_DASHread] = ACTIONS(509),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(509),
    [anon_sym_ATreturn] = ACTIONS(509),
    [anon_sym_ATsee] = ACTIONS(509),
    [anon_sym_ATthrows] = ACTIONS(509),
    [anon_sym_ATvar] = ACTIONS(509),
    [anon_sym_ATdeprecated] = ACTIONS(509),
    [anon_sym_ATsince] = ACTIONS(509),
    [anon_sym_ATversion] = ACTIONS(509),
    [anon_sym_ATtemplate] = ACTIONS(511),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(509),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(509),
    [anon_sym_ATimplements] = ACTIONS(509),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(509),
    [anon_sym_ATextends] = ACTIONS(509),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(509),
    [anon_sym_ATuse] = ACTIONS(511),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(509),
    [anon_sym_ATafter] = ACTIONS(511),
    [anon_sym_ATafterClass] = ACTIONS(509),
    [anon_sym_ATannotation] = ACTIONS(509),
    [anon_sym_ATbackupGlobals] = ACTIONS(509),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(509),
    [anon_sym_ATbefore] = ACTIONS(511),
    [anon_sym_ATbeforeClass] = ACTIONS(509),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(511),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(509),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(509),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(509),
    [anon_sym_ATcovers] = ACTIONS(511),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(511),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(509),
    [anon_sym_ATcoversNothing] = ACTIONS(509),
    [anon_sym_ATdataProvider] = ACTIONS(509),
    [anon_sym_ATdepends] = ACTIONS(511),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(509),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(509),
    [anon_sym_ATgroup] = ACTIONS(509),
    [anon_sym_ATlarge] = ACTIONS(509),
    [anon_sym_ATmedium] = ACTIONS(509),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(509),
    [anon_sym_ATrequires] = ACTIONS(511),
    [anon_sym_ATrequiresusages] = ACTIONS(509),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(509),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(509),
    [anon_sym_ATsmall] = ACTIONS(509),
    [anon_sym_ATtest] = ACTIONS(511),
    [anon_sym_ATtestWith] = ACTIONS(509),
    [anon_sym_ATtestdox] = ACTIONS(509),
    [anon_sym_ATticket] = ACTIONS(509),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(509),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(509),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(509),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(511),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(509),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(511),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(509),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(509),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(509),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(509),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(509),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(509),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(509),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(509),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(509),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(511),
    [anon_sym_ATreadonly] = ACTIONS(509),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(509),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(509),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(509),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(509),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(509),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(509),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(509),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(509),
    [anon_sym_ATparam_DASHout] = ACTIONS(509),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(509),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(511),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(509),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(509),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(509),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(509),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(509),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(509),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(509),
    [anon_sym_ATmixin] = ACTIONS(509),
    [sym__end] = ACTIONS(509),
    [sym__text_not_version] = ACTIONS(256),
  },
  [116] = {
    [sym_inline_tag] = STATE(114),
    [aux_sym_description_repeat1] = STATE(114),
    [anon_sym_LBRACE] = ACTIONS(5),
    [anon_sym_ATinheritdoc] = ACTIONS(513),
    [anon_sym_ATinheritDoc] = ACTIONS(513),
    [anon_sym_ATapi] = ACTIONS(513),
    [anon_sym_ATfilesource] = ACTIONS(513),
    [anon_sym_ATignore] = ACTIONS(513),
    [anon_sym_ATinternal] = ACTIONS(513),
    [anon_sym_ATcategory] = ACTIONS(513),
    [anon_sym_ATcopyright] = ACTIONS(513),
    [anon_sym_ATtodo] = ACTIONS(513),
    [anon_sym_ATexample] = ACTIONS(513),
    [anon_sym_ATlicense] = ACTIONS(513),
    [anon_sym_ATpackage] = ACTIONS(513),
    [anon_sym_ATsource] = ACTIONS(513),
    [anon_sym_ATsubpackage] = ACTIONS(513),
    [anon_sym_ATuses] = ACTIONS(513),
    [anon_sym_ATauthor] = ACTIONS(513),
    [anon_sym_ATglobal] = ACTIONS(513),
    [anon_sym_ATlink] = ACTIONS(513),
    [anon_sym_ATmethod] = ACTIONS(513),
    [anon_sym_ATparam] = ACTIONS(515),
    [anon_sym_ATproperty] = ACTIONS(515),
    [anon_sym_ATproperty_DASHread] = ACTIONS(513),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(513),
    [anon_sym_ATreturn] = ACTIONS(513),
    [anon_sym_ATsee] = ACTIONS(513),
    [anon_sym_ATthrows] = ACTIONS(513),
    [anon_sym_ATvar] = ACTIONS(513),
    [anon_sym_ATdeprecated] = ACTIONS(513),
    [anon_sym_ATsince] = ACTIONS(513),
    [anon_sym_ATversion] = ACTIONS(513),
    [anon_sym_ATtemplate] = ACTIONS(515),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(513),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(513),
    [anon_sym_ATimplements] = ACTIONS(513),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(513),
    [anon_sym_ATextends] = ACTIONS(513),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(513),
    [anon_sym_ATuse] = ACTIONS(515),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(513),
    [anon_sym_ATafter] = ACTIONS(515),
    [anon_sym_ATafterClass] = ACTIONS(513),
    [anon_sym_ATannotation] = ACTIONS(513),
    [anon_sym_ATbackupGlobals] = ACTIONS(513),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(513),
    [anon_sym_ATbefore] = ACTIONS(515),
    [anon_sym_ATbeforeClass] = ACTIONS(513),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(515),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(513),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(513),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(513),
    [anon_sym_ATcovers] = ACTIONS(515),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(515),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(513),
    [anon_sym_ATcoversNothing] = ACTIONS(513),
    [anon_sym_ATdataProvider] = ACTIONS(513),
    [anon_sym_ATdepends] = ACTIONS(515),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(513),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(513),
    [anon_sym_ATgroup] = ACTIONS(513),
    [anon_sym_ATlarge] = ACTIONS(513),
    [anon_sym_ATmedium] = ACTIONS(513),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(513),
    [anon_sym_ATrequires] = ACTIONS(515),
    [anon_sym_ATrequiresusages] = ACTIONS(513),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(513),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(513),
    [anon_sym_ATsmall] = ACTIONS(513),
    [anon_sym_ATtest] = ACTIONS(515),
    [anon_sym_ATtestWith] = ACTIONS(513),
    [anon_sym_ATtestdox] = ACTIONS(513),
    [anon_sym_ATticket] = ACTIONS(513),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(513),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(513),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(513),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(515),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(513),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(515),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(513),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(513),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(513),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(513),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(513),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(513),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(513),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(513),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(513),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(515),
    [anon_sym_ATreadonly] = ACTIONS(513),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(513),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(513),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(513),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(513),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(513),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(513),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(513),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(513),
    [anon_sym_ATparam_DASHout] = ACTIONS(513),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(513),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(515),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(513),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(513),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(513),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(513),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(513),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(513),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(513),
    [anon_sym_ATmixin] = ACTIONS(513),
    [sym__end] = ACTIONS(513),
    [sym_text] = ACTIONS(517),
  },
  [117] = {
    [sym_inline_tag] = STATE(139),
    [aux_sym__description_after_type_repeat1] = STATE(117),
    [anon_sym_LBRACE] = ACTIONS(519),
    [anon_sym_ATinheritdoc] = ACTIONS(522),
    [anon_sym_ATinheritDoc] = ACTIONS(522),
    [anon_sym_ATapi] = ACTIONS(522),
    [anon_sym_ATfilesource] = ACTIONS(522),
    [anon_sym_ATignore] = ACTIONS(522),
    [anon_sym_ATinternal] = ACTIONS(522),
    [anon_sym_ATcategory] = ACTIONS(522),
    [anon_sym_ATcopyright] = ACTIONS(522),
    [anon_sym_ATtodo] = ACTIONS(522),
    [anon_sym_ATexample] = ACTIONS(522),
    [anon_sym_ATlicense] = ACTIONS(522),
    [anon_sym_ATpackage] = ACTIONS(522),
    [anon_sym_ATsource] = ACTIONS(522),
    [anon_sym_ATsubpackage] = ACTIONS(522),
    [anon_sym_ATuses] = ACTIONS(522),
    [anon_sym_ATauthor] = ACTIONS(522),
    [anon_sym_ATglobal] = ACTIONS(522),
    [anon_sym_ATlink] = ACTIONS(522),
    [anon_sym_ATmethod] = ACTIONS(522),
    [anon_sym_ATparam] = ACTIONS(524),
    [anon_sym_ATproperty] = ACTIONS(524),
    [anon_sym_ATproperty_DASHread] = ACTIONS(522),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(522),
    [anon_sym_ATreturn] = ACTIONS(522),
    [anon_sym_ATsee] = ACTIONS(522),
    [anon_sym_ATthrows] = ACTIONS(522),
    [anon_sym_ATvar] = ACTIONS(522),
    [anon_sym_ATdeprecated] = ACTIONS(522),
    [anon_sym_ATsince] = ACTIONS(522),
    [anon_sym_ATversion] = ACTIONS(522),
    [anon_sym_ATtemplate] = ACTIONS(524),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(522),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(522),
    [anon_sym_ATimplements] = ACTIONS(522),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(522),
    [anon_sym_ATextends] = ACTIONS(522),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(522),
    [anon_sym_ATuse] = ACTIONS(524),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(522),
    [anon_sym_ATafter] = ACTIONS(524),
    [anon_sym_ATafterClass] = ACTIONS(522),
    [anon_sym_ATannotation] = ACTIONS(522),
    [anon_sym_ATbackupGlobals] = ACTIONS(522),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(522),
    [anon_sym_ATbefore] = ACTIONS(524),
    [anon_sym_ATbeforeClass] = ACTIONS(522),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(524),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(522),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(522),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(522),
    [anon_sym_ATcovers] = ACTIONS(524),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(524),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(522),
    [anon_sym_ATcoversNothing] = ACTIONS(522),
    [anon_sym_ATdataProvider] = ACTIONS(522),
    [anon_sym_ATdepends] = ACTIONS(524),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(522),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(522),
    [anon_sym_ATgroup] = ACTIONS(522),
    [anon_sym_ATlarge] = ACTIONS(522),
    [anon_sym_ATmedium] = ACTIONS(522),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(522),
    [anon_sym_ATrequires] = ACTIONS(524),
    [anon_sym_ATrequiresusages] = ACTIONS(522),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(522),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(522),
    [anon_sym_ATsmall] = ACTIONS(522),
    [anon_sym_ATtest] = ACTIONS(524),
    [anon_sym_ATtestWith] = ACTIONS(522),
    [anon_sym_ATtestdox] = ACTIONS(522),
    [anon_sym_ATticket] = ACTIONS(522),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(522),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(522),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(522),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(524),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(522),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(524),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(522),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(522),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(522),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(522),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(522),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(522),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(522),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(522),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(522),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(524),
    [anon_sym_ATreadonly] = ACTIONS(522),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(522),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(522),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(522),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(522),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(522),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(522),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(522),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(522),
    [anon_sym_ATparam_DASHout] = ACTIONS(522),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(522),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(524),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(522),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(522),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(522),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(522),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(522),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(522),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(522),
    [anon_sym_ATmixin] = ACTIONS(522),
    [sym__end] = ACTIONS(522),
    [sym__text_after_type] = ACTIONS(526),
  },
  [118] = {
    [anon_sym_LBRACE] = ACTIONS(195),
    [anon_sym_ATinheritdoc] = ACTIONS(195),
    [anon_sym_ATinheritDoc] = ACTIONS(195),
    [anon_sym_ATapi] = ACTIONS(195),
    [anon_sym_ATfilesource] = ACTIONS(195),
    [anon_sym_ATignore] = ACTIONS(195),
    [anon_sym_ATinternal] = ACTIONS(195),
    [anon_sym_ATcategory] = ACTIONS(195),
    [anon_sym_ATcopyright] = ACTIONS(195),
    [anon_sym_ATtodo] = ACTIONS(195),
    [anon_sym_ATexample] = ACTIONS(195),
    [anon_sym_ATlicense] = ACTIONS(195),
    [anon_sym_ATpackage] = ACTIONS(195),
    [anon_sym_ATsource] = ACTIONS(195),
    [anon_sym_ATsubpackage] = ACTIONS(195),
    [anon_sym_ATuses] = ACTIONS(195),
    [anon_sym_ATauthor] = ACTIONS(195),
    [anon_sym_LT] = ACTIONS(195),
    [anon_sym_ATglobal] = ACTIONS(195),
    [anon_sym_ATlink] = ACTIONS(195),
    [anon_sym_ATmethod] = ACTIONS(195),
    [anon_sym_ATparam] = ACTIONS(193),
    [anon_sym_ATproperty] = ACTIONS(193),
    [anon_sym_ATproperty_DASHread] = ACTIONS(195),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(195),
    [anon_sym_ATreturn] = ACTIONS(195),
    [anon_sym_ATsee] = ACTIONS(195),
    [anon_sym_ATthrows] = ACTIONS(195),
    [anon_sym_ATvar] = ACTIONS(195),
    [anon_sym_ATdeprecated] = ACTIONS(195),
    [anon_sym_ATsince] = ACTIONS(195),
    [anon_sym_ATversion] = ACTIONS(195),
    [anon_sym_ATtemplate] = ACTIONS(193),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(195),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(195),
    [anon_sym_ATimplements] = ACTIONS(195),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(195),
    [anon_sym_ATextends] = ACTIONS(195),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(195),
    [anon_sym_ATuse] = ACTIONS(193),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(195),
    [anon_sym_ATafter] = ACTIONS(193),
    [anon_sym_ATafterClass] = ACTIONS(195),
    [anon_sym_ATannotation] = ACTIONS(195),
    [anon_sym_ATbackupGlobals] = ACTIONS(195),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(195),
    [anon_sym_ATbefore] = ACTIONS(193),
    [anon_sym_ATbeforeClass] = ACTIONS(195),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(193),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(195),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(195),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(195),
    [anon_sym_ATcovers] = ACTIONS(193),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(193),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(195),
    [anon_sym_ATcoversNothing] = ACTIONS(195),
    [anon_sym_ATdataProvider] = ACTIONS(195),
    [anon_sym_ATdepends] = ACTIONS(193),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(195),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(195),
    [anon_sym_ATgroup] = ACTIONS(195),
    [anon_sym_ATlarge] = ACTIONS(195),
    [anon_sym_ATmedium] = ACTIONS(195),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(195),
    [anon_sym_ATrequires] = ACTIONS(193),
    [anon_sym_ATrequiresusages] = ACTIONS(195),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(195),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(195),
    [anon_sym_ATsmall] = ACTIONS(195),
    [anon_sym_ATtest] = ACTIONS(193),
    [anon_sym_ATtestWith] = ACTIONS(195),
    [anon_sym_ATtestdox] = ACTIONS(195),
    [anon_sym_ATticket] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(193),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(193),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(193),
    [anon_sym_ATreadonly] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(195),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(195),
    [anon_sym_ATparam_DASHout] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(193),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(195),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(195),
    [anon_sym_ATmixin] = ACTIONS(195),
    [anon_sym_COLON_COLON] = ACTIONS(195),
    [sym__end] = ACTIONS(195),
    [sym_text] = ACTIONS(195),
  },
  [119] = {
    [anon_sym_LBRACE] = ACTIONS(382),
    [anon_sym_ATinheritdoc] = ACTIONS(382),
    [anon_sym_ATinheritDoc] = ACTIONS(382),
    [anon_sym_ATapi] = ACTIONS(382),
    [anon_sym_ATfilesource] = ACTIONS(382),
    [anon_sym_ATignore] = ACTIONS(382),
    [anon_sym_ATinternal] = ACTIONS(382),
    [anon_sym_ATcategory] = ACTIONS(382),
    [anon_sym_ATcopyright] = ACTIONS(382),
    [anon_sym_ATtodo] = ACTIONS(382),
    [anon_sym_ATexample] = ACTIONS(382),
    [anon_sym_ATlicense] = ACTIONS(382),
    [anon_sym_ATpackage] = ACTIONS(382),
    [anon_sym_ATsource] = ACTIONS(382),
    [anon_sym_ATsubpackage] = ACTIONS(382),
    [anon_sym_ATuses] = ACTIONS(382),
    [anon_sym_ATauthor] = ACTIONS(382),
    [anon_sym_ATglobal] = ACTIONS(382),
    [anon_sym_ATlink] = ACTIONS(382),
    [anon_sym_ATmethod] = ACTIONS(382),
    [anon_sym_ATparam] = ACTIONS(380),
    [anon_sym_ATproperty] = ACTIONS(380),
    [anon_sym_ATproperty_DASHread] = ACTIONS(382),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(382),
    [anon_sym_ATreturn] = ACTIONS(382),
    [anon_sym_ATsee] = ACTIONS(382),
    [anon_sym_ATthrows] = ACTIONS(382),
    [anon_sym_ATvar] = ACTIONS(382),
    [anon_sym_ATdeprecated] = ACTIONS(382),
    [anon_sym_ATsince] = ACTIONS(382),
    [anon_sym_ATversion] = ACTIONS(382),
    [anon_sym_ATtemplate] = ACTIONS(380),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(382),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(382),
    [anon_sym_ATimplements] = ACTIONS(382),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(382),
    [anon_sym_ATextends] = ACTIONS(382),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(382),
    [anon_sym_ATuse] = ACTIONS(380),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(382),
    [anon_sym_ATafter] = ACTIONS(380),
    [anon_sym_ATafterClass] = ACTIONS(382),
    [anon_sym_ATannotation] = ACTIONS(382),
    [anon_sym_ATbackupGlobals] = ACTIONS(382),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(382),
    [anon_sym_ATbefore] = ACTIONS(380),
    [anon_sym_ATbeforeClass] = ACTIONS(382),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(380),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(382),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(382),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(382),
    [anon_sym_ATcovers] = ACTIONS(380),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(380),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(382),
    [anon_sym_ATcoversNothing] = ACTIONS(382),
    [anon_sym_ATdataProvider] = ACTIONS(382),
    [anon_sym_ATdepends] = ACTIONS(380),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(382),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(382),
    [anon_sym_ATgroup] = ACTIONS(382),
    [anon_sym_ATlarge] = ACTIONS(382),
    [anon_sym_ATmedium] = ACTIONS(382),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(382),
    [anon_sym_ATrequires] = ACTIONS(380),
    [anon_sym_ATrequiresusages] = ACTIONS(382),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(382),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(382),
    [anon_sym_ATsmall] = ACTIONS(382),
    [anon_sym_ATtest] = ACTIONS(380),
    [anon_sym_ATtestWith] = ACTIONS(382),
    [anon_sym_ATtestdox] = ACTIONS(382),
    [anon_sym_ATticket] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(380),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(380),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(380),
    [anon_sym_ATreadonly] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(382),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(382),
    [anon_sym_ATparam_DASHout] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(380),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(382),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(382),
    [anon_sym_ATmixin] = ACTIONS(382),
    [anon_sym_PIPE] = ACTIONS(382),
    [anon_sym_DOLLAR] = ACTIONS(382),
    [sym__end] = ACTIONS(382),
    [sym__text_after_type] = ACTIONS(382),
  },
  [120] = {
    [anon_sym_LBRACE] = ACTIONS(395),
    [anon_sym_ATinheritdoc] = ACTIONS(395),
    [anon_sym_ATinheritDoc] = ACTIONS(395),
    [anon_sym_ATapi] = ACTIONS(395),
    [anon_sym_ATfilesource] = ACTIONS(395),
    [anon_sym_ATignore] = ACTIONS(395),
    [anon_sym_ATinternal] = ACTIONS(395),
    [anon_sym_ATcategory] = ACTIONS(395),
    [anon_sym_ATcopyright] = ACTIONS(395),
    [anon_sym_ATtodo] = ACTIONS(395),
    [anon_sym_ATexample] = ACTIONS(395),
    [anon_sym_ATlicense] = ACTIONS(395),
    [anon_sym_ATpackage] = ACTIONS(395),
    [anon_sym_ATsource] = ACTIONS(395),
    [anon_sym_ATsubpackage] = ACTIONS(395),
    [anon_sym_ATuses] = ACTIONS(395),
    [anon_sym_ATauthor] = ACTIONS(395),
    [anon_sym_ATglobal] = ACTIONS(395),
    [anon_sym_ATlink] = ACTIONS(395),
    [anon_sym_ATmethod] = ACTIONS(395),
    [anon_sym_ATparam] = ACTIONS(393),
    [anon_sym_ATproperty] = ACTIONS(393),
    [anon_sym_ATproperty_DASHread] = ACTIONS(395),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(395),
    [anon_sym_ATreturn] = ACTIONS(395),
    [anon_sym_ATsee] = ACTIONS(395),
    [anon_sym_ATthrows] = ACTIONS(395),
    [anon_sym_ATvar] = ACTIONS(395),
    [anon_sym_ATdeprecated] = ACTIONS(395),
    [anon_sym_ATsince] = ACTIONS(395),
    [anon_sym_ATversion] = ACTIONS(395),
    [anon_sym_ATtemplate] = ACTIONS(393),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(395),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(395),
    [anon_sym_ATimplements] = ACTIONS(395),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(395),
    [anon_sym_ATextends] = ACTIONS(395),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(395),
    [anon_sym_ATuse] = ACTIONS(393),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(395),
    [anon_sym_ATafter] = ACTIONS(393),
    [anon_sym_ATafterClass] = ACTIONS(395),
    [anon_sym_ATannotation] = ACTIONS(395),
    [anon_sym_ATbackupGlobals] = ACTIONS(395),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(395),
    [anon_sym_ATbefore] = ACTIONS(393),
    [anon_sym_ATbeforeClass] = ACTIONS(395),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(393),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(395),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(395),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(395),
    [anon_sym_ATcovers] = ACTIONS(393),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(393),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(395),
    [anon_sym_ATcoversNothing] = ACTIONS(395),
    [anon_sym_ATdataProvider] = ACTIONS(395),
    [anon_sym_ATdepends] = ACTIONS(393),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(395),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(395),
    [anon_sym_ATgroup] = ACTIONS(395),
    [anon_sym_ATlarge] = ACTIONS(395),
    [anon_sym_ATmedium] = ACTIONS(395),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(395),
    [anon_sym_ATrequires] = ACTIONS(393),
    [anon_sym_ATrequiresusages] = ACTIONS(395),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(395),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(395),
    [anon_sym_ATsmall] = ACTIONS(395),
    [anon_sym_ATtest] = ACTIONS(393),
    [anon_sym_ATtestWith] = ACTIONS(395),
    [anon_sym_ATtestdox] = ACTIONS(395),
    [anon_sym_ATticket] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(393),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(393),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(393),
    [anon_sym_ATreadonly] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(395),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(395),
    [anon_sym_ATparam_DASHout] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(393),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(395),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(395),
    [anon_sym_ATmixin] = ACTIONS(395),
    [anon_sym_PIPE] = ACTIONS(395),
    [anon_sym_DOLLAR] = ACTIONS(395),
    [sym__end] = ACTIONS(395),
    [sym__text_after_type] = ACTIONS(395),
  },
  [121] = {
    [sym_inline_tag] = STATE(148),
    [aux_sym__description_not_version_repeat1] = STATE(121),
    [anon_sym_LBRACE] = ACTIONS(529),
    [anon_sym_ATinheritdoc] = ACTIONS(532),
    [anon_sym_ATinheritDoc] = ACTIONS(532),
    [anon_sym_ATapi] = ACTIONS(532),
    [anon_sym_ATfilesource] = ACTIONS(532),
    [anon_sym_ATignore] = ACTIONS(532),
    [anon_sym_ATinternal] = ACTIONS(532),
    [anon_sym_ATcategory] = ACTIONS(532),
    [anon_sym_ATcopyright] = ACTIONS(532),
    [anon_sym_ATtodo] = ACTIONS(532),
    [anon_sym_ATexample] = ACTIONS(532),
    [anon_sym_ATlicense] = ACTIONS(532),
    [anon_sym_ATpackage] = ACTIONS(532),
    [anon_sym_ATsource] = ACTIONS(532),
    [anon_sym_ATsubpackage] = ACTIONS(532),
    [anon_sym_ATuses] = ACTIONS(532),
    [anon_sym_ATauthor] = ACTIONS(532),
    [anon_sym_ATglobal] = ACTIONS(532),
    [anon_sym_ATlink] = ACTIONS(532),
    [anon_sym_ATmethod] = ACTIONS(532),
    [anon_sym_ATparam] = ACTIONS(534),
    [anon_sym_ATproperty] = ACTIONS(534),
    [anon_sym_ATproperty_DASHread] = ACTIONS(532),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(532),
    [anon_sym_ATreturn] = ACTIONS(532),
    [anon_sym_ATsee] = ACTIONS(532),
    [anon_sym_ATthrows] = ACTIONS(532),
    [anon_sym_ATvar] = ACTIONS(532),
    [anon_sym_ATdeprecated] = ACTIONS(532),
    [anon_sym_ATsince] = ACTIONS(532),
    [anon_sym_ATversion] = ACTIONS(532),
    [anon_sym_ATtemplate] = ACTIONS(534),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(532),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(532),
    [anon_sym_ATimplements] = ACTIONS(532),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(532),
    [anon_sym_ATextends] = ACTIONS(532),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(532),
    [anon_sym_ATuse] = ACTIONS(534),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(532),
    [anon_sym_ATafter] = ACTIONS(534),
    [anon_sym_ATafterClass] = ACTIONS(532),
    [anon_sym_ATannotation] = ACTIONS(532),
    [anon_sym_ATbackupGlobals] = ACTIONS(532),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(532),
    [anon_sym_ATbefore] = ACTIONS(534),
    [anon_sym_ATbeforeClass] = ACTIONS(532),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(534),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(532),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(532),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(532),
    [anon_sym_ATcovers] = ACTIONS(534),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(534),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(532),
    [anon_sym_ATcoversNothing] = ACTIONS(532),
    [anon_sym_ATdataProvider] = ACTIONS(532),
    [anon_sym_ATdepends] = ACTIONS(534),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(532),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(532),
    [anon_sym_ATgroup] = ACTIONS(532),
    [anon_sym_ATlarge] = ACTIONS(532),
    [anon_sym_ATmedium] = ACTIONS(532),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(532),
    [anon_sym_ATrequires] = ACTIONS(534),
    [anon_sym_ATrequiresusages] = ACTIONS(532),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(532),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(532),
    [anon_sym_ATsmall] = ACTIONS(532),
    [anon_sym_ATtest] = ACTIONS(534),
    [anon_sym_ATtestWith] = ACTIONS(532),
    [anon_sym_ATtestdox] = ACTIONS(532),
    [anon_sym_ATticket] = ACTIONS(532),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(532),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(532),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(532),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(534),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(532),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(534),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(532),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(532),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(532),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(532),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(532),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(532),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(532),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(532),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(532),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(534),
    [anon_sym_ATreadonly] = ACTIONS(532),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(532),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(532),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(532),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(532),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(532),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(532),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(532),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(532),
    [anon_sym_ATparam_DASHout] = ACTIONS(532),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(532),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(534),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(532),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(532),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(532),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(532),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(532),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(532),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(532),
    [anon_sym_ATmixin] = ACTIONS(532),
    [sym__end] = ACTIONS(532),
    [sym__text_not_version] = ACTIONS(536),
  },
  [122] = {
    [anon_sym_LBRACE] = ACTIONS(207),
    [anon_sym_ATinheritdoc] = ACTIONS(207),
    [anon_sym_ATinheritDoc] = ACTIONS(207),
    [anon_sym_ATapi] = ACTIONS(207),
    [anon_sym_ATfilesource] = ACTIONS(207),
    [anon_sym_ATignore] = ACTIONS(207),
    [anon_sym_ATinternal] = ACTIONS(207),
    [anon_sym_ATcategory] = ACTIONS(207),
    [anon_sym_ATcopyright] = ACTIONS(207),
    [anon_sym_ATtodo] = ACTIONS(207),
    [anon_sym_ATexample] = ACTIONS(207),
    [anon_sym_ATlicense] = ACTIONS(207),
    [anon_sym_ATpackage] = ACTIONS(207),
    [anon_sym_ATsource] = ACTIONS(207),
    [anon_sym_ATsubpackage] = ACTIONS(207),
    [anon_sym_ATuses] = ACTIONS(207),
    [anon_sym_ATauthor] = ACTIONS(207),
    [anon_sym_LT] = ACTIONS(207),
    [anon_sym_ATglobal] = ACTIONS(207),
    [anon_sym_ATlink] = ACTIONS(207),
    [anon_sym_ATmethod] = ACTIONS(207),
    [anon_sym_ATparam] = ACTIONS(205),
    [anon_sym_ATproperty] = ACTIONS(205),
    [anon_sym_ATproperty_DASHread] = ACTIONS(207),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(207),
    [anon_sym_ATreturn] = ACTIONS(207),
    [anon_sym_ATsee] = ACTIONS(207),
    [anon_sym_ATthrows] = ACTIONS(207),
    [anon_sym_ATvar] = ACTIONS(207),
    [anon_sym_ATdeprecated] = ACTIONS(207),
    [anon_sym_ATsince] = ACTIONS(207),
    [anon_sym_ATversion] = ACTIONS(207),
    [anon_sym_ATtemplate] = ACTIONS(205),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(207),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(207),
    [anon_sym_ATimplements] = ACTIONS(207),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(207),
    [anon_sym_ATextends] = ACTIONS(207),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(207),
    [anon_sym_ATuse] = ACTIONS(205),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(207),
    [anon_sym_ATafter] = ACTIONS(205),
    [anon_sym_ATafterClass] = ACTIONS(207),
    [anon_sym_ATannotation] = ACTIONS(207),
    [anon_sym_ATbackupGlobals] = ACTIONS(207),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(207),
    [anon_sym_ATbefore] = ACTIONS(205),
    [anon_sym_ATbeforeClass] = ACTIONS(207),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(205),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(207),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(207),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(207),
    [anon_sym_ATcovers] = ACTIONS(205),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(205),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(207),
    [anon_sym_ATcoversNothing] = ACTIONS(207),
    [anon_sym_ATdataProvider] = ACTIONS(207),
    [anon_sym_ATdepends] = ACTIONS(205),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(207),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(207),
    [anon_sym_ATgroup] = ACTIONS(207),
    [anon_sym_ATlarge] = ACTIONS(207),
    [anon_sym_ATmedium] = ACTIONS(207),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(207),
    [anon_sym_ATrequires] = ACTIONS(205),
    [anon_sym_ATrequiresusages] = ACTIONS(207),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(207),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(207),
    [anon_sym_ATsmall] = ACTIONS(207),
    [anon_sym_ATtest] = ACTIONS(205),
    [anon_sym_ATtestWith] = ACTIONS(207),
    [anon_sym_ATtestdox] = ACTIONS(207),
    [anon_sym_ATticket] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(205),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(205),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(205),
    [anon_sym_ATreadonly] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(207),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(207),
    [anon_sym_ATparam_DASHout] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(205),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(207),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(207),
    [anon_sym_ATmixin] = ACTIONS(207),
    [anon_sym_COLON_COLON] = ACTIONS(207),
    [sym__end] = ACTIONS(207),
    [sym_text] = ACTIONS(207),
  },
  [123] = {
    [anon_sym_LBRACE] = ACTIONS(367),
    [anon_sym_ATinheritdoc] = ACTIONS(367),
    [anon_sym_ATinheritDoc] = ACTIONS(367),
    [anon_sym_ATapi] = ACTIONS(367),
    [anon_sym_ATfilesource] = ACTIONS(367),
    [anon_sym_ATignore] = ACTIONS(367),
    [anon_sym_ATinternal] = ACTIONS(367),
    [anon_sym_ATcategory] = ACTIONS(367),
    [anon_sym_ATcopyright] = ACTIONS(367),
    [anon_sym_ATtodo] = ACTIONS(367),
    [anon_sym_ATexample] = ACTIONS(367),
    [anon_sym_ATlicense] = ACTIONS(367),
    [anon_sym_ATpackage] = ACTIONS(367),
    [anon_sym_ATsource] = ACTIONS(367),
    [anon_sym_ATsubpackage] = ACTIONS(367),
    [anon_sym_ATuses] = ACTIONS(367),
    [anon_sym_ATauthor] = ACTIONS(367),
    [anon_sym_ATglobal] = ACTIONS(367),
    [anon_sym_ATlink] = ACTIONS(367),
    [anon_sym_ATmethod] = ACTIONS(367),
    [anon_sym_ATparam] = ACTIONS(365),
    [anon_sym_ATproperty] = ACTIONS(365),
    [anon_sym_ATproperty_DASHread] = ACTIONS(367),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(367),
    [anon_sym_ATreturn] = ACTIONS(367),
    [anon_sym_ATsee] = ACTIONS(367),
    [anon_sym_ATthrows] = ACTIONS(367),
    [anon_sym_ATvar] = ACTIONS(367),
    [anon_sym_ATdeprecated] = ACTIONS(367),
    [anon_sym_ATsince] = ACTIONS(367),
    [anon_sym_ATversion] = ACTIONS(367),
    [anon_sym_ATtemplate] = ACTIONS(365),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(367),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(367),
    [anon_sym_ATimplements] = ACTIONS(367),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(367),
    [anon_sym_ATextends] = ACTIONS(367),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(367),
    [anon_sym_ATuse] = ACTIONS(365),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(367),
    [anon_sym_ATafter] = ACTIONS(365),
    [anon_sym_ATafterClass] = ACTIONS(367),
    [anon_sym_ATannotation] = ACTIONS(367),
    [anon_sym_ATbackupGlobals] = ACTIONS(367),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(367),
    [anon_sym_ATbefore] = ACTIONS(365),
    [anon_sym_ATbeforeClass] = ACTIONS(367),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(365),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(367),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(367),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(367),
    [anon_sym_ATcovers] = ACTIONS(365),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(365),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(367),
    [anon_sym_ATcoversNothing] = ACTIONS(367),
    [anon_sym_ATdataProvider] = ACTIONS(367),
    [anon_sym_ATdepends] = ACTIONS(365),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(367),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(367),
    [anon_sym_ATgroup] = ACTIONS(367),
    [anon_sym_ATlarge] = ACTIONS(367),
    [anon_sym_ATmedium] = ACTIONS(367),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(367),
    [anon_sym_ATrequires] = ACTIONS(365),
    [anon_sym_ATrequiresusages] = ACTIONS(367),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(367),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(367),
    [anon_sym_ATsmall] = ACTIONS(367),
    [anon_sym_ATtest] = ACTIONS(365),
    [anon_sym_ATtestWith] = ACTIONS(367),
    [anon_sym_ATtestdox] = ACTIONS(367),
    [anon_sym_ATticket] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(365),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(365),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(365),
    [anon_sym_ATreadonly] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(367),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(367),
    [anon_sym_ATparam_DASHout] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(365),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(367),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(367),
    [anon_sym_ATmixin] = ACTIONS(367),
    [anon_sym_AMP] = ACTIONS(367),
    [anon_sym_DOLLAR] = ACTIONS(367),
    [sym__end] = ACTIONS(367),
    [sym__text_after_type] = ACTIONS(367),
  },
  [124] = {
    [sym_inline_tag] = STATE(139),
    [aux_sym__description_after_type_repeat1] = STATE(117),
    [anon_sym_LBRACE] = ACTIONS(351),
    [anon_sym_ATinheritdoc] = ACTIONS(539),
    [anon_sym_ATinheritDoc] = ACTIONS(539),
    [anon_sym_ATapi] = ACTIONS(539),
    [anon_sym_ATfilesource] = ACTIONS(539),
    [anon_sym_ATignore] = ACTIONS(539),
    [anon_sym_ATinternal] = ACTIONS(539),
    [anon_sym_ATcategory] = ACTIONS(539),
    [anon_sym_ATcopyright] = ACTIONS(539),
    [anon_sym_ATtodo] = ACTIONS(539),
    [anon_sym_ATexample] = ACTIONS(539),
    [anon_sym_ATlicense] = ACTIONS(539),
    [anon_sym_ATpackage] = ACTIONS(539),
    [anon_sym_ATsource] = ACTIONS(539),
    [anon_sym_ATsubpackage] = ACTIONS(539),
    [anon_sym_ATuses] = ACTIONS(539),
    [anon_sym_ATauthor] = ACTIONS(539),
    [anon_sym_ATglobal] = ACTIONS(539),
    [anon_sym_ATlink] = ACTIONS(539),
    [anon_sym_ATmethod] = ACTIONS(539),
    [anon_sym_ATparam] = ACTIONS(541),
    [anon_sym_ATproperty] = ACTIONS(541),
    [anon_sym_ATproperty_DASHread] = ACTIONS(539),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(539),
    [anon_sym_ATreturn] = ACTIONS(539),
    [anon_sym_ATsee] = ACTIONS(539),
    [anon_sym_ATthrows] = ACTIONS(539),
    [anon_sym_ATvar] = ACTIONS(539),
    [anon_sym_ATdeprecated] = ACTIONS(539),
    [anon_sym_ATsince] = ACTIONS(539),
    [anon_sym_ATversion] = ACTIONS(539),
    [anon_sym_ATtemplate] = ACTIONS(541),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(539),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(539),
    [anon_sym_ATimplements] = ACTIONS(539),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(539),
    [anon_sym_ATextends] = ACTIONS(539),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(539),
    [anon_sym_ATuse] = ACTIONS(541),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(539),
    [anon_sym_ATafter] = ACTIONS(541),
    [anon_sym_ATafterClass] = ACTIONS(539),
    [anon_sym_ATannotation] = ACTIONS(539),
    [anon_sym_ATbackupGlobals] = ACTIONS(539),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(539),
    [anon_sym_ATbefore] = ACTIONS(541),
    [anon_sym_ATbeforeClass] = ACTIONS(539),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(541),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(539),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(539),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(539),
    [anon_sym_ATcovers] = ACTIONS(541),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(541),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(539),
    [anon_sym_ATcoversNothing] = ACTIONS(539),
    [anon_sym_ATdataProvider] = ACTIONS(539),
    [anon_sym_ATdepends] = ACTIONS(541),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(539),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(539),
    [anon_sym_ATgroup] = ACTIONS(539),
    [anon_sym_ATlarge] = ACTIONS(539),
    [anon_sym_ATmedium] = ACTIONS(539),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(539),
    [anon_sym_ATrequires] = ACTIONS(541),
    [anon_sym_ATrequiresusages] = ACTIONS(539),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(539),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(539),
    [anon_sym_ATsmall] = ACTIONS(539),
    [anon_sym_ATtest] = ACTIONS(541),
    [anon_sym_ATtestWith] = ACTIONS(539),
    [anon_sym_ATtestdox] = ACTIONS(539),
    [anon_sym_ATticket] = ACTIONS(539),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(539),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(539),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(539),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(541),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(539),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(541),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(539),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(539),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(539),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(539),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(539),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(539),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(539),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(539),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(539),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(541),
    [anon_sym_ATreadonly] = ACTIONS(539),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(539),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(539),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(539),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(539),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(539),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(539),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(539),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(539),
    [anon_sym_ATparam_DASHout] = ACTIONS(539),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(539),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(541),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(539),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(539),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(539),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(539),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(539),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(539),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(539),
    [anon_sym_ATmixin] = ACTIONS(539),
    [sym__end] = ACTIONS(539),
    [sym__text_after_type] = ACTIONS(359),
  },
  [125] = {
    [anon_sym_LBRACE] = ACTIONS(427),
    [anon_sym_ATinheritdoc] = ACTIONS(427),
    [anon_sym_ATinheritDoc] = ACTIONS(427),
    [anon_sym_ATapi] = ACTIONS(427),
    [anon_sym_ATfilesource] = ACTIONS(427),
    [anon_sym_ATignore] = ACTIONS(427),
    [anon_sym_ATinternal] = ACTIONS(427),
    [anon_sym_ATcategory] = ACTIONS(427),
    [anon_sym_ATcopyright] = ACTIONS(427),
    [anon_sym_ATtodo] = ACTIONS(427),
    [anon_sym_ATexample] = ACTIONS(427),
    [anon_sym_ATlicense] = ACTIONS(427),
    [anon_sym_ATpackage] = ACTIONS(427),
    [anon_sym_ATsource] = ACTIONS(427),
    [anon_sym_ATsubpackage] = ACTIONS(427),
    [anon_sym_ATuses] = ACTIONS(427),
    [anon_sym_ATauthor] = ACTIONS(427),
    [anon_sym_ATglobal] = ACTIONS(427),
    [anon_sym_ATlink] = ACTIONS(427),
    [anon_sym_ATmethod] = ACTIONS(427),
    [anon_sym_ATparam] = ACTIONS(424),
    [anon_sym_ATproperty] = ACTIONS(424),
    [anon_sym_ATproperty_DASHread] = ACTIONS(427),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(427),
    [anon_sym_ATreturn] = ACTIONS(427),
    [anon_sym_ATsee] = ACTIONS(427),
    [anon_sym_ATthrows] = ACTIONS(427),
    [anon_sym_ATvar] = ACTIONS(427),
    [anon_sym_ATdeprecated] = ACTIONS(427),
    [anon_sym_ATsince] = ACTIONS(427),
    [anon_sym_ATversion] = ACTIONS(427),
    [anon_sym_ATtemplate] = ACTIONS(424),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(427),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(427),
    [anon_sym_ATimplements] = ACTIONS(427),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(427),
    [anon_sym_ATextends] = ACTIONS(427),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(427),
    [anon_sym_ATuse] = ACTIONS(424),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(427),
    [anon_sym_ATafter] = ACTIONS(424),
    [anon_sym_ATafterClass] = ACTIONS(427),
    [anon_sym_ATannotation] = ACTIONS(427),
    [anon_sym_ATbackupGlobals] = ACTIONS(427),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(427),
    [anon_sym_ATbefore] = ACTIONS(424),
    [anon_sym_ATbeforeClass] = ACTIONS(427),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(424),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(427),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(427),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(427),
    [anon_sym_ATcovers] = ACTIONS(424),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(424),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(427),
    [anon_sym_ATcoversNothing] = ACTIONS(427),
    [anon_sym_ATdataProvider] = ACTIONS(427),
    [anon_sym_ATdepends] = ACTIONS(424),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(427),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(427),
    [anon_sym_ATgroup] = ACTIONS(427),
    [anon_sym_ATlarge] = ACTIONS(427),
    [anon_sym_ATmedium] = ACTIONS(427),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(427),
    [anon_sym_ATrequires] = ACTIONS(424),
    [anon_sym_ATrequiresusages] = ACTIONS(427),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(427),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(427),
    [anon_sym_ATsmall] = ACTIONS(427),
    [anon_sym_ATtest] = ACTIONS(424),
    [anon_sym_ATtestWith] = ACTIONS(427),
    [anon_sym_ATtestdox] = ACTIONS(427),
    [anon_sym_ATticket] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(424),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(424),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(424),
    [anon_sym_ATreadonly] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(427),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(427),
    [anon_sym_ATparam_DASHout] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(424),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(427),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(427),
    [anon_sym_ATmixin] = ACTIONS(427),
    [anon_sym_PIPE] = ACTIONS(427),
    [anon_sym_DOLLAR] = ACTIONS(427),
    [sym__end] = ACTIONS(427),
    [sym__text_after_type] = ACTIONS(427),
  },
  [126] = {
    [anon_sym_LBRACE] = ACTIONS(484),
    [anon_sym_ATinheritdoc] = ACTIONS(484),
    [anon_sym_ATinheritDoc] = ACTIONS(484),
    [anon_sym_ATapi] = ACTIONS(484),
    [anon_sym_ATfilesource] = ACTIONS(484),
    [anon_sym_ATignore] = ACTIONS(484),
    [anon_sym_ATinternal] = ACTIONS(484),
    [anon_sym_ATcategory] = ACTIONS(484),
    [anon_sym_ATcopyright] = ACTIONS(484),
    [anon_sym_ATtodo] = ACTIONS(484),
    [anon_sym_ATexample] = ACTIONS(484),
    [anon_sym_ATlicense] = ACTIONS(484),
    [anon_sym_ATpackage] = ACTIONS(484),
    [anon_sym_ATsource] = ACTIONS(484),
    [anon_sym_ATsubpackage] = ACTIONS(484),
    [anon_sym_ATuses] = ACTIONS(484),
    [anon_sym_ATauthor] = ACTIONS(484),
    [anon_sym_ATglobal] = ACTIONS(484),
    [anon_sym_ATlink] = ACTIONS(484),
    [anon_sym_ATmethod] = ACTIONS(484),
    [anon_sym_ATparam] = ACTIONS(482),
    [anon_sym_ATproperty] = ACTIONS(482),
    [anon_sym_ATproperty_DASHread] = ACTIONS(484),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(484),
    [anon_sym_ATreturn] = ACTIONS(484),
    [anon_sym_ATsee] = ACTIONS(484),
    [anon_sym_ATthrows] = ACTIONS(484),
    [anon_sym_ATvar] = ACTIONS(484),
    [anon_sym_ATdeprecated] = ACTIONS(484),
    [anon_sym_ATsince] = ACTIONS(484),
    [anon_sym_ATversion] = ACTIONS(484),
    [anon_sym_ATtemplate] = ACTIONS(482),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(484),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(484),
    [anon_sym_ATimplements] = ACTIONS(484),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(484),
    [anon_sym_ATextends] = ACTIONS(484),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(484),
    [anon_sym_ATuse] = ACTIONS(482),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(484),
    [anon_sym_ATafter] = ACTIONS(482),
    [anon_sym_ATafterClass] = ACTIONS(484),
    [anon_sym_ATannotation] = ACTIONS(484),
    [anon_sym_ATbackupGlobals] = ACTIONS(484),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(484),
    [anon_sym_ATbefore] = ACTIONS(482),
    [anon_sym_ATbeforeClass] = ACTIONS(484),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(482),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(484),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(484),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(484),
    [anon_sym_ATcovers] = ACTIONS(482),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(482),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(484),
    [anon_sym_ATcoversNothing] = ACTIONS(484),
    [anon_sym_ATdataProvider] = ACTIONS(484),
    [anon_sym_ATdepends] = ACTIONS(482),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(484),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(484),
    [anon_sym_ATgroup] = ACTIONS(484),
    [anon_sym_ATlarge] = ACTIONS(484),
    [anon_sym_ATmedium] = ACTIONS(484),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(484),
    [anon_sym_ATrequires] = ACTIONS(482),
    [anon_sym_ATrequiresusages] = ACTIONS(484),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(484),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(484),
    [anon_sym_ATsmall] = ACTIONS(484),
    [anon_sym_ATtest] = ACTIONS(482),
    [anon_sym_ATtestWith] = ACTIONS(484),
    [anon_sym_ATtestdox] = ACTIONS(484),
    [anon_sym_ATticket] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(482),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(482),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(482),
    [anon_sym_ATreadonly] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(484),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(484),
    [anon_sym_ATparam_DASHout] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(482),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(484),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(484),
    [anon_sym_ATmixin] = ACTIONS(484),
    [anon_sym_PIPE] = ACTIONS(484),
    [anon_sym_DOLLAR] = ACTIONS(484),
    [sym__end] = ACTIONS(484),
    [sym__text_after_type] = ACTIONS(484),
  },
  [127] = {
    [anon_sym_LBRACE] = ACTIONS(543),
    [anon_sym_ATinheritdoc] = ACTIONS(543),
    [anon_sym_ATinheritDoc] = ACTIONS(543),
    [anon_sym_ATapi] = ACTIONS(543),
    [anon_sym_ATfilesource] = ACTIONS(543),
    [anon_sym_ATignore] = ACTIONS(543),
    [anon_sym_ATinternal] = ACTIONS(543),
    [anon_sym_ATcategory] = ACTIONS(543),
    [anon_sym_ATcopyright] = ACTIONS(543),
    [anon_sym_ATtodo] = ACTIONS(543),
    [anon_sym_ATexample] = ACTIONS(543),
    [anon_sym_ATlicense] = ACTIONS(543),
    [anon_sym_ATpackage] = ACTIONS(543),
    [anon_sym_ATsource] = ACTIONS(543),
    [anon_sym_ATsubpackage] = ACTIONS(543),
    [anon_sym_ATuses] = ACTIONS(543),
    [anon_sym_ATauthor] = ACTIONS(543),
    [anon_sym_ATglobal] = ACTIONS(543),
    [anon_sym_ATlink] = ACTIONS(543),
    [anon_sym_ATmethod] = ACTIONS(543),
    [anon_sym_ATparam] = ACTIONS(545),
    [anon_sym_ATproperty] = ACTIONS(545),
    [anon_sym_ATproperty_DASHread] = ACTIONS(543),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(543),
    [anon_sym_ATreturn] = ACTIONS(543),
    [anon_sym_ATsee] = ACTIONS(543),
    [anon_sym_ATthrows] = ACTIONS(543),
    [anon_sym_ATvar] = ACTIONS(543),
    [anon_sym_ATdeprecated] = ACTIONS(543),
    [anon_sym_ATsince] = ACTIONS(543),
    [anon_sym_ATversion] = ACTIONS(543),
    [anon_sym_ATtemplate] = ACTIONS(545),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(543),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(543),
    [anon_sym_ATimplements] = ACTIONS(543),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(543),
    [anon_sym_ATextends] = ACTIONS(543),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(543),
    [anon_sym_ATuse] = ACTIONS(545),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(543),
    [anon_sym_ATafter] = ACTIONS(545),
    [anon_sym_ATafterClass] = ACTIONS(543),
    [anon_sym_ATannotation] = ACTIONS(543),
    [anon_sym_ATbackupGlobals] = ACTIONS(543),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(543),
    [anon_sym_ATbefore] = ACTIONS(545),
    [anon_sym_ATbeforeClass] = ACTIONS(543),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(545),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(543),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(543),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(543),
    [anon_sym_ATcovers] = ACTIONS(545),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(545),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(543),
    [anon_sym_ATcoversNothing] = ACTIONS(543),
    [anon_sym_ATdataProvider] = ACTIONS(543),
    [anon_sym_ATdepends] = ACTIONS(545),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(543),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(543),
    [anon_sym_ATgroup] = ACTIONS(543),
    [anon_sym_ATlarge] = ACTIONS(543),
    [anon_sym_ATmedium] = ACTIONS(543),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(543),
    [anon_sym_ATrequires] = ACTIONS(545),
    [anon_sym_ATrequiresusages] = ACTIONS(543),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(543),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(543),
    [anon_sym_ATsmall] = ACTIONS(543),
    [anon_sym_ATtest] = ACTIONS(545),
    [anon_sym_ATtestWith] = ACTIONS(543),
    [anon_sym_ATtestdox] = ACTIONS(543),
    [anon_sym_ATticket] = ACTIONS(543),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(543),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(543),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(543),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(545),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(543),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(545),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(543),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(543),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(543),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(543),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(543),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(543),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(543),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(543),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(543),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(545),
    [anon_sym_ATreadonly] = ACTIONS(543),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(543),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(543),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(543),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(543),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(543),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(543),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(543),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(543),
    [anon_sym_ATparam_DASHout] = ACTIONS(543),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(543),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(545),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(543),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(543),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(543),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(543),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(543),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(543),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(543),
    [anon_sym_ATmixin] = ACTIONS(543),
    [anon_sym_LPAREN_RPAREN] = ACTIONS(547),
    [sym__end] = ACTIONS(543),
    [sym_text] = ACTIONS(543),
  },
  [128] = {
    [anon_sym_LBRACE] = ACTIONS(223),
    [anon_sym_ATinheritdoc] = ACTIONS(223),
    [anon_sym_ATinheritDoc] = ACTIONS(223),
    [anon_sym_ATapi] = ACTIONS(223),
    [anon_sym_ATfilesource] = ACTIONS(223),
    [anon_sym_ATignore] = ACTIONS(223),
    [anon_sym_ATinternal] = ACTIONS(223),
    [anon_sym_ATcategory] = ACTIONS(223),
    [anon_sym_ATcopyright] = ACTIONS(223),
    [anon_sym_ATtodo] = ACTIONS(223),
    [anon_sym_ATexample] = ACTIONS(223),
    [anon_sym_ATlicense] = ACTIONS(223),
    [anon_sym_ATpackage] = ACTIONS(223),
    [anon_sym_ATsource] = ACTIONS(223),
    [anon_sym_ATsubpackage] = ACTIONS(223),
    [anon_sym_ATuses] = ACTIONS(223),
    [anon_sym_ATauthor] = ACTIONS(223),
    [anon_sym_ATglobal] = ACTIONS(223),
    [anon_sym_ATlink] = ACTIONS(223),
    [anon_sym_ATmethod] = ACTIONS(223),
    [anon_sym_ATparam] = ACTIONS(221),
    [anon_sym_ATproperty] = ACTIONS(221),
    [anon_sym_ATproperty_DASHread] = ACTIONS(223),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(223),
    [anon_sym_ATreturn] = ACTIONS(223),
    [anon_sym_ATsee] = ACTIONS(223),
    [anon_sym_ATthrows] = ACTIONS(223),
    [anon_sym_ATvar] = ACTIONS(223),
    [anon_sym_ATdeprecated] = ACTIONS(223),
    [anon_sym_ATsince] = ACTIONS(223),
    [anon_sym_ATversion] = ACTIONS(223),
    [anon_sym_ATtemplate] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(223),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(223),
    [anon_sym_ATimplements] = ACTIONS(223),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(223),
    [anon_sym_ATextends] = ACTIONS(223),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(223),
    [anon_sym_ATuse] = ACTIONS(221),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(223),
    [anon_sym_ATafter] = ACTIONS(221),
    [anon_sym_ATafterClass] = ACTIONS(223),
    [anon_sym_ATannotation] = ACTIONS(223),
    [anon_sym_ATbackupGlobals] = ACTIONS(223),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(223),
    [anon_sym_ATbefore] = ACTIONS(221),
    [anon_sym_ATbeforeClass] = ACTIONS(223),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(221),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(223),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(223),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(223),
    [anon_sym_ATcovers] = ACTIONS(221),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(221),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(223),
    [anon_sym_ATcoversNothing] = ACTIONS(223),
    [anon_sym_ATdataProvider] = ACTIONS(223),
    [anon_sym_ATdepends] = ACTIONS(221),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(223),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(223),
    [anon_sym_ATgroup] = ACTIONS(223),
    [anon_sym_ATlarge] = ACTIONS(223),
    [anon_sym_ATmedium] = ACTIONS(223),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(223),
    [anon_sym_ATrequires] = ACTIONS(221),
    [anon_sym_ATrequiresusages] = ACTIONS(223),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(223),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(223),
    [anon_sym_ATsmall] = ACTIONS(223),
    [anon_sym_ATtest] = ACTIONS(221),
    [anon_sym_ATtestWith] = ACTIONS(223),
    [anon_sym_ATtestdox] = ACTIONS(223),
    [anon_sym_ATticket] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(221),
    [anon_sym_ATreadonly] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(223),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(223),
    [anon_sym_ATparam_DASHout] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(221),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(223),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(223),
    [anon_sym_ATmixin] = ACTIONS(223),
    [anon_sym_COLON_COLON] = ACTIONS(223),
    [sym__end] = ACTIONS(223),
    [sym_text] = ACTIONS(223),
  },
  [129] = {
    [anon_sym_LBRACE] = ACTIONS(219),
    [anon_sym_ATinheritdoc] = ACTIONS(219),
    [anon_sym_ATinheritDoc] = ACTIONS(219),
    [anon_sym_ATapi] = ACTIONS(219),
    [anon_sym_ATfilesource] = ACTIONS(219),
    [anon_sym_ATignore] = ACTIONS(219),
    [anon_sym_ATinternal] = ACTIONS(219),
    [anon_sym_ATcategory] = ACTIONS(219),
    [anon_sym_ATcopyright] = ACTIONS(219),
    [anon_sym_ATtodo] = ACTIONS(219),
    [anon_sym_ATexample] = ACTIONS(219),
    [anon_sym_ATlicense] = ACTIONS(219),
    [anon_sym_ATpackage] = ACTIONS(219),
    [anon_sym_ATsource] = ACTIONS(219),
    [anon_sym_ATsubpackage] = ACTIONS(219),
    [anon_sym_ATuses] = ACTIONS(219),
    [anon_sym_ATauthor] = ACTIONS(219),
    [anon_sym_ATglobal] = ACTIONS(219),
    [anon_sym_ATlink] = ACTIONS(219),
    [anon_sym_ATmethod] = ACTIONS(219),
    [anon_sym_ATparam] = ACTIONS(217),
    [anon_sym_ATproperty] = ACTIONS(217),
    [anon_sym_ATproperty_DASHread] = ACTIONS(219),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(219),
    [anon_sym_ATreturn] = ACTIONS(219),
    [anon_sym_ATsee] = ACTIONS(219),
    [anon_sym_ATthrows] = ACTIONS(219),
    [anon_sym_ATvar] = ACTIONS(219),
    [anon_sym_ATdeprecated] = ACTIONS(219),
    [anon_sym_ATsince] = ACTIONS(219),
    [anon_sym_ATversion] = ACTIONS(219),
    [anon_sym_ATtemplate] = ACTIONS(217),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(219),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(219),
    [anon_sym_ATimplements] = ACTIONS(219),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(219),
    [anon_sym_ATextends] = ACTIONS(219),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(219),
    [anon_sym_ATuse] = ACTIONS(217),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(219),
    [anon_sym_ATafter] = ACTIONS(217),
    [anon_sym_ATafterClass] = ACTIONS(219),
    [anon_sym_ATannotation] = ACTIONS(219),
    [anon_sym_ATbackupGlobals] = ACTIONS(219),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(219),
    [anon_sym_ATbefore] = ACTIONS(217),
    [anon_sym_ATbeforeClass] = ACTIONS(219),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(217),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(219),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(219),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(219),
    [anon_sym_ATcovers] = ACTIONS(217),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(217),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(219),
    [anon_sym_ATcoversNothing] = ACTIONS(219),
    [anon_sym_ATdataProvider] = ACTIONS(219),
    [anon_sym_ATdepends] = ACTIONS(217),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(219),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(219),
    [anon_sym_ATgroup] = ACTIONS(219),
    [anon_sym_ATlarge] = ACTIONS(219),
    [anon_sym_ATmedium] = ACTIONS(219),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(219),
    [anon_sym_ATrequires] = ACTIONS(217),
    [anon_sym_ATrequiresusages] = ACTIONS(219),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(219),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(219),
    [anon_sym_ATsmall] = ACTIONS(219),
    [anon_sym_ATtest] = ACTIONS(217),
    [anon_sym_ATtestWith] = ACTIONS(219),
    [anon_sym_ATtestdox] = ACTIONS(219),
    [anon_sym_ATticket] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(217),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(217),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(217),
    [anon_sym_ATreadonly] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(219),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(219),
    [anon_sym_ATparam_DASHout] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(217),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(219),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(219),
    [anon_sym_ATmixin] = ACTIONS(219),
    [anon_sym_COLON_COLON] = ACTIONS(219),
    [sym__end] = ACTIONS(219),
    [sym_text] = ACTIONS(219),
  },
  [130] = {
    [anon_sym_LBRACE] = ACTIONS(215),
    [anon_sym_ATinheritdoc] = ACTIONS(215),
    [anon_sym_ATinheritDoc] = ACTIONS(215),
    [anon_sym_ATapi] = ACTIONS(215),
    [anon_sym_ATfilesource] = ACTIONS(215),
    [anon_sym_ATignore] = ACTIONS(215),
    [anon_sym_ATinternal] = ACTIONS(215),
    [anon_sym_ATcategory] = ACTIONS(215),
    [anon_sym_ATcopyright] = ACTIONS(215),
    [anon_sym_ATtodo] = ACTIONS(215),
    [anon_sym_ATexample] = ACTIONS(215),
    [anon_sym_ATlicense] = ACTIONS(215),
    [anon_sym_ATpackage] = ACTIONS(215),
    [anon_sym_ATsource] = ACTIONS(215),
    [anon_sym_ATsubpackage] = ACTIONS(215),
    [anon_sym_ATuses] = ACTIONS(215),
    [anon_sym_ATauthor] = ACTIONS(215),
    [anon_sym_ATglobal] = ACTIONS(215),
    [anon_sym_ATlink] = ACTIONS(215),
    [anon_sym_ATmethod] = ACTIONS(215),
    [anon_sym_ATparam] = ACTIONS(213),
    [anon_sym_ATproperty] = ACTIONS(213),
    [anon_sym_ATproperty_DASHread] = ACTIONS(215),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(215),
    [anon_sym_ATreturn] = ACTIONS(215),
    [anon_sym_ATsee] = ACTIONS(215),
    [anon_sym_ATthrows] = ACTIONS(215),
    [anon_sym_ATvar] = ACTIONS(215),
    [anon_sym_ATdeprecated] = ACTIONS(215),
    [anon_sym_ATsince] = ACTIONS(215),
    [anon_sym_ATversion] = ACTIONS(215),
    [anon_sym_ATtemplate] = ACTIONS(213),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(215),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(215),
    [anon_sym_ATimplements] = ACTIONS(215),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(215),
    [anon_sym_ATextends] = ACTIONS(215),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(215),
    [anon_sym_ATuse] = ACTIONS(213),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(215),
    [anon_sym_ATafter] = ACTIONS(213),
    [anon_sym_ATafterClass] = ACTIONS(215),
    [anon_sym_ATannotation] = ACTIONS(215),
    [anon_sym_ATbackupGlobals] = ACTIONS(215),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(215),
    [anon_sym_ATbefore] = ACTIONS(213),
    [anon_sym_ATbeforeClass] = ACTIONS(215),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(213),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(215),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(215),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(215),
    [anon_sym_ATcovers] = ACTIONS(213),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(213),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(215),
    [anon_sym_ATcoversNothing] = ACTIONS(215),
    [anon_sym_ATdataProvider] = ACTIONS(215),
    [anon_sym_ATdepends] = ACTIONS(213),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(215),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(215),
    [anon_sym_ATgroup] = ACTIONS(215),
    [anon_sym_ATlarge] = ACTIONS(215),
    [anon_sym_ATmedium] = ACTIONS(215),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(215),
    [anon_sym_ATrequires] = ACTIONS(213),
    [anon_sym_ATrequiresusages] = ACTIONS(215),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(215),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(215),
    [anon_sym_ATsmall] = ACTIONS(215),
    [anon_sym_ATtest] = ACTIONS(213),
    [anon_sym_ATtestWith] = ACTIONS(215),
    [anon_sym_ATtestdox] = ACTIONS(215),
    [anon_sym_ATticket] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(213),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(213),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(213),
    [anon_sym_ATreadonly] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(215),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(215),
    [anon_sym_ATparam_DASHout] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(213),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(215),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(215),
    [anon_sym_ATmixin] = ACTIONS(215),
    [anon_sym_COLON_COLON] = ACTIONS(215),
    [sym__end] = ACTIONS(215),
    [sym_text] = ACTIONS(215),
  },
  [131] = {
    [anon_sym_ATinheritdoc] = ACTIONS(549),
    [anon_sym_ATinheritDoc] = ACTIONS(549),
    [anon_sym_ATapi] = ACTIONS(549),
    [anon_sym_ATfilesource] = ACTIONS(549),
    [anon_sym_ATignore] = ACTIONS(549),
    [anon_sym_ATinternal] = ACTIONS(549),
    [anon_sym_ATcategory] = ACTIONS(549),
    [anon_sym_ATcopyright] = ACTIONS(549),
    [anon_sym_ATtodo] = ACTIONS(549),
    [anon_sym_ATexample] = ACTIONS(549),
    [anon_sym_ATlicense] = ACTIONS(549),
    [anon_sym_ATpackage] = ACTIONS(549),
    [anon_sym_ATsource] = ACTIONS(549),
    [anon_sym_ATsubpackage] = ACTIONS(549),
    [anon_sym_ATuses] = ACTIONS(549),
    [anon_sym_ATauthor] = ACTIONS(549),
    [anon_sym_ATglobal] = ACTIONS(549),
    [anon_sym_ATlink] = ACTIONS(549),
    [anon_sym_ATmethod] = ACTIONS(549),
    [anon_sym_ATparam] = ACTIONS(551),
    [anon_sym_ATproperty] = ACTIONS(551),
    [anon_sym_ATproperty_DASHread] = ACTIONS(549),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(549),
    [anon_sym_ATreturn] = ACTIONS(549),
    [anon_sym_ATsee] = ACTIONS(549),
    [anon_sym_ATthrows] = ACTIONS(549),
    [anon_sym_ATvar] = ACTIONS(549),
    [anon_sym_ATdeprecated] = ACTIONS(549),
    [anon_sym_ATsince] = ACTIONS(549),
    [anon_sym_ATversion] = ACTIONS(549),
    [anon_sym_ATtemplate] = ACTIONS(551),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(549),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(549),
    [anon_sym_ATimplements] = ACTIONS(549),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(549),
    [anon_sym_ATextends] = ACTIONS(549),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(549),
    [anon_sym_ATuse] = ACTIONS(551),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(549),
    [anon_sym_ATafter] = ACTIONS(551),
    [anon_sym_ATafterClass] = ACTIONS(549),
    [anon_sym_ATannotation] = ACTIONS(549),
    [anon_sym_ATbackupGlobals] = ACTIONS(549),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(549),
    [anon_sym_ATbefore] = ACTIONS(551),
    [anon_sym_ATbeforeClass] = ACTIONS(549),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(551),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(549),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(549),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(549),
    [anon_sym_ATcovers] = ACTIONS(551),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(551),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(549),
    [anon_sym_ATcoversNothing] = ACTIONS(549),
    [anon_sym_ATdataProvider] = ACTIONS(549),
    [anon_sym_ATdepends] = ACTIONS(551),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(549),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(549),
    [anon_sym_ATgroup] = ACTIONS(549),
    [anon_sym_ATlarge] = ACTIONS(549),
    [anon_sym_ATmedium] = ACTIONS(549),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(549),
    [anon_sym_ATrequires] = ACTIONS(551),
    [anon_sym_ATrequiresusages] = ACTIONS(549),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(549),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(549),
    [anon_sym_ATsmall] = ACTIONS(549),
    [anon_sym_ATtest] = ACTIONS(551),
    [anon_sym_ATtestWith] = ACTIONS(549),
    [anon_sym_ATtestdox] = ACTIONS(549),
    [anon_sym_ATticket] = ACTIONS(549),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(549),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(549),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(549),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(551),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(549),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(551),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(549),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(549),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(549),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(549),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(549),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(549),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(549),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(549),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(549),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(551),
    [anon_sym_ATreadonly] = ACTIONS(549),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(549),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(549),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(549),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(549),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(549),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(549),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(549),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(549),
    [anon_sym_ATparam_DASHout] = ACTIONS(549),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(549),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(551),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(549),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(549),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(549),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(549),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(549),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(549),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(549),
    [anon_sym_ATmixin] = ACTIONS(549),
    [anon_sym_COMMA] = ACTIONS(549),
    [anon_sym_RPAREN] = ACTIONS(549),
    [anon_sym_EQ] = ACTIONS(549),
    [sym__end] = ACTIONS(549),
  },
  [132] = {
    [anon_sym_LBRACE] = ACTIONS(203),
    [anon_sym_ATinheritdoc] = ACTIONS(203),
    [anon_sym_ATinheritDoc] = ACTIONS(203),
    [anon_sym_ATapi] = ACTIONS(203),
    [anon_sym_ATfilesource] = ACTIONS(203),
    [anon_sym_ATignore] = ACTIONS(203),
    [anon_sym_ATinternal] = ACTIONS(203),
    [anon_sym_ATcategory] = ACTIONS(203),
    [anon_sym_ATcopyright] = ACTIONS(203),
    [anon_sym_ATtodo] = ACTIONS(203),
    [anon_sym_ATexample] = ACTIONS(203),
    [anon_sym_ATlicense] = ACTIONS(203),
    [anon_sym_ATpackage] = ACTIONS(203),
    [anon_sym_ATsource] = ACTIONS(203),
    [anon_sym_ATsubpackage] = ACTIONS(203),
    [anon_sym_ATuses] = ACTIONS(203),
    [anon_sym_ATauthor] = ACTIONS(203),
    [anon_sym_ATglobal] = ACTIONS(203),
    [anon_sym_ATlink] = ACTIONS(203),
    [anon_sym_ATmethod] = ACTIONS(203),
    [anon_sym_ATparam] = ACTIONS(201),
    [anon_sym_ATproperty] = ACTIONS(201),
    [anon_sym_ATproperty_DASHread] = ACTIONS(203),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(203),
    [anon_sym_ATreturn] = ACTIONS(203),
    [anon_sym_ATsee] = ACTIONS(203),
    [anon_sym_ATthrows] = ACTIONS(203),
    [anon_sym_ATvar] = ACTIONS(203),
    [anon_sym_ATdeprecated] = ACTIONS(203),
    [anon_sym_ATsince] = ACTIONS(203),
    [anon_sym_ATversion] = ACTIONS(203),
    [anon_sym_ATtemplate] = ACTIONS(201),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(203),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(203),
    [anon_sym_ATimplements] = ACTIONS(203),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(203),
    [anon_sym_ATextends] = ACTIONS(203),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(203),
    [anon_sym_ATuse] = ACTIONS(201),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(203),
    [anon_sym_ATafter] = ACTIONS(201),
    [anon_sym_ATafterClass] = ACTIONS(203),
    [anon_sym_ATannotation] = ACTIONS(203),
    [anon_sym_ATbackupGlobals] = ACTIONS(203),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(203),
    [anon_sym_ATbefore] = ACTIONS(201),
    [anon_sym_ATbeforeClass] = ACTIONS(203),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(201),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(203),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(203),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(203),
    [anon_sym_ATcovers] = ACTIONS(201),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(201),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(203),
    [anon_sym_ATcoversNothing] = ACTIONS(203),
    [anon_sym_ATdataProvider] = ACTIONS(203),
    [anon_sym_ATdepends] = ACTIONS(201),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(203),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(203),
    [anon_sym_ATgroup] = ACTIONS(203),
    [anon_sym_ATlarge] = ACTIONS(203),
    [anon_sym_ATmedium] = ACTIONS(203),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(203),
    [anon_sym_ATrequires] = ACTIONS(201),
    [anon_sym_ATrequiresusages] = ACTIONS(203),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(203),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(203),
    [anon_sym_ATsmall] = ACTIONS(203),
    [anon_sym_ATtest] = ACTIONS(201),
    [anon_sym_ATtestWith] = ACTIONS(203),
    [anon_sym_ATtestdox] = ACTIONS(203),
    [anon_sym_ATticket] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(201),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(201),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(201),
    [anon_sym_ATreadonly] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(203),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(203),
    [anon_sym_ATparam_DASHout] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(201),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(203),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(203),
    [anon_sym_ATmixin] = ACTIONS(203),
    [anon_sym_COLON_COLON] = ACTIONS(203),
    [sym__end] = ACTIONS(203),
    [sym_text] = ACTIONS(203),
  },
  [133] = {
    [anon_sym_LBRACE] = ACTIONS(199),
    [anon_sym_ATinheritdoc] = ACTIONS(199),
    [anon_sym_ATinheritDoc] = ACTIONS(199),
    [anon_sym_ATapi] = ACTIONS(199),
    [anon_sym_ATfilesource] = ACTIONS(199),
    [anon_sym_ATignore] = ACTIONS(199),
    [anon_sym_ATinternal] = ACTIONS(199),
    [anon_sym_ATcategory] = ACTIONS(199),
    [anon_sym_ATcopyright] = ACTIONS(199),
    [anon_sym_ATtodo] = ACTIONS(199),
    [anon_sym_ATexample] = ACTIONS(199),
    [anon_sym_ATlicense] = ACTIONS(199),
    [anon_sym_ATpackage] = ACTIONS(199),
    [anon_sym_ATsource] = ACTIONS(199),
    [anon_sym_ATsubpackage] = ACTIONS(199),
    [anon_sym_ATuses] = ACTIONS(199),
    [anon_sym_ATauthor] = ACTIONS(199),
    [anon_sym_ATglobal] = ACTIONS(199),
    [anon_sym_ATlink] = ACTIONS(199),
    [anon_sym_ATmethod] = ACTIONS(199),
    [anon_sym_ATparam] = ACTIONS(197),
    [anon_sym_ATproperty] = ACTIONS(197),
    [anon_sym_ATproperty_DASHread] = ACTIONS(199),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(199),
    [anon_sym_ATreturn] = ACTIONS(199),
    [anon_sym_ATsee] = ACTIONS(199),
    [anon_sym_ATthrows] = ACTIONS(199),
    [anon_sym_ATvar] = ACTIONS(199),
    [anon_sym_ATdeprecated] = ACTIONS(199),
    [anon_sym_ATsince] = ACTIONS(199),
    [anon_sym_ATversion] = ACTIONS(199),
    [anon_sym_ATtemplate] = ACTIONS(197),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(199),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(199),
    [anon_sym_ATimplements] = ACTIONS(199),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(199),
    [anon_sym_ATextends] = ACTIONS(199),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(199),
    [anon_sym_ATuse] = ACTIONS(197),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(199),
    [anon_sym_ATafter] = ACTIONS(197),
    [anon_sym_ATafterClass] = ACTIONS(199),
    [anon_sym_ATannotation] = ACTIONS(199),
    [anon_sym_ATbackupGlobals] = ACTIONS(199),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(199),
    [anon_sym_ATbefore] = ACTIONS(197),
    [anon_sym_ATbeforeClass] = ACTIONS(199),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(197),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(199),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(199),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(199),
    [anon_sym_ATcovers] = ACTIONS(197),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(197),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(199),
    [anon_sym_ATcoversNothing] = ACTIONS(199),
    [anon_sym_ATdataProvider] = ACTIONS(199),
    [anon_sym_ATdepends] = ACTIONS(197),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(199),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(199),
    [anon_sym_ATgroup] = ACTIONS(199),
    [anon_sym_ATlarge] = ACTIONS(199),
    [anon_sym_ATmedium] = ACTIONS(199),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(199),
    [anon_sym_ATrequires] = ACTIONS(197),
    [anon_sym_ATrequiresusages] = ACTIONS(199),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(199),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(199),
    [anon_sym_ATsmall] = ACTIONS(199),
    [anon_sym_ATtest] = ACTIONS(197),
    [anon_sym_ATtestWith] = ACTIONS(199),
    [anon_sym_ATtestdox] = ACTIONS(199),
    [anon_sym_ATticket] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(197),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(197),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(197),
    [anon_sym_ATreadonly] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(199),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(199),
    [anon_sym_ATparam_DASHout] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(197),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(199),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(199),
    [anon_sym_ATmixin] = ACTIONS(199),
    [anon_sym_COLON_COLON] = ACTIONS(199),
    [sym__end] = ACTIONS(199),
    [sym_text] = ACTIONS(199),
  },
  [134] = {
    [anon_sym_LBRACE] = ACTIONS(553),
    [anon_sym_ATinheritdoc] = ACTIONS(553),
    [anon_sym_ATinheritDoc] = ACTIONS(553),
    [anon_sym_ATapi] = ACTIONS(553),
    [anon_sym_ATfilesource] = ACTIONS(553),
    [anon_sym_ATignore] = ACTIONS(553),
    [anon_sym_ATinternal] = ACTIONS(553),
    [anon_sym_ATcategory] = ACTIONS(553),
    [anon_sym_ATcopyright] = ACTIONS(553),
    [anon_sym_ATtodo] = ACTIONS(553),
    [anon_sym_ATexample] = ACTIONS(553),
    [anon_sym_ATlicense] = ACTIONS(553),
    [anon_sym_ATpackage] = ACTIONS(553),
    [anon_sym_ATsource] = ACTIONS(553),
    [anon_sym_ATsubpackage] = ACTIONS(553),
    [anon_sym_ATuses] = ACTIONS(553),
    [anon_sym_ATauthor] = ACTIONS(553),
    [anon_sym_ATglobal] = ACTIONS(553),
    [anon_sym_ATlink] = ACTIONS(553),
    [anon_sym_ATmethod] = ACTIONS(553),
    [anon_sym_ATparam] = ACTIONS(555),
    [anon_sym_ATproperty] = ACTIONS(555),
    [anon_sym_ATproperty_DASHread] = ACTIONS(553),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(553),
    [anon_sym_ATreturn] = ACTIONS(553),
    [anon_sym_ATsee] = ACTIONS(553),
    [anon_sym_ATthrows] = ACTIONS(553),
    [anon_sym_ATvar] = ACTIONS(553),
    [anon_sym_ATdeprecated] = ACTIONS(553),
    [anon_sym_ATsince] = ACTIONS(553),
    [anon_sym_ATversion] = ACTIONS(553),
    [anon_sym_ATtemplate] = ACTIONS(555),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(553),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(553),
    [anon_sym_ATimplements] = ACTIONS(553),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(553),
    [anon_sym_ATextends] = ACTIONS(553),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(553),
    [anon_sym_ATuse] = ACTIONS(555),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(553),
    [anon_sym_ATafter] = ACTIONS(555),
    [anon_sym_ATafterClass] = ACTIONS(553),
    [anon_sym_ATannotation] = ACTIONS(553),
    [anon_sym_ATbackupGlobals] = ACTIONS(553),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(553),
    [anon_sym_ATbefore] = ACTIONS(555),
    [anon_sym_ATbeforeClass] = ACTIONS(553),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(555),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(553),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(553),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(553),
    [anon_sym_ATcovers] = ACTIONS(555),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(555),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(553),
    [anon_sym_ATcoversNothing] = ACTIONS(553),
    [anon_sym_ATdataProvider] = ACTIONS(553),
    [anon_sym_ATdepends] = ACTIONS(555),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(553),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(553),
    [anon_sym_ATgroup] = ACTIONS(553),
    [anon_sym_ATlarge] = ACTIONS(553),
    [anon_sym_ATmedium] = ACTIONS(553),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(553),
    [anon_sym_ATrequires] = ACTIONS(555),
    [anon_sym_ATrequiresusages] = ACTIONS(553),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(553),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(553),
    [anon_sym_ATsmall] = ACTIONS(553),
    [anon_sym_ATtest] = ACTIONS(555),
    [anon_sym_ATtestWith] = ACTIONS(553),
    [anon_sym_ATtestdox] = ACTIONS(553),
    [anon_sym_ATticket] = ACTIONS(553),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(553),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(553),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(553),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(555),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(553),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(555),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(553),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(553),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(553),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(553),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(553),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(553),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(553),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(553),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(553),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(555),
    [anon_sym_ATreadonly] = ACTIONS(553),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(553),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(553),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(553),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(553),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(553),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(553),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(553),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(553),
    [anon_sym_ATparam_DASHout] = ACTIONS(553),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(553),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(555),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(553),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(553),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(553),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(553),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(553),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(553),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(553),
    [anon_sym_ATmixin] = ACTIONS(553),
    [anon_sym_COLON_COLON] = ACTIONS(557),
    [sym__end] = ACTIONS(553),
    [sym_text] = ACTIONS(553),
  },
  [135] = {
    [anon_sym_LBRACE] = ACTIONS(559),
    [anon_sym_ATinheritdoc] = ACTIONS(559),
    [anon_sym_ATinheritDoc] = ACTIONS(559),
    [anon_sym_ATapi] = ACTIONS(559),
    [anon_sym_ATfilesource] = ACTIONS(559),
    [anon_sym_ATignore] = ACTIONS(559),
    [anon_sym_ATinternal] = ACTIONS(559),
    [anon_sym_ATcategory] = ACTIONS(559),
    [anon_sym_ATcopyright] = ACTIONS(559),
    [anon_sym_ATtodo] = ACTIONS(559),
    [anon_sym_ATexample] = ACTIONS(559),
    [anon_sym_ATlicense] = ACTIONS(559),
    [anon_sym_ATpackage] = ACTIONS(559),
    [anon_sym_ATsource] = ACTIONS(559),
    [anon_sym_ATsubpackage] = ACTIONS(559),
    [anon_sym_ATuses] = ACTIONS(559),
    [anon_sym_ATauthor] = ACTIONS(559),
    [anon_sym_ATglobal] = ACTIONS(559),
    [anon_sym_ATlink] = ACTIONS(559),
    [anon_sym_ATmethod] = ACTIONS(559),
    [anon_sym_ATparam] = ACTIONS(561),
    [anon_sym_ATproperty] = ACTIONS(561),
    [anon_sym_ATproperty_DASHread] = ACTIONS(559),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(559),
    [anon_sym_ATreturn] = ACTIONS(559),
    [anon_sym_ATsee] = ACTIONS(559),
    [anon_sym_ATthrows] = ACTIONS(559),
    [anon_sym_ATvar] = ACTIONS(559),
    [anon_sym_ATdeprecated] = ACTIONS(559),
    [anon_sym_ATsince] = ACTIONS(559),
    [anon_sym_ATversion] = ACTIONS(559),
    [anon_sym_ATtemplate] = ACTIONS(561),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(559),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(559),
    [anon_sym_ATimplements] = ACTIONS(559),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(559),
    [anon_sym_ATextends] = ACTIONS(559),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(559),
    [anon_sym_ATuse] = ACTIONS(561),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(559),
    [anon_sym_ATafter] = ACTIONS(561),
    [anon_sym_ATafterClass] = ACTIONS(559),
    [anon_sym_ATannotation] = ACTIONS(559),
    [anon_sym_ATbackupGlobals] = ACTIONS(559),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(559),
    [anon_sym_ATbefore] = ACTIONS(561),
    [anon_sym_ATbeforeClass] = ACTIONS(559),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(561),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(559),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(559),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(559),
    [anon_sym_ATcovers] = ACTIONS(561),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(561),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(559),
    [anon_sym_ATcoversNothing] = ACTIONS(559),
    [anon_sym_ATdataProvider] = ACTIONS(559),
    [anon_sym_ATdepends] = ACTIONS(561),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(559),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(559),
    [anon_sym_ATgroup] = ACTIONS(559),
    [anon_sym_ATlarge] = ACTIONS(559),
    [anon_sym_ATmedium] = ACTIONS(559),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(559),
    [anon_sym_ATrequires] = ACTIONS(561),
    [anon_sym_ATrequiresusages] = ACTIONS(559),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(559),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(559),
    [anon_sym_ATsmall] = ACTIONS(559),
    [anon_sym_ATtest] = ACTIONS(561),
    [anon_sym_ATtestWith] = ACTIONS(559),
    [anon_sym_ATtestdox] = ACTIONS(559),
    [anon_sym_ATticket] = ACTIONS(559),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(559),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(559),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(559),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(561),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(559),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(561),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(559),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(559),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(559),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(559),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(559),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(559),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(559),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(559),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(559),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(561),
    [anon_sym_ATreadonly] = ACTIONS(559),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(559),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(559),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(559),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(559),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(559),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(559),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(559),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(559),
    [anon_sym_ATparam_DASHout] = ACTIONS(559),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(559),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(561),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(559),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(559),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(559),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(559),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(559),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(559),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(559),
    [anon_sym_ATmixin] = ACTIONS(559),
    [sym__end] = ACTIONS(559),
    [sym__text_not_version] = ACTIONS(559),
  },
  [136] = {
    [anon_sym_LBRACE] = ACTIONS(563),
    [anon_sym_ATinheritdoc] = ACTIONS(563),
    [anon_sym_ATinheritDoc] = ACTIONS(563),
    [anon_sym_ATapi] = ACTIONS(563),
    [anon_sym_ATfilesource] = ACTIONS(563),
    [anon_sym_ATignore] = ACTIONS(563),
    [anon_sym_ATinternal] = ACTIONS(563),
    [anon_sym_ATcategory] = ACTIONS(563),
    [anon_sym_ATcopyright] = ACTIONS(563),
    [anon_sym_ATtodo] = ACTIONS(563),
    [anon_sym_ATexample] = ACTIONS(563),
    [anon_sym_ATlicense] = ACTIONS(563),
    [anon_sym_ATpackage] = ACTIONS(563),
    [anon_sym_ATsource] = ACTIONS(563),
    [anon_sym_ATsubpackage] = ACTIONS(563),
    [anon_sym_ATuses] = ACTIONS(563),
    [anon_sym_ATauthor] = ACTIONS(563),
    [anon_sym_ATglobal] = ACTIONS(563),
    [anon_sym_ATlink] = ACTIONS(563),
    [anon_sym_ATmethod] = ACTIONS(563),
    [anon_sym_ATparam] = ACTIONS(565),
    [anon_sym_ATproperty] = ACTIONS(565),
    [anon_sym_ATproperty_DASHread] = ACTIONS(563),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(563),
    [anon_sym_ATreturn] = ACTIONS(563),
    [anon_sym_ATsee] = ACTIONS(563),
    [anon_sym_ATthrows] = ACTIONS(563),
    [anon_sym_ATvar] = ACTIONS(563),
    [anon_sym_ATdeprecated] = ACTIONS(563),
    [anon_sym_ATsince] = ACTIONS(563),
    [anon_sym_ATversion] = ACTIONS(563),
    [anon_sym_ATtemplate] = ACTIONS(565),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(563),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(563),
    [anon_sym_ATimplements] = ACTIONS(563),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(563),
    [anon_sym_ATextends] = ACTIONS(563),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(563),
    [anon_sym_ATuse] = ACTIONS(565),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(563),
    [anon_sym_ATafter] = ACTIONS(565),
    [anon_sym_ATafterClass] = ACTIONS(563),
    [anon_sym_ATannotation] = ACTIONS(563),
    [anon_sym_ATbackupGlobals] = ACTIONS(563),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(563),
    [anon_sym_ATbefore] = ACTIONS(565),
    [anon_sym_ATbeforeClass] = ACTIONS(563),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(565),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(563),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(563),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(563),
    [anon_sym_ATcovers] = ACTIONS(565),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(565),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(563),
    [anon_sym_ATcoversNothing] = ACTIONS(563),
    [anon_sym_ATdataProvider] = ACTIONS(563),
    [anon_sym_ATdepends] = ACTIONS(565),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(563),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(563),
    [anon_sym_ATgroup] = ACTIONS(563),
    [anon_sym_ATlarge] = ACTIONS(563),
    [anon_sym_ATmedium] = ACTIONS(563),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(563),
    [anon_sym_ATrequires] = ACTIONS(565),
    [anon_sym_ATrequiresusages] = ACTIONS(563),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(563),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(563),
    [anon_sym_ATsmall] = ACTIONS(563),
    [anon_sym_ATtest] = ACTIONS(565),
    [anon_sym_ATtestWith] = ACTIONS(563),
    [anon_sym_ATtestdox] = ACTIONS(563),
    [anon_sym_ATticket] = ACTIONS(563),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(563),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(563),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(563),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(565),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(563),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(565),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(563),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(563),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(563),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(563),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(563),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(563),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(563),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(563),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(563),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(565),
    [anon_sym_ATreadonly] = ACTIONS(563),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(563),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(563),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(563),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(563),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(563),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(563),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(563),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(563),
    [anon_sym_ATparam_DASHout] = ACTIONS(563),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(563),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(565),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(563),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(563),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(563),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(563),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(563),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(563),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(563),
    [anon_sym_ATmixin] = ACTIONS(563),
    [sym__end] = ACTIONS(563),
    [sym_text] = ACTIONS(563),
  },
  [137] = {
    [anon_sym_LBRACE] = ACTIONS(567),
    [anon_sym_ATinheritdoc] = ACTIONS(567),
    [anon_sym_ATinheritDoc] = ACTIONS(567),
    [anon_sym_ATapi] = ACTIONS(567),
    [anon_sym_ATfilesource] = ACTIONS(567),
    [anon_sym_ATignore] = ACTIONS(567),
    [anon_sym_ATinternal] = ACTIONS(567),
    [anon_sym_ATcategory] = ACTIONS(567),
    [anon_sym_ATcopyright] = ACTIONS(567),
    [anon_sym_ATtodo] = ACTIONS(567),
    [anon_sym_ATexample] = ACTIONS(567),
    [anon_sym_ATlicense] = ACTIONS(567),
    [anon_sym_ATpackage] = ACTIONS(567),
    [anon_sym_ATsource] = ACTIONS(567),
    [anon_sym_ATsubpackage] = ACTIONS(567),
    [anon_sym_ATuses] = ACTIONS(567),
    [anon_sym_ATauthor] = ACTIONS(567),
    [anon_sym_ATglobal] = ACTIONS(567),
    [anon_sym_ATlink] = ACTIONS(567),
    [anon_sym_ATmethod] = ACTIONS(567),
    [anon_sym_ATparam] = ACTIONS(569),
    [anon_sym_ATproperty] = ACTIONS(569),
    [anon_sym_ATproperty_DASHread] = ACTIONS(567),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(567),
    [anon_sym_ATreturn] = ACTIONS(567),
    [anon_sym_ATsee] = ACTIONS(567),
    [anon_sym_ATthrows] = ACTIONS(567),
    [anon_sym_ATvar] = ACTIONS(567),
    [anon_sym_ATdeprecated] = ACTIONS(567),
    [anon_sym_ATsince] = ACTIONS(567),
    [anon_sym_ATversion] = ACTIONS(567),
    [anon_sym_ATtemplate] = ACTIONS(569),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(567),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(567),
    [anon_sym_ATimplements] = ACTIONS(567),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(567),
    [anon_sym_ATextends] = ACTIONS(567),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(567),
    [anon_sym_ATuse] = ACTIONS(569),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(567),
    [anon_sym_ATafter] = ACTIONS(569),
    [anon_sym_ATafterClass] = ACTIONS(567),
    [anon_sym_ATannotation] = ACTIONS(567),
    [anon_sym_ATbackupGlobals] = ACTIONS(567),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(567),
    [anon_sym_ATbefore] = ACTIONS(569),
    [anon_sym_ATbeforeClass] = ACTIONS(567),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(569),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(567),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(567),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(567),
    [anon_sym_ATcovers] = ACTIONS(569),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(569),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(567),
    [anon_sym_ATcoversNothing] = ACTIONS(567),
    [anon_sym_ATdataProvider] = ACTIONS(567),
    [anon_sym_ATdepends] = ACTIONS(569),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(567),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(567),
    [anon_sym_ATgroup] = ACTIONS(567),
    [anon_sym_ATlarge] = ACTIONS(567),
    [anon_sym_ATmedium] = ACTIONS(567),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(567),
    [anon_sym_ATrequires] = ACTIONS(569),
    [anon_sym_ATrequiresusages] = ACTIONS(567),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(567),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(567),
    [anon_sym_ATsmall] = ACTIONS(567),
    [anon_sym_ATtest] = ACTIONS(569),
    [anon_sym_ATtestWith] = ACTIONS(567),
    [anon_sym_ATtestdox] = ACTIONS(567),
    [anon_sym_ATticket] = ACTIONS(567),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(567),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(567),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(567),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(569),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(567),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(569),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(567),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(567),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(567),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(567),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(567),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(567),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(567),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(567),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(567),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(569),
    [anon_sym_ATreadonly] = ACTIONS(567),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(567),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(567),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(567),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(567),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(567),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(567),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(567),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(567),
    [anon_sym_ATparam_DASHout] = ACTIONS(567),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(567),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(569),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(567),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(567),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(567),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(567),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(567),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(567),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(567),
    [anon_sym_ATmixin] = ACTIONS(567),
    [sym__end] = ACTIONS(567),
    [sym_text] = ACTIONS(567),
  },
  [138] = {
    [anon_sym_LBRACE] = ACTIONS(571),
    [anon_sym_ATinheritdoc] = ACTIONS(571),
    [anon_sym_ATinheritDoc] = ACTIONS(571),
    [anon_sym_ATapi] = ACTIONS(571),
    [anon_sym_ATfilesource] = ACTIONS(571),
    [anon_sym_ATignore] = ACTIONS(571),
    [anon_sym_ATinternal] = ACTIONS(571),
    [anon_sym_ATcategory] = ACTIONS(571),
    [anon_sym_ATcopyright] = ACTIONS(571),
    [anon_sym_ATtodo] = ACTIONS(571),
    [anon_sym_ATexample] = ACTIONS(571),
    [anon_sym_ATlicense] = ACTIONS(571),
    [anon_sym_ATpackage] = ACTIONS(571),
    [anon_sym_ATsource] = ACTIONS(571),
    [anon_sym_ATsubpackage] = ACTIONS(571),
    [anon_sym_ATuses] = ACTIONS(571),
    [anon_sym_ATauthor] = ACTIONS(571),
    [anon_sym_ATglobal] = ACTIONS(571),
    [anon_sym_ATlink] = ACTIONS(571),
    [anon_sym_ATmethod] = ACTIONS(571),
    [anon_sym_ATparam] = ACTIONS(573),
    [anon_sym_ATproperty] = ACTIONS(573),
    [anon_sym_ATproperty_DASHread] = ACTIONS(571),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(571),
    [anon_sym_ATreturn] = ACTIONS(571),
    [anon_sym_ATsee] = ACTIONS(571),
    [anon_sym_ATthrows] = ACTIONS(571),
    [anon_sym_ATvar] = ACTIONS(571),
    [anon_sym_ATdeprecated] = ACTIONS(571),
    [anon_sym_ATsince] = ACTIONS(571),
    [anon_sym_ATversion] = ACTIONS(571),
    [anon_sym_ATtemplate] = ACTIONS(573),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(571),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(571),
    [anon_sym_ATimplements] = ACTIONS(571),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(571),
    [anon_sym_ATextends] = ACTIONS(571),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(571),
    [anon_sym_ATuse] = ACTIONS(573),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(571),
    [anon_sym_ATafter] = ACTIONS(573),
    [anon_sym_ATafterClass] = ACTIONS(571),
    [anon_sym_ATannotation] = ACTIONS(571),
    [anon_sym_ATbackupGlobals] = ACTIONS(571),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(571),
    [anon_sym_ATbefore] = ACTIONS(573),
    [anon_sym_ATbeforeClass] = ACTIONS(571),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(573),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(571),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(571),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(571),
    [anon_sym_ATcovers] = ACTIONS(573),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(573),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(571),
    [anon_sym_ATcoversNothing] = ACTIONS(571),
    [anon_sym_ATdataProvider] = ACTIONS(571),
    [anon_sym_ATdepends] = ACTIONS(573),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(571),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(571),
    [anon_sym_ATgroup] = ACTIONS(571),
    [anon_sym_ATlarge] = ACTIONS(571),
    [anon_sym_ATmedium] = ACTIONS(571),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(571),
    [anon_sym_ATrequires] = ACTIONS(573),
    [anon_sym_ATrequiresusages] = ACTIONS(571),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(571),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(571),
    [anon_sym_ATsmall] = ACTIONS(571),
    [anon_sym_ATtest] = ACTIONS(573),
    [anon_sym_ATtestWith] = ACTIONS(571),
    [anon_sym_ATtestdox] = ACTIONS(571),
    [anon_sym_ATticket] = ACTIONS(571),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(571),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(571),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(571),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(573),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(571),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(573),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(571),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(571),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(571),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(571),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(571),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(571),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(571),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(571),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(571),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(573),
    [anon_sym_ATreadonly] = ACTIONS(571),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(571),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(571),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(571),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(571),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(571),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(571),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(571),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(571),
    [anon_sym_ATparam_DASHout] = ACTIONS(571),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(571),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(573),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(571),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(571),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(571),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(571),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(571),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(571),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(571),
    [anon_sym_ATmixin] = ACTIONS(571),
    [sym__end] = ACTIONS(571),
    [sym_text] = ACTIONS(571),
  },
  [139] = {
    [anon_sym_LBRACE] = ACTIONS(575),
    [anon_sym_ATinheritdoc] = ACTIONS(575),
    [anon_sym_ATinheritDoc] = ACTIONS(575),
    [anon_sym_ATapi] = ACTIONS(575),
    [anon_sym_ATfilesource] = ACTIONS(575),
    [anon_sym_ATignore] = ACTIONS(575),
    [anon_sym_ATinternal] = ACTIONS(575),
    [anon_sym_ATcategory] = ACTIONS(575),
    [anon_sym_ATcopyright] = ACTIONS(575),
    [anon_sym_ATtodo] = ACTIONS(575),
    [anon_sym_ATexample] = ACTIONS(575),
    [anon_sym_ATlicense] = ACTIONS(575),
    [anon_sym_ATpackage] = ACTIONS(575),
    [anon_sym_ATsource] = ACTIONS(575),
    [anon_sym_ATsubpackage] = ACTIONS(575),
    [anon_sym_ATuses] = ACTIONS(575),
    [anon_sym_ATauthor] = ACTIONS(575),
    [anon_sym_ATglobal] = ACTIONS(575),
    [anon_sym_ATlink] = ACTIONS(575),
    [anon_sym_ATmethod] = ACTIONS(575),
    [anon_sym_ATparam] = ACTIONS(577),
    [anon_sym_ATproperty] = ACTIONS(577),
    [anon_sym_ATproperty_DASHread] = ACTIONS(575),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(575),
    [anon_sym_ATreturn] = ACTIONS(575),
    [anon_sym_ATsee] = ACTIONS(575),
    [anon_sym_ATthrows] = ACTIONS(575),
    [anon_sym_ATvar] = ACTIONS(575),
    [anon_sym_ATdeprecated] = ACTIONS(575),
    [anon_sym_ATsince] = ACTIONS(575),
    [anon_sym_ATversion] = ACTIONS(575),
    [anon_sym_ATtemplate] = ACTIONS(577),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(575),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(575),
    [anon_sym_ATimplements] = ACTIONS(575),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(575),
    [anon_sym_ATextends] = ACTIONS(575),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(575),
    [anon_sym_ATuse] = ACTIONS(577),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(575),
    [anon_sym_ATafter] = ACTIONS(577),
    [anon_sym_ATafterClass] = ACTIONS(575),
    [anon_sym_ATannotation] = ACTIONS(575),
    [anon_sym_ATbackupGlobals] = ACTIONS(575),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(575),
    [anon_sym_ATbefore] = ACTIONS(577),
    [anon_sym_ATbeforeClass] = ACTIONS(575),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(577),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(575),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(575),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(575),
    [anon_sym_ATcovers] = ACTIONS(577),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(577),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(575),
    [anon_sym_ATcoversNothing] = ACTIONS(575),
    [anon_sym_ATdataProvider] = ACTIONS(575),
    [anon_sym_ATdepends] = ACTIONS(577),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(575),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(575),
    [anon_sym_ATgroup] = ACTIONS(575),
    [anon_sym_ATlarge] = ACTIONS(575),
    [anon_sym_ATmedium] = ACTIONS(575),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(575),
    [anon_sym_ATrequires] = ACTIONS(577),
    [anon_sym_ATrequiresusages] = ACTIONS(575),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(575),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(575),
    [anon_sym_ATsmall] = ACTIONS(575),
    [anon_sym_ATtest] = ACTIONS(577),
    [anon_sym_ATtestWith] = ACTIONS(575),
    [anon_sym_ATtestdox] = ACTIONS(575),
    [anon_sym_ATticket] = ACTIONS(575),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(575),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(575),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(575),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(577),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(575),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(577),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(575),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(575),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(575),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(575),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(575),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(575),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(575),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(575),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(575),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(577),
    [anon_sym_ATreadonly] = ACTIONS(575),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(575),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(575),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(575),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(575),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(575),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(575),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(575),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(575),
    [anon_sym_ATparam_DASHout] = ACTIONS(575),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(575),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(577),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(575),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(575),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(575),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(575),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(575),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(575),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(575),
    [anon_sym_ATmixin] = ACTIONS(575),
    [sym__end] = ACTIONS(575),
    [sym__text_after_type] = ACTIONS(575),
  },
  [140] = {
    [anon_sym_LBRACE] = ACTIONS(579),
    [anon_sym_ATinheritdoc] = ACTIONS(579),
    [anon_sym_ATinheritDoc] = ACTIONS(579),
    [anon_sym_ATapi] = ACTIONS(579),
    [anon_sym_ATfilesource] = ACTIONS(579),
    [anon_sym_ATignore] = ACTIONS(579),
    [anon_sym_ATinternal] = ACTIONS(579),
    [anon_sym_ATcategory] = ACTIONS(579),
    [anon_sym_ATcopyright] = ACTIONS(579),
    [anon_sym_ATtodo] = ACTIONS(579),
    [anon_sym_ATexample] = ACTIONS(579),
    [anon_sym_ATlicense] = ACTIONS(579),
    [anon_sym_ATpackage] = ACTIONS(579),
    [anon_sym_ATsource] = ACTIONS(579),
    [anon_sym_ATsubpackage] = ACTIONS(579),
    [anon_sym_ATuses] = ACTIONS(579),
    [anon_sym_ATauthor] = ACTIONS(579),
    [anon_sym_ATglobal] = ACTIONS(579),
    [anon_sym_ATlink] = ACTIONS(579),
    [anon_sym_ATmethod] = ACTIONS(579),
    [anon_sym_ATparam] = ACTIONS(581),
    [anon_sym_ATproperty] = ACTIONS(581),
    [anon_sym_ATproperty_DASHread] = ACTIONS(579),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(579),
    [anon_sym_ATreturn] = ACTIONS(579),
    [anon_sym_ATsee] = ACTIONS(579),
    [anon_sym_ATthrows] = ACTIONS(579),
    [anon_sym_ATvar] = ACTIONS(579),
    [anon_sym_ATdeprecated] = ACTIONS(579),
    [anon_sym_ATsince] = ACTIONS(579),
    [anon_sym_ATversion] = ACTIONS(579),
    [anon_sym_ATtemplate] = ACTIONS(581),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(579),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(579),
    [anon_sym_ATimplements] = ACTIONS(579),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(579),
    [anon_sym_ATextends] = ACTIONS(579),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(579),
    [anon_sym_ATuse] = ACTIONS(581),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(579),
    [anon_sym_ATafter] = ACTIONS(581),
    [anon_sym_ATafterClass] = ACTIONS(579),
    [anon_sym_ATannotation] = ACTIONS(579),
    [anon_sym_ATbackupGlobals] = ACTIONS(579),
    [anon_sym_ATbackupStaticAttributes] = ACTIONS(579),
    [anon_sym_ATbefore] = ACTIONS(581),
    [anon_sym_ATbeforeClass] = ACTIONS(579),
    [anon_sym_ATcodeCoverageIgnore] = ACTIONS(581),
    [anon_sym_ATcodeCoverageIgnore_STAR] = ACTIONS(579),
    [anon_sym_ATcodeCoverageIgnoreEnd] = ACTIONS(579),
    [anon_sym_ATcodeCoverageIgnoreStart] = ACTIONS(579),
    [anon_sym_ATcovers] = ACTIONS(581),
    [anon_sym_ATcoversDefaultClass] = ACTIONS(581),
    [anon_sym_ATcoversDefaultClasstoshortenannotations] = ACTIONS(579),
    [anon_sym_ATcoversNothing] = ACTIONS(579),
    [anon_sym_ATdataProvider] = ACTIONS(579),
    [anon_sym_ATdepends] = ACTIONS(581),
    [anon_sym_ATdependsannotationtoexpressdependencies] = ACTIONS(579),
    [anon_sym_ATdoesNotPerformAssertions] = ACTIONS(579),
    [anon_sym_ATgroup] = ACTIONS(579),
    [anon_sym_ATlarge] = ACTIONS(579),
    [anon_sym_ATmedium] = ACTIONS(579),
    [anon_sym_ATpreserveGlobalState] = ACTIONS(579),
    [anon_sym_ATrequires] = ACTIONS(581),
    [anon_sym_ATrequiresusages] = ACTIONS(579),
    [anon_sym_ATrunInSeparateProcess] = ACTIONS(579),
    [anon_sym_ATrunTestsInSeparateProcesses] = ACTIONS(579),
    [anon_sym_ATsmall] = ACTIONS(579),
    [anon_sym_ATtest] = ACTIONS(581),
    [anon_sym_ATtestWith] = ACTIONS(579),
    [anon_sym_ATtestdox] = ACTIONS(579),
    [anon_sym_ATticket] = ACTIONS(579),
    [anon_sym_ATpsalm_DASHconsistent_DASHconstructor] = ACTIONS(579),
    [anon_sym_ATpsalm_DASHconsistent_DASHtemplates] = ACTIONS(579),
    [anon_sym_ATpsalm_DASHvar] = ACTIONS(579),
    [anon_sym_ATpsalm_DASHparam] = ACTIONS(581),
    [anon_sym_ATpsalm_DASHreturn] = ACTIONS(579),
    [anon_sym_ATpsalm_DASHproperty] = ACTIONS(581),
    [anon_sym_ATpsalm_DASHproperty_DASHread] = ACTIONS(579),
    [anon_sym_ATpsalm_DASHproperty_DASHwrite] = ACTIONS(579),
    [anon_sym_ATpsalm_DASHmethod] = ACTIONS(579),
    [anon_sym_ATpsalm_DASHignore_DASHvar] = ACTIONS(579),
    [anon_sym_ATpsalm_DASHif_DASHthis_DASHis] = ACTIONS(579),
    [anon_sym_ATpsalm_DASHthis_DASHout] = ACTIONS(579),
    [anon_sym_ATpsalm_DASHignore_DASHnullable_DASHreturn] = ACTIONS(579),
    [anon_sym_ATpsalm_DASHignore_DASHfalsable_DASHreturn] = ACTIONS(579),
    [anon_sym_ATpsalm_DASHseal_DASHproperties] = ACTIONS(579),
    [anon_sym_ATpsalm_DASHreadonly] = ACTIONS(581),
    [anon_sym_ATreadonly] = ACTIONS(579),
    [anon_sym_ATpsalm_DASHmutation_DASHfree] = ACTIONS(579),
    [anon_sym_ATpsalm_DASHexternal_DASHmutation_DASHfree] = ACTIONS(579),
    [anon_sym_ATpsalm_DASHimmutable] = ACTIONS(579),
    [anon_sym_ATpsalm_DASHpure] = ACTIONS(579),
    [anon_sym_ATpsalm_DASHallow_DASHprivate_DASHmutation] = ACTIONS(579),
    [anon_sym_ATpsalm_DASHreadonly_DASHallow_DASHprivate_DASHmutation] = ACTIONS(579),
    [anon_sym_ATpsalm_DASHtrace] = ACTIONS(579),
    [anon_sym_ATno_DASHnamed_DASHarguments] = ACTIONS(579),
    [anon_sym_ATparam_DASHout] = ACTIONS(579),
    [anon_sym_ATpsalm_DASHparam_DASHout] = ACTIONS(579),
    [anon_sym_ATpsalm_DASHassert] = ACTIONS(581),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHtrue] = ACTIONS(579),
    [anon_sym_ATpsalm_DASHassert_DASHif_DASHfalse] = ACTIONS(579),
    [anon_sym_ATpsalm_DASHimport_DASHtype] = ACTIONS(579),
    [anon_sym_ATpsalm_DASHsuppress] = ACTIONS(579),
    [anon_sym_ATpsalm_DASHinternal] = ACTIONS(579),
    [anon_sym_ATpsalm_DASHrequire_DASHextends] = ACTIONS(579),
    [anon_sym_ATpsalm_DASHrequire_DASHimplements] = ACTIONS(579),
    [anon_sym_ATmixin] = ACTIONS(579),
    [sym__end] = ACTIONS(579),
    [sym_text] = ACTIONS(579),
  },
  [141] = {
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_ATinheritdoc] = ACTIONS(549),
    [anon_sym_ATinheritDoc] = ACTIONS(549),
    [anon_sym_ATapi] = ACTIONS(549),
    [anon_sym_ATfilesource] = ACTIONS(549),
    [anon_sym_ATignore] = ACTIONS(549),
    [anon_sym_ATinternal] = ACTIONS(549),
    [anon_sym_ATcategory] = ACTIONS(549),
    [anon_sym_ATcopyright] = ACTIONS(549),
    [anon_sym_ATtodo] = ACTIONS(549),
    [anon_sym_ATexample] = ACTIONS(549),
    [anon_sym_ATlicense] = ACTIONS(549),
    [anon_sym_ATpackage] = ACTIONS(549),
    [anon_sym_ATsource] = ACTIONS(549),
    [anon_sym_ATsubpackage] = ACTIONS(549),
    [anon_sym_ATuses] = ACTIONS(549),
    [anon_sym_ATauthor] = ACTIONS(549),
    [anon_sym_ATglobal] = ACTIONS(549),
    [anon_sym_ATlink] = ACTIONS(549),
    [anon_sym_ATmethod] = ACTIONS(549),
    [anon_sym_ATparam] = ACTIONS(551),
    [anon_sym_ATproperty] = ACTIONS(551),
    [anon_sym_ATproperty_DASHread] = ACTIONS(549),
    [anon_sym_ATproperty_DASHwrite] = ACTIONS(549),
    [anon_sym_ATreturn] = ACTIONS(549),
    [anon_sym_ATsee] = ACTIONS(549),
    [anon_sym_ATthrows] = ACTIONS(549),
    [anon_sym_ATvar] = ACTIONS(549),
    [anon_sym_ATdeprecated] = ACTIONS(549),
    [anon_sym_ATsince] = ACTIONS(549),
    [anon_sym_ATversion] = ACTIONS(549),
    [anon_sym_ATtemplate] = ACTIONS(551),
    [anon_sym_ATpsalm_DASHtemplate] = ACTIONS(549),
    [anon_sym_ATphpstan_DASHtemplate] = ACTIONS(549),
    [anon_sym_ATimplements] = ACTIONS(549),
    [anon_sym_ATtemplate_DASHimplements] = ACTIONS(549),
    [anon_sym_ATextends] = ACTIONS(549),
    [anon_sym_ATtemplate_DASHextends] = ACTIONS(549),
    [anon_sym_ATuse] = ACTIONS(551),
    [anon_sym_ATtemplate_DASHuse] = ACTIONS(549),
    [anon_sym_ATafter] =