# pyright: reportPrivateUsage=false

from __future__ import annotations

from typing import Iterable, Iterator, MutableMapping, TypeVar

from .._types import SupportsLaxedItems
from ._classlookup import ElementBase, ElementClassLookup, FallbackElementClassLookup

_KT = TypeVar("_KT")
_VT = TypeVar("_VT")

class _NamespaceRegistry(MutableMapping[_KT, _VT]):
    def __delitem__(self, __key: _KT) -> None: ...
    def __getitem__(self, __key: _KT) -> _VT: ...
    def __setitem__(self, __key: _KT, __value: _VT) -> None: ...
    def __iter__(self) -> Iterator[_KT]: ...
    def __len__(self) -> int: ...
    def update(  # type: ignore[override]
        self,
        class_dict_iterable: SupportsLaxedItems[_KT, _VT] | Iterable[tuple[_KT, _VT]],
    ) -> None: ...
    def items(self) -> list[tuple[_KT, _VT]]: ...  # type: ignore[override]
    def iteritems(self) -> Iterator[tuple[_KT, _VT]]: ...
    def clear(self) -> None: ...

class _ClassNamespaceRegistry(_NamespaceRegistry[str | None, type[ElementBase]]): ...

class ElementNamespaceClassLookup(FallbackElementClassLookup):
    def __init__(self, fallback: ElementClassLookup | None = None) -> None: ...
    def get_namespace(self, ns_uri: str | None) -> _ClassNamespaceRegistry: ...
