import os
from core_function import client_search_testing

import pytest
from pymatgen.core.periodic_table import Element

from mp_api.client.routes.materials.xas import XASRester
from mp_api.client.core.utils import _compare_emmet_ver

if _compare_emmet_ver("0.85.0", ">="):
    from emmet.core.types.enums import XasEdge, XasType
else:
    from emmet.core.xas import (
        Type as XasType,
        Edge as XasEdge,
    )


@pytest.fixture
def rester():
    rester = XASRester()
    yield rester
    rester.session.close()


excluded_params = [
    "sort_fields",
    "chunk_size",
    "num_chunks",
    "all_fields",
    "fields",
    "material_ids",
]

sub_doc_fields = []  # type: list

alt_name_dict = {
    "required_elements": "elements",
    "formula": "formula_pretty",
    "exclude_elements": "material_id",
}  # type: dict

custom_field_tests = {
    "edge": XasEdge.L2_3,
    "spectrum_type": XasType.EXAFS,
    "absorbing_element": Element("Ce"),
    "required_elements": [Element("Ce")],
    "formula": "Ce(WO4)2",
    "chemsys": "Ce-O-W",
    "elements": ["Ce"],
}  # type: dict


@pytest.mark.skip(reason="Temp skip until timeout update.")
@pytest.mark.skipif(os.getenv("MP_API_KEY") is None, reason="No API key found.")
def test_client(rester):
    search_method = rester.search

    client_search_testing(
        search_method=search_method,
        excluded_params=excluded_params,
        alt_name_dict=alt_name_dict,
        custom_field_tests=custom_field_tests,
        sub_doc_fields=sub_doc_fields,
    )
