var keyData = {
  'ML-KEM-512': {
    privateUsages: ['decapsulateBits', 'decapsulateKey'],
    publicUsages: ['encapsulateBits', 'encapsulateKey'],
    pkcs8: new Uint8Array([
      48, 84, 2, 1, 0, 48, 11, 6, 9, 96, 134, 72, 1, 101, 3, 4, 4, 1, 4, 66,
      128, 64, 165, 38, 193, 164, 132, 122, 104, 173, 83, 214, 227, 31, 231,
      183, 152, 228, 96, 140, 65, 23, 83, 131, 8, 205, 245, 192, 122, 226, 244,
      94, 134, 109, 118, 60, 173, 203, 25, 75, 189, 144, 22, 37, 163, 53, 78,
      149, 185, 80, 130, 235, 161, 49, 141, 160, 11, 40, 152, 18, 142, 30, 56,
      252, 129, 211,
    ]),
    spki: hexStringToUint8Array(
      '30820332300b06096086480165030404010382032100366811c162b905bc1bf854094672bf9030954e19881fbc1d60c45469a51a20542864940ae5b261d3312dc85a416e8aad7192c6eed89b779c094293439e792f9876630b741997688e2e89479e340f7bb16e38f18ffc4a9217493388067b70743650f80955c56141662caa176302412c4eacab52f3a572518c8f148e74d1747bda95c566518ef1734ee76599f28674fb0ef609a729162c1ea6c39b899d5493a5461a5e648514c0f445dcaac8501ba5e42a543d5b9474faccd4e95ad7921260953f9832341022a91255ad88099170e5b1a2219dded196c0fca8ac6aa624269bb8423b65aaa3210a328179566a7bc8c44548ef97766aba1ae1933576030902258cfcf71eb7b10489e69f03ba5d3f5110eaeb49b3da180d7b2780165a3978aa73f8679b72b329051922488f03d050831379dd1306e75642d87547c280bb89a550b038b8bbd8854590a995758f65740c712a47fec072e1c1150e05be019c1e0e9216f6b2024fdc4e1f0c309af5ad34c997983674faf34dd7890719d04e3f8374f98223d67c1d930207b2429f02794355cac0d11c7e1058b1c5c4225c3abec5e05cfa063a51d47a2c341e89fa7b051c2a4e272a0583827581c9a48376a7078aef4a6e337232fe41c83e121acc206726f38a977625611b0f47c054d765b72c94b890e51fbd788da882aba97c45bfb07151150b21fbcdee6c8406b73d3a98af53f21f88e3b2fb98c0f114712c6b169e9a6a41d20d16eaaf62d127df5a1b9360959c4480ee19ce111b8cec439d53e33c32c374412966649c4037755abc5065eae3aaf05249bdfc9d52f116737bcfae707683f2a65eec2da6b39b7653bdff5256a765277a7169382943ed09cc2ad6a206658e199655e9d9885abb58f7f459d351a7fcb391bfc2685908406f6b4cad156d17d335263c748c83b98e54b1f4c815cd8b5ed7c60231308f63e27966ea3743aa3e2dd2c89e752ae9c56e81d40c8e127ff12b979ac0582075cdf4530ab6d588e9829c2d56231ecb6c5e210fd243b1e1f77891968a1fe4b7bc2225f420390625178f12b5d3ca2812963d953c47ff21824119c492f7b41f05b01dfbda8292ac0c35b3448878c401d1b18f7fc5c3cef899576d467afc70'
    ),
    'raw-public': hexStringToUint8Array(
      '366811c162b905bc1bf854094672bf9030954e19881fbc1d60c45469a51a20542864940ae5b261d3312dc85a416e8aad7192c6eed89b779c094293439e792f9876630b741997688e2e89479e340f7bb16e38f18ffc4a9217493388067b70743650f80955c56141662caa176302412c4eacab52f3a572518c8f148e74d1747bda95c566518ef1734ee76599f28674fb0ef609a729162c1ea6c39b899d5493a5461a5e648514c0f445dcaac8501ba5e42a543d5b9474faccd4e95ad7921260953f9832341022a91255ad88099170e5b1a2219dded196c0fca8ac6aa624269bb8423b65aaa3210a328179566a7bc8c44548ef97766aba1ae1933576030902258cfcf71eb7b10489e69f03ba5d3f5110eaeb49b3da180d7b2780165a3978aa73f8679b72b329051922488f03d050831379dd1306e75642d87547c280bb89a550b038b8bbd8854590a995758f65740c712a47fec072e1c1150e05be019c1e0e9216f6b2024fdc4e1f0c309af5ad34c997983674faf34dd7890719d04e3f8374f98223d67c1d930207b2429f02794355cac0d11c7e1058b1c5c4225c3abec5e05cfa063a51d47a2c341e89fa7b051c2a4e272a0583827581c9a48376a7078aef4a6e337232fe41c83e121acc206726f38a977625611b0f47c054d765b72c94b890e51fbd788da882aba97c45bfb07151150b21fbcdee6c8406b73d3a98af53f21f88e3b2fb98c0f114712c6b169e9a6a41d20d16eaaf62d127df5a1b9360959c4480ee19ce111b8cec439d53e33c32c374412966649c4037755abc5065eae3aaf05249bdfc9d52f116737bcfae707683f2a65eec2da6b39b7653bdff5256a765277a7169382943ed09cc2ad6a206658e199655e9d9885abb58f7f459d351a7fcb391bfc2685908406f6b4cad156d17d335263c748c83b98e54b1f4c815cd8b5ed7c60231308f63e27966ea3743aa3e2dd2c89e752ae9c56e81d40c8e127ff12b979ac0582075cdf4530ab6d588e9829c2d56231ecb6c5e210fd243b1e1f77891968a1fe4b7bc2225f420390625178f12b5d3ca2812963d953c47ff21824119c492f7b41f05b01dfbda8292ac0c35b3448878c401d1b18f7fc5c3cef899576d467afc70'
    ),
    'raw-seed': new Uint8Array([
      165, 38, 193, 164, 132, 122, 104, 173, 83, 214, 227, 31, 231, 183, 152,
      228, 96, 140, 65, 23, 83, 131, 8, 205, 245, 192, 122, 226, 244, 94, 134,
      109, 118, 60, 173, 203, 25, 75, 189, 144, 22, 37, 163, 53, 78, 149, 185,
      80, 130, 235, 161, 49, 141, 160, 11, 40, 152, 18, 142, 30, 56, 252, 129,
      211,
    ]),
  },
  'ML-KEM-768': {
    privateUsages: ['decapsulateBits', 'decapsulateKey'],
    publicUsages: ['encapsulateBits', 'encapsulateKey'],
    pkcs8: new Uint8Array([
      48, 84, 2, 1, 0, 48, 11, 6, 9, 96, 134, 72, 1, 101, 3, 4, 4, 2, 4, 66,
      128, 64, 166, 200, 29, 100, 198, 48, 80, 164, 143, 215, 2, 108, 106, 162,
      231, 107, 111, 143, 2, 14, 183, 253, 156, 17, 91, 213, 75, 200, 112, 89,
      243, 55, 201, 9, 240, 170, 192, 86, 52, 228, 122, 16, 73, 139, 30, 11,
      224, 117, 143, 2, 124, 21, 63, 91, 210, 94, 160, 123, 99, 189, 172, 61,
      235, 191,
    ]),
    spki: hexStringToUint8Array(
      '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'
    ),
    'raw-public': hexStringToUint8Array(
      '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'
    ),
    'raw-seed': new Uint8Array([
      166, 200, 29, 100, 198, 48, 80, 164, 143, 215, 2, 108, 106, 162, 231, 107,
      111, 143, 2, 14, 183, 253, 156, 17, 91, 213, 75, 200, 112, 89, 243, 55,
      201, 9, 240, 170, 192, 86, 52, 228, 122, 16, 73, 139, 30, 11, 224, 117,
      143, 2, 124, 21, 63, 91, 210, 94, 160, 123, 99, 189, 172, 61, 235, 191,
    ]),
  },
  'ML-KEM-1024': {
    privateUsages: ['decapsulateBits', 'decapsulateKey'],
    publicUsages: ['encapsulateBits', 'encapsulateKey'],
    pkcs8: new Uint8Array([
      48, 84, 2, 1, 0, 48, 11, 6, 9, 96, 134, 72, 1, 101, 3, 4, 4, 3, 4, 66,
      128, 64, 152, 117, 178, 230, 181, 134, 244, 129, 167, 125, 166, 8, 181,
      95, 206, 210, 136, 112, 219, 125, 6, 118, 122, 83, 38, 244, 57, 205, 50,
      98, 59, 46, 232, 66, 17, 145, 204, 252, 162, 185, 116, 116, 242, 28, 132,
      193, 251, 65, 39, 3, 101, 145, 174, 21, 195, 144, 234, 14, 158, 32, 49,
      57, 142, 113,
    ]),
    spki: hexStringToUint8Array(
      '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'
    ),
    'raw-public': hexStringToUint8Array(
      '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'
    ),
    'raw-seed': new Uint8Array([
      152, 117, 178, 230, 181, 134, 244, 129, 167, 125, 166, 8, 181, 95, 206,
      210, 136, 112, 219, 125, 6, 118, 122, 83, 38, 244, 57, 205, 50, 98, 59,
      46, 232, 66, 17, 145, 204, 252, 162, 185, 116, 116, 242, 28, 132, 193,
      251, 65, 39, 3, 101, 145, 174, 21, 195, 144, 234, 14, 158, 32, 49, 57,
      142, 113,
    ]),
  },
};
