// This file was generated automatically by the Snowball to JSX compiler

import "base-stemmer.jsx";
import "among.jsx";

 /**
  * This class was automatically generated by a Snowball to JSX compiler
  * It implements the stemming algorithm defined by a snowball script.
  */

class EnglishStemmer extends BaseStemmer
{
    static const serialVersionUID = 1;
    static const methodObject = new EnglishStemmer();

    static const a_0 = [
        new Among("arsen", -1, -1),
        new Among("commun", -1, -1),
        new Among("gener", -1, -1)
    ];

    static const a_1 = [
        new Among("'", -1, 1),
        new Among("'s'", 0, 1),
        new Among("'s", -1, 1)
    ];

    static const a_2 = [
        new Among("ied", -1, 2),
        new Among("s", -1, 3),
        new Among("ies", 1, 2),
        new Among("sses", 1, 1),
        new Among("ss", 1, -1),
        new Among("us", 1, -1)
    ];

    static const a_3 = [
        new Among("", -1, 3),
        new Among("bb", 0, 2),
        new Among("dd", 0, 2),
        new Among("ff", 0, 2),
        new Among("gg", 0, 2),
        new Among("bl", 0, 1),
        new Among("mm", 0, 2),
        new Among("nn", 0, 2),
        new Among("pp", 0, 2),
        new Among("rr", 0, 2),
        new Among("at", 0, 1),
        new Among("tt", 0, 2),
        new Among("iz", 0, 1)
    ];

    static const a_4 = [
        new Among("ed", -1, 2),
        new Among("eed", 0, 1),
        new Among("ing", -1, 2),
        new Among("edly", -1, 2),
        new Among("eedly", 3, 1),
        new Among("ingly", -1, 2)
    ];

    static const a_5 = [
        new Among("anci", -1, 3),
        new Among("enci", -1, 2),
        new Among("ogi", -1, 13),
        new Among("li", -1, 16),
        new Among("bli", 3, 12),
        new Among("abli", 4, 4),
        new Among("alli", 3, 8),
        new Among("fulli", 3, 14),
        new Among("lessli", 3, 15),
        new Among("ousli", 3, 10),
        new Among("entli", 3, 5),
        new Among("aliti", -1, 8),
        new Among("biliti", -1, 12),
        new Among("iviti", -1, 11),
        new Among("tional", -1, 1),
        new Among("ational", 14, 7),
        new Among("alism", -1, 8),
        new Among("ation", -1, 7),
        new Among("ization", 17, 6),
        new Among("izer", -1, 6),
        new Among("ator", -1, 7),
        new Among("iveness", -1, 11),
        new Among("fulness", -1, 9),
        new Among("ousness", -1, 10)
    ];

    static const a_6 = [
        new Among("icate", -1, 4),
        new Among("ative", -1, 6),
        new Among("alize", -1, 3),
        new Among("iciti", -1, 4),
        new Among("ical", -1, 4),
        new Among("tional", -1, 1),
        new Among("ational", 5, 2),
        new Among("ful", -1, 5),
        new Among("ness", -1, 5)
    ];

    static const a_7 = [
        new Among("ic", -1, 1),
        new Among("ance", -1, 1),
        new Among("ence", -1, 1),
        new Among("able", -1, 1),
        new Among("ible", -1, 1),
        new Among("ate", -1, 1),
        new Among("ive", -1, 1),
        new Among("ize", -1, 1),
        new Among("iti", -1, 1),
        new Among("al", -1, 1),
        new Among("ism", -1, 1),
        new Among("ion", -1, 2),
        new Among("er", -1, 1),
        new Among("ous", -1, 1),
        new Among("ant", -1, 1),
        new Among("ent", -1, 1),
        new Among("ment", 15, 1),
        new Among("ement", 16, 1)
    ];

    static const a_8 = [
        new Among("e", -1, 1),
        new Among("l", -1, 2)
    ];

    static const a_9 = [
        new Among("succeed", -1, -1),
        new Among("proceed", -1, -1),
        new Among("exceed", -1, -1),
        new Among("canning", -1, -1),
        new Among("inning", -1, -1),
        new Among("earring", -1, -1),
        new Among("herring", -1, -1),
        new Among("outing", -1, -1)
    ];

    static const a_10 = [
        new Among("andes", -1, -1),
        new Among("atlas", -1, -1),
        new Among("bias", -1, -1),
        new Among("cosmos", -1, -1),
        new Among("dying", -1, 3),
        new Among("early", -1, 9),
        new Among("gently", -1, 7),
        new Among("howe", -1, -1),
        new Among("idly", -1, 6),
        new Among("lying", -1, 4),
        new Among("news", -1, -1),
        new Among("only", -1, 10),
        new Among("singly", -1, 11),
        new Among("skies", -1, 2),
        new Among("skis", -1, 1),
        new Among("sky", -1, -1),
        new Among("tying", -1, 5),
        new Among("ugly", -1, 8)
    ];

    static const g_v = [17, 65, 16, 1] : int[];

    static const g_v_WXY = [1, 17, 65, 208, 1] : int[];

    static const g_valid_LI = [55, 141, 2] : int[];

    var B_Y_found : boolean = false;
    var I_p2 : int = 0;
    var I_p1 : int = 0;

    function copy_from (other : EnglishStemmer) : void
    {
        this.B_Y_found = other.B_Y_found;
        this.I_p2 = other.I_p2;
        this.I_p1 = other.I_p1;
        super.copy_from(other);
    }

    function r_prelude () : boolean
    {
        var v_1 : int;
        var v_2 : int;
        var v_3 : int;
        var v_4 : int;
        var v_5 : int;
        // (, line 25
        // unset Y_found, line 26
        this.B_Y_found = false;
        // do, line 27
        v_1 = this.cursor;
        var lab0 = true;
        lab0: while (lab0 == true)
        {
            lab0 = false;
            // (, line 27
            // [, line 27
            this.bra = this.cursor;
            // literal, line 27
            if (!(this.eq_s(1, "'")))
            {
                break lab0;
            }
            // ], line 27
            this.ket = this.cursor;
            // delete, line 27
            if (!this.slice_del())
            {
                return false;
            }
        }
        this.cursor = v_1;
        // do, line 28
        v_2 = this.cursor;
        var lab1 = true;
        lab1: while (lab1 == true)
        {
            lab1 = false;
            // (, line 28
            // [, line 28
            this.bra = this.cursor;
            // literal, line 28
            if (!(this.eq_s(1, "y")))
            {
                break lab1;
            }
            // ], line 28
            this.ket = this.cursor;
            // <-, line 28
            if (!this.slice_from("Y"))
            {
                return false;
            }
            // set Y_found, line 28
            this.B_Y_found = true;
        }
        this.cursor = v_2;
        // do, line 29
        v_3 = this.cursor;
        var lab2 = true;
        lab2: while (lab2 == true)
        {
            lab2 = false;
            // repeat, line 29
            replab3: while(true)
            {
                v_4 = this.cursor;
                var lab4 = true;
                lab4: while (lab4 == true)
                {
                    lab4 = false;
                    // (, line 29
                    // goto, line 29
                    golab5: while(true)
                    {
                        v_5 = this.cursor;
                        var lab6 = true;
                        lab6: while (lab6 == true)
                        {
                            lab6 = false;
                            // (, line 29
                            if (!(this.in_grouping(EnglishStemmer.g_v, 97, 121)))
                            {
                                break lab6;
                            }
                            // [, line 29
                            this.bra = this.cursor;
                            // literal, line 29
                            if (!(this.eq_s(1, "y")))
                            {
                                break lab6;
                            }
                            // ], line 29
                            this.ket = this.cursor;
                            this.cursor = v_5;
                            break golab5;
                        }
                        this.cursor = v_5;
                        if (this.cursor >= this.limit)
                        {
                            break lab4;
                        }
                        this.cursor++;
                    }
                    // <-, line 29
                    if (!this.slice_from("Y"))
                    {
                        return false;
                    }
                    // set Y_found, line 29
                    this.B_Y_found = true;
                    continue replab3;
                }
                this.cursor = v_4;
                break replab3;
            }
        }
        this.cursor = v_3;
        return true;
    }

    function r_mark_regions () : boolean
    {
        var v_1 : int;
        var v_2 : int;
        // (, line 32
        this.I_p1 = this.limit;
        this.I_p2 = this.limit;
        // do, line 35
        v_1 = this.cursor;
        var lab0 = true;
        lab0: while (lab0 == true)
        {
            lab0 = false;
            // (, line 35
            // or, line 41
            var lab1 = true;
            lab1: while (lab1 == true)
            {
                lab1 = false;
                v_2 = this.cursor;
                var lab2 = true;
                lab2: while (lab2 == true)
                {
                    lab2 = false;
                    // among, line 36
                    if (this.find_among(EnglishStemmer.a_0, 3) == 0)
                    {
                        break lab2;
                    }
                    break lab1;
                }
                this.cursor = v_2;
                // (, line 41
                // gopast, line 41
                golab3: while(true)
                {
                    var lab4 = true;
                    lab4: while (lab4 == true)
                    {
                        lab4 = false;
                        if (!(this.in_grouping(EnglishStemmer.g_v, 97, 121)))
                        {
                            break lab4;
                        }
                        break golab3;
                    }
                    if (this.cursor >= this.limit)
                    {
                        break lab0;
                    }
                    this.cursor++;
                }
                // gopast, line 41
                golab5: while(true)
                {
                    var lab6 = true;
                    lab6: while (lab6 == true)
                    {
                        lab6 = false;
                        if (!(this.out_grouping(EnglishStemmer.g_v, 97, 121)))
                        {
                            break lab6;
                        }
                        break golab5;
                    }
                    if (this.cursor >= this.limit)
                    {
                        break lab0;
                    }
                    this.cursor++;
                }
            }
            // setmark p1, line 42
            this.I_p1 = this.cursor;
            // gopast, line 43
            golab7: while(true)
            {
                var lab8 = true;
                lab8: while (lab8 == true)
                {
                    lab8 = false;
                    if (!(this.in_grouping(EnglishStemmer.g_v, 97, 121)))
                    {
                        break lab8;
                    }
                    break golab7;
                }
                if (this.cursor >= this.limit)
                {
                    break lab0;
                }
                this.cursor++;
            }
            // gopast, line 43
            golab9: while(true)
            {
                var lab10 = true;
                lab10: while (lab10 == true)
                {
                    lab10 = false;
                    if (!(this.out_grouping(EnglishStemmer.g_v, 97, 121)))
                    {
                        break lab10;
                    }
                    break golab9;
                }
                if (this.cursor >= this.limit)
                {
                    break lab0;
                }
                this.cursor++;
            }
            // setmark p2, line 43
            this.I_p2 = this.cursor;
        }
        this.cursor = v_1;
        return true;
    }

    function r_shortv () : boolean
    {
        var v_1 : int;
        // (, line 49
        // or, line 51
        var lab0 = true;
        lab0: while (lab0 == true)
        {
            lab0 = false;
            v_1 = this.limit - this.cursor;
            var lab1 = true;
            lab1: while (lab1 == true)
            {
                lab1 = false;
                // (, line 50
                if (!(this.out_grouping_b(EnglishStemmer.g_v_WXY, 89, 121)))
                {
                    break lab1;
                }
                if (!(this.in_grouping_b(EnglishStemmer.g_v, 97, 121)))
                {
                    break lab1;
                }
                if (!(this.out_grouping_b(EnglishStemmer.g_v, 97, 121)))
                {
                    break lab1;
                }
                break lab0;
            }
            this.cursor = this.limit - v_1;
            // (, line 52
            if (!(this.out_grouping_b(EnglishStemmer.g_v, 97, 121)))
            {
                return false;
            }
            if (!(this.in_grouping_b(EnglishStemmer.g_v, 97, 121)))
            {
                return false;
            }
            // atlimit, line 52
            if (this.cursor > this.limit_backward)
            {
                return false;
            }
        }
        return true;
    }

    function r_R1 () : boolean
    {
        if (!(this.I_p1 <= this.cursor))
        {
            return false;
        }
        return true;
    }

    function r_R2 () : boolean
    {
        if (!(this.I_p2 <= this.cursor))
        {
            return false;
        }
        return true;
    }

    function r_Step_1a () : boolean
    {
        var among_var : int;
        var v_1 : int;
        var v_2 : int;
        // (, line 58
        // try, line 59
        v_1 = this.limit - this.cursor;
        var lab0 = true;
        lab0: while (lab0 == true)
        {
            lab0 = false;
            // (, line 59
            // [, line 60
            this.ket = this.cursor;
            // substring, line 60
            among_var = this.find_among_b(EnglishStemmer.a_1, 3);
            if (among_var == 0)
            {
                this.cursor = this.limit - v_1;
                break lab0;
            }
            // ], line 60
            this.bra = this.cursor;
            switch (among_var) {
                case 0:
                    this.cursor = this.limit - v_1;
                    break lab0;
                case 1:
                    // (, line 62
                    // delete, line 62
                    if (!this.slice_del())
                    {
                        return false;
                    }
                    break;
            }
        }
        // [, line 65
        this.ket = this.cursor;
        // substring, line 65
        among_var = this.find_among_b(EnglishStemmer.a_2, 6);
        if (among_var == 0)
        {
            return false;
        }
        // ], line 65
        this.bra = this.cursor;
        switch (among_var) {
            case 0:
                return false;
            case 1:
                // (, line 66
                // <-, line 66
                if (!this.slice_from("ss"))
                {
                    return false;
                }
                break;
            case 2:
                // (, line 68
                // or, line 68
                var lab1 = true;
                lab1: while (lab1 == true)
                {
                    lab1 = false;
                    v_2 = this.limit - this.cursor;
                    var lab2 = true;
                    lab2: while (lab2 == true)
                    {
                        lab2 = false;
                        // (, line 68
                        // hop, line 68
                        {
                            var c : int = this.cursor - 2;
                            if (this.limit_backward > c || c > this.limit)
                            {
                                break lab2;
                            }
                            this.cursor = c;
                        }
                        // <-, line 68
                        if (!this.slice_from("i"))
                        {
                            return false;
                        }
                        break lab1;
                    }
                    this.cursor = this.limit - v_2;
                    // <-, line 68
                    if (!this.slice_from("ie"))
                    {
                        return false;
                    }
                }
                break;
            case 3:
                // (, line 69
                // next, line 69
                if (this.cursor <= this.limit_backward)
                {
                    return false;
                }
                this.cursor--;
                // gopast, line 69
                golab3: while(true)
                {
                    var lab4 = true;
                    lab4: while (lab4 == true)
                    {
                        lab4 = false;
                        if (!(this.in_grouping_b(EnglishStemmer.g_v, 97, 121)))
                        {
                            break lab4;
                        }
                        break golab3;
                    }
                    if (this.cursor <= this.limit_backward)
                    {
                        return false;
                    }
                    this.cursor--;
                }
                // delete, line 69
                if (!this.slice_del())
                {
                    return false;
                }
                break;
        }
        return true;
    }

    function r_Step_1b () : boolean
    {
        var among_var : int;
        var v_1 : int;
        var v_3 : int;
        var v_4 : int;
        // (, line 74
        // [, line 75
        this.ket = this.cursor;
        // substring, line 75
        among_var = this.find_among_b(EnglishStemmer.a_4, 6);
        if (among_var == 0)
        {
            return false;
        }
        // ], line 75
        this.bra = this.cursor;
        switch (among_var) {
            case 0:
                return false;
            case 1:
                // (, line 77
                // call R1, line 77
                if (!this.r_R1())
                {
                    return false;
                }
                // <-, line 77
                if (!this.slice_from("ee"))
                {
                    return false;
                }
                break;
            case 2:
                // (, line 79
                // test, line 80
                v_1 = this.limit - this.cursor;
                // gopast, line 80
                golab0: while(true)
                {
                    var lab1 = true;
                    lab1: while (lab1 == true)
                    {
                        lab1 = false;
                        if (!(this.in_grouping_b(EnglishStemmer.g_v, 97, 121)))
                        {
                            break lab1;
                        }
                        break golab0;
                    }
                    if (this.cursor <= this.limit_backward)
                    {
                        return false;
                    }
                    this.cursor--;
                }
                this.cursor = this.limit - v_1;
                // delete, line 80
                if (!this.slice_del())
                {
                    return false;
                }
                // test, line 81
                v_3 = this.limit - this.cursor;
                // substring, line 81
                among_var = this.find_among_b(EnglishStemmer.a_3, 13);
                if (among_var == 0)
                {
                    return false;
                }
                this.cursor = this.limit - v_3;
                switch (among_var) {
                    case 0:
                        return false;
                    case 1:
                        // (, line 83
                        // <+, line 83
                        {
                            var c : int = this.cursor;
                            this.insert(this.cursor, this.cursor, "e");
                            this.cursor = c;
                        }
                        break;
                    case 2:
                        // (, line 86
                        // [, line 86
                        this.ket = this.cursor;
                        // next, line 86
                        if (this.cursor <= this.limit_backward)
                        {
                            return false;
                        }
                        this.cursor--;
                        // ], line 86
                        this.bra = this.cursor;
                        // delete, line 86
                        if (!this.slice_del())
                        {
                            return false;
                        }
                        break;
                    case 3:
                        // (, line 87
                        // atmark, line 87
                        if (this.cursor != this.I_p1)
                        {
                            return false;
                        }
                        // test, line 87
                        v_4 = this.limit - this.cursor;
                        // call shortv, line 87
                        if (!this.r_shortv())
                        {
                            return false;
                        }
                        this.cursor = this.limit - v_4;
                        // <+, line 87
                        {
                            var c : int = this.cursor;
                            this.insert(this.cursor, this.cursor, "e");
                            this.cursor = c;
                        }
                        break;
                }
                break;
        }
        return true;
    }

    function r_Step_1c () : boolean
    {
        var v_1 : int;
        var v_2 : int;
        // (, line 93
        // [, line 94
        this.ket = this.cursor;
        // or, line 94
        var lab0 = true;
        lab0: while (lab0 == true)
        {
            lab0 = false;
            v_1 = this.limit - this.cursor;
            var lab1 = true;
            lab1: while (lab1 == true)
            {
                lab1 = false;
                // literal, line 94
                if (!(this.eq_s_b(1, "y")))
                {
                    break lab1;
                }
                break lab0;
            }
            this.cursor = this.limit - v_1;
            // literal, line 94
            if (!(this.eq_s_b(1, "Y")))
            {
                return false;
            }
        }
        // ], line 94
        this.bra = this.cursor;
        if (!(this.out_grouping_b(EnglishStemmer.g_v, 97, 121)))
        {
            return false;
        }
        // not, line 95
        {
            v_2 = this.limit - this.cursor;
            var lab2 = true;
            lab2: while (lab2 == true)
            {
                lab2 = false;
                // atlimit, line 95
                if (this.cursor > this.limit_backward)
                {
                    break lab2;
                }
                return false;
            }
            this.cursor = this.limit - v_2;
        }
        // <-, line 96
        if (!this.slice_from("i"))
        {
            return false;
        }
        return true;
    }

    function r_Step_2 () : boolean
    {
        var among_var : int;
        // (, line 99
        // [, line 100
        this.ket = this.cursor;
        // substring, line 100
        among_var = this.find_among_b(EnglishStemmer.a_5, 24);
        if (among_var == 0)
        {
            return false;
        }
        // ], line 100
        this.bra = this.cursor;
        // call R1, line 100
        if (!this.r_R1())
        {
            return false;
        }
        switch (among_var) {
            case 0:
                return false;
            case 1:
                // (, line 101
                // <-, line 101
                if (!this.slice_from("tion"))
                {
                    return false;
                }
                break;
            case 2:
                // (, line 102
                // <-, line 102
                if (!this.slice_from("ence"))
                {
                    return false;
                }
                break;
            case 3:
                // (, line 103
                // <-, line 103
                if (!this.slice_from("ance"))
                {
                    return false;
                }
                break;
            case 4:
                // (, line 104
                // <-, line 104
                if (!this.slice_from("able"))
                {
                    return false;
                }
                break;
            case 5:
                // (, line 105
                // <-, line 105
                if (!this.slice_from("ent"))
                {
                    return false;
                }
                break;
            case 6:
                // (, line 107
                // <-, line 107
                if (!this.slice_from("ize"))
                {
                    return false;
                }
                break;
            case 7:
                // (, line 109
                // <-, line 109
                if (!this.slice_from("ate"))
                {
                    return false;
                }
                break;
            case 8:
                // (, line 111
                // <-, line 111
                if (!this.slice_from("al"))
                {
                    return false;
                }
                break;
            case 9:
                // (, line 112
                // <-, line 112
                if (!this.slice_from("ful"))
                {
                    return false;
                }
                break;
            case 10:
                // (, line 114
                // <-, line 114
                if (!this.slice_from("ous"))
                {
                    return false;
                }
                break;
            case 11:
                // (, line 116
                // <-, line 116
                if (!this.slice_from("ive"))
                {
                    return false;
                }
                break;
            case 12:
                // (, line 118
                // <-, line 118
                if (!this.slice_from("ble"))
                {
                    return false;
                }
                break;
            case 13:
                // (, line 119
                // literal, line 119
                if (!(this.eq_s_b(1, "l")))
                {
                    return false;
                }
                // <-, line 119
                if (!this.slice_from("og"))
                {
                    return false;
                }
                break;
            case 14:
                // (, line 120
                // <-, line 120
                if (!this.slice_from("ful"))
                {
                    return false;
                }
                break;
            case 15:
                // (, line 121
                // <-, line 121
                if (!this.slice_from("less"))
                {
                    return false;
                }
                break;
            case 16:
                // (, line 122
                if (!(this.in_grouping_b(EnglishStemmer.g_valid_LI, 99, 116)))
                {
                    return false;
                }
                // delete, line 122
                if (!this.slice_del())
                {
                    return false;
                }
                break;
        }
        return true;
    }

    function r_Step_3 () : boolean
    {
        var among_var : int;
        // (, line 126
        // [, line 127
        this.ket = this.cursor;
        // substring, line 127
        among_var = this.find_among_b(EnglishStemmer.a_6, 9);
        if (among_var == 0)
        {
            return false;
        }
        // ], line 127
        this.bra = this.cursor;
        // call R1, line 127
        if (!this.r_R1())
        {
            return false;
        }
        switch (among_var) {
            case 0:
                return false;
            case 1:
                // (, line 128
                // <-, line 128
                if (!this.slice_from("tion"))
                {
                    return false;
                }
                break;
            case 2:
                // (, line 129
                // <-, line 129
                if (!this.slice_from("ate"))
                {
                    return false;
                }
                break;
            case 3:
                // (, line 130
                // <-, line 130
                if (!this.slice_from("al"))
                {
                    return false;
                }
                break;
            case 4:
                // (, line 132
                // <-, line 132
                if (!this.slice_from("ic"))
                {
                    return false;
                }
                break;
            case 5:
                // (, line 134
                // delete, line 134
                if (!this.slice_del())
                {
                    return false;
                }
                break;
            case 6:
                // (, line 136
                // call R2, line 136
                if (!this.r_R2())
                {
                    return false;
                }
                // delete, line 136
                if (!this.slice_del())
                {
                    return false;
                }
                break;
        }
        return true;
    }

    function r_Step_4 () : boolean
    {
        var among_var : int;
        var v_1 : int;
        // (, line 140
        // [, line 141
        this.ket = this.cursor;
        // substring, line 141
        among_var = this.find_among_b(EnglishStemmer.a_7, 18);
        if (among_var == 0)
        {
            return false;
        }
        // ], line 141
        this.bra = this.cursor;
        // call R2, line 141
        if (!this.r_R2())
        {
            return false;
        }
        switch (among_var) {
            case 0:
                return false;
            case 1:
                // (, line 144
                // delete, line 144
                if (!this.slice_del())
                {
                    return false;
                }
                break;
            case 2:
                // (, line 145
                // or, line 145
                var lab0 = true;
                lab0: while (lab0 == true)
                {
                    lab0 = false;
                    v_1 = this.limit - this.cursor;
                    var lab1 = true;
                    lab1: while (lab1 == true)
                    {
                        lab1 = false;
                        // literal, line 145
                        if (!(this.eq_s_b(1, "s")))
                        {
                            break lab1;
                        }
                        break lab0;
                    }
                    this.cursor = this.limit - v_1;
                    // literal, line 145
                    if (!(this.eq_s_b(1, "t")))
                    {
                        return false;
                    }
                }
                // delete, line 145
                if (!this.slice_del())
                {
                    return false;
                }
                break;
        }
        return true;
    }

    function r_Step_5 () : boolean
    {
        var among_var : int;
        var v_1 : int;
        var v_2 : int;
        // (, line 149
        // [, line 150
        this.ket = this.cursor;
        // substring, line 150
        among_var = this.find_among_b(EnglishStemmer.a_8, 2);
        if (among_var == 0)
        {
            return false;
        }
        // ], line 150
        this.bra = this.cursor;
        switch (among_var) {
            case 0:
                return false;
            case 1:
                // (, line 151
                // or, line 151
                var lab0 = true;
                lab0: while (lab0 == true)
                {
                    lab0 = false;
                    v_1 = this.limit - this.cursor;
                    var lab1 = true;
                    lab1: while (lab1 == true)
                    {
                        lab1 = false;
                        // call R2, line 151
                        if (!this.r_R2())
                        {
                            break lab1;
                        }
                        break lab0;
                    }
                    this.cursor = this.limit - v_1;
                    // (, line 151
                    // call R1, line 151
                    if (!this.r_R1())
                    {
                        return false;
                    }
                    // not, line 151
                    {
                        v_2 = this.limit - this.cursor;
                        var lab2 = true;
                        lab2: while (lab2 == true)
                        {
                            lab2 = false;
                            // call shortv, line 151
                            if (!this.r_shortv())
                            {
                                break lab2;
                            }
                            return false;
                        }
                        this.cursor = this.limit - v_2;
                    }
                }
                // delete, line 151
                if (!this.slice_del())
                {
                    return false;
                }
                break;
            case 2:
                // (, line 152
                // call R2, line 152
                if (!this.r_R2())
                {
                    return false;
                }
                // literal, line 152
                if (!(this.eq_s_b(1, "l")))
                {
                    return false;
                }
                // delete, line 152
                if (!this.slice_del())
                {
                    return false;
                }
                break;
        }
        return true;
    }

    function r_exception2 () : boolean
    {
        // (, line 156
        // [, line 158
        this.ket = this.cursor;
        // substring, line 158
        if (this.find_among_b(EnglishStemmer.a_9, 8) == 0)
        {
            return false;
        }
        // ], line 158
        this.bra = this.cursor;
        // atlimit, line 158
        if (this.cursor > this.limit_backward)
        {
            return false;
        }
        return true;
    }

    function r_exception1 () : boolean
    {
        var among_var : int;
        // (, line 168
        // [, line 170
        this.bra = this.cursor;
        // substring, line 170
        among_var = this.find_among(EnglishStemmer.a_10, 18);
        if (among_var == 0)
        {
            return false;
        }
        // ], line 170
        this.ket = this.cursor;
        // atlimit, line 170
        if (this.cursor < this.limit)
        {
            return false;
        }
        switch (among_var) {
            case 0:
                return false;
            case 1:
                // (, line 174
                // <-, line 174
                if (!this.slice_from("ski"))
                {
                    return false;
                }
                break;
            case 2:
                // (, line 175
                // <-, line 175
                if (!this.slice_from("sky"))
                {
                    return false;
                }
                break;
            case 3:
                // (, line 176
                // <-, line 176
                if (!this.slice_from("die"))
                {
                    return false;
                }
                break;
            case 4:
                // (, line 177
                // <-, line 177
                if (!this.slice_from("lie"))
                {
                    return false;
                }
                break;
            case 5:
                // (, line 178
                // <-, line 178
                if (!this.slice_from("tie"))
                {
                    return false;
                }
                break;
            case 6:
                // (, line 182
                // <-, line 182
                if (!this.slice_from("idl"))
                {
                    return false;
                }
                break;
            case 7:
                // (, line 183
                // <-, line 183
                if (!this.slice_from("gentl"))
                {
                    return false;
                }
                break;
            case 8:
                // (, line 184
                // <-, line 184
                if (!this.slice_from("ugli"))
                {
                    return false;
                }
                break;
            case 9:
                // (, line 185
                // <-, line 185
                if (!this.slice_from("earli"))
                {
                    return false;
                }
                break;
            case 10:
                // (, line 186
                // <-, line 186
                if (!this.slice_from("onli"))
                {
                    return false;
                }
                break;
            case 11:
                // (, line 187
                // <-, line 187
                if (!this.slice_from("singl"))
                {
                    return false;
                }
                break;
        }
        return true;
    }

    function r_postlude () : boolean
    {
        var v_1 : int;
        var v_2 : int;
        // (, line 203
        // Boolean test Y_found, line 203
        if (!(this.B_Y_found))
        {
            return false;
        }
        // repeat, line 203
        replab0: while(true)
        {
            v_1 = this.cursor;
            var lab1 = true;
            lab1: while (lab1 == true)
            {
                lab1 = false;
                // (, line 203
                // goto, line 203
                golab2: while(true)
                {
                    v_2 = this.cursor;
                    var lab3 = true;
                    lab3: while (lab3 == true)
                    {
                        lab3 = false;
                        // (, line 203
                        // [, line 203
                        this.bra = this.cursor;
                        // literal, line 203
                        if (!(this.eq_s(1, "Y")))
                        {
                            break lab3;
                        }
                        // ], line 203
                        this.ket = this.cursor;
                        this.cursor = v_2;
                        break golab2;
                    }
                    this.cursor = v_2;
                    if (this.cursor >= this.limit)
                    {
                        break lab1;
                    }
                    this.cursor++;
                }
                // <-, line 203
                if (!this.slice_from("y"))
                {
                    return false;
                }
                continue replab0;
            }
            this.cursor = v_1;
            break replab0;
        }
        return true;
    }

    override function stem () : boolean
    {
        var v_1 : int;
        var v_2 : int;
        var v_3 : int;
        var v_4 : int;
        var v_5 : int;
        var v_6 : int;
        var v_7 : int;
        var v_8 : int;
        var v_9 : int;
        var v_10 : int;
        var v_11 : int;
        var v_12 : int;
        var v_13 : int;
        // (, line 205
        // or, line 207
        var lab0 = true;
        lab0: while (lab0 == true)
        {
            lab0 = false;
            v_1 = this.cursor;
            var lab1 = true;
            lab1: while (lab1 == true)
            {
                lab1 = false;
                // call exception1, line 207
                if (!this.r_exception1())
                {
                    break lab1;
                }
                break lab0;
            }
            this.cursor = v_1;
            var lab2 = true;
            lab2: while (lab2 == true)
            {
                lab2 = false;
                // not, line 208
                {
                    v_2 = this.cursor;
                    var lab3 = true;
                    lab3: while (lab3 == true)
                    {
                        lab3 = false;
                        // hop, line 208
                        {
                            var c : int = this.cursor + 3;
                            if (0 > c || c > this.limit)
                            {
                                break lab3;
                            }
                            this.cursor = c;
                        }
                        break lab2;
                    }
                    this.cursor = v_2;
                }
                break lab0;
            }
            this.cursor = v_1;
            // (, line 208
            // do, line 209
            v_3 = this.cursor;
            var lab4 = true;
            lab4: while (lab4 == true)
            {
                lab4 = false;
                // call prelude, line 209
                if (!this.r_prelude())
                {
                    break lab4;
                }
            }
            this.cursor = v_3;
            // do, line 210
            v_4 = this.cursor;
            var lab5 = true;
            lab5: while (lab5 == true)
            {
                lab5 = false;
                // call mark_regions, line 210
                if (!this.r_mark_regions())
                {
                    break lab5;
                }
            }
            this.cursor = v_4;
            // backwards, line 211
            this.limit_backward = this.cursor; this.cursor = this.limit;
            // (, line 211
            // do, line 213
            v_5 = this.limit - this.cursor;
            var lab6 = true;
            lab6: while (lab6 == true)
            {
                lab6 = false;
                // call Step_1a, line 213
                if (!this.r_Step_1a())
                {
                    break lab6;
                }
            }
            this.cursor = this.limit - v_5;
            // or, line 215
            var lab7 = true;
            lab7: while (lab7 == true)
            {
                lab7 = false;
                v_6 = this.limit - this.cursor;
                var lab8 = true;
                lab8: while (lab8 == true)
                {
                    lab8 = false;
                    // call exception2, line 215
                    if (!this.r_exception2())
                    {
                        break lab8;
                    }
                    break lab7;
                }
                this.cursor = this.limit - v_6;
                // (, line 215
                // do, line 217
                v_7 = this.limit - this.cursor;
                var lab9 = true;
                lab9: while (lab9 == true)
                {
                    lab9 = false;
                    // call Step_1b, line 217
                    if (!this.r_Step_1b())
                    {
                        break lab9;
                    }
                }
                this.cursor = this.limit - v_7;
                // do, line 218
                v_8 = this.limit - this.cursor;
                var lab10 = true;
                lab10: while (lab10 == true)
                {
                    lab10 = false;
                    // call Step_1c, line 218
                    if (!this.r_Step_1c())
                    {
                        break lab10;
                    }
                }
                this.cursor = this.limit - v_8;
                // do, line 220
                v_9 = this.limit - this.cursor;
                var lab11 = true;
                lab11: while (lab11 == true)
                {
                    lab11 = false;
                    // call Step_2, line 220
                    if (!this.r_Step_2())
                    {
                        break lab11;
                    }
                }
                this.cursor = this.limit - v_9;
                // do, line 221
                v_10 = this.limit - this.cursor;
                var lab12 = true;
                lab12: while (lab12 == true)
                {
                    lab12 = false;
                    // call Step_3, line 221
                    if (!this.r_Step_3())
                    {
                        break lab12;
                    }
                }
                this.cursor = this.limit - v_10;
                // do, line 222
                v_11 = this.limit - this.cursor;
                var lab13 = true;
                lab13: while (lab13 == true)
                {
                    lab13 = false;
                    // call Step_4, line 222
                    if (!this.r_Step_4())
                    {
                        break lab13;
                    }
                }
                this.cursor = this.limit - v_11;
                // do, line 224
                v_12 = this.limit - this.cursor;
                var lab14 = true;
                lab14: while (lab14 == true)
                {
                    lab14 = false;
                    // call Step_5, line 224
                    if (!this.r_Step_5())
                    {
                        break lab14;
                    }
                }
                this.cursor = this.limit - v_12;
            }
            this.cursor = this.limit_backward;            // do, line 227
            v_13 = this.cursor;
            var lab15 = true;
            lab15: while (lab15 == true)
            {
                lab15 = false;
                // call postlude, line 227
                if (!this.r_postlude())
                {
                    break lab15;
                }
            }
            this.cursor = v_13;
        }
        return true;
    }

    function equals (o : variant) : boolean {
        return o instanceof EnglishStemmer;
    }

    function hashCode() : int
    {
        //http://stackoverflow.com/questions/194846/is-there-any-kind-of-hashcode-function-in-javascript
        var classname = "EnglishStemmer";
        var hash = 0;
        if (classname.length == 0) return hash;
        for (var i = 0; i < classname.length; i++) {
            var char = classname.charCodeAt(i);
            hash = ((hash << 5) - hash) + char;
            hash = hash & hash; // Convert to 32bit integer
        }
        return hash;
    }

}

