<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/redis/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/redis/metadata.yaml"
sidebar_label: "Redis"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Databases"
most_popular: True
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Redis


<img src="https://netdata.cloud/img/redis.svg" width="150"/>


Plugin: go.d.plugin
Module: redis

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors the health and performance of Redis servers and collects general statistics, CPU and memory consumption, replication information, command statistics, and more.


It connects to the Redis instance via a TCP or UNIX socket and executes the following commands:

- [INFO ALL](https://redis.io/commands/info)
- [PING](https://redis.io/commands/ping/)


This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

By default, it detects instances running on localhost by attempting to connect using known Redis TCP and UNIX sockets:

- 127.0.0.1:6379
- /tmp/redis.sock
- /var/run/redis/redis.sock
- /var/lib/redis/redis.sock


#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per Redis instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| redis.connections | accepted, rejected | connections/s |
| redis.clients | connected, blocked, tracking, in_timeout_table | clients |
| redis.ping_latency | min, max, avg | seconds |
| redis.commands | processes | commands/s |
| redis.keyspace_lookup_hit_rate | lookup_hit_rate | percentage |
| redis.memory | max, used, rss, peak, dataset, lua, scripts | bytes |
| redis.mem_fragmentation_ratio | mem_fragmentation | ratio |
| redis.key_eviction_events | evicted | keys/s |
| redis.net | received, sent | kilobits/s |
| redis.rdb_changes | changes | operations |
| redis.bgsave_now | current_bgsave_time | seconds |
| redis.bgsave_health | last_bgsave | status |
| redis.bgsave_last_rdb_save_since_time | last_bgsave_time | seconds |
| redis.aof_file_size | current, base | bytes |
| redis.commands_calls | a dimension per command | calls |
| redis.commands_usec | a dimension per command | microseconds |
| redis.commands_usec_per_sec | a dimension per command | microseconds/s |
| redis.key_expiration_events | expired | keys/s |
| redis.database_keys | a dimension per database | keys |
| redis.database_expires_keys | a dimension per database | keys |
| redis.connected_replicas | connected | replicas |
| redis.master_link_status | up, down | status |
| redis.master_last_io_since_time | time | seconds |
| redis.master_link_down_since_time | time | seconds |
| redis.uptime | uptime | seconds |



## Alerts


The following alerts are available:

| Alert name  | On metric | Description |
|:------------|:----------|:------------|
| [ redis_connections_rejected ](https://github.com/netdata/netdata/blob/master/src/health/health.d/redis.conf) | redis.connections | connections rejected because of maxclients limit in the last minute |
| [ redis_bgsave_slow ](https://github.com/netdata/netdata/blob/master/src/health/health.d/redis.conf) | redis.bgsave_now | duration of the on-going RDB save operation |
| [ redis_bgsave_broken ](https://github.com/netdata/netdata/blob/master/src/health/health.d/redis.conf) | redis.bgsave_health | status of the last RDB save operation (0: ok, 1: error) |
| [ redis_master_link_down ](https://github.com/netdata/netdata/blob/master/src/health/health.d/redis.conf) | redis.master_link_down_since_time | time elapsed since the link between master and slave is down |


## Setup

### Prerequisites

No action required.

### Configuration

#### File

The configuration file name for this integration is `go.d/redis.conf`.


You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/redis.conf
```
#### Options

The following options can be defined globally: update_every, autodetection_retry.


<details open><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Data collection frequency. | 5 | no |
| autodetection_retry | Recheck interval in seconds. Zero means no recheck will be scheduled. | 0 | no |
| address | Redis server address. | redis://@localhost:6379 | yes |
| timeout | Dial (establishing new connections), read (socket reads) and write (socket writes) timeout in seconds. | 1 | no |
| username | Username used for authentication. |  | no |
| password | Password used for authentication. |  | no |
| tls_skip_verify | Server certificate chain and hostname validation policy. Controls whether the client performs this check. | no | no |
| tls_ca | Certificate authority that client use when verifying server certificates. |  | no |
| tls_cert | Client tls certificate. |  | no |
| tls_key | Client tls key. |  | no |

</details>

#### Examples

##### TCP socket

An example configuration.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    address: 'redis://@127.0.0.1:6379'

```
</details>

##### Unix socket

An example configuration.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    address: 'unix://@/tmp/redis.sock'

```
</details>

##### TCP socket with password

An example configuration.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    address: 'redis://:password@127.0.0.1:6379'

```
</details>

##### Multi-instance

> **Note**: When you define multiple jobs, their names must be unique.

Local and remote instances.


<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    address: 'redis://:password@127.0.0.1:6379'

  - name: remote
    address: 'redis://user:password@203.0.113.0:6379'

```
</details>



## Troubleshooting

### Debug Mode

**Important**: Debug mode is not supported for data collection jobs created via the UI using the Dyncfg feature.

To troubleshoot issues with the `redis` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m redis
  ```

### Getting Logs

If you're encountering problems with the `redis` collector, follow these steps to retrieve logs and identify potential issues:

- **Run the command** specific to your system (systemd, non-systemd, or Docker container).
- **Examine the output** for any warnings or error messages that might indicate issues.  These messages should provide clues about the root cause of the problem.

#### System with systemd

Use the following command to view logs generated since the last Netdata service restart:

```bash
journalctl _SYSTEMD_INVOCATION_ID="$(systemctl show --value --property=InvocationID netdata)" --namespace=netdata --grep redis
```

#### System without systemd

Locate the collector log file, typically at `/var/log/netdata/collector.log`, and use `grep` to filter for collector's name:

```bash
grep redis /var/log/netdata/collector.log
```

**Note**: This method shows logs from all restarts. Focus on the **latest entries** for troubleshooting current issues.

#### Docker Container

If your Netdata runs in a Docker container named "netdata" (replace if different), use this command:

```bash
docker logs netdata 2>&1 | grep redis
```


