<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/collectors/windows.plugin/integrations/iis.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/collectors/windows.plugin/metadata.yaml"
sidebar_label: "IIS"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Windows Systems"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# IIS


<img src="https://netdata.cloud/img/windows.svg" width="150"/>


Plugin: windows.plugin
Module: PerflibWebService

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors website requests and logins.


It queries the 'Web Service' object from Perflib in order to gather the metrics.


This collector is only supported on the following platforms:

- windows

This collector only supports collecting metrics from a single instance of this integration.


### Default Behavior

#### Auto-Detection

The collector automatically detects all of the metrics, no further configuration is required.


#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per IIS website

These metrics refer to the IIS website.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| website | The name of the IIS website. |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| iis.website_traffic | received, sent | bytes/s |
| iis.website_requests_rate | requests | requests/s |
| iis.website_requests_by_type_rate | options, get, post, head, put, delete, trace, move, copy, mkcol, propfind, proppatch, search, lock, unlock, other | requests/s |
| iis.website_active_connections_count | active | connections |
| iis.website_users_count | anonymous, non_anonymous | users |
| iis.website_connection_attempts_rate | connection | attempts/s |
| iis.website_isapi_extension_requests_count | isapi | requests |
| iis.website_isapi_extension_requests_rate | isapi | requests/s |
| iis.website_ftp_file_transfer_rate | received, sent | files/s |
| iis.website_logon_attempts_rate | logon | attempts/s |
| iis.website_errors_rate | document_locked, document_not_found | errors/s |
| iis.website_uptime | uptime | seconds |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

No action required.

### Configuration

#### File

The configuration file name for this integration is `netdata.conf`.
Configuration for this specific integration is located in the `[plugin:windows]` section within that file.

The file format is a modified INI syntax. The general structure is:

```ini
[section1]
    option1 = some value
    option2 = some other value

[section2]
    option3 = some third value
```
You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config netdata.conf
```
#### Options



| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| PerflibWebService | An option to enable or disable the data collection. | yes | no |

#### Examples
There are no configuration examples.


