/**********************************************************************************************************************
 * DISCLAIMER
 * This software is supplied by Renesas Electronics Corporation and is only intended for use with Renesas products. No
 * other uses are authorized. This software is owned by Renesas Electronics Corporation and is protected under all
 * applicable laws, including copyright laws.
 * THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
 * THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED. TO THE MAXIMUM
 * EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES
 * SHALL BE LIABLE FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR ANY REASON RELATED TO
 * THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 * Renesas reserves the right, without notice, to make changes to this software and to discontinue the availability of
 * this software. By using this software, you agree to the additional terms and conditions found by accessing the
 * following link:
 * http://www.renesas.com/disclaimer
 *
 * Copyright (C) 2020 Renesas Electronics Corporation. All rights reserved.
 *********************************************************************************************************************/
/**********************************************************************************************************************
 * File Name    : s_flash2.c
 * Version      : 1.01
 * Description  : Key information file.
 *********************************************************************************************************************/
/**********************************************************************************************************************
 * History : DD.MM.YYYY Version  Description
 *         : 05.10.2020 1.00        First Release.
 *         : 02.12.2020 1.01        Added new functions such as the Brainpool curve.
 *********************************************************************************************************************/

/**********************************************************************************************************************
 Includes   <System Includes> , "Project Includes"
 *********************************************************************************************************************/
#include "r_sce.h"

/**********************************************************************************************************************
 Macro definitions
 *********************************************************************************************************************/

/**********************************************************************************************************************
 Typedef definitions
 *********************************************************************************************************************/

/**********************************************************************************************************************
 Exported global variables
 *********************************************************************************************************************/
uint32_t const S_FLASH2[] =
{
#ifndef __ARMEB__   /* Little endian */
    0xad78b7ce, 0xf485a034, 0xcb79fe33, 0xde0206f4,
    0xd724cdb7, 0xffc1c3fb, 0x8ec8b097, 0x75147619,
    0x7a747536, 0x9a9f225c, 0x8db851be, 0x332e46eb,
    0x5315ec11, 0xed2d9a01, 0x785e1417, 0x710be082,
    0x9bd5cfc4, 0x803958d8, 0x65371697, 0x9332ece2,
    0xc1fbda82, 0xa39f1f88, 0xe3c70320, 0x7b3eb514,
    0xc246e4dd, 0xb98512cc, 0x077290a0, 0x852dff73,
    0x79edda48, 0xad95daf3, 0x135207b4, 0xa559c171,
    0xe4427203, 0x04a673d8, 0xc953eabc, 0xdb54226b,
    0x2a152052, 0xde86f990, 0x715aa1c2, 0xa42047f5,
    0x8f4e7169, 0x2ff8d793, 0x57280c0f, 0xb9ca5163,
    0xecffa856, 0x827ef6e0, 0x5f424cf3, 0xddd4f654,
    0xd7682af1, 0x89f5525a, 0x0925501d, 0x29e94fe2,
    0x19be4b41, 0xbf761fab, 0x8e3013bd, 0xa1a97207,
    0x1432d5d4, 0x8637f40e, 0x59f8bdbe, 0xa68b9ee0,
    0x67ed60c6, 0x54ee5b4b, 0x7bdf9c18, 0x623561a9,
    0xee881a24, 0x0fe13417, 0xecabc9d7, 0x07b0f6cd,
    0x9d2fb554, 0xea830811, 0x60bbf204, 0x532e919e,
    0xd79072e2, 0x60e5c587, 0x092271ec, 0x72fab7b6,
    0x4e00ad87, 0xd49a737c, 0xcb4e2e8f, 0xf0974963,
    0xf9bc9a4a, 0x482c13b3, 0xf61580b3, 0x99aa1a84,
    0x51149b14, 0x0ca6bab4, 0xc834df5b, 0xe55a08c3,
    0x5f4f5997, 0x94fc624b, 0x5d090f02, 0x01313fa9,
    0x4c1331ee, 0x47c531ee, 0x5b55f12e, 0x45512449,
    0x4552105f, 0x31238514, 0x3081a3d4, 0x2471f8d4,
    0xcf8bd178, 0xf289fc71, 0x1d01c385, 0x3c9bd983,
    0x2236584e, 0xd24fa393, 0x3f013ab2, 0x2401202b,
    0x44f04f3f, 0x2c1731b8, 0x9735437c, 0x523294d9,
    0x6673c3b4, 0xc5f333fa, 0x7e74296d, 0x2b77f78b,
    0x8ad5533d, 0xd2a323a7, 0xa7565c0a, 0x50887e94,
    0x4c3c7a7e, 0xe69e848a, 0xfc0aabe1, 0x1ee10b86,
    0x5a543d6a, 0x0ea7ec9a, 0xec62a28e, 0x9a8e19c8,
    0xd693dfc4, 0x617e2298, 0x9312d81e, 0x16377a11,
    0x99fee12f, 0xd61b5bb5, 0xe4ba72c2, 0x88ef6b51,
    0x92f8a700, 0xf7e72b1f, 0x36405e75, 0x77a1251f,
    0xfdef1161, 0xc96c84d3, 0x39718323, 0x8bcee018,
    0x39dd415c, 0x95565903, 0x5f98893f, 0xf2a1f6e1,
    0x301e8b7b, 0xc3f584a5, 0xa640dfb9, 0x9bec650b,
    0x55bd6a31, 0x71348032, 0xdc4aa649, 0xeac3f267,
    0x8ea986e4, 0x415b9fc6, 0x5452a145, 0xcb7ea535,
    0x79c53d53, 0x15f2f3ed, 0x1eb1bae9, 0xc955735d,
    0x062925b6, 0x6cdcf074, 0x4783ad93, 0x2aa83a2b,
    0xd13efca5, 0xb1a88d5c, 0xc13557de, 0x7236deb5,
    0x9b710768, 0x2fe5c387, 0xa023a059, 0x53a6dad1,
    0xe92fa9fb, 0x64ecb595, 0x670dc6f7, 0x078ff273,
    0xca4df9c3, 0x752cc089, 0x164117f6, 0x8f367e18,
    0xff07e9a6, 0xf05017cd, 0xa8fd9094, 0x117657fe,
    0x7732e086, 0xf53acf4d, 0x66b122cd, 0xe06ff062,
    0xce16bf08, 0xe239afbb, 0xce19cee7, 0xb1a1a1e4,
    0x9760e317, 0x691933ac, 0x3ff47837, 0x37a98542,
    0x82dd3a4c, 0x8d33b9fe, 0x66383758, 0xba254288,
    0x3073bc2c, 0x0bc7ef02, 0xeb8980a0, 0x89d73944,
    0x4d1998ce, 0xc6a84435, 0xdfeae1a8, 0xb7cea4d8,
    0xe48a7dca, 0x6d2e4833, 0x0bc61d21, 0x6406ba72,
    0xbcfb3740, 0x284f77da, 0xeeda9f19, 0x4013584d,
    0xae77def9, 0xb52ed4d1, 0xea53840e, 0xc58c1c93,
    0x57caa4ef, 0xf49815f6, 0x39de04df, 0xee3e82cd,
    0x94fa315f, 0x9089f7f6, 0x8c148c62, 0xaea86eb9,
    0xee4d92a1, 0x53e22273, 0x320a1a49, 0x6062458c,
    0x83f899dd, 0x130cd15d, 0x2254b89a, 0xb47adbde,
    0xb00fa169, 0x79e37a18, 0x2e83b3d0, 0x52a50351,
    0x88d45f8d, 0x26e83c7e, 0xe31d675a, 0xa86ee007,
    0x9a6df643, 0x31c6fb04, 0x6abb3f42, 0xbd6d955d,
    0x8c5fbcc3, 0x6c343ccb, 0x61e18836, 0xc279bad9,
    0xa12ae050, 0x4794b96f, 0x20a151e8, 0x2b7cee93,
    0xfea27c67, 0x362554bc, 0x8cf0b632, 0x9449694d,
    0xe9eb3752, 0x4dfbb874, 0x96ee12e7, 0xcc0bab5b,
    0x1d1d454e, 0x0346a061, 0xa06707ae, 0xbdb76aa4,
    0x45e15add, 0x2bf3fe1c, 0xfaaaffac, 0xee5b079d,
    0x49a3f4b3, 0xc3f5a0d2, 0x8363720f, 0xb35da70b,
    0xd06c0ad3, 0x8a83b325, 0x0c6f419d, 0xb8ad75f7,
    0x85f8211c, 0x0e9aa552, 0xdb4eea0a, 0xf3a81af9,
    0xcdd0a2be, 0x1678793d, 0xf15a4107, 0xd4a0cf7b,
    0x6940f0d4, 0x020549a6, 0x6372983d, 0xb8d3f734,
    0x694ff9a7, 0xefa49bdf, 0x42831ff8, 0x27a0c27c,
    0xcedf518d, 0xeedb44f4, 0xc7a724de, 0x4a52d583,
    0x43eb80f5, 0x5ca362a6, 0xb13fd822, 0xfbe540a2,
    0xdc785c16, 0xcb58458a, 0x74cf432d, 0x967c6b61,
    0x62167c74, 0xaa40d95f, 0x0ca80521, 0x1feb9633,
    0xa0b968ab, 0xfba2b2db, 0xb74cbf74, 0x2d8a21ff,
    0xe3a80f4f, 0x90fea7fe, 0x73d0828c, 0x85b97cfc,
    0xae6d737b, 0x8c76de29, 0x34c4b173, 0x04c04e21,
    0xc4005344, 0x39691984, 0x039bf0ce, 0x697fce5b,
    0x0d0ed2b6, 0xce6b8ac6, 0x5a32f56c, 0x43c35359,
    0x5b3803f0, 0x6b97a563, 0x650b708d, 0xb275f0d2,
    0x21447967, 0x8890ca7e, 0xf64dcfae, 0xe6581cb8,
    0x5b7c4163, 0x8de977ba, 0x824e2654, 0xe36811e7,
    0x2cc2625f, 0xad9f4ad5, 0x202feb20, 0xcd85413b,
    0xc9190d84, 0x3ed08b6a, 0x506d4a1f, 0xa2a1e8d7,
    0xc70c01f1, 0xd3b8ddcf, 0xce141c89, 0xa19b31fa,
    0xf1b37042, 0x7e5cb4c5, 0x0a2088c9, 0x207c3366,
    0x705c1a48, 0x05352a16, 0xf2236556, 0x061b4e2f,
    0xf7be8a2e, 0x20bc58ed, 0x4ea6a298, 0x2489282e,
    0x50c9aa2c, 0x00791346, 0xaec86312, 0x24f8f2cd,
    0x187678a6, 0x90045d55, 0x07c3277a, 0xa47ff698,
    0x29cc0f62, 0x0103f887, 0x341fa96d, 0x86d54d2c,
    0xf31712d8, 0x00a33b7d, 0x2c43b2f8, 0xf3ac68af,
    0x27785c02, 0x0b1fc86c, 0x06119876, 0x3707c3ce,
    0xcad84f69, 0x3a5ef643, 0x8464b479, 0x4439b78f,
    0x1727d533, 0x81a383b5, 0x1b92975c, 0x5006a634,
    0xb8f0e0b2, 0x4e6d7415, 0x13590f5e, 0x4414d3f7,
    0xc4f1f111, 0xb9dc6d5d, 0xdd544f92, 0xf14de9a6,
    0xa626265c, 0x1e07e4b6, 0x655033c6, 0x56a425d1,
    0x3c102773, 0x31641587, 0x35be4499, 0x6e7bcbad,
    0x073d1c86, 0xdd0c786d, 0x0871ab1b, 0x805af125,
    0x3ec11642, 0xdbb154e8, 0xa866d423, 0x26f1e26d,
    0x6228f64e, 0x80217ade, 0xf966b1ed, 0x4a664d5b,
    0xce50a089, 0xe71a0846, 0x6bb935d2, 0xa2838885,
    0xce6a9ca9, 0x14d09b86, 0xeff642e0, 0x3446f4e3,
    0x8efc125e, 0x6c18ba57, 0x32c27f0b, 0x4a7d9b9e,
    0x75a08670, 0xae0f3372, 0x9655ae09, 0x017c9312,
    0x3836eeba, 0xa4169358, 0xba319d22, 0x055b6ce4,
    0xe706d8d9, 0xf4160e72, 0x99a30673, 0x9a99f174,
    0x85ab677c, 0xcb76bfec, 0x54bd20ba, 0x66b58ca3,
    0xf2a6609e, 0x0e40e3fb, 0xf18e1d75, 0x3db67a96,
    0xd7561e85, 0x8d07c345, 0x0440e605, 0xf7e551f6,
    0x38d9dc21, 0xfc6fcc63, 0x1b4e95df, 0xfeff7756,
    0x04b6eceb, 0xadead1d6, 0xfd67d45e, 0xa1b1d273,
    0xc508c6a7, 0xe5d582db, 0x527fabee, 0x4bea7a44,
    0x471063cd, 0xbb8c0f82, 0xb8e8d98f, 0xfc246cc6,
    0xca417726, 0xb2f63429, 0xcd408eb3, 0x26e5f88a,
    0x57a1f600, 0x21154b8c, 0xba77816a, 0xe9f6f447,
    0xec18caaa, 0x4c37bcff, 0x4854e740, 0x7173da47,
    0xb18f1c0b, 0xd5d2e739, 0xb5cce51a, 0x7da4de1f,
    0x2073cbe8, 0x37c2c87d, 0x3063058a, 0x468a7f18,
    0x7323419e, 0x8e1a8186, 0x49a92e14, 0xf67dee26,
    0xbc9c1a64, 0xa8c7aef1, 0x556ca70e, 0xb8fc261e,
    0xeb40656c, 0xd4c84476, 0x38433e0b, 0x13792038,
    0xf5c20c0e, 0x7000a994, 0x52b36412, 0x9b4e4d14,
    0xc8916c36, 0x793b6a21, 0xe46ee83a, 0x0416a9da,
    0x1fb8ac7d, 0x5c9922da, 0xaf5ae1e1, 0xe55ee839,
    0xdbd1c7ff, 0x18b52cea, 0xad61d711, 0x20769f0a,
    0x19d2b4ab, 0x1dd6272b, 0x97b37865, 0x9d56c45d,
    0xdbe6183b, 0x6bf759a6, 0x836bd3e3, 0x0410083c,
    0xc27555c1, 0x27f6bd7a, 0xd75b2ddb, 0x41ee4c81,
    0xa198ccbb, 0xff399a8e, 0x8b87e36b, 0x788e6f1a,
    0x6a0ed92c, 0x8be87eda, 0x423e7e3b, 0x2766ea9e,
    0xcdef7371, 0x32e22a57, 0x8f079b53, 0xc801c87c,
    0x5d73565f, 0xe523bfd0, 0x11cdb2df, 0x24d65f2e,
    0x8b3c28d2, 0x0583181c, 0x32ba110b, 0x917d557e,
    0x93a7d01b, 0xbc91da09, 0x83ffe873, 0x3bb39f2e,
    0xe26093e9, 0xe160e16d, 0x5ed67962, 0x2df8719c,
    0x2c1ef993, 0x90c41821, 0x25ce335c, 0x39912698,
    0x8f5df038, 0x976f324c, 0xde5afbb9, 0x7453ac8f,
    0x8877ec75, 0x0a3687b2, 0x019adaec, 0x542930f7,
    0x017e5e03, 0x7414500d, 0x192aaf58, 0x7bc0ed61,
    0x6b650d47, 0x9c8ebe21, 0xe7970cb4, 0x87db9ef2,
    0x09eb26fe, 0xe64243c2, 0xdf062583, 0xb2563e12,
    0x0a2532e7, 0xfbf631b1, 0x104e6c3c, 0x3c5e63a3,
    0xd463e061, 0xf2ef1d35, 0x684f64e2, 0x839a2da7,
    0x84d28ca5, 0xe3ec7dae, 0xeb7a75a5, 0x3ac14923,
    0x4040f5bf, 0x140e2a37, 0xbdf017af, 0x9ecdbaa2,
    0x505f4ed4, 0x99f163d4, 0x6f4fa78c, 0xb52db623,
    0x1ac48739, 0x0a86fc18, 0xd00ff2b9, 0xe2036f93,
    0xeeeb068e, 0x917779a9, 0xcf4688e5, 0x52264c45,
    0x16bdcc49, 0x5b6c1a5d, 0x67b53024, 0x4a5b67a3,
    0x84f24183, 0x0ec06dfd, 0x6e4b3751, 0x483cc294,
    0xfa14dcd6, 0x4e234ff1, 0x0fed8f86, 0xf59271da,
    0x529c56f2, 0xbbebeac3, 0x0f77f16e, 0x0dca89fb,
    0xc6ff4eeb, 0x5e09896c, 0x451d9e36, 0xf94dc1b9,
    0xc7da035f, 0xe5a3e3e5, 0x7b8346c0, 0x8e23cb38,
    0x4c6b24ba, 0x6bbec422, 0xfeeb33b5, 0x09b2425f,
    0x413b39c7, 0xad9136a0, 0x92e7f60d, 0x1f3a0df4,
    0x08d2778e, 0x3067de6a, 0x098d4bcb, 0x10625f9d,
    0x64abac10, 0xb2830643, 0x94e9969d, 0x4fdd4d0d,
    0xa81cf5e5, 0x42a47c77, 0x8f3c1e69, 0xe46160bc,
    0xee399b53, 0x6a0c080e, 0x769d77ed, 0xbc9ccf9a,
    0xef007244, 0x6f8b2f06, 0x454d1666, 0xadeb361f,
    0xa1382a16, 0xd0181a2e, 0x7a72ba9f, 0xa1af160a,
    0x62b7ab48, 0x89748586, 0x30be6312, 0x517f468f,
    0xf2668d4b, 0x53cb3ad7, 0xca1fc9b2, 0xab52352c,
    0xf37c7bdb, 0x9d727d00, 0xe5f61ed5, 0x5f42361b,
    0x87434502, 0x41e3102e, 0x2ee03064, 0xd2b2ff6e,
    0x718a0e01, 0x0d6a32d2, 0x23753c2a, 0x17ce213e,
    0x67ec2873, 0x2f043590, 0x9ce3f47f, 0x94bdf807,
    0xe7c34a2e, 0xac6a9525, 0xc96a0e6c, 0xb9571ebf,
    0xc3d75569, 0xbb3d469d, 0x47568330, 0x0f1d97b1,
    0xe6e096dd, 0xb235560b, 0x02aa2212, 0x3c2f8ee5,
    0x605dd867, 0x04761613, 0xbfc51805, 0x0d6ff887,
    0xf31457fb, 0x53a277aa, 0x94d53086, 0xb973b7e3,
    0x82844baa, 0xb49a8934, 0xe38631f2, 0x57eafd13,
    0xae1f298e, 0x591f5ae4, 0x4d5c2754, 0x2055f9ad,
    0xda6d1d53, 0x5428245a, 0x133df432, 0x99e18dd3,
    0xf566ed22, 0x6959e3f2, 0x393f42a5, 0xf77c2430,
    0x2cb8ce85, 0x55c7d5bc, 0x9eb79021, 0x8068d650,
    0xd8bfb406, 0x43a7e773, 0xdca584b9, 0x97166d46,
    0xbee94513, 0xbb932e5b, 0xd5cb562b, 0xbf7537e6,
    0x11035ec9, 0xec66d5e8, 0xc10c49b5, 0x859ca138,
    0x62d925e5, 0x5294d361, 0xc19057a6, 0xab2dbc63,
    0x64e5434d, 0x6364a2e8, 0x362ae565, 0x3524ed35,
    0x2b27d97e, 0xd9306b26, 0xbccff4ae, 0x66875ce5,
    0x1d90119d, 0x7a35af65, 0x7d8455cf, 0x8d37e43a,
    0x9dc3af95, 0xa3c19115, 0xead12535, 0xf12d7507,
    0xdd178ed2, 0xdec73bfe, 0x85fba2e6, 0x39568c8b,
    0x8fc1a449, 0x2cf1d471, 0x9baece78, 0xf36b8e52,
    0x6eca1700, 0x58f51ef8, 0x33ab7a99, 0x9fbf7225,
    0x259c7276, 0x150b5987, 0x75a98c0d, 0xb2b52445,
    0xc54233c0, 0x7dbb5474, 0x37efa2ae, 0x638fe8f1,
    0xb30c509c, 0x043c5cdf, 0x44d042a4, 0xec33ca06,
    0x406dbc04, 0x80318f7f, 0x4b26002a, 0x4dd523a3,
    0x0dc16862, 0x2b790de3, 0x42e0de46, 0x072f3919,
    0x03517e7f, 0x02c7aa48, 0x3067ee94, 0x5ffefbb3,
    0x7617ef70, 0x2b63ad83, 0x5426902f, 0x3d78b187,
    0xe3460d3f, 0x1d5453bc, 0x7cbc37aa, 0xf49dd33f,
    0x8ec83672, 0x9784c880, 0x8e095378, 0x77998bb0,
    0x741cfcad, 0x97707a64, 0xdf2a3d5c, 0x0160da53,
    0x134fe8bb, 0xff2c52a6, 0xb0388e2e, 0x8bf4986a,
    0x537c777e, 0x92e690d4, 0xd8649ee9, 0x9534e260,
    0xbb2bf1bd, 0x0d7cf870, 0xe5838c51, 0x826abd18,
    0x566b90e1, 0x2795531b, 0x9243b4b0, 0x26f3bc1e,
    0x4d543eb4, 0xb153c05a, 0x09b68083, 0xf007c6ae,
    0x67a1cd5e, 0xfc56b513, 0x0d365369, 0x6d3b5c2c,
    0xade5ec6a, 0x80045fcf, 0x4da66d69, 0x06894d5b,
    0x0ed1cb94, 0xb06b7cf1, 0x62d0ee57, 0x9d592242,
    0x62678e5c, 0x55d5dc9e, 0x41fed9a9, 0x01eed9e2,
    0x80e0e1af, 0x4cc2d1d8, 0xfe31b4f9, 0xabfb5428,
    0xa401aad7, 0x4db199c1, 0xecd0a771, 0x617a6a96,
    0xd767b885, 0x032b6e8e, 0x942e638e, 0x2cddd5db,
    0xb4eef740, 0x05fa1e17, 0xd0c87adc, 0x921aa8ea,
    0x6ce2c256, 0x22c54b08, 0x815b07f7, 0xc9f13170,
    0x721783dc, 0x115b4392, 0x8eafd75b, 0x91a1cda3,
    0x0dbdb102, 0xccd6c9c6, 0x70c9403c, 0xa69fd812,
    0x316187a2, 0x43308b58, 0x49b563a3, 0xc8869daf,
    0xe66d0ebe, 0x7a168b7d, 0xb419a3e5, 0x7644caa5,
    0x6d5847ca, 0xfb07974d, 0xa7dbf662, 0xe5c52a8a,
    0x526f76ab, 0xf506c5c2, 0xf5655c05, 0xb6a6ff7f,
    0x3c7e73e9, 0x79e3d89f, 0x00822b07, 0xf5f92875,
    0x4110dda7, 0xcf5f4c36, 0x60ac4580, 0xcf4b5421,
    0x18e88d0f, 0x8a0904b4, 0x754e8a45, 0x41eaef0a,
    0xf4b50e33, 0x15f8480d, 0xba006b1c, 0x5d9ec804,
    0x376dff2d, 0xa5434ccf, 0xf7528fb3, 0xd5932e03,
    0x0c5cdde3, 0x16ab47c8, 0x1e765717, 0xba7fc2da,
    0x721bf153, 0xef53dd81, 0x5d79ee44, 0xe261b422,
    0x0390dd78, 0xb4aa77e6, 0xf3bc8dee, 0x61a6b960,
    0x5b6005ff, 0x2dc3cae8, 0xffea8090, 0xa23bc5ae,
    0xcbd3758c, 0x82c99c15, 0xb52f0ebd, 0xe969cda9,
    0x56268ad3, 0x3670da61, 0x7b6cde3f, 0xa6da4504,
    0xbcacccc8, 0x7af23a70, 0x728dab94, 0x85f110f9,
    0x4ee9f86a, 0x475f7e8c, 0xd36d3bc8, 0x3b581db2,
    0x376ca887, 0xc50ed90b, 0xc0f71fe9, 0xa4dee98f,
    0x57828808, 0xb1384311, 0x53bfab22, 0xb1aaa36a,
    0x270f0aec, 0x3d107e75, 0xb167a511, 0xdf640078,
    0xf63b98e7, 0xcc6c6893, 0x369667c2, 0xa9cfd952,
    0x16b937e7, 0x04adb37b, 0xd674ec6f, 0xadc5aa0d,
    0xf04ba0ff, 0x88d300e9, 0xb3038196, 0x5c3060c3,
    0x45892304, 0x672cb274, 0x972199aa, 0xe6a9bb18,
    0xb79ab2fa, 0x37223e41, 0xfc82a4ff, 0xdc0acceb,
    0xa809d1be, 0xd6110ec0, 0xb6f01ba8, 0x8d829cf6,
    0x5e49844d, 0xca0075a5, 0x35d5a4b8, 0xc06c7e11,
    0xe688c9b3, 0x0acf49eb, 0x42a5f8f0, 0x704e0479,
    0x4dc6fc87, 0x2ac4d4b2, 0x5da5213e, 0x38798d90,
    0xeb48dc66, 0x49525830, 0x1a0f35dc, 0xb887ce89,
    0x6a2db320, 0xb5e290bb, 0x945ef0eb, 0xb19277da,
    0x51e4cac8, 0x3c61c05f, 0x2c3a1a03, 0x955642bc,
    0x968c18b4, 0x687d6e9b, 0x8fc33c5a, 0x78464a1b,
    0x3b3cee58, 0x000d6946, 0xa2cbab20, 0x7104a36d,
    0x5099e49e, 0xf14a2223, 0x58325291, 0xf1fc50c2,
    0xea594db1, 0x42522deb, 0xa4f974f5, 0xd67a54c0,
    0x6746450a, 0x0550cffa, 0x31cdddae, 0x181ee273,
    0xb26e8ab3, 0x773b3f12, 0x03ec9bdd, 0x08edf6e3,
    0x6a8b3677, 0x83f41f37, 0xac569f85, 0x32d55f87,
    0xd3be6a9e, 0x7cc27593, 0x1b46185f, 0x5bf35f74,
    0xdb4741ad, 0x51a7e06a, 0x7b7c54c0, 0x6377312b,
    0x2c2dd650, 0xc7ad211f, 0x5882527c, 0x0f95ef48,
    0x02e4af0e, 0xd9f53012, 0xabb93fb2, 0xee5ed3bd,
    0x66f1506d, 0xcf9166b8, 0x47bd54cb, 0x579b6a54,
    0xc07a04d2, 0xaf8c09eb, 0xb41011bc, 0x2258e0ed,
    0x61abf396, 0xad9cab5e, 0x0a2c18a2, 0x09412ef0,
    0xa37ad2d8, 0xf861863c, 0x3e6a51d5, 0x41f34b4f,
    0xbf023a6b, 0xf463c7f6, 0x8688b684, 0x0fc37237,
    0x0c215d46, 0x359a9ecd, 0xf3a403b2, 0xadeeb7d5,
    0x5890465c, 0x42a69fe7, 0xac624b62, 0x8b8bb173,
    0xf1657e63, 0xc3c7e5fa, 0x4d4ee3df, 0x8831e396,
    0x05ec4e6d, 0x6be7f36a, 0x34b02899, 0x1362af8d,
    0x3c07bda4, 0x6fab3d4c, 0xc44f95f8, 0x6d147101,
    0x3b7fef86, 0x8fbd05aa, 0xf5e01b97, 0xc0e296e5,
    0xea832026, 0x92700bdf, 0x1a5d1b4d, 0xb01ea0ba,
    0x856a7c9a, 0xf6f19e2b, 0x6848cd8f, 0xb0573d7c,
    0xc651fdd9, 0xca780370, 0xa8ed392d, 0x22026ddb,
    0x5bfdb3fc, 0xfddee7ac, 0x8bd364f5, 0x453e8461,
    0xbc687ebd, 0xba3666a4, 0x3e2e8327, 0x94124360,
    0xa05b150e, 0x75643ddb, 0x3086fdd6, 0xa6b4b7a2,
    0xb5194151, 0x4e7f6d86, 0xd5a8a31a, 0x057a6561,
    0x32c83190, 0x999168c3, 0x59d3eafe, 0x6e248352,
    0x4c17916b, 0xec0266d9, 0x3934c9b7, 0x5c83e546,
    0x4ba27f28, 0xf0ebbab5, 0xfa7c4ca7, 0x63347956,
    0x31cbf261, 0xb3594cee, 0x06dfcc14, 0x963a7a4d,
    0xdf95b26d, 0x58a7498b, 0x7aee7d3b, 0x33571a2f,
    0x52dd80b8, 0xe8955985, 0xbed140a7, 0xf2fe7527,
    0x7ed1a883, 0xf66ec1e1, 0x3cbaca54, 0x5a258d0e,
    0x46235bb1, 0x8beedba3, 0x55db81e2, 0xb3ce5e61,
    0xefce6dae, 0x9f81d49a, 0x91cfabd3, 0x56597a09,
    0xc9bd5434, 0x54081084, 0xa791ac58, 0x189c4c29,
    0xc9b32fea, 0xbbbf9c57, 0x657fd931, 0xc96b0719,
    0x65f1ec81, 0xbdaa21e0, 0x882fc032, 0x5b05da67,
    0x577868d8, 0x5c1f91f3, 0x09e136f6, 0xacd3ad00,
    0xba32702a, 0xbb8b6aef, 0xf29fccde, 0x1bcfd9a5,
    0xd15b1af4, 0xdf5e1004, 0x0dc88c1e, 0xd66cada7,
    0x28cadec9, 0xf1eafe0d, 0xd791d9ff, 0x08d42687,
    0x3d167403, 0x3a3e84e0, 0x6ee427e7, 0xba4e9824,
    0x576ff3c2, 0x5af749f0, 0xe4984a6c, 0x79f9ed22,
    0xfbe9e2b9, 0x8955b116, 0xb8007b8e, 0x04fddc93,
    0x9760385f, 0xb3561117, 0x5cfa9176, 0xb9652c4e,
    0xe9a16941, 0x35c0431a, 0x5c93ec85, 0xc6229a6e,
    0x91a5455c, 0x12246a5b, 0x418a4d90, 0xfd6ecdbc,
    0x855f6731, 0xeea8b82f, 0xc408d702, 0x12d37de6,
    0xbad36dbe, 0x265f821e, 0x2643771c, 0x2eaaee32,
    0xdaed9b58, 0x20a70137, 0x29af4613, 0x54cb80eb,
    0xac5e9c36, 0xf4708d5a, 0xc139d828, 0x604b2bb6,
    0xb188a825, 0x6c3b3bbd, 0xd3d7106d, 0x1ef37d9d,
    0xfc1becdf, 0x4a98a9ac, 0xac080fef, 0xe1ba9ee5,
    0x0025a248, 0x7da83ae2, 0xc476f3a2, 0xa4df02a0,
    0x7ec40699, 0xabb61727, 0x7a71dc76, 0x30d9969b,
    0xf2aa88f4, 0x57e37476, 0x48806278, 0x91f224eb,
    0x2865417a, 0x87cefef8, 0x2d373407, 0xd6ab05a4,
    0x4fc32de6, 0xbeef8739, 0xd88310b2, 0xa220afbf,
    0x66b0f668, 0xb2a2719d, 0xc0fe9c5e, 0xbde8b9bd,
    0xa877a290, 0x54355f17, 0xf19fb70a, 0x95c686f6,
    0x37c1f8d9, 0xa504aad7, 0xfe0c661f, 0xab47da0a,
    0x9b7b830f, 0xf60da290, 0xd777f871, 0x39fa0de6,
    0x5a0a8904, 0x25d9406a, 0xd5d63a68, 0x8897c0d8,
    0x0bc7c81b, 0x5c985ba8, 0x32e20e7b, 0xfd916425,
    0x0fd5082a, 0x16407eed, 0xa92f7791, 0x76a875dd,
    0x29c7efb6, 0xfebda3fe, 0x844e232f, 0xe6761ce3,
    0x22253ef3, 0xb5079bfe, 0xd4a04ac0, 0xe76d1f2a,
    0x7ce73530, 0xb247eb66, 0x899c404d, 0xee87825c,
    0x78980343, 0x16346878, 0xb895388d, 0x6ac7c031,
    0x76908e23, 0x103a995f, 0x0add4443, 0x9672bc36,
    0x2eb2b525, 0xebcff9cf, 0x9bcdea28, 0xd3abc08c,
    0x98cb3b8c, 0xfcebb335, 0x2a0c0bc1, 0x53f37e12,
    0x7bba0bd7, 0xbcbb3531, 0x1998d0b1, 0xd2a9e818,
    0xd39ee1ee, 0xb19276b7, 0x529cf200, 0x228ad4a9,
    0xf6ae580b, 0x4217eceb, 0x8bc0257c, 0xd9ff3e73,
    0x372a88c3, 0xb94cc100, 0xcc5b18bb, 0x15e613a7,
    0x7862041e, 0xb2a2f6ed, 0xcc0b9dec, 0x1011c965,
    0x8efd57b9, 0xca18dafd, 0xc1b66321, 0x3b9d7b37,
    0xe9b3c769, 0x49c8fb85, 0xa1fe1f2b, 0xf7b351b4,
    0xef655e43, 0x5dc14b65, 0x376b283b, 0x7b43e360,
    0xd34e1464, 0x4d864c45, 0xd9281dd0, 0xfb01cebc,
    0x44aa42e5, 0xf085000a, 0xca56b3d1, 0xd6dc961e,
    0xa215886f, 0x46cafa03, 0x0c7bafc8, 0xb39177fa,
    0xba084749, 0x58dfcb08, 0x6f7f0c91, 0xa5ba86f8,
    0x61e82a0c, 0xb7365259, 0x9f05977e, 0xa825ccca,
    0x8bb72d1f, 0x9ef507ac, 0xcf3efdd6, 0x66b9f77d,
    0x337ec357, 0x69bd52ea, 0xb6915240, 0x1738280e,
    0xb0c1a8ee, 0x544f1b72, 0x610212dd, 0x78672dea,
    0xc9900261, 0xd58deda2, 0xaa95f866, 0x027a6ad2,
    0xd9608a3a, 0xc8f56bd9, 0x5c190a07, 0x57856e18,
    0xabb9a3f9, 0xaecfdff7, 0xd73632a3, 0x7c044fc3,
    0x458a4f30, 0x6d254e42, 0xd314e3ac, 0x534df8bc,
    0x05052b27, 0x68ea7326, 0xc9d5fdce, 0x7f73ebe0,
    0x6d0165fd, 0xaee2f3aa, 0x0108c342, 0xb6836226,
    0xf2bf35e0, 0xf6ac4171, 0xf14a5a0f, 0xca50912a,
#else               /* Big endian */
    0xceb778ad, 0x34a085f4, 0x33fe79cb, 0xf40602de,
    0xb7cd24d7, 0xfbc3c1ff, 0x97b0c88e, 0x19761475,
    0x3675747a, 0x5c229f9a, 0xbe51b88d, 0xeb462e33,
    0x11ec1553, 0x019a2ded, 0x17145e78, 0x82e00b71,
    0xc4cfd59b, 0xd8583980, 0x97163765, 0xe2ec3293,
    0x82dafbc1, 0x881f9fa3, 0x2003c7e3, 0x14b53e7b,
    0xdde446c2, 0xcc1285b9, 0xa0907207, 0x73ff2d85,
    0x48daed79, 0xf3da95ad, 0xb4075213, 0x71c159a5,
    0x037242e4, 0xd873a604, 0xbcea53c9, 0x6b2254db,
    0x5220152a, 0x90f986de, 0xc2a15a71, 0xf54720a4,
    0x69714e8f, 0x93d7f82f, 0x0f0c2857, 0x6351cab9,
    0x56a8ffec, 0xe0f67e82, 0xf34c425f, 0x54f6d4dd,
    0xf12a68d7, 0x5a52f589, 0x1d502509, 0xe24fe929,
    0x414bbe19, 0xab1f76bf, 0xbd13308e, 0x0772a9a1,
    0xd4d53214, 0x0ef43786, 0xbebdf859, 0xe09e8ba6,
    0xc660ed67, 0x4b5bee54, 0x189cdf7b, 0xa9613562,
    0x241a88ee, 0x1734e10f, 0xd7c9abec, 0xcdf6b007,
    0x54b52f9d, 0x110883ea, 0x04f2bb60, 0x9e912e53,
    0xe27290d7, 0x87c5e560, 0xec712209, 0xb6b7fa72,
    0x87ad004e, 0x7c739ad4, 0x8f2e4ecb, 0x634997f0,
    0x4a9abcf9, 0xb3132c48, 0xb38015f6, 0x841aaa99,
    0x149b1451, 0xb4baa60c, 0x5bdf34c8, 0xc3085ae5,
    0x97594f5f, 0x4b62fc94, 0x020f095d, 0xa93f3101,
    0xee31134c, 0xee31c547, 0x2ef1555b, 0x49245145,
    0x5f105245, 0x14852331, 0xd4a38130, 0xd4f87124,
    0x78d18bcf, 0x71fc89f2, 0x85c3011d, 0x83d99b3c,
    0x4e583622, 0x93a34fd2, 0xb23a013f, 0x2b200124,
    0x3f4ff044, 0xb831172c, 0x7c433597, 0xd9943252,
    0xb4c37366, 0xfa33f3c5, 0x6d29747e, 0x8bf7772b,
    0x3d53d58a, 0xa723a3d2, 0x0a5c56a7, 0x947e8850,
    0x7e7a3c4c, 0x8a849ee6, 0xe1ab0afc, 0x860be11e,
    0x6a3d545a, 0x9aeca70e, 0x8ea262ec, 0xc8198e9a,
    0xc4df93d6, 0x98227e61, 0x1ed81293, 0x117a3716,
    0x2fe1fe99, 0xb55b1bd6, 0xc272bae4, 0x516bef88,
    0x00a7f892, 0x1f2be7f7, 0x755e4036, 0x1f25a177,
    0x6111effd, 0xd3846cc9, 0x23837139, 0x18e0ce8b,
    0x5c41dd39, 0x03595695, 0x3f89985f, 0xe1f6a1f2,
    0x7b8b1e30, 0xa584f5c3, 0xb9df40a6, 0x0b65ec9b,
    0x316abd55, 0x32803471, 0x49a64adc, 0x67f2c3ea,
    0xe486a98e, 0xc69f5b41, 0x45a15254, 0x35a57ecb,
    0x533dc579, 0xedf3f215, 0xe9bab11e, 0x5d7355c9,
    0xb6252906, 0x74f0dc6c, 0x93ad8347, 0x2b3aa82a,
    0xa5fc3ed1, 0x5c8da8b1, 0xde5735c1, 0xb5de3672,
    0x6807719b, 0x87c3e52f, 0x59a023a0, 0xd1daa653,
    0xfba92fe9, 0x95b5ec64, 0xf7c60d67, 0x73f28f07,
    0xc3f94dca, 0x89c02c75, 0xf6174116, 0x187e368f,
    0xa6e907ff, 0xcd1750f0, 0x9490fda8, 0xfe577611,
    0x86e03277, 0x4dcf3af5, 0xcd22b166, 0x62f06fe0,
    0x08bf16ce, 0xbbaf39e2, 0xe7ce19ce, 0xe4a1a1b1,
    0x17e36097, 0xac331969, 0x3778f43f, 0x4285a937,
    0x4c3add82, 0xfeb9338d, 0x58373866, 0x884225ba,
    0x2cbc7330, 0x02efc70b, 0xa08089eb, 0x4439d789,
    0xce98194d, 0x3544a8c6, 0xa8e1eadf, 0xd8a4ceb7,
    0xca7d8ae4, 0x33482e6d, 0x211dc60b, 0x72ba0664,
    0x4037fbbc, 0xda774f28, 0x199fdaee, 0x4d581340,
    0xf9de77ae, 0xd1d42eb5, 0x0e8453ea, 0x931c8cc5,
    0xefa4ca57, 0xf61598f4, 0xdf04de39, 0xcd823eee,
    0x5f31fa94, 0xf6f78990, 0x628c148c, 0xb96ea8ae,
    0xa1924dee, 0x7322e253, 0x491a0a32, 0x8c456260,
    0xdd99f883, 0x5dd10c13, 0x9ab85422, 0xdedb7ab4,
    0x69a10fb0, 0x187ae379, 0xd0b3832e, 0x5103a552,
    0x8d5fd488, 0x7e3ce826, 0x5a671de3, 0x07e06ea8,
    0x43f66d9a, 0x04fbc631, 0x423fbb6a, 0x5d956dbd,
    0xc3bc5f8c, 0xcb3c346c, 0x3688e161, 0xd9ba79c2,
    0x50e02aa1, 0x6fb99447, 0xe851a120, 0x93ee7c2b,
    0x677ca2fe, 0xbc542536, 0x32b6f08c, 0x4d694994,
    0x5237ebe9, 0x74b8fb4d, 0xe712ee96, 0x5bab0bcc,
    0x4e451d1d, 0x61a04603, 0xae0767a0, 0xa46ab7bd,
    0xdd5ae145, 0x1cfef32b, 0xacffaafa, 0x9d075bee,
    0xb3f4a349, 0xd2a0f5c3, 0x0f726383, 0x0ba75db3,
    0xd30a6cd0, 0x25b3838a, 0x9d416f0c, 0xf775adb8,
    0x1c21f885, 0x52a59a0e, 0x0aea4edb, 0xf91aa8f3,
    0xbea2d0cd, 0x3d797816, 0x07415af1, 0x7bcfa0d4,
    0xd4f04069, 0xa6490502, 0x3d987263, 0x34f7d3b8,
    0xa7f94f69, 0xdf9ba4ef, 0xf81f8342, 0x7cc2a027,
    0x8d51dfce, 0xf444dbee, 0xde24a7c7, 0x83d5524a,
    0xf580eb43, 0xa662a35c, 0x22d83fb1, 0xa240e5fb,
    0x165c78dc, 0x8a4558cb, 0x2d43cf74, 0x616b7c96,
    0x747c1662, 0x5fd940aa, 0x2105a80c, 0x3396eb1f,
    0xab68b9a0, 0xdbb2a2fb, 0x74bf4cb7, 0xff218a2d,
    0x4f0fa8e3, 0xfea7fe90, 0x8c82d073, 0xfc7cb985,
    0x7b736dae, 0x29de768c, 0x73b1c434, 0x214ec004,
    0x445300c4, 0x84196939, 0xcef09b03, 0x5bce7f69,
    0xb6d20e0d, 0xc68a6bce, 0x6cf5325a, 0x5953c343,
    0xf003385b, 0x63a5976b, 0x8d700b65, 0xd2f075b2,
    0x67794421, 0x7eca9088, 0xaecf4df6, 0xb81c58e6,
    0x63417c5b, 0xba77e98d, 0x54264e82, 0xe71168e3,
    0x5f62c22c, 0xd54a9fad, 0x20eb2f20, 0x3b4185cd,
    0x840d19c9, 0x6a8bd03e, 0x1f4a6d50, 0xd7e8a1a2,
    0xf1010cc7, 0xcfddb8d3, 0x891c14ce, 0xfa319ba1,
    0x4270b3f1, 0xc5b45c7e, 0xc988200a, 0x66337c20,
    0x481a5c70, 0x162a3505, 0x566523f2, 0x2f4e1b06,
    0x2e8abef7, 0xed58bc20, 0x98a2a64e, 0x2e288924,
    0x2caac950, 0x46137900, 0x1263c8ae, 0xcdf2f824,
    0xa6787618, 0x555d0490, 0x7a27c307, 0x98f67fa4,
    0x620fcc29, 0x87f80301, 0x6da91f34, 0x2c4dd586,
    0xd81217f3, 0x7d3ba300, 0xf8b2432c, 0xaf68acf3,
    0x025c7827, 0x6cc81f0b, 0x76981106, 0xcec30737,
    0x694fd8ca, 0x43f65e3a, 0x79b46484, 0x8fb73944,
    0x33d52717, 0xb583a381, 0x5c97921b, 0x34a60650,
    0xb2e0f0b8, 0x15746d4e, 0x5e0f5913, 0xf7d31444,
    0x11f1f1c4, 0x5d6ddcb9, 0x924f54dd, 0xa6e94df1,
    0x5c2626a6, 0xb6e4071e, 0xc6335065, 0xd125a456,
    0x7327103c, 0x87156431, 0x9944be35, 0xadcb7b6e,
    0x861c3d07, 0x6d780cdd, 0x1bab7108, 0x25f15a80,
    0x4216c13e, 0xe854b1db, 0x23d466a8, 0x6de2f126,
    0x4ef62862, 0xde7a2180, 0xedb166f9, 0x5b4d664a,
    0x89a050ce, 0x46081ae7, 0xd235b96b, 0x858883a2,
    0xa99c6ace, 0x869bd014, 0xe042f6ef, 0xe3f44634,
    0x5e12fc8e, 0x57ba186c, 0x0b7fc232, 0x9e9b7d4a,
    0x7086a075, 0x72330fae, 0x09ae5596, 0x12937c01,
    0xbaee3638, 0x589316a4, 0x229d31ba, 0xe46c5b05,
    0xd9d806e7, 0x720e16f4, 0x7306a399, 0x74f1999a,
    0x7c67ab85, 0xecbf76cb, 0xba20bd54, 0xa38cb566,
    0x9e60a6f2, 0xfbe3400e, 0x751d8ef1, 0x967ab63d,
    0x851e56d7, 0x45c3078d, 0x05e64004, 0xf651e5f7,
    0x21dcd938, 0x63cc6ffc, 0xdf954e1b, 0x5677fffe,
    0xebecb604, 0xd6d1eaad, 0x5ed467fd, 0x73d2b1a1,
    0xa7c608c5, 0xdb82d5e5, 0xeeab7f52, 0x447aea4b,
    0xcd631047, 0x820f8cbb, 0x8fd9e8b8, 0xc66c24fc,
    0x267741ca, 0x2934f6b2, 0xb38e40cd, 0x8af8e526,
    0x00f6a157, 0x8c4b1521, 0x6a8177ba, 0x47f4f6e9,
    0xaaca18ec, 0xffbc374c, 0x40e75448, 0x47da7371,
    0x0b1c8fb1, 0x39e7d2d5, 0x1ae5ccb5, 0x1fdea47d,
    0xe8cb7320, 0x7dc8c237, 0x8a056330, 0x187f8a46,
    0x9e412373, 0x86811a8e, 0x142ea949, 0x26ee7df6,
    0x641a9cbc, 0xf1aec7a8, 0x0ea76c55, 0x1e26fcb8,
    0x6c6540eb, 0x7644c8d4, 0x0b3e4338, 0x38207913,
    0x0e0cc2f5, 0x94a90070, 0x1264b352, 0x144d4e9b,
    0x366c91c8, 0x216a3b79, 0x3ae86ee4, 0xdaa91604,
    0x7dacb81f, 0xda22995c, 0xe1e15aaf, 0x39e85ee5,
    0xffc7d1db, 0xea2cb518, 0x11d761ad, 0x0a9f7620,
    0xabb4d219, 0x2b27d61d, 0x6578b397, 0x5dc4569d,
    0x3b18e6db, 0xa659f76b, 0xe3d36b83, 0x3c081004,
    0xc15575c2, 0x7abdf627, 0xdb2d5bd7, 0x814cee41,
    0xbbcc98a1, 0x8e9a39ff, 0x6be3878b, 0x1a6f8e78,
    0x2cd90e6a, 0xda7ee88b, 0x3b7e3e42, 0x9eea6627,
    0x7173efcd, 0x572ae232, 0x539b078f, 0x7cc801c8,
    0x5f56735d, 0xd0bf23e5, 0xdfb2cd11, 0x2e5fd624,
    0xd2283c8b, 0x1c188305, 0x0b11ba32, 0x7e557d91,
    0x1bd0a793, 0x09da91bc, 0x73e8ff83, 0x2e9fb33b,
    0xe99360e2, 0x6de160e1, 0x6279d65e, 0x9c71f82d,
    0x93f91e2c, 0x2118c490, 0x5c33ce25, 0x98269139,
    0x38f05d8f, 0x4c326f97, 0xb9fb5ade, 0x8fac5374,
    0x75ec7788, 0xb287360a, 0xecda9a01, 0xf7302954,
    0x035e7e01, 0x0d501474, 0x58af2a19, 0x61edc07b,
    0x470d656b, 0x21be8e9c, 0xb40c97e7, 0xf29edb87,
    0xfe26eb09, 0xc24342e6, 0x832506df, 0x123e56b2,
    0xe732250a, 0xb131f6fb, 0x3c6c4e10, 0xa3635e3c,
    0x61e063d4, 0x351deff2, 0xe2644f68, 0xa72d9a83,
    0xa58cd284, 0xae7dece3, 0xa5757aeb, 0x2349c13a,
    0xbff54040, 0x372a0e14, 0xaf17f0bd, 0xa2bacd9e,
    0xd44e5f50, 0xd463f199, 0x8ca74f6f, 0x23b62db5,
    0x3987c41a, 0x18fc860a, 0xb9f20fd0, 0x936f03e2,
    0x8e06ebee, 0xa9797791, 0xe58846cf, 0x454c2652,
    0x49ccbd16, 0x5d1a6c5b, 0x2430b567, 0xa3675b4a,
    0x8341f284, 0xfd6dc00e, 0x51374b6e, 0x94c23c48,
    0xd6dc14fa, 0xf14f234e, 0x868fed0f, 0xda7192f5,
    0xf2569c52, 0xc3eaebbb, 0x6ef1770f, 0xfb89ca0d,
    0xeb4effc6, 0x6c89095e, 0x369e1d45, 0xb9c14df9,
    0x5f03dac7, 0xe5e3a3e5, 0xc046837b, 0x38cb238e,
    0xba246b4c, 0x22c4be6b, 0xb533ebfe, 0x5f42b209,
    0xc7393b41, 0xa03691ad, 0x0df6e792, 0xf40d3a1f,
    0x8e77d208, 0x6ade6730, 0xcb4b8d09, 0x9d5f6210,
    0x10acab64, 0x430683b2, 0x9d96e994, 0x0d4ddd4f,
    0xe5f51ca8, 0x777ca442, 0x691e3c8f, 0xbc6061e4,
    0x539b39ee, 0x0e080c6a, 0xed779d76, 0x9acf9cbc,
    0x447200ef, 0x062f8b6f, 0x66164d45, 0x1f36ebad,
    0x162a38a1, 0x2e1a18d0, 0x9fba727a, 0x0a16afa1,
    0x48abb762, 0x86857489, 0x1263be30, 0x8f467f51,
    0x4b8d66f2, 0xd73acb53, 0xb2c91fca, 0x2c3552ab,
    0xdb7b7cf3, 0x007d729d, 0xd51ef6e5, 0x1b36425f,
    0x02454387, 0x2e10e341, 0x6430e02e, 0x6effb2d2,
    0x010e8a71, 0xd2326a0d, 0x2a3c7523, 0x3e21ce17,
    0x7328ec67, 0x9035042f, 0x7ff4e39c, 0x07f8bd94,
    0x2e4ac3e7, 0x25956aac, 0x6c0e6ac9, 0xbf1e57b9,
    0x6955d7c3, 0x9d463dbb, 0x30835647, 0xb1971d0f,
    0xdd96e0e6, 0x0b5635b2, 0x1222aa02, 0xe58e2f3c,
    0x67d85d60, 0x13167604, 0x0518c5bf, 0x87f86f0d,
    0xfb5714f3, 0xaa77a253, 0x8630d594, 0xe3b773b9,
    0xaa4b8482, 0x34899ab4, 0xf23186e3, 0x13fdea57,
    0x8e291fae, 0xe45a1f59, 0x54275c4d, 0xadf95520,
    0x531d6dda, 0x5a242854, 0x32f43d13, 0xd38de199,
    0x22ed66f5, 0xf2e35969, 0xa5423f39, 0x30247cf7,
    0x85ceb82c, 0xbcd5c755, 0x2190b79e, 0x50d66880,
    0x06b4bfd8, 0x73e7a743, 0xb984a5dc, 0x466d1697,
    0x1345e9be, 0x5b2e93bb, 0x2b56cbd5, 0xe63775bf,
    0xc95e0311, 0xe8d566ec, 0xb5490cc1, 0x38a19c85,
    0xe525d962, 0x61d39452, 0xa65790c1, 0x63bc2dab,
    0x4d43e564, 0xe8a26463, 0x65e52a36, 0x35ed2435,
    0x7ed9272b, 0x266b30d9, 0xaef4cfbc, 0xe55c8766,
    0x9d11901d, 0x65af357a, 0xcf55847d, 0x3ae4378d,
    0x95afc39d, 0x1591c1a3, 0x3525d1ea, 0x07752df1,
    0xd28e17dd, 0xfe3bc7de, 0xe6a2fb85, 0x8b8c5639,
    0x49a4c18f, 0x71d4f12c, 0x78ceae9b, 0x528e6bf3,
    0x0017ca6e, 0xf81ef558, 0x997aab33, 0x2572bf9f,
    0x76729c25, 0x87590b15, 0x0d8ca975, 0x4524b5b2,
    0xc03342c5, 0x7454bb7d, 0xaea2ef37, 0xf1e88f63,
    0x9c500cb3, 0xdf5c3c04, 0xa442d044, 0x06ca33ec,
    0x04bc6d40, 0x7f8f3180, 0x2a00264b, 0xa323d54d,
    0x6268c10d, 0xe30d792b, 0x46dee042, 0x19392f07,
    0x7f7e5103, 0x48aac702, 0x94ee6730, 0xb3fbfe5f,
    0x70ef1776, 0x83ad632b, 0x2f902654, 0x87b1783d,
    0x3f0d46e3, 0xbc53541d, 0xaa37bc7c, 0x3fd39df4,
    0x7236c88e, 0x80c88497, 0x7853098e, 0xb08b9977,
    0xadfc1c74, 0x647a7097, 0x5c3d2adf, 0x53da6001,
    0xbbe84f13, 0xa6522cff, 0x2e8e38b0, 0x6a98f48b,
    0x7e777c53, 0xd490e692, 0xe99e64d8, 0x60e23495,
    0xbdf12bbb, 0x70f87c0d, 0x518c83e5, 0x18bd6a82,
    0xe1906b56, 0x1b539527, 0xb0b44392, 0x1ebcf326,
    0xb43e544d, 0x5ac053b1, 0x8380b609, 0xaec607f0,
    0x5ecda167, 0x13b556fc, 0x6953360d, 0x2c5c3b6d,
    0x6aece5ad, 0xcf5f0480, 0x696da64d, 0x5b4d8906,
    0x94cbd10e, 0xf17c6bb0, 0x57eed062, 0x4222599d,
    0x5c8e6762, 0x9edcd555, 0xa9d9fe41, 0xe2d9ee01,
    0xafe1e080, 0xd8d1c24c, 0xf9b431fe, 0x2854fbab,
    0xd7aa01a4, 0xc199b14d, 0x71a7d0ec, 0x966a7a61,
    0x85b867d7, 0x8e6e2b03, 0x8e632e94, 0xdbd5dd2c,
    0x40f7eeb4, 0x171efa05, 0xdc7ac8d0, 0xeaa81a92,
    0x56c2e26c, 0x084bc522, 0xf7075b81, 0x7031f1c9,
    0xdc831772, 0x92435b11, 0x5bd7af8e, 0xa3cda191,
    0x02b1bd0d, 0xc6c9d6cc, 0x3c40c970, 0x12d89fa6,
    0xa2876131, 0x588b3043, 0xa363b549, 0xaf9d86c8,
    0xbe0e6de6, 0x7d8b167a, 0xe5a319b4, 0xa5ca4476,
    0xca47586d, 0x4d9707fb, 0x62f6dba7, 0x8a2ac5e5,
    0xab766f52, 0xc2c506f5, 0x055c65f5, 0x7fffa6b6,
    0xe9737e3c, 0x9fd8e379, 0x072b8200, 0x7528f9f5,
    0xa7dd1041, 0x364c5fcf, 0x8045ac60, 0x21544bcf,
    0x0f8de818, 0xb404098a, 0x458a4e75, 0x0aefea41,
    0x330eb5f4, 0x0d48f815, 0x1c6b00ba, 0x04c89e5d,
    0x2dff6d37, 0xcf4c43a5, 0xb38f52f7, 0x032e93d5,
    0xe3dd5c0c, 0xc847ab16, 0x1757761e, 0xdac27fba,
    0x53f11b72, 0x81dd53ef, 0x44ee795d, 0x22b461e2,
    0x78dd9003, 0xe677aab4, 0xee8dbcf3, 0x60b9a661,
    0xff05605b, 0xe8cac32d, 0x9080eaff, 0xaec53ba2,
    0x8c75d3cb, 0x159cc982, 0xbd0e2fb5, 0xa9cd69e9,
    0xd38a2656, 0x61da7036, 0x3fde6c7b, 0x0445daa6,
    0xc8ccacbc, 0x703af27a, 0x94ab8d72, 0xf910f185,
    0x6af8e94e, 0x8c7e5f47, 0xc83b6dd3, 0xb21d583b,
    0x87a86c37, 0x0bd90ec5, 0xe91ff7c0, 0x8fe9dea4,
    0x08888257, 0x114338b1, 0x22abbf53, 0x6aa3aab1,
    0xec0a0f27, 0x757e103d, 0x11a567b1, 0x780064df,
    0xe7983bf6, 0x93686ccc, 0xc2679636, 0x52d9cfa9,
    0xe737b916, 0x7bb3ad04, 0x6fec74d6, 0x0daac5ad,
    0xffa04bf0, 0xe900d388, 0x968103b3, 0xc360305c,
    0x04238945, 0x74b22c67, 0xaa992197, 0x18bba9e6,
    0xfab29ab7, 0x413e2237, 0xffa482fc, 0xebcc0adc,
    0xbed109a8, 0xc00e11d6, 0xa81bf0b6, 0xf69c828d,
    0x4d84495e, 0xa57500ca, 0xb8a4d535, 0x117e6cc0,
    0xb3c988e6, 0xeb49cf0a, 0xf0f8a542, 0x79044e70,
    0x87fcc64d, 0xb2d4c42a, 0x3e21a55d, 0x908d7938,
    0x66dc48eb, 0x30585249, 0xdc350f1a, 0x89ce87b8,
    0x20b32d6a, 0xbb90e2b5, 0xebf05e94, 0xda7792b1,
    0xc8cae451, 0x5fc0613c, 0x031a3a2c, 0xbc425695,
    0xb4188c96, 0x9b6e7d68, 0x5a3cc38f, 0x1b4a4678,
    0x58ee3c3b, 0x46690d00, 0x20abcba2, 0x6da30471,
    0x9ee49950, 0x23224af1, 0x91523258, 0xc250fcf1,
    0xb14d59ea, 0xeb2d5242, 0xf574f9a4, 0xc0547ad6,
    0x0a454667, 0xfacf5005, 0xaeddcd31, 0x73e21e18,
    0xb38a6eb2, 0x123f3b77, 0xdd9bec03, 0xe3f6ed08,
    0x77368b6a, 0x371ff483, 0x859f56ac, 0x875fd532,
    0x9e6abed3, 0x9375c27c, 0x5f18461b, 0x745ff35b,
    0xad4147db, 0x6ae0a751, 0xc0547c7b, 0x2b317763,
    0x50d62d2c, 0x1f21adc7, 0x7c528258, 0x48ef950f,
    0x0eafe402, 0x1230f5d9, 0xb23fb9ab, 0xbdd35eee,
    0x6d50f166, 0xb86691cf, 0xcb54bd47, 0x546a9b57,
    0xd2047ac0, 0xeb098caf, 0xbc1110b4, 0xede05822,
    0x96f3ab61, 0x5eab9cad, 0xa2182c0a, 0xf02e4109,
    0xd8d27aa3, 0x3c8661f8, 0xd5516a3e, 0x4f4bf341,
    0x6b3a02bf, 0xf6c763f4, 0x84b68886, 0x3772c30f,
    0x465d210c, 0xcd9e9a35, 0xb203a4f3, 0xd5b7eead,
    0x5c469058, 0xe79fa642, 0x624b62ac, 0x73b18b8b,
    0x637e65f1, 0xfae5c7c3, 0xdfe34e4d, 0x96e33188,
    0x6d4eec05, 0x6af3e76b, 0x9928b034, 0x8daf6213,
    0xa4bd073c, 0x4c3dab6f, 0xf8954fc4, 0x0171146d,
    0x86ef7f3b, 0xaa05bd8f, 0x971be0f5, 0xe596e2c0,
    0x262083ea, 0xdf0b7092, 0x4d1b5d1a, 0xbaa01eb0,
    0x9a7c6a85, 0x2b9ef1f6, 0x8fcd4868, 0x7c3d57b0,
    0xd9fd51c6, 0x700378ca, 0x2d39eda8, 0xdb6d0222,
    0xfcb3fd5b, 0xace7defd, 0xf564d38b, 0x61843e45,
    0xbd7e68bc, 0xa46636ba, 0x27832e3e, 0x60431294,
    0x0e155ba0, 0xdb3d6475, 0xd6fd8630, 0xa2b7b4a6,
    0x514119b5, 0x866d7f4e, 0x1aa3a8d5, 0x61657a05,
    0x9031c832, 0xc3689199, 0xfeead359, 0x5283246e,
    0x6b91174c, 0xd96602ec, 0xb7c93439, 0x46e5835c,
    0x287fa24b, 0xb5baebf0, 0xa74c7cfa, 0x56793463,
    0x61f2cb31, 0xee4c59b3, 0x14ccdf06, 0x4d7a3a96,
    0x6db295df, 0x8b49a758, 0x3b7dee7a, 0x2f1a5733,
    0xb880dd52, 0x855995e8, 0xa740d1be, 0x2775fef2,
    0x83a8d17e, 0xe1c16ef6, 0x54caba3c, 0x0e8d255a,
    0xb15b2346, 0xa3dbee8b, 0xe281db55, 0x615eceb3,
    0xae6dceef, 0x9ad4819f, 0xd3abcf91, 0x097a5956,
    0x3454bdc9, 0x84100854, 0x58ac91a7, 0x294c9c18,
    0xea2fb3c9, 0x579cbfbb, 0x31d97f65, 0x19076bc9,
    0x81ecf165, 0xe021aabd, 0x32c02f88, 0x67da055b,
    0xd8687857, 0xf3911f5c, 0xf636e109, 0x00add3ac,
    0x2a7032ba, 0xef6a8bbb, 0xdecc9ff2, 0xa5d9cf1b,
    0xf41a5bd1, 0x04105edf, 0x1e8cc80d, 0xa7ad6cd6,
    0xc9deca28, 0x0dfeeaf1, 0xffd991d7, 0x8726d408,
    0x0374163d, 0xe0843e3a, 0xe727e46e, 0x24984eba,
    0xc2f36f57, 0xf049f75a, 0x6c4a98e4, 0x22edf979,
    0xb9e2e9fb, 0x16b15589, 0x8e7b00b8, 0x93dcfd04,
    0x5f386097, 0x171156b3, 0x7691fa5c, 0x4e2c65b9,
    0x4169a1e9, 0x1a43c035, 0x85ec935c, 0x6e9a22c6,
    0x5c45a591, 0x5b6a2412, 0x904d8a41, 0xbccd6efd,
    0x31675f85, 0x2fb8a8ee, 0x02d708c4, 0xe67dd312,
    0xbe6dd3ba, 0x1e825f26, 0x1c774326, 0x32eeaa2e,
    0x589bedda, 0x3701a720, 0x1346af29, 0xeb80cb54,
    0x369c5eac, 0x5a8d70f4, 0x28d839c1, 0xb62b4b60,
    0x25a888b1, 0xbd3b3b6c, 0x6d10d7d3, 0x9d7df31e,
    0xdfec1bfc, 0xaca9984a, 0xef0f08ac, 0xe59ebae1,
    0x48a22500, 0xe23aa87d, 0xa2f376c4, 0xa002dfa4,
    0x9906c47e, 0x2717b6ab, 0x76dc717a, 0x9b96d930,
    0xf488aaf2, 0x7674e357, 0x78628048, 0xeb24f291,
    0x7a416528, 0xf8fece87, 0x0734372d, 0xa405abd6,
    0xe62dc34f, 0x3987efbe, 0xb21083d8, 0xbfaf20a2,
    0x68f6b066, 0x9d71a2b2, 0x5e9cfec0, 0xbdb9e8bd,
    0x90a277a8, 0x175f3554, 0x0ab79ff1, 0xf686c695,
    0xd9f8c137, 0xd7aa04a5, 0x1f660cfe, 0x0ada47ab,
    0x0f837b9b, 0x90a20df6, 0x71f877d7, 0xe60dfa39,
    0x04890a5a, 0x6a40d925, 0x683ad6d5, 0xd8c09788,
    0x1bc8c70b, 0xa85b985c, 0x7b0ee232, 0x256491fd,
    0x2a08d50f, 0xed7e4016, 0x91772fa9, 0xdd75a876,
    0xb6efc729, 0xfea3bdfe, 0x2f234e84, 0xe31c76e6,
    0xf33e2522, 0xfe9b07b5, 0xc04aa0d4, 0x2a1f6de7,
    0x3035e77c, 0x66eb47b2, 0x4d409c89, 0x5c8287ee,
    0x43039878, 0x78683416, 0x8d3895b8, 0x31c0c76a,
    0x238e9076, 0x5f993a10, 0x4344dd0a, 0x36bc7296,
    0x25b5b22e, 0xcff9cfeb, 0x28eacd9b, 0x8cc0abd3,
    0x8c3bcb98, 0x35b3ebfc, 0xc10b0c2a, 0x127ef353,
    0xd70bba7b, 0x3135bbbc, 0xb1d09819, 0x18e8a9d2,
    0xeee19ed3, 0xb77692b1, 0x00f29c52, 0xa9d48a22,
    0x0b58aef6, 0xebec1742, 0x7c25c08b, 0x733effd9,
    0xc3882a37, 0x00c14cb9, 0xbb185bcc, 0xa713e615,
    0x1e046278, 0xedf6a2b2, 0xec9d0bcc, 0x65c91110,
    0xb957fd8e, 0xfdda18ca, 0x2163b6c1, 0x377b9d3b,
    0x69c7b3e9, 0x85fbc849, 0x2b1ffea1, 0xb451b3f7,
    0x435e65ef, 0x654bc15d, 0x3b286b37, 0x60e3437b,
    0x64144ed3, 0x454c864d, 0xd01d28d9, 0xbcce01fb,
    0xe542aa44, 0x0a0085f0, 0xd1b356ca, 0x1e96dcd6,
    0x6f8815a2, 0x03faca46, 0xc8af7b0c, 0xfa7791b3,
    0x494708ba, 0x08cbdf58, 0x910c7f6f, 0xf886baa5,
    0x0c2ae861, 0x595236b7, 0x7e97059f, 0xcacc25a8,
    0x1f2db78b, 0xac07f59e, 0xd6fd3ecf, 0x7df7b966,
    0x57c37e33, 0xea52bd69, 0x405291b6, 0x0e283817,
    0xeea8c1b0, 0x721b4f54, 0xdd120261, 0xea2d6778,
    0x610290c9, 0xa2ed8dd5, 0x66f895aa, 0xd26a7a02,
    0x3a8a60d9, 0xd96bf5c8, 0x070a195c, 0x186e8557,
    0xf9a3b9ab, 0xf7dfcfae, 0xa33236d7, 0xc34f047c,
    0x304f8a45, 0x424e256d, 0xace314d3, 0xbcf84d53,
    0x272b0505, 0x2673ea68, 0xcefdd5c9, 0xe0eb737f,
    0xfd65016d, 0xaaf3e2ae, 0x42c30801, 0x266283b6,
    0xe035bff2, 0x7141acf6, 0x0f5a4af1, 0x2a9150ca,
#endif  /* defined __ARMEB__ */
};

/**********************************************************************************************************************
 Private (static) variables and functions
 *********************************************************************************************************************/
