/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.model.building.ModelCache;

class ReactorModelCache
implements ModelCache {
    private final Map<CacheKey, Object> models = new ConcurrentHashMap<CacheKey, Object>(256);

    ReactorModelCache() {
    }

    @Override
    public Object get(String groupId, String artifactId, String version, String tag) {
        return this.models.get(new CacheKey(groupId, artifactId, version, tag));
    }

    @Override
    public void put(String groupId, String artifactId, String version, String tag, Object data2) {
        this.models.put(new CacheKey(groupId, artifactId, version, tag), data2);
    }

    private static final class CacheKey {
        private final String groupId;
        private final String artifactId;
        private final String version;
        private final String tag;
        private final int hashCode;

        CacheKey(String groupId, String artifactId, String version, String tag) {
            this.groupId = groupId != null ? groupId : "";
            this.artifactId = artifactId != null ? artifactId : "";
            this.version = version != null ? version : "";
            this.tag = tag != null ? tag : "";
            int hash2 = 17;
            hash2 = hash2 * 31 + this.groupId.hashCode();
            hash2 = hash2 * 31 + this.artifactId.hashCode();
            hash2 = hash2 * 31 + this.version.hashCode();
            this.hashCode = hash2 = hash2 * 31 + this.tag.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey that = (CacheKey)obj;
            return this.artifactId.equals(that.artifactId) && this.groupId.equals(that.groupId) && this.version.equals(that.version) && this.tag.equals(that.tag);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

