;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; RUN: foreach %s %t wasm-opt --remove-unused-types --closed-world -all -S -o - | filecheck %s

;; Use described the most, middle next, and describing least.
;; The unused type lets remove-unused-types work and sort the types, so we
;; can test the sort is valid.
(module
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $described (descriptor $middle) (struct))
    (type $described (descriptor $middle) (struct))
    ;; CHECK:       (type $middle (describes $described) (descriptor $describing) (struct))
    (type $middle (describes $described) (descriptor $describing) (struct))
    ;; CHECK:       (type $describing (describes $middle) (struct))
    (type $describing (describes $middle) (struct))

    (type $unused (struct))
  )

  ;; CHECK:       (type $3 (func (param anyref)))

  ;; CHECK:      (func $uses (type $3) (param $x anyref)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (ref.cast (ref $described)
  ;; CHECK-NEXT:    (local.get $x)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (ref.cast (ref $described)
  ;; CHECK-NEXT:    (local.get $x)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (ref.cast (ref $described)
  ;; CHECK-NEXT:    (local.get $x)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (ref.cast (ref $middle)
  ;; CHECK-NEXT:    (local.get $x)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (ref.cast (ref $middle)
  ;; CHECK-NEXT:    (local.get $x)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (ref.cast (ref $describing)
  ;; CHECK-NEXT:    (local.get $x)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $uses (param $x anyref)
    (drop (ref.cast (ref $described) (local.get $x)))
    (drop (ref.cast (ref $described) (local.get $x)))
    (drop (ref.cast (ref $described) (local.get $x)))

    (drop (ref.cast (ref $middle) (local.get $x)))
    (drop (ref.cast (ref $middle) (local.get $x)))

    (drop (ref.cast (ref $describing) (local.get $x)))
  )
)

;; As above, but with use counts flipped.
(module
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $described (descriptor $middle) (struct))
    (type $described (descriptor $middle) (struct))
    ;; CHECK:       (type $middle (describes $described) (descriptor $describing) (struct))
    (type $middle (describes $described) (descriptor $describing) (struct))
    ;; CHECK:       (type $describing (describes $middle) (struct))
    (type $describing (describes $middle) (struct))

    (type $unused (struct))
  )

  ;; CHECK:       (type $3 (func (param anyref)))

  ;; CHECK:      (func $uses (type $3) (param $x anyref)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (ref.cast (ref $described)
  ;; CHECK-NEXT:    (local.get $x)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (ref.cast (ref $middle)
  ;; CHECK-NEXT:    (local.get $x)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (ref.cast (ref $middle)
  ;; CHECK-NEXT:    (local.get $x)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (ref.cast (ref $describing)
  ;; CHECK-NEXT:    (local.get $x)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (ref.cast (ref $describing)
  ;; CHECK-NEXT:    (local.get $x)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (ref.cast (ref $describing)
  ;; CHECK-NEXT:    (local.get $x)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $uses (param $x anyref)
    (drop (ref.cast (ref $described) (local.get $x)))

    (drop (ref.cast (ref $middle) (local.get $x)))
    (drop (ref.cast (ref $middle) (local.get $x)))

    (drop (ref.cast (ref $describing) (local.get $x)))
    (drop (ref.cast (ref $describing) (local.get $x)))
    (drop (ref.cast (ref $describing) (local.get $x)))
  )
)

