import { z } from 'zod';
declare const ReplacementSchema: z.ZodObject<{
    precedence: z.ZodNumber;
    line: z.ZodNumber;
    endLine: z.ZodNumber;
    column: z.ZodNumber;
    endColumn: z.ZodNumber;
    insertionPoint: z.ZodString;
    replacement: z.ZodString;
}, "strip", z.ZodTypeAny, {
    line: number;
    precedence: number;
    endLine: number;
    column: number;
    endColumn: number;
    insertionPoint: string;
    replacement: string;
}, {
    line: number;
    precedence: number;
    endLine: number;
    column: number;
    endColumn: number;
    insertionPoint: string;
    replacement: string;
}>;
declare const LevelSchema: z.ZodEnum<["error", "warning", "info", "style"]>;
export declare const ShellCheckResultSchema: z.ZodObject<{
    comments: z.ZodArray<z.ZodObject<{
        file: z.ZodString;
        line: z.ZodNumber;
        endLine: z.ZodNumber;
        column: z.ZodNumber;
        endColumn: z.ZodNumber;
        level: z.ZodEnum<["error", "warning", "info", "style"]>;
        code: z.ZodNumber;
        message: z.ZodString;
        fix: z.ZodNullable<z.ZodObject<{
            replacements: z.ZodArray<z.ZodObject<{
                precedence: z.ZodNumber;
                line: z.ZodNumber;
                endLine: z.ZodNumber;
                column: z.ZodNumber;
                endColumn: z.ZodNumber;
                insertionPoint: z.ZodString;
                replacement: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                line: number;
                precedence: number;
                endLine: number;
                column: number;
                endColumn: number;
                insertionPoint: string;
                replacement: string;
            }, {
                line: number;
                precedence: number;
                endLine: number;
                column: number;
                endColumn: number;
                insertionPoint: string;
                replacement: string;
            }>, "many">;
        }, "strip", z.ZodTypeAny, {
            replacements: {
                line: number;
                precedence: number;
                endLine: number;
                column: number;
                endColumn: number;
                insertionPoint: string;
                replacement: string;
            }[];
        }, {
            replacements: {
                line: number;
                precedence: number;
                endLine: number;
                column: number;
                endColumn: number;
                insertionPoint: string;
                replacement: string;
            }[];
        }>>;
    }, "strip", z.ZodTypeAny, {
        message: string;
        file: string;
        line: number;
        code: number;
        endLine: number;
        column: number;
        endColumn: number;
        level: "error" | "warning" | "style" | "info";
        fix: {
            replacements: {
                line: number;
                precedence: number;
                endLine: number;
                column: number;
                endColumn: number;
                insertionPoint: string;
                replacement: string;
            }[];
        } | null;
    }, {
        message: string;
        file: string;
        line: number;
        code: number;
        endLine: number;
        column: number;
        endColumn: number;
        level: "error" | "warning" | "style" | "info";
        fix: {
            replacements: {
                line: number;
                precedence: number;
                endLine: number;
                column: number;
                endColumn: number;
                insertionPoint: string;
                replacement: string;
            }[];
        } | null;
    }>, "many">;
}, "strip", z.ZodTypeAny, {
    comments: {
        message: string;
        file: string;
        line: number;
        code: number;
        endLine: number;
        column: number;
        endColumn: number;
        level: "error" | "warning" | "style" | "info";
        fix: {
            replacements: {
                line: number;
                precedence: number;
                endLine: number;
                column: number;
                endColumn: number;
                insertionPoint: string;
                replacement: string;
            }[];
        } | null;
    }[];
}, {
    comments: {
        message: string;
        file: string;
        line: number;
        code: number;
        endLine: number;
        column: number;
        endColumn: number;
        level: "error" | "warning" | "style" | "info";
        fix: {
            replacements: {
                line: number;
                precedence: number;
                endLine: number;
                column: number;
                endColumn: number;
                insertionPoint: string;
                replacement: string;
            }[];
        } | null;
    }[];
}>;
export type ShellCheckResult = z.infer<typeof ShellCheckResultSchema>;
export type ShellCheckComment = ShellCheckResult['comments'][number];
export type ShellCheckCommentLevel = z.infer<typeof LevelSchema>;
export type ShellCheckReplacement = z.infer<typeof ReplacementSchema>;
export {};
