% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_shuffle.R
\name{list_shuffle}
\alias{list_shuffle}
\title{Shuffle a list just like shuffle in PHP}
\usage{
list_shuffle(., seed = NULL)
}
\arguments{
\item{.}{data to shuffle as list}

\item{seed}{apply seed if indicated for reproducibility}
}
\value{
shuffled list of items store to the list name
}
\description{
Shorthand to shuffle a list and save
}
\examples{
list001 <- list("a" = 1:5,
           "b" = letters[1:5],
           c = LETTERS[1:10],
           "2" = number(5,5),
           "e" = randString(5,5))
list001 #show initial list

#illustrate basic functionality
list_shuffle(list001)
list001 #shuffle and resaved to variable

list.f2<-list001
list_shuffle(list.f2)
list.f2 #first output

list.f2<-list001
list_shuffle(list.f2)
list.f2 # different output from first output top

list.f2<-list001
list_shuffle(list.f2,seed = 344L)
list.f2 #second output

list.f2<-list001
list_shuffle(list.f2,seed = 344L)
list.f2 #the same output as second output top

}
