% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duplicate.R
\name{duplicate}
\alias{duplicate}
\title{Duplicate a file with global text replace}
\usage{
duplicate(file, new.name, pattern = NULL, replacement = NULL, open = TRUE)
}
\arguments{
\item{file}{data frame to re-sample}

\item{new.name}{column to uniquely re-sample}

\item{pattern}{number of rows to return}

\item{replacement}{unique numeric value for reproducibility}

\item{open}{description}
}
\value{
data frame containing re-sampled rows from an original data frame
}
\description{
Shorthand to return a re-sample number of rows in a data frame by unique column
}
\examples{
\donttest{
if(interactive()){
# example to duplicate a file, and replace text1 within it
# NOTE that, by default, this function will also open the file within RStudio

#create sample file
file1s <- paste0(tempfile(),".R")
writeLines("message(
'Sample items: eggs, coke, fanta, book'
)", file1s)

file2s <- paste0(tempfile(),".R")
file3s <- paste0(tempfile(),".R")

duplicate(
  file = file1s,
  new.name = file2s,
  pattern = 'text1',
  replacement = 'replacement1'
 )

# duplicate the file, with multiple replacements
# replace 'book' with 'egg' and 'coke' with 'fanta'
duplicate(
  file1s, file2s,
  pattern = c('book','coke'),
  replacement = c('egg','fanta')
)



# duplicate the file with no replacement
duplicate(file1s,file3s) # this simply performs file.copy, and opens the new file



# duplicate the file but do not open for editing
duplicate(file1s,file3s, open = FALSE) # this does not open file after duplication
}
}
}
