% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcadaptRead.R
\name{read.pcadapt}
\alias{read.pcadapt}
\title{File Converter}
\usage{
read.pcadapt(
  input,
  type = c("pcadapt", "lfmm", "vcf", "bed", "ped", "pool", "example"),
  type.out = c("bed", "matrix"),
  allele.sep = c("/", "|"),
  pop.sizes,
  ploidy,
  local.env,
  blocksize
)
}
\arguments{
\item{input}{A genotype matrix or a character string specifying the name of 
the file to be converted. Matrices should use NAs to encode missing values. 
To encode missing values in 'pcadapt' and 'lfmm' files, 9s should be used.}

\item{type}{A character string specifying the type of data to be converted 
from. Converters from 'vcf' and 'ped' formats are not maintained anymore;
if you have any issue with those, please use PLINK >= 1.9 to convert them
to the 'bed' format.}

\item{type.out}{Either a bed file or a standard R matrix. 
If the input is a matrix, then the output is automatically a matrix 
(so that you don't need to specify this parameter). 
If the input is a bed file, then the output is also a bed file.}

\item{allele.sep}{a vector of characters indicating what delimiters are used 
in VCF files. By default, only "|" and "/" are recognized. 
So, this argument is only useful for \code{type = "vcf"}.}

\item{pop.sizes}{deprecated argument.}

\item{ploidy}{deprecated argument.}

\item{local.env}{deprecated argument.}

\item{blocksize}{deprecated argument.}
}
\description{
\code{read.pcadapt} converts genotype matrices or files to an appropriate
  format readable by \code{pcadapt}. For a file as input, you can choose to
  return either a matrix or convert it in bed/bim/fam files. 
  For a matrix as input, this returns a matrix.
}
