% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-.R, R/geom-.R, R/annotation-custom.R,
%   R/annotation-logticks.R, R/geom-polygon.R, R/geom-map.R, R/annotation-map.R,
%   R/geom-raster.R, R/annotation-raster.R, R/axis-secondary.R, R/coord-.R,
%   R/coord-cartesian-.R, R/coord-fixed.R, R/coord-flip.R, R/coord-map.R,
%   R/coord-polar.R, R/coord-quickmap.R, R/coord-radial.R, R/coord-transform.R,
%   R/facet-.R, R/facet-grid-.R, R/facet-null.R, R/facet-wrap.R, R/stat-.R,
%   R/geom-abline.R, R/geom-rect.R, R/geom-bar.R, R/geom-blank.R,
%   R/geom-boxplot.R, R/geom-col.R, R/geom-path.R, R/geom-contour.R,
%   R/geom-crossbar.R, R/geom-segment.R, R/geom-curve.R, R/geom-ribbon.R,
%   R/geom-density.R, R/geom-density2d.R, R/geom-dotplot.R, R/geom-errorbar.R,
%   R/geom-errorbarh.R, R/geom-function.R, R/geom-hex.R, R/geom-hline.R,
%   R/geom-label.R, R/geom-linerange.R, R/geom-point.R, R/geom-pointrange.R,
%   R/geom-quantile.R, R/geom-rug.R, R/geom-smooth.R, R/geom-spoke.R,
%   R/geom-text.R, R/geom-tile.R, R/geom-violin.R, R/geom-vline.R,
%   R/guide-.R, R/guide-axis.R, R/guide-axis-logticks.R, R/guide-axis-stack.R,
%   R/guide-axis-theta.R, R/guide-legend.R, R/guide-bins.R, R/guide-colorbar.R,
%   R/guide-colorsteps.R, R/guide-custom.R, R/guide-none.R, R/guide-old.R,
%   R/layout.R, R/position-.R, R/position-dodge.R, R/position-dodge2.R,
%   R/position-identity.R, R/position-jitter.R, R/position-jitterdodge.R,
%   R/position-nudge.R, R/position-stack.R, R/scale-.R, R/scale-binned.R,
%   R/scale-continuous.R, R/scale-date.R, R/scale-discrete-.R,
%   R/scale-identity.R, R/stat-align.R, R/stat-bin.R, R/stat-bin2d.R,
%   R/stat-bindot.R, R/stat-binhex.R, R/stat-boxplot.R, R/stat-contour.R,
%   R/stat-count.R, R/stat-density-2d.R, R/stat-density.R, R/stat-ecdf.R,
%   R/stat-ellipse.R, R/stat-function.R, R/stat-identity.R, R/stat-qq-line.R,
%   R/stat-qq.R, R/stat-quantilemethods.R, R/stat-smooth.R, R/stat-sum.R,
%   R/stat-summary-2d.R, R/stat-summary-bin.R, R/stat-summary-hex.R,
%   R/stat-summary.R, R/stat-unique.R, R/stat-ydensity.R
\docType{data}
\name{ggplot2-ggproto}
\alias{ggplot2-ggproto}
\alias{Geom}
\alias{GeomCustomAnn}
\alias{GeomLogticks}
\alias{GeomPolygon}
\alias{GeomMap}
\alias{GeomAnnotationMap}
\alias{GeomRaster}
\alias{GeomRasterAnn}
\alias{AxisSecondary}
\alias{Coord}
\alias{CoordCartesian}
\alias{CoordFixed}
\alias{CoordFlip}
\alias{CoordMap}
\alias{CoordPolar}
\alias{CoordQuickmap}
\alias{CoordRadial}
\alias{CoordTrans}
\alias{Facet}
\alias{FacetGrid}
\alias{FacetNull}
\alias{FacetWrap}
\alias{Stat}
\alias{GeomAbline}
\alias{GeomRect}
\alias{GeomBar}
\alias{GeomBlank}
\alias{GeomBoxplot}
\alias{GeomCol}
\alias{GeomPath}
\alias{GeomLine}
\alias{GeomStep}
\alias{GeomContour}
\alias{GeomContourFilled}
\alias{GeomCrossbar}
\alias{GeomSegment}
\alias{GeomCurve}
\alias{GeomRibbon}
\alias{GeomArea}
\alias{GeomDensity}
\alias{GeomDensity2d}
\alias{GeomDensity2dFilled}
\alias{GeomDotplot}
\alias{GeomErrorbar}
\alias{GeomErrorbarh}
\alias{GeomFunction}
\alias{GeomHex}
\alias{GeomHline}
\alias{GeomLabel}
\alias{GeomLinerange}
\alias{GeomPoint}
\alias{GeomPointrange}
\alias{GeomQuantile}
\alias{GeomRug}
\alias{GeomSmooth}
\alias{GeomSpoke}
\alias{GeomText}
\alias{GeomTile}
\alias{GeomViolin}
\alias{GeomVline}
\alias{Guide}
\alias{GuideAxis}
\alias{GuideAxisLogticks}
\alias{GuideAxisStack}
\alias{GuideAxisTheta}
\alias{GuideLegend}
\alias{GuideBins}
\alias{GuideColourbar}
\alias{GuideColoursteps}
\alias{GuideCustom}
\alias{GuideNone}
\alias{GuideOld}
\alias{Layout}
\alias{Position}
\alias{PositionDodge}
\alias{PositionDodge2}
\alias{PositionIdentity}
\alias{PositionJitter}
\alias{PositionJitterdodge}
\alias{PositionNudge}
\alias{PositionStack}
\alias{PositionFill}
\alias{Scale}
\alias{ScaleContinuous}
\alias{ScaleDiscrete}
\alias{ScaleBinned}
\alias{ScaleBinnedPosition}
\alias{ScaleContinuousPosition}
\alias{ScaleContinuousDatetime}
\alias{ScaleContinuousDate}
\alias{ScaleDiscretePosition}
\alias{ScaleDiscreteIdentity}
\alias{ScaleContinuousIdentity}
\alias{StatAlign}
\alias{StatBin}
\alias{StatBin2d}
\alias{StatBindot}
\alias{StatBinhex}
\alias{StatBoxplot}
\alias{StatContour}
\alias{StatContourFilled}
\alias{StatCount}
\alias{StatDensity2d}
\alias{StatDensity2dFilled}
\alias{StatDensity}
\alias{StatEcdf}
\alias{StatEllipse}
\alias{StatFunction}
\alias{StatIdentity}
\alias{StatQqLine}
\alias{StatQq}
\alias{StatQuantile}
\alias{StatSmooth}
\alias{StatSum}
\alias{StatSummary2d}
\alias{StatSummaryBin}
\alias{StatSummaryHex}
\alias{StatSummary}
\alias{StatUnique}
\alias{StatYdensity}
\title{Base ggproto classes for ggplot2}
\description{
If you are creating a new geom, stat, position, or scale in another package,
you'll need to extend from \code{ggplot2::Geom}, \code{ggplot2::Stat},
\code{ggplot2::Position}, or \code{ggplot2::Scale}.
}
\section{Geoms}{


All \verb{geom_*()} functions (like \code{geom_point()}) return a layer that
contains a \verb{Geom*} object (like \code{GeomPoint}). The \verb{Geom*}
object is responsible for rendering the data in the plot.

Each of the \verb{Geom*} objects is a \code{\link[=ggproto]{ggproto()}} object, descended
from the top-level \code{Geom}, and each implements various methods and
fields.

Compared to \code{Stat} and \code{Position}, \code{Geom} is a little
different because the execution of the setup and compute functions is
split up. \code{setup_data} runs before position adjustments, and
\code{draw_layer()} is not run until render time, much later.

To create a new type of Geom object, you typically will want to
override one or more of the following:
\itemize{
\item Either \code{draw_panel(self, data, panel_params, coord)} or
\code{draw_group(self, data, panel_params, coord)}. \code{draw_panel} is
called once per panel, \code{draw_group} is called once per group.

Use \code{draw_panel} if each row in the data represents a
single element. Use \code{draw_group} if each group represents
an element (e.g. a smooth, a violin).

\code{data} is a data frame of scaled aesthetics.

\code{panel_params} is a set of per-panel parameters for the
\code{coord}. Generally, you should consider \code{panel_params}
to be an opaque data structure that you pass along whenever you call
a coord method.

You must always call \code{coord$transform(data, panel_params)} to
get the (position) scaled data for plotting. To work with
non-linear coordinate systems, you typically need to convert into a
primitive geom (e.g. point, path or polygon), and then pass on to the
corresponding draw method for munching.

Must return a grob. Use \code{\link[=zeroGrob]{zeroGrob()}} if there's nothing to
draw.
\item \code{draw_key}: Renders a single legend key.
\item \code{required_aes}: A character vector of aesthetics needed to
render the geom.
\item \code{default_aes}: A list (generated by \code{\link[=aes]{aes()}} of
default values for aesthetics.
\item \code{setup_data}: Converts width and height to xmin and xmax,
and ymin and ymax values. It can potentially set other values as well.
}
}

\section{Coordinate systems}{


All \verb{coord_*()} functions (like \code{coord_trans()}) return a \verb{Coord*}
object (like \code{CoordTrans}).

Each of the \verb{Coord*} objects is a \code{\link[=ggproto]{ggproto()}} object,
descended from the top-level \code{Coord}.  To create a new type of Coord
object, you typically will want to implement one or more of the following:
\itemize{
\item \code{aspect}: Returns the desired aspect ratio for the plot.
\item \code{labels}: Returns a list containing labels for x and y.
\item \code{render_fg}: Renders foreground elements.
\item \code{render_bg}: Renders background elements.
\item \code{render_axis_h}: Renders the horizontal axes.
\item \code{render_axis_v}: Renders the vertical axes.
\item \code{backtransform_range(panel_params)}: Extracts the panel range provided
in \code{panel_params} (created by \code{setup_panel_params()}, see below) and
back-transforms to data coordinates. This back-transformation can be needed
for coords such as \code{coord_trans()} where the range in the transformed
coordinates differs from the range in the untransformed coordinates. Returns
a list of two ranges, \code{x} and \code{y}, and these correspond to the variables
mapped to the \code{x} and \code{y} aesthetics, even for coords such as \code{coord_flip()}
where the \code{x} aesthetic is shown along the y direction and vice versa.
\item \code{range(panel_params)}: Extracts the panel range provided
in \code{panel_params} (created by \code{setup_panel_params()}, see below) and
returns it. Unlike \code{backtransform_range()}, this function does not perform
any back-transformation and instead returns final transformed coordinates. Returns
a list of two ranges, \code{x} and \code{y}, and these correspond to the variables
mapped to the \code{x} and \code{y} aesthetics, even for coords such as \code{coord_flip()}
where the \code{x} aesthetic is shown along the y direction and vice versa.
\item \code{transform}: Transforms x and y coordinates.
\item \code{distance}: Calculates distance.
\item \code{is_linear}: Returns \code{TRUE} if the coordinate system is
linear; \code{FALSE} otherwise.
\item \code{is_free}: Returns \code{TRUE} if the coordinate system supports free
positional scales; \code{FALSE} otherwise.
\item \code{setup_panel_params(scale_x, scale_y, params)}: Determines the appropriate
x and y ranges for each panel, and also calculates anything else needed to
render the panel and axes, such as tick positions and labels for major
and minor ticks. Returns all this information in a named list.
\item \code{setup_data(data, params)}: Allows the coordinate system to
manipulate the plot data. Should return list of data frames.
\item \code{setup_layout(layout, params)}: Allows the coordinate
system to manipulate the \code{layout} data frame which assigns
data to panels and scales.
}
}

\section{Facets}{


All \verb{facet_*} functions returns a \code{Facet} object or an object of a
\code{Facet} subclass. This object describes how to assign data to different
panels, how to apply positional scales and how to lay out the panels, once
rendered.

Extending facets can range from the simple modifications of current facets,
to very laborious rewrites with a lot of \code{\link[=gtable]{gtable()}} manipulation.
For some examples of both, please see the extension vignette.

\code{Facet} subclasses, like other extendible ggproto classes, have a range
of methods that can be modified. Some of these are required for all new
subclasses, while other only need to be modified if need arises.

The required methods are:
\itemize{
\item \code{compute_layout}: Based on layer data compute a mapping between
panels, axes, and potentially other parameters such as faceting variable
level etc. This method must return a data.frame containing at least the
columns \code{PANEL}, \code{SCALE_X}, and \code{SCALE_Y} each containing
integer keys mapping a PANEL to which axes it should use. In addition the
data.frame can contain whatever other information is necessary to assign
observations to the correct panel as well as determining the position of
the panel.
\item \code{map_data}: This method is supplied the data for each layer in
turn and is expected to supply a \code{PANEL} column mapping each row to a
panel defined in the layout. Additionally this method can also add or
subtract data points as needed e.g. in the case of adding margins to
\code{facet_grid()}.
\item \code{draw_panels}: This is where the panels are assembled into a
\code{gtable} object. The method receives, among others, a list of grobs
defining the content of each panel as generated by the Geoms and Coord
objects. The responsibility of the method is to decorate the panels with
axes and strips as needed, as well as position them relative to each other
in a gtable. For some of the automatic functions to work correctly, each
panel, axis, and strip grob name must be prefixed with "panel", "axis", and
"strip" respectively.
}

In addition to the methods described above, it is also possible to override
the default behaviour of one or more of the following methods:
\itemize{
\item \code{setup_params}:
\item \code{init_scales}: Given a master scale for x and y, create panel
specific scales for each panel defined in the layout. The default is to
simply clone the master scale.
\item \code{train_scales}: Based on layer data train each set of panel
scales. The default is to train it on the data related to the panel.
\item \code{finish_data}: Make last-minute modifications to layer data
before it is rendered by the Geoms. The default is to not modify it.
\item \code{draw_back}: Add a grob in between the background defined by the
Coord object (usually the axis grid) and the layer stack. The default is to
return an empty grob for each panel.
\item \code{draw_front}: As above except the returned grob is placed
between the layer stack and the foreground defined by the Coord object
(usually empty). The default is, as above, to return an empty grob.
\item \code{draw_labels}: Given the gtable returned by \code{draw_panels},
add axis titles to the gtable. The default is to add one title at each side
depending on the position and existence of axes.
}

All extension methods receive the content of the params field as the params
argument, so the constructor function will generally put all relevant
information into this field. The only exception is the \code{shrink}
parameter which is used to determine if scales are retrained after Stat
transformations has been applied.
}

\section{Stats}{


All \verb{stat_*()} functions (like \code{stat_bin()}) return a layer that
contains a \verb{Stat*} object (like \code{StatBin}). The \verb{Stat*}
object is responsible for rendering the data in the plot.

Each of the \verb{Stat*} objects is a \code{\link[=ggproto]{ggproto()}} object, descended
from the top-level \code{Stat}, and each implements various methods and
fields. To create a new type of Stat object, you typically will want to
override one or more of the following:
\itemize{
\item One of :
\code{compute_layer(self, data, scales, ...)},
\code{compute_panel(self, data, scales, ...)}, or
\code{compute_group(self, data, scales, ...)}.

\code{compute_layer()} is called once per layer, \code{compute_panel()}
is called once per panel, and \code{compute_group()} is called once per
group. All must return a data frame.

It's usually best to start by overriding \code{compute_group}: if
you find substantial performance optimisations, override higher up.
You'll need to read the source code of the default methods to see
what else you should be doing.

\code{data} is a data frame containing the variables named according
to the aesthetics that they're mapped to. \code{scales} is a list
containing the \code{x} and \code{y} scales. There functions are called
before the facets are trained, so they are global scales, not local
to the individual panels.\code{...} contains the parameters returned by
\code{setup_params()}.
\item \code{finish_layer(data, params)}: called once for each layer. Used
to modify the data after scales has been applied, but before the data is
handed of to the geom for rendering. The default is to not modify the
data. Use this hook if the stat needs access to the actual aesthetic
values rather than the values that are mapped to the aesthetic.
\item \code{setup_params(data, params)}: called once for each layer.
Used to setup defaults that need to complete dataset, and to inform
the user of important choices. Should return list of parameters.
\item \code{setup_data(data, params)}: called once for each layer,
after \code{setup_params()}. Should return modified \code{data}.
Default methods removes all rows containing a missing value in
required aesthetics (with a warning if \code{!na.rm}).
\item \code{required_aes}: A character vector of aesthetics needed to
render the geom.
\item \code{default_aes}: A list (generated by \code{\link[=aes]{aes()}} of
default values for aesthetics.
}
}

\section{Guides}{


The \verb{guide_*()} functions, such as \code{guide_legend()} return an object that
is responsible for displaying how objects in the plotting panel are related
to actual values.

Each of the \verb{Guide*} object is a \code{\link[=ggproto]{ggproto()}} object, descended from the
top-level \code{Guide}, and each implements their own methods for drawing.

To create a new type of Guide object, you typically will want to override
one or more of the following:

Properties:
\itemize{
\item \code{available_aes} A \code{character} vector with aesthetics that this guide
supports. The value \code{"any"} indicates all non-position aesthetics.
\item \code{params} A named \code{list} of parameters that the guide needs to function.
It has the following roles:
\itemize{
\item \code{params} provides the defaults for a guide.
\item \code{names(params)} determines what are valid arguments to \code{new_guide()}.
Some parameters are \emph{required} to render the guide. These are: \code{title},
\code{name}, \code{position}, \code{direction}, \code{order} and \code{hash}.
\item During build stages, \code{params} holds information about the guide.
}
\item \code{elements} A named list of \code{character}s, giving the name of theme elements
that should be retrieved automatically, for example \code{"legend.text"}.
\item \code{hashables} An \code{expression} that can be evaluated in the context of
\code{params}. The hash of the evaluated expression determines the merge
compatibility of guides, and is stored in \code{params$hash}.
}

Methods:
\itemize{
\item \code{extract_key()} Returns a \code{data.frame} with (mapped) breaks and labels
extracted from the scale, which will be stored in \code{params$key}.
\item \code{extract_decor()} Returns a \code{data.frame} containing other structured
information extracted from the scale, which will be stored in
\code{params$decor}. The \code{decor} has a guide-specific  meaning: it is the bar in
\code{guide_colourbar()}, but specifies the \code{axis.line} in \code{guide_axis()}.
\item \code{extract_params()} Updates the \code{params} with other, unstructured
information from the scale. An example of this is inheriting the guide's
title from the \code{scale$name} field.
\item \code{transform()} Updates the \code{params$key} based on the coordinates. This
applies to position guides, as it rescales the aesthetic to the [0, 1]
range.
\item \code{merge()} Combines information from multiple guides with the same
\code{params$hash}. This ensures that e.g. \code{guide_legend()} can display both
\code{shape} and \code{colour} in the same guide.
\item \code{process_layers()} Extract information from layers. This acts mostly
as a filter for which layers to include and these are then (typically)
forwarded to \code{get_layer_key()}.
\item \code{get_layer_key()} This can be used to gather information about how legend
keys should be displayed.
\item \code{setup_params()} Set up parameters at the beginning of drawing stages.
It can be used to overrule user-supplied parameters or perform checks on
the \code{params} property.
\item \code{override_elements()} Take populated theme elements derived from the
\code{elements} property and allows overriding these theme settings.
\item \code{build_title()} Render the guide's title.
\item \code{build_labels()} Render the guide's labels.
\item \code{build_decor()} Render the \code{params$decor}, which is different for every
guide.
\item \code{build_ticks()} Render tick marks.
\item \code{measure_grobs()} Measure dimensions of the graphical objects produced
by the \verb{build_*()} methods to be used in the layout or assembly.
\item \code{arrange_layout()} Set up a layout for how graphical objects produced by
the \verb{build_*()} methods should be arranged.
\item \code{assemble_drawing()} Take the graphical objects produced by the \verb{build_*()}
methods, the measurements from \code{measure_grobs()} and layout from
\code{arrange_layout()} to finalise the guide.
\item \code{add_title} Adds the title to a gtable, taking into account the size
of the title as well as the gtable size.
}
}

\section{Positions}{


All \verb{position_*()} functions (like \code{position_dodge()}) return a
\verb{Position*} object (like \code{PositionDodge}). The \verb{Position*}
object is responsible for adjusting the position of overlapping geoms.

The way that the \verb{position_*} functions work is slightly different from
the \verb{geom_*} and \verb{stat_*} functions, because a \verb{position_*}
function actually "instantiates" the \verb{Position*} object by creating a
descendant, and returns that.

Each of the \verb{Position*} objects is a \code{\link[=ggproto]{ggproto()}} object,
descended from the top-level \code{Position}, and each implements the
following methods:
\itemize{
\item \code{compute_layer(self, data, params, panel)} is called once
per layer. \code{panel} is currently an internal data structure, so
this method should not be overridden.
\item \code{compute_panel(self, data, params, scales)} is called once per
panel and should return a modified data frame.

\code{data} is a data frame containing the variables named according
to the aesthetics that they're mapped to. \code{scales} is a list
containing the \code{x} and \code{y} scales. There functions are called
before the facets are trained, so they are global scales, not local
to the individual panels. \code{params} contains the parameters returned by
\code{setup_params()}.
\item \code{setup_params(data, params)}: called once for each layer.
Used to setup defaults that need to complete dataset, and to inform
the user of important choices. Should return list of parameters.
\item \code{setup_data(data, params)}: called once for each layer,
after \code{setup_params()}. Should return modified \code{data}.
Default checks that required aesthetics are present.
}

And the following fields
\itemize{
\item \code{required_aes}: a character vector giving the aesthetics
that must be present for this position adjustment to work.
}
}

\section{Scales}{


All \verb{scale_*} functions like \code{\link[=scale_x_continuous]{scale_x_continuous()}} return a \verb{Scale*}
object like \code{ScaleContinuous}. Each of the \verb{Scale*} objects is a \code{\link[=ggproto]{ggproto()}}
object, descended from the top-level \code{Scale}.

Properties not documented in \code{\link[=continuous_scale]{continuous_scale()}} or \code{\link[=discrete_scale]{discrete_scale()}}:
\itemize{
\item \code{call} The call to \code{\link[=continuous_scale]{continuous_scale()}} or \code{\link[=discrete_scale]{discrete_scale()}} that constructed
the scale.
\item \code{range} One of \code{continuous_range()} or \code{discrete_range()}.
}

Methods:
\itemize{
\item \code{is_discrete()} Returns \code{TRUE} if the scale is a discrete scale
\item \code{is_empty()} Returns \code{TRUE} if the scale contains no information (i.e.,
it has no information with which to calculate its \code{limits}).
\item \code{clone()} Returns a copy of the scale that can be trained
independently without affecting the original scale.
\item \code{transform()} Transforms a vector of values using \code{self$trans}.
This occurs before the \code{Stat} is calculated.
\item \code{train()} Update the \code{self$range} of observed (transformed) data values with
a vector of (possibly) new values.
\item \code{reset()} Reset the \code{self$range} of observed data values. For discrete
position scales, only the continuous range is reset.
\item \code{map()} Map transformed data values to some output value as
determined by \code{self$rescale()} and \code{self$palette} (except for position scales,
which do not use the default implementation of this method). The output corresponds
to the transformed data value in aesthetic space (e.g., a color, line width, or size).
\item \code{rescale()} Rescale transformed data to the the range 0, 1. This is most useful for
position scales. For continuous scales, \code{rescale()} uses the \code{rescaler} that
was provided to the constructor. \code{rescale()} does not apply \code{self$oob()} to
its input, which means that discrete values outside \code{limits} will be \code{NA}, and
values that are outside \code{range} will have values less than 0 or greater than 1.
This allows guides more control over how out-of-bounds values are displayed.
\item \code{transform_df()}, \code{train_df()}, \code{map_df()} These \verb{_df} variants
accept a data frame, and apply the \code{transform}, \code{train}, and \code{map} methods
(respectively) to the columns whose names are in \code{self$aesthetics}.
\item \code{get_limits()} Calculates the final scale limits in transformed data space
based on the combination of \code{self$limits} and/or the range of observed values
(\code{self$range}).
\item \code{get_breaks()} Calculates the final scale breaks in transformed data space
based on on the combination of \code{self$breaks}, \code{self$trans$breaks()} (for
continuous scales), and \code{limits}. Breaks outside of \code{limits} are assigned
a value of \code{NA} (continuous scales) or dropped (discrete scales).
\item \code{get_labels()} Calculates labels for a given set of (transformed) \code{breaks}
based on the combination of \code{self$labels} and \code{breaks}.
\item \code{get_breaks_minor()} For continuous scales, calculates the final scale minor breaks
in transformed data space based on the rescaled \code{breaks}, the value of \code{self$minor_breaks},
and the value of \code{self$trans$minor_breaks()}. Discrete scales always return \code{NULL}.
\item \code{get_transformation()} Returns the scale's transformation object.
\item \code{make_title()} Hook to modify the title that is calculated during guide construction
(for non-position scales) or when the \code{Layout} calculates the x and y labels
(position scales).
}

These methods are only valid for position (x and y) scales:
\itemize{
\item \code{dimension()} For continuous scales, the dimension is the same concept as the limits.
For discrete scales, \code{dimension()} returns a continuous range, where the limits
would be placed at integer positions. \code{dimension()} optionally expands
this range given an expansion of length 4 (see \code{\link[=expansion]{expansion()}}).
\item \code{break_info()} Returns a \code{list()} with calculated values needed for the \code{Coord}
to transform values in transformed data space. Axis and grid guides also use
these values to draw guides. This is called with
a (usually expanded) continuous range, such as that returned by \code{self$dimension()}
(even for discrete scales). The list has components \code{major_source}
(\code{self$get_breaks()} for continuous scales, or \code{seq_along(self$get_breaks())}
for discrete scales), \code{major} (the rescaled value of \code{major_source}, ignoring
\code{self$rescaler}), \code{minor} (the rescaled value of \code{minor_source}, ignoring
\code{self$rescaler}), \code{range} (the range that was passed in to \code{break_info()}),
\code{labels} (the label values, one for each element in \code{breaks}).
\item \code{axis_order()} One of \code{c("primary", "secondary")} or \code{c("secondary", "primary")}
\item \code{make_sec_title()} Hook to modify the title for the second axis that is calculated
when the \code{Layout} calculates the x and y labels.
}
}

\seealso{
ggproto
}
\keyword{datasets}
\keyword{internal}
