% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queue.R
\name{cpp_queue}
\alias{cpp_queue}
\title{Create queue}
\usage{
cpp_queue(x)
}
\arguments{
\item{x}{An integer, numeric, character, or logical vector.}
}
\value{
Returns a CppQueue object referencing a queue in C++.
}
\description{
Create a queue. Queues are first-in, first-out containers.
}
\details{
The first element added to a queue is the first one to remove.

C++ queue methods implemented in this package are \link{back}, \link{emplace}, \link{empty}, \link{front}, \link{pop}, \link{push}, and \link{size}. The 
package also adds the \link{==} operator and various helper functions (\link{print}, \link{to_r}, \link{type}).

All object-creating methods in this package begin with \code{cpp_} to avoid clashes with functions from other packages, such as \code{utils::stack} and 
\code{base::vector}.
}
\examples{
q <- cpp_queue(1:4)
q
# First element: 1

push(q, 9L)
q
# First element: 1
back(q)
# [1] 9

emplace(q, 10L)
back(q)
# [1] 10

}
