% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/status-bar.R
\name{cli_status}
\alias{cli_status}
\title{Update the status bar (superseded)}
\usage{
cli_status(
  msg,
  msg_done = paste(msg, "... done"),
  msg_failed = paste(msg, "... failed"),
  .keep = FALSE,
  .auto_close = TRUE,
  .envir = parent.frame(),
  .auto_result = c("clear", "done", "failed", "auto")
)
}
\arguments{
\item{msg}{The text to show, a character vector. It will be
collapsed into a single string, and the first line is kept and cut to
\code{\link[=console_width]{console_width()}}. The message is often associated with the start of
a calculation.}

\item{msg_done}{The message to use when the message is cleared, when
the calculation finishes successfully. If \code{.auto_close} is \code{TRUE}
and \code{.auto_result} is \code{"done"}, then this is printed automatically
when the calling function (or \code{.envir}) finishes.}

\item{msg_failed}{The message to use when the message is cleared, when
the calculation finishes unsuccessfully. If \code{.auto_close} is \code{TRUE}
and \code{.auto_result} is \code{"failed"}, then this is printed automatically
when the calling function (or \code{.envir}) finishes.}

\item{.keep}{What to do when this status bar is cleared. If \code{TRUE} then
the content of this status bar is kept, as regular cli output (the
screen is scrolled up if needed). If \code{FALSE}, then this status bar
is deleted.}

\item{.auto_close}{Whether to clear the status bar when the calling
function finishes (or \code{.envir} is removed from the stack, if
specified).}

\item{.envir}{Environment to evaluate the glue expressions in. It is
also used to auto-clear the status bar if \code{.auto_close} is \code{TRUE}.}

\item{.auto_result}{What to do when auto-closing the status bar.}
}
\value{
The id of the new status bar container element, invisibly.
}
\description{
\strong{The \verb{cli_status_*()} functions are superseded by
the \code{\link[=cli_progress_message]{cli_progress_message()}} and \code{\link[=cli_progress_step]{cli_progress_step()}} functions,
because they have a better default behavior.}

The status bar is the last line of the terminal. cli apps can use this
to show status information, progress bars, etc. The status bar is kept
intact by all semantic cli output.
}
\details{
Use \code{\link[=cli_status_clear]{cli_status_clear()}} to clear the status bar.

Often status messages are associated with processes. E.g. the app starts
downloading a large file, so it sets the status bar accordingly. Once the
download is done (or has failed), the app typically updates the status bar
again. cli automates much of this, via the \code{msg_done}, \code{msg_failed}, and
\code{.auto_result} arguments. See examples below.
}
\seealso{
Status bars support \link[=inline-markup]{inline markup}.

The \code{\link[=cli_progress_message]{cli_progress_message()}} and \code{\link[=cli_progress_step]{cli_progress_step()}}
functions, for a superior API.

Other status bar: 
\code{\link{cli_process_start}()},
\code{\link{cli_status_clear}()},
\code{\link{cli_status_update}()}

Other functions supporting inline markup: 
\code{\link{cli_abort}()},
\code{\link{cli_alert}()},
\code{\link{cli_blockquote}()},
\code{\link{cli_bullets_raw}()},
\code{\link{cli_bullets}()},
\code{\link{cli_dl}()},
\code{\link{cli_h1}()},
\code{\link{cli_li}()},
\code{\link{cli_ol}()},
\code{\link{cli_process_start}()},
\code{\link{cli_progress_along}()},
\code{\link{cli_progress_bar}()},
\code{\link{cli_progress_message}()},
\code{\link{cli_progress_output}()},
\code{\link{cli_progress_step}()},
\code{\link{cli_rule}},
\code{\link{cli_status_update}()},
\code{\link{cli_text}()},
\code{\link{cli_ul}()},
\code{\link{format_error}()},
\code{\link{format_inline}()}
}
\concept{functions supporting inline markup}
\concept{status bar}
